FillInBlanks = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
    },
    answers: '',
    currentQuestion: 0,
    awaitingResponse: true,
    minimumInputWidth: 60,
    characterWidth: 12,
    initialize: function (options) {
        this.parent(options);

        this.btnReset = this.container.getElement('.reset');
        this.btnReset.addEvent(this.clickEvent, this.reset.bind(this));
        this.btnReset.set('disabled', true);

        this.btnCheckAnswers = this.container.getElement('.check-answers');
        this.btnCheckAnswers.addEvent(this.clickEvent, this.checkAnswers.bind(this));
        this.btnCheckAnswers.set('disabled', true);

        this.inputs = this.container.getElements('input[type="text"]');
        this.inputs.addEvent('keydown', this.checkComplete);

        this.render();
    },
    checkComplete: function () {
        _this.btnReset.removeProperty('disabled');
        completedInputs = 0;
        _this.inputs.each(function (input) {
            if (input.get('value') != '') {
                completedInputs++;
            }
        });
        if (completedInputs == _this.inputs.length) {
            _this.btnCheckAnswers.removeProperty('disabled');
        }
    },
    createDOM: function () {
        this.questionContainer = this.container.getElement('.assessment-container');
        _this = this;
        this.options.data.each(function (item, index) {
            sentenceParts = item.sentence.split('%%');


            newSentence = ''
            sentenceParts.each(function (part, i) {
                answer = item.answers[i - 1];

                inputWidth = _this.minimumInputWidth;
                if (typeof answer != 'undefined') {

                    answerLength = answer.replace(/[^A-Z]/gi, "").length * _this.characterWidth;

                    if (answerLength > _this.minimumInputWidth) {
                        inputWidth = answerLength;
                    }
                }

                replaceHTML = '<input type="text" style="width:' + inputWidth + 'px" data-answer="' + answer + '"></input><span class="correct-answer correct"></span>'
                newSentence += part.replace('%', replaceHTML);

            })

            question = new Element('div.sentence', {
                html: '<strong>' + parseInt(index + 1) + '. </strong>' + newSentence,
                'tabindex': 0
            }).inject(_this.questionContainer)

        });


        this.parent();

    },
    reset: function () {

        this.inputs.set('value', '');
        this.inputs.removeClass('correct');
        this.inputs.removeClass('incorrect');
        this.btnReset.set('disabled', true);
        this.btnCheckAnswers.set('disabled', true);
        this.container.getElements('.correct-answer').set('html', '');
        this.container.getElement('.result').set('html', '');

    },
    checkAnswers: function () {
        this.btnCheckAnswers.set('disabled', true);
        correctAnswers = 0;
        this.inputs.each(function (input, i) {
            myAnswer = input.get('value');
            myAnswer = myAnswer.trim();
            input.setAttribute('class', '');
            if (myAnswer.toUpperCase() == input.get('data-answer').toUpperCase()) {
                input.addClass('correct');
                correctAnswers++;
            } else {                
                input.addClass('incorrect');
                $$(input).getNext('.correct-answer')[0].set('html', '(' + input.get('data-answer') + ')');
            }
        });

        this.container.getElement('.result').set('html', new Score(this.inputs.length, correctAnswers).getMessage()).show().focus();

    },
    render: function () {
        this.parent();
    }
});