var ua = window.navigator.userAgent;
var webkit = !!ua.match(/WebKit/i);
var isChrome = window.navigator.userAgent.match(/(Chrome)/i) ? true : false;
var isMac = window.navigator.platform.match(/(Mac)/i) ? true : false;

FillInTheBlank = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
        data: [],
        container: null
    },

    answers: [],
    selection: {},
    wordsId: 1,
    sameWordsLength: null,
    wordBank: null,
    answersReady: false,
    inputPlaceholderOnChangeTime: null,
    assets:[
        '../../../fonts/helveticaneueetw02-55rg.eot',
        '../../../fonts/helveticaneueetw02-55rg.woff',
        '../../../fonts/helveticaneueetw02-55rg.ttf',
        '../../../fonts/helveticaneueetw02-75bd.eot',
        '../../../fonts/helveticaneueetw02-75bd.woff',
        '../../../fonts/helveticaneueetw02-75bd.ttf'
    ],

    initialize: function(options) {
        this.parent(options);
        document.widgetType  = 'fillInTheBlank';

        // remove the WEditor DOM on preview mode
        if (!this.isEditMode) {
            var lookForWeditorInterval = setInterval(function (){
                if ($$("div.mdwysiwyg").length) {
                    $$("div.mdwysiwyg").dispose();
                }

                clearTimeout(lookForWeditorInterval);
            }, 500); 
        }
    },

    afterAssetsLoaded: function(){
        var that = this;
        if (this.isEditMode) {
            // Event onselect is not available for div
            $$('#main-content').addEvent('mouseup', function() {
                that.enableCreateBlank();
            });
            // Paste as plain text
            $$('#main-content').addEvent('paste', function(e) {
                // cancel paste
                e.preventDefault();
                // get text representation of clipboard
                var text = e.event.clipboardData.getData("text/plain");

                // insert text manually
                document.execCommand("insertHTML", false, text);

                that.updateContents(false);
            });
            $$('#create-blank > button').addEvent('click', function() {
                that.createBlank();
            });
            $$('#main-content div.remove-word').addEvent('click', function(e) {
                that.removeWord(e);
            });

            that.initKeyboard();

            // Set the cursor at the beginning of the editable area
            var editble = $$('#main-content')[0];
            if (editble.createTextRange) {
                var part = editble.createTextRange();
                part.move("character", 0);
                part.select();
            }else if (editble.setSelectionRange){
                editble.setSelectionRange(0, 0);}
            editble.focus();
        }else{
            $('create-blank').hide();

            that.inputs = $$('#main-content input[type=text]');
            that.inputs.addEvents({
                keyup: function(e){
                    that.checkInputs();
                }
            });
        }

        $$('#main-content input[type=text]').addEvent('keydown', function(e){
            that.enlargeInput(e);
        });

        that.loadFromJsonData();
        that.loadWordsFromInputs();
        this.checkAnswersButton = this.container.getElement('.check-answers');
        this.checkAnswersButton.set('disabled', 'disabled');
        this.checkAnswersButton.addEvent('click', function() {
            that.checkAnswers();
        });

        this.resetButton = this.container.getElement('.reset');
        //this.resetButton.set('disabled', 'disabled');
        this.resetButton.addEvent('click', function() {
            that.reset();
        });

        var blankContainerEls = $$('#main-content div.blank-container');

        if (blankContainerEls.length > 0) {
            blankContainerEls.forEach(injectLabels);
        } else {
            // support legacy widgets
            // find .blank-container on legacy widgets
            $$('#main-content div:not([class="remove-word"].[tabindex="0"][contenteditable="false"])')
                .filter(function (el) {
                    return el.querySelector('input') && el.get('style').trim() === '';
                })
                .forEach(injectLabels);
        }

        function injectLabels (div, index) {
            function isAUsedLabel (node) {
                if (node.nodeType === 1) {
                    // is an element node
                    if (node.tagName.toLowerCase() === 'label') {
                        return node.get('data-is-used-label')
                    }
                }
                return false
            }
            
            function isFillinInstructions (node) {
                if (node.nodeType === 1) {
                    // is an element node
                    return node.id.toLowerCase() === 'fillin-instructions';
                }
                return false;
            }
            
            //if prevText.constructor == Text

            // take previous|next text sibling that is not a used label
            var prevNode = div.previousSibling;
            var prevText = prevNode && !isAUsedLabel(prevNode) && !isFillinInstructions(prevNode) && (prevNode.nodeValue || prevNode.innerText);
            if (!prevText || !prevText.trim()) {
                prevNode = div.previousElementSibling;
                prevText = prevNode && !isAUsedLabel(prevNode) && !isFillinInstructions(prevNode) && (prevNode.nodeValue || prevNode.innerText);
            }
            var nextNode = div.nextSibling;
            var nextText = nextNode && !isAUsedLabel(nextNode) && !isFillinInstructions(nextNode) && (nextNode.nodeValue || nextNode.innerText);
            if (!nextText || !nextText.trim()) {
                nextNode = div.nextElementSibling;
                nextText = nextNode && !isAUsedLabel(nextNode) && !isFillinInstructions(nextNode) && (nextNode.nodeValue || nextNode.innerText);
            }
            var oldLabel;
            var text;
            var textPosition;

            if (prevText) {
                oldLabel = prevNode;
                text = prevText;
                textPosition = 'before';
            } else if (nextText) {
                oldLabel = nextNode;
                text = nextText;
                textPosition = 'after';
            }

            $$(div)[0].removeAttribute('tabindex');
            $$(div)[0].removeAttribute('contenteditable');

            if (!oldLabel || !text || !textPosition) {
                return
            }

            var input = div.querySelector('input');
            var id = 'answer-'+ index;
            input.set('id', id);

            // replace label
            var label = new Element('label', {
                'html': text,
                'for': id,
                // lock label
                'data-is-used-label': true
            }).inject(div, textPosition);
            div.parentElement.removeChild(oldLabel);
        }

        $$('label').map(function(label){
            if(!label.get('text')) label.remove()
        })

        var introLine = $$('#intro-line');
        // var paragraphs = introLine
        //   .get('html')[0]
        //   .split('.')
        //   .map(function(paragraph,index, arr){
        //       if(index < arr.length - 1 || paragraph == ' '){
        //         return '<p>'+ paragraph +'.</p>'
        //       }
        //   }).join('');
        introLine.set('html', '<p>' + introLine.get('html')[0] + '</p>');

        $$('.result')[0].removeAttribute('tabindex');

        this.render();

        this.listenResize();

        if(that.inputs && that.inputs.length > 0 && this.sameWordsLength){
            var currentMax = 0;
            that.inputs.forEach( function(theInput) {
                currentMax = Math.max(currentMax, theInput.getWidth() );
            });

            that.inputs.forEach( function(theInput) {
                theInput.setStyle('width',currentMax+'px');
            });
        }

        this.initializeInputsDraggables();

        setTimeout(function () {
            if ($('word-bank')) {
                var wordBankTitle = $$('#word-bank > label');
                $('word-bank').prepend(new Element('h2', {'html': wordBankTitle[0].innerHTML}));
                wordBankTitle[0].remove();
            }

            if (!that.isEditMode && that.sameWordsLength) {
                // calculate the length of the longest term
                var maxLength = 0;
                $$('#main-content input').each(function (el, index) {
                    var inputDataAnswer = el.get('data-answer');
                    if (!inputDataAnswer) return;
                    if (inputDataAnswer.length > maxLength) {
                        maxLength = inputDataAnswer.length;
                    }
                });
                // update all input max-length with the longest term length
                $$('#main-content input').set('maxlength', maxLength);
            }

            if (!that.isEditMode) {
                if (window.innerWidth <= 700) {
                    $$('#word-bank').setStyle('width', '143px');
                    window.fireEvent('resize');
                }
            }
        }, 0)
    },

    listenResize: function(){
        window.addEvent("resize", this.rearrengeLis.bind(this));
    },

    rearrengeLis: function(){
        var top = 38;
        $("word-list").getElements("> li").forEach(function(li){
            var li_size = li.getSize();

            li.setStyles({
                'top': top+'px',
                'cursor': '-webkit-grab'
            }); 
            
            
            li.set('data-top', li.getStyle('top').toInt());
            li.set('data-left', li.getStyle('left').toInt());
            top += li_size.y + 5;
        });
    },

    checkInputs: function(){
        var that = this;
        setTimeout(function() {
            var isFilled = true;
            that.inputs.each(function(elem) {
                if(elem.get('value') == '') {
                    isFilled = false;
                    that.answersReady = false;
                }
            });
            if(isFilled){
                that.answersReady = true;
            }

            that.render();
        }, 750);
    },

    enlargeInput: function(event){
        var count = $(event.target).get('value').length+1;

        if(count >= $(event.target).get('size') && count <= 50) {
            $$('.blank-wrapper-autosize').setStyle('width', 'auto');
            $(event.target).set('size', count);
        } else if(count < $(event.target).get('size') && count > $(event.target).get('data-answer').length) {
            $(event.target).set('size', count);
        }
    },

    loadFromJsonData: function() {
        if(this.options.data){
            this.sameWordsLength = this.options.data.sameWordsLength;
            this.wordBank = this.options.data.wordBank;
        }
        // Sync with server
        var isLoading = true;
        this.sendPostMessages('initial-settings', {'sameWordsLength': this.sameWordsLength, 'wordBank': this.wordBank});
        this.setWordLength(this.sameWordsLength ? 'same-length' : 'actual-length', isLoading);
        this.showWordsBank(this.wordBank, isLoading);
    },

    formatBlankValue: function(text) {
        return text.replace(/\n|\r|&nbsp;/g,' ').trim();
    },

    loadWordsFromInputs: function() {
        var that = this;
        var words = [];
        $$('#main-content').getElements('input')[0].each(function(elem) {
            if(that.isEditMode){
                elem.set('value', elem.get('data-answer'));
            }else{
                elem.removeProperty('readonly');
            }
            words.push({'answer':elem.get('data-answer'), 'id': elem.getNext('.remove-word').get('data-id')});
            if (elem.getNext('.remove-word').get('data-id') > that.wordsId) {
                that.wordsId = elem.getNext('.remove-word').get('data-id');
            }
        });
        that.answers = words;
        var top = 33;
        $('word-list').empty();
        words = that.shuffleWords(words);
        var wordsText = words.map(function(word){ return word.answer}).join(', ');

        if($('fillin-instructions')) $('fillin-instructions').remove();
        if(this.wordBank){

            $('main-content').adopt(new Element('#fillin-instructions.visually-hidden', {
                text: 'Enter a word for this blank. Options: ' + wordsText
            }).setStyle('left', '-99999rem'));
        }

        words.each(function(elem) {
            var li = new Element('li', {'html': elem.answer, 'data-id': elem.id});
            $('word-list').grab(li);
            if(!that.isEditMode){
                new Drag.Move(li, {
                    droppables: '#main-content input[type=text]',
                    onDrag: function( element ){
                        $$('.blank-wrapper').addClass( 'draggable-begin-drag' );
                        that.hidePlaceholderInputs();
                        element.addClass('dragging');
                        that.showInputs();
                    },
                    onDrop: function(element, droppable){
                        element.removeClass('dragging');
                        $$('.blank-wrapper').removeClass( 'draggable-begin-drag' );
                        that.resetPlaceholderInputs();
                        that.hideInputs();
                        if (!droppable){
                            element.setStyles({
                                'top': element.get('data-top')+'px',
                                'left': element.get('data-left')+'px'
                            });
                            return;
                        } else {
                            var elText = that.formatBlankValue(element.get("text"));

                            if(droppable.get('size') < elText.length){
                                droppable.set('size', elText.length);
                            }
                            if( droppable.get('data-current-id') && droppable.get('data-current-id').trim()!="" ) {
                                //console.log( $('word-list').getElement('[data-id="'+ droppable.get('data-current-id').trim() +'"]') );
                                var lastOne = $('word-list').getElement('[data-id="'+ droppable.get('data-current-id').trim() +'"]');
                                lastOne.show();
                                lastOne.setStyles({
                                    'top': lastOne.get('data-top')+'px',
                                    'left': lastOne.get('data-left')+'px'
                                });
                            }
                            droppable.set('value', elText);
                            droppable.set('data-current-id', element.get('data-id'));
                            droppable.setStyle('background-color', '#FFFFFF');
                            var $dragPlaceholder = droppable.getPrevious('.input-drag-placeholder') || droppable.getNext('.input-drag-placeholder');
                            
                            $dragPlaceholder.set('html', element.get('html'));

                            //element.destroy();
                            element.hide();
                            that.checkInputs();

                            // display draggable placeholder
                            $$(droppable.parentElement).addClass('draggable');

                            var inputSize = droppable.getSize();
                            $dragPlaceholder.setStyle('width', inputSize.x);
                        }
                    },
                    onEnter: function(element, droppable){
                        droppable.setStyle('background-color', '#CEEDF9');
                    },
                    onLeave: function(element, droppable){
                        droppable.setStyle('background-color', '#FFFFFF');
                    }
                });
                li.setStyles({
                    'top': top+'px',
                    'cursor': '-webkit-grab'
                }); 
                var li_size = li.getSize();
                
                li.set('data-top', li.getStyle('top').toInt());
                li.set('data-left', li.getStyle('left').toInt());
                top += li_size.y + 5;
            }
        });
    },

    enableCreateBlank: function() {
        this.selection = "";

        if (document.getSelection) {
            this.selection = document.getSelection();
        } else if (document.selection) {
            this.selection = document.selection.createRange();
        }
        if (this.selection == "") {
            $('create-blank').getElement('button').disabled = true;
        } else {
            $('create-blank').getElement('button').disabled = false;
        }
    },

    createBlank: function() {
        var that = this;
        var txt = this.selection.toString() || this.selection.text;
        var range;
        var el = new Element('div.blank-container', {'contenteditable': 'false'});
        var input = new Element('input' ,{
            'type':'text',
            'data-answer': txt,
            'class': 'processed',
            'size':that.sameWordsLength ? 17 : txt.length+1,
            'maxlength': 50, 'value': txt,
            'readonly': 'readonly',
            'id': 'answer-' + that.wordsId
        });
        input.addEvent('keydown', function(e){
            that.enlargeInput(e);
        });
        el.grab(input);
        el.grab(new Element('div' ,{'html':'&times;', 'class': 'remove-word', 'contenteditable': 'false', 'data-id': that.wordsId}).addEvent('click', function(e){that.removeWord(e)}));

        if (document.getSelection) {
            if (this.selection.getRangeAt && this.selection.rangeCount) {
                range = this.selection.getRangeAt(0);
                
                range.deleteContents()
                range.insertNode(el)
            }    
        }

        el.getElement('input').focus();

        // Add txt to WORD BANK
        var li = new Element('li', {'html': txt, 'data-id': that.wordsId});
        $('word-list').grab(li);

        // Disable Create Blank button
        $('create-blank').getElement('button').disabled = true;

        that.wordsId++;
        that.setContentChangedTimer();
    },

    removeWord: function(e) {
        var id = $$(e.target).get('data-id');
        var target = $$(e.target);
        var txt = target.getParent().getElement('input').get('data-answer');
        var textNode = document.createTextNode(txt);

        if(target.getParent()[0].getParent().get('tag') == 'li'){
            $('main-content').getElement(target.getParent()[0].getParent()).replaceChild(textNode, target.getParent()[0]);
        } else {
            $('main-content').replaceChild(textNode, target.getParent()[0]);
        }

        $('word-list').getElement('li[data-id="'+id+'"]').destroy();
        target.getParent().destroy();
        this.setContentChangedTimer();
    },

    checkAnswers: function() {
        var _this = this;
        this.checkAnswersFlag = true;
        this.showInputs();
        this.hidePlaceholderInputs();
        var correctAnswers = 0;

        this.inputs.each(function (input, i) {
            myAnswer = _this.formatBlankValue(input.get('value'));
            input.set('readonly', 'readonly');
            input.set('size', input.get('value').trim().length);
            input.addClass('hide');
            input.getParent().addClass('check-answers-wrapper');
            input.getNext('.input-drag-placeholder').removeAttribute('contenteditable');
            if (myAnswer.toUpperCase() == _this.formatBlankValue(input.get('data-answer')).toUpperCase()) {
                input.addClass('correct');
                input.getNext('.input-drag-placeholder').addClass('placeholder-correct');
                new Element('span.correct-mark').set('aria-hidden','true').inject(input, 'after');
                // new Element('span.correct-mark-desc').set('text', ' correct mark').inject(input, 'after');
                // new Element('span.correct-mark').set('aria-hidden','true').inject(input, 'after');
                new Element('span.correct').set('html', input.get('value')  + ' <span class="hide-text"> is correct. </span>').inject(input, 'after');
                input.addClass('hide-input');
                correctAnswers++;
            } else {
                input.addClass('incorrect');
                input.getNext('.input-drag-placeholder').addClass('placeholder-incorrect');
                new Element('span.input-answer.correct', {
                    html: '<span class="hide-text"> The correct answer was </span>' + '(' + input.get('data-answer').trim() + ')'
                }).inject(input, 'after');
                new Element('span.incorrect-mark').set('aria-hidden','true').inject(input, 'after');

                // new Element('span.incorrect-mark-desc').set('text', ' incorrect mark icon').inject(input, 'after');
                // new Element('span.incorrect-mark').set('aria-hidden','true').inject(input, 'after');
                new Element('span.incorrect').set('html', input.get('value') + ' <span class="hide-text"> is incorrect. </span>').inject(input, 'after');
            }
        });

        this.showPlaceholders(true);
        this.hideInputsCheck();
        
        var scoreMessage = "You completed the challenge. You have " + correctAnswers + " out of " + this.inputs.length + " correct.";
        this.container.getElement('.result').set('html', scoreMessage).show().set("tabindex", "0");

        setTimeout(function () {
            _this.container.getElement('.result').focus();
        }, 0);

        this.clearTimersOnUserInteraction(function (timers) {
            timers.push(setTimeout(function () {
                // is safari
                if (webkit && isMac) {
                    $("main-content").getElements("ol").each(function (node) {
                        var label = _this.getOrderedListText(node);
                        if (label && label.trim().length > 0) {
                            $$(node).set("aria-label", label);
                        }
                    });
                    $("main-content").getElements("ul").each(function (node) {
                        var label = _this.getUnorderedListText(node);
                        if (label && label.trim().length > 0) {
                            $$(node).set("aria-label", label);
                        }
                    });
                }
                
                if ((isChrome || webkit) && isMac) {
                    $("main-content").set("role", "article");
                }

                $("main-content").set("tabindex", "-1").focus();
            }, 2750));
        });

        this.render();
    },

    getListItemText: function(liEl) {
        var _this = this;
        var str = "";
        liEl.childNodes.forEach(function(node) {
            // check if node is text node
            var isTextNode = parseInt(node.nodeType, 10) === parseInt(Node.TEXT_NODE, 10);
            if (isTextNode) {
                str += " " + node.textContent.replace(/(\r\n|\n|\r)/gm, " ");
                return;
            }

            if (node.childNodes.length > 1) {
                str += _this.getListItemText(node);
                return;
            }

            var hasAriaHidden = $$(node).get("aria-hidden")[0] === "true";
            var isVisible = $$(node).isVisible()[0];
            var isRemoveWordBtn = $$(node).hasClass("remove-word")[0];
            if (hasAriaHidden || !isVisible) {
                return;
            }

            str += " " + node.textContent.replace(/(\r\n|\n|\r)/gm, " ");
        });
        return str;
    },
    getOrderedListText: function(olEl) {
        var _this = this;
        var str = "";
        olEl.getChildren("li").each(function (childNode, index) {
            var prefix = index === 0 ? " " : ", ";
            str += prefix + (index + 1) + ". " + _this.getListItemText(childNode);
        });
        return str;
    },
    getUnorderedListText: function(ulEl) {
        var _this = this;
        // var bullet = "&#8226;";
        var bullet = "•";
        var str = "";
        ulEl.getChildren("li").each(function (childNode, index) {
            var prefix = index === 0 ? " " : ", ";
            str += prefix + bullet + " " + _this.getListItemText(childNode);
        });
        return str;
    },

    reset: function() {
        $("main-content").set("role");
        $("main-content").getElements("ol, ul").set("aria-label");

        for (var i = 0; i < this.inputs.length; i++) {
            this.inputs[i].set('value', '');
            this.inputs[i].removeClass('correct');
            this.inputs[i].removeClass('incorrect');
            this.inputs[i].removeClass('hide-input');
            this.inputs[i].removeProperty('readonly');
            $$('span.input-answer').destroy();
            $$('span.correct').destroy();
            $$('span.correct-mark').destroy();
            $$('span.correct-mark-desc').destroy();
            $$('span.incorrect').destroy();
            $$('span.incorrect-mark').destroy();
            $$('span.incorrect-mark-desc').destroy();
            this.sameWordsLength ? this.inputs[i].set('size', 17) : this.inputs[i].set('size', this.inputs[i].get('data-answer').length+1);
        };
        if( this.inputs.length > 0){
            this.inputs.forEach(function(theInput){
                theInput.set('data-current-id', null);

                // hide dragPlaceholder
                theInput.getParent().removeClass('draggable');
            });
        }
        this.container.getElement('.result').set('html', '');
        this.selection = {};
        this.checkAnswersFlag = false;
        this.answersReady = false;
        this.loadWordsFromInputs();
        this.render();
        this.emptyPlaceholderInputs();
        this.hideInputs();
        this.resetPlaceholderInputs();
        this.showInputs();

        // call responsive-v4.js
        window.calculate_container_size();
    },

    bindEditMode: function() {
        this.isEditMode = true;
        this.saveTimer = null;
        var that = this;

        $$('[data-md-editable="md-content-editable"]').set('contenteditable', 'true');

        $$('[data-md-editable="md-content-editable"]').addEvent('input', function(e) {
            that.addInputKeyupEvent();
            that.setContentChangedTimer();
        });

        this.addInputKeyupEvent();
    },

    addInputKeyupEvent:function(){
        $$('#main-content input[type=text]:not(.processed)').addEvent('keyup', function(e) {
            this.setAttribute('value', this.get('value'));
        }).addEvent('change', function(e) {
            this.setAttribute('value', this.get('value'));
        });

        $$('#main-content input[type=text]:not(.processed)').addClass("processed");
    },

    setContentChangedTimer: function() {
        var that = this;
        clearTimeout(this.saveTimer);
        this.saveTimer = setTimeout(function() {
            that.updateContents();
        }, 750);
    },

    updateContents: function(prevReload) {
        prevReload = prevReload == false ? prevReload : true;
        this.saveRequest({
            method: 'setHTML',
            selector: '#main-content',
            html: $('main-content').get('html')
        }, prevReload);
    },

    postMessageReceived: function(message,path) {
        this.parent(message, path);
        var that = this;
        switch (message.data.method) {
            case "toggleHTML":
                that.saveRequestProcedure(null, {
                    method: "toggleHTML",
                    selector: message.data.wrapper,
                    elementID: message.data.elementID,
                    toggle: "" + message.data.value
                }, null, function() {
                    document.location.reload();
                });
                break;
            case "word-length":
                that.setWordLength(message.data.id);
                break;
            case "show-words-bank":
                that.showWordsBank(message.data.value);
                break;

            default:
                console.warn('fill-in-the-blank Unknown message', message);
        }
    },

    setWordLength: function(option, isLoading) {
        switch (option) {
            case "actual-length":
                this.sameWordsLength = false;
                $$('#main-content').getElements('input')[0].each(function(elem) {
                    elem.set('size', elem.get('data-answer').length+1);
                });
                break;
            case "same-length":
                this.sameWordsLength = true;
                $$('#main-content').getElements('input').each(function(elem) {
                    elem.set('size', 17);
                });
                break;
            default :
                break;
        }
        if (!isLoading){
            this.save();
        }
    },

    showWordsBank: function(value, isLoading) {
        if(value){
            this.wordBank = true;
            $('word-bank').show();
        }else{
            this.wordBank = false;
            $('word-bank').hide();
        }
        if (!isLoading){
            this.save();
        }
    },

    shuffleWords: function(words) {
        var counter = words.length, temp, index;

        // While there are elements in the array
        while (counter > 0) {
            // Pick a random index
            index = Math.floor(Math.random() * counter);

            // Decrease counter by 1
            counter--;

            // And swap the last element with it
            temp = words[counter];
            words[counter] = words[index];
            words[index] = temp;
        }

        return words;
    },

    initKeyboard: function() {
        var that = this;
        document.onkeydown = function(event) {
            var key = window.event ? window.event.keyCode : event.keyCode;
            var selection = document.getSelection();
            switch (key) {
                //backspace and delete
                /*
                case 8:
                    if(selection.anchorOffset == 0){
                        return false;
                    }
                    break;
                case 46:
                    if(selection.anchorOffset == selection.anchorNode.length){
                        return false;
                    }
                    break;
                */
                case 13:
                    // insert 2 br tags (if only one br tag is inserted the cursor won't go to the next line)
                    document.execCommand('insertHTML', false, '<br/><br/>');
                    // prevent the default behaviour of return key pressed
                    return false;
                    break;
                default :
                    break;
            }
        }
    },

    save: function(){
        this.saveRequest({
            method: 'mdData',
            options: {'json': {'sameWordsLength': this.sameWordsLength, 'wordBank': this.wordBank}}
        }, true);
    },

    render: function() {
        //this.resetButton.set('disabled', 'disabled');
        if(this.container.getElement('.result')){
            this.container.getElement('.result').inject(this.container.getElement('.widget-footer'), 'top');
        }
        if (this.checkAnswersFlag) {
            this.checkAnswersButton.set('disabled', 'disabled');
            this.resetButton.removeProperty('disabled');
        }
        else if (this.answersReady) {
            this.checkAnswersButton.removeProperty('disabled');
            this.resetButton.removeProperty('disabled');
        }
        else {
            this.checkAnswersButton.set('disabled', 'disabled');
        }

        if(this.wordBank){
            $$('#main-content input').map(function(input){
                input.set('aria-describedby', 'fillin-instructions');
            });
        }
    },

    initializeInputsDraggables: function() {
        var that = this;
        if(!that.isEditMode && that.inputs){
            var tryToDrag = false,
                autoSizeMode = that.inputs && that.inputs.length > 0 && this.sameWordsLength,
                autoSizeClassName =  autoSizeMode? 
                        'blank-wrapper-not-autosize' : 'blank-wrapper-autosize'
            ;
            that.inputs.forEach(function(theInput, index){
            
                var label = theInput.parentElement.previousElementSibling ? theInput.parentElement.previousElementSibling.textContent: '';
                var elementWidth = theInput.getWidth(),
                    elementHeight = theInput.getHeight(),
                    elementPosition = theInput.getPosition(),
                    elementYPosition = (elementPosition.y - elementHeight + 4),
                    elementXPosition = elementPosition.x,
                    removeWord = theInput.getNext('.remove-word')
                ;
                // theInput.removeAttribute('id')
                // theInput.setAttribute('aria-hidden','true')
                // theInput.setAttribute('tabindex', -1)
                //console.log(elementPosition);
                var dragPlaceholder = new Element('div.input-drag-placeholder',{
                    //style: 'width: '+elementWidth+'px; height: '+(elementHeight + 1)+'px; left: '+ elementXPosition + 'px; top: '+ elementYPosition + 'px;',
                    style: 'width: '+elementWidth+'px; height: '+(elementHeight )+'px; left: 0; top: 0;',
                    'data-initial-y': elementYPosition,
                    'data-initial-x': elementXPosition,
                    readonly: true,
                    // 'contenteditable': 'true',
                    'html': '&nbsp;',
                    // id : 'answer-'+ index,
                    'aria-hidden': true,
                    // 'aria-label': label,
                    'data-calculated-width': elementWidth
                });
                //dragPlaceholder.inject(theInput,"before");

                var blankWrapper = new Element('div.blank-wrapper.'+autoSizeClassName,{
                    style: 'width: '+elementWidth+'px; height: '+(elementHeight)+'px;min-width: '+elementWidth+'px;',
                });
                theInput.setStyle('height', elementHeight + 'px');
                blankWrapper.inject(theInput,"before");
                blankWrapper.adopt(theInput);
                blankWrapper.adopt(dragPlaceholder);
                blankWrapper.adopt(removeWord );

                dragPlaceholder.addEvent('input', function(ev){
                    ev.target.getNext('input').set('value', ev.target.get('text') );
                    if( ev.target.getNext('input').get('data-current-id') && ev.target.getNext('input').get('data-current-id').trim()!="" ) {
                        var element = $('word-list').getElement('[data-id="' + ev.target.getNext('input').get('data-current-id') + '"]');
                        element.setStyles({
                            left: element.get('data-left') + 'px',
                            top: element.get('data-top') + 'px'
                        });
                        element.show();
                        ev.target.getNext('input').set('data-current-id', null);

                    }
                    if( that.inputPlaceholderOnChangeTime ){
                        clearTimeout(that.inputPlaceholderOnChangeTime);
                    }
                    that.inputPlaceholderOnChangeTime = setTimeout( function() {
                        that.checkInputs();
                    }, 750);
                });

                dragPlaceholder.addEvent(that.clickEvent, function (ev) {
                    if (!tryToDrag) {
                        var $input = $$(ev.target).getPrevious('input')[0];
                        var answers = that.answers.map(function (o) {
                            return that.formatBlankValue(o.answer);
                        })
                        
                        $input.setStyle('color', null);
                        
                        if (answers.indexOf($input.get('value')) === -1) {
                            $input.getParent().removeClass('draggable');
                            $input.focus();
                        }

                        tryToDrag = false;
                    }
                });
                
                // TODO: drag dragPlaceholder if wordBank
                new Drag.Move(dragPlaceholder, {
                    droppables: '#main-content input[type=text]',
                    onBeforeStart: function(element, ev){
                        tryToDrag = false;

                        var $input = $$(element).getPrevious('input');
                        var inputPosition = $input.getPosition()[0];
                        var inputSize = $input.getSize()[0];

                        $input.setStyle('color', 'transparent');

                        // remove position relative from wrapper
                        // display dragPlaceholder
                        $input.getParent().addClass('draggable-begin-drag');

                        var widgetHeaderSize = $$('.widget-header')[0].getSize();

                        // initial onDrag dragPlaceholder position
                        element.setStyles({
                            left: inputPosition.x,
                            top: inputPosition.y - widgetHeaderSize.y,
                            width: inputSize.x
                        });
                    },
                    onDrag: function( element, ev ){
                        tryToDrag = true;
                        element.getParent().addClass( 'draggable-begin-drag' );
                        /*
                        if($$('.input-placeholder').length > 0) {
                            $$('.input-placeholder').forEach(function(thePlaceholder) {
                                thePlaceholder.dispose();
                            });
                        }
                        var elementWidth = element.getWidth(),
                            elementHeight = element.getHeight();
                        var placeholder = new Element('div.input-placeholder',{
                            html: element.get('text'),
                            style: 'width: '+elementWidth+'px; height: '+(elementHeight - 4)+'px'
                        });
                        element.addClass('dragging');
                        placeholder.inject(element, "after");
                        */
                        
                        var prevInput = element.getNext('input') || element.getPrevious('input');
                        element.set('data-current-id',prevInput.get('data-current-id'));
                        element.set('html',prevInput.get('value'));
                        that.resetPlaceholderInputs();
                        element.addClass('dragging');
                        $$('.input-drag-placeholder:not(.dragging)').forEach(function(thePlaceholder) {
                            thePlaceholder.addClass('placeholder-hide');
                        });
                        that.showInputs();
                        
                    },
                    onDrop: function(element, droppable){
                        element.removeClass('dragging');
                        element.getParent().removeClass( 'draggable-begin-drag' );
                        element.setStyles({
                            left: '0',
                            top: '0'
                        });

                        that.resetPlaceholderInputs();
                        that.hideInputs();

                        if (!droppable){
                            return;
                        } else {
                            var elText = that.formatBlankValue(element.get("text"));

                            if(droppable.get('size') < elText.length){
                                droppable.set('size', elText.length);
                            }
                            var newCurrentId = element.get('data-current-id');
                            var newValue = elText;
                            if( newValue == "" ) {
                                newValue = '&nbsp;';
                            }
                            if( droppable.get('data-current-id') && droppable.get('data-current-id').trim()!="" ) {
                                var lastCurrentId = droppable.get('data-current-id').trim();
                                var lastValue = droppable.get('value').trim();
                                if( lastValue.trim() == "" ) {
                                    lastValue = '&nbsp;';
                                }
                                element.set('html', lastValue);
                                element.set('data-current-id', lastCurrentId);
                            } else {
                                var droppableValue = droppable.get('value');
                                if( droppableValue.trim() == "" ) {
                                    droppableValue = '&nbsp;';
                                }
                                element.set('html', droppableValue);
                                element.set('data-current-id', null);
                            }
                            droppable.set('value', newValue);
                            droppable.set('data-current-id', newCurrentId);
                            droppable.setStyle('background-color', '#FFFFFF');

                            var $dragPlaceholder = droppable.getPrevious('.input-drag-placeholder') || droppable.getNext('.input-drag-placeholder');
                            var inputSize = droppable.getSize();
                            $dragPlaceholder.set('html', element.get('html'));
                            $dragPlaceholder.setStyles({
                                width: inputSize.x
                            })
                            
                            //element.destroy();
                            that.checkInputs();

                            var prevInput = element.getNext('input') || element.getPrevious('input');
                            prevInput.set('data-current-id',element.get('data-current-id'));
                            prevInput.set('value', that.formatBlankValue(element.get("text")));
                            that.resetPlaceholderInputs();

                            // display draggable placeholder
                            $$(droppable.parentElement).addClass('draggable');
                        }

                        droppable.removeClass('dragging');
                        element.removeClass('dragging');

                        droppable.blur();
                        element.blur();
                    },
                    onEnter: function(element, droppable){
                        droppable.setStyle('background-color', '#CEEDF9');
                        //console.log(element, droppable);
                    },
                    onLeave: function(element, droppable){
                        droppable.setStyle('background-color', '#FFFFFF');
                    },
                    onCancel: function(element, droppable){
                        if($$('.input-placeholder').length > 0) {
                            $$('.input-placeholder').forEach(function(thePlaceholder) {
                                thePlaceholder.dispose();
                            });
                        }
                        element.removeClass('dragging');
                        element.getParent().removeClass('draggable-begin-drag');
                        element.setStyles({
                            left: 0,
                            top: 0
                        })

                        var $input = $$(element).getPrevious('input');
                        $input.setStyle('color', null);
                    },
                    onComplete: function (element, event) {
                        var prevInput = element.getNext('input') || element.getPrevious('input');
                        var answers = that.answers.map(function (o) {
                            return o.answer
                        })

                        prevInput.setStyle('color', null);

                        if (answers.indexOf(prevInput.get('value')) === -1) {
                            // hide dragPlaceholder
                            element.getParent().removeClass('draggable');
                        }
                    }
                });
            });

            that.hideInputs();
            setTimeout(that.inputPlaceholderInitialized.bind(that), 750);
        }
    },

    resetPlaceholderInputs: function() {
        var that = this;
        if(!that.isEditMode && that.inputs){
            $$('.input-drag-placeholder').forEach(function(thePlaceholder) {
                // avoid display editor text popup
                // thePlaceholder.setAttribute('contenteditable', 'true');

                thePlaceholder.removeClass('dragging');
                thePlaceholder.removeClass('placeholder-hide');
                thePlaceholder.removeClass('placeholder-incorrect');
                thePlaceholder.removeClass('placeholder-correct');
                thePlaceholder.getParent().removeClass('check-answers-wrapper');
            });
        }
    },

    emptyPlaceholderInputs: function() {
        var that = this;
        if(!that.isEditMode && that.inputs){
            $$('.input-drag-placeholder').forEach(function(thePlaceholder) {
                thePlaceholder.set('html', '&nbsp;');
                thePlaceholder.setStyle('min-width', null );
            });
        }
    },

    hidePlaceholderInputs: function(){
        var that = this;
        if(!that.isEditMode && that.inputs){
            $$('.input-drag-placeholder').forEach(function(thePlaceholder) {
                thePlaceholder.addClass('placeholder-hide');
            });
        }
    },

    showInputs: function() {
        var that = this;
        if(!that.isEditMode && that.inputs){
            that.inputs.forEach( function(theInput) {
                theInput.removeClass('hide');
                theInput.removeClass('hide-check');
            });
        }
    },

    hideInputs: function() {
        var that = this;
        if(!that.isEditMode && that.inputs){
            that.inputs.forEach( function(theInput) {
                // theInput.addClass('hide');
                // theInput.removeClass('hide-check');
            });
        }
    },

    hideInputsCheck: function() {
        var that = this;
        if(!that.isEditMode && that.inputs){
            that.inputs.forEach( function(theInput) {
                theInput.addClass('hide-check');
            });
        }
    },

    showPlaceholders: function(setMinWidth) {
        var that = this;
        if(!that.isEditMode && that.inputs){
            $$('.input-drag-placeholder').forEach(function(thePlaceholder) {
                thePlaceholder.removeClass('placeholder-hide');
                if(typeof setMinWidth != 'undefined' && setMinWidth) {
                    thePlaceholder.setStyle('min-width', thePlaceholder.get('data-calculated-width') + 'px' );
                }
            });
        }        
    },

    inputPlaceholderInitialized: function() {
        var that = this;
        if(!that.isEditMode && that.inputs){
            $$('.input-drag-placeholder').forEach(function(thePlaceholder) {
                /*
                var inputPosition = thePlaceholder.getPosition();
                var elementHeight = thePlaceholder.getHeight();
                thePlaceholder.set('data-initial-y', (inputPosition.y - elementHeight + 4));
                thePlaceholder.set('data-initial-x', inputPosition.x);
                thePlaceholder.removeClass('processing');
                */
            });
        }  
    }

});