/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
*/
Flashcards = new Class({
    Implements: [Options, Events],

    options: {
        allChapters: false,
        shuffle: true,
    },

    cards: [],
    
    mode: 'flip-normal',
    status: {
        currentCard: 0,
        reviewed: [],
        mastered: 0,
        repeated: [],
        toGo: 0
    },
    first_chapter: 1000,
    last_chapter: -1,
    players: null,
    prefix : "http://mediaplayer-cert.pearsoncmg.com/assets/_embed.true/",
    iframeContainer:null,

    audio_types: [
        'front-speech',
        'front-music',
        'back-speech',
        'back-music'
    ],

    // initialize - widget initialization
    initialize: function(options) {
        this.setOptions(options);
        var audio_elements,
            _this = this;

        this.checkCurrentChapter();

        this.createDOM();
                
        if (typeof this.options.currentChapter == 'undefined' || this.options.currentChapter === null) {
            console.error('Flashcards', 'currentChapter parameter is mandatory.');
            return false;
        }

        this.restart();

        this.options.container.getElement('.current-chapter-cards').set('html', 'Ch. ' + this.options.currentChapter).addEvent('click', function() {
            _this.pauseAudio();
            _this.options.allChapters = false;
            _this.restart();
        });
        if ((this.options.currentChapter > 0) && (this.first_chapter != this.last_chapter)) {
            this.options.container.getElement('.all-chapters-cards').set('html', 'Ch. ' + this.first_chapter + '-' + this.last_chapter).addEvent('click', function() {
                _this.pauseAudio();
                _this.options.allChapters = true;
                _this.restart();
            });
        }
        else {
            this.options.container.getElement('.all-chapters-cards').hide();
        }

        this.options.container.getElements('.restart').addEvent('click', function() {
            _this.pauseAudio();
            _this.restart();
        });
        this.options.container.getElements('.flip').addEvent('click', function() {
            _this.pauseAudio();
            _this.flip();
        });
        this.options.container.getElements('.skip').addEvent('click', function() {
            _this.pauseAudio();
            _this.skip();
        });

        window.getFrameTarget = function(message) {
            var frames = document.getElementsByTagName('iframe'),
            frameId = 0,
            framesLength = frames.length;
        
            for (; frameId < framesLength; frameId++) {
                if (frames[frameId].contentWindow === message.source) {
                    return frames[frameId];
                }
            }
            return null;
        }

        window.sendCommandMessage = function(playerId, command, payload) {
            var params = JSON.stringify({
                "type": "command",
                "method": command,
                "playerId": playerId,
                "payload": payload
            });
            document.getElementById(playerId).contentWindow.postMessage(params, '*');
        }

        this.players = $$('#embedded-players > iframe');
    },

    checkCurrentChapter: function() {
        var found = false;
        if (this.options.cards.length < 1) {
            console.error('Flashcards', 'No cards defined.');
        }
        for (var i = this.options.cards.length - 1; i >= 0; i--) {
            if (this.options.cards[i].chapter == this.options.currentChapter) {
                found = true;
                break;
            }
        };
        if (!found) {
            this.options.currentChapter = this.options.cards[0].chapter;
        }
    },

    createDOM: function() {
        var card, card_data, front, back, audio, audio_wrapper, audio_wrapper_back,
            container = this.options.container.getElement('section.cards');
            
        new Element("div.offscreen.flashcard-live-messages",{
            "aria-live":"assertive"
        }).inject($$('.Flashcards')[0]);

        if (!$('embedded-players')) {
            new Element('div#embedded-players').setStyle('display', 'none').inject($$('body')[0]);
        }
        $('embedded-players').set('html', '');
        for (var i = 0; i < this.audio_types.length; i++) {
            new Element('iframe', {
                id: this.audio_types[i],
                name: this.audio_types[i],
                'class': '__embedpearsonvideoplayer__',
                height: 0,
                width: 0
            }).inject($('embedded-players'));
        };

        // for (var i = this.options.cards.length - 1; i >= 0; i--) {
        for (var i = 0; i < this.options.cards.length; i++) {
            card_data = this.options.cards[i];
            if (card_data.chapter > this.options.currentChapter) {
                continue;
            }
            card = new Element('article.card', {
                'data-chapter': card_data.chapter
            }).inject(container, 'bottom');
            front = new Element('div.front', {
                html: '<div class="content-wrapper"><p tabindex="0" class="term">' + card_data.term + '</p></div>'
            }).inject(card);
            back = new Element('div.back').inject(card);
            new Element('a.click-thru', {
                href: '#',
                html: 'Click or tap here to view answer',
                "role":"button"
            }).inject(back);
            defi = new Element('div.content-wrapper.content-definition', {
                html: '<p>' + card_data.definition + '</p>',
                'tabindex': 0
            }).inject(back);
            // defi.hide();
            if (card_data.audio) {
                audio_wrapper = new Element('div.audio-wrapper-common.audio-wrapper').inject(front);
                audio_wrapper_back = new Element('div.audio-wrapper-common.audio-wrapper-back').inject(back, 'top');
                audio_html = '<div class="marginalia"><a tabindex="0" data-type="audio" data-audio="[AUDIO]" data-audio-type="[AUDIOTYPE]"><p><span aria-disabled="true" aria-hidden="true" class="design-icon design-icon_1"></span>[TEXT]</p></a></div>';
                for (audio_type in card_data.audio) {
                    switch (audio_type) {
                        case 'front-speech':
                            audio = new Element('div.audio', {
                                html: audio_html
                                        .replace('[AUDIO]', card_data.audio[audio_type])
                                        .replace('[AUDIOTYPE]', audio_type)
                                        .replace('[TEXT]', ' Listen to Pronunciation'),
                   //             'tabindex': 0
                            }).inject(audio_wrapper);
                            break;
                        // case 'back-speech':
                        //     audio = new Element('div.audio', {
                        //         html: audio_html
                        //                 .replace('[AUDIO]', card_data.audio[audio_type])
                        //                 .replace('[AUDIOTYPE]', audio_type)
                        //                 .replace('[TEXT]', ' Read Aloud')
                        //     }).inject(audio_wrapper_back);
                        //     break;
                        case 'front-music':
                            audio = new Element('div.audio', {
                                html: audio_html
                                        .replace('[AUDIO]', card_data.audio[audio_type])
                                        .replace('[AUDIOTYPE]', audio_type)
                                        .replace('[TEXT]', ' Listen to Example'),
                   //             'tabindex': 0
                            }).inject(audio_wrapper);
                            break;
                        case 'back-music':
                            audio = new Element('div.audio', {
                                html: audio_html
                                        .replace('[AUDIO]', card_data.audio[audio_type])
                                        .replace('[AUDIOTYPE]', audio_type)
                                        .replace('[TEXT]', ' Listen to Example'),
                   //             'tabindex': 0
                            }).inject(audio_wrapper);
                            break;
                        default:
                    }
                }
            }
        };     
        if(this.options.displayCurrentChapterButton == false){
            this.options.container.getElement('.current-chapter-cards').setStyle('opacity', '0');
        }
    },

    flip: function() {
        var front_content, back_content, front_audio_content, back_audio_content,
            card_elements = this.options.container.getElements('.card');
        for (var i = 0; i < card_elements.length; i++) {
            front_content = card_elements[i].getElement('.front .content-wrapper');
            back_content = card_elements[i].getElement('.back .content-wrapper');
            card_elements[i].getElement('.front').grab(back_content);
            card_elements[i].getElement('.back').grab(front_content);
            front_audio_content = card_elements[i].getElement('.front .audio-wrapper-common');
            back_audio_content = card_elements[i].getElement('.back .audio-wrapper-common');
            if (back_audio_content) {
                back_audio_content.removeClass('audio-wrapper-back').addClass('audio-wrapper');
                card_elements[i].getElement('.front').grab(back_audio_content);
            }
            if (front_audio_content) {
                front_audio_content.addClass('audio-wrapper-back').removeClass('audio-wrapper');
                card_elements[i].getElement('.back').grab(front_audio_content);
            }
        };

        if (this.mode == 'flip-normal') {
            this.mode = 'flip-inverse';
        }
        else {
            this.mode = 'flip-normal';
        }

        this.render();
    },

    restart: function() {

        if(this.options.shuffle)
            this.shuffleCards();

        var chapter,
            card_index = 0,
            card_elements = this.options.container.getElements('.card');

        this.cards = [];

        for (var i = 0; i < card_elements.length; i++) {
            chapter = +card_elements[i].get('data-chapter');

            if (chapter > this.last_chapter) {
                this.last_chapter = chapter;
            }
            if (chapter < this.first_chapter) {
                this.first_chapter = chapter;
            }

            if (this.options.allChapters || this.options.currentChapter == chapter) {
                this.cards.push(new Flashcards_card({
                    el: card_elements[i],
                    index: card_index++,
                    chapter: chapter
                }));                
            }

            card_elements[i].set('data-card-id', i);
        };

        this.totalCards = this.cards.length;

        this.status.currentCard = 0;
        this.status.reviewed = [];
        this.status.mastered = 0;
        this.status.repeated = [];
        this.status.toGo = this.totalCards;

        this.render();

        this.showCard(0);

        this.options.container.getElements('.main-nav button').removeProperty('disabled');
        if (this.options.allChapters) {
            this.options.container.getElement('.all-chapters-cards').set('disabled', 'disabled');
        }
        else {
            this.options.container.getElement('.current-chapter-cards').set('disabled', 'disabled');
        }
    },

    shuffleCards: function() {
        var deck = this.options.container.getElement('.cards');
        var cards = this.options.container.getElements('.card');
        var currentIndex = cards.length, temporaryValue, randomIndex ;

        while (0 !== currentIndex) {

            randomIndex = Math.floor(Math.random() * currentIndex);
            currentIndex -= 1;
            temporaryValue = cards[currentIndex];
            cards[currentIndex] = cards[randomIndex];
            cards[randomIndex] = temporaryValue;
        }

        for (var i = 0; i < cards.length; i++) {
            deck.appendChild(cards[i]);
        }
    },

    render: function() {
        this.options.container.getElement('.cards').set('data-mode', this.mode);

        this.options.container.getElement('.status-reviewed').set('html', this.status.reviewed.length);
        this.options.container.getElement('.status-mastered').set('html', this.status.mastered);
        this.options.container.getElement('.status-to-go').set('html', this.status.toGo);

        if(this.options.container.getElement(".bottom-text-note"))
            this.options.container.getElement(".bottom-text-note").set("aria-label",this.options.container.getElement(".status").get("text").trim());
        if (this.status.toGo > 0) {
            this.options.container.removeClass('end');
        }
    },

    showCard: function(index) {
        var _this = this;

        for (var i = 0; i < _this.cards.length; i++) {
            _this.cards[i].hide();
            _this.cards[i].el.setStyle('opacity', 0);
        };

        _this.status.currentCard = index;
        _this.cards[_this.status.currentCard].show();
        _this.cards[_this.status.currentCard].el.morph({opacity:1}, 1500);

        _this.render();


    },

    nextCard: function() {
        this.status.mastered++;
        this.status.toGo--;

        if (this.status.toGo > 0) {
            console.log('to show card', this.status.currentCard + 1);
            this.showCard(this.status.currentCard + 1);
            setTimeout(function(){
                $$(".card.active *[tabindex]")[0].focus();
                            //console.log($$(".card.active'] *[tabindex]"));
            },500);
        }
        else {
            console.log('end');
            this.render();
            this.end();
        }
    },

    postponeCard: function(index) {
        var card = this.cards.splice(index, 1)[0];
        this.cards.push(card);

        this.reIndex();

        this.showCard(index);
        setTimeout(function(){
            $$(".card.active *[tabindex]")[0].focus();
                    //console.log($$(".card.active'] *[tabindex]"));
        },500);
    },

    skip: function() {
        if (widget_instance.options.container.hasClass('end')) {
            return false;
        }

        var card = this.cards.splice(this.status.currentCard, 1)[0];
        card.skip();
        this.reIndex();

        this.status.toGo--;

        this.render();

        if (this.status.toGo > 0) {
            this.showCard(this.status.currentCard);
            $$(".card.active *[tabindex]")[0].focus();
        }
        else {
            this.end();
        }
    },

    reIndex: function() {
        this.status.repeated = [];
        for (var i = 0; i < this.cards.length; i++) {
            this.cards[i].options.index = i;
            this.cards[i].render();

            if (this.cards[i].repeated) {
                this.status.repeated.push(i);
            }
        };
    },

    pauseAudio: function() {
        var audio_links = this.options.container.getElements('.active a[data-type="audio"]');
        for (var i = 0; i < audio_links.length; i++) {
            if (audio_links[i].getElement('.design-icon i').hasClass('fa-volume-up')) {
                console.log('audio_links[i]', audio_links[i]);
                window.widget_instance.cards[window.widget_instance.status.currentCard].togglePlayButton(audio_links[i].getParent());
            }
        };
    },

    end: function() {
        var repeated_cards_list = this.options.container.getElement('.repeated-cards'),
            repeated_text = this.status.repeated.length + ' card';

        if (this.status.repeated.length != 1) {
            repeated_text += 's';
        }

        this.options.container.getElement('.repeated').set('html', repeated_text);
        repeated_cards_list.set('html', '');
        for (var i = 0; i < this.status.repeated.length; i++) {
            new Element('li', {
                html: this.cards[this.status.repeated[i]].el.getElement('.term').get('html')
            }).inject(repeated_cards_list);
        };
        this.options.container.addClass('end');
    }
});

Flashcards_card = new Class({
    Implements: [Options, Events],

    status: 'initial',
    repeated: false,
    reviewed: false,

    url_prefix: 'http://mediaplayer-cert.pearsoncmg.com/assets/_embed.true/',

    options: {

    },

    initialize: function(options) {
        this.setOptions(options);
        this.el = this.options.el;
        var _this = this;

        if (!this.el.get('data-initialized')) {
            this.el.getElement('.click-thru').addEvent('click', function() {
                _this.el.getElement('.got-it').show();
                _this.el.getElement('.not-yet').show();
                window.widget_instance.pauseAudio();
                _this.flip();
                _this.el.getElement('div.content-wrapper.content-definition').show().focus();
                return false;
            });

            this.audio_elements = this.el.getElements('.audio');
            this.audio_elements.addEvent('click', function() {
                _this.togglePlayButton(this);
                return false;
            });
            this.audio_elements.addEvent('keypress', function(e) {
                if (e.code === 13 || e.code === 32)
                    this.fireEvent("click");
            });

            for (var i = 0; i < this.audio_elements.length; i++) {
                new Element('i.fa.fa-volume-off').inject(this.audio_elements[i].getElement('span'), 'top');
            };
        }
        else {
            this.el.getElement('div.controls').destroy();
        }

        var controls = new Element('div.controls').inject(this.el.getElement('.back'));
        this.controls = {
            gotIt: new Element('button.got-it', {
                html: 'Got It!',
                'tabindex': 0
            }).inject(controls),
            notYet: new Element('button.not-yet', {
                html: 'Not Yet',
                'tabindex': 0
            }).inject(controls),
        };
        this.controls.gotIt.addEvent('click', function() {
            window.widget_instance.pauseAudio();
            _this.gotIt();
            return false;
        });
        this.controls.notYet.addEvent('click', function() {
            window.widget_instance.pauseAudio();
            _this.notYet();
            return false;
        });
        this.controls.gotIt.hide();
        this.controls.notYet.hide();
        // this.render();

        this.el.removeClass('active').removeClass('flipped');
        this.el.set('data-initialized', 1);

        if (window.addEventListener) {
            window.addEventListener("message", this.listenMessage, false);
        } else {
            window.attachEvent("onmessage", this.listenMessage);
        }        
    },

    show: function() {
        this.el.addClass('active');
        this.initAudio();
    },

    hide: function() {
        this.el.removeClass('active').removeClass('flipped');
    },

    skip: function() {
        this.options.index = -1;
        this.el.removeProperty('data-index');
        this.hide();
    },

    gotIt: function() {
        $$(".got-it").set('disabled',true);
        var parent_element = window.widget_instance;

        this.status = 'mastered';

        var aftermessages = new Element('div.after-gotit-message', {
                html: 'Great!',
                style: 'opacity: 1'
            }).inject(this.el.getElement('.back'));
                if($$(".flashcard-live-messages").length>0){
                    $$(".flashcard-live-messages").set("html",'Great!');
                }
        setTimeout( function() { 
            $$('.after-gotit-message').destroy();
            parent_element.nextCard();
            $$(".got-it").set('disabled',false); }, 1000);

    },

    notYet: function() {
        $$(".not-yet").set('disabled',true);
        var parent_element = window.widget_instance;

        this.status = 'not-yet',
        this.repeated = true;

        var aftermessages = new Element('div.after-notyet-message', {
                html: 'OK, we’ll come back to this.',
                style: 'opacity: 1'
            }).inject(this.el.getElement('.back'));
                if($$(".flashcard-live-messages").length>0){
                    $$(".flashcard-live-messages").set("html",'OK, we’ll come back to this.');
                }
        var whichIndex = this.options.index;

        setTimeout( function() { 
            $$('.after-notyet-message').destroy();
            parent_element.postponeCard(whichIndex);
            $$(".not-yet").set('disabled',false); }, 1000);
    },

    flip: function() {
        var parent_element = window.widget_instance,
            card_id = this.el.get('data-card-id');

        this.status = 'reviewed';
        this.reviewed = true;

        this.el.toggleClass('flipped');

        if (parent_element.status.reviewed.indexOf(card_id) < 0) {
            parent_element.status.reviewed.push(card_id);
        }
        parent_element.render();
    },

    togglePlayButton: function(button) {
        var link = button.getElement('a[data-type="audio"]');
        if (!link.hasClass('loaded')) {
            return false;
        }
        var playerId = link.get('data-audio-type');
        var icon = button.getElement('.fa');
        if(icon && icon.hasClass('fa-volume-up')) {
            icon.removeClass('fa-volume-up').addClass('fa-volume-off');
            window.sendCommandMessage(playerId, 'pause');
        } else {
            window.widget_instance.pauseAudio();
            icon.removeClass('fa-volume-off').addClass('fa-volume-up');
            window.sendCommandMessage(playerId, 'play');                       
        }
    },

    listenMessage: function(message) {
        var msg = {};
    
        // convert the stringified JSON back to JSON object
        msg.data = JSON.parse(message.data);

        //get playerId from a fallback mechanism, as a fall back on some platforms/browsers
        playerId = ((typeof msg.data.payload != "undefined") 
            && msg.data.payload.playerId) ? msg.data.payload.playerId : window.getFrameTarget(message).id;
        
        //Make sure we are getting to the right events
        if (msg.data.type && msg.data.type == "message" && msg.data.method && msg.data.method == "publish") {
            //And we have a Media Player ready for playback event
            if(msg.data.payload.message.action == 'spp_readyForPlayback') {
                //lets enable all the buttons, now that the player is ready
                var buttonsArr = document.getElementsByTagName('button');
                $$('.active a[data-type="audio"][data-audio-type="' + playerId + '"]').addClass('loaded');
                for (var i = 0; i < buttonsArr.length; i++) {
                    buttonsArr[i].disabled=false;
                    
                }
                window.sendCommandMessage(playerId, 'setVolume', params = {'percent':100});
            }
            
            //Playback finished, lets change the button state to "replay"
            if(msg.data.payload.message.action == 'spp_finished') {
                $$('a[data-type="audio"][data-audio-type="' + playerId + '"] .fa').removeClass('fa-volume-up').addClass('fa-volume-off');
            }
        }
    },

    initAudio: function() {
        var audio_link;
        if (!this.audio_elements) {
            this.audio_elements = this.el.getElements('.audio');
            if (this.audio_elements) {
                this.audio_elements.addEvent('click', function() {
                    _this.togglePlayButton(this);
                    return false;
                });
            }
        }
        if (this.audio_elements) {
            for (var i = 0; i < this.audio_elements.length; i++) {
                if (this.audio_elements[i].hasClass('audio-init')) {
                    continue;
                }
                audio_link = this.audio_elements[i].getElement('a[data-type="audio"]');
                $$('.active a[data-type="audio"]').removeClass('loaded');
                $$('iframe#' + audio_link.get('data-audio-type')).set('src', this.url_prefix + audio_link.get('data-audio'));
                // console.warn('initialized', this.audio_elements[i]);
                this.audio_elements[i].addClass('audio-init');
            };
        }
    },

    render: function() {
        this.el.set('data-index', this.options.index);
    }
});