/*
 Poe eBook Framework
 Copyright 2011-2015 Metrodigi, Inc. All rights reserved.
 */

window.IS_MAC = window.navigator.platform.match(/(Mac|iPhone|iPod|iPad)/i) ? true : false;
window.IS_FIREFOX_WINDOWS = (navigator.userAgent.indexOf('Firefox') !== -1 && navigator.userAgent.indexOf('Windows') !== -1);
window.IS_CHROME_WINDOWS = (navigator.userAgent.indexOf('Chrome') !== -1 && navigator.userAgent.indexOf('Windows') !== -1);

Flashcards = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
      allChapters: false,
      shuffle: true,
    },

    cards: [],

    mode: 'flip-normal',
    status: {
      currentCard: 0,
      reviewed: [],
      mastered: 0,
      repeated: [],
      toGo: 0
    },
    first_chapter: 1000,
    last_chapter: -1,
    players: null,
    prefix : "http://mediaplayer-cert.pearsoncmg.com/assets/_embed.true/",
    iframeContainer:null,

    audio_types: [
      'front-speech',
      'front-music',
      'back-speech',
      'back-music'
    ],

    timerIds: {},

    initialize: function(options) {

      window.elem = this;
      var audio_elements,
      _this = this;
      this.parent(options);
      this.checkCurrentChapter();

      if (typeof this.options.currentChapter == 'undefined' || this.options.currentChapter === null) {
        console.error('Flashcards', 'currentChapter parameter is mandatory.');
        return false;
      }

      // fix buttons position on legacy widgets
      var gotItBtnEl = this.options.container.getElements('.got-it-v3')[0];
      var nextBtnEl = this.options.container.getElements('.next')[0];
      var prevBtnEl = this.options.container.getElements('.prev')[0];
      // check if gotItBtnEl isn't the last element
      if (gotItBtnEl.nextElementSibling) {
        prevBtnEl.clone().inject(document.querySelector('.bottom-nav'));
        nextBtnEl.clone().inject(document.querySelector('.bottom-nav'));
        gotItBtnEl.clone().inject(document.querySelector('.bottom-nav'));
        prevBtnEl.destroy();
        nextBtnEl.destroy();
        gotItBtnEl.destroy();
      }

      this.resetStatus();

      var chapter = this.options.container.getElement('.current-chapter-cards');

      if(this.options.currentChapter > 0){
        chapter.set('html', 'Ch. ' + this.options.currentChapter);
      }
      else{
        chapter.set('html', '&nbsp;&nbsp;&nbsp;');
      }
      chapter.removeEvents('click');
      chapter.addEvent('click', function() {
        _this.pauseAudio();
        _this.options.allChapters = false;
        _this.resetStatus();
      });

        try{
            var statusContainer = $$('.status-v3')[0];
            var subStatusContainer = new Element('.sub-status-v3',{
                html: statusContainer.get('html')
            })

            var labelStatus = subStatusContainer.getChildren('#label-status')[0]

            statusContainer.innerHTML = null
            statusContainer.adopt(labelStatus)
            statusContainer.adopt(subStatusContainer)

        }catch(e){
            console.log(e)
        }

      if ((this.first_chapter != this.last_chapter)) {
        this.options.container.getElement('.all-chapters-cards').set('html', 'Start Cumulative Review').addEvent('click', function() {
          _this.pauseAudio();
          _this.options.allChapters = true;
          _this.resetStatus();
        });
      }
      else {
        this.options.container.getElement('.all-chapters-cards').hide();
      }

      this.options.container.getElements('.restart').removeEvents('click');
      this.options.container.getElements('.restart').addEvent('click', function() {
        _this.pauseAudio();
        _this.resetStatus();
        setTimeout(function(){
          $$(".cards .active")[0].set('tabindex',-1).focus();
          $$(".cards .active")[0].addClass('non-keyboard-outline');
          console.log($$(".cards [tabindex]")[0]);
        }, 750);
      });

      this.options.container.getElements('.flip').removeEvents('click');
      this.options.container.getElements('.flip').addEvent('click', function() {
        _this.pauseAudio();
        _this.flip();
        setTimeout(function(){
          $$(".cards .active")[0].set('tabindex',-1).focus();
          $$(".cards .active")[0].addClass('non-keyboard-outline');
          console.log($$(".cards [tabindex]")[0]);
        }, 500);
      });

      this.options.container.getElements('.skip').removeEvents('click');
      this.options.container.getElements('.skip').addEvent('click', function() {
        _this.pauseAudio();
        _this.skip();
      });

      this.options.container.getElements('.next').removeEvents('click');
      this.options.container.getElements('.next').addEvent('click', function() {
        _this.pauseAudio();
        return _this.changeCard(_this.status.currentCard, true);
      });

      this.options.container.getElements('.prev').removeEvents('click');
      this.options.container.getElements('.prev').addEvent('click', function() {
        _this.pauseAudio();
        _this.changeCard(_this.status.currentCard, false);
      });

      this.options.container.getElements('.got-it-v3').removeEvents('click');
      this.options.container.getElements('.got-it-v3').addEvent('click', function(event) {
        if (event.target.hasClass('is-disabled')) return;

        _this.pauseAudio();
        for (var i = 0; i < _this.cards.length; i++) {
          if(_this.cards[i].el.hasClass('active')){
            _this.cards[i].gotIt(i);
            return;
          }
        }
      });

      this.disableGotIt();

      window.getFrameTarget = function(message) {
        var frames = document.getElementsByTagName('iframe'),
        frameId = 0,
        framesLength = frames.length;

        for (; frameId < framesLength; frameId++) {
          if (frames[frameId].contentWindow === message.source) {
            return frames[frameId];
          }
        }
        return null;
      }

      window.sendCommandMessage = function(playerId, command, payload) {
        var params = JSON.stringify({
          "type": "command",
          "method": command,
          "playerId": playerId,
          "payload": payload
        });
        document.getElementById(playerId).contentWindow.postMessage(params, '*');
      }

      this.players = $$('#embedded-players > iframe');

      var mainNav = $$('.main-nav');
      if( mainNav.length > 0 ) {
        mainNav.forEach( function (theEl) {
          theEl.setProperties({
            role:'navigation',
            'aria-label': "Start over, swap and status"
          });
        });
      }

      var bottomNav = $$('.bottom-nav');
      if( bottomNav.length > 0 ) {
        bottomNav.forEach( function (theEl) {
          theEl.setProperties({
            role:'navigation',
            'aria-label': "Previous and next card"
          });
        });
      }

      var statusV3 = $$('.status.status-v3');
      if( statusV3.length > 0 ) {
        statusV3.forEach( function (theEl) {
          theEl.set('tabindex', null);
          theEl.removeProperty('tabindex');
          theEl.removeAttribute('tabindex');
        });
      }

      if (IS_FIREFOX_WINDOWS) {
        // ensure JAWS reads card on firefox
        $$('.card').setProperties({
          role: 'region'
        });
      }

      //this.readActiveFrontCard(250);

      setTimeout(function () {
        _this.updateCardsHeight();
        window.addEventListener('resize', _this.updateCardsHeight);
      }, 0);
    },

    updateCardsHeight: function () {
      var windowHeight;
      var cardsEl = document.querySelector('.cards');
      var ratio = window._current_scale || 1;

      if (ratio < 1) {
        var windowHeight = document.querySelector('body').getBoundingClientRect().height;
      } else {
        var windowHeight = window.innerHeight;
      }

      if (windowHeight > 650) {
        return $$(cardsEl).setStyles({
          'min-height': null,
          'height': null
        });
      }

      var headerElBCR = document.querySelector('.widget-header').getBoundingClientRect();
      var mainNavElBCR = document.querySelector('.main-nav').getBoundingClientRect();
      var bottomNavElBCR = document.querySelector('.bottom-nav').getBoundingClientRect();
      var cardsMarginBottom = 20;
      var remainingHeight = windowHeight - (headerElBCR.height + mainNavElBCR.height + bottomNavElBCR.height + cardsMarginBottom);

      $$(cardsEl).setStyles({
        'min-height': 'initial',
        'height': remainingHeight / ratio + 'px'
      });
    },

    readActiveFrontCard: function (timeout) {
      this.clearTimers();

      timeout = timeout || 500;

      this.timerIds.readActiveFrontCard = setTimeout(function () {
        // read front card
        $$(".cards .active .front")[0].set('tabindex',-1).focus();
        $$(".cards .active .front")[0].addClass('non-keyboard-outline');
      }, timeout);
    },

    clearTimers: function () {
      var _this = this;

      Object.keys(_this.timerIds).forEach(function (key) {
        clearTimeout(_this.timerIds[key]);
        delete _this.timerIds[key];
      });
    },

    customPostMessages:function(message,path) {
        this.parent(message, path);

        var that = this;

        switch(message.data.method){
          case "data-change":
            that.options.cards = message.data.data;
            $$(".MetrodigiWidget.Flashcards .cards")[0].empty();
            $$(".MetrodigiWidget.Flashcards .card").dispose();
            $$(".MetrodigiWidget.Flashcards .offscreen.flashcard-live-messages")[0].dispose();
            $("embedded-players").dispose();
            //that.restartDom();
            that.initialize(that.options);

            setTimeout(function(){
              that.pauseAudio();
              that.showCard(message.data.row_modified-1);
            },500);
            break;
          case "delete-image":
            that.deleteImage(message.data.data.image, message.data.data.id);
          break;

          case "new-json":

            this.options.cards = message.data.json;

            _this.saveRequest({
                method: 'mdData',
                options: {'json': message.data.json}
            }, function(data){

            },true);

            break;
          case "show-media-popup":
            var imagepath,filepath,multimediaTypeFormat,multimediaType,caption="",defaultImage=false,copyFile=false;
            filepath = 'images/' + message.data.data.source_value;
            imagepath="https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
            multimediaType = multimediaTypeFormat =  message.data.data.source_type;

            if(multimediaType=="internet"){
                multimediaType="iframe";
                filepath = imagepath = message.data.data.source_value;
            }

            if(multimediaType=="computer"){

              if(message.data.data.source_ext.indexOf("image/")!=-1){
                multimediaType="image";
                multimediaTypeFormat = message.data.data.source_ext;
                imagepath = filepath = message.data.data.source_value;
              }

              copyFile=true;

            }
            var containerSelector = '[data-md-editable="md-portal-media-list"]';

            that.saveRequest({
                path: undefined,
                method: 'appendMultimediaHTML5',
                element: containerSelector,
                type: 'md-portal-media-list-element',
                content: imagepath,
                filePath:filepath,
                multimediaType:multimediaType,
                multimediaTypeFormat:multimediaTypeFormat,
                mustCopyTheFile:true,
                caption:'',
                defaultImage:false,
                id:null
            },function(){
            });

            break;
        }
    },
    deleteImage: function(imageName,widgetId){
      this.saveRequest(
        {
          method:"deleteImageHTML5",
          imageName: imageName,
          directory: 'images',
          id: widgetId
        }
      );
    },

    checkCurrentChapter: function() {
      var found = false;
      if (this.options.cards.length < 1) {
        console.error('Flashcards', 'No cards defined.');
      }
      for (var i = this.options.cards.length - 1; i >= 0; i--) {
        if (this.options.cards[i].chapter == this.options.currentChapter) {
          found = true;
          break;
        }
      };
      if (!found) {
        var max = 0;
        for (var i = 0; i < this.options.cards.length; i++) {
          var chapter = this.options.cards[i].chapter;
          max =  chapter > max ? chapter : max;
        };
        // console.log('max',max);
        this.options.currentChapter = chapter;
      }
    },

    createDOM: function() {
      var card, card_data, front, back, audio, audio_wrapper, audio_wrapper_back,
      container = this.options.container.getElement('section.cards');

      new Element("div.offscreen.flashcard-live-messages",{
       "aria-live":"assertive"
     }).inject($$('.Flashcards')[0]);

      if (!$('embedded-players')) {
        new Element('div#embedded-players').setStyle('display', 'none').inject($$('body')[0]);
      }
      $('embedded-players').set('html', '');
      for (var i = 0; i < this.audio_types.length; i++) {
        new Element('iframe', {
          id: this.audio_types[i],
          name: this.audio_types[i],
          'class': '__embedpearsonvideoplayer__',
          height: 0,
          width: 0
        }).inject($('embedded-players'));
      }

      for (var i = 0; i < this.options.cards.length; i++) {
        injectCard(this.options.cards[i], this);
      }

      if($$(".cards img").length>0){
        var images_array = $$(".cards img").map(function(img){return img.get("src");});
        //console.log(images_array);

        Asset.images(images_array, {
            onProgress: function(){
              var image_element = $$("img[src='"+this.get("src")+"']")[0];
              //console.log(image_element);
              if( (new Number(this.get("width"))) > (new Number(this.get("height"))) ){
                image_element.addClass("landscape");
              }
              else{
                image_element.addClass("portrait");
              }
            }
        });
      }

      if(this.options.displayCurrentChapterButton == false){
        this.options.container.getElement('.current-chapter-cards').setStyle('opacity', '0');
      }
    },

    flip: function() {
      var front_content, back_content, front_audio_content, back_audio_content,
      card_elements = this.options.container.getElements('.card');

      for (var i = 0; i < card_elements.length; i++) {
        front_content = card_elements[i].getElement('.front .content-wrapper');
        back_content = card_elements[i].getElement('.back .content-wrapper');
        card_elements[i].getElement('.front').grab(back_content);
        card_elements[i].getElement('.back').grab(front_content);


        front_audio_content = card_elements[i].getElement('.front .audio-wrapper-common');
        back_audio_content = card_elements[i].getElement('.back .audio-wrapper-common');

        if (back_audio_content) {
          back_audio_content.removeClass('audio-wrapper-back').addClass('audio-wrapper');
          card_elements[i].getElement('.front').grab(back_audio_content);
        }
        if (front_audio_content) {
          front_audio_content.addClass('audio-wrapper-back').removeClass('audio-wrapper');
          card_elements[i].getElement('.back').grab(front_audio_content);
        }
      };

      if (this.mode == 'flip-normal') {
        this.mode = 'flip-inverse';
      }
      else {
        this.mode = 'flip-normal';
      }

      this.render();
    },

    restartDom: function(){
      this.options.container.getElements('article.card').destroy();
      this.createDOM();
    },

    resetStatus: function(){
      if(this.options.shuffle){
        this.shuffleCards();
      }

      var chapter,
      card_index = 0;

      card_elements = this.options.container.getElements('.card');

      this.cards = [];

      for (var i = 0; i < card_elements.length; i++) {
        chapter =+ card_elements[i].get('data-chapter');

        if (chapter > this.last_chapter) {
          this.last_chapter = chapter;
        }
        if (chapter < this.first_chapter) {
          this.first_chapter = chapter;
        }
        // // console.log('reset queston  ',this.options.allChapters,this.options.currentChapter == chapter);
        if (this.options.allChapters || this.options.currentChapter == chapter) {
          this.cards.push(new Flashcards_card({
            el: card_elements[i],
            index: card_index++,
            chapter: chapter
          }));
        }

        card_elements[i].set('data-card-id', i);
      }

      this.totalCards = this.cards.length;

      this.status.currentCard = 0;
      this.status.reviewed = [];
      this.status.mastered = 0;
      this.status.repeated = [];
      this.status.toGo = this.totalCards;
      this.status.totalCards = this.totalCards;

      this.render();
      // console.log('resetstatus',this.options);
      this.showCard(0);

      this.options.container.getElements('.main-nav button').removeProperty('disabled');
      if (this.options.allChapters) {
        this.options.container.getElement('.all-chapters-cards').set('disabled', 'disabled');
      }
      else {
        this.options.container.getElement('.current-chapter-cards').set('disabled', 'disabled');
      }

      this.disableGotIt();
      $$('.next, .prev').set('disabled','');
      this.disableButtonsIfisTheLastCard();
    },

    restart: function() {
      this.resetStatus();
    },

    shuffleCards: function() {
      var deck = this.options.container.getElement('.cards');
      var cards = this.options.container.getElements('.card');
      var currentIndex = cards.length, temporaryValue, randomIndex ;

      while (0 !== currentIndex) {

        randomIndex = Math.floor(Math.random() * currentIndex);
        currentIndex -= 1;
        temporaryValue = cards[currentIndex];
        cards[currentIndex] = cards[randomIndex];
        cards[randomIndex] = temporaryValue;
      }

      for (var i = 0; i < cards.length; i++) {
        deck.appendChild(cards[i]);
      }
    },

    render: function() {
        var activeTerm = this.options.container.getElement('.card.active .term');
        if (activeTerm) {
            if ($$(activeTerm)[0].getChildren('p').length == 0) {
                var termHtml = $(activeTerm).get('html')
                $(activeTerm).set('html', '<p>' + termHtml + '</p>')
            }
        }
        if (this.options.container.getElement('.card.active.flipped .term .image-wrapper')) {
            var iw_p = this.options.container.getElement('.card.active.flipped .term .image-wrapper + p');
            var iw = this.options.container.getElement('.card.active.flipped .term .image-wrapper');
            var iw_img = iw.getElement('img');
            iw_img.setStyle('max-height', '167px');
            if(iw_p){
              var iw_p_height = iw_p.getCoordinates().height;
              iw_img.setStyle('max-height', (parseInt(iw_img.getStyle('max-height')) - iw_p_height) + 'px');
            }
        }

        if (this.options.container.getElement('.card.active:not(.flipped) .term .image-wrapper')) {
            this.options.container.getElement('.card.active:not(.flipped) .term .image-wrapper img').setStyle('max-height', '');
        }
        //Determine the image height based on the amount of text
        var iw_p = this.options.container.getElement('.card.active .image-wrapper + p');
        if (iw_p && iw_p.getCoordinates().height !== 0) {

            var p_text = this.options.container.getElement('.card.active .image-wrapper + p'),
                p_text_height = parseInt(p_text.getCoordinates().height),
                p_text_max_height = parseInt(p_text.getStyle('max-height'));

            var iw_img = this.options.container.getElement('.card.active .image-wrapper');
            if (iw_img && parseInt(iw_img.getCoordinates().height) !== 0) {
                iw_img.setStyle('max-height', '');
            }

            if (p_text_height !== 0 && p_text_height < p_text_max_height) {

                var iw = this.options.container.getElement('.card.active .image-wrapper');

                iw.setStyle('max-height', '');
                iw.setStyle('max-height', (parseInt(iw.getStyle('max-height')) + (p_text_max_height - p_text_height))+'px');
            }

        }
      this.options.container.getElement('.cards').set('data-mode', this.mode);

      this.options.container.getElement('.status-reviewed').set('html', this.status.reviewed.length);
      this.options.container.getElement('.status-mastered').set('html', this.status.mastered);

      //this.options.container.getElementById('label-status').set('html', this.status.reviewed.length + ' reviewed ' + this.status.mastered + ' mastered');

      this.options.container.getElement('.status-to-go').set('html', this.status.toGo);
      if(this.options.container.getElement('.status-total')){
        this.options.container.getElement('.status-total').set('html', this.status.totalCards);
      }

      if(this.options.container.getElement(".bottom-text-note"))
        this.options.container.getElement(".bottom-text-note").set("aria-label",this.options.container.getElement(".status").get("text").trim());
      if (this.status.toGo > 0) {
        this.options.container.removeClass('end');
      }

      this.options.container.getElement('.right-helper').setAttribute('aria-live', 'polite');
    },

    showCard: function(index) {
      var _this = this;
      $$('.back').set('aria-hidden', 'true');
      for (var i = 0; i < _this.cards.length; i++) {
        _this.cards[i].hide();
        _this.cards[i].el.setStyle('opacity', 0);
      };

      _this.status.currentCard = index;
      _this.cards[_this.status.currentCard].show();
      _this.cards[_this.status.currentCard].el.morph({opacity:1}, 1500);

      var currentChapter = this.options.container.getElement('.active').get('data-chapter');
      if(currentChapter === '0'){
        this.options.container.getElement('.current-chapter-cards').set('html', '&nbsp;&nbsp;&nbsp;');
      }
      else{
        //this.options.container.getElement('.current-chapter-cards').set('html', 'Ch. ' + currentChapter);
        this.options.container.getElement('.current-chapter-cards').set('html', '&nbsp;&nbsp;&nbsp;');
      }

      _this.render();
    },

    nextCard: function() {
      this.status.mastered++;
      this.status.toGo--;

      if (this.status.toGo > 0) {
        this.disableGotIt();

        this.postponeCard(this.status.currentCard);

        this.readActiveFrontCard(500);
      }
      else {
        this.render();
        this.end();
      }
    },

    changeCard: function(index, next){
      this.disableGotIt();
      this.readActiveFrontCard(1000);
      if (widget_instance.options.container.hasClass('end')) {
        return false;
      }
      return this.cards[index].notYet(next);
    },

    postponeCard: function(index) {
      if(index+1<this.cards.length){
        if(this.cards[index+1].status=='mastered'){
          return this.postponeCard(index+1);
        }
        this.showCard(index+1);
      }
      else{
        if(this.cards[0].status=='mastered'){
          return this.postponeCard(0);
        }
        this.showCard(0);
      }

      setTimeout(function(){
        $$(".card.active")[0].focus();
      },500);
    },

    prevCard: function(index) {

      if(index-1>=0){
        if(this.cards[index-1].status=='mastered'){
          return this.prevCard(index-1);
        }
        this.showCard(index-1);
      }
      else{
        if(this.cards[this.cards.length-1].status=='mastered'){
          return this.prevCard(this.cards.length-1);
        }
        this.showCard(this.cards.length-1);
      }

      setTimeout(function(){
        $$(".card.active")[0].focus();
      },500);
    },
    //(deprecated!)for compatibility with old flashcards conserve this
    skip: function() {
      if (widget_instance.options.container.hasClass('end')) {
        return false;
      }

      var card = this.cards.splice(this.status.currentCard, 1)[0];
      card.skip();
      this.reIndex();

      this.status.toGo--;

      this.render();

      if (this.status.toGo > 0) {
        this.showCard(this.status.currentCard);
        $$(".card.active")[0].focus();
      }
      else {
        this.end();
      }
    },
    //(deprecated!)for compatibility with old flashcards conserve this
    reIndex: function() {
      this.status.repeated = [];
      for (var i = 0; i < this.cards.length; i++) {
        this.cards[i].options.index = i;
        this.cards[i].render();

        if (this.cards[i].repeated) {
          this.status.repeated.push(i);
        }
      };
    },

    pauseAudio: function() {
      var audio_links = this.options.container.getElements('.active a[data-type="audio"]');
      for (var i = 0; i < audio_links.length; i++) {
        if (audio_links[i].getElement('.design-icon i').hasClass('fa-volume-up')) {
          window.widget_instance.cards[window.widget_instance.status.currentCard].togglePlayButton(audio_links[i].getParent());
        }
      };
      if($$('.pearson-audio')){
        $$('.pearson-audio').each(function(el, index){
          el.contentWindow.window.postMessage(JSON.stringify({
              method   : 'pause',
              playerId : '',
              type     : 'command'
          }), '*');
        })
      }
    },

    end: function() {
      var _this = this;
      var repeated_cards_list = this.options.container.getElement('.repeated-cards');

      for (var i = 0; i < this.cards.length; i++) {
        var card = this.cards[i];
        if(card.repeated){
          this.status.repeated.push(card);
        }
      }
      repeated_text = this.status.repeated.length + ' card';

      if (this.status.repeated.length != 1) {
        repeated_text += 's';
      }

      this.options.container.getElement('.repeated').set('html', repeated_text);

      repeated_cards_list.set('html', '');

      var repeatedTermsList = [];
      for (var i = 0; i < this.status.repeated.length; i++) {
          var term_text = this.status.repeated[i].el.getElement('.term p').innerHTML;
          if (term_text !== '') {
              new Element('li', {
                  html: term_text
              }).inject(repeated_cards_list);
              repeatedTermsList.push(term_text);
          }
      }
      if (repeatedTermsList.length > 0) {
        repeated_cards_list.set('aria-label', repeatedTermsList.join(', '));
      }
      this.disableGotIt();


      this.options.container.addClass('end');
      setTimeout(function () {
        $$(".end-screen")[0]
          .set("tabindex", "0")
          .focus();
      }, 500);
    },

    disableGotIt: function disableGotIt(){
      var gotItButton = this.options.container.getElements('.got-it-v3');

      if(gotItButton){
        if (window.IS_MAC) {
          gotItButton.set('disabled','disabled');
        } else {
          // avoid screen reader say `unavailable` on windows
          setTimeout(function () {
            $$('.got-it-v3')[0].blur();
            $$('.got-it-v3').set('tabindex', '0');
            $$('.got-it-v3').removeClass('is-disabled');
            $$('.got-it-v3').set('disabled','disabled');
          }, 250);
        }
      }
    },

    disableButtonsIfisTheLastCard: function(){
      var arr = [];
      var cards = this.cards;
      for (var i = 0; i < cards.length; i++) {
        var card = cards[i];
        if(card.mastered){
          arr.push(card);

        }
        if((cards.length - arr.length) === 1){
            $$('.next, .prev').set('disabled','disabled');
            // console.log(arr, (cards.length - arr.length))
            break;
        }
      }
    }
  });

function convertToHTML(content){
    var pattern, re;
    //replace html to safe text for input
    pattern = '&quot;';
    re = new RegExp(pattern, "g");
    content = content.replace(re, '"');

    pattern = '&amp;';
    re = new RegExp(pattern, "g");
    content = content.replace(re, '&');

    pattern = "&#039;";
    re = new RegExp(pattern, "g");
    content = content.replace(re, "'");

    pattern = '&lt;';
    re = new RegExp(pattern, "g");
    content = content.replace(re, '<');

    pattern = '&gt;';
    re = new RegExp(pattern, "g");
    content = content.replace(re, '>');

    //clean up the content before get rendered
    // pattern = '<([^>]+)>(\s*)<\/([^>]+)>';
    // re = new RegExp(pattern, "g");
    // content = content.replace(re, '');

    return content;
}

function injectCard(card_data, that){

  var container = that.options.container.getElement('section.cards');
  if (card_data.chapter!=""  && that.options.currentChapter!=""  && card_data.chapter > that.options.currentChapter) {
    return;
  }

  card = new Element('article.card', {
    'data-chapter': card_data.chapter
  }).inject(container, 'bottom');

  if(!card_data.term){
    card_data.term = '';
  }

  if(card_data['term image'] && card_data['term image'].path && card_data['term image']!=='undefined'){
    var $theContent = convertToHTML(card_data.term);
    if( !(/^<([^>]+)>/.test($theContent)) ){
      if ($theContent.length > 0){
        $theContent = '<p tabindex="0">' + $theContent + '</p>';
      } else {
        $theContent = '';
      }
    }
    front = new Element('div.front', {
      html: '<div class="content-wrapper content-wrapper-image-text"><div class="term"><div class="image-wrapper"><img></div><div class="content-term-wrapper">' + $theContent + '</div></div></div>',
        // 'role': 'button',
        // 'aria-label': 'Front'
    }).inject(card);

    if(card_data.term){
      front.getElements('.term img').addClass('text');
    }
    front.getElements('.term img').set('src', card_data['term image'].path);
  }
  else if(card_data['term audio'] && card_data['term audio'] !== 'undefined'){
    if( /(\.mp3|\.mp4)$/g.test( card_data['term audio'] ) ){
        //audioEditable.getElement('iframe').set('data-src', audioEditable.getElement('iframe').get('src'))
        //new Element('div.iframe-media-lazy-load[tabindex="0"]',{html:'<span>Click to load the media.</span>', 'aria-label': 'Press enter to enable the media.'}).inject( audioEditable.getElement('iframe') ,"after");
      front = new Element('div.front', {
        html: '<div class="content-wrapper content-wrapper-audio-text"><div class="term"><div class="audio-wrapper"><audio controls><source src="'+card_data['term audio']+'"></audio></div><div class="content-term-wrapper"><p>' + convertToHTML(card_data.term) + '</p></div></div></div>',
        // 'role': 'button',
        // 'aria-label': 'Front'
      }).inject(card);
    } else {
      front = new Element('div.front', {
        html: '<div class="content-wrapper content-wrapper-audio-text"><div class="term"><div class="audio-wrapper"><iframe src="" height="65"></iframe></div><div class="content-term-wrapper"><p>' + convertToHTML(card_data.term) + '</p></div></div></div>',
        'tabindex': 0
      }).inject(card);

      if(card_data.term){
        front.getElements('.term iframe').addClass('pearson-audio');
      }
      front.getElements('.term iframe').set('src', card_data['term audio']);
    }


    if(front.getElement('.iframe-media-lazy-load')){
      front.getElement('.iframe-media-lazy-load').addEvent('click', function(e){
          e.stopPropagation();
          var entry = e.target.getParents('.audio-wrapper')[0];
          if( entry.getElement('iframe') ){
              entry.getElement('iframe').set('src', entry.getElement('iframe').get('data-src'));
              entry.getElement('.iframe-media-lazy-load').dispose();
          }
      });

      front.getElement('.iframe-media-lazy-load').addEvent('keypress', function(e){
          e.stopPropagation();
          if(e.key != 'enter' && e.key != 'space') return;
          var entry = e.target.getParents('.audio-wrapper')[0];
          if( entry.getElement('iframe') ){
              entry.getElement('iframe').set('src', entry.getElement('iframe').get('data-src'));
              entry.getElement('.iframe-media-lazy-load').dispose();
          }
      });
    }

  } else {
    var $theContent = convertToHTML(card_data.term);
    if( !(/^<([^>]+)>/.test($theContent)) ){
      //$theContent = '<p tabindex="0">' + $theContent + '</p>';
    }
    front = new Element('div.front', {
      html: '<div class="content-wrapper"><div class="term">' + $theContent + '</div></div>',
      // 'role': 'button',
      // 'aria-label': 'Front'
    }).inject(card);
  }

  back = new Element('div.back',{
    // 'role': 'button',
    // 'aria-label': 'Back'
  }).inject(card);
  new Element('button.flip-icon', {
    html: '',
    'aria-label': 'Flip',
    'role': 'button'
  }).inject(card);


  if(card_data['definition image'] && card_data['definition image'].path && card_data['definition image']!=='undefined'){
    var $theContent = convertToHTML(card_data.definition);
    if( !(/^<([^>]+)>/.test($theContent)) ){
      $theContent = '<p>' + $theContent + '</p>';
    }
    defi = new Element('div.content-wrapper.content-definition.content-wrapper-image-text', {
      html: '<div class="wrapper with-image"><div class="image-wrapper"><img></div><div class="content-term-wrapper"><div class="wrapper-container">' + $theContent + '</div></div></div>'
    }).inject(back);
    defi.getElements('img').set('src', card_data['definition image'].path);

    if(card_data.definition){
      defi.getElements('img').addClass('text');
    }
    defi.addClass('img');

  }else if(card_data['definition audio'] && card_data['definition audio'] && card_data['definition audio']!=='undefined'){
    if( /(\.mp3|\.mp4)$/g.test( card_data['term audio'] ) ){
        //audioEditable.getElement('iframe').set('data-src', audioEditable.getElement('iframe').get('src'))
        //new Element('div.iframe-media-lazy-load[tabindex="0"]',{html:'<span>Click to load the media.</span>', 'aria-label': 'Press enter to enable the media.'}).inject( audioEditable.getElement('iframe') ,"after");
      defi = new Element('div.content-wrapper.content-definition.content-wrapper-audio-text', {
        html: '<div class="wrapper with-image"><div class="audio-wrapper"><audio controls><source src="'+card_data['definition audio']+'"></audio></div><div class="content-term-wrapper"><div class="wrapper-container"><p>' + convertToHTML(card_data.definition) + '</p></div></div></div>'
      }).inject(back);
    } else {
      defi = new Element('div.content-wrapper.content-definition.content-wrapper-audio-text', {
        html: '<div class="wrapper with-image"><div class="audio-wrapper"><iframe height="65"></iframe></div><div class="content-term-wrapper"><div class="wrapper-container"><p>' + convertToHTML(card_data.definition) + '</p></div></div></div>'
      }).inject(back);
      defi.getElements('iframe').set('src', card_data['definition audio']);
    }
    /*
    defi = new Element('div.content-wrapper.content-definition.content-wrapper-audio-text', {
      html: '<div class="wrapper with-image"><div class="audio-wrapper"><iframe height="65"></iframe><div class="iframe-media-lazy-load" tabindex="0" aria-label="Press enter to enable the media."><span>Click to load the media.</span></div></div><div class="content-term-wrapper"><p>' + convertToHTML(card_data.definition) + '</p></div></div>'
    }).inject(back);
    defi.getElements('iframe').set('data-src', card_data['definition audio']);
    */

    if(card_data.definition){
      defi.getElements('iframe').addClass('pearson-audio');
    }
    defi.addClass('iframe');

    if(defi.getElement('.iframe-media-lazy-load')){
      defi.getElement('.iframe-media-lazy-load').addEvent('click', function(e){
          e.stopPropagation();
          var entry = e.target.getParents('.audio-wrapper')[0];
          if( entry.getElement('iframe') ){
              entry.getElement('iframe').set('src', entry.getElement('iframe').get('data-src'));
              entry.getElement('.iframe-media-lazy-load').dispose();
          }
      });

      defi.getElement('.iframe-media-lazy-load').addEvent('keypress', function(e){
          e.stopPropagation();
          if(e.key != 'enter' && e.key != 'space') return;
          var entry = e.target.getParents('.audio-wrapper')[0];
          if( entry.getElement('iframe') ){
              entry.getElement('iframe').set('src', entry.getElement('iframe').get('data-src'));
              entry.getElement('.iframe-media-lazy-load').dispose();
          }
      });
    }

  }else{
    var $theContent = convertToHTML(card_data.definition);
    if( !(/^<([^>]+)>/.test($theContent)) ){
      $theContent = '<p>' + $theContent + '</p>';
    }
    new Element('div.content-wrapper.content-definition', {
      html: '<div class="wrapper"><div class="wrapper-container">' + $theContent + '</div></div>'
    }).inject(back);
  }
  $$('.wrapper-container').each(function(el, i){
    el.getElements('p').each(function(elem, i){
      if (elem.get('html').trim().length > 0){
        //elem.set('tabindex', 0);
      } else {
        elem.remove();
      }
    })
  });



  if (card_data.audio) {
    audio_wrapper = new Element('div.audio-wrapper-common.audio-wrapper').inject(front);
    audio_wrapper_back = new Element('div.audio-wrapper-common.audio-wrapper-back').inject(back, 'top');
    audio_html = '<div class="marginalia"><a tabindex="0" data-type="audio" data-audio="[AUDIO]" data-audio-type="[AUDIOTYPE]"><p><span aria-disabled="true" aria-hidden="true" class="design-icon design-icon_1"></span>[TEXT]</p></a></div>';
    for (audio_type in card_data.audio) {
      switch (audio_type) {
        case 'front-speech':
        audio = new Element('div.audio', {
          html: audio_html
          .replace('[AUDIO]', card_data.audio[audio_type])
          .replace('[AUDIOTYPE]', audio_type)
          .replace('[TEXT]', ' Listen to Pronunciation'),
       }).inject(audio_wrapper);
        break;
              case 'front-music':
              audio = new Element('div.audio', {
                html: audio_html
                .replace('[AUDIO]', card_data.audio[audio_type])
                .replace('[AUDIOTYPE]', audio_type)
                .replace('[TEXT]', ' Listen to Example'),
       }).inject(audio_wrapper);
              break;
              case 'back-speech':
              audio = new Element('div.audio', {
                html: audio_html
                .replace('[AUDIO]', card_data.audio[audio_type])
                .replace('[AUDIOTYPE]', audio_type)
                .replace('[TEXT]', ' Listen to Example'),
       }).inject(audio_wrapper_back);
              break;
              default:
            }
      }
    }
}

Flashcards_card = new Class({
  Implements: [Options, Events],

  status: 'initial',
  repeated: false,
  reviewed: false,
  mastered: false,

  url_prefix: 'http://mediaplayer-cert.pearsoncmg.com/assets/_embed.true/',

  options: {

  },

  initialize: function(options) {
    this.setOptions(options);
    this.el = this.options.el;
    var _this = this;

    if (!this.el.get('data-initialized')) {
      this.el.addEvent('click', function() {
        var gotItButton = _this.el.getParent().getParent().getElement('.got-it-v3');

        if(!_this.el.hasClass('flipped')){

          if(gotItButton){
            gotItButton.set('disabled','');
          }
          else{
            _this.el.getElement('.got-it').show();
            _this.el.getElement('.not-yet').show();
          }

            try {
                var statusContainer = $$('.status-v3')[0];
                var subStatusContainer = new Element('.sub-status-v3',{
                    html: statusContainer.get('html')
                })

                var labelStatus = subStatusContainer.getChildren('#label-status')[0]

                statusContainer.innerHTML = null
                statusContainer.adopt(labelStatus)
                statusContainer.adopt(subStatusContainer)

            } catch(e) {
                console.log(e)
            }

          window.widget_instance.pauseAudio();
            _this.el.getElement('div.content-wrapper.content-definition').show('table').focus();
          _this.flip();
        }



        return false;
      });

      this.audio_elements = this.el.getElements('.audio');
      this.audio_elements.addEvent('click', function() {
        _this.togglePlayButton(this);
        return false;
      });
      this.audio_elements.addEvent('keypress', function(e) {
        if (e.code === 13 || e.code === 32)
          this.fireEvent("click");
      });

      for (var i = 0; i < this.audio_elements.length; i++) {
        new Element('i.fa.fa-volume-off').inject(this.audio_elements[i].getElement('span'), 'top');
      };
    }
    else {
      this.el.getElement('div.controls').destroy();
    }

    injectControls(this,options);

    this.el.removeClass('active').removeClass('flipped');
    this.el.set('data-initialized', 1);
    if (window.addEventListener) {
      window.addEventListener("message", this.listenMessage, false);
    } else {
      window.attachEvent("onmessage", this.listenMessage);
    }

    $$('.card.active .back').set('aria-hidden', true);
  },

  show: function() {
    this.el.addClass('active');
    this.initAudio();

  },

  hide: function() {
    this.el.removeClass('active').removeClass('flipped');
  },

  skip: function() {
    this.options.index = -1;
    this.el.removeProperty('data-index');
    this.hide();
  },

  gotIt: function() {
    var parent_element = window.widget_instance;

    this.status = 'mastered';
    this.mastered = true;

    parent_element.disableButtonsIfisTheLastCard();

    var gotItButton = $$('.got-it-v3').set('text','Great!');
    $$('.great').set('style','display:inline');
    // $$('.great')[0].set('tabindex', 0);
    // $$('.great')[0].focus();

    if (window.IS_MAC) {
      $$('.got-it-v3').set('disabled','disabled');
    } else {
      // avoid screen reader say `unavailable` on windows
      $$('.got-it-v3').set('tabindex', '-1');
      $$('.got-it-v3').addClass('is-disabled');
    }

    setTimeout( function() {
      $$('.got-it-v3').set('text','Got it!');
      $$('.great').hide();

      parent_element.nextCard();
    }, 1000);

 },

  notYet: function(next) {
    var parent_element = window.widget_instance;

    this.status = 'not-yet',
    this.repeated = true;

    var whichIndex = this.options.index;

    setTimeout( function() {
      $$('.after-notyet-message').destroy();
      if(next){
        return parent_element.postponeCard(whichIndex);
      }
      return parent_element.prevCard(whichIndex);
    }, 500);
  },

  flip: function() {
    var parent_element = window.widget_instance,
    card_id = this.el.get('data-card-id');

    this.status = 'reviewed';
    this.reviewed = true;

    this.el.toggleClass('flipped');

    //$$('.card.active .back')[0].set('tabindex', 0);
    // $$('.card.active .back')[0].focus();
    // $$('.card.active .back').set('aria-hidden', false);

    if (parent_element.status.reviewed.indexOf(card_id) < 0) {
      parent_element.status.reviewed.push(card_id);
    }

    parent_element.render();
    parent_element.clearTimers();
    $$('.status-v3 .sub-status-v3')[0].set('tabindex',-1).focus()
    parent_element.timerIds.cardFlip = setTimeout(function(){
      $$('.card.active .back')[0].set('tabindex',-1).focus();
    },3500)

    $$('.card.active .back').set('aria-hidden', false);
    this.stopAudios();
  },

  togglePlayButton: function(button) {
    var link = button.getElement('a[data-type="audio"]');
    if (!link.hasClass('loaded')) {
      return false;
    }
    var playerId = link.get('data-audio-type');
    var icon = button.getElement('.fa');
    if(icon && icon.hasClass('fa-volume-up')) {
      icon.removeClass('fa-volume-up').addClass('fa-volume-off');
      window.sendCommandMessage(playerId, 'pause');
    } else {
      window.widget_instance.pauseAudio();
      icon.removeClass('fa-volume-off').addClass('fa-volume-up');
      window.sendCommandMessage(playerId, 'play');
    }
  },

  listenMessage: function(message) {
    var msg = {};
    try{


      // convert the stringified JSON back to JSON object
      msg.data = JSON.parse(message.data);

      //get playerId from a fallback mechanism, as a fall back on some platforms/browsers
      playerId = ((typeof msg.data.payload != "undefined")
        && msg.data.payload.playerId) ? msg.data.payload.playerId : window.getFrameTarget(message).id;

      //Make sure we are getting to the right events
      if (msg.data.type && msg.data.type == "message" && msg.data.method && msg.data.method == "publish") {
          //And we have a Media Player ready for playback event
          if(msg.data.payload.message.action == 'spp_readyForPlayback') {
              //lets enable all the buttons, now that the player is ready
              var buttonsArr = document.getElementsByTagName('button');
              $$('.active a[data-type="audio"][data-audio-type="' + playerId + '"]').addClass('loaded');
              for (var i = 0; i < buttonsArr.length; i++) {
                buttonsArr[i].disabled=false;
              }

              var gotItButton = $$('.got-it-v3');
              if(gotItButton[0]&&!$$('article.active.flipped')[0]){
                gotItButton.set('disabled','disabled');
              }

              window.sendCommandMessage(playerId, 'setVolume', params = {'percent':100});
            }

          //Playback finished, lets change the button state to "replay"
          if(msg.data.payload.message.action == 'spp_finished') {
            $$('a[data-type="audio"][data-audio-type="' + playerId + '"] .fa').removeClass('fa-volume-up').addClass('fa-volume-off');
          }
        }
    }
    catch(error){

    }
  },

  initAudio: function() {
    var audio_link;
    var _this = this;
    if (!this.audio_elements) {
      this.audio_elements = this.el.getElements('.audio');
      if (this.audio_elements) {
        this.audio_elements.addEvent('click', function() {
          _this.togglePlayButton(this);
          return false;
        });
      }
    }
    if (this.audio_elements) {
      for (var i = 0; i < this.audio_elements.length; i++) {
        if (this.audio_elements[i].hasClass('audio-init')) {
          return;
        }
        audio_link = this.audio_elements[i].getElement('a[data-type="audio"]');
        $$('.active a[data-type="audio"]').removeClass('loaded');
        $$('iframe#' + audio_link.get('data-audio-type')).set('src', this.url_prefix + audio_link.get('data-audio'));
          this.audio_elements[i].addClass('audio-init');
        };
      }

      this.stopAudios();

    },

    stopAudios: function(){
      if( $$('audio').length > 0 ){
        $$('audio').forEach(function(audio){
          audio.pause();
        });
      }
      if( $$('video').length > 0 ){
        $$('video').forEach(function(audio){
          audio.pause();
        });
      }
    },

    render: function() {
        this.el.set('data-index', this.options.index);
    }
  });

function injectControls(_this,options){
  var controls = new Element('div.controls').inject(_this.el.getElement('.back'));
  _this.controls = {
    gotIt: new Element('button.got-it', {
      html: 'Got It!',
      //'tabindex': 0
    }).inject(controls),
    notYet: new Element('button.not-yet', {
      html: 'Not Yet',
      //'tabindex': 0
    }).inject(controls),
  };
  if(_this.options){
    _this.controls.gotIt.addEvent('click', function() {
      window.widget_instance.pauseAudio();
      _this.gotIt();
      return false;
    });
  }

  _this.controls.notYet.addEvent('click', function() {
    window.widget_instance.pauseAudio();
    _this.notYet();
    return false;
  });

  _this.controls.gotIt.hide();
  _this.controls.notYet.hide();
}

/*
 * https://github.com/mootools/mootools-core/issues/2524
 * https://gist.github.com/nuxodin/9250e56a3ce6c0446efa
*/
/* focusin/out event polyfill (firefox) */
!function(){
    var w = window,
        d = w.document;

    if( w.onfocusin === undefined ){
        d.addEventListener('focus'    ,addPolyfill    ,true);
        d.addEventListener('blur'     ,addPolyfill    ,true);
        d.addEventListener('focusin'  ,removePolyfill ,true);
        d.addEventListener('focusout' ,removePolyfill ,true);
    }
    function addPolyfill(e){
        var type = e.type === 'focus' ? 'focusin' : 'focusout';
        var event = new CustomEvent(type, { bubbles:true, cancelable:false });
        event.c1Generated = true;
        e.target.dispatchEvent( event );
    }
    function removePolyfill(e){
        if(!e.c1Generated){ // focus after focusin, so chrome will the first time trigger tow times focusin
            d.removeEventListener('focus'    ,addPolyfill    ,true);
            d.removeEventListener('blur'     ,addPolyfill    ,true);
            d.removeEventListener('focusin'  ,removePolyfill ,true);
            d.removeEventListener('focusout' ,removePolyfill ,true);
        }
        setTimeout(function(){
            d.removeEventListener('focusin'  ,removePolyfill ,true);
            d.removeEventListener('focusout' ,removePolyfill ,true);
        });
    }

}();
