var show_all = false;
HotspotAssessment = new Class({
    Implements: [Options, Events],

    options: {
        delay: 2000,
    },

    hotspots: [],
    challenge_mode: false,

    initialize: function(options) {
        var _this = this;
    	this.setOptions(options);
        this.container = this.options.container;

        this.canvas = this.container.getElement('canvas');
        this.ctx = this.canvas.getContext('2d');
        this.feedback = this.container.getElement('.feedback');
        this.final_feedback = this.container.getElement('.header-feedback.score');
        this.challenge_hotspots = this.container.getElement('.challenge-hotspots').setStyles(this.options.draggable_config);
        this.quiz_image = this.container.getElement(".quiz-image");

        this.createDOM();

        this.container.getElement('.show-all').addEvent('click', function() {
            this.showAll();
        }.bind(this));
        this.container.getElement('.start-challenge').addEvent('click', function() {
            this.startChallenge();
        }.bind(this));
        this.container.getElement('.try-again').addEvent('click', function() {
            this.tryAgain();
        }.bind(this));
        this.container.getElement('.end-challenge').addEvent('click', function() {
            this.restart();
        }.bind(this));

        this.draggable = this.container.getElement('.draggable');
        this.draggable.makeDraggable({
            droppables: $$('.title'),
            onEnter: function(draggable, droppable) {
                droppable.addClass('hover');
            },
            onLeave: function(draggable, droppable) {
                _this.container.getElements('.title').removeClass('hover');
            },
            onDrop: function(draggable, droppable) {
                var delay = 0;
                if (droppable) {
                    _this.checkAnswer(draggable.get('data-hotspot-id'), droppable.getParent().get('data-hotspot-id'), droppable.getParent());
                    delay = _this.options.delay;
                }
                setTimeout(function() {
                    draggable.morph({
                        left: _this.draggable_previous_pos.left,
                        top: _this.draggable_previous_pos.top
                    });
                    _this.container.getElements('.title').removeClass('hover');
                }, delay);
            }
        });
    },

    createDOM: function() {
        this.quiz_image.setProperty('src', this.options.background.src).setStyles(this.options.background);

        var item,
            hotspots_list = new Element('ul.hotspots-list').inject(this.canvas, 'after');

        for (var i = 0; i < this.options.data.length; i++) {
            this.hotspots[i] = new Hotspot(Object.merge({
                id: i,
                el: new Element('li.droppable.list-item.list-item-' + i).inject(hotspots_list)
            }, this.options.data[i]));
        };

        this.challenge_hotspots_list = new Element('ul').inject(this.challenge_hotspots);
    },

    showAll: function(){
        var identifier = show_all ? 'fa-minus-circle' : 'fa-plus-circle';

        if (!show_all){
            this.container.getElement('.show-all').set('html', 'Hide All');
            show_all = true;

            this.container.getElements('i.fa.button').each(function(e){
                var popup = e.getParent().getParent().getElement('span.text.popup');
                popup.setStyle('display', 'block');

                if (e.hasClass('fa-plus-circle')){
                    e.removeClass('fa-plus-circle');
                    e.addClass('fa-minus-circle');
                }
            });
        } else {
            this.container.getElement('.show-all').set('html', 'Show All');
            show_all = false;

            this.container.getElements('i.fa.button').each(function(e){
                var popup = e.getParent().getParent().getElement('span.text.popup');
                popup.setStyle('display', 'none');

                if (e.hasClass('fa-minus-circle')){
                    e.removeClass('fa-minus-circle');
                    e.addClass('fa-plus-circle');
                }
            });
        }
    },

    startChallenge: function() {
        var challenge_terms = this.shuffle(this.hotspots),
            _this = this;

        this.challenge_mode = true;
        this.container.removeClass('challenge-complete');
        this.container.addClass('challenge');

        this.feedback.show();
        this.container.getElement('.note.initial').hide();
        this.container.getElement('.note.challenge').show();
        this.container.getElement('.start-challenge').hide();
        this.container.getElement('.show-all').hide();
        this.container.getElement('.try-again').setStyle('display', 'inline-block');
        this.container.getElement('.end-challenge').setStyle('display', 'inline-block');
        this.container.getElements('i.fa').hide();
        this.container.getElements('span.text.popup').setStyle('display', 'none');
        this.container.getElements('.fa-minus-circle').removeClass('fa-minus-circle').addClass('fa-plus-circle');
        this.container.getElement('.show-all').set('html', 'Show All');
        show_all = false;

        this.feedback.set('html', '');
        this.challenge_hotspots_list.set('html', '');

        for (var i = 0; i < challenge_terms.length; i++) {
            new Element('li', {
                html: '<span>' + challenge_terms[i].options.text + '</span>',
                'data-hotspot-id': challenge_terms[i].options.id
            }).setStyle('width', challenge_terms[i].options.captionWidth).inject(this.challenge_hotspots_list);
        };
        this.draggable.set('data-hotspot-id', challenge_terms[0].options.id);
        this.challenge_hotspots_list.getElement('li[data-hotspot-id="'+challenge_terms[0].options.id+'"]').show();

        var grab_position = this.options.draggable_config.grab_position;
        if (grab_position == 'TOP'){
            var draggable_calculated_top = (parseFloat(this.challenge_hotspots.getStyle('top')) - parseFloat(this.draggable.getStyle('height'))) - 10;
            var draggable_calculated_left = parseFloat(this.challenge_hotspots.getStyle('left')) + (parseFloat(this.challenge_hotspots.getStyle('width'))/2);
            this.draggable.setStyles({
                top: draggable_calculated_top,
                left: draggable_calculated_left
            });
            this.draggable_previous_pos = {
                top: draggable_calculated_top,
                left: draggable_calculated_left
            };
            this.line = {
                start: [
                    draggable_calculated_left, 
                    parseFloat(this.challenge_hotspots.getStyle('top'))
                ],
                end: [
                    parseInt(this.draggable.getStyle('left')),
                    parseInt(this.draggable.getStyle('top')) + this.draggable.getSize().y / 2
                ]
            };
        } else if (grab_position == 'BOTTOM'){
            var draggable_calculated_top = (parseFloat(this.challenge_hotspots.getStyle('top'))) + (parseFloat(this.challenge_hotspots.getStyle('height'))) + (parseFloat(this.draggable.getStyle('height')));
            var draggable_calculated_left = parseFloat(this.challenge_hotspots.getStyle('left')) + (parseFloat(this.challenge_hotspots.getStyle('width'))/2);
            this.draggable.setStyles({
                top: draggable_calculated_top,
                left: draggable_calculated_left
            });
            this.draggable_previous_pos = {
                top: draggable_calculated_top,
                left: draggable_calculated_left
            };
            this.line = {
                start: [
                    draggable_calculated_left, 
                    parseFloat(this.challenge_hotspots.getStyle('top'))
                ],
                end: [
                    parseInt(this.draggable.getStyle('left')),
                    parseInt(this.draggable.getStyle('top')) + this.draggable.getSize().y / 2
                ]
            };
        } else if (grab_position == 'LEFT'){
            var draggable_calculated_top = (parseFloat(this.challenge_hotspots.getStyle('top'))) + (parseFloat(this.challenge_hotspots.getStyle('height'))/2);
            var draggable_calculated_left = parseFloat(this.challenge_hotspots.getStyle('left')) - (parseFloat(this.draggable.getStyle('width'))) - 10;
            this.draggable.setStyles({
                top: draggable_calculated_top,
                left: draggable_calculated_left
            });
            this.draggable_previous_pos = {
                top: draggable_calculated_top,
                left: draggable_calculated_left
            };
            this.line = {
                start: [
                    parseFloat(this.challenge_hotspots.getStyle('left')), 
                    draggable_calculated_top,
                ],
                end: [
                    (draggable_calculated_left + parseFloat(this.draggable.getStyle('width'))),
                    parseInt(this.draggable.getStyle('top')) + this.draggable.getSize().y / 2
                ]
            };
        } else if (grab_position == 'RIGHT'){
            var draggable_calculated_top = (parseFloat(this.challenge_hotspots.getStyle('top'))) + (parseFloat(this.challenge_hotspots.getStyle('height'))/2);
            var draggable_calculated_left = parseFloat(this.challenge_hotspots.getStyle('left')) + (parseFloat(this.challenge_hotspots.getStyle('width'))) + (parseFloat(this.draggable.getStyle('width'))) + 10;
            this.draggable.setStyles({
                top: draggable_calculated_top,
                left: draggable_calculated_left
            });
            this.draggable_previous_pos = {
                top: draggable_calculated_top,
                left: draggable_calculated_left
            };
            this.line = {
                start: [
                    draggable_calculated_left - (parseFloat(this.challenge_hotspots.getStyle('width'))/2), 
                    draggable_calculated_top,
                ],
                end: [
                    parseInt(this.draggable.getStyle('left')),
                    parseInt(this.draggable.getStyle('top')) + this.draggable.getSize().y / 2
                ]
            };
        }
        this.render();

        this.correct_answers_on_first_try = 0;
        this.correct_on_first_try = true;

        if (grab_position == 'TOP' || grab_position == 'BOTTOM' || grab_position == 'RIGHT') {
            this.timer = setInterval(function() {
                if (_this.challenge_mode) {
                    _this.line.end = [
                        parseInt(_this.draggable.getStyle('left')),
                        parseInt(_this.draggable.getStyle('top')) + _this.draggable.getSize().y / 2
                    ];
                    _this.render();
                }
            }, 33);
        } else {
            this.timer = setInterval(function() {
                if (_this.challenge_mode) {
                    _this.line.end = [
                        parseInt(_this.draggable.getStyle('left')) + parseInt(_this.draggable.getStyle('width')),
                        parseInt(_this.draggable.getStyle('top')) + _this.draggable.getSize().y / 2
                    ];
                    _this.render();
                }
            }, 33);
        }
    },

    endChallenge: function() {
        clearTimeout(this.timer);
        this.ctx.clearRect(0, 0, 900, 600);
        this.container.removeClass('challenge').removeProperty('data-challenge');
    },

    checkAnswer: function(answer1, answer2, element) {
        var _this = this,
            offset = 0;
    
        if (answer1 == answer2) {
            this.feedback
                    .set('html', message.correct)
                    .removeClass('correct').removeClass('incorrect')
                    .addClass('correct');
            element
                    .set("tabindex", -1)
                    .addClass('answered');

            if (this.correct_on_first_try) {
                this.correct_answers_on_first_try++;
            }
            setTimeout(function() {
                _this.challenge_hotspots_list.children[0].destroy();
                if (_this.challenge_hotspots_list.children.length > 0) {
                    _this.draggable.set('data-hotspot-id', _this.challenge_hotspots_list.children[0].get('data-hotspot-id'));
                    _this.challenge_hotspots_list.children[0].show();
                }
                else {
                    _this.container.addClass('challenge-complete');

                    // Show score
                    var score = new Score(_this.hotspots.length,_this.correct_answers_on_first_try);
                    _this.final_feedback.set('html', score.getMessage());
                    _this.final_feedback.show();
                    _this.container.getElement('.note.challenge').hide();
                    
                    _this.feedback.removeProperty("aria-live");
                    
                    _this.endChallenge();
                }
            }, _this.options.delay + offset - 10);
            this.correct_on_first_try = true;
        }
        else {
            this.correct_on_first_try = false;
            this.feedback
                .set('html', message.incorrect)
                .removeClass('correct').removeClass('incorrect')
                .addClass('incorrect');
        }
            
        setTimeout(function() {
            _this.feedback.set('html', '');
        }, _this.options.delay + offset);
    },

    shuffle: function(o) {
        for(var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
        return o;
    },

    render: function() {
        this.ctx.clearRect(0, 0, 900, 600);
        this.ctx.beginPath();
        this.ctx.moveTo(this.line.start[0], this.line.start[1]);
        this.ctx.lineTo(this.line.end[0], this.line.end[1]);
        this.ctx.stroke();
    },

    tryAgain: function(){
        this.restart();
        this.startChallenge();
    },

    restart: function(){
        this.endChallenge();
        
        this.feedback.hide();
        this.container.getElement('.note.initial').show();
        this.container.getElement('.note.challenge').hide();
        this.container.getElement('.start-challenge').show();
        this.container.getElement('.show-all').show();
        this.container.getElement('.end-challenge').setStyle('display', 'none');
        this.container.getElement('.try-again').setStyle('display', 'none');
        this.container.getElements('i.fa').show();
        this.container.getElements('.droppable.answered').removeClass('answered');

        this.feedback.set('html', '');
        this.challenge_hotspots_list.set('html', '');   
    }
});

Hotspot = new Class({
    Implements: [Options, Events],

    options: {
    },

    initialize: function(options) {
        this.setOptions(options);
        this.el = this.options.el;

        var title = new Element('span.title', {
            html: this.options.title
        }).setStyles({
            left: this.options.title_position.x,
            top: this.options.title_position.y,
            width: "auto"
        }).inject(this.el);

        var button = new Element('i.fa.fa-plus-circle.button').inject(title);

        var text_popup = new Element('span.text.popup', {
            html: this.options.text
        }).setStyles({
            left: this.options.text_position.x,
            top: this.options.text_position.y,
            width: this.options.captionWidth
        }).inject(this.el);

        if (this.options.image){
            new Element('img.hotspot-img', {
                src: this.options.image
            }).inject(text_popup);
        }

        this.el.set('data-hotspot-id', this.options.id);

        button.addEvent('click', function(e){
            var popup = this.getParent().getParent().getElement('span.text.popup');
            popup.setStyle('display', popup.getStyle('display') == 'none' ? 'block' : 'none');
            if (this.hasClass('fa-plus-circle')){
                this.removeClass('fa-plus-circle');
                this.addClass('fa-minus-circle');
            } else {
                this.removeClass('fa-minus-circle');
                this.addClass('fa-plus-circle');
            }

            var count_opened = 0;
            var count_closed = 0;
            var count_all = 0;
            this.getParent().getParent().getParent().getElements('i.fa.button').each(function(e){
                if (e.hasClass("fa-minus-circle")) count_opened += 1;
                if (e.hasClass("fa-plus-circle")) count_closed += 1;
                count_all += 1;
            });
            if (count_all == count_opened){
                document.getElement('.show-all').set('html', 'Hide All');
                show_all = true;
            } else if (count_all == count_closed) {
                document.getElement('.show-all').set('html', 'Show All');
                show_all = false;
            }
        });
    }
});
