Hotspot = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        backgroundImage: 'images/elephant-organs.png',
        canvasSize: {
            x: 680,
            y: 454
        },
    },
    currentImage: 0,
    toggleHeight: 600,
    pos: 0,
    total_questions: 0,
    answered_questions: 0,
    // initialize - widget initialization
    initialize: function (options) {
        this.parent(options);
        _this = this;

        this.popups = this.container.getElements('.popup');
        this.popups.hide();

        this.instructionalLines = this.container.getElements('.hotspots-lines-container canvas');
        this.instructionalLines.hide();

        this.triggers = this.container.getElements('.trigger');

        this.hotspots_container = this.container.getElement('.hotspots-container');

        this.container.addEvent(this.clickEvent, function (e) {
            e.preventDefault();
            _this.popupToggle(e.target);
        });

        this.imageContainer = this.container.getElement('.img-container');
        this.imageContainer.setStyle('width', '680px');
        this.imageContainer.setStyle('max-width', '680px');
//
        var initialWidth = this.imageContainer.getWidth() * 80 / 100;

    },
    hidePopUps: function () {
        this.popups.hide();
        this.instructionalLines.hide();
        this.triggers.removeClass('opened');
        this.triggers.addClass('closed');
    },
    createDOM: function () {
        _this = this;
        _this.toggles = this.container.getElements('.toggle');
        _this.hotspots_lines_container = this.container.getElement('.hotspots-lines-container');

        hotspots_container = this.container.getElement('.hotspots-container');
        hotspots = this.options.data.hotspots;
        hotspots.each(function (hotspot, i) {
            if (hotspot.assessment != false) {
                _this.total_questions++;
            }
            trigger = new Element('a.trigger.closed', {
                style: 'left:' + hotspot.x + '%; top:' + hotspot.y + '%;',
                'pop-id': i,
                html: hotspot.title
            }).inject(hotspots_container);

            image = '';
            specialClass = '';
            if (hotspot.image != null) {
                image = '<div class="hotspot-image" style="background-image:url(images/' + hotspot.image + ')"></div>';
            }
            if (hotspot.leftImage == true) {
                specialClass = '.special-popup';
            }

            popup = new Element('div.popup' + specialClass, {
                html: image + '<p><strong>' + hotspot.title + '</strong> ' + hotspot.text + '</p>',
                'pop-id': i
            }).inject(hotspots_container);

            popup.style.left = hotspot.popup_x + "px";
            popup.style.top = hotspot.popup_y + "px";

            canvas = new Element('canvas', {
                width: _this.options.canvasSize.x,
                height: _this.options.canvasSize.y,
                'pop-id': i
            }).inject(_this.hotspots_lines_container);

            initial_pos_x = (_this.options.canvasSize.x * hotspot.x / 100) + 12;
            initial_pos_y = (_this.options.canvasSize.y * hotspot.y / 100) + 5;

            switch (hotspot.lineDirection) {
                case 'TOP':
                    line_to_x = initial_pos_x;
                    line_to_y = initial_pos_y;
                    line2_to_x = initial_pos_x;
                    line2_to_y = hotspot.popup_y;
                    break;
                case 'LEFT':
                    line_to_x = hotspot.popup_x;
                    line_to_y = initial_pos_y;
                    break;
                case 'BOTTOM':
                    line_to_x = initial_pos_x;
                    line_to_y = hotspot.popup_y;
                    line2_to_x = initial_pos_x;
                    line2_to_y = hotspot.popup_y;
                    break;
                case 'RIGHT':
                    line_to_x = hotspot.popup_x;
                    line_to_y = initial_pos_y;
                    break;
                default:
                    line_to_x = initial_pos_x;
                    line_to_y = hotspot.popup_y;
                    break;
            }

            var ctx = canvas.getContext("2d");
            ctx.beginPath();
            ctx.moveTo(initial_pos_x, initial_pos_y);
            ctx.lineTo(line_to_x, line_to_y);
            if (hotspot.lineDirection === 'TOP' || hotspot.lineDirection === 'BOTTOM') {
                ctx.lineTo(line2_to_x, line2_to_y + popup.clientHeight*0.5);
            }
            ctx.lineTo(hotspot.popup_x, hotspot.popup_y + popup.clientHeight*0.5);
            ctx.lineWidth = 2;
            ctx.strokeStyle = '#453789';
            ctx.stroke();
        });

    },
    popupToggle: function (trigger) {
        _this = this;
        current_trigger = trigger;
        this.popups.hide();
        this.instructionalLines.hide();
        this.triggers.removeClass('opened');

        if (current_trigger.hasClass('closed')) {
            this.triggers.addClass('closed');
            current_trigger.addClass('opened');
            current_trigger.removeClass('closed');
            id = current_trigger.get('pop-id');
            this.popups[id].show();
            this.instructionalLines[id].show();

            trigger_position = current_trigger.getPosition(_this.container.getElement('.hotspots-container'));

        } else {
            current_trigger.removeClass('opened');
            _this.triggers.addClass('closed');

            this.popups.hide();
        }


    },
    render: function () {
        this.parent();
    }
});