
HotSpot = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    imagesLoaded: false,
    originalSize: {},
    // initialize - widget initialization
    initialize: function (options) {


        _this = this;

        this.parent(options);
        this.data = this.options.data;
        this.settings = this.options.options;

        this.calculateSize();

        window.addEvent('resize', function(){
            if(!window.noResize) _this.recalculateSize();
        });

        // enable medium editor on #introductory-line
        this.initMediumEditor();
    },
    initEditroLineReDraw: function(){

        // setInterval(function(){

        // }, 500);
        _this.lines = $$('.connector-line');
        _this.lines.destroy();
        _this.createLines();
        _this.forceOpenedLines();
    },
    initHotspotEvents: function(){

        _this = this;

        this.popups = this.container.getElements('.popup');
        this.triggers = this.container.getElements('.trigger');
        this.hotspotsContainer = $$('.hotspots-container')[0];
        this.imageContainer = this.container.getElement('.img-container');

        // this.container.addEvent(this.clickEvent, function (e) {
        //     e.preventDefault();
        //     _this.popupToggle(e.target);
        // });
        setTimeout(function(){
            $('background-image').removeAttribute('aria-describedby')

        },0)

        if(this.isEditMode){

            this.triggers.makeDraggable({
                onDrag: function(draggable){
                    draggable.addClass('dragging');
                },
                onDrop: function(draggable){
                    draggable.removeClass('dragging');
                    _this.initEditroLineReDraw();
                    _this.sendDragUpdateMessage(draggable, 'trigger');
                }
            });

            this.popups.makeDraggable({
                onDrag: function(draggable){
                    draggable.addClass('dragging');
                },
                onDrop: function(draggable){
                    draggable.removeClass('dragging');
                    _this.initEditroLineReDraw();
                    _this.sendDragUpdateMessage(draggable, 'popup');
                }
            });
            this.popups.each(function(resizable){
                var handleRight  = new Element("div.handle-right.handle", {html: ""});
                handleRight.inject($(resizable));
                $(resizable).makeResizable({
                    modifiers: {
                        x: 'width',
                        y: 'height'
                    },
                    limit: {
                        x: [0, 1000],
                        y: [0, 1000]
                    },
                    handle: handleRight,
                    onComplete: function (el){
                        _this.resizeHotspot(el);
                    },
                    stopPropagation: true,
                    preventDefault: true
                });
            });

        }

    },
    sendDragUpdateMessage: function(item, type){

        // leftPX = parseInt(item.style.left);
        // topPX = parseInt(item.style.top);

        leftPX = item.style.left;
        topPX = item.style.top;

        // containerWidth = this.hotspotsContainer.getSize().x;
        // containerHeight = this.hotspotsContainer.getSize().y;

        // leftPercentual = parseFloat(leftPX * 100 / containerWidth).toFixed(2);
        // topPercentual = parseFloat(topPX * 100 / containerWidth).toFixed(2);

        id = item.get('hotspot-id');

        switch(type){
            case 'trigger':
                // this.data[id].x = leftPercentual;
                // this.data[id].y = topPercentual;
                this.data[id].x = leftPX;
                this.data[id].y = topPX;
            break;
            case 'popup':
                // this.data[id].px = leftPercentual;
                // this.data[id].py = topPercentual;
                this.data[id].px = leftPX;
                this.data[id].py = topPX;
            break;

        }

        this.saveData().then(
            function (response){
                if (parent && parent != window) {
                    parent.postMessage({
                        method: 'moved-item',
                        item:{
                            type: type,
                            // left: leftPercentual,
                            // top: topPercentual,
                            left: leftPX,
                            top: topPX,
                            id: id
                        }
                    },"*");
                }

            }, function (error){
                console.warn(error);

            }
        );

    },
    resizeHotspot: function(item){
        _this = this;
        itemHeight = item.getStyle("height");
        itemWidth = item.getStyle("width");
        id = item.get('hotspot-id');
        this.data[id].itemHeight = itemHeight;
        this.data[id].itemWidth = itemWidth;

        this.saveData().then(
            function (response){
                if (parent && parent != window) {
                    parent.postMessage({
                        method: 'resize-item',
                        item:{
                            type: "resize",
                            height: itemHeight,
                            width: itemWidth,
                            id: id
                        }
                    },"*");
                }

            }, function (error){
                console.warn(error);

            }
        );
        // this.options.data.each(function (item, index) {
        //     if (index == id) {
        //         var new_term = {title: item.title, text: item.text, image: item.image, x: item.x, y: item.y, px: item.px, py: item.py, itemHeight: itemHeight, itemWidth: itemWidth };
        //         _this.options.data[index] = new_term;

        //     }
        // });
        // this.saveRequest({method: 'mdData', options: {'json': this.options.data}});

    },
    recalculateSize: function () {

        this.lines = $$('.connector-line');
        this.lines.destroy();
        this.createLines();
        this.closePopups();


    },
    resizeWidgetBody: function() {
        //console.log($('background-image').width);
        //var _this = this;
        //var _height = ($(window).getWidth() - 30) * _this.originalSize.y /  _this.originalSize.x;
        //console.log( _height );
        //alert(  window.innerWidth );
        //$$('.widget-body')[0].setStyles({
            //height: _height + 'px'
        //});
    },
    calculateSize:  function(){
        _this = this;
        $('MetrodigiWidget').addClass('loading-back-image');
        backgroundImage = $$('#background-image')[0];
        this.hotspotsContainer = $$('.hotspots-container')[0];
        this.hotspotsContainer.innerHTML = '';
        images = [backgroundImage.src];
        this.options.data.each(function(hotspot, i){
            if(hotspot.image){
                images.push(hotspot.image.path);
            }
        });

        window.addEvent('resize', _this.resizeWidgetBody.bind(this));


        if(!_this.imagesLoaded){

            Asset.images(images, {
                onProgress: function(counter, index, source) {
                    //console.log('LOADED IMAGE -> ' + i);
                    _this.originalSize.x = this.width;
                    _this.originalSize.y = this.height;
                    _this.resizeWidgetBody();
                },
                onComplete: function(params) {
                    // console.log('LOADED ALL IMAGES');
                    // console.log('INIT WIDGET');

                    // _this.hotspotsContainer.setStyles({
                    //     width: backgroundImage.width,
                    //     height: backgroundImage.height
                    // });



                    setTimeout(function(){
                        _this.createHotspots();
                        _this.initHotspotEvents();
                    }, 300);

                    //console.log($$('.hotspots-container')[0].getSize().y);
                    //console.log( params, this );

                    _this.imagesLoaded = true;
                    $('MetrodigiWidget').removeClass('loading-back-image');
                }
            });

        }

    },
    createHotspots: function () {

        _this = this;

        hotspots_container = this.container.getElement('.hotspots-container');
        this.options.data.each(function (hotspot, i) {

            // console.log('hotspot', hotspot.text);
            // console.log(_this.htmlDecode(hotspot.text));
            // console.log('==================');

            text = hotspot.text;
            decodedText = _this.htmlDecode(hotspot.text);

            if(decodedText){
                text = decodedText;
            }

            invisibleClass = '';
            if(_this.settings.invisibleHotspots){
                invisibleClass = '.invisible-hotspots';
            }

            hotspotStyleClass = '';
            if(_this.settings.iconHotspot){
                hotspotStyleClass = '.icon';
            }

            var year = _this.getYearFromText(hotspot.text.replace(/&lt;p&gt;/gi,'').stripTags())

            trigger = new Element('button.trigger' + hotspotStyleClass + invisibleClass, {
                style: 'left:' + hotspot.x + '; top:' + hotspot.y + ';',
                'hotspot-id': i,
                html: hotspot.title,
                'aria-label': 'Hotspot: '+ hotspot.title +', '+ year +'. learn more.',
                'aria-pressed': 'false',
            }).inject(hotspots_container);

            trigger.addEvent('click', function(){
                _this.popupToggle(this)
            })

            if(hotspot.image.path){
                var ariaDescribedby = "";
                var longstatic = "";
                if(typeof accessibility_data != 'undefined'){
                    if(accessibility_data.images != 'undefined' && accessibility_data.images != null){
                        Array.each(accessibility_data.images, function (item) {
                            var src = hotspot.image.path;
                            var n = src.lastIndexOf('/');
                            var final_src = src.substring(n + 1);
                            if (final_src === item.src){
                                ariaDescribedby = 'aria-describedby="longstatic"';
                                longstatic = '<div id="longstatic" style="display:none">' + item.altLong + '</div>';
                            }
                        });
                    }
                }
                popupHTML = '<img src="' + hotspot.image.path + '"  alt="' + hotspot.image.alt + '" '+ ariaDescribedby+' />' + longstatic
            }else if(hotspot.text){
                if(hotspot.title !=""){
                    popupHTML = '<div class="text-container"><span class="title">' + hotspot.title + '</span> ' + text + '</div>';
                }else{
                    popupHTML = '<div class="text-container"><span class="title no-padding">' + hotspot.title + '</span> ' + text + '</div>';
                }
            }else{
                popupHTML = '<div class="text-container">Please Add content</div>';
            }
            var closeButton = '<button  aria-label="Close" class="close-dialog-button">×</button>'
            popup = new Element('div.popup', {
                html: popupHTML + closeButton,
                'hotspot-id': i,
                id: 'hotspot_'+i
            }).inject(hotspots_container);

            popup.addEvent('click',function(){
                _this.popupToggle(this)
            })

            $$('[hotspot-id="'+ i +'"] .close-dialog-button').addEvent('click',function(e){

                e.preventDefault();
                e.stopPropagation();
                var selector = '[hotspot-id='+ i + ']'
                _this.closePopUp($$(selector + '.trigger')[0] , i)

            })

            popup.style.left = hotspot.px;// + "%";
            popup.style.top = hotspot.py;// + "%";
            if(hotspot.itemHeight != "")
            {
                popup.style.height = hotspot.itemHeight;
                popup.style.width = hotspot.itemWidth;
            }

        });
        parent.postMessage({
            method: 'hide-resize-input',
            item:{
                value: true
            }
        },"*");
        this.createLines();

        // inject alt, altLong
        this.accessibilityAltSearch();
    },

    getYearFromText(text){
        return text.substring(0, 4);
    },
    createLines: function () {
        this.options.data.each(function (hotspot, i) {
            _this.connect($$('div.popup')[i], $$('.trigger')[i], "#4E148D", 2, i);
        });
    },
    connect: function (div1, div2, color, thickness, id) {
        // console.log('CONNECT');
        // console.log('div1', div1);
        // console.log('div2', div2);
        var off, off2, x1, y2, x2, y2, length, cx, cy, angle = null;

        //scaleFactor = 1;
        off1 = this.getOffset(div1);
        off2 = this.getOffset(div2);
        //console.log(scaleFactor);
        console.log( off1, off2 , id);
        if(off1 && off2){
            // bottom right
            x1 = off1.left + off1.width;
            y1 = off1.top + off1.height;
            //x1*=scaleFactor;
            //y1*=scaleFactor;
            // top right
            x2 = off2.left + off2.width;
            y2 = off2.top + off1.height - (off1.height - 13);
            //y2*=scaleFactor;
            //y2*=scaleFactor;
            // distance
            length = Math.sqrt(((x2-x1) * (x2-x1)) + ((y2-y1) * (y2-y1)));
            //length*=scaleFactor;
            // center
            cx = ((x1 + x2) / 2) - (length / 2);
            cy = ((y1 + y2) / 2) - (thickness / 2);
            // angle
            angle = Math.atan2((y1-y2),(x1-x2))*(180/Math.PI);
            // make hr
            //cx*=scaleFactor;
            //cy*=scaleFactor;
            htmlLine = new Element('div', {
                'hotspot-id': id,
                'class': 'connector-line',
                'styles': {
                    'height': thickness + 'px',
                    'background-color': color,
                    'line-height': '1px',
                    'position': 'absolute',
                    'left': cx + 'px',
                    'top': cy + 'px',
                    'width': length + 'px',
                    'transform': 'rotate(' + angle + 'deg)'
                }
            })
            $(document).getElement('body').grab(htmlLine);
        }
    },
    getOffset: function (el) {
        var rect = {};
        if( typeof el == 'undefined') {
            return;
        }

        rect = el.getBoundingClientRect();

        var body = document.body,
            scaleFactor = window._current_scale || 1
        ;

        return {
            left: rect.left/scaleFactor + window.pageXOffset,
            top: rect.top/scaleFactor + window.pageYOffset,
            width: rect.width/scaleFactor / 2,
            height: rect.height/scaleFactor / 2
        };
    },
    openPopUp: function(trigger, id){
        this.popups[id].addClass('active');
        this.lines[id].addClass('active');
        trigger.addClass('active');
        trigger.set('aria-pressed', 'true');
        trigger.set('aria-describedby', 'hotspot_'+id);

        // $$('[hotspot-id='+ id +'] .close-dialog-button')[0].set('tabindex', 0).focus()
        var textContainer = $$('[hotspot-id='+ id +'] .text-container')[0];
        var image = $$('[hotspot-id='+ id +'] img')[0];
        if (textContainer) {
            textContainer.set('tabindex', -1).focus();
            textContainer.getNext('button').set('tabindex', '0');
        } else if (image) {
            image.set('tabindex', -1).focus();
            image.getNext('button').set('tabindex', '0');
        } else {
            this.popups[id].set('tabindex', '-1').focus();
        }

        window.noResize = true;
        setTimeout(function(){ window.noResize = false }, 200)
    },
    closePopUp: function(trigger, id){
        this.popups[id].removeClass('active');
        this.popups[id].getElement('button').set('tabindex', -1)
        this.lines[id].removeClass('active');
        trigger.removeClass('active');
        trigger.focus();
        trigger.set('aria-pressed', 'false');
        trigger.removeAttribute('aria-describedby');
    },
    closePopups: function(){
        if(this.popups)
            this.popups.removeClass('active');
        this.lines.removeClass('active');
        if(this.triggers){
            this.triggers.removeClass('active');
            this.triggers.set('aria-pressed', 'false');
            this.triggers.forEach(function(el){
                el.removeAttribute('aria-describedby');
            });
        }
    },
    popupToggle: function (trigger) {
        _this = this;
        this.lines = $$('.connector-line');

        if(!trigger.hasClass('trigger')){
            if(trigger.hasClass('popup')){
                currentTrigger = this.triggers[trigger.get('hotspot-id')];
            }else if(!trigger.hasClass('popup')){
                if(trigger.getParents('.popup')[0]){
                    id = trigger.getParents('.popup')[0].get('hotspot-id');
                    currentTrigger = this.triggers[id];
                }else{
                    this.closePopups();
                    return
                }
            }
        }else if(trigger.hasClass('trigger')){
            currentTrigger = trigger;
        }

        id = currentTrigger.get('hotspot-id');

        action = 'open';
        if(currentTrigger.hasClass('active')){
            action = 'close';
        }
        if(this.settings.concurrentHotspots == false){
            if(action == 'open'){
                this.closePopups();
                this.openPopUp(currentTrigger, id);
            }else{
                this.closePopUp(currentTrigger, id);
            }
        } else if(this.settings.concurrentHotspots ==  true){
            if(action == 'open'){
                this.openPopUp(currentTrigger, id);
            }else{
                this.closePopUp(currentTrigger, id);
            }
        }

    },
    forceOpenedLines: function(){
        $$('.trigger.active').each(function(trigger, i){
            $$('.connector-line[hotspot-id="'+trigger.get('hotspot-id')+'"]').addClass('active');
        });
    },
    render: function () {
        this.parent();
    },
    htmlDecode: function(input){
      var e = document.createElement('div');
      e.innerHTML = input;
      return e.childNodes.length === 0 ? "" : e.childNodes[0].nodeValue;
    },
    saveRequestPromise: function (request) {
        var that = this;

        return new Promise(function (resolve, reject){
            var formData = new FormData();
            var xhr = new XMLHttpRequest();

            request.path = '';
            request = JSON.stringify(request);
            formData.append('savedata', request);
            formData.append('widget_id', that.widget_id);

            xhr.open('POST', that.root + 'api/index.php/save/');
            xhr.onload = function () {
                if (xhr.status === 200) {
                    var response = JSON.parse(xhr.responseText);

                    resolve('Saved!');

                } else {
                    reject(xhr.status + ' ' + xhr.responseText)
                }
            };

            xhr.send(formData);
        });
    },
    saveDataOptions: function (){
        console.log('SAVE DATA OPTIONS');
        console.log('this.settings', this.settings);
        var request = {
            method: "mdDataByID",
            selector: "#md-widget-data-options",
            variable_name: 'options',
            path: '',
            options: {
                json: this.settings
            }
        };

        return this.saveRequestPromise(request);
    },
    saveData: function (){

        console.log('======= SAVE DATA =======');
        console.log(this.data);
        dataJSON = this.data
        var request = {
            method: "mdDataByID",
            selector: "#md-widget-data",
            variable_name: 'data',
            path: '',
            options: {
                json: dataJSON
            }
        };

        return this.saveRequestPromise(request);
    },
    updateWidgetFromSettings: function(){
        console.log('updateWidgetFromSettings');
        console.log('this.settings', this.settings);

        if(this.settings.iconHotspot){
            this.triggers.addClass('icon');
        }else{
            this.triggers.removeClass('icon')
        }

        if(this.settings.invisibleHotspots){
            this.triggers.addClass('invisible-hotspots');
        }else{
            this.triggers.removeClass('invisible-hotspots')
        }

    },
    customPostMessages: function (message) {
        var _this = this;
        console.log('message.data', message.data);
        console.log('this.data', this.data);

        //if(this.container.getElement('#background-image').get('src') != ''){

        if (parent && parent != window) {
            parent.postMessage({
                method: 'update-image',
                target: _this.container.getElement('#background-image').get('src')
            },"*");
        }

            //$(".drag-zone-other-options-button.filled").appendHTML('MANTEAJKSHD')

        // }

        switch (message.data.method) {

            case 'backgroundimg-change':
                if(message.data.image_url !=""){
                    this.container.getElement('#background-image').set('src', message.data.image_url);
                    this.saveRequest({method: 'mdSetAttribute', options: {selector: '#background-image', attribute: 'src', value: message.data.image_url}});
                }
                else{
                    this.container.getElement('#background_image').set('src', '');
                    this.saveRequest({method: 'mdSetAttribute', options: {selector: '#background-image', attribute: 'src', value: ''}});
                }
            break;
            case 'addImage':
                if(message.data.image_name !=""){
                    $('background-image').set('src', message.data.image_name);
                    $('background-image').removeClass('non-accessible');
                    this.saveRequest({method: 'mdSetAttribute', options: {selector: '#background-image', attribute: 'src', value: message.data.image_name}});
                    if($('background-image').get('src') == message.data.image_name){
                        this.sendPostMessages('background_placed', {} );
                    }
                }
                else{
                    $('background-image').set('src', '');
                    $('background-image').addClass('non-accessible');
                    this.saveRequest({method: 'mdSetAttribute', options: {selector: '#background-image', attribute: 'src', value: ''}});
                    if($('background-image').get('src') == ''){
                        this.sendPostMessages('background_removed', {} );
                    }
                }
            break;
            case "setting-change":

                newSettings = JSON.parse(message.data.settings)

                this.settings = newSettings

                this.saveDataOptions().then(function (response){
                    _this.updateWidgetFromSettings();
                }, function (error){
                    console.warn(error);
                });

            break;
       }
   },
});
