/***
 * The commented-out code is the old, deprecated version. This is a copy of identify-v2.js
 * We should remove this file, but currently Davies relies on it (ch07)
 **/

CustomWidget = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    // Set initial options here
    options: {
        data: {
            img: {
                // width: 700,
                // height: 510,
                width: 672,
                height: 490,
                scale: 1
            }
        }
    },
    bubbles: {},
    total: 0,
    // initialize - widget initialization
    initialize: function (options) {
        var _this = this,
            reset = function () {
                var button = this;
                _this.container.set("data-stage", 1);
                _this.feedback.set('text', '').set("data-state", "");
                _this.bubbles = {};
                _this.total = 0;
                _this.container.getElements('.bubble').each(function (bubble) {
                    var id = parseInt(Math.random(0, 100) * 100);
                    bubble.set("data-state", "1").set("data-id", id);
                    bubble.getElements(".option").each(function (option) {
                        option.set("data-state", null);
                    });
                    _this.bubbles[id] = false;
                    _this.total++;
                });
                $$(".bubble[data-state='1'] .bubbleState1")[0].focus();
            };

        this.parent(options);
        this.feedback = this.container.getElement('.feedbackTxt');
        this.reset = this.container.getElement('.widget-footer button.reset');
        this.start = this.container.getElement('.widget-footer button.start');
        this.end = this.container.getElement('.widget-footer button.end');
        this.start.show();

        var startEventHandler = function () {
            _this.end.show();
            _this.start.hide();
            reset();
        };
        _this.container.getElements('.bubble').each(function (bubble) {
            var id = parseInt(Math.random(0, 100) * 100);
            bubble.set("data-id", id);
            _this.bubbles[id] = false;
            _this.total++;
        });
        this.start.addEvent(this.clickEvent, startEventHandler);
        this.reset.addEvent(this.clickEvent, reset);
        this.end.addEvent(this.clickEvent, function () {
            reset();
            var bubbles = _this.container.getElements('.bubble');
            for (var i = 0; i < bubbles.length; i++) {
                bubbles[i].set('data-state', 3);
                _this.start.show();
                _this.end.hide();
            }
        });

        this.render();
        _this.container.set("data-stage", "1");
    },
    // Add any helper methods here
    clearCanvas: function () {
        var _this = this;
        _this.ctx.clearRect(0, 0, 1500, 1500);
    },
    // render - updates the widget display
    render: function () {
        var _this = this;
        this.parent();

        var canvas = this.container.getElement("canvas");
        _this.ctx = canvas.getContext("2d");
        _this.ctx.width = canvas.width;
        _this.ctx.height = canvas.height;
        var lines = function (arr) {
                var size = {
                    x: 100,
                    y: 100
                };

                arr.forEach(function (bubble) {
                    var data = JSON.parse(bubble.get("data-line"));
                    data.line.forEach(function (line) {
                        if ('orientation' in line) {
                            switch (line.orientation) {
                            case 'top':
                                plot({
                                    x: data.x + (size.x / 2),
                                    y: data.y + size.y
                                }, {
                                    x: data.x + (size.x / 2),
                                    y: line.stop.y
                                }, line.stop);
                                break;
                            case 'right':
                                plot({
                                    x: data.x,
                                    y: data.y + (size.y / 2)
                                }, {
                                    x: line.stop.x,
                                    y: data.y + (size.y / 2)
                                }, line.stop);
                                break;
                            case 'bottom':
                                plot({
                                    x: data.x + (size.x / 2),
                                    y: data.y
                                }, {
                                    x: data.x + (size.x / 2),
                                    y: line.stop.y
                                }, line.stop);
                                break;
                            case 'left':
                                plot({
                                    x: data.x + size.x,
                                    y: data.y + (size.y / 2)
                                }, {
                                    x: line.stop.x,
                                    y: data.y + (size.y / 2)
                                }, line.stop);
                                break;
                            }
                        } else {
                            drawLine(line.start, line.stop)
                        }
                    });
                });
            },
            plot = function (start, mid, stop) {
                drawLine(start, mid);
                drawLine(mid, stop);
            },
            drawLine = function (start, stop) {
                _this.ctx.moveTo(start.x, start.y);
                _this.ctx.lineTo(stop.x, stop.y);
                _this.ctx.stroke();
            },
            img = new Image();
        img.src = _this.options.data.img.src;
        img.onload = function () {
             _this.ctx.drawImage(img, (_this.options.data.img.width * (1 - _this.options.data.img.scale))/2 + 15, (_this.options.data.img.height * (1 - _this.options.data.img.scale))/2, _this.options.data.img.width * _this.options.data.img.scale, _this.options.data.img.height * _this.options.data.img.scale);
            $$('.stageWrap')[0].setStyle('background',
                'url(' + img.src + ') no-repeat scroll 50% 50% transparent'
            );
            lines($$('.bubble'));
        };

        document.body.addEvent(this.clickEvent, function () {
            _this.closeBubbles();
        });
        this.container
            .addEvent(this.clickEvent + ':relay(.bubbleClick)', function (e, i) {
                e.stopPropagation();
                if (_this.container.get("data-stage") === "0") return;
                _this.closeBubbles();
                if (i.getParent('.bubble').get("data-state") === '1') {
                    i.getParent('.bubble').set("data-state", "2");
                }
                if (_this.keyboard_access)
                    i.getParent('.bubble').getElement(".dropdown button").focus();
            })
            .addEvent(this.clickEvent + ':relay(.btnClick)', function (e, i) {
                e.stopPropagation();

                var id = i.getParent('.bubble').get("data-id"),
                    correct = i.getParent('.bubble').getElement('.answer').get('text'),
                    answer = i.getFirst('div').get('text');

                _this.setAll(_this.container.getElements('.option'), 'state', '');

                if (correct === answer) {
                    i.set("data-state", "yes");
                    _this.feedback.set('text', 'Correct!').set("data-state", "green");

                    if (!_this.bubbles[id]) _this.bubbles[id] = 1;

                    setTimeout(function () {
                        i.getParent('.bubble').set("data-state", "3");
                        _this.feedback.set('text', '').set("data-state", "");
                        _this.checkFinish();
                        if ($$(".bubble[data-state='1'] .bubbleState1").length > 0)
                            $$(".bubble[data-state='1'] .bubbleState1 button")[0].focus();
                    }, 1200);
                } else {
                    _this.bubbles[id] = true;
                    i.set("data-state", "no");
                    _this.feedback.set('text', 'Incorrect. Try again.').set("data-state", "red");

                    setTimeout(function () {
                        _this.feedback.set('text', '').set("data-state", "");
                    }, 1200);
                }
            });

        this.container
            .addEvent("keypress:relay(div.bubbleState1.bubbleClick)", function (e, i) {
                _this.keyboard_access = true;
                if (e.key == "enter") {
                    _this.closeBubbles();
                    if (i.getParent('.bubble').get("data-state") === '1') {
                        i.getParent('.bubble').set("data-state", "2");
                    }
                    i.getParent('.bubble').getElement("button").focus();
                }
            })
    },
    closeBubbles: function () {
        this.container.getElements('.bubble').forEach(function (el, i) {
            if (el.get("data-state") === '2') {
                el.set("data-state", "1");
            }
        });
    },
    createDOM: function () {
        var bubbles = this.container.getElements('.bubble');

        for (var i = 0; i < bubbles.length; i++) {
            var bubble = bubbles[i];

            new Element('div.bubbleState3.bubbleClick', {
                html: "<div class='answer'>" + bubble.get('data-correct-answer') + "</div>"
            }).inject(bubble, 'top');
            new Element('div.bubbleState2.bubbleClick', {
                html: "<div class='questionMark'>?</div>"
            }).inject(bubble, 'top');
            new Element('div.bubbleState1.bubbleClick', {
                html: "<button tabindex='" + i + "'><span class='responsive-call-to-action'>Click or tap</span> to identify</button>"
                    //"tabindex":i
            }).inject(bubble, 'top');

            bubble
            //.set("tabindex", i)
                .set('data-state', 3)
                .addClass('bubble' + (i + 1))
                .setStyles({
                    left: +bubble.get('data-position-x'),
                    top: +bubble.get('data-position-y')
                });

            this.createDropdown(bubble, i);
        }
        this.insertActionText();
    },
    setAll: function (arr, dataAtt, value) {
        arr.forEach(function (el, i, arr) {
            el.set("data-" + dataAtt, value);
        });
    },
    checkFinish: function () {
        var check = this.container.getElements('.bubble').every(function (bubble) {
            return bubble.get("data-state") === '3';
        });
        if (check) {
            var count = 0,
                score;
            console.log(this.bubbles);
            for (var i in this.bubbles) {
                count = count + (this.bubbles[i] === 1 ? 1 : 0);
            }
            score = new Score(this.total, count);
            this.feedback.set('text', score.getMessage()).set("data-state", "green");

            this.container.set("data-stage", "2");
            if ($$(".reset").length > 0) $$(".reset")[0].focus();
            else if ($$(".end").length > 0) $$(".end")[0].focus();
        }
    },
    createDropdown: function (el, i) {
        var dropdown = el.getElement('.dropdown'),
            options = dropdown.get('data-options').split(',');

        dropdown
            .addClass('dropdown' + i)
            .addClass("options-count-" + options.length)
            .addClass('dropdown' + dropdown.get('data-type'));

        for (var j = 0; j < options.length; j++) {
            new Element('div.option.btnClick', {
                html: "<div><button tabindex='" + i + "'>" + options[j] + "</button></div><span class='optIcon'></span>",
                'data-state': ''
                    /*,
                                    'tabindex': i*/
            }).inject(dropdown);
        }
    }
});








//
//CustomWidget = new Class({
//    Implements: [Options, Events],
//    Extends: MetrodigiWidget,
//    // Set initial options here
//    options: {
//        data: {
//            img: {
//                // NOTE: Default image values are propagated in "initialize"
//                // width: 700,
//                // height: 510,
//                // width: 672,
//                // height: 490,
//                // scale: 1
//            }
//        }
//    },
//    bubbles: {},
//    total: 0,
//    // initialize - widget initialization
//    initialize: function (options) {
//
//        window.addEvent("mousemove", function () {
//            document.getElement("body").addClass("remove-outline");
//        }).addEvent("keyup", function (e) {
//            if (e.key == "tab") {
//                document.getElement("body").removeClass("remove-outline");
//            }
//        });
//
//        var _this = this;
//    
//        /**********
//         * Default img values if none are passed in:
//          ********/
//        _this.options.data.img.width = _this.options.data.img.width || 672;
//        _this.options.data.img.height = _this.options.data.img.height || 490;
//        _this.options.data.img.scale = _this.options.data.img.scale || 1;
//        
//    
//        var reset = function () {
//                var button = this;
//                _this.container.set("data-stage", 1);
//                _this.feedback.set('text', '').set("data-state", "");
//                _this.bubbles = {};
//                _this.total = 0;
//                _this.container.getElements('.bubble').each(function (bubble) {
//                    var id = parseInt(Math.random(0, 100) * 100);
//                    bubble.set("data-state", "1").set("data-id", id);
//                    bubble.getElements(".option").each(function (option) {
//                        option.set("data-state", null);
//                    });
//                    _this.bubbles[id] = false;
//                    _this.total++;
//                });
//                $$(".bubble[data-state='1'] .bubbleState1")[0].focus();
//            };
//
//        this.parent(options);
//        this.feedback = this.container.getElement('.feedbackTxt');
//        this.reset = this.container.getElement('.widget-footer button.reset');
//        this.start = this.container.getElement('.widget-footer button.start');
//        this.end = this.container.getElement('.widget-footer button.end');
//
//        var startEventHandler = function () {
//            _this.container.set("data-stage", "1");
//            $$(".bubble[data-state='1'] .bubbleState1 button")[0].focus();
//        };
//        _this.container.getElements('.bubble').each(function (bubble) {
//            var id = parseInt(Math.random(0, 100) * 100);
//            bubble.set("data-id", id);
//            _this.bubbles[id] = false;
//            _this.total++;
//        });
//        this.start.addEvent(this.clickEvent, startEventHandler);
//        this.reset.addEvent(this.clickEvent, reset);
//        this.end.addEvent(this.clickEvent, reset);
//
//        this.render();
//        _this.container.set("data-stage", "1");
//    },
//    // Add any helper methods here
//    clearCanvas: function () {
//        var _this = this;
//        _this.ctx.clearRect(0, 0, 1500, 1500);
//    },
//    // render - updates the widget display
//    render: function () {
//        var _this = this;
//        this.parent();
//
//        var canvas = this.container.getElement("canvas");
//        _this.ctx = canvas.getContext("2d");
//        _this.ctx.width = canvas.width;
//        _this.ctx.height = canvas.height;
//        var lines = function (arr) {
//                var size = {
//                    x: 100,
//                    y: 100
//                };
//
//                arr.forEach(function (bubble) {
//                    var data = JSON.parse(bubble.get("data-line"));
//                    data.line.forEach(function (line) {
//                        if ('orientation' in line) {
//                            switch (line.orientation) {
//                            case 'top':
//                                plot({
//                                    x: data.x + (size.x / 2),
//                                    y: data.y + size.y
//                                }, {
//                                    x: data.x + (size.x / 2),
//                                    y: line.stop.y
//                                }, line.stop);
//                                break;
//                            case 'right':
//                                plot({
//                                    x: data.x,
//                                    y: data.y + (size.y / 2)
//                                }, {
//                                    x: line.stop.x,
//                                    y: data.y + (size.y / 2)
//                                }, line.stop);
//                                break;
//                            case 'bottom':
//                                plot({
//                                    x: data.x + (size.x / 2),
//                                    y: data.y
//                                }, {
//                                    x: data.x + (size.x / 2),
//                                    y: line.stop.y
//                                }, line.stop);
//                                break;
//                            case 'left':
//                                plot({
//                                    x: data.x + size.x,
//                                    y: data.y + (size.y / 2)
//                                }, {
//                                    x: line.stop.x,
//                                    y: data.y + (size.y / 2)
//                                }, line.stop);
//                                break;
//                            }
//                        } else {
//                            drawLine(line.start, line.stop)
//                        }
//                    });
//                });
//            },
//            plot = function (start, mid, stop) {
//                drawLine(start, mid);
//                drawLine(mid, stop);
//            },
//            drawLine = function (start, stop) {
//                _this.ctx.moveTo(start.x, start.y);
//                _this.ctx.lineTo(stop.x, stop.y);
//                _this.ctx.stroke();
//            },
//            img = new Image();
//        img.src = _this.options.data.img.src;
//        img.onload = function () {
//             _this.ctx.drawImage(img, (_this.options.data.img.width * (1 - _this.options.data.img.scale))/2 + 15, (_this.options.data.img.height * (1 - _this.options.data.img.scale))/2, _this.options.data.img.width * _this.options.data.img.scale, _this.options.data.img.height * _this.options.data.img.scale);
//            $$('.stageWrap')[0].setStyle('background',
//                'url(' + img.src + ') no-repeat scroll 50% 50% transparent'
//            );
//            lines($$('.bubble'));
//        };
//
//        document.body.addEvent(this.clickEvent, function () {
//            _this.closeBubbles();
//        });
//        this.container
//            .addEvent(this.clickEvent + ':relay(.bubbleClick)', function (e, i) {
//                e.stopPropagation();
//                if (_this.container.get("data-stage") === "0") return;
//                _this.closeBubbles();
//                if (i.getParent('.bubble').get("data-state") === '1') {
//                    i.getParent('.bubble').set("data-state", "2");
//                }
//                if (_this.keyboard_access)
//                    i.getParent('.bubble').getElement(".dropdown button").focus();
//            })
//            .addEvent(this.clickEvent + ':relay(.btnClick)', function (e, i) {
//                e.stopPropagation();
//
//                var id = i.getParent('.bubble').get("data-id"),
//                    correct = i.getParent('.bubble').getElement('.answer').get('text'),
//                    answer = i.getFirst('div').get('text');
//
//                _this.setAll(_this.container.getElements('.option'), 'state', '');
//
//                if (correct === answer) {
//                    i.set("data-state", "yes");
//                    _this.feedback.set('text', 'Correct!').set("data-state", "green");
//
//                    if (!_this.bubbles[id]) _this.bubbles[id] = 1;
//
//                    setTimeout(function () {
//                        i.getParent('.bubble').set("data-state", "3");
//                        _this.feedback.set('text', '').set("data-state", "");
//                        _this.checkFinish();
//                        if ($$(".bubble[data-state='1'] .bubbleState1").length > 0)
//                            $$(".bubble[data-state='1'] .bubbleState1 button")[0].focus();
//                    }, 1200);
//                } else {
//                    _this.bubbles[id] = true;
//                    i.set("data-state", "no");
//                    _this.feedback.set('text', 'Incorrect. Try again.').set("data-state", "red");
//
//                    setTimeout(function () {
//                        _this.feedback.set('text', '').set("data-state", "");
//                    }, 1200);
//                }
//            });
//
//        this.container
//            .addEvent("keypress:relay(div.bubbleState1.bubbleClick)", function (e, i) {
//                _this.keyboard_access = true;
//                if (e.key == "enter") {
//                    _this.closeBubbles();
//                    if (i.getParent('.bubble').get("data-state") === '1') {
//                        i.getParent('.bubble').set("data-state", "2");
//                    }
//                    i.getParent('.bubble').getElement("button").focus();
//                }
//            })
//    },
//    closeBubbles: function () {
//        this.container.getElements('.bubble').forEach(function (el, i) {
//            if (el.get("data-state") === '2') {
//                el.set("data-state", "1");
//            }
//        });
//    },
//    createDOM: function () {
//        var bubbles = this.container.getElements('.bubble');
//
//        for (var i = 0; i < bubbles.length; i++) {
//            var bubble = bubbles[i];
//
//            new Element('div.bubbleState3.bubbleClick', {
//                html: "<div class='answer'>" + bubble.get('data-correct-answer') + "</div>"
//            }).inject(bubble, 'top');
//            new Element('div.bubbleState2.bubbleClick', {
//                html: "<div class='questionMark'>?</div>"
//            }).inject(bubble, 'top');
//            new Element('div.bubbleState1.bubbleClick', {
//                html: "<button tabindex='" + i + "'><span class='responsive-call-to-action'>Click or tap</span> to identify</button>"
//                    //"tabindex":i
//            }).inject(bubble, 'top');
//
//            bubble
//            //.set("tabindex", i)
//                .set('data-state', 1)
//                .addClass('bubble' + (i + 1))
//                .setStyles({
//                    left: +bubble.get('data-position-x'),
//                    top: +bubble.get('data-position-y')
//                });
//
//            this.createDropdown(bubble, i);
//        }
//        this.insertActionText();
//    },
//    setAll: function (arr, dataAtt, value) {
//        arr.forEach(function (el, i, arr) {
//            el.set("data-" + dataAtt, value);
//        });
//    },
//    checkFinish: function () {
//        var check = this.container.getElements('.bubble').every(function (bubble) {
//            return bubble.get("data-state") === '3';
//        });
//        if (check) {
//            var count = 0,
//                score;
//            console.log(this.bubbles);
//            for (var i in this.bubbles) {
//                count = count + (this.bubbles[i] === 1 ? 1 : 0);
//            }
//            score = new Score(this.total, count);
//            this.feedback.set('text', score.getMessage()).set("data-state", "green");
//
//            this.container.set("data-stage", "2");
//            if ($$(".reset").length > 0) $$(".reset")[0].focus();
//            else if ($$(".end").length > 0) $$(".end")[0].focus();
//        }
//    },
//    createDropdown: function (el, i) {
//        var dropdown = el.getElement('.dropdown'),
//            options = dropdown.get('data-options').split(',');
//
//        dropdown
//            .addClass('dropdown' + i)
//            .addClass("options-count-" + options.length)
//            .addClass('dropdown' + dropdown.get('data-type'));
//
//        for (var j = 0; j < options.length; j++) {
//            new Element('div.option.btnClick', {
//                html: "<div><button tabindex='" + i + "'>" + options[j] + "</button></div><span class='optIcon'></span>",
//                'data-state': ''
//                    /*,
//                    'tabindex': i*/
//            }).inject(dropdown);
//        }
//    }
//});