IllustrationSection = new Class({
    Implements: [Options, Events],

    options: {
        delay: 2000,
        top_score: 7
    },

    terms: [],
    challenge_mode: false,

    initialize: function(options) {
        var _this = this;
    	this.setOptions(options);
        this.container = this.options.container;

        this.canvas = this.container.getElement('canvas');
        this.ctx = this.canvas.getContext('2d');
        this.feedback = this.container.getElement('.feedback');
        this.challenge_term = this.container.getElement('.challenge-term');
        this.question_number = this.container.getElement('.widget-footer .question-number');
        this.final_feedback = {
            score: this.container.getElement('.header-feedback.score'),
            type: this.container.getElements('.header-feedback .type'),
            questions_right: this.container.getElements('.header-feedback .questions-right'),
            questions_percent: this.container.getElements('.header-feedback .questions-percent')
        };
        
        

        this.createDOM();
        this.container.getElements('.draw-area').setStyle('background-image', 'url(' + this.options.bg_image_src + ')');
        this.container.getElements('.draw-area').setStyle('background-size', this.options.bg_image_size.w + 'px ' + this.options.bg_image_size.h + 'px');
        this.container.getElements('.total-questions').set('html', this.terms.length);

        this.container.getElement('.start-term-challenge').addEvent('click', function() {
            this.startChallenge('term');
        }.bind(this));
        
        if(this.options.hasDefinition){
            this.container.getElement('.start-definition-challenge').addEvent('click', function() {
                this.startChallenge('definition');
            }.bind(this));
        }else{
            this.container.getElement('.start-definition-challenge').setStyle('display', 'none');
        }
            
        this.container.getElement('.end-challenge').addEvent('click', function() {
            this.endChallenge();
        }.bind(this));

        this.draggable = this.container.getElement('.draggable');
        this.draggable_previous_pos = {
            x: parseInt(this.draggable.getStyle('left')),
            y: parseInt(this.draggable.getStyle('top'))
        };
        this.draggable.makeDraggable({
            droppables: $$('.droppable'),
            onEnter: function(draggable, droppable) {
                droppable.addClass('hover');
            },
            onLeave: function(draggable, droppable) {
                _this.container.getElements('.droppable').removeClass('hover');
            },
            onDrop: function(draggable, droppable) {
                var delay = 0;
                if (droppable) {
                    _this.checkAnswer(draggable.get('data-term-id'), droppable.get('data-term-id'), droppable);
                    delay = _this.options.delay;
                }
                setTimeout(function() {
                    draggable.morph({
                        left: _this.draggable_previous_pos.x,
                        top: _this.draggable_previous_pos.y
                    });
                    _this.container.getElements('.droppable').removeClass('hover');
                }, delay);
            }
        });
        this.container.getElements(".droppable")
            .addEvent("click", function() {
                if (_this.container.hasClass("Accessibility")) {
                    _this.checkAnswer(_this.container.getElement("div.note.accessibility:not(.status)").get('data-term-id'), this.get('data-term-id'), this);
                }
            });
    },

    createDOM: function() {
        var item,
            term_list = new Element('ul.term-list').inject(this.canvas, 'after');

        for (var i = 0; i < this.options.data.length; i++) {
            this.terms[i] = new TermsAndDefinitions_Term({
                id: i,
                el: new Element('li.droppable.list-item.list-item-' + i).inject(term_list),
                term: this.options.data[i].term,
                definition: this.options.data[i].definition,
                highlight: this.options.data[i].highlight,
                position: this.options.data[i].position
            });
        };

        this.challenge_term_list = new Element('ul').inject(this.challenge_term);
    },

    startChallenge: function(type) {
        var challenge_terms = this.shuffle(this.terms),
            _this = this;

        this.challenge_mode = true;
        this.container.addClass('challenge').set('data-challenge', type);
        this.container.removeClass('challenge-complete');
        this.container.getElements('.widget-header .header-feedback').removeClass('visible');
        this.container.getElements('.bubble').removeClass('dissabled');
        this.type = type;

        this.feedback.set('html', '');
        this.challenge_term_list.set('html', '');
        this.question_number.set('html', 1);
        for (var i = 0; i < challenge_terms.length; i++) {
            new Element('li.' + type, {
                html: '<span>' + challenge_terms[i].options[type] + '</span>',
                'data-term-id': challenge_terms[i].options.id
            }).inject(this.challenge_term_list);
        };
        this.draggable.set('data-term-id', challenge_terms[0].options.id);
        this.changeNoteAccessibility();

        this.line = {
            start: [
                this.challenge_term.getSize().x - 1, 
                this.challenge_term.getSize().y / 2],
            end: [
                parseInt(this.draggable.getStyle('left')),
                parseInt(this.draggable.getStyle('top')) + this.draggable.getSize().y / 2]
        };
        this.render();

        this.correct_answers_on_first_try = 0;
        this.correct_on_first_try = true;

        this.timer = setInterval(function() {
            if (_this.challenge_mode) {
                _this.line.end = [
                    parseInt(_this.draggable.getStyle('left')),
                    parseInt(_this.draggable.getStyle('top')) + _this.draggable.getSize().y / 2
                ];
                _this.render();
            }
        }, 33);
        if (!this.container.hasClass("Accessibility")) {
            //this.container.getElement('button.accessibility').focus();
        }
    },

    endChallenge: function() {
        clearTimeout(this.timer);
        this.ctx.clearRect(0, 0, 700, 500);
        this.container.getElements('.bubble').addClass('dissabled');
        this.container.removeClass('challenge').removeProperty('data-challenge');
        this.container.getElements('.answered').removeClass('answered');
    },

    checkAnswer: function(answer1, answer2, element) {
        var _this = this,
            accessibility_on = _this.container.hasClass("Accessibility"),
            offset = accessibility_on ? 750 : 0;
    
        if (answer1 == answer2) {
            if(element.getElement('.bubble')){
                element.getElement('.bubble').addClass('dissabled');
            }
            this.feedback
                    .set('html', message.correct)
                    .removeClass('correct').removeClass('incorrect')
                    .addClass('correct');
            element
                    .set("tabindex", -1)
                    .addClass('answered');

            if (this.correct_on_first_try) {
                this.correct_answers_on_first_try++;
            }
            setTimeout(function() {
                _this.challenge_term_list.children[0].destroy();
                if (_this.challenge_term_list.children.length > 0) {
                    _this.question_number.set('html', _this.terms.length - _this.challenge_term_list.children.length + 1);
                    _this.draggable.set('data-term-id', _this.challenge_term_list.children[0].get('data-term-id'));
                    if(accessibility_on){
                        _this.container.getElement("div.note.accessibility.status").set("html", _this.container.getElement(".widget-footer .questions").get("text") + ". " + (_this.type === "term" ? "Term Challenge: " : "Definition Challenge: "));
                        _this.changeNoteAccessibility();
                        _this.container.getElement("div.instruction.accessibility").set("html", _this.container.getElement("div.instruction.accessibility").get("text") + " ");
                        _this.container.getElement("div.note.accessibility:not(.status)").focus();
                    }
                }
                else {
                    _this.container.addClass('challenge-complete');

                    // Show score
                    var score = new Score(_this.terms.length,_this.correct_answers_on_first_try);
                    _this.final_feedback.score.set('html', score.getMessage());
                    _this.final_feedback.score.addClass('visible');
                    
                    _this.feedback.removeProperty("aria-live");
                    
                    _this.endChallenge();
                }
            }, _this.options.delay + offset - 10);
            this.correct_on_first_try = true;            
        }
        else {
            this.correct_on_first_try = false;
            this.feedback
                .set('html', message.incorrect)
                .removeClass('correct').removeClass('incorrect')
                .addClass('incorrect');
        }

//        console.log('yaya', document.querySelector('[role="definition"].note.accessibility'));
//            setTimeout(function(){
//                document.querySelector('.shout').innerText = document.querySelector('[role="definition"].note.accessibility').innerText;
//            },2000)
            
        setTimeout(function() {
            _this.feedback.set('html', '');
        }, _this.options.delay + offset);
    },

    shuffle: function(o) {
        for(var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
        return o;
    },

    render: function() {
        this.ctx.clearRect(0, 0, 700, 500);
        this.ctx.beginPath();
        
        if (!this.container.hasClass("Accessibility")) {
            this.ctx.moveTo(this.line.start[0], this.line.start[1]);
            this.ctx.lineTo(this.line.end[0], this.line.end[1]);
        }
        
        this.ctx.stroke();
    },
            
    changeNoteAccessibility: function() {
        var element = this.challenge_term_list.children[0],
                text = element.getElement("span").get("html");
//        this.container.getElement("div.note.accessibility:not(.status)").set({
//            html: "<strong>"+(this.type==="term"?"Term Challenge: ":"Definition Challenge: ")+"</strong>"+text,
//            "data-term-id": element.get("data-term-id")
//        });
    }
});

TermsAndDefinitions_Term = new Class({
    Implements: [Options, Events],

    options: {
    },

    initialize: function(options) {
        this.setOptions(options);
        this.el = this.options.el;
        this.position = this.options.position;
        
        this.el.setAttribute('aria-label', this.options.highlight);
        this.el.setAttribute('tabindex', 0);
        
        new Element('strong.term', {
            html: this.options.term
        }).inject(this.el);
        new Element('span.definition', {
            html: (this.options.definition === '-') ? '<div class="bubble dissabled"></div>' : this.options.definition
        }).inject(this.el);

        this.el.set('data-term-id', this.options.id);

        this.render();
    },

    render: function() {
        this.el.setStyles({
            left: this.options.position[0],
            top: this.options.position[1]
        })
    }
});