/**
 * Image Drag-and-drop dev authoring:
 *
 * @author:  Marcelo Aguilera
 */

TermsAndDefinitions = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        hasDefinition: false,
        delayMode: false,
        challengeMode: false,
        maxAttempts: 3
    },
    terms: [],
    challenge_mode: false,
    removeText: function (message) {
        var _this = this;
        _this.options.data.terms.each(function (item, index) {
            if (message.data.id === item.id) {
                _this.options.data.terms.splice(index, 1);
                var item_text = _this.container.getElement("#"+message.data.id+".draggable-item.item-text");
                item_text.destroy();
                return false;
            }
        });

        _this.options.data.texts.each(function (item, index) {
            if (message.data.id === item.id) {
                _this.options.data.texts.splice(index, 1);
                return false;
            }
        });
        this.options.data = _this.options.data;
        this.saveRequest({method: 'mdData', options: {'json': this.options.data}});
    },
    changeInstruction: function () {
        _this = this;
        this.container.getElement("#presentation_instruction").set("html",  _this.options.data.texts[0]);
        this.container.getElement("#presentation_instruction").addEvent('focusout',function(event) {
            _this.options.data.texts[0] = $(this).get("html");
            _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
        });
        if($("challenge_instruction")){
            this.container.getElement("#challenge_instruction").set("html",  _this.options.data.texts[1]);
        
            this.container.getElement("#challenge_instruction").addEvent('focusout',function(event) {
                _this.options.data.texts[1] = $(this).get("html");
                _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
            });
        }
    },
    saveText: function (message) {
        var _this = this;
        var new_item = true;
        var position = {};
        this.options.data.terms.each(function (item, index) {
            if (item.id === message.data.id) {
                new_item = false;
                var new_term = {term: message.data.term, definition: message.data.definition, position: item.position, id: message.data.id, maxWidth: item.maxWidth, targetAlign: message.data.targetAlign, accessibilityLabel: message.data.accessibilityLabel};
                _this.options.data.terms[index] = new_term;
                var term_div  = new Element("div.term ", {html: message.data.term});
                var definition_div = new Element("div.definition", {html: message.data.definition});
                var position = typeof message.data.targetAlign !== 'undefined' && message.data.targetAlign !== ''? message.data.targetAlign : 'left';
                var item_text = _this.container.getElement("#"+message.data.id+".draggable-item.item-text");
                var handleRight  = new Element("div.handle-right.handle", {html: ""});
                item_text.empty();
                item_text.adopt([term_div,definition_div]);
                ['left', 'center', 'right', 'manual'].forEach(function(align){
                    item_text.removeClass("draggable-align-"+align);
                });
                item_text.addClass("draggable-align-"+position);
                item_text.setStyles({
                    left: item.position[0],
                    top: item.position[1]
                });
                item_text.setStyle('max-width', item.maxWidth);
                handleRight.inject(item_text);
                item_text.makeResizable({
                    modifiers: {
                        x: 'width',
                        y: false
                    },
                    limit: {
                        x: [0, 600]
                    },
                    handle: handleRight,
                    onStart: function (el) {
                        el.setStyle('max-width', "600px");
                    },
                    onComplete: function (el){
                        _this.setMaxWidth(item_text.get("id"),item_text.getStyle("width"));
                    },
                    stopPropagation: true,
                });
                return false;
            }
        });

        if (new_item) {
            // var new_term = {term: message.data.term, definition: message.data.definition, position: ["4%", "4%"], id: message.data.id, maxWidth: "250px"}; - Responsive Feature
            var position = typeof message.data.targetAlign !== 'undefined' && message.data.targetAlign !== ''? message.data.targetAlign : 'left';
            var new_term = {term: message.data.term, definition: message.data.definition, position: ["20px", "20px"], id: message.data.id, maxWidth: "600px", targetAlign: message.data.targetAlign, accessibilityLabel: message.data.accessibilityLabel};
            var term_div  = new Element("div.term ", {html: message.data.term});
            var definition_div = new Element("div.definition", {html: message.data.definition});
            var item_text = new Element("div#"+message.data.id+".draggable-item.item-text");
            item_text.adopt([term_div,definition_div]);
            item_text.inject($("item_container"));
            ['left', 'center', 'right', 'manual'].forEach(function(align){
                item_text.removeClass("draggable-align-"+align);
            });
            item_text.addClass("draggable-align-"+position);
            item_text.setStyles({
                // left: "4%",  // responsive feature
                // top: "4%"
                left: "20px",
                top: "20px"
            });
            item_text.setStyle('max-width', '600px');
            _this.options.data.terms.push(new_term);
            $$('#'+message.data.id+'.draggable-item').each(function(drag){
                var handleRight  = new Element("div.handle-right.handle", {html: ""});
                handleRight.inject($(drag));
                new Drag.Move(drag, {
                    onComplete: function(el){
                        // Responsive Feature - (Uncomment code below to add Responsive feature)
                        // var leftPosition= (parseInt($(drag).getStyle("left").replace(/[^-\d\.]/g, ''))*100)/parseInt($("item_container").getSize().x);
                        // var topPosition= (parseInt($(drag).getStyle("top").replace(/[^-\d\.]/g, ''))*100)/parseInt($("item_container").getSize().y);
                        // _this.setPosition($(drag).get("id"), [leftPosition+"%", topPosition+"%"]);
                        // Comment the following code to add Responsive feature
                        var leftPosition= $(drag).getStyle("left");
                        var topPosition= $(drag).getStyle("top");
                        _this.setPosition($(drag).get("id"), [leftPosition, topPosition]);
                        //--------------------
                    }
                });
                $(drag).makeResizable({
                    modifiers: {
                        x: 'width',
                        y: false
                    },
                    limit: {
                        x: [0, 600]
                    },
                    handle: handleRight,
                    onStart: function (el) {
                        el.setStyle('max-width', "600px");
                    },
                    onComplete: function (el){
                        _this.setMaxWidth($(drag).get("id"),$(drag).getStyle("width"));
                    },
                    stopPropagation: true,
                });
            });
        }


        this.options.data = _this.options.data;
        this.saveRequest({method: 'mdData', options: {'json': this.options.data}});
        this.setTermPosition();
    },
    customPostMessages: function (message) {
        var _this = this;
        
        switch (message.data.method) {
            case 'async-data-updated':
            case 'data-change':
                if(message.data.data.challenge_mode_intro_text == true){
                    $$("body")[0].removeClass('challenge-intro-text-force-hide');
                } else {
                    $$("body")[0].addClass('challenge-intro-text-force-hide');
                }
                break;
            case 'addImage':
                if(message.data.image_name !=""){
                    $('background_image').set('src', message.data.image_name);
                    $('background_image').removeClass('non-accessible');
                    this.saveRequest({method: 'mdSetAttribute', options: {selector: '#background_image', attribute: 'src', value: message.data.image_name}});
                    if($('background_image').get('src') == message.data.image_name){
                        this.sendPostMessages('background_placed', {} );
                    }
                }
                else{
                    $('background_image').set('src', '');
                    $('background_image').addClass('non-accessible');
                    this.saveRequest({method: 'mdSetAttribute', options: {selector: '#background_image', attribute: 'src', value: ''}});
                    if($('background_image').get('src') == ''){
                        this.sendPostMessages('background_removed', {} );
                    }
                }
                _this.loadImageContainer();
                break;
            case 'saveText':
                this.saveText(message);
                break;
            case 'removeText':
                this.removeText(message);
                break;
            case 'showDefinition':
                this.showDefinition(message);
                break;

        }
    },
    setPosition: function (item_id, position) {
        _this = this;
        this.options.data.terms.each(function (item, index) {
            if (item.id === item_id) {
                var new_term = {term: item.term, definition: item.definition, position: position, id: item.id, maxWidth: item.maxWidth};
                _this.options.data.terms[index] = new_term;

            }
        });
        this.saveRequest({method: 'mdData', options: {'json': this.options.data}});
    },
    setMaxWidth: function (item_id, maxWidth) {
        _this = this;
        this.options.data.terms.each(function (item, index) {
            if (item.id === item_id) {
                var new_term = {term: item.term, definition: item.definition, position: item.position, id: item.id, maxWidth: maxWidth};
                _this.options.data.terms[index] = new_term;

            }
        });
        this.saveRequest({method: 'mdData', options: {'json': this.options.data}});
    },
    generateDom: function () {
        _this = this;
        _this.tabindex= 0;
        _this.loadImageContainer();
        this.options.data.terms.each(function (item, index) {
            _this.items.push(item);
            var term_div  = new Element("div.term ", {html: item.term});
            term_div.set("tabindex",_this.tabindex)
            if(_this.hasDefinition){
                var definition_div = new Element("div.definition", {html: item.definition});
                definition_div.set("tabindex",_this.tabindex);
            }
            else{
                var definition_div = "";
            }
            var position = typeof item.targetAlign !== 'undefined' && item.targetAlign !== ''? item.targetAlign : 'left';
            var item_text = new Element("div#"+item.id+".draggable-item.item-text.draggable-align-"+position);
            item_text.adopt([term_div,definition_div]);
            var draw_area = $("item_container");
            item_text.inject(draw_area);
            item_text.setStyles({
                left: item.position[0],
                top: item.position[1]
            });
            item_text.setStyle('max-width', item.maxWidth);
            if (_this.isEditMode) {
                _this.feedback.hide();
                $$('#'+item.id+'.draggable-item').each(function(drag){
                    var handleRight  = new Element("div.handle-right.handle", {html: ""});
                    handleRight.inject($(drag));
                    $(drag).removeClass("preview-mode");
                    new Drag.Move(drag, {
                        onComplete: function(el){
                            // Responsive Feature - (Uncomment code below to add Responsive feature)
                            // var leftPosition= (parseInt($(drag).getStyle("left").replace(/[^-\d\.]/g, ''))*100)/parseInt($("item_container").getSize().x);
                            // var topPosition= (parseInt($(drag).getStyle("top").replace(/[^-\d\.]/g, ''))*100)/parseInt($("item_container").getSize().y);
                            // _this.setPosition($(drag).get("id"), [leftPosition+"%", topPosition+"%"]);
                            // Comment the following code to add Responsive feature
                            var leftPosition= $(drag).getStyle("left");
                            var topPosition= $(drag).getStyle("top");
                            _this.setPosition($(drag).get("id"), [leftPosition, topPosition]);
                            //--------------------
                        }
                    });
                    $(drag).makeResizable({
                        modifiers: {
                            x: 'width',
                            y: false
                        },
                        limit: {
                            x: [0, 600]
                        },
                        handle: handleRight,
                        onStart: function (el) {
                            el.setStyle('max-width', "600px");
                        },
                        onComplete: function (el){
                            _this.setMaxWidth($(drag).get("id"),$(drag).getStyle("width"));
                        },
                        stopPropagation: true,
                    });
                });
            }else{
                _this.feedback.show();
                $$('#'+item.id+'.draggable-item').each(function(drag){
                    $(drag).addClass("preview-mode");
                });
            }
        });
        if (_this.isEditMode) {
            $$('.widget-footer').hide();
            $("presentation_instruction").set("contenteditable","true");
            if($("challenge_instruction"))
                $("challenge_instruction").set("contenteditable","true");
        }else{
            $("presentation_instruction").set("contenteditable","false");
            if($("challenge_instruction"))
                $("challenge_instruction").set("contenteditable","false");
        }
        

    },
    loadImageContainer: function () {
        _this = this;
        new Asset.images($("background_image").get("src"), {
            onComplete:function(){
                _this.setTermPosition();
            },
            async: true
        });

    },
    setTermPosition: function(){
        var _this = this;
        $("MetrodigiWidget").setStyles({
            opacity: 1
        });
        _this.options.data.terms.each(function (item, index) {
            $$('#'+item.id+'.draggable-item .term').each(function(drag){
                var size = $(drag).getSize();
                $(drag).setStyle("height", size.y);
            });
        });
        _this.resizeContainer();
    },
    resizeContainer: function () {
        _this = this;
        // Responsive Feature - (Uncomment code below to add Responsive feature)
        // if($("background_image").getSize().y >_this.container.getElement(".draw-area").getSize().y){
        //     $("background_image").setStyles({
        //         height: "100%",
        //         width: "auto"
        //     });
        // }
        // if($("background_image").getSize().x >_this.container.getElement(".draw-area").getSize().x){
        //     $("background_image").setStyles({
        //         height: "auto",
        //         width: "100%"
        //     });
        // }
        // $("item_container").setStyles({
        //     height: $("background_image").getSize().y,
        //     width: $("background_image").getSize().x,
        //     top: 0,
        //     left: $("background_image").getPosition().x + 15
        // });

        if( typeof _this.draggable != "undefined"){
            _this.draggableVerticalAxis = (_this.draggable.getPosition().y - 28) / (window._current_scale || 1) ;
            _this.linedraw(50 , _this.draggableVerticalAxis, _this.draggable.getPosition().x / (window._current_scale || 1), _this.draggable.getPosition().y / (window._current_scale || 1));
        }
        // Comment the following code to add Responsive feature
        $("item_container").setStyles({
            height: $$(".draw-area")[0].getSize().y,
            width: $$(".draw-area")[0].getSize().x,
            top: 0,
            left: 0
        });
        //-------------------
    },

    initialize: function (options) {
        _this = this;
        var has_definitions = $('MetrodigiWidget').get('data-def');
        if (has_definitions === 'true') {
            this.options.hasDefinition = true;
        } else {
            this.options.hasDefinition = false;
        }
        var start_mode = $('MetrodigiWidget').get('data-mode');
        if (start_mode === 'true') {
            this.options.challengeMode = true;
        } else {
            this.options.challengeMode = false;
        }
        var delay_mode = $('MetrodigiWidget').get('data-type');
        if (delay_mode === 'true') {
            this.options.delayMode = true;
        } else {
            this.options.delayMode = false;
        }
         _this.options.maxAttempts =   parseInt($('MetrodigiWidget').get('data-attempts'));
        this.parent(options);
        var _this = this;
        this.setOptions(options);
        this.container = this.options.container;
        this.items= [];
        this.itemsChallenge = [];
        this.feedback = this.container.getElement('.feedback');
        this.challenge_term = this.container.getElement('.challenge-term');
        this.question_number = this.container.getElement('.widget-footer .question-number');
        this.attempts = this.container.getElement('.widget-footer .attempts');
        this.attemptsDelay = this.container.getElement('.widget-footer .attempts-delay');
        this.totalAttempts = this.container.getElement('.widget-footer .total-attempts');
        this.correctAnswers = this.container.getElement('.widget-footer .correct-answers');
        this.score = this.container.getElement('.widget-footer .score');
        this.scoreDelay = this.container.getElement('.widget-footer .score-delay');
        this.questions = _this.container.getElement('.widget-footer .questions');
        this.checkAnswerButton = this.container.getElement('.check-answers');
        this.checkAnswerButton.hide();
        this.tryAgainButton = this.container.getElement('.try-again');
        this.tryAgainButton.hide();
        this.hasDefinition = this.options.hasDefinition;
        this.delayMode = this.options.delayMode;
        this.challengeComplete = false;
        this.challengeRepeat = false;
        this.termActive=false;
        this.definitionActive=false;
        this.wrongAnswers = [];
        this.correctArray = [];
        this.generateDom();
        this.changeInstruction();
        this.observeWindowResize();
        this.item_index = 0;
        this.attemptsCounter = 0;
        this.score.hide();
        this.scoreDelay.hide();
        this.typeChallenge = "term";
        this.draggableVerticalAxis = 100;
        
        if(typeof this.options.data.challenge_mode_intro_text === 'undefined' || this.options.data.challenge_mode_intro_text == false){
            //$$("body")[0].addClass('challenge-intro-text-force-hide');
        }

        if($("presentation_instruction").get("html") != ""){
            $("presentation_instruction").removeClass("tiny-needs-placeholder");
        }
        else{
            $("presentation_instruction").addClass("tiny-needs-placeholder");
        }
        if ($("challenge_instruction")){
            if($("challenge_instruction").get("html") != ""){
                $("challenge_instruction").removeClass("tiny-needs-placeholder");
            }
            else{
                $("challenge_instruction").addClass("tiny-needs-placeholder");
            }
        }

        if (!this.isEditMode) {
            $("presentation_instruction").removeClass("tiny-needs-placeholder");
            $("challenge_instruction").removeClass("tiny-needs-placeholder");
        }

        $$("#presentation_instruction, #challenge_instruction").addEvent('focusin',function(item) {
            $(this).removeClass("tiny-needs-placeholder");
        });
        $$("#presentation_instruction, #challenge_instruction").addEvent('focusout',function(item) {
            console.log($(this).get("html"));
            if($(this).get("html") == "" && this.isEditMode){
                $(this).addClass("tiny-needs-placeholder");
            }
        });


        this.container.getElements('.total-questions').set('html', this.items.length);
        if (!this.hasDefinition) {
            $$(this.container.getElement('.start-definition-challenge')).addClass('hidden');
            $$(this.container.getElement('.start-term-challenge')).set('text', 'Start Challenge');
        }
        this.container.getElement('.start-term-challenge').addEvent('click', function (e) {
            _this.startChallenge("term", e);
            document.previousFocused = 'start-challenge'
            //$$(".challenge-term")[0].focus();
            $("challenge_instruction").setAttribute('tabindex', 0);
            $("challenge_instruction").focus();
        });
        this.container.getElement('.start-definition-challenge').addEvent('click', function (e) {
            _this.startChallenge("definition", e);
            document.previousFocused = 'start-challenge'
            //$$(".challenge-term")[0].focus();
            $("challenge_instruction").setAttribute('tabindex', 0);
            $("challenge_instruction").focus();
        });
        this.container.getElement('.end-challenge').addEvent('click', function () {            
            _this.endChallenge();
        });
        this.checkAnswerButton.addEvent('click', function () {
            _this.checkAnswer();
        });
        this.checkAnswerButton.addEvent('keypress', function () {
            _this.checkAnswer(true);
        });
        this.tryAgainButton.addEvent('click', function (e) {
            _this.startChallenge(_this.typeChallenge, e);
            document.previousFocused = 'start-challenge'
            $$(".challenge-term")[0].focus();
        });
        // this.container.getElement('.start-term-challenge').addEvent('keypress', function (item) {
        //     _this.startChallenge("term");
        //     $$(".challenge-term")[0].focus();
        // });
        // this.container.getElement('.start-definition-challenge').addEvent('keypress', function (item) {
        //     _this.startChallenge("definition");
        //     $$(".challenge-term")[0].focus();
        // });

        // this.tryAgainButton.addEvent('keypress', function () {
        //     _this.startChallenge(_this.typeChallenge);
        //     $$(".challenge-term")[0].focus();
        // });

        $$(".challenge-term")[0].addEvent("keypress", function (e){
            _this.keypressDraggable(this, e);
        });
        $("background_image").set("tabindex","0");
        if (!_this.checkBackgroundImage()){
            $('background_image').addClass('non-accessible');
        }

        if (_this.isEditMode) {
            $("presentation_instruction").show();
            if($("challenge_instruction")){
                $("challenge_instruction").hide();
                var footerEditor = new Element('footer.widget-footer.editor-footer',{
                    html: '<span>Currently editing Presentation Mode Instruction Text.</span><button class="edit-intro hidden">Edit Presentation Mode Instruction Text</button><button class="edit-challenge">Edit Challenge Mode Instruction Text</button>'
                });
                footerEditor.inject(this.container.getElement('.widget-content'));

                $$('.edit-challenge')[0].addEvent('click', function(){
                    $("challenge_instruction").show();
                    $('presentation_instruction').hide();
                    $$('.edit-challenge')[0].addClass('hidden');
                    $$('.edit-intro')[0].removeClass('hidden');
                    _this.container.getElement('footer.widget-footer.editor-footer span').set('html','Currently editing Challenge Mode Instruction Text.');
                });

                $$('.edit-intro')[0].addEvent('click', function(){
                    $("challenge_instruction").hide();
                    $('presentation_instruction').show();
                    $$('.edit-challenge')[0].removeClass('hidden');
                    $$('.edit-intro')[0].addClass('hidden');
                    _this.container.getElement('footer.widget-footer.editor-footer span').set('html','Currently editing Presentation Mode Instruction Text.');
                });
            }
            $$(".item-text").addClass("edit-mode");
        } else {
            if($("challenge_instruction"))
                $("challenge_instruction").hide();
            if(this.options.challengeMode){
                if(this.hasDefinition){
                    $$(".item-text").addClass("hide-draw");
                }
                else{
                    _this.startChallenge("term");
                    $$(".challenge-mode").addEvent("keypress", function (e){
                        _this.keypressEvent(this, e);
                    });
                }
            }
            $$(".note").removeClass("tiny-needs-placeholder");
        }

    },
    checkBackgroundImage: function () {
        if ( $('background_image').get('src') == ''){
            return false;
        }
        return true;
    },
    startChallenge: function (type, e) {
        var _this = this;
        $("background_image").set("tabindex","-1");
        $$(".item-text").removeClass("hide-draw");
        if(_this.typeChallenge != type){
            _this.typeChallenge = type;

            if(type == "term"){
                $$(".definition").removeClass("challenge-mode");
                $$(".draggable-item .term").set("tabindex","1");
                $$(".draggable-item .definition").set("tabindex","-1");
                if(!_this.termActive){
                    _this.challengeRepeat = false;
                    _this.termActive= true;
                }
            }
            else{
                $$(".term").removeClass("challenge-mode");
                $$(".draggable-item .term").set("tabindex","-1");
                $$(".draggable-item .definition").set("tabindex","1");
                if(!_this.definitionActive){
                    _this.challengeRepeat = false;
                    _this.definitionActive = true;
                }
            }
        }
        if(type == "term"){
            $$(".draggable-item .term").each(function(term, i){
                if(typeof term.getSiblings('.definition')[0] != "undefined"){
                    term.set('aria-label', 'Term for: ' + term.getSiblings('.definition')[0].get('text') + '... Press Enter to place the term here.' );
                }
            });
        }
        _this.scoreDelay.hide();
        _this.tryAgainButton.hide();
        _this.challengeComplete = false;
        this.feedback.set('html', '');
        this.itemsChallenge = [];
        this.items.shuffle();
        this.items.each(function (item, index) {
            if(!_this.correctArray.contains(item.id)){
                _this.itemsChallenge.push(item);
            }
        });
        this.item_index = 0;
        if($("challenge_instruction"))
            $("challenge_instruction").show();
        $("presentation_instruction").hide();
        if(typeof _this.correctArray.lenth != "undefined"){
            this.question_number.set('html', _this.correctArray.length );
        }else{
           this.question_number.set('html', 1);
        }
        if(type == "term"){
            // $$(".challenge-term")[0].set('html', _this.itemsChallenge[_this.item_index].term);
            // $$(".challenge-term")[0].set('aria-label', 'Term: ' + $$('.challenge-term')[_this.item_index].get('text') + '... Press Enter to find a matching definition. ');
            // $$(".draggable-item .definition").set("tabindex","-1");

            var labelTextStart = "<span class=visually-hidden >'Term:'</span>";
            var labelTextEnd = "<span class=visually-hidden >'Press tab to select an option from the list and submit your answer.'</span>";
            var labelText =  labelTextStart + _this.itemsChallenge[_this.item_index].term + labelTextEnd
            $$(".challenge-term")[0].set('html',  labelText);

            $$(".challenge-term")[0].set('aria-label', labelText.replace(/<[^>]+>/g, "") );
            $$(".draggable-item .definition").set("tabindex", -1).set('aria-hidden', 'true');
        }
        else{
            // $$(".challenge-term")[0].set('html', _this.itemsChallenge[_this.item_index].definition);
            // $$(".draggable-item .term").set("tabindex","-1");

            var labelTextStart =  "<span class=visually-hidden >'Definition:'</span>";
            var labelTextEnd = "<span class=visually-hidden >'Press tab to select an option from the list and submit your answer.'</span>";
            var labelText =  labelTextStart  + _this.itemsChallenge[_this.item_index].definition + labelTextEnd
            $$(".challenge-term")[0].set('html', labelText);
            $$(".challenge-term")[0].set('aria-label', labelText.replace(/<[^>]+>/g, ""));
        }
        
        $$(".challenge-term")[0].show();
        $$(".challenge-term")[0].set("tabindex",_this.tabindex);
        $$(".challenge-term")[0].removeEvent("keypress");

        $$(".draggable ").show();
        this.container.addClass('challenge').set('data-challenge', type);
        this.options.data.terms.each(function (item, index) {
            if(!_this.correctArray.contains(item.id)){
                $$('#'+item.id+'.draggable-item .'+type).each(function(drag){
                    $(drag).addClass("challenge-mode");
                    var non_hide_size = $(drag).getSize();
                    if(non_hide_size.y > 0){
                        $(drag).setStyle("height", non_hide_size.y);
                    }
                    $(drag).addClass("hide-item");
                    $(drag).set('item_id',item.id);
                });
            }
        });
        $$(".new-content-hide").destroy();
        $$(".new-content").destroy();
        $$(".challenge-mode").removeClass("hide-item-delay");
        this.draggable = this.container.getElement('.draggable.grab');
        _this.draggableVerticalAxis = (_this.draggable.getPosition().y - 28) / (window._current_scale || 1) ;
        this.draggable.set('item_id', _this.itemsChallenge[_this.item_index].id);
        setTimeout(function () {
            var leftPos = _this.getDraggableLeftPosition();
            var topPos = _this.getDraggableTopPosition();

            $$(".draggable ").setStyles({
                left: leftPos,
                top: topPos
            });

            // update draggableVerticalAxis on each restart
            _this.draggableVerticalAxis = (_this.draggable.getPosition().y - 28) / (window._current_scale || 1) ;
            _this.linedraw(50 , _this.draggableVerticalAxis, _this.draggable.getPosition().x / (window._current_scale || 1), _this.draggable.getPosition().y / (window._current_scale || 1));
        }, 0);
        if( !_this.challengeRepeat ){
            $$(".challenge-mode").addEvent("keypress", function (e){
                _this.keypressEvent(this, e);
            });
            this.draggable.makeDraggable({
                onDrag: function (draggable) {
                   _this.linedraw(50 , _this.draggableVerticalAxis, _this.draggable.getPosition().x / (window._current_scale || 1), _this.draggable.getPosition().y / (window._current_scale || 1));
                },
                droppables: $$('.challenge-mode'),
                onEnter: function (draggable, droppable) {
                    droppable.addClass('hover');
                },
                onLeave: function (draggable, droppable) {
                    _this.container.getElements('.challenge-mode').removeClass('hover');
                },
                onDrop: function (draggable, droppable) {
                    _this.dragEvents(type, draggable, droppable);
                    var leftPos = _this.getDraggableLeftPosition(),
                        topPos = _this.getDraggableTopPosition(),
                        mover = new Fx.Move(draggable, {
                            relativeTo: $$(".draw-area")[0],
                            position: 'upperLeft',
                            offset: {x: leftPos, y: topPos},
                            onStart: function () {
                                if($("line") != null){
                                    $("line").destroy();
                                }
                            },
                            onComplete: function () {
                                if(!_this.challengeComplete){
                                    _this.draggableVerticalAxis = (_this.draggable.getPosition().y - 28) / (window._current_scale || 1) ;
                                    _this.linedraw(50 , _this.draggableVerticalAxis, _this.draggable.getPosition().x / (window._current_scale || 1), _this.draggable.getPosition().y / (window._current_scale || 1));
                                }
                                $$(".incorrect-droppable").removeClass("incorrect-droppable");
                            }
                        })
                    ;
                    mover.start();
                    setTimeout(function () {
                        _this.feedback.set('html', '');
                    }, 1000);
                }
            });
        }

        function hideAssessableMenu(descriptionWrapper){

            var children = descriptionWrapper.getParent().getChildren('.assessable-controls')
            children.addClass('visually-hidden')
            children.set('tabindex', -1)
            $$('.challenge-term').floatingTipsHide()
        }

        if(!$$('.assessable-controls').length){
            function SetHideAssessableMenu(e){
                var wrapper;
                wrapper = $(e.target)
                if(e.target.tagName == 'H2' || e.target.tagName == 'SPAN') wrapper = $(e.target.parentNode)
                hideAssessableMenu(wrapper)
            }
            $$('.challenge-term').addEvent('click', SetHideAssessableMenu)
            $$('.challenge-term').addEvent('contextmenu', SetHideAssessableMenu)

            $$('*').addEvent('focusin',function(e){
                e.stopPropagation()

                var wasByKeyboard = window.lastClick < window.lastKey;
                if (!wasByKeyboard) {
                    $$('.challenge-term').floatingTipsHide();
                    return;
                }

                var target = $(e.target)
                var parent = target.getParent()
                if(target.hasClass('assessable-controls') || target.hasClass('challenge-term')){
                    if(document.previousFocused == 'start-challenge'){
                        setTimeout(function(){
                            try{
                                $$('.floating-tip-wrapper')[0].remove()
                            }
                            catch(e){
                            }
                        },0)
                        document.previousFocused = 'button'
                        return
                    }
                    if (!target.hasClass('challenge-term')) {
                        if (document.previousFocused == 'not-allowed') {
                            return
                        } else {
                            if (target.tagName == 'button') document.previousFocused = 'button'
                            if (target.tagName == 'select') document.previousFocused = 'select'
                        }

                    } else {
                        document.previousFocused = 'description'
                        parent.getChildren('.assessable-controls').set('tabindex', 0)
                    }
                    parent.getChildren('.assessable-controls').removeClass('visually-hidden')
                }else{
                    $$('.challenge-term')[0].getSiblings('.assessable-controls').set('tabindex',-1)
                    $$('.challenge-term')[0].getSiblings('.assessable-controls').addClass('visually-hidden')
                    document.previousFocused = 'not-allowed'
                }

            })
            $$('*').addEvent('focusout',function(e){
                e.stopPropagation()
                var target = $(e.target)
                var parent = target.getParent()
                if(target.hasClass('assessable-controls') || target.hasClass('challenge-term')){

                    setTimeout(function(){

                        if(document.activeElement.tagName != 'SELECT' &&
                            document.activeElement.tagName != 'BUTTON' &&
                            document.activeElement.tagName != 'DIV'){
                            $$('.challenge-term')[0].getSiblings('.assessable-controls').set('tabindex',-1)
                            $$('.challenge-term')[0].getSiblings('.assessable-controls').addClass('visually-hidden')
                        }
                    },0)

                    if(target.hasClass('challenge-term')){
                        if(document.previousFocused != 'button') return
                    }
                    else if(target.tagName =='button'){
                        if(document.previousFocused != 'description' && document.previousFocused != 'select')
                            return
                    }
                    else if(target.tagName == 'select') {
                        if(document.previousFocused != 'button') return
                    }

                    //
                }

            })
            //NEW
            var challengeTerm = $$('.challenge-term')[0];



            var menu = new Element('select.visually-hidden.assessable-controls', {
                'aria-label':  'Make a selection to associate this theory with the theorist',
                // html: menuOptions,
                'tabindex': -1
            })
            var menuSubmitButton = new Element('button.assessable-controls.visually-hidden', {
                'aria-label':  'Submit answer',
                html: "Submit answer",
                'tabindex': -1
            })

            _this.setMenuOptions = function() {
                var menuOptions = '';
                if(this.options.hasDefinition){
                    var oppositeType = type == 'term'? 'definition' : 'term'
                    var droppables =  $$('.challenge-mode').map(function(droppable){
                        return droppable.getSiblings('.term, .definition')[0]
                    })
                    menuOptions = droppables.map(function(term){
                        var itemId = term.getSiblings('.term,.definition').get('item_id')[0]
                        return '<option data-id="' + itemId+ '">'+  term.getChildren('h2,p')[0].textContent + '</option>';
                    })
                } else {
                    var droppables =  $$('.challenge-mode.hide-item').map(function(droppable){
                        return droppable.getChildren('p')[0]
                    })

                    const termsMap = {}
                    const labelsMap = {}
                    this.itemsChallenge.map(function(item){
                        var term = item.term.replace('</p>', '').replace('<p>', '');
                        termsMap[term] = item.id
                        labelsMap[item.id] = item.accessibilityLabel
                    })
                    menuOptions = droppables.map(function(term){
                        var itemId = termsMap[term.textContent]
                        // var itemId = term.getParent().get('item_id')[0]
                        return '<option data-id="' + itemId+ '">'+  labelsMap[itemId] + '</option>';
                    })
                }

                menu.set('html', menuOptions);
                // menu.adopt(menuOptions)
                menu.set('selected-index', 0)
            }

            menu.inject($('item_container'), 'before')
            menuSubmitButton.inject($('item_container'), 'before')

            menuSubmitButton.addEventListener('click', function(){
                var selectedOption = $(menu.options[menu.selectedIndex])
                var id = selectedOption.get('data-id')
                var draggable = $$(".draggable")[0];
                var dropTarget = $$('.challenge-mode[item_id='+ id +']')[0]

                dropTarget.setAttribute('aria-disabled', true)
                _this.dragEvents(_this.typeChallenge, draggable, dropTarget);
                if(!_this.options.delayMode){
                    _this.feedback.set("tabindex",0);
                    _this.feedback.focus();

                    setTimeout(function () {

                        $$(".incorrect-droppable").removeClass("incorrect-droppable");
                        _this.feedback.set('html', '');
                        _this.feedback.set("tabindex",-1);
                        if(!_this.challengeComplete){
                            if(_this.typeChallenge == 'definition'){

                                var labelTextStart =  "<span class=visually-hidden >'Definition:'</span>";
                                // var labelTextEnd = "<span class=visually-hidden >'... Press  Enter to find a matching term.'</span>";
                                var labelTextEnd = "<span class=visually-hidden >'Press tab to select an option from the list and submit your answer.'</span>";



                                $$(".challenge-term")[0].getChildren(0).grab(labelTextStart,'before')
                                $$(".challenge-term")[0].adopt(labelTextEnd)
                                // var labelText = 'Definition: ' + $$('.challenge-term')[0].get('text') + '... Press  Enter to find a matching term. '
                                var labelText = 'Definition: ' + $$('.challenge-term')[0].get('text') + ' Press tab to select an option from the list and submit your answer.'
                                $$(".challenge-term")[0].set('aria-label', labelText);
                            }
                            else{
                                var labelTextStart =  "<span class=visually-hidden >'Term:'</span>";
                                // var labelTextEnd = "<span class=visually-hidden >'... Press  Enter to find a matching definition.'</span>";
                                var labelTextEnd = "<span class=visually-hidden >'Press tab to select an option from the list and submit your answer.'</span>";

                                $$(".challenge-term")[0].getChildren()[0].grab(labelTextStart,'before')
                                $$(".challenge-term")[0].adopt(labelTextEnd)

                                // var labelText = 'Term: ' + $$('.challenge-term')[0].get('text') + '... Press  Enter to find a matching definition. '

                                var labelText = "<span class=visually-hidden >'Press tab to select an option from the list and submit your answer.'</span>";

                                $$(".challenge-term")[0].set('aria-label', labelText );
                            }

                            $$(".challenge-term")[0].focus();

                        }
                        else{
                            // _this.score.set("tabindex",0);
                            // _this.score.focus();
                        }
                    }, 1000);
                }else{
                    if(!_this.challengeComplete){
                        if(_this.typeChallenge == 'term'){

                            var labelTextStart = new Element('span.visually-hidden', {
                                text: 'Term:'
                            })
                            // var labelTextEnd = new Element('span.visually-hidden',{
                            //     text: '... Press  Enter to find a matching definition.'
                            // })

                            var labelTextEnd = new Element('span.visually-hidden', {
                                text : 'Press tab to select an option from the list and submit your answer.'
                            })


                            $$(".challenge-term")[0].getChildren(0).grab(labelTextStart,'before')
                            $$(".challenge-term")[0].adopt(labelTextEnd)
                            // $$(".challenge-term")[0].getChildren()[0].grab(new Element('span.visually-hidden', {
                            //     text : labelText
                            // }),'before')
                            // $$(".challenge-term")[0].set('aria-label', labelText );
                        }
                        else{
                            var labelTextStart = new Element('span.visually-hidden', {
                                text: 'Definition:'
                            })
                            // var labelTextEnd = new Element('span.visually-hidden',{
                            //     text: '... Press  Enter to find a matching term.'
                            // })
                            var labelTextEnd = new Element('span.visually-hidden', {
                                text : 'Press tab to select an option from the list and submit your answer.'
                            })

                            $$(".challenge-term")[0].getChildren(0).grab(labelTextStart,'before')
                            $$(".challenge-term")[0].adopt(labelTextEnd)

                            // $$(".challenge-term")[0].set('aria-label', labelText );

                        }
                        $$(".challenge-term")[0].focus();
                    }
                    else{
                        _this.checkAnswerButton.focus();
                    }
                }
                _this.setMenuOptions()

            })
        }
        _this.setMenuOptions()


        if (e && e.event) {
            var x = e.event.x || e.event.pageX || e.page.x
            var y = e.event.y || e.event.pageY || e.page.y

            if (!(x && y)) setTimeout(function(){$$('.challenge-term')[0].focus()},0)
        }

        $$('.challenge-mode').set('role', 'radio')


        $$('.challenge-term').floatingTips({
            position: 'right',
            showOn: 'focus',
            hideOn: 'focusout',
            content: function() { return $('instructions-tooltip'); },
            html: true,
        })
    },
    setDragAlign: function(){
        var _this = this;
        var align = _this.itemsChallenge[_this.item_index].targetAlign;
        if(typeof align === 'undefined'){
            align = 'left';
        }
        $$('.draggable').removeClass('align-center');
        $$('.draggable').removeClass('align-left');
        $$('.draggable').removeClass('align-right');
        
        switch(align){
            case 'center':
                $$('.draggable').addClass('align-center');
                break;
            case 'left':
                $$('.draggable').addClass('align-left');
                break;
            case 'right':
                $$('.draggable').addClass('align-right');
                break;
        }
    },
    getDraggableLeftPosition: function () {
        var challengeTermEl = document.querySelector('.challenge-term');
        var challengeTermBCR = challengeTermEl.getBoundingClientRect();
        var draggableEl = document.querySelector('.draggable.grab');
        var draggableElBCR = draggableEl.getBoundingClientRect();

        var left = challengeTermBCR.left + challengeTermBCR.width - draggableElBCR.width;

        return left;
    },
    getDraggableTopPosition: function(){
        return $$('.challenge-term')[0].getSize().y + 35;
    },
    getFeedbackTopPosition: function() {
        return $$('.challenge-term')[0].getSize().y + 22;
    },
    dragEvents: function(type, draggable, droppable){
        var _this = this;
        if (droppable && $(droppable).hasClass("challenge-mode")) {
            if(!_this.options.delayMode){
                if( $(droppable).get("item_id") == $(draggable).get("item_id") ){
                    $(droppable).removeClass("hide-item");
                    if(_this.itemsChallenge.length > _this.item_index + 1){
                        _this.item_index++;
                        if(type == "term"){
                            $$(".challenge-term")[0].set('html', _this.itemsChallenge[_this.item_index].term);
                        }
                        else{
                            $$(".challenge-term")[0].set('html', _this.itemsChallenge[_this.item_index].definition);
                        }
                        $(draggable).set('item_id', _this.itemsChallenge[_this.item_index].id);
                    }else{
                        _this.challengeComplete = true;
                        $$(".challenge-term")[0].hide();
                        $(draggable).hide();
                        _this.attempts.set('html', (_this.itemsChallenge.length - _this.wrongAnswers.length));
                        if($("line") != null){
                            $("line").destroy();
                        }
                        _this.score.show();
                    }
                    $(droppable).addClass("correct-droppable");
                    $(droppable).set("tabindex","-1");
                    _this.feedback
                        .set('html', "Correct!")
                        .removeClass('correct').removeClass('incorrect')
                        .addClass('correct')
                        .setStyle('top', _this.getFeedbackTopPosition());
                    _this.question_number.set('html', _this.item_index +1);
                }
                else {
                    if(!_this.wrongAnswers.contains($(draggable).get("item_id")))
                    {
                      _this.wrongAnswers.push($(draggable).get("item_id"));
                    }
                    if(!$(droppable).hasClass("correct-droppable"))
                    {
                        $(droppable).addClass("incorrect-droppable");
                        _this.feedback
                            .set('html', "Incorrect!")
                            .removeClass('correct').removeClass('incorrect')
                            .addClass('incorrect')
                            .setStyle('top', _this.getFeedbackTopPosition());
                    }
                }
            }
            else{
                $(droppable).removeClass("hide-item");
                _this.question_number.set('html', _this.correctArray.length + _this.item_index +1);
                if( $(droppable).get("item_id") != $(draggable).get("item_id") ){
                    _this.wrongAnswers.push($(draggable).get("item_id"));
                    $(droppable).addClass("hide-item-delay");
                    $(droppable).set("tabindex","-1");
                    var new_content = new Element("div.new-content ", {html: $$(".challenge-term")[0].get("html")});
                    new_content.set("tabindex","-1");
                    if(_this.typeChallenge == "term"){
                        new_content.inject($(droppable).getParent(".draggable-item"),"top");
                        new_content.addClass("new-term");
                    }
                    else{
                        new_content.inject($(droppable).getParent(".draggable-item"),"bottom");
                        new_content.addClass("new-definition");
                    }

                }
                if(_this.itemsChallenge.length > _this.item_index + 1){
                    _this.item_index++;
                    if(type == "term"){
                        $$(".challenge-term")[0].set('html', _this.itemsChallenge[_this.item_index].term);
                    }
                    else{
                        $$(".challenge-term")[0].set('html', _this.itemsChallenge[_this.item_index].definition);
                    }
                    $(draggable).set('item_id', _this.itemsChallenge[_this.item_index].id);
                }
                else{
                    _this.challengeComplete = true;
                    $$(".challenge-term")[0].hide();
                    $(draggable).hide();
                    if($("line") != null){
                        $("line").destroy();
                    }
                    _this.checkAnswerButton.show();
                }
            }
        }
    },
    keypressDraggable: function(i, e){
        _this = this;
        if (e.key == "enter" || e.key == "space") {
            var control = false;
            $$('.challenge-mode.hide-item').each(function(element, index){
                if (control == false) {
                    element.focus();
                    control = true;
                }
            });
        }
    },
    keypressEvent: function (i, e) {
        _this = this;
        var draggable = $$(".draggable")[0];
        var droppable = $$(".")
        if (e.key == "enter" || e.key == 'space') {
            _this.dragEvents(_this.typeChallenge, draggable, i);
            if(!_this.options.delayMode){
                _this.feedback.set("tabindex",0);
                _this.feedback.focus();
                setTimeout(function () {
                    $$(".incorrect-droppable").removeClass("incorrect-droppable");
                    _this.feedback.set('html', '');
                    _this.feedback.set("tabindex",-1);
                    if(!_this.challengeComplete){
                        $$(".challenge-term")[0].focus();
                        $$(".challenge-term")[0].set('aria-label', 'Term: ' + $$('.challenge-term')[0].get('text') + '... Press Enter to find a matching definition. ');
                    }
                    else{
                        _this.score.set("tabindex",0);
                        _this.score.focus();
                    }
                }, 1000);
            }else{
                if(!_this.challengeComplete){
                    $$(".challenge-term")[0].focus();
                    $$(".challenge-term")[0].set('aria-label', 'Term: ' + $$('.challenge-term')[0].get('text') + '... Press Enter to find a matching definition. ');
                }
                else{
                    _this.checkAnswerButton.focus();
                }
            }
        }
    },
    linedraw: function (x1,y1,x2,y2){
        _this = this;
        if($("line") != null){
            $("line").destroy();
        }

        var angle = Math.atan2(y2 - y1, x2 - x1) * 180 / Math.PI;
        var length= Math.sqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2));
        var line = new Element("div#line.draggable-line");
        line.setStyles({
            height: "1px",
            width: (length +10) + "px",
            top: (y1) + "px",
            left: (x1) + "px",
            transform: "rotate(" + angle + "deg)"
        });
        line.inject(_this.container);
    },
    endChallenge: function () {
        _this = this;
        _this.score.hide();
        _this.wrongAnswers=[];
        _this.item_index = 0;
        _this.attemptsCounter = 0;
        _this.challengeRepeat = true;
        _this.correctArray=[];
        $("background_image").set("tabindex","0");
        if($("challenge_instruction"))
            $("challenge_instruction").hide();
        $("presentation_instruction").show();
        this.checkAnswerButton.hide();
        this.tryAgainButton.hide();
        $$(".new-content").destroy();
        this.draggable = this.container.getElement('.draggable.grab');
        this.container.removeClass('challenge').removeProperty('data-challenge');
        this.container.getElements('.answered').removeClass('answered');
        $$(".challenge-mode").each(function (item) {
            $(item).removeClass("hide-item");
            $(item).removeClass("hide-item-delay");
        });
        $$(".correct-droppable").set("tabindex","0");
        $$(".correct-droppable").removeClass("correct-droppable");
        $$(".incorrect-droppable").set("tabindex","0");
        $$(".incorrect-droppable").removeClass("incorrect-droppable");
        $$(".new-content-hide").destroy();
        _this.challengeComplete = true;
        $$(".challenge-term")[0].hide();
        $$(".draggable ").hide();
        if($("line") != null){
            $("line").destroy();
        }
        _this.feedback
            .set('html', "")
            .removeClass('correct').removeClass('incorrect');
        // $("background_image").focus();
    },
    checkAnswer: function (tabAccess) {
        _this = this;
        this.attemptsCounter++;
        if(this.attemptsCounter != _this.options.maxAttempts && _this.correctArray.length != _this.items.length){
            _this.tryAgainButton.show();
        }
        _this.attemptsDelay.set('html', _this.attemptsCounter);
        _this.totalAttempts.set('html', _this.options.maxAttempts);
        _this.correctAnswers.set('html', $$(".challenge-mode:not(.hide-item-delay)").length);
        _this.scoreDelay.show();
        if(tabAccess){
          _this.scoreDelay.focus();
        }
        _this.correctArray = [];
        $$(".new-content").addClass("new-content-hide");
        $$(".new-content-hide").removeClass("new-content");
        $$(".new-content-hide").addClass("incorrect-droppable");
        $$(".challenge-mode:not(.hide-item-delay)").each(function (item) {
            $(item).addClass("correct-droppable");
            $(item).set("tabindex, -1");
            _this.correctArray.push($(item).get("item_id"));
        });
        if(_this.correctArray.length == _this.items.length || this.attemptsCounter == _this.options.maxAttempts){
            _this.tryAgainButton.hide();
            this.attemptsCounter = 0;
        }
        _this.challengeRepeat = true;
        _this.checkAnswerButton.hide();
    },

    isTouchDevice: function () {
        return typeof window.ontouchstart !== 'undefined';
    },
    observeWindowResize: function () {
        _this = this;
        window.addEvent('resize', function(){
            _this.resizeContainer();
        });
    }
});


/*
 ---
 description: Class for creating floating balloon tips that nicely appears when hovering an element.

 license: MIT-style

 authors:
 - Lorenzo Stanco

 requires:
 - core/1.3: '*'

 provides: [FloatingTips]

 ...
 */

var FloatingTips = new Class({

    Implements: [Options, Events],

    options: {
        position: 'top',
        fixed: false,
        center: true,
        content: 'title',
        html: false,
        balloon: true,
        arrowSize: 6,
        arrowOffset: 6,
        distance: 3,
        motion: 6,
        motionOnShow: true,
        motionOnHide: true,
        showOn: 'mouseenter',
        hideOn: 'mouseleave',
        hideOnTipOutsideClick: false,
        discrete: false,
        showDelay: 0,
        hideDelay: 0,
        className: 'floating-tip',
        identifier: '',
        offset: { x: 0, y: 0 },
        fx: { 'duration': 'short' }
    },

    /**
     * Array containing the elements which have a Tip applied by this instance
     */
    networkMembers: [],

    initialize: function(elements, options) {
        this.setOptions(options);
        var s = this;
        this.boundShow = (function() {
            var element = this;
            s.show(element);
            if (s.options.discrete) s.networkMembers.filter(function(item) {
                return item !== element;
            }).invoke('floatingTipsHide');
        });
        this.boundHide = (function() { s.hide(this); });
        if (!['top', 'right', 'bottom', 'left', 'inside'].contains(this.options.position)) this.options.position = 'top';
        if (elements) this.attach(elements);
        $$('body')[0].grab(new Element('#instructions-tooltip.visually-hidden', {
            text: "Select an option from the list, and submit your answer."
        }))
        return this;
    },

    attach: function(elements) {
        var s = this;
        $$(elements).each(function(e) {
            s.networkMembers.include(e);
            if (e.retrieve('floatingtip_hasevents')) { return; }
            var evs = { };
            s.options.showOn && (evs[s.options.showOn] = s.boundShow);
            s.options.hideOn && (evs[s.options.hideOn] = s.boundHide);
            e.addEvents(evs);
            e.store('floatingtip_hasevents', true);
            e.store('floatingtip_object', s);
        });
        return this;
    },

    detach: function(elements) {
        var s = this;
        var evs = { };
        evs[this.options.showOn] = this.boundShow;
        evs[this.options.hideOn] = this.boundHide;
        $$(elements).each(function(e) {
            s.networkMembers.erase(e);
            s.hide(e);
            e.removeEvents(evs);
            e.eliminate('floatingtip_hasevents');
            e.eliminate('floatingtip_object');
        });
        return this;
    },

    show: function(element) {
        var old = element.retrieve('floatingtip');
        if (old) if (old.getStyle('opacity') != 0) { clearTimeout(old.retrieve('timeout')); return this; }
        var tip = this._create(element);
        if (tip == null) return this;
        element.store('floatingtip', tip);
        this._animate(tip, 'in');
        element.store('floatingtip_visible', true);
        this.fireEvent('show', [tip, element]);
        return this;
    },

    hide: function(element) {
        var tip = element.retrieve('floatingtip');
        if (!tip) return this;
        this._animate(tip, 'out');
        element.store('floatingtip_visible', false);
        this.fireEvent('hide', [tip, element]);
        return this;
    },

    toggle: function(element) {
        if (element.retrieve('floatingtip_visible')) return this.hide(element);
        else return this.show(element);
    },

    _create: function(elem) {
        var o = this.options;
        var oc = o.content;
        var opos = o.position;

        if (oc == 'title') {
            oc = 'floatingtitle';
            if (!elem.get('floatingtitle')) elem.setProperty('floatingtitle', elem.get('title'));
            elem.set('title', '');
        }

        var cnt = (typeof(oc) == 'string' ? elem.get(oc) : oc(elem));
        var cwr = new Element('div').addClass(o.className).setStyle('margin', 0);
        var tip = new Element('div')
            .addClass(o.className + '-wrapper')
            .addClass('position-' + this.options.position)
            .setStyles({ 'margin': 0, 'padding': 0 })
            .adopt(cwr);
        if (o.identifier.length > 0) {
            tip.addClass(o.identifier);
        }

        if (cnt) {
            if (o.html) {
                if (o.html_adopt) cwr.adopt(cnt);
                else cwr.set('html', typeof(cnt) == 'string' ? cnt : cnt.get('html'));
            } else {
                cwr.set('text', cnt);
            }
        } else {
            return null;
        }

        var body = document.id(document.body);
        tip.setStyles({ 'position': (o.fixed ? 'fixed' : 'absolute'), 'opacity': 0, 'top': 0, 'left': 0 }).inject(body);

        // Z-index "copied" after tip injecting, because of webkit bug: https://bugs.webkit.org/show_bug.cgi?id=15562
        cwr.setStyle('position', 'relative'); // Position
        tip.setStyles({ 'z-index': cwr.getStyle('z-index') });
        cwr.setStyle('position', null); // Reset position

        if (o.balloon && !Browser.ie6) {

            var trg = new Element('div').addClass(o.className + '-triangle').setStyles({ 'margin': 0, 'padding': 0 });
            var trgSt = { 'border-color': cwr.getStyle('background-color'), 'border-width': o.arrowSize, 'border-style': 'solid','width': 0, 'height': 0 };

            switch (opos) {
                case 'inside':
                case 'top'   : trgSt['border-bottom-width'] = 0; break;
                case 'right' : trgSt['border-left-width'  ] = 0; trgSt['float'] = 'left'; cwr.setStyle('margin-left', o.arrowSize); break;
                case 'bottom': trgSt['border-top-width'   ] = 0; break;
                case 'left'  : trgSt['border-right-width' ] = 0;
                    if (Browser.ie7) { trgSt['position'] = 'absolute'; trgSt['right'] = 0; } else { trgSt['float'] = 'right'; }
                    cwr.setStyle('margin-right', o.arrowSize); break;
            }

            switch (opos) {
                case 'inside': case 'top': case 'bottom':
                trgSt['border-left-color'] = trgSt['border-right-color'] = 'transparent';
                trgSt['margin-left'] = o.center ? tip.getSize().x / 2 - o.arrowSize : o.arrowOffset; break;
                case 'left': case 'right':
                trgSt['border-top-color'] = trgSt['border-bottom-color'] = 'transparent';
                trgSt['margin-top'] = o.center ?  tip.getSize().y / 2 - o.arrowSize : o.arrowOffset; break;
            }

            // Firefox triangle pixelation fix (https://brettstrikesback.com/de-pixelating-the-css-triangle/)
            if (Browser.firefox || Browser.name == 'firefox') {
                trgSt['-moz-transform'] = 'scale(1.01)';
                trgSt['transform'] = 'scale(1.01)';
            }

            trg.setStyles(trgSt).inject(tip, (opos == 'top' || opos == 'inside') ? 'bottom' : 'top');

        }

        var tipSz = tip.getSize(), trgC = elem.getCoordinates();
        var offsetOption = ('function' === typeof(o.offset) ? Object.merge({ x: 0, y: 0 }, o.offset(elem)) : o.offset);
        var pos = { x: trgC.left + offsetOption.x, y: trgC.top + offsetOption.y };

        if (opos == 'inside') {
            tip.setStyles({ 'width': tip.getStyle('width'), 'height': tip.getStyle('height') });
            elem.setStyle('position', 'relative').adopt(tip);
            pos = { x: o.offset.x, y: o.offset.y };
        } else {
            switch (opos) {
                case 'top'   :  pos.y -= tipSz.y + o.distance; break;
                case 'right' :  pos.x += trgC.width + o.distance; break;
                case 'bottom':  pos.y += trgC.height + o.distance; break;
                case 'left'  :  pos.x -= tipSz.x + o.distance; break;
            }
        }

        if (o.center) {
            switch (opos) {
                case 'top' : case 'bottom': pos.x += (trgC.width / 2 - tipSz.x / 2); break;
                case 'left': case 'right' : pos.y += (trgC.height / 2 - tipSz.y / 2); break;
                case 'inside':
                    pos.x += (trgC.width / 2 - tipSz.x / 2);
                    pos.y += (trgC.height / 2 - tipSz.y / 2); break;
            }
        }

        tip.set('morph', o.fx).store('position', pos);
        tip.setStyles({ 'top': pos.y, 'left': pos.x });

        if (o.hideOnTipOutsideClick) {
            var documentClickHandler = null;
            documentClickHandler = function(event) {
                var eventTarget = document.id(event.target);
                if (elem && elem !== eventTarget && !elem.contains(eventTarget)) {
                    this.hide(elem);
                } else if (!elem) {
                    document.removeEvent('click', documentClickHandler);
                }
            }.bind(this);
            document.addEvent('click', documentClickHandler);
            tip.addEvent('click', function(event) { event.stopPropagation(); });
        }

        return tip;
    },

    _animate: function(tip, d) {

        clearTimeout(tip.retrieve('timeout'));
        tip.store('timeout', (function(t) {

            var o = this.options, din = (d == 'in');
            var m = { 'opacity': din ? 1 : 0 };

            if ((o.motionOnShow && din) || (o.motionOnHide && !din)) {
                var pos = t.retrieve('position');
                if (!pos) return;
                switch (o.position) {
                    case 'inside':
                    case 'top'   : m['top']  = din ? [pos.y - o.motion, pos.y] : pos.y - o.motion; break;
                    case 'right' : m['left'] = din ? [pos.x + o.motion, pos.x] : pos.x + o.motion; break;
                    case 'bottom': m['top']  = din ? [pos.y + o.motion, pos.y] : pos.y + o.motion; break;
                    case 'left'  : m['left'] = din ? [pos.x - o.motion, pos.x] : pos.x - o.motion; break;
                }
            }

            t.morph(m);
            if (!din) t.get('morph').chain(function() { this.dispose(); }.bind(t));

        }).delay((d == 'in') ? this.options.showDelay : this.options.hideDelay, this, tip));

        return this;

    }

});

Elements.implement({

    floatingTips: function(options) {
        new FloatingTips(this, options);
        return this;
    }

});

Element.implement({

    floatingTips: function(options) {
        new FloatingTips($$(this), options);
        return this;
    },

    floatingTipsShow: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.show(this);
        return this;
    },

    floatingTipsHide: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.hide(this);
        return this;
    },

    floatingTipsToggle: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.toggle(this);
        return this;
    }

});

Element.Properties.floatingTips = {

    get: function(){
        return this.retrieve('floatingtip_object');
    }

};