// find polyfill
if (!Array.prototype.find) {
    Array.prototype.find = function (predicate) {
        'use strict';
        if (this == null) {
            throw new TypeError('Array.prototype.find called on null or undefined');
        }
        if (typeof predicate !== 'function') {
            throw new TypeError('predicate must be a function');
        }
        var list = Object(this);
        var length = list.length >>> 0;
        var thisArg = arguments[1];
        var value;

        for (var i = 0; i < length; i++) {
            value = list[i];
            if (predicate.call(thisArg, value, i, list)) {
                return value;
            }
        }
        return undefined;
    };
}

StandardImageMap = new Class({
    Implements: [Options, Events],
    objects: [],
    // Set initial options here
    options: {
    },
    
    // initialize - widget initialization
    initialize: function(elements, options) {
        this.setOptions(options);
        this.elements = elements;
        elements.addClass("loading");
        this.render();
    },
    render: function(){
        var resizeSlider = this.resizeSlider.bind(this);

        window.removeEvent('resize', resizeSlider);
        window.addEvent('resize', resizeSlider);

        var _this = this,
            close = function(){
                var popup_close = $$(".popup .close");
                if(popup_close.length > 0){
                    popup_close.fireEvent("click");
                }
            },
            adjustOverlays = function() {
                var overlays = _this.elements[0].getElement('.overlays');
                if (!overlays) {
                    return false;
                }
                var imagemap_wrapper = _this.elements[0].getElement('.imagemap-wrapper');
                var img = imagemap_wrapper.getElement('img');
                var img_size = {}
                var baseImgOffset = 0

                if (img.hasClass('hidden')) {
                    img.removeClass('hidden')
                    img_size = img.getSize();
                    baseImgOffset = img.offsetLeft
                    img.addClass('hidden')    
                } else {
                    img_size = img.getSize();
                    baseImgOffset = img.offsetLeft
                }

                overlays.setStyles({
                    width: img_size.x,
                    height: img_size.y,
                    'margin-left': baseImgOffset
                });

                if (imagemap_wrapper.scrollLeft > 0) {
                    overlays.setStyles({
                        'margin-left': imagemap_wrapper.scrollLeft
                    });
                }
                var imgs = overlays.getElements('img');
                if (imgs) {
                    imgs.setStyles({
                        width: img_size.x,
                        height: img_size.y,
                        'margin-left': -imagemap_wrapper.scrollLeft
                    });
                }
                var slider = _this.elements[0].getElement('.slider');                
                if (slider) {
                    slider.style.setProperty( 'width', (+img_size.x + 10) +'px', 'important' );
                    slider.setStyles({
                        'margin-left': img.offsetLeft - 10
                    });
                }
            },
            adjustOverlayWidth = function() {
                var width = _this.elements[0].getElement('input.slider').get('value');
                if(width >= 1){
                    var ajuste =  width - 0.30;
                }else{
                    var ajuste = width;
                }                
                _this.elements[0].getElement('.overlays-inside').setStyle(
                    'width',
                    ajuste + '%'
                );     
            },
            events = ["click", "touchstart"];

        setInterval(adjustOverlays, 500);

        this.elements.each(function(element, i){
            var options = {},
                img = element.getElement("img"),
                imageMap,
                self = this;

            options.zoomStep = 100;
            options.showZoomControls = element.get('data-show-controls') === "false" ? null : true;
            options.imageUrl = img.get("src");
            options.alt = img.get('data-alt');
            options.extraLayer = element.get("data-overlay");
            options.overlayAlt = element.get("data-overlay-alt");
            options.overlayData = element.getElements('dl.overlays');
            options.text_left = element.get("data-text-left");
            options.text_right = element.get("data-text-right");
            options.manIcon = element.get("data-scale-button");
            options.hideSlider = element.get("data-hide-slider") === "true";
            options.alt = img.get("data-alt");    
            options.defaultZoom = element.get("data-default-zoom") ? +element.get("data-default-zoom") : element.getDimensions().x;
            options.minZoom = options.defaultZoom;
            options.popupZoom = parseInt(element.get('data-popup-zoom'));
            options.maxZoom = img.get("width");
            options.autoZoom = element.get('data-autozoom');
            options.showNavigator = element.get('data-show-navigator') === "true"; // default is false
            options.multipleLayersCheckboxMode = element.get('data-multiple-layer-checkbox') === "true";
            options.revealDirectionRTL = element.get('data-reveal-direction') === "rtl";
            options.controlPosition = element.get('data-controls') ? element.get('data-controls') : "right"; //default is right
            options.i = i;
            options.adjustCallback = !element.get("data-overlay") ? null : function() {
                adjustOverlays();
            }
            options.captions = element.getElements('p.caption');

            if (options.extraLayer) {
                options.extraLayer = options.extraLayer.split(',');
                var overlayAlt = [];
                if( options.overlayAlt !== "" && options.overlayAlt.indexOf(',') > 0 ){
                    
                    try {
                        overlayAlt = JSON.parse(options.overlayAlt);
                    } catch(e){}
                    if(!overlayAlt){
                        overlayAlt = options.overlayAlt.split(',');
                    }                    
                } else if( options.overlayAlt !== "" && typeof options.overlayAlt === "string"){
                    overlayAlt = [options.overlayAlt];
                }
                
                if(overlayAlt!==null && overlayAlt !== undefined && overlayAlt !== ""){
                    options.overlayAlt = overlayAlt;
                }
            }
            
            imageMap = new ModifiedImageMap(element, options);
            imageMap.options.imageEl.options = options;
            imageMap._setZoom = imageMap.setZoom;


            imageMap.setZoom = function(zoomLevel){
                this._setZoom(zoomLevel);

                if(+zoomLevel <= +this.options.defaultZoom){
                    this.controlsWrapper.addClass("lock");
                }
                else{
                    this.controlsWrapper.removeClass("lock");
                }
                if(this.options.extraLayer){
                    try{
                        var img = this.wrapper.getElements("img"),
                            img_dimensions = img.getComputedSize(),
                            img_position = img.getPosition(element);

                        this.wrapper.getElement(".extra") //on load this is not created
                            .setStyles({
                                left: (img_position.x >= 0)? img_position.x : 0, 
                                "background-image": "url('" + options.extraLayer + "')",
                                "background-size": img_dimensions.width + "px " + img_dimensions.height + "px",
                                "height": img_dimensions.height + "px",
                            });
                    }catch(e){}
                }
            };

            imageMap.setPan = function(x, y) {
                this.wrapper.scrollTo(x, y);
            };

            imageMap.options.imageEl.addEvent("load", function(){
                var options = this.options,
                    widget_imagemap_wrapper = element.getElement(".widget-imagemap-wrapper"),
                    control_container = widget_imagemap_wrapper.getElement(".map-controls-container"),
                    img_dimensions = this.getComputedSize(),
                    img_position = this.getPosition(element),
                    spacing = 20,
                    person = new Element("div.map-control.scale.man-icon", {
                        html: "Man", "data-i": options.i,
                        tabindex: 0
                    }).inject(control_container),
                    events = ["click", "touchstart"];

                if (imageMap.options.manIcon) {
                    events.each(function(event){
                        person.addEvent(event, function(e) {
                            if (options.manIcon === 'true') {
                                var popup = new Element("div.popup", {
                                    html:"<span class='close'>×</span><img src='" + imageMap.options.imageUrl + "' style='width:" + imageMap.options.popupZoom +"px' />",
                                    styles: {
                                        "margin-left" : -imageMap.options.popupZoom/2 + "px",
                                        "margin-top" : -imageMap.options.popupZoom/2 * img_dimensions.height / img_dimensions.width + "px"
                                    }
                                }).inject(widget_imagemap_wrapper.addClass("popup_open"));
                                events.each(function(event){
                                    popup.getElement(".close")
                                        .addEvent(event,function(){
                                            popup.remove();
                                            widget_imagemap_wrapper.removeClass("popup_open");
                                        });
                                });
                            }
                            else {
                                var imageObj = new Image();
                                imageObj.src = options.manIcon;
                                imageObj.addEventListener('load', function() {
                                    var popup_max_area = imageMap.options.imageAreaDiv.getSize();
                                    var popup = new Element("div.popup", {
                                        html: "<span class='close'>×</span><img src='" + imageObj.src + "' style='" + 
                                            "max-width: " + (popup_max_area.x - 20) + "px; " +
                                            "max-height: " + (popup_max_area.y - 20) + "px; " + "' />",
                                        styles: {
                                            "opacity" : 0
                                        }
                                    }).inject(widget_imagemap_wrapper.addClass("popup_open"));
                                    setTimeout(function() {
                                        var popup_size = {
                                            x: parseInt(popup.getStyle('width')),
                                            y: parseInt(popup.getStyle('height'))
                                        };
                                        $$('.popup')[0].setStyles({
                                            "margin-left" : -popup_size.x/2 + "px",
                                            "margin-top" : -popup_size.y/2 + "px",
                                            "opacity" : 1
                                        });
                                    }, 100);
                                    events.each(function(event){
                                        popup.getElement(".close")
                                            .addEvent(event,function(){
                                                popup.remove();
                                                widget_imagemap_wrapper.removeClass("popup_open");
                                            });
                                    });
                                }, false);
                            }

                            e.preventDefault();
                            e.stopPropagation();
                        });
                    });
                }
                else {
                    person.hide();
                }

                imageMap.options.defaultZoom = Math.max(imageMap.options.defaultZoom, img_dimensions.height);
                imageMap.options.minZoom = imageMap.options.defaultZoom / 2;
                imageMap.currentZoom = imageMap.options.defaultZoom;
                
                var h = widget_imagemap_wrapper.getDimensions().y * img_dimensions.width / img_dimensions.height;
                Hammer(
                    widget_imagemap_wrapper.addClass(options.controlPosition)
                ).on("pinchout", function(e){
                    imageMap.setZoom(imageMap.currentZoom + imageMap.options.zoomStep);
                    e.preventDefault();
                    e.stopPropagation();
                }).on("pinchin", function(e){
                    imageMap.setZoom(imageMap.currentZoom - imageMap.options.zoomStep);
                    e.preventDefault();
                    e.stopPropagation();
                });
                
                if (options.showNavigator) {
                    var navigator = widget_imagemap_wrapper.getElement(".imagemap-navigator");

                    navigator
                        .setStyles({
                            height: navigator.getDimensions().x * img_dimensions.height / img_dimensions.width
                        })
                        .getElement(".navigator-view-area")
                            .setStyles({height: 0, top: -9999999999});
                }
                else{
                    var imagemap_wrapper = widget_imagemap_wrapper.getElement(".imagemap-wrapper");
                    widget_imagemap_wrapper.addClass("no-navigator");
                }
                if(options.controlPosition === "right"){
                    control_container
                        .setStyles({
                            top:  navigator ? navigator.getElement("img").getDimensions().y : parseInt(this.getStyle("padding-top")) - 5,
                        });
                }
                
                element
                    .removeClass("loading")
                    .getElements(">*")
                        .setStyles({opacity: 1});
                
                if (options.extraLayer) {
                    var imagemap_wrapper = widget_imagemap_wrapper.getElement(".imagemap-wrapper");
                    var overlays = new Element('div.overlays').inject(imagemap_wrapper);
                    var overlays_inside = new Element('div.overlays-inside').inject(overlays);
                    if (options.overlayData && this.options.extraLayer.length > 0) {
                        var toggle_inputs = new Element('form.toggle-layers', {
                            role: 'presentation'
                        }).inject(element);
                    }
                    var tr;
                    var presentationType = $('MetrodigiWidget').get('data-xml-type');

                    for (var i = 0; i < this.options.extraLayer.length; i++) {
                        var layer = this.options.extraLayer[i];
                        var alt_text = this.options.overlayAlt[i];
                        var accessibleImageData = window.accessibility_data && window.accessibility_data.images && window.accessibility_data.images.find(function (image) {
                            return image.src && image.src === layer.substr(layer.lastIndexOf('/') + 1);
                        });

                        new Element('img', {
                            src: layer,
                            'class': presentationType === 'buttons' ? ' hidden': '',
                            alt: alt_text,
                            'aria-hidden': true
                        }).inject(overlays_inside);
                        if(options.hideSlider) {
                            try {
                                if (options.overlayData && this.options.extraLayer.length > 0) {
                                    var altElId = 'imagealtstatic-' + i;
                                    var lastTimerId = null;
                                    var firstRadioCheck = true;

                                    function toggleInput (inputEl) {
                                        clearTimeout(lastTimerId);

                                        var currentInputEl = inputEl;
                                        var wasByKeyboard = window.lastClick.getTime() < window.lastKey.getTime();
                                        var altImg =  $$('p[id^=longstatic]').filter(function(p){
                                            return p.previousSibling.tagName.toLowerCase() == "img"
                                        })[0];

                                        if ( altImg ) {
                                            $(altImg).addClass('hidden');
                                            $(altImg).set('aria-hidden', true);
                                            $(altImg.previousSibling).set('aria-hidden', true);
                                        }

                                        if (options.multipleLayersCheckboxMode) {
                                            //radio mode

                                            // uncheck all radio inputs
                                            $$('.toggle-layers input').each(function (inputEl) {
                                                inputEl.removeAttribute('checked');
                                                inputEl.set('checked', false);
                                            });

                                            // check current radio input
                                            currentInputEl.set('checked', true);
                                            currentInputEl.setAttribute('checked', 'checked');

                                            var index = currentInputEl.get('data-overlay-id');
                                            $$('.overlays-inside')[0].getElements('img').removeClass('show-image-wrapper').addClass('hidden');
                                            $$('.overlays-inside')[0].getElements('img').removeClass('show-image-wrapper').set('aria-hidden', true)
                                            $$('.overlays-inside')[0].getElements('img')[index].addClass('show-image-wrapper').removeClass('hidden');
                                            $$('.overlays-inside')[0].getElements('img')[index].addClass('show-image-wrapper').set('aria-hidden', false)

                                            currentInputEl.set('aria-describedby', currentInputEl.get('data-describedby'));

                                            if (wasByKeyboard && firstRadioCheck) {
                                                // read image alt text
                                                currentInputEl.getNext('p').set('aria-relevant', 'additions text');
                                                currentInputEl.getNext('p').set('aria-hidden', 'false');
                                            }

                                            firstRadioCheck = false;
                                        } else {
                                            //checkbox mode

                                            // check current checkbox input
                                            currentInputEl.set('checked', !currentInputEl.get('checked'));

                                            var index = currentInputEl.get('data-overlay-id');

                                            $$('.toggle-layers input:not(:checked)').set('aria-describedby', '');

                                            $$('.overlays-inside')[0].getElements('img')[index].toggle();
                                            var overlayImage = $$('.overlays-inside img')[index];

                                            if (currentInputEl.get('checked')) {
                                                overlayImage.removeClass('hidden');
                                                overlayImage.set('aria-hidden', false);

                                                currentInputEl.getNext('p').set('text', '');
                                                currentInputEl.set('aria-describedby', currentInputEl.get('data-describedby'));
                                                currentInputEl.getNext('p').set('aria-hidden', 'false');
                                                currentInputEl.getNext('p').set('aria-relevant', 'additions text');

                                                lastTimerId = setTimeout(function () {
                                                    var p = currentInputEl.getNext('p');
                                                    // read image alt text
                                                    p.set('text', p.get('data-text'));
                                                }, 500);
                                            } else {
                                                overlayImage.addClass('hidden');
                                                overlayImage.set('aria-hidden', true);
                                            }
                                        }
                                        var label = $$('form.toggle-layers')[0].getElement('label[for=input-'+index+']').get('text');

                                        var isOneActive = false
                                        $$('.overlays-inside')[0].getElements('img').each(function (layer, i){
                                            if (!layer.hasClass('hidden')) {
                                                isOneActive = true
                                            }
                                        })
                                        var imagemap_wrapper = _this.elements[0].getElement('.imagemap-wrapper');
                                        var baseImg = imagemap_wrapper.getElement('img');
                                        if (!isOneActive) {
                                            baseImg.removeClass('hidden')
                                        }
                                    }

                                    tr = new Element('div.row').grab(
                                        new Element('input', {
                                            id: 'input-' + i,
                                            type: options.multipleLayersCheckboxMode ? 'radio' : 'checkbox',
                                            'data-overlay-id': i,
                                            name:'overlay_layers',
                                            'aria-describedby': '',
                                            'data-describedby': altElId,
                                            events: {
                                                click: function (e) {
                                                    e.preventDefault();
                                                    setTimeout(function () {
                                                        toggleInput(e.target);
                                                    }, 0);
                                                },
                                                keyup: function (e) {
                                                    e.preventDefault();
                                                    if (e.code == 32) {
                                                        setTimeout(function () {
                                                            toggleInput(e.target);
                                                        }, 0);
                                                    }
                                                }
                                            }
                                        }), 'top'
                                    ).grab(
                                        new Element('label', {
                                            for: 'input-' + i,
                                            html: options.overlayData.getElements('dd')[0][i].get('html')
                                        })
                                    ).grab(
                                        new Element('p', {
                                            id: altElId,
                                            html: accessibleImageData && accessibleImageData.alt,
                                            'data-text': accessibleImageData && accessibleImageData.alt,
                                            class: 'visually-hidden',
                                            'aria-live': 'polite',
                                            // prevent image alt text been read twice
                                            'aria-hidden': 'true',
                                            'aria-relevant': ''
                                        })
                                    );
                                    tr.inject(toggle_inputs);
                                }
                            }
                            catch (e) {
                                console.error('Invalid overlay data', i, e);
                            }
                        }
                    };
                    element.addClass('overlay-enabled');
                    if (options.hideSlider) {
                        overlays_inside.addClass('fixed-width');
                    }
                    else {
                        var label = new Element('label', {
                            'for': 'slider-image'
                        }).inject(imagemap_wrapper.getParent());
                        var slider = new Element('input.slider', {
                            id: 'slider-image',
                            type: 'range',
                            min: 0,
                            max: 100,
                            tabindex: 0
                        }).set('value', options.revealDirectionRTL?100:0).inject(imagemap_wrapper.getParent());
                        slider.addEvents({
                            'input': function(e) {
                                adjustOverlayWidth(this.get('value'));
                            },
                            'change': function(e) {
                                adjustOverlayWidth(this.get('value'));
                            }
                        });

                        _this.resizeSlider();

                        if(options.revealDirectionRTL){
                            adjustOverlayWidth(100);
                        }
                    }
                    if (!_this.elements[0].getElement('.slider')) {
                        $$('.overlays-inside')[0].getElements('img').hide();
                    }
                }

                var autoZoom = _this.autoZoom.bind(imageMap);
                autoZoom(); // fix image wrapper zoom
                window.fireEvent("resize"); // fix toggle layers position
                window.removeEventListener('resize', autoZoom);
                window.addEventListener('resize', autoZoom);
                if($$('.overlays-inside')[0]){
                    var baseImage = $$('.overlays-inside')[0].getElements('img');
                    
                    baseImage[0].setAttribute('alt', options.alt);
                }

            });
            _this.objects.push(imageMap);

        });

        new Element('div#notification.visually-hidden', {
            'aria-live': 'assertive',
            html: '<p></p>'
        }).inject($('image-overlay-wrapper'));
        
        
        window.addEvent('keyup', function(e) {
            if(e.key === "esc"){
                close();
            }
        });
        setTimeout(function(){
            _this.customResize();
        },2000);
    },
    customResize: function () {
        var _this = this;
        var w_size = $$('.widget-content .widget-imagemap-wrapper .image-area .imagemap-wrapper img')[0].getSize();        
        var w_size2;
        if($$('.widget-content .widget-imagemap-wrapper .imagemap-navigator')[0]){
            w_size2 = $$('.widget-content .widget-imagemap-wrapper .imagemap-navigator')[0].getSize();

            var plus = 0;
            if(w_size2.y > w_size.y){
                w_size = w_size2;
                plus = 30;
            }
        }

        var height = w_size.y;
        var w_name = location.toString().split("/")[location.toString().split("/").length - 2] + '/' + location.toString().split("/")[location.toString().split("/").length - 1];
        var elems = window.parent.document.getElementsByTagName('iframe');        
        $$(elems).each(function (e) {
            try {
                var src = e.get('src');
                if (src.contains(w_name)) {
                    var res = Math.abs(Math.abs(height) - Math.abs(e.get('height')));
                    if(res > 15 && e.get('class') !== "gadget"){
                        $$('.widget-content .widget-imagemap-wrapper .image-area .imagemap-wrapper')[0].setStyle('height', (height + 45 + plus) + 'px');                        
                        e.set('height', height + 60 +plus);
                    }
                }
            } catch (er) {
            }
        });
    },
    isMobile: function() {
        return screen.width <= 667;
    },

    // resize input slider
    resizeSlider: function() {
        var sliderImageEl = $('slider-image');
        var $imageArea = $$('.image-area')[0];

        if (sliderImageEl && $imageArea) {
            sliderImageEl.style.setProperty( 'max-width', (parseInt($imageArea.getSize().x) + 10) + 'px', 'important' );
        }
    },

    autoZoom: function(imageMap) {
        var imageMap = this;
        if (imageMap.options.autoZoom) {
            var container_size = imageMap.options.imageEl.getParent().getSize();
            var image_size = {
                x: imageMap.options.imageEl.naturalWidth,
                y: imageMap.options.imageEl.naturalHeight
            };
            var mod_container_size = {
                x: container_size.y * (image_size.x / image_size.y),
                y: container_size.x * (image_size.y / image_size.x)
            };
            if (mod_container_size.y > container_size.y) {
                var x = mod_container_size.x;
                imageMap.options.minZoom = x;
                imageMap.options.defaultZoom = x;
                imageMap.setZoom(x);
            }
            else {
                imageMap.options.minZoom = container_size.x;
                imageMap.options.defaultZoom = container_size.x;
                imageMap.setZoom(container_size.x);
            }
        }
        else if (imageMap.options.defaultZoom) {
            imageMap.setZoom(imageMap.options.defaultZoom);
        }
    }
});

ModifiedImageMap = new Class({
    Implements: [Events, Options],
    options: {
        defaultZoom: 100,
        defaultX: 0,
        defaultY: 0,
        zoomStep: 10,
        minZoom: 0,
        maxZoom: 250,
        left: 0,
        top: 0,
        wrapperEl: null,
        imageEl: null,
        controlsEl: null,
        imageUrl: null,
        showZoomControls: true,
        boundDragToContainer: false,
        showNavigator: false,
        updateNavigatorImmediately: true
    },
    currentZoom: null,
    wrapper: null,
    image: null,
    controlsWrapper: null,
    initialize: function (el, options) {
        this.el = el;
        this.setOptions(options);
        var needDomSetup = !options.wrapperEl;
        if(needDomSetup) {
            this.setupDom();
        }
        this.wrapper = this.options.wrapperEl;
        this.image = this.options.imageEl;


        if(this.options.showNavigator) {
            this.addNavigator();
        }
        this.controlsWrapper = this.options.controlsEl;
        this.addControls();

        if(!needDomSetup) {
            this.attachBehavior();
        }
        
        var ratio;
        if (this.options.defaultZoom == 'autofit') {
            this.options.imageEl.addEvent('load', function(){
                ratio = this.image.naturalHeight / this.image.naturalWidth;
                this.setZoom(this.el.getSize().x * ratio);
            }.bind(this));
        }
    },
    addNavigator: function(){
        var myvar;
        this.navigator = this.options.navigatorEl;
        this.navigatorImage = this.image.clone();
        this.navigatorImage.addClass('non-accessible');
        this.navigatorImage.setStyles({'width':'100%'});
        this.navigator.adopt(this.navigatorImage);
        this.navigatorArea = new Element('div', {'class':'navigator-view-area'});
        this.navigator.adopt(this.navigatorArea);
        this.navigatorArea.makeDraggable({
            container: this.navigator,
            stopPropagation: true,
            preventDefault: true,            
            onDrag: function(){
                clearTimeout(myvar);

                if(this.options.updateNavigatorImmediately) {                          
                    this.positionImageArea();                        
                }

                if (this.options.adjustCallback) {
                    this.options.adjustCallback();
                }
            }.bind(this),
            onComplete: function(){                
                this.positionImageArea();                                
                if($$('.rtl-wrapper').length > 0){                    
                    myvar = setTimeout(function(){
                        $$('.rtl-wrapper').getElements('img')[0][1].show();                           
                        $$('.overlays-inside').setStyle('border-right', '2px solid #AA0000');                                               
                    }, 400);                                                                                
                }else{
                    setTimeout(function(){
                        $$('.overlays-inside').setStyle('border-right', '2px solid #AA0000');                                               
                    }, 400);                
                }
                if (this.options.adjustCallback) {
                    this.options.adjustCallback();
                }
            }.bind(this)
        });
    },
    getNavigationRatio: function(){
        return this.image.width / this.navigator.getSize().x;
    },
    positionNavigatorArea: function(){
        var navigatorRatio = this.getNavigationRatio();
        var wrapperSize = this.wrapper.getSize();
        var navHeightRatio = (wrapperSize.y/navigatorRatio);
        var navHeight = this.navigatorImage.height>navHeightRatio ? this.navigatorImage.height : navHeightRatio;

        this.navigatorArea.setStyles({
            'top':(this.wrapper.scrollTop/navigatorRatio)+'px',
            'left':(this.wrapper.scrollLeft/navigatorRatio)+'px',
            width: (wrapperSize.x/navigatorRatio)+'px',
            height:(wrapperSize.y/navigatorRatio)+'px'
        });
    },
    positionImageArea: function(){
        var scaleRatio = window._current_scale || 1;
        var navigatorRatio = this.getNavigationRatio();
        var navPos = this.navigatorArea.getPosition(this.navigator);                
        this.wrapper.scrollTo((navPos.x * navigatorRatio) / scaleRatio, (navPos.y * navigatorRatio) / scaleRatio);
    },
    attachBehavior: function(){
        this.setZoom(this.options.defaultZoom);
        this._resetDrag();
        this.wrapper.scrollTo(this.options.left, this.options.top);
    },

    setupDom: function() {
        var onWindowResize = this.onWindowResize.bind(this);

        window.removeEvent('resize', onWindowResize);
        window.addEvent('resize', onWindowResize);

        this.el.empty();
        this.options.wrapperEl = new Element('div', {'class':'imagemap-wrapper'});
        this.options.imageAreaDiv = new Element('div.image-area');
        this.onWindowResize();

        this.options.wrapperEl.setStyles({
            'position': 'relative',
            'overflow':'hidden'
        });

        if (this.options.showNavigator) {
            this.el.addClass('navigator-enabled');
        }
        this.options.imageEl = new Element('img', {
            src: this.options.imageUrl
        });
        this.options.imageEl.addEvent('load', function(){
            this.attachBehavior();
            // Reset minzoom if the image and container are both "portrait" orientation.
            // Prevents zoom out to blank areas.  See CHAUC-1060.
            if (this.image.naturalWidth < this.image.naturalHeight && this.el.getSize().x < this.el.getSize().y) {
                this.options.minZoom = this.el.getSize().x / this.image.naturalWidth * this.image.naturalHeight;
            }

            if(this.options.showNavigator) {
                this.positionNavigatorArea();
            }
            if (this.options.adjustCallback) {
                this.options.adjustCallback();
            }

        }.bind(this));
        this.options.wrapperEl.adopt(this.options.imageEl);

        this.options.controlsEl = new Element('div');
        var widgetWrapperEl = new Element('div', {'class':'widget-imagemap-wrapper'});
        widgetWrapperEl.adopt(this.options.imageAreaDiv.adopt(this.options.wrapperEl));

        if(this.options.showNavigator) {
            this.options.navigatorEl = new Element('div',{'class':'imagemap-navigator'});
            widgetWrapperEl.adopt(this.options.navigatorEl);
        }

        widgetWrapperEl.adopt(this.options.controlsEl).adopt(this.options.captions);
        this.el.adopt(widgetWrapperEl);
    },
    addControls: function(){
        var clickEvent = this.isTouchDevice() ? 'touchstart' : 'click';
        var createControl = function(text, isPlus){
            var css = isPlus?'zoom-in':'zoom-out';
            var controlEl = new Element('div', {
                'class': 'map-control '+css,
                'text': text,
                'tabindex': 0,
                role: 'button',
                'aria-label': isPlus ? 'Zoom In' : 'Zoom Out'
            });
            controlEl.addEvent(clickEvent, function(e){
                e.stop();                
                var zoom = this.currentZoom;
                if(isPlus) {
                    zoom = zoom + this.options.zoomStep;
                } else {
                    zoom = zoom - this.options.zoomStep;
                }
                this.setZoom(zoom);
            }.bind(this));
            controlEl.addEvent('keydown', function(e) {
                if (e.which == 13 || e.code == 13 || e.which == 32 || e.code == 32) {
                    this.fireEvent(clickEvent, e);
                }
            });
            return controlEl;
        }.bind(this);

        this.controlsWrapper.addClass('map-controls-container');

        this.controlsWrapper.adopt(createControl('+', true));
        this.controlsWrapper.adopt(createControl('-', false));
        this.controlsWrapper.adopt(new Element('div', {
            'class': 'map-control reload',
            html: '&#8635;',
            style: 'margin-top: 5px',
            tabindex: 0,
            role: 'button',
            'aria-label': 'Reset',
            events: {
                click: function (e) {
                    this.setZoom(this.options.defaultZoom)
                    this.wrapper.scrollTop  = 0;
                    this.wrapper.scrollLeft = 0;
                    if(this.options.showNavigator) {
                        this.positionNavigatorArea();
                    }
                    if (this.options.adjustCallback) {
                        this.options.adjustCallback();
                    }
                }.bind(this),
                keyup: function(e) {
                    if (e.which == 13 || e.code == 13 || e.which == 32 || e.code == 32) {
                        this.fireEvent('click', e);
                    }
                }
            }
        }));
    },
    _resetZoom: function(){        
        var imageSize  = this.image.getSize();
        var useWidth = false;
        var zoomWidth  = this.currentZoom;
        var zoomHeight = this.currentZoom;
        if (useWidth) {
            zoomWidth  = zoomHeight * this.image.naturalWidth  / this.image.naturalHeight;
        } else {
            zoomHeight = zoomWidth  * this.image.naturalHeight / this.image.naturalWidth;
        }

        var yDiff      = Math.floor(zoomHeight - imageSize.y) / 2;
        var xDiff      = Math.floor(zoomWidth  - imageSize.x) / 2;
        var scrollTop  = this.wrapper.scrollTop;
        var scrollLeft = this.wrapper.scrollLeft;

        this.image.setStyle('width'  , zoomWidth  + 'px');
        this.image.setStyle('height' , zoomHeight + 'px');

       // If slide start right.
       if($$('.rtl-wrapper').length > 0){
            this.image.getNext('img').setStyle('width', zoomWidth  + 'px');
            this.image.getNext('img').setStyle('height', zoomHeight + 'px');
            $$('.rtl-wrapper').setStyle('width', zoomWidth  + 'px');
            $$('.rtl-wrapper').setStyle('height', zoomHeight + 'px');
        }
       
        this.wrapper.scrollTop  = scrollTop  + yDiff;
        this.wrapper.scrollLeft = scrollLeft + xDiff;

        if(this.options.showNavigator) {
            this.positionNavigatorArea();
        }
        if (this.options.adjustCallback) {
            this.options.adjustCallback();
        }

    },
    setZoom: function(zoomLevel){
        if(zoomLevel > this.options.maxZoom) {
            this.currentZoom = this.options.maxZoom;
        } else if(zoomLevel < this.options.minZoom) {
            this.currentZoom = this.options.minZoom;
        } else {
            this.currentZoom = zoomLevel;
        }
        this._resetZoom();
    },
    setPan: function(x, y) {
        this.wrapper.scrollTo(x, y);
    },
    _resetDrag: function(){
        if(this.drag) {
            this.drag.drag.detach();
        }
        this.drag = new DragScroll(this.wrapper, {
            axis: {x: true, y: true},
            friction: 100,
            boundDragToContainer: this.options.boundDragToContainer,
            stopPropagation: true,
            onDrag: function(){
                if(this.options.showNavigator && this.options.updateNavigatorImmediately) {
                    this.positionNavigatorArea();
                }
                if (this.options.adjustCallback) {
                    this.options.adjustCallback();
                }
            }.bind(this),
            onComplete: function(){
                if(this.options.showNavigator) {
                    this.positionNavigatorArea();
                }
                if (this.options.adjustCallback) {
                    this.options.adjustCallback();
                }
            }.bind(this)
        });
    },
    isTouchDevice: function () {
      return !!('ontouchstart' in window);
    },

    onWindowResize: function() {
        if (this.options.showNavigator && $$(".imagemap-wrapper .overlays .overlays-inside")[0]) {
            this.setZoom(this.currentZoom);
        }

        this.updateImageWrapperHeight();
        this.updateImageWrapperWidth();
    },

    // scale `image map wrapper` to available width 
    updateImageWrapperWidth: function () {
        var size = this.el.getSize();
        // avoid infinite window resize
        if (!this.options.showNavigator) {
            this.options.wrapperEl.setStyles({'width': size.x + "px"});
        } else {
            this.options.wrapperEl.setStyles({'width': size.x - 160 + "px"});
        }
    },

    // scale `image map wrapper` to available height 
    updateImageWrapperHeight: function () {
        if (this.isTouchDevice()) {
            // avoid infinite window resize
            this.options.wrapperEl.setStyle('max-height', window.screen.height);
        }

        var ratio = window._current_scale || 1;
        var window_height = ratio < 1 ? $$('body')[0].getHeight() : window.getHeight();

        if (window_height === 0) return;

        var type = $$('#MetrodigiWidget').get('data-xml-type')[0];
        var headerEl = $$('.widget-header')[0];
        var headerHeight = headerEl ? headerEl.getHeight() : 0;
        var toggleLayersEl = $$('.toggle-layers')[0];
        var wrapperPadding = 30;

        if (type === 'buttons') {
            wrapperPadding += 30 + (toggleLayersEl ? toggleLayersEl.getHeight() : 65);
        }
        if (type === 'slider') {
            wrapperPadding += 15 + 26;
        }

        var wrapperHeight = window_height - (headerHeight + wrapperPadding) * ratio;
        this.options.wrapperEl.setStyle('height', wrapperHeight + 'px');
    }
});

var sum = function(array){
  var result = 0;
  for (var l = array.length; l--;) result += array[l];
  return result;
};

DragScroll = new Class({

  // We'd like to use the Options Class Mixin
  Implements: [Options, Events],

  // Default options
  options: {
    friction: 5,
    axis: {x: true, y: true},
    boundDragToContainer: false
  },

  initialize: function(element, options){
    element = this.element = document.id(element);
    this.content = element.getFirst();
    this.setOptions(options);

    // Drag speed
    var prevTime, prevScroll, speed, scroll, timer;
    var timerFn = function(){
      var now = Date.now();
      scroll = [element.scrollLeft, element.scrollTop];
      if (prevTime){
        var dt = now - prevTime + 1;
        speed = [
          1000 * (scroll[0] - prevScroll[0]) / dt,
          1000 * (scroll[1] - prevScroll[1]) / dt
        ];
      }
      prevScroll = scroll;
      prevTime = now;
    };
  
    // Use Fx.Scroll for scrolling to the right position after the dragging
    var fx = this.fx = new Fx.Scroll(element, {
      transition: Fx.Transitions.Expo.easeOut
    });

    // Set initial scroll
    fx.set.apply(fx, this.limit(element.scrollLeft, element.scrollTop));

    var self = this;
      friction = this.options.friction,
      axis = this.options.axis;

    // Make the element draggable
    var drag = this.drag = new Drag(element, {
      style: false,
      invert: true,
      modifiers: {x: axis.x && 'scrollLeft', y: axis.y && 'scrollTop'},
      stopPropagation: true,
      preventDefault: true,
      onStart: function(){
        // Start the speed measuring
        timerFn();
        timer = setInterval(timerFn, 1000 / 60);
        // cancel any fx if they are still running
        fx.cancel();
      },
      onDrag: function(el, e) {
        self.fireEvent('drag', el, e);
        if(!self.options.boundDragToContainer) {
          return;
        }
        var elSize = el.getSize();
        var elPosition = el.getPosition();
        var cushion = -5;

        var x = this.mouse.now.x - elPosition.x;
        var y = this.mouse.now.y - elPosition.y;

        if (x <= cushion || x >= elSize.x-cushion || y <= cushion || y >= elSize.y-cushion) {
          this.stop();
        }
      },
      onComplete: function(){
        // Stop the speed measuring
        prevTime = false;
        clearInterval(timer);
        // Scroll to the new location
        fx.start.apply(fx, self.limit(
          scroll[0] + (speed[0] || 0) / friction,
          scroll[1] + (speed[1] || 0) / friction
        ));
        self.fireEvent('complete');
      }
    });

  },

  // Calculate the limits
  getLimit: function(){
    var limit = [[0, 0], [0, 0]], element = this.element;
    var styles = Object.values(this.content.getStyles(
      'padding-left', 'border-left-width', 'margin-left',
      'padding-top', 'border-top-width', 'margin-top',
      'width', 'height'
    )).invoke('toInt');
    limit[0][0] = sum(styles.slice(0, 3));
    limit[0][1] = styles[6] + limit[0][0] - element.clientWidth;
    limit[1][0] = sum(styles.slice(3, 6));
    limit[1][1] = styles[7] + limit[1][0] - element.clientHeight;
    return limit;
  },

  // Apply the limits to the x and y values
  limit: function(x, y){
    var limit = this.getLimit();
    return [
      x.limit(limit[0][0], limit[0][1]),
      y.limit(limit[1][0], limit[1][1])
    ];
  }
});
