/**
 * Created by germanmontes on 30/09/14.
 */
var OverlayImage =  new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
        data: []
    },

    xmlType: 'slider',
    zoom: 'false',

    initialize: function(options) {
        document.widgetType ='imageOverlay',
        this.xmlType = $(options.container).get('data-xml-type');
    	this.zoom = $(options.container).get('data-zoom') || false;
        this.checkbox_mode = $(options.container).get('data-checkbox') || false;
        this.scalemarker = $(options.container).get('data-scalemarker') || false;
        this.scalemarker_source = $(options.container).get('data-scalemarker-source') || false;
        this.reveal_direction = $(options.container).get('data-reveal-direction') || 'ltr';
        options.extra = ["data-zoom","data-checkbox","data-scalemarker","data-scalemarker-type","data-scalemarker-source","data-reveal-direction"];
    	this.parent(options);

    	if(parent!=window){
            parent.postMessage({method:"widget-ready", edit_mode:this.isEditMode},"*");
        }

        this.addEvents();
    },

    customPostMessages:function(message,path) {
        var _this = this;

        if(message.data.event === 'on-update-widget-height'){
            // re render widget on next tick
            return setTimeout(function () {
                _this.render();
            }, 0);
        }

        switch(message.data.method){
        	case "retrieve-image-accessibility-list":
                if(parent!=window){
                    var image_list = [];

                	this.options.data.each(function (entry, index) {
		    			if(entry.Image.path) {
		    				image_list.push({
	                            image: entry.Image.path,
	                            text: entry.Image.alt
	                        });
		    			}
		            });

                    parent.postMessage({
                        method:"image-accessibility-list",
                        list:image_list
                    },"*");
                }
                break;

            case 'data-change':                
                this.options.data = message.data.data;
                this.render();
                break;
                
         	case "image-accessibility-text":
         		var i = 0;
         		this.options.data.each(function (entry, index) {
	    			if(entry.Image.path) {
	    				if(message.data.ind == i++) {
	    					entry.Image.alt = message.data.text;
	    				}
	    			}
	            });

	            this.saveRequest({method: 'mdData', options: {'json': this.options.data}});

                break;
            case "view-mode-switch":
                if(message.data.edit)
                    this.render();
                break;
        }
    },

    renderCheckboxes: function() {
    	if(this.xmlType == 'buttons') {
    		var overlays = [];
            var overlays_alt = [];
    		var checkbox_list = new Element('dl.overlays').inject($('image-overlay-wrapper'));

    		this.options.data.each(function (entry, index) {
    			if(index > 0 && entry.Image.path) {
    				overlays.push(entry.Image.path);
                    overlays_alt.push(entry.Image.alt);
    				new Element('dt', {html: ''}).inject(checkbox_list);
    				new Element('dd', {html: entry['Image Label']}).inject(checkbox_list);
    			}
            });

    		$('image-overlay-wrapper').set('data-overlay', overlays.join());
            $('image-overlay-wrapper').set('data-overlay-alt', JSON.stringify(overlays_alt));
    		$('image-overlay-wrapper').set('data-hide-slider', true);
    		$('image-overlay-wrapper').set('data-visible-extra-layers', false);
		}
    },

    render: function() {
        _this = this;

        clearTimeout(_this._rtlFlagTimer);

        $('image-overlay-wrapper').empty();
    	if(this.options.data[0] && this.options.data[0].Image.path) {
    		if(this.zoom == 'true') {
    			$('image-overlay-wrapper').set('data-show-navigator', 'true');
    		}
            
            if(this.checkbox_mode=="true"){
                $('image-overlay-wrapper').set('data-multiple-layer-checkbox', 'true');   
            }

            if(this.scalemarker=="true"){
                $('image-overlay-wrapper').set('data-scale-button',this.scalemarker_source);
            }
            var rtl_flag = false;
            if(this.xmlType=="slider" && this.reveal_direction=="rtl"){
                $('image-overlay-wrapper').set('data-reveal-direction','rtl');
                rtl_flag = true;
            }            

    		if(this.xmlType == 'slider' && this.options.data[1] && this.options.data[1].Image.path) {
    			$('image-overlay-wrapper').set('data-overlay', this.options.data[1].Image.path);
                $('image-overlay-wrapper').set('data-overlay-alt', this.options.data[1].Image.alt);
    		}

    		new Element('img', {
			    src: this.options.data[0].Image.path,
                'data-alt': this.options.data[0].Image.alt,
			    events: {
			        load: function(){                                                
			            this.set('width',this.width);
            			this.set('height',this.height);

                        _this.renderCheckboxes();

                        new StandardImageMap($$(".image_container"),{
	                        "zoomStep":100,
	                        "showZoomControls":true
	                    });

                        if(rtl_flag){
                            setTimeout(function initRtl () {
                                if (!$$(".imagemap-wrapper .overlays .overlays-inside")[0]) {
                                    // call initRtl until StandardImageMap mount overlay element
                                    _this._rtlFlagTimer = setTimeout(function () {
                                        initRtl();
                                    }, 250);

                                    return;
                                }

                                try {
                                    var current_image = $$(".imagemap-wrapper > img")[0];
                                    var image_to_reveal = current_image.clone();
    
                                    var image_wrapper = new Element("div.rtl-wrapper").setStyles({
                                        width: current_image.getWidth(),
                                        height: current_image.getHeight()
                                    });
                                    image_wrapper.inject($$(".imagemap-wrapper > img")[0],"before");
                                    image_wrapper.adopt($$(".imagemap-wrapper > img")[0]);
    
                                    image_wrapper.adopt($$(".imagemap-wrapper .overlays img")[0]);
                                    $$(".imagemap-wrapper .overlays .overlays-inside")[0].adopt(image_to_reveal);
                                } catch (error) {
                                    console.warn(error);
                                }
                            },0);
                        }

                        // prevent double render on edit mode
                        if (_this.isEditMode && !_this._initialized) {
                            _this._initialized = true;
                            setTimeout(function () {
                                _this.render();
                            }, 1000);
                        }
			        }
			    }
			}).inject($('image-overlay-wrapper'));
    	}
    },

    addEvents: function() {
        window.addEvent('resize', function(){
            var wrapper = $$('.imagemap-wrapper')[0];
            if(wrapper && !this.zoom){
                wrapper.setStyle('width', $(window).getWidth() + 'px');
                if( wrapper.getElement("> img") ) {
                    if( wrapper.getElement("> img").getWidth() > window.getWidth() ) {
                        wrapper.addClass('imagemap-wrapper-autosize');
                    } else {
                        wrapper.removeClass('imagemap-wrapper-autosize');
                    }
                }
            }
        }.bind(this));
    }
});
