InlineSelfQuiz = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    rd: null,
    data: {},
    settings: {},

    quiz: {
        attempt: 0,
        position: 0,
        total: 0
    },

    initialize: function (options){
        this.parent(options);
        
        this.data = this.options.data;
        this.settings = this.options.options;
        
        if (this.isEditMode) {
            this.renderEditMode();
        } else {
            this.renderPreviewMode();
        }

        window.addEvent('resize', function () {
            this.updateSize();
        }.bind(this));

        this.updateSize();
    },

    // FRAMEWORK Methods
    updateSize: function () {
        var introLine = $('intro-line');
        var footerHeight = 0;
        var introLineHeight = 0;
        var subtract = 0;
        var marginBottom = 47;
        var container;

        if (this.isEditMode) {
            container = $$('.table-container')[0];
            marginBottom = 70;
        } else {
            container = $$('.list-container')[0];

            footerHeight = 40;
            marginBottom = 50;
        }

        if (introLine) {
            introLineHeight = introLine.getHeight();
        }

        subtract = introLineHeight + footerHeight + marginBottom;

        container.setStyle('height', 'calc(100vh - ' + subtract + 'px)');
    },
    customPostMessages: function (message, path) {
        var method = message.data.method;

        switch (method) {
            case 'setting-change':
                var setting = message.data.update;
                var newSettings = JSON.parse(message.data.settings);

                this.settings = newSettings;
                this.saveSettings();

                break;

            case 'add-media':
                var target = message.data.target;
                var content = message.data.content;

                this.addMedia(target, content);
                
                break;

            case 'delete-media-confirm':
                var id = message.data.target;

                this.deleteMedia(id);

                break;

            case 'delete-item-confirm':
                var target = message.data.target;

                this.deleteItem(target);

                break;

            case 'delete-option-confirm':
                var id = message.data.target;
                var value = message.data.value;

                this.deleteOption(id, value);

                break;
        }
    },
    saveRequestPromise: function (remoteMethod, request) {
        var that = this;
        var promise =  new Promise(function (resolve, reject) {
            var formData = new FormData();
            var xhr = new XMLHttpRequest();

            request.path = '';
            request = JSON.stringify(request);
            formData.append('savedata', request);
            formData.append('widget_id', this.widget_id);

            xhr.open('POST', this.root + 'api/index.php/' + remoteMethod + '/');

            xhr.onload = function () {
                if (xhr.status === 200) {
                    var response = JSON.parse(xhr.responseText);
                    that.loadImagesTinyMCE();
                    resolve('Saved!');
                } else {
                    reject(xhr.status + ' ' + xhr.responseText);
                }
            };

            xhr.send(formData);
        }.bind(this));

        return promise;
    },
    saveSettings: function () {
        var request = {
            method: 'mdDataByID',
            selector: '#md-widget-data-options',
            variable_name: 'options',
            path: '',
            options: {
                json: this.settings
            }
        };

        return this.saveRequestPromise('save', request);
    },
    saveData: function () {
        var request = {
            method: 'mdData',
            variable_name: 'data',
            options: {
                json: this.data
            }
        };

        return this.saveRequestPromise('saveExternal', request);
    },
    notifyMediaUpdate: function () {
        if (parent && parent != window) {
            parent.postMessage({
                method: 'reload-accessibilty'
            }, '*');
        }
    },

    // COMMON Methods
    numberQuestions: function () {
        var questionNumbers = $$('.question-number');
        
        questionNumbers.each(function (question, index) {
            var number = (index + 1) + '.';
            question.set('html', number);
        });
    },
    updateTotalOfQuestions: function () {
        var totalOfQuestions = $$('.total-questions');
        var questionText = (this.data.length == 1)? 'question' : 'questions';
        var label = this.data.length + ' ' + questionText;
        
        totalOfQuestions.set('html', label);
    },
    getRandomValue: function () {
        return Math.floor((Math.random() * 10000) + 1);
    },
    mediaElement: function (media) {
        switch (media.type) {
            case 'image':
                return new Element('img', {
                    'class': 'item-image',
                    'tabindex': 0,
                    'src': media.path
                });

            case 'audio':
                return new Element('audio', {
                    'class': 'item-audio',
                    'controls': 'controls',
                    'tabindex': 0,
                    'src': media.path
                });

            case 'video':
                return new Element('video', {
                    'class': 'item-video',
                    'controls': 'controls',
                    'tabindex': 0,
                    'src': media.path
                });

            case 'iframe':
                var subtype = (media.subtype)? media.subtype : '';
                
                if (media.path.match(/mediaplayer.pearsoncmg.com/) && media.path.match(/audio/)) {
                    subtype = 'audio';
                }

                return new Element('iframe', {
                    'allowfullscreen': "true",
                    'webkitallowfullscreen': "true",
                    'mozallowfullscreen': "true",
                    'class': 'item-iframe ' + subtype,
                    'tabindex': 0,
                    'src': media.path
                });
        }
    },
    mediaControls: function (id) {
        var container = new Element('div.media-controls');
        var overlay = new Element('div.media-overlay');

        var edit = new Element('div', {
            'class': 'media-edit',
            'data-id': id,
            'html': '<i class="fa fa-pencil" data-id="' + id + '"></i>',
            events: {
                'click': this.addMediaModal.bind(this)
            }
        });

        var destroy = new Element('div', {
            'class': 'media-delete',
            'data-id': id,
            'html': '<i class="fa fa-times" data-id="' + id + '"></i>',
            events: {
                'click': this.deleteMediaConfirm.bind(this)
            }
        });

        container.grab(edit);
        container.grab(destroy);
        container.grab(overlay);

        return container;
    },
    findItemIndexById: function (id) {
        var itemIndex = -1;

        this.data.each(function (item, index) {
            if (id == item.id) {
                itemIndex = index;

                return true;
            }
        });

        return itemIndex;
    },
    findOptionIndexByIdAndValue: function (id, value) {
        var itemIndex = this.findItemIndexById(id);
        var optionIndex = -1;

        this.data[itemIndex].options.each(function (option, index) {
            if (Number(option.value) == Number(value)) {
                optionIndex = index;

                return true;
            }
        });

        return optionIndex;
    },

    /* EDIT Mode */

    // EDIT Actions
    addItem: function (e) {
        var correctOption = this.getRandomValue();

        var item = {
            id: this.getRandomValue(),
            type: 'multiple-choice',
            content: '',
            feedback: '',
            media: {
                type: '',
                path: ''
            },
            correct: correctOption,
            options: [
                {
                    label: '',
                    value: correctOption,
                    feedback: {
                        correct: '',
                        incorrect: ''
                    }
                },
                {
                    label: '',
                    value: this.getRandomValue(),
                    feedback: {
                        correct: '',
                        incorrect: ''
                    }
                },
                {
                    label: '',
                    value: this.getRandomValue(),
                    feedback: {
                        correct: '',
                        incorrect: ''
                    }
                },
                {
                    label: '',
                    value: this.getRandomValue(),
                    feedback: {
                        correct: '',
                        incorrect: ''
                    }
                }
            ]
        }

        this.data.push(item);

        this.saveData().then(
            function (response) {
                $$('table tbody')[0].grab(this.itemOnEdit(item))

                this.numberQuestions();
                this.updateTotalOfQuestions();
                this.initRedips();
                this.initTinyMCE();
                this.sortableOptions();
            }.bind(this), function (error) {
                console.warn(error);
            }
        );
    },
    itemDeleteConfirm: function (id) {
        if (parent && parent != window) {
            parent.postMessage({
                method: 'show-item-delete-confirm',
                target: id
            }, '*');
        }
    },
    deleteItem: function (id) {
        var itemIndex = this.findItemIndexById(id);

        this.data.splice(itemIndex, 1);

        this.saveData().then(
            function (response) {
                $$('tr[data-id="' + id + '"]')[0].destroy();

                this.numberQuestions();
                this.updateTotalOfQuestions();
                this.initRedips();
            }.bind(this), function (error) {
                console.warn(error);
            }
        );
    },
    initIntroLineTinyMCE: function () {
        var that = this;
        
        tinymce.init({
            selector: '#intro-line',
            inline: true,
            plugins: "charmap bdesk_photo codeTag codesample stixFormat",
            toolbar: 'undo redo | bold italic superscript subscript codeTag stixFormat | charmap codesample bdesk_photo indent outdent | alignleft aligncenter alignright',
            menubar: false,
            forced_root_block: 'div',
            formats: {
                StixFormat: {
                    inline: 'ins', 
                    classes: 'stix-format' 
                }
            },
            setup: function (editor) {
                editor.addCommand('afterImageUpload', function (ui, v) {
                    that.loadImagesTinyMCE();
                    that.notifyMediaUpdate();
                });
                editor.on('change', function(e) {
                    $(this.getElement()).fireEvent('input', [null, this.getElement()])
                });
            }
        });
    },
    initTinyMCE: function (e) {
        var that = this;
        tinymce.remove();

        tinymce.init({
            selector: '.richText',
            inline: true,
            plugins: "charmap bdesk_photo codeTag codesample stixFormat advlist positionfix",
            toolbar: 'undo redo | bold italic superscript subscript codeTag stixFormat bullist numlist | charmap codesample bdesk_photo indent outdent | alignleft aligncenter alignright',
            menubar: false,
            forced_root_block: 'div',
            formats: {
                StixFormat: {
                    inline: 'ins', 
                    classes: 'stix-format' 
                }
            },
            setup: function (editor) {
                editor.addCommand('afterImageUpload', function (ui, v) {
                    that.loadImagesTinyMCE();
                    that.notifyMediaUpdate();
                });
                editor.on('change', function(e) {
                    $(this.getElement()).fireEvent('input', [null, this.getElement()])
                });
            }
        });
    },
    loadImagesTinyMCE : function () {
        var tinymceImages = $$('.tinymce-image');
        
        tinymceImages.each(function (image, index) {
            var imageData = image.getAttribute('data-img');
                image.src = imageData;
        });
    },
    editQuestion: function (event, element) {
        var id, text, target, itemIndex;

        if (event != null) {
            target = event.target;
        } else {
            target = $(element);
        }

        id = target.getAttribute('data-id');    
        itemIndex = this.findItemIndexById(id);

        var content = target.clone();
        var images = content.getElements('img');

        images.each(function (image, index){
            image.setAttribute('src', '');
            image.removeClass('processed');
        });

        text = content.get('html');

        this.data[itemIndex].content = text;

        clearTimeout(this.saveTimer);
        this.saveTimer = setTimeout(function () {
            this.saveData();

            console.info('Question saved!');
        }.bind(this), 500);
    },
    addOption: function (e) {
        var id = e.target.getAttribute('data-id');
        var container = $$('.options[data-id="' + id + '"]')[0];
        var itemIndex = this.findItemIndexById(id);
        var item = this.data[itemIndex];
        var option = {
            label: '',
            value: this.getRandomValue(),
            feedback: {
                correct: '',
                incorrect: ''
            }
        };

        item.options.push(option);

        this.saveData().then(
            function (response) {
                container.grab(this.optionOnEdit(item, option));

                this.sortableOptions();
                this.initTinyMCE();

                console.log('Option added!');
            }.bind(this), function (error) {
                console.warn(error);
            }
        );
    },
    editOption: function (event, element) {
        var id, value, text, target, optionIndex;
        if (event != null) {
            target = event.target;
        } else {
            target = $(element);
        }

        id = target.getAttribute('data-id');
        value = target.getAttribute('data-value');
        itemIndex = this.findItemIndexById(id);
        optionIndex = this.findOptionIndexByIdAndValue(id, value);

        //remove image src and processed class
        //text = target.get('html');
        var content = target.clone();
        var images = content.getElements('img');

        images.each(function (image, index){
            image.setAttribute('src', '');
            image.removeClass('processed');
        });

        text = content.get('html');

        this.data[itemIndex].options[optionIndex].label = text;

        clearTimeout(this.saveTimer);
        this.saveTimer = setTimeout(function () {
            this.saveData();

            console.info('Option saved!');
        }.bind(this), 500);
    },
    editCorrectFeedbackOnOption: function (event, element) {
        var id, value, text, target, optionIndex;

        if (event != null) {
            target = event.target;
        } else {
            target = $(element);
        }

        id = target.getAttribute('data-id');
        value = target.getAttribute('data-value');
        itemIndex = this.findItemIndexById(id);
        optionIndex = this.findOptionIndexByIdAndValue(id, value);

        var content = target.clone();
        var images = content.getElements('img');

        images.each(function (image, index){
            image.setAttribute('src', '');
            image.removeClass('processed');
        });

        text = content.get('html');

        this.data[itemIndex].options[optionIndex].feedback.correct = text;

        clearTimeout(this.saveTimer);
        this.saveTimer = setTimeout(function () {
            this.saveData();

            console.info('Feedback Option saved!');
        }.bind(this), 500);
    },
    editIncorrectFeedbackOnOption: function (event, element) {
        var id, value, text, target, optionIndex;

        if (event != null) {
            target = event.target;
        } else {
            target = $(element);
        }

        id = target.getAttribute('data-id');
        value = target.getAttribute('data-value');
        itemIndex = this.findItemIndexById(id);
        optionIndex = this.findOptionIndexByIdAndValue(id, value);

        var content = target.clone();
        var images = content.getElements('img');

        images.each(function (image, index){
            image.setAttribute('src', '');
            image.removeClass('processed');
        });

        text = content.get('html');

        this.data[itemIndex].options[optionIndex].feedback.incorrect = text;

        clearTimeout(this.saveTimer);
        this.saveTimer = setTimeout(function () {
            this.saveData();

            console.info('Feedback Option saved!');
        }.bind(this), 500);
    },
    optionDeleteConfirm: function (id, value) {
        if (parent && parent != window) {
            parent.postMessage({
                method: 'show-option-delete-confirm',
                target: id,
                value: value
            }, '*');
        }
    },
    deleteOption: function (id, value) {
        var itemIndex = this.findItemIndexById(id);
        var optionIndex = this.findOptionIndexByIdAndValue(id, value);

        this.data[itemIndex].options.splice(optionIndex, 1);

        this.saveData().then(
            function (response) {
                var target = $$('.destroy[data-id="' + id + '"][data-value="' + value + '"]');
                
                target.getParent().dispose();
            }.bind(this), function (error) {
                console.warn(error);
            }
        );
    },
    openOptionFeedback: function (e) {
        var target = e.target;
        var id = target.getAttribute('data-id');
        var value = target.getAttribute('data-value');
        var correct = $$('.correct[data-id="' + id + '"][data-value="' + value + '"]');
        var incorrect = $$('.incorrect[data-id="' + id + '"][data-value="' + value + '"]');

        correct.toggle();
        incorrect.toggle();

        target.toggleClass('open');
    },
    setCorrectOption: function (e) {
        var id = e.target.getAttribute('data-id');
        var value = e.target.getAttribute('data-value');
        var itemIndex = this.findItemIndexById(id);

        this.data[itemIndex].correct = value;

        var li = e.target.getParent();
        var ul = li.getParent();
        var options = ul.getChildren('li');

        options.removeClass('selected');
        li.addClass('selected');

        var allCorrect = options.getChildren('.option-feedback .correct');
        var allIncorrect = options.getChildren('.option-feedback .incorrect');
        var correctSelected = li.getChildren('.option-feedback .correct');
        var incorrectSelected = li.getChildren('.option-feedback .incorrect');

        allCorrect.each(function (correct, index) {
            correct.removeClass('richText').addClass('disabled');
        });
        
        allIncorrect.each(function (incorrect, index) {
            incorrect.removeClass('disabled').addClass('richText');
        });
        
        correctSelected.removeClass('disabled').addClass('richText');
        incorrectSelected.removeClass('richText').addClass('disabled');
        
        clearTimeout(this.saveTimer);
        this.saveTimer = setTimeout(function () {
            this.saveData();
            this.initTinyMCE();
            console.info('Radio saved!');
        }.bind(this), 500);
    },
    sortableOptions: function () {
        var sortables = new Sortables('.options', {
            revert: true,
            handle: '.drag-icon',

            onStart: function (el) {
                el.setStyle('opacity', 0.6);
                el.setStyle('box-shadow', '0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23)');
            },

            onComplete: function (el) {
                el.setStyle('box-shadow', 'none');

                var id = el.getAttribute('data-id');
                var options = $$('.option[data-id="' + id + '"]');

                var newOptions = [];

                options.each(function (option, index) {
                    var value = option.getAttribute('data-value');
                    var label = $$('.label[data-id="' + id + '"][data-value="' + value + '"]');
                    var labelText = label[0].get('html');
                    var correct = option.getElement('.correct')
                    var correctText = correct.get('html')
                    var incorrect = option.getElement('.incorrect')
                    var incorrectText = incorrect.get('html')

                    newOptions.push({
                        label: labelText,
                        value: value,
                        feedback: {
                            correct: correctText,
                            incorrect: incorrectText
                        }
                     });
                });

                var itemIndex = this.findItemIndexById(id)


                this.data[itemIndex].options = newOptions;

                this.saveData().then(
                    function (response) {
                        console.log('Options reorder saved!');

                    }.bind(this), function (error) {
                        console.warn(error);
                    }
                );
            }.bind(this)
        });
    },
    selectRadioButton: function (e) {
        var target = e.target;
        var maxParent = 10;
        var counter = 0;

        e.preventDefault();

        while (! target.hasClass('label') && counter < maxParent) {
            target = target.getParent();

            counter++;
        }
        
        if (e.key == "enter" || e.key == "space" || e.event.type == 'click') {
            var id = target.getAttribute('data-radio-id');
            var radio = $$('.radio[id="' + id + '"]')[0];

            if (! target.hasClass('evaluated')) radio.click();    
        }
    },
    addMediaModal: function (e) {
        var id = e.target.getAttribute('data-id');
        
        if (parent && parent != window) {
            parent.postMessage({
                method: 'show-add-media',
                target: id
            }, '*');
        }
    },
    addMedia: function (id, file) {
        var saveMethod;
        var containerClass;
        
        if (id == -1) {
            this.settings.media = {
                type: file.type,
                subtype: file.subtype,
                path: file.path
            };

            containerClass = '.main-media-container';
            saveMethod = this.saveSettings.bind(this);

        } else {
            var itemIndex = this.findItemIndexById(id);

            this.data[itemIndex].media = {
                type: file.type,
                subtype: file.subtype,
                path: file.path
            };

            containerClass = '.media-container';
            saveMethod = this.saveData.bind(this);
        }

        saveMethod().then(function (response) {
            var container = $$(containerClass + '[data-id="' + id + '"]')[0];
            
            container.empty();
            container.grab(this.mediaElement(file));
            container.grab(this.mediaControls(id));

            this.notifyMediaUpdate();
        }.bind(this), function (error) {
            console.warn(error);
        });
    },
    deleteMediaConfirm: function (e) {
        var id = e.target.getAttribute('data-id');

        if (parent && parent != window) {
            parent.postMessage({
                method: 'show-delete-media-confirm',
                target: id
            }, '*');
        }
    },
    deleteMedia: function (id) {
        var saveMethod;
        var containerClass;
        var buttonClass;

        if (id == -1) {
            this.settings.media = {
                type: '',
                path: ''
            };

            containerClass = '.main-media-container';
            buttonClass = 'add-main-media';
            saveMethod = this.saveSettings.bind(this);
        } else {
            var itemIndex = this.findItemIndexById(id);

            this.data[itemIndex].media = {
                type: '',
                path: ''
            };

            containerClass = '.media-container';
            buttonClass = 'add-media';
            saveMethod = this.saveData.bind(this);
        }

        saveMethod().then(function (response) {
            var container = $$(containerClass + '[data-id="' + id + '"]')[0];
            
            container.empty();
            container.grab(this.addMediaButtonOnEdit(id, buttonClass));

            this.notifyMediaUpdate();

        }.bind(this), function (error) {
            console.warn(error);
        });
    },
    editFeedback: function (event, element) {
        var id, text, target, index;

        if (event != null) {
            target = event.target;
        } else {
            target = $(element);
        }

        id = target.getAttribute('data-id');
        text = target.get('html');
        index = this.findItemIndexById(id);
        
        this.data[index].feedback = text;

        clearTimeout(this.saveTimer);
        this.saveTimer = setTimeout(function () {
            this.saveData();

            console.info('Feedback saved!');
        }.bind(this), 500);  
    },
    initRedips: function () {
        this.rd = REDIPS.drag;

        this.rd.useHandler = true;
        this.rd.shift.mode = 'vertical2';
        this.rd.dropMode = 'shift';
        this.rd.init('assessment-area');

        // Events
        this.rd.event.moved = function (target) {
            this.rd.obj.addClass('dragged');
        }.bind(this)
        this.rd.event.dropped = function (target) {
            var positions = this.rd.getPosition();
            var origin = positions[4];
            var destination = positions[1];

            this.rd.obj.removeClass('dragged');

            var removedItem = this.data.splice(origin, 1);
            
            this.data.splice(destination, 0, removedItem[0]);
            
            this.saveData().then(
                function (response) {
                    var tr = $$('#list tr');
                
                    // reorder TR data-id
                    this.data.each(function (item, index) {
                        tr[index].setAttribute('data-id', item.id);
                    });

                    this.numberQuestions();

                    console.log('Reorder saved!');
                }.bind(this), function (error) {
                    console.warn(error);
                }
            );
        }.bind(this);
    },

    // EDIT Render Elements
    optionOnEdit: function (item, option) {
        var id = option.value + 'op' + option.value;
        var isSelected = (option.value == item.correct) ? true : false;

        var li = new Element('li', {
            'class': 'option',
            'data-id': item.id,
            'data-value': option.value
        });

        var radio = new Element('input', {
            'id': id,
            'name': 'op' + item.id,
            'type': 'radio',
            'class': 'option-radio',
            'data-id': item.id,
            'data-value': option.value,
            'checked': isSelected,
            events: {
                'click': this.setCorrectOption.bind(this)
            }
        });

        var label = new Element('div',{
            'class': 'label text richText',
            'data-placeholder': 'Type an answer here',
            'data-id': item.id,
            'data-value': option.value,
            'data-md-editable': 'md-content-editable',
            'contenteditable': true,
            'html': option.label,
            events: {
                'input': this.editOption.bind(this)
            }
        });

        var drag = new Element('div', {
            'class': 'drag drag-icon',
            'data-id': item.id,
            'data-value': option.value
        });

        var destroy = new Element('div', {
            'class': 'destroy destroy-icon fa fa-trash-o',
            'data-id': item.id,
            'data-value': option.value,
            events: {
                'click': this.optionDeleteConfirm.pass([item.id, option.value])
            }
        });

        var feedback = new Element('div.option-feedback');

        var title = new Element('div.title', {
            'class': 'title',
            'data-id': item.id,
            'data-value': option.value,
            'html': 'Feedback',
            events: {
                'click': this.openOptionFeedback
            }
        });

        var correct = new Element('div', {
            'class': 'correct',
            'data-id': item.id,
            'data-value': option.value,
            'data-md-editable': 'md-content-editable',
            'html': option.feedback.correct,
            events: {
                'input': this.editCorrectFeedbackOnOption.bind(this)
            }
        });

        var incorrect = new Element('div', {
            'class': 'incorrect',
            'data-id': item.id,
            'data-value': option.value,
            'data-md-editable': 'md-content-editable',
            'html': option.feedback.incorrect,
            events: {
                'input': this.editIncorrectFeedbackOnOption.bind(this)
            }
        });

        if (isSelected) {
            li.addClass('selected');
            correct.addClass('richText');
            incorrect.addClass('disabled');
        } else {
            correct.addClass('disabled');
            incorrect.addClass('richText');
        }

        feedback.grab(title);
        feedback.grab(correct);
        feedback.grab(incorrect);

        li.grab(radio);
        li.grab(label);
        li.grab(drag);
        li.grab(destroy);
        li.grab(feedback);

        return li;
    },
    addMediaButtonOnEdit : function (id, classes) {
        return new Element('button', {
            'class': classes,
            'data-id': id,
            'html': '<i class="fa fa-plus" data-id="' + id + '"></i> Add Media',
            events: {
                'click': this.addMediaModal.bind(this)
            }
        });
    },
    mediaOnEdit: function (id, media, containerClass, buttonClass) {
        var container = new Element('div', {
            'class': containerClass,
            'data-id': id
        });

        if (media.path.trim().length) {
            container.grab(this.mediaElement(media));
            container.grab(this.mediaControls(id));
        } else {
            container.grab(this.addMediaButtonOnEdit(id, buttonClass))
        }

        return container;
    },
    addItemButtonOnEdit: function () {
        var button = new Element('button', {
            'class': 'add-item',
            'html': '<i class="fa fa-plus"></i> Add New Question',
            events: {
                'click': this.addItem.bind(this)
            }
        });

        var actions = new Element('div.actions');
        actions.grab(button);

        return actions;
    },
    itemOnEdit: function (item) {
        switch (item.type) {
            case 'multiple-choice':
                return this.multipleChoiceOnEdit(item);
        }
    },
    multipleChoiceOnEdit: function (item) {
        var tr = new Element('tr', {
            'data-id': item.id
        });
        var td = new Element('td');

        var container = new Element('div', {
            'class': 'item redips-drag',
            'data-id': item.id,
            'data-type': item.type
        });

        var nonDraggable = new Element('div.non-draggable');

        var draggable = new Element('div', {
            'class': 'drag drag-icon redips-handler',
            'data-id': item.id
        });

        var destroy = new Element('div', {
            'class': 'destroy destroy-icon',
            'data-id': item.id,
            events: {
                'click': this.itemDeleteConfirm.pass(item.id)
            }
        });

        var controls = new Element('div.controls');
        controls.grab(destroy);
        controls.grab(draggable);

        var questionNumber = new Element('div', {
            'class': 'question-number',
            'html': '.'
        });

        var question = new Element('div', {
            'class': 'question text richText',
            'data-id': item.id,
            'data-placeholder': 'Type question here',
            'data-md-editable': 'md-content-editable',
            'contenteditable': true,
            'html': item.content,
            events: {
                'input': this.editQuestion.bind(this)
            }
        });

        var options = new Element('ul', {
            'class': 'options',
            'data-id': item.id
        });

        item.options.each(function (option, index) {
            options.grab(this.optionOnEdit(item, option));

        }.bind(this));

        var addOptionContainer = new Element('div',{
            'class': 'add-option-container',
            'data-id': item.id
        });
        var addOption = new Element('span', {
            'class': 'add-option',
            'data-id': item.id,
            'html': '<i class="fa fa-plus" data-id="' + item.id + '"></i> Add Answer',
            events: {
                'click': this.addOption.bind(this)
            }
        });

        addOptionContainer.grab(addOption);

        var feedback = new Element('div', {
            'class': 'feedback text richText',
            'data-id': item.id,
            'data-placeholder': 'Type feedback here',
            'data-md-editable': 'md-content-editable',
            'contenteditable': true,
            'html': item.feedback,
            events: {
                'input': this.editFeedback.bind(this)
            }
        });

        nonDraggable.grab(this.mediaOnEdit(item.id, item.media, 'media-container', 'add-media'));
        nonDraggable.grab(questionNumber);
        nonDraggable.grab(question);
        nonDraggable.grab(options);
        nonDraggable.grab(addOptionContainer);
        nonDraggable.grab(feedback);

        container.grab(controls);
        container.grab(nonDraggable);

        td.grab(container);
        tr.grab(td);

        return tr;
    },
    renderEditMode: function () {
        var assessmentArea = $('assessment-area');
        var totalOfQuestions = new Element('div.total-questions');
        var tableContainer = new Element('div.table-container');
        var table = new Element('table#list');
        var tbody = new Element('tbody');
        
        this.data.each(function (item, index) {
            tbody.grab(this.itemOnEdit(item));

        }.bind(this));
        
        assessmentArea.addClass('edit');
        assessmentArea.grab(totalOfQuestions);
        assessmentArea.grab(tableContainer);
        table.grab(tbody);
        tableContainer.grab(this.mediaOnEdit(-1, this.settings.media, 'main-media-container', 'add-main-media'));
        tableContainer.grab(table);
        tableContainer.grab(this.addItemButtonOnEdit());

        this.updateTotalOfQuestions();
        this.sortableOptions();
        this.initRedips();
        this.numberQuestions();

        //TinyMCE
        this.initTinyMCE();
        this.loadImagesTinyMCE();
        this.initIntroLineTinyMCE();
    },

    /* PREVIEW Mode */
    /* RENDER on Preview */
    mediaOnPreview: function (media, classes) {
        var container = new Element('div', {
            'class': classes
        });

        if (media.path.trim().length) {
            container.grab(this.mediaElement(media));
        }

        return container;
    },
    itemOnPreview: function (item, index) {
        switch (item.type) {
            case 'multiple-choice':
                return this.multipleChoiceOnPreview(item, index);
        }
    },
    optionOnPreview: function (item, option, container) {
        var id = option.value + 'op' + option.value;

        var radio = new Element('input', {
            'id': id,
            'name': 'op' + item.id,
            'type': 'radio',
            'class': 'radio',
            'data-id': item.id,
            'data-value': option.value,
            'aria-describedby': this.settings.response == 'immediate'? "i"+ item.id : null
        });
        if(this.settings.response == 'immediate'){
            var instruccions = new Element('span.radio-instruction.visually-hidden#i'+item.id, {
                text : "Press enter after select an option to check the answer",
                'aria-hidden': true
            })
        }
        var label = new Element('label', {
            'class': 'label text',
            'data-radio-id': id,
            'html': option.label,
            'id': 'label-'+ item.id,
            'for':id,
            events: {
                // 'keypress': this.selectRadioButton.bind(this),
                // 'click': this.selectRadioButton.bind(this),
            }

        });

        var feedback = new Element('div', {
            'class': 'option-feedback',
            'data-radio-id': id
        });

        var correct = new Element('div', {
            'class': 'correct',
            'data-id': item.id,
            'data-value': option.value,
            'html': option.feedback.correct
        });

        var incorrect = new Element('div', {
            'class': 'incorrect',
            'data-id': item.id,
            'data-value': option.value,
            'html': option.feedback.incorrect
        });

        if (correct.get('text').trim().length) {
            feedback.grab(correct);
        }
        if (incorrect.get('text').trim().length) {
            feedback.grab(incorrect);    
        }

        var br = new Element('div.break');

        container.grab(radio);
        container.grab(label);
        container.grab(feedback);
        if(this.settings.response == 'immediate'){container.grab(instruccions)}
        container.grab(br);
    },
    controlsOnPreview: function () {
        var container = new Element('div.controls');

        var checkAnswer = new Element('button', {
            'class': 'check-answer',
            'disabled': true,
            'html': 'Check Answer'
        }).hide();

        var tryAgain = new Element('button', {
            'class': 'try-again',
            'disabled': true,
            'html': 'Try Again'
        }).hide();

        var restart = new Element('button', {
            'class': 'restart',
            'disabled': true,
            'html': 'Restart'
        }).hide();

        var reset = new Element('button', {
            'class': 'reset',
            'disabled': true,
            'html': 'Reset'
        }).hide();

        var next = new Element('button', {
            'class': 'next',
            'disabled': true,
            'html': 'Next'
        }).hide();

        container.grab(checkAnswer);
        container.grab(tryAgain);
        container.grab(restart);
        container.grab(reset);
        container.grab(next);

        return container;
    },
    footerOnPreview: function () {
        var container = new Element('div.footer');
        var feedback = new Element('div.feedback');

        container.grab(feedback);
        container.grab(this.controlsOnPreview());

        return container;
    },
    multipleChoiceOnPreview: function (item, index) {

        var li = new Element('li', {
            'class': 'item',
            'data-id': item.id,
            'data-type': item.type
        });

        var number = new Element('div', {
            'class': 'index-number',
            'text': (index + 1) + '.'
        });

        var question = new Element('legend', {
            'class': 'question text',
            'tabindex': 0,
            'html': item.content
        });

        question.set('aria-label', (index + 1) + '. ' + question.textContent);

        var options = new Element('fieldset.options');

        if (this.settings.answerOrder == 'random') {
            item.options.shuffle()
        }
        options.grab(question);
        // console.log(question)
        // console.log(question.getElement('div'))
        // this.mediaOnPreview(item.media, 'media-container').inject(question.getElement('div'), 'before');
        //number.inject(question.getElement('div'),'before');
        item.options.each(function (option, index) {
            this.optionOnPreview(item, option, options);

        }.bind(this));

        li.grab(number);
        li.grab(this.mediaOnPreview(item.media, 'media-container'));
        li.grab(question);
        li.grab(options);

        var feedback = new Element('div', {
            'class': 'feedback',
            'data-id': item.id,
            'html': item.feedback
        });

        if (feedback.get('text').trim().length) {
            li.grab(feedback);
        }

        return li;
    },
    renderPreviewMode: function () {
        var assessmentArea = $('assessment-area');        
        var listContainer = new Element('div.list-container');
        var totalOfQuestions = new Element('div.total-questions');
        var list = new Element('ol', {
            'class': 'items',
            'type': 1
        });

        if (this.settings.order == 'random') {
            this.data.shuffle();
        }

        this.data.each(function (item, index) {
            list.grab(this.itemOnPreview(item, index));
        }.bind(this));

        assessmentArea.addClass('preview');
        assessmentArea.grab(totalOfQuestions);
        assessmentArea.grab(listContainer);
        listContainer.grab(this.mediaOnPreview(this.settings.media, 'main-media-container'));
        listContainer.grab(list);
        
        assessmentArea.grab(this.footerOnPreview());

        this.updateTotalOfQuestions();
        this.loadImagesTinyMCE();
        this.startQuiz();
    },

    /* QUIZ */
    showScoring: function () {
        var mainMedia = $$('.preview .main-media-container')[0];
        var scoring = new Element('div.scoring');
        var oks = 0;

        if (this.quiz.mode == 'one' && this.quiz.response == 'delayed') {
            oks = $$('.item.ok').length;
            scoring.set('html', 'You answered ' + oks + ' out of ' + this.quiz.total + ' questions correctly.');

        } else {
            // Mode: one or all
            // Response: immediate

            oks = $$('.item.first-attempt').length;
            scoring.set('html', 'You answered ' + oks + ' out of ' + this.quiz.total + ' questions correctly on the first attempt.');
        }

        // show feedback
        var feedbacks = $$('.feedback');
        feedbacks.show();
        try{
          $$('.item.fail').map(function(fail){
              var question = fail.getElement('.question')
              var okLabel = fail.getElement('label.ok').get('html')
              var failLabel = fail.getElement('label.fail').get('html')
              question.grab(new Element('.result-actual.visually-hidden', {
                  html: 'You answered: ' + failLabel + '.'
              }))
              question.grab(new Element('.result-should.visually-hidden',{
                  html: 'Correct answer was: ' + okLabel + '.'
              }))
          })

          $$('.item.ok').map(function(ok){
              var question = ok.getElement('.question')
              var okLabel = ok.getElement('label.ok').get('html')
              question.grab(new Element('.result-actual.visually-hidden', {
                  html: 'You correctly answered: ' + okLabel + '.'
              }))
          })
        }catch(e){}

        scoring.inject(mainMedia, 'after');


        //Scroll to scoring
        var myFx = new Fx.Scroll($$('.list-container')[0], {
            duration: 300
        });
        myFx.toElement(scoring);
        setTimeout(function(){
            $$('.scoring')[0].set('tabindex',0).focus()
        },0)
    },
    isAnswered: function (item) {
        var type = item.getAttribute('data-type');
        var answered = false;

        switch (type) {
            case 'multiple-choice':
                var checked = item.getChildren('.options .radio').filter('.radio:checked');
                
                if (checked.length) answered = true;
                    
                break;
        }

        return answered;
    },
    evalMultipleChoice: function (itemElement, attempt) {
        var id = itemElement.getAttribute('data-id');
        var index = this.findItemIndexById(id);
        var item = this.data[index];
        var correct = item.correct;
        var radios = itemElement.getChildren('.options .radio');
        var status = 'ok';

        radios.each(function (radio, index) {
            var id = radio.id;
            var label = $$('.label[data-radio-id="' + id + '"]');
            var optionFeedback = $$('.option-feedback[data-radio-id="' + id + '"]');
            var value = radio.getAttribute('data-value');

            radio.removeClass('ok fail');
            label.removeClass('ok fail evaluated');
            optionFeedback.removeClass('ok fail');

            radio.setAttribute('disabled', 'disabled');

            if (radio.get('checked')) {
                if (value == correct) {
                    radio.addClass('ok');
                    label.addClass('ok');
                    optionFeedback.addClass('ok').set('tabindex',-1)
                    if (optionFeedback.getElement('.short-feedback')[0]) {
                        optionFeedback.getElement('.short-feedback')[0].remove()
                    }
                    optionFeedback[0].grab(new Element('span.short-feedback.visually-hidden', {
                        text: "Correct! "
                    }), 'top')

                    optionFeedback[0].focus()

                    if (attempt == 1) itemElement.addClass('first-attempt');
                } else {
                    status = 'fail';
                    radio.addClass('fail');
                    label.addClass('fail');
                    optionFeedback.addClass('fail').set('tabindex',-1);

                    if (optionFeedback.getElement('.short-feedback')[0]) {
                        optionFeedback.getElement('.short-feedback')[0].remove()
                    }
                    optionFeedback[0].grab(new Element('span.short-feedback.visually-hidden', {
                        text: "Incorrect! "
                    }), 'top')
                    if(attempt > 1){
                        var _correct = '' + correct + 'op' + correct
                        optionFeedback[0].grab(new Element('span.correct-answer.visually-hidden',{
                            html: 'The correct answer was: ' + $(_correct).nextSibling.innerHTML
                        }))
                    }

                    optionFeedback[0].focus()
                }

            } else {
                if (value == correct) {
                    status = 'fail';

                    if (this.quiz.response == 'immediate') {
                        if (attempt == this.quiz.maxAttempts) {
                            radio.addClass('ok');
                            label.addClass('ok');
                        } else {
                            radio.addClass('pass');
                            label.addClass('pass');
                        }
                    } else {
                        radio.addClass('ok');
                        label.addClass('ok');
                    }
                } else {
                    radio.addClass('pass');
                }

            }

            label.addClass('evaluated');
        }.bind(this));

        itemElement.removeClass('ok fail').addClass(status);

        // show feedback when the answers is ok
        var feedback = $$('.feedback[data-id="' + id + '"]');
        if (status == 'ok') {
            feedback.show();
        }

        // show feedback when reach max attempts on one + immediate
        if (this.quiz.mode == 'one' && this.quiz.response == 'immediate') {
            if (this.quiz.attempt == this.quiz.maxAttempts) {
                feedback.show();    
            }
        }

        return status;
    },
    enableCheckAnswerAllMode: function (e) {
        var checkAnswer = $$('.footer .check-answer')[0];
        var items = $$('.item');
        var isEnabled = true;

        items.each(function (item, index) {
            if (this.isAnswered(item) == false ) isEnabled = false;
            
        }.bind(this));

        if (isEnabled) {
            checkAnswer.removeProperty('disabled');
        }
    },
    updateFeedback: function (message) {
        var feedback = $$('.footer .feedback')[0];

        feedback.set('html', message);
    },
    resetAllMode: function () {
        var items = $$('.item');
        var tryAgain = $$('.footer .try-again')[0];
        var reset = $$('.footer .reset')[0];
        var checkAnswer = $$('.footer .check-answer')[0];
        var feedbacks = $$('.item .feedback');
        var scoring = $$('div.scoring');

        items.each(function (item, index) {
            var radios = item.getChildren('.options .radio');
            var labels = item.getChildren('.options .label');
            var optionFeedbacks = item.getChildren('.options .option-feedback');

            item.removeClass('fail first-attempt');
            radios.removeClass('ok fail pass');
            labels.removeClass('ok fail evaluated');
            optionFeedbacks.removeClass('ok fail');

            radios.set('checked', false);
            radios.set('disabled', false);
        });

        this.updateFeedback('');
        
        this.quiz = {
            position: 0,
            mode: this.settings.presentation,
            response: this.settings.response,
            attempt: 0,
            maxAttempts: this.settings.maxAttempts,
            total: this.data.length
        };

        feedbacks.hide()

        if (this.quiz.response == 'immediate') {
            reset.hide();
            checkAnswer.hide();
            tryAgain.show();
        } else {
            reset.hide();
            checkAnswer.show();    
        }

        if (scoring.length > 0) {
            scoring.dispose();
        }
        $$('.result-actual,.result-should,.short-feedback').map(function(trash){
            trash.remove()
        })

        setTimeout(function(){

            $$('.item')[0].getElement('legend').focus()
        },0)
    },
    tryAgainAllMode: function () {
        var items = $$('.item');
        var tryAgain = $$('.footer .try-again')[0];
        var checkAnswer = $$('.footer .check-answer')[0];

        items.each(function (item, index) {
            if (item.hasClass('fail')) {
                var id = item.getAttribute('data-id');
                var radios = item.getChildren('.options .radio');
                var labels = item.getChildren('.options .label');
                var optionFeedback = item.getChildren('.options .option-feedback');
                var feedback = $$('.feedback[data-id="' + id + '"]');

                feedback.hide();
                item.removeClass('fail');
                radios.removeClass('ok fail pass');
                labels.removeClass('ok fail evaluated');
                optionFeedback.removeClass('ok fail');

                radios.set('checked', false);
                radios.set('disabled', false);
            }
        });

        if (this.quiz.response == 'immediate') {
            tryAgain.setAttribute('disabled', 'disabled');
            tryAgain.show();
        } else {
            tryAgain.setAttribute('disabled', 'disabled');
            tryAgain.hide();
            checkAnswer.show();    
        }
        items[0].getElement('legend').focus()
    },
    enableTryAgainImmediateAllMode: function () {
        var tryAgain = $$('.footer .try-again')[0];
        var reset = $$('.footer .reset')[0];
        var items = $$('.item');
        var isEnabled = true;
        var isOk = 0;

        items.each(function (item, index) {
            if (this.isAnswered(item) == false ) isEnabled = false;
            if (item.hasClass('ok')) isOk++;
        }.bind(this));
        
        if (isEnabled) {
            this.quiz.attempt++;
            this.updateFeedback('Try ' + this.quiz.attempt + ' of ' + this.quiz.maxAttempts);

            if (isOk == this.quiz.total) {
                tryAgain.hide()
                reset.removeProperty('disabled');
                reset.show();

                this.showScoring();
            } else {
                if (this.quiz.attempt < this.quiz.maxAttempts) {
                    tryAgain.removeProperty('disabled');
                } else {
                    tryAgain.hide()
                    reset.removeProperty('disabled');
                    reset.show();

                    this.showScoring();
                }
            }
        }
    },
    checkAnswerImmediateAllMode: function (event) {
        if(event.type !== "keypress"){
            //real click!
            if(!event.page.x && !event.page.y) return
        }else{

            var wasEnterPressed = event.code == 13 || event.which == 13 || event.keyCode == 13;
            var wasSpacePressed = event.code == 32 || event.which == 32 || event.keyCode == 32;
            if(!wasEnterPressed && !wasSpacePressed){
                return
            }
            event.target.checked = true
        }
        var target = event.target;
        var id = target.getAttribute('data-id');
        var item = $$('.item[data-id="' + id + '"]')[0];
        var attempt = this.quiz.attempt + 1;

        switch (item.getAttribute('data-type')) {
            case 'multiple-choice':
                status = this.evalMultipleChoice(item, attempt);
                
                break;
        }

        this.enableTryAgainImmediateAllMode();
    },
    checkAnswerAllMode: function () {
        var reset = $$('.footer .reset')[0];
        var tryAgain = $$('.footer .try-again')[0];
        var checkAnswer = $$('.footer .check-answer')[0];
        var items = $$('.item');
        var ok = 0;

        this.quiz.attempt++;

        items.each(function (item, index) {
            var status;

            switch (item.getAttribute('data-type')) {
                case 'multiple-choice':
                    status = this.evalMultipleChoice(item, this.quiz.attempt);

                    break;
            }

            if (status == 'ok') ok++;
            
        }.bind(this)); 

        checkAnswer.setAttribute('disabled', 'disabled');
        checkAnswer.hide();

        if (ok == this.quiz.total) {
            reset.removeProperty('disabled');
            reset.show();
            
            this.updateFeedback('Correct.');

            this.showScoring();

        } else {
            if (this.quiz.attempt < this.quiz.maxAttempts) {
                tryAgain.removeProperty('disabled');
                tryAgain.show();    

            } else {
                reset.removeProperty('disabled');
                reset.show();

                this.showScoring();
            }

            this.updateFeedback('Try ' + this.quiz.attempt + ' of ' + this.quiz.maxAttempts);
        }
    },
    setAllMode: function () {
        var checkAnswer = $$('.footer .check-answer')[0];
        checkAnswer.addEvent('click', this.checkAnswerAllMode.bind(this));

        var tryAgain = $$('.footer .try-again')[0];
        tryAgain.addEvent('click', this.tryAgainAllMode.bind(this));

        var reset = $$('.footer .reset')[0];
        reset.addEvent('click', this.resetAllMode.bind(this));
        
        checkAnswer.show();
        tryAgain.hide();
        reset.hide();

        // Radio
        var radios = $$('.options .radio');

        if (this.quiz.response == 'immediate') {
            radios.addEvent('click', this.checkAnswerImmediateAllMode.bind(this));
            radios.addEvent('keypress', this.checkAnswerImmediateAllMode.bind(this));
            checkAnswer.hide();
            tryAgain.show();
            reset.hide();
        } else {
            radios.addEvent('click', this.enableCheckAnswerAllMode.bind(this));  
            checkAnswer.show();
            tryAgain.hide();
            reset.hide();  
        }
        
    },

    /* ONE Mode */
    nextOneMode: function () {
        var reset = $$('.footer .reset')[0];
        var items = $$('.item');
        var item = items[this.quiz.position];
        var next = $$('.footer .next')[0];

        item.hide();
        
        this.quiz.attempt = 0;
        this.quiz.position++;

        this.updateFeedback('');

        if (this.quiz.position < this.quiz.total) {

            item = items[this.quiz.position];
            item.show();

            item.getElement('legend').focus()
            next.setAttribute('disabled', 'disabled');
        } else {
            if (this.quiz.response == 'delayed') {
                items.each(function (item, index) {

                    switch (item.getAttribute('data-type')) {
                        case 'multiple-choice':
                            this.evalMultipleChoice(item);

                            break;
                    }
                }.bind(this));
            }

            this.showScoring();

            next.hide();
            items.show();
            $$('.item')[0].getElement('legend').focus()
            $$('.radio-instruction').map(function(instruction){
                instruction.remove()
            })
            reset.removeProperty('disabled');
            reset.show();
        }
        
    },
    tryAgainOneMode: function () {
        var next = $$('.footer .next')[0];
        var tryAgain = $$('.footer .try-again')[0];
        var items = $$('.item');
        var item = items[this.quiz.position];

        var radios = item.getChildren('.options .radio');
        var labels = item.getChildren('.options .label');
        var optionFeedback = item.getChildren('.options .option-feedback');

        item.removeClass('fail');
        radios.removeClass('ok fail pass');
        labels.removeClass('ok fail evaluated');
        optionFeedback.removeClass('ok fail');
        radios.set('checked', false);
        radios.set('disabled', false);

        next.setAttribute('disabled', 'disabled');
        next.show();

        tryAgain.setAttribute('disabled', 'disabled');
        tryAgain.hide()
        item.getElement('legend').focus()
    },
    enableNextOneMode: function (e) {
        if(e.type !== "keypress"){
            //real click!
            if(!e.page.x && !e.page.y) return
        }else{

            var wasEnterPressed = e.code == 13 || e.which == 13 || e.keyCode == 13;
            var wasSpacePressed = e.code == 32 || e.which == 32 || e.keyCode == 32;
            if(!wasEnterPressed && !wasSpacePressed){
                return
            }
            e.target.checked = true
        }
        var checkAnswer = $$('.footer .check-answer')[0];
        var tryAgain = $$('.footer .try-again')[0];
        var next = $$('.footer .next')[0];
        var items = $$('.item');
        var item = items[this.quiz.position];
        var isEnabled = this.isAnswered(item);
 
        if (isEnabled) {
            if (this.quiz.response == 'immediate') {
                var status;

                // Count as a attempt
                this.quiz.attempt++;

                switch (item.getAttribute('data-type')) {
                    case 'multiple-choice':
                        status = this.evalMultipleChoice(item, this.quiz.attempt);
                        
                        break;
                }

                if (status == 'ok') {
                    this.updateFeedback('Correct.');

                    next.removeProperty('disabled');
                    next.show();
                } else {
                    this.updateFeedback('Try ' + this.quiz.attempt + ' of ' + this.quiz.maxAttempts);
                    
                    if (this.quiz.attempt < this.quiz.maxAttempts) {
                        tryAgain.removeProperty('disabled');
                        tryAgain.show()
                        next.hide();

                    } else {
                        tryAgain.hide()
                        next.removeProperty('disabled');
                    }
                }
                
            } else {
                next.removeProperty('disabled');
            }
        }
    },
    resetOneMode: function () {
        var items = $$('.item');
        var buttons = $$('.footer button');
        var tryAgain = $$('.footer .try-again')[0];
        var reset = $$('.footer .reset')[0];
        var next = $$('.footer .next')[0];
        var checkAnswer = $$('.footer .check-answer')[0];
        var feedbacks = $$('.item .feedback');
        var scoring = $$('.scoring')[0];

        scoring.destroy();
        buttons.each(function (button, index) {
            button.setAttribute('disabled', 'disabled');
        });
        buttons.hide();

        items.each(function (item, index) {
            var radios = item.getChildren('.options .radio');
            var labels = item.getChildren('.options .label');
            var optionFeedback = item.getChildren('.options .option-feedback');

            item.removeClass('fail first-attempt');
            radios.removeClass('ok fail pass');
            labels.removeClass('ok fail evaluated');
            optionFeedback.removeClass('ok fail');

            radios.set('checked', false);
            radios.set('disabled', false);
        });

        items.hide();
        feedbacks.hide();

        if (items.length) items[0].show();

        this.updateFeedback('');
        
        this.quiz = {
            position: 0,
            mode: this.settings.presentation,
            response: this.settings.response,
            attempt: 0,
            maxAttempts: this.settings.maxAttempts,
            total: this.data.length
        };

        next.show();

        $$('.result-actual,.result-should,.short-feedback').map(function(trash){
            trash.remove()
        })
        $$('.item')[0].getElement('legend').focus()
    },
    setOneMode: function () {
        var items = $$('.item');
        var footer = $$('.footer')[0];
        var radios = $$('.options .radio');
        var tryAgain = $$('.footer .try-again')[0];
        var reset = $$('.footer .reset')[0];
        var next = $$('.footer .next')[0];

        items.hide();
        if (items.length) items[0].show();

        radios.addEvent('click', this.enableNextOneMode.bind(this));
        radios.addEvent('keypress', this.enableNextOneMode.bind(this));
        tryAgain.addEvent('click', this.tryAgainOneMode.bind(this));
        next.addEvent('click', this.nextOneMode.bind(this));
        reset.addEvent('click', this.resetOneMode.bind(this));
        
        footer.addClass('one');
        next.show();
    },

    /* START */
    startQuiz: function () {
        this.quiz = {
            position: 0,
            mode: this.settings.presentation,
            response: this.settings.response,
            attempt: 0,
            maxAttempts: this.settings.maxAttempts,
            total: this.data.length
        };

        switch (this.quiz.mode) {
            case 'one':
                this.setOneMode();

                break;

            case 'all':
                this.setAllMode();

                break;
        }
    },

});