InteractiveGraph = new Class({
    Implements: [Options, Events],
    options: {
        type: 'line'
    },
    initialize: function (options) {
        this.setOptions(options);
        this.render();
    },
    render: function () {
        if (this.options.width) {
            $$('svg').setStyle('width', this.options.width);
        }

        if (this.options.type == 'line') {
            this.renderLine(this);
        }
    },
    renderLine: function(that) {
        d3.json('javascript/data.json', function (data) {
            nv.addGraph(function () {
                var chart = nv.models.lineChart()
                        .x(function (d) {
                            return d[0]
                        })
                        .y(function (d) {
                            return d[1]
                        }) //adjusting, 100% is 1.00000, not 100 as it is in the data
                        .color(d3.scale.category10().range())
                        .useInteractiveGuideline(true)
                        ;
                if (that.options.rangeY) {
                    chart.forceY(that.options.rangeY);
                }

                chart.xAxis
                        .tickValues(that.options.tickValues);

                chart.yAxis
                        .tickFormat(d3.format('%'));

                d3.select('#chart svg')
                        .datum(data)
                        .call(chart);

                //TODO: Figure out a good way to do this automatically
                nv.utils.windowResize(chart.update);

                return chart;
            });
        });
    }
});