InteractiveGraphData = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        data: {},
        type: null
    },

    annotatedGraphs: ['line-data','bar-data','pie-data'],
    toggleGraphs: ['line-data-toggle','bar-data-toggle','pie-data-toggle'],
    currentGraph: 0,
    defaultSettings: [
        // lines
        {'showArea': false, 'showLine': true, 'showPoint': true, 'fullWidth': false, 'lineSmooth': true, axisX: { offset: 75 }, axisY: { offset: 60 }},
        // bars
        {'strokeWidth': 10, 'seriesBarDistance': 15, 'stackBars': false, 'reverseData': false, 'horizontalBars': false, axisX: { offset: 75 }, axisY: { offset: 60 }},
        // pies
        {'startAngle': 0, 'labelOffset': 0, 'chartPadding': 0, 'showLabel': true, 'donut': false, 'donutWidth': 60, 'labelWhite': true}
    ],

    initialize: function (options) {
        this.setOptions(options);
        $$('body')[0].grab(new Element('#graphUpdateAlert.visually-hidden',{
            text: '',
            'aria-live': 'polite',
            'role': 'alert'
        }))
        if(typeof this.options.data.graph == "undefined") {
            var settings = null;
            switch (this.options.type){
                case 'line-data': case 'line-data-toggle':
                    settings = this.defaultSettings[0];
                    break;
                case 'bar-data': case 'bar-data-toggle':
                    settings = this.defaultSettings[1];
                    break;
                case 'pie-data': case 'pie-data-toggle':
                    settings = this.defaultSettings[2];
                    break;
            }
            if(this.isAnnotatedGraph()) {
                if(this.options.type == 'pie-data' || this.options.type == 'pie-data-toggle'){
                    this.options.data = {graph: [{labels: ['',''], series: [[1,1]]}], captions: [['Data Set 1']], settings: [settings], theme: ['theme1']};
                }else{
                    this.options.data = {graph: [{labels: ['',''], series: [['','']]}], captions: [['Data Set 1']], settings: [settings], theme: ['theme1']};
                }
            } else if(this.isToggleGraph()) {
                if(this.options.type == 'pie-data' || this.options.type == 'pie-data-toggle'){
                    this.options.data = {graph: [{labels: ['',''], series: [[1,1]]}], captions: [['Data Set 1']], settings: [settings], tabs: ['NEW TAB'], theme: ['theme1']};
                }else{
                    this.options.data = {graph: [{labels: ['',''], series: [['','']]}], captions: [['Data Set 1']], settings: [settings], tabs: ['NEW TAB'], theme: ['theme1']};
                }
            }
        }

        options.visuallyHideLongStatic = true;
    
        var that = this;
        setTimeout(function(){
            that.renderDataTable();
        }, 500)

        this.parent(this.options);
    },
    renderDataTable: function(filters){

        var isReRendering = !!$$('.dataTableContainer').length || !!filters;

        var title = data.settings[0]['label-y'];

        var captions = isReRendering ? filters : data.captions[0];

        var dataTableContainer;
        if (!isReRendering) {
            dataTableContainer = new Element('.dataTableContainer.visually-hidden')
            $$('.ct-chart')[0].adopt(dataTableContainer);
        }
        if(isReRendering){
            dataTableContainer = $$('.dataTableContainer');
            if(!filters.length)
                return dataTableContainer.set('html', 'No data to show. All filters are unselected.');

            var captionsDiffIndex = data.captions[0]
                .filter( function(c){
                return filters.indexOf(c) < 0;
                })
                .map(function(diff){
                return data.captions[0].indexOf(diff);
                });
        }

        var series =  !isReRendering ? data.graph[0].series : data.graph[0].series.filter(function(s, index){
            return captionsDiffIndex.indexOf(index) < 0
        });

        var filterHeaders = '<th id="labels"></th>'+ captions.map(function(caption){
            return '<th id="'+ slugify(caption) +'">' + caption +'</th>'  //h1 betwwen captions

        }).join('');


        var tableBody = data.graph[0].labels.map(function(xAxis, labelIndex){
            var rows = captions.map(function(caption, captionIndex){
                return '<td headers="'+  slugify(xAxis) + ' ' + slugify(caption) +'">' + series[captionIndex][labelIndex] + '</td>'
            }).join('');

            return '<tr>' + '<td id="'+ slugify(xAxis) +'" headers="labels">' + xAxis+ '</td>' + rows + '</tr>'; //h2 betwwen td

        }).join('');


        var html =

            '<table>'+

                '<thead>'+

                    '<tr>' +
                        '<th colspan=' + (captions.length + 1) + '><h1>' + title + '</h1></th>'+
                    '</tr>'+

                    '<tr>' + filterHeaders + '</tr>'+

                '</thead>'+

                '<tbody>' + tableBody + '</tbody>'+

            '</table>';

        dataTableContainer.set('html', html);
        $$('.dataTableContainer table')[0].setAttribute('tabindex', 0);

        if(isReRendering){

          //prevent offset table bug  on slow connections
          // try{
          //   if(p.getParent().hasClass('visually-hidden')){
          //     p.getParent().addClass('visually-hidden-focusable')
          //       .removeClass('visually-hidden')
          //   }
          // }
          // catch(e){
          //     //
          // }

          // return $$('#longdesc table')[0].set('tabindex', -1).focus();
            var alert = $('graphUpdateAlert')
            if(!alert.get('text') || alert.get('text') == 'Graph data has been updated.' ){
                alert.set('text', 'Graph data has been updated')
            } else if(alert.get('text') ==  'Graph data has been updated'){
                alert.set('text', 'Graph data has been updated.')
            }
        }

        //accessibility_index.descriptions[0].longdescHTML = html;

    },

    afterInitialize: function(){

    },
    bindEditMode: function() {
        this.sendPostMessages('initial-data', {
            'graph': this.options.data.graph[this.currentGraph],
            'captions': this.options.data.captions[this.currentGraph],
            'settings': this.options.data.settings[this.currentGraph],
            'theme': this.options.data.theme[this.currentGraph]
        });
    },

    // Receive messages from server and take actions
    customPostMessages: function(message) {
        switch(message.data.method){
            case "data-change":
                this.options.data.graph[this.currentGraph] = message.data.graph;
                this.options.data.settings[this.currentGraph] = message.data.settings;
                this.options.data.captions[this.currentGraph] = message.data.captions;
                this.options.data.theme[this.currentGraph] = message.data.theme;
                this.save();
                this.render();
                break;
        }
    },

    save: function (callback) {
        this.saveRequest({method: 'mdData', options: {'json': this.options.data}}, callback);
    },

    isAnnotatedGraph: function() {
        if(this.annotatedGraphs.indexOf(this.options.type) >= 0) {
            return true;
        }
        return false;
    },

    isToggleGraph: function() {
        if(this.toggleGraphs.indexOf(this.options.type) >= 0) {
            return true;
        }
        return false;
    },

    render: function () {
        this.body.set('html','');

        if(this.isToggleGraph()) {
            this.renderTabs();
        }

        this.renderGraph();

        if(this.options.data.settings[this.currentGraph].showCaption) {
            this.renderLegend();
        }

        this.renderLabels();

        this.addEvents();
    },

    renderLegend: function() {
        var theme = this.options.data.theme[this.currentGraph];
        var letters = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o'];
        var legend = new Element('div.ct-chart-legend');
        legend.inject($$('div.ct-chart')[0]);
        var legend_list = new Element('ul');
        legend_list.inject(legend);

        var captions =  this.options.data.captions[this.currentGraph].slice();

        if(this.options.data.settings[this.currentGraph]['reverseData']){
            captions.reverse();
        }

        captions.each(function(el, i) {
            new Element('li', {
                html: '<span><i class="fa fa-check"></i></span> '+ '<p  aria-hidden="true" style="display:inline-block; margin:0">'+el + '</p>',
                'class': theme+' legend-'+letters[i]
            }).inject(legend_list);
        });
    },

    renderLabels: function() {

        if(this.options.data.settings[this.currentGraph]['show-label-x']){
            new Element('div', {
                    html: this.options.data.settings[this.currentGraph]['label-x'],
                    'class': 'x-label'
            }).inject($$('.ct-chart')[0]);
        }

        if(this.options.data.settings[this.currentGraph]['show-label-y']){
            var yLabelEl = new Element('div', {
                html: this.options.data.settings[this.currentGraph]['label-y'],
                class: 'y-label',
                // start hidden
                style: 'visibility: hidden;'
            }).inject($$('.ct-chart')[0]);
            
            setTimeout(function () {
                var yLabelBCR = yLabelEl.getBoundingClientRect();
                var chartElBCR = document.querySelector('.ct-grids').getBoundingClientRect();

                yLabelEl.setStyles({
                    // vertically align the y label in the middle
                    'top': (chartElBCR.height / 2) - (yLabelBCR.height / 2),
                    // display y label
                    'visibility': 'visible'
                });
            }, 0);
        }
    },

    renderGraph: function() {        
        _this = this;

        this.body.appendHTML('<div class="ct-chart"></div>');
        
        if(typeof this.options.data.settings[this.currentGraph].startAngle != 'undefined') {
            this.options.data.settings[this.currentGraph].startAngle = +this.options.data.settings[this.currentGraph].startAngle;
        }
        if(typeof this.options.data.settings[this.currentGraph].chartPadding != 'undefined') {
            this.options.data.settings[this.currentGraph].chartPadding = +this.options.data.settings[this.currentGraph].chartPadding;
        }
        if(typeof this.options.data.settings[this.currentGraph].labelOffset != 'undefined') {
            this.options.data.settings[this.currentGraph].labelOffset = +this.options.data.settings[this.currentGraph].labelOffset;
        }
        if(typeof this.options.data.settings[this.currentGraph].labelOffset != 'undefined') {
            this.options.data.settings[this.currentGraph].labelOffset = +this.options.data.settings[this.currentGraph].labelOffset;
        }
        if(typeof this.options.data.settings[this.currentGraph].low != 'undefined' && this.options.data.settings[this.currentGraph].low) {
            this.options.data.settings[this.currentGraph].low = +this.options.data.settings[this.currentGraph].low.toString().replace(',','');
        }
        if(typeof this.options.data.settings[this.currentGraph].high != 'undefined' && this.options.data.settings[this.currentGraph].high) {
            this.options.data.settings[this.currentGraph].high = +this.options.data.settings[this.currentGraph].high.toString().replace(',','');
        }

        if(typeof this.options.data.settings[this.currentGraph].axisX != 'undefined') {
            if(typeof this.options.data.settings[this.currentGraph].axisX.labelOffset != 'undefined') {
                if(typeof this.options.data.settings[this.currentGraph].axisX.labelOffset.x != 'undefined') {
                    this.options.data.settings[this.currentGraph].axisX.labelOffset.x = +this.options.data.settings[this.currentGraph].axisX.labelOffset.x;
                }
                if(typeof this.options.data.settings[this.currentGraph].axisX.labelOffset.y != 'undefined') {
                    this.options.data.settings[this.currentGraph].axisX.labelOffset.y = +this.options.data.settings[this.currentGraph].axisX.labelOffset.y;
                }
            }
        }
        
        if(typeof this.options.data.settings[this.currentGraph].axisY != 'undefined') {
            if(typeof this.options.data.settings[this.currentGraph].axisY.labelOffset != 'undefined') {
                if(typeof this.options.data.settings[this.currentGraph].axisY.labelOffset.x != 'undefined') {
                    this.options.data.settings[this.currentGraph].axisY.labelOffset.x = +this.options.data.settings[this.currentGraph].axisY.labelOffset.x;
                }
                if(typeof this.options.data.settings[this.currentGraph].axisY.labelOffset.y != 'undefined') {
                    this.options.data.settings[this.currentGraph].axisY.labelOffset.y = +this.options.data.settings[this.currentGraph].axisY.labelOffset.y;
                }
            }
        }


        if(this.options.type == 'line-data' || this.options.type == 'line-data-toggle') {
            this.options.data.settings[this.currentGraph].classNames = {};
            this.options.data.settings[this.currentGraph].classNames.line = 'line-'+this.options.data.theme[this.currentGraph];
            this.options.data.settings[this.currentGraph].classNames.point = 'point-'+this.options.data.theme[this.currentGraph];
            this.options.data.settings[this.currentGraph].classNames.area = 'area-'+this.options.data.theme[this.currentGraph];

            var chart = new Chartist.Line('.ct-chart', this.options.data.graph[this.currentGraph], this.options.data.settings[this.currentGraph]);
            if(window.d3Objects==null) window.d3Objects=[];
            window.d3Objects.push(chart);
        } else if(this.options.type == 'bar-data' || this.options.type == 'bar-data-toggle') {
            this.options.data.settings[this.currentGraph].classNames = {};
            this.options.data.settings[this.currentGraph].classNames.bar = 'bar-'+this.options.data.theme[this.currentGraph];

            var chart = new Chartist.Bar('.ct-chart', this.options.data.graph[this.currentGraph], this.options.data.settings[this.currentGraph]);

            chart.on('created',function(){
                $$('.ct-chart-legend li span')
                  .set('role','checkbox')
                  .set('aria-checked','true')
                  .set('tabindex', 0);
                $$('svg').set('role','presentation');
                $$('svg').set('aria-hidden', 'true');


                $$('.ct-chart-legend>ul>li').map(function(li){
                  var span = li.getElement('span');
                  span.set('aria-label', li.get('text'));
                });
            })

            if(window.d3Objects==null) window.d3Objects=[];
            window.d3Objects.push(chart);

            if(typeof this.options.data.settings[this.currentGraph].strokeWidth != 'undefined') {
                chart.on('draw', function(data) {
                    if(data.type === 'bar') {
                        data.element.attr({
                            style: 'stroke-width: '+_this.options.data.settings[_this.currentGraph].strokeWidth+'px'
                        });
                    }
                });
            }

        } else if(this.options.type == 'pie-data' || this.options.type == 'pie-data-toggle') {
            var graph = [];
            graph.labels = this.options.data.graph[this.currentGraph].labels;
            graph.series = [];
            this.options.data.settings[this.currentGraph].classNames = {};
            this.options.data.settings[this.currentGraph].classNames.pie = 'pie-'+this.options.data.theme[this.currentGraph];
            this.options.data.settings[this.currentGraph].classNames.slicePie = 'slice-'+this.options.data.theme[this.currentGraph];
            this.options.data.settings[this.currentGraph].classNames.slice = 'slice-'+this.options.data.theme[this.currentGraph];
            this.options.data.settings[this.currentGraph].classNames.donut = 'donut-'+this.options.data.theme[this.currentGraph];
            this.options.data.settings[this.currentGraph].classNames.label = this.options.data.settings[this.currentGraph].labelWhite ? 'label-white' : 'label-black'; 
            for(var i= 0; i < this.options.data.graph[this.currentGraph].series[0].length; i++) {
                graph.series[i] = +this.options.data.graph[this.currentGraph].series[0][i];
            }

            //console.log(graph);
            //console.log(this.options.data.settings[this.currentGraph]);

            //this.options.data.settings[this.currentGraph].labelOffset = -18;
            //this.options.data.settings[this.currentGraph].labelPosition = 'inside';
            //this.options.data.settings[this.currentGraph].labelDirection = 'neutral';

            //this.options.data.settings[this.currentGraph].labelOffset = 120;
            //this.options.data.settings[this.currentGraph].chartPadding = 70;
            var chart = new Chartist.Pie('.ct-chart', graph, this.options.data.settings[this.currentGraph]);

            if(this.options.data.settings[this.currentGraph].autoCenterLabel == true){
                var latestTID = null;
                var pathIndx = 0;                
                chart.on('draw', function(data) {                    
                    if(data.type === 'slice'){
                        data.element._node.set('data-angle', data.endAngle - data.startAngle);
                        data.element._node.set('data-radius', data.radius);
                        data.element._node.set('data-start-angle', data.startAngle);
                        data.element._node.set('data-end-angle', data.endAngle);
                    }
                    if(data.type === 'label') {
                        //var textHtml = ['<div class="label-wrapper" style="height: '+data.group.height()+'px; min-width: '+(data.group.width() - 40)+'px">','<div>', data.text, '</div>','</div>'].join('');
                        //console.log(data);
                        //console.log('----');
                        //console.log(textHtml);
                        //console.log( data );
                        //return;
                        data.group._node.set('data-path-id',pathIndx);
                        var textHtml = ['<div class="label-wrapper" style="min-width: 200px">','<div>', data.text, '</div>','</div>'].join('');
                        var currentNodePosition = data.group._node.getBBox();                        
                        
                        var multilineText = Chartist.Svg('svg').foreignObject(textHtml, {
                            //x: data.x - 75*0,
                            //y: data.y - 20*0,
                            x: currentNodePosition.x ,
                            y: currentNodePosition.y ,
                            // width: data.group.width(),
                            // height: data.group.height(),
                            'data-path-id': pathIndx
                        }, 'ct-label ' + _this.options.data.settings[_this.currentGraph].classNames.label);

                        /*
                        console.log( chart.svg.width() );
                        console.log(data.group );
                        console.log(data.group.width() );
                        console.log(data.group.height() );
                        console.log(data.group._node.getBoundingClientRect() );
                        console.log(data.group._node.getBBox() );
                        */
                        //console.log(data.group.getBBox());
                        //data.element.replace(multilineText);
                        //Chartist.Svg('svg').append(  );
                        data.element.remove();
                        var g = Chartist.Svg('svg').elem('g');
                        g.append(multilineText);
                        chart.svg.append(g);
                        //chart.svg.append(multilineText);
                        
                        //console.log( chart );
                        
                        //console.log(g._node.getBoundingClientRect() );
                        //console.log(g._node.getBBox() );
                        console.log('---||---');

                        /*if(latestTID!=null) clearTimeout(latestTID);
                        debugger;
                        latestTID = setTimeout( function() {
                            debugger;
                            $$('foreignObject').forEach(function(foreignObject){
                                foreignObject.getParent().set('width', foreignObject.getParent().getParent().getWidth());
                            });
                        }.bind(this), 500);*/
                        pathIndx++;
                    }
                });

                chart.on('created', function(data) {
                    //console.log ( chart.querySelector('path') );
                    //console.log ( chart.svg.querySelectorAll('path').svgElements[0] );
                    $$('path').forEach(function(path){
                        var pathData = path.getBBox();
                        //console.log(Math.sin(path.get('data-angle')) * path.get('data-radius'));
                        var foreign = $$('foreignObject[data-path-id="'+path.getParent().get('data-path-id')+'"]');
                        foreign.set('x', pathData.x);
                        foreign.set('y', pathData.y >= 0? pathData.y : 0);
                        if(path.get('data-start-angle') > 250 && path.get('data-end-angle') <= 360){
                            foreign.getElement('.label-wrapper').addClass('chart-iv-quarter');
                        }
                        foreign.set('width', pathData.width);
                        foreign.set('height', pathData.height);
                        foreign.getElement('.label-wrapper').setStyles({
                            'min-width': pathData.width,
                            height: pathData.height
                        });

                        //console.log(pathData.height);
                    });
                });
            }
            if(window.d3Objects==null) window.d3Objects=[];
            window.d3Objects.push(chart);
        }
    },

    renderTabs: function(){
        var _this = this;
        if($$('.tabs')[0]){
            $$('.tabs')[0].empty();
        }else{
            this.body.appendHTML('<div class="tabs"></div>');
        }
        this.options.data.tabs.each(function(el, i){
            if(i == 0){
                if(_this.isEditMode){
                    if(_this.options.data.tabs.length > 1){
                        $$('.tabs').appendHTML('<div class="item-tab"><span class="tab-text" contenteditable="true" data-id="'+i+'">'+el+'</span><div title="Delete Entry" class="fa fa-times delete"></div></div>');
                    }else{
                        $$('.tabs').appendHTML('<div class="item-tab"><span class="tab-text" contenteditable="true" data-id="'+i+'">'+el+'</span></div>');
                    }
                }else{                    
                    if (_this.options.data.tabs.length > 1 && el !== "") {
                        $$('.tabs').appendHTML('<div class="item-tab"><span class="tab-text" data-id="'+i+'">'+el+'</span></div>');
                    }
                }
            }else{
                if(_this.isEditMode){
                    $$('.tabs').appendHTML('<div class="item-tab"><span class="tab-text" contenteditable="true" data-id="'+i+'">'+el+'</span><div title="Delete Entry" class="fa fa-times delete"></div></div>');
                }else{
                    $$('.tabs').appendHTML('<div class="item-tab"><span class="tab-text" data-id="'+i+'">'+el+'</span></div>');
                }
            }
        });
        $$('.item-tab').each(function(el, i){
            if(i == _this.currentGraph){
                el.addClass('active');
            }
        });
        if(this.isEditMode){
            $$('.tabs').appendHTML('<button class="add-another-entry-button"><span class="fa fa-plus"></span>&nbsp;NEW TAB</button>');
        }
    },

    addEvents: function(){
        var _this = this;
        $$('.add-another-entry-button').addEvent('click', function(e){
            var settings = null;
            switch (_this.options.type){
                case 'line-data': case 'line-data-toggle':
                settings = _this.defaultSettings[0];
                break;
                case 'bar-data': case 'bar-data-toggle':
                settings = _this.defaultSettings[1];
                break;
                case 'pie-data': case 'pie-data-toggle':
                settings = _this.defaultSettings[2];
                break;
            }
            if(_this.options.type == 'pie-data' || _this.options.type == 'pie-data-toggle'){
                _this.options.data.tabs.push('NEW TAB');
                _this.options.data.graph.push({labels: ['',''], series: [[1,1]]});
                _this.options.data.settings.push(settings);
                _this.options.data.captions.push(["Data Set 1"]);
                _this.options.data.theme.push('theme1');
            }else{
                _this.options.data.tabs.push('NEW TAB');
                _this.options.data.graph.push({labels: ['',''], series: [['','']]});
                _this.options.data.settings.push(settings);
                _this.options.data.captions.push(["Data Set 1"]);
                _this.options.data.theme.push('theme1');
            }
            _this.save(function(){
                window.location.reload();
            });
        });

        $$('div.fa.fa-times.delete').addEvent('click', function(e){
            e.stopPropagation();
            _this.options.data.tabs.splice(e.target.getParent().getElement('span.tab-text').get('data-id'), 1);
            _this.options.data.graph.splice(e.target.getParent().getElement('span.tab-text').get('data-id'), 1);
            _this.options.data.settings.splice(e.target.getParent().getElement('span.tab-text').get('data-id'), 1);
            _this.options.data.captions.splice(e.target.getParent().getElement('span.tab-text').get('data-id'), 1);
            _this.options.data.theme.splice(e.target.getParent().getElement('span.tab-text').get('data-id'), 1);
            _this.save(function(){
                window.location.reload();
            });
        });

        $$('span.tab-text[contenteditable="true"]').addEvent('blur', function(e){
            _this.options.data.tabs[e.target.get('data-id')] = e.target.get('text');
            _this.save();
        });

        $$('.item-tab').addEvent('click', function(e){
            if(!e.event.currentTarget.hasClass('active')){
                $$('.item-tab').each(function(el){
                    if(el.hasClass('active')){
                        el.removeClass('active');
                    }
                });
                _this.currentGraph = e.event.currentTarget.getElement('.tab-text').get('data-id');
                e.event.currentTarget.addClass('active');
                _this.sendPostMessages('initial-data', {'graph': _this.options.data.graph[_this.currentGraph], 'captions': _this.options.data.captions[_this.currentGraph], 'settings': _this.options.data.settings[_this.currentGraph], 'theme': _this.options.data.theme[_this.currentGraph]});
                _this.render();
            }
        });

        $$('.ct-chart-legend li').addEvent('keypress', _this.toggleFilters.bind(_this));
        $$('.ct-chart-legend li').addEvent('click',  _this.toggleFilters.bind(_this));
    },
    toggleFilters: function(e){

        var wasTabPresssed = e.code == 9 || e.which == 9 || e.keyCode == 9;
        var wasEscapePressed = e.code == 27 || e.which == 27 || e.keyCode == 27;

        if(e.type == "keypress" && (wasTabPresssed || wasEscapePressed)) return;

        var letter = e.event.currentTarget.get('class')[e.event.currentTarget.get('class').length-1];

        if(e.event.currentTarget.getElement('span').getElement('i')){

          e.event.currentTarget.getElement('span').empty();

          $$(e.event.currentTarget.getElement('span')).set('aria-checked','false');

          $$('.ct-series.ct-series-'+letter).each(function(el){

            el.hide();

          });

        } else{

          e.event.currentTarget.getElement('span').grab(new Element('i.fa.fa-check'));

          $$(e.event.currentTarget.getElement('span')).set('aria-checked','true');

          $$('.ct-series.ct-series-'+letter).each(function(el){

            el.show();

          });
        }

        var filters = $$('.fa.fa-check').getParent().getParent().get('text').map(function(filter){

          return filter.trim();

        });

        this.renderDataTable(filters);

    }
});

function slugify(text) {
    return text.toString().toLowerCase()
      .replace(/\s+/g, '-')           // Replace spaces with -
      .replace(/[^\w\-]+/g, '')       // Remove all non-word chars
      .replace(/\-\-+/g, '-')         // Replace multiple - with single -
      .replace(/^-+/, '')             // Trim - from start of text
      .replace(/-+$/, '');            // Trim - from end of text
}