InteractiveGraphImages = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
    },
    mode: null,
    data: [],
    initialize: function (options) {
        this.mode = $('MetrodigiWidget').getProperty('data-xml-type');
        this.data = options.data;
        this.parent(options);
        switch (this.mode) {
            case 'annotated':
                this.annotated();
                break;
            case 'toggle':
                this.toggle();
                break;
            case 'timeline':
                this.timeline();
                break;
            case 'reveal':
                this.reveal();
                break;
        }
    },
    reveal: function () {
        var _this = this;
        if (this.data.length === 2) {
            var back = this.data[0].image;
            var over = this.data[1].image;
            $$('.widget-content .images').appendHTML('<div class="back"><img src="images/' + back + '" /></div>');
            $$('.widget-content .images').appendHTML('<div class="over"><img src="images/' + over + '" /></div>');
        } else {
            $$('.widget-content .images').appendHTML('<h3>Amount of images incorrect.</h3>');
        }
        var image = $$('.images .back img')[0];
        image.addEvent('load', function () {
            var size = image.getSize();
            var slider = $('slider');
            slider.show();
            slider.setStyle('width', size.x + 30);
            var bottom = size.y + 40;
            $$('.slider .knob .bar').setStyle('height', bottom);
            $$('.slider .knob .bar').setStyle('bottom', -bottom);
            slider = new Slider(slider, slider.getElement('.knob'), {
                range: [0, size.x],
                initialStep: 0,
                onChange: function (value) {
                    _this.revealChart(value);
                }
            });
            _this.revealEvents(slider, size);
        });
        // create slider knob actions
        $$('.slider .knob').addEvent('mousedown', function () {
            this.addClass('mousedown');
        });
        $$('body, .slider .knob').addEvent('mouseup', function () {
            $$('body, .slider .knob').removeClass('mousedown');
        });
    },
    revealChart: function (value) {
        $$('.widget-content .images .over').setStyle('width', value);
    },
    revealEvents: function (slider, size) {
        var counter = 1;
        $$('.play').addEvent('click', function () {
            $(this).hide();
            $$('.reset').show();
            var animTime = setInterval(function () {
                slider.set(counter += 20);
                if (counter >= size.x) {
                    counter = 1;
                    $$('.play').show();
                    $$('.reset').hide();
                    clearInterval(animTime);
                }
            }, 150);
            $$('.reset').addEvent('click', function(){
                $(this).hide();
                $$('.play').show();
                clearInterval(animTime);
            });
        });

    },
    annotated: function () {
        if (typeof this.data[0] !== 'undefined') {
            var src = this.data[0].image;
            var label = this.data[0].label;
            $$('.widget-content .images').appendHTML('<img src="images/' + src + '" />');
        }
    },
    toggle: function () {
        if (typeof this.data !== 'undefined' && this.data.length > 0) {
            var labels = '';
            var images = '';
            Array.each(this.data, function (item, index) {
                var src = item.image;
                var label = item.label;
                var _class = '';
                if (index === 0) {
                    _class = 'selected';
                }
                labels += '<a href="#" class="label ' + _class + '" data-index="' + index + '">' + label + '</a>';
                images += '<div class="image image_' + index + '"><img src="images/' + src + '" /></div>';
            });
            $$('.widget-header .labels').appendHTML(labels);
            $$('.widget-content .images').appendHTML(images);
            this.toggleEvents();
        }
    },
    toggleEvents: function () {
        $$('.widget-header .label').addEvent('click', function () {
            var index = this.getProperty('data-index');
            $$('.widget-header .label').removeClass('selected');
            this.addClass('selected');
            $$('.widget-content .images .image').hide();
            $$('.widget-content .images .image_' + index).show();
        });
    },
    timeline: function () {
        if (typeof this.data !== 'undefined' && this.data.length > 0) {
            var labels = [];
            var values = '';
            var percentage = 100 / (this.data.length - 1);
            var images = '';
            Array.each(this.data, function (item, index) {
                var _class = '';
                var src = item.image;
                if (index === 0) {
                    _class = 'first';
                }
                if (index === this.data.length - 1) {
                    _class = 'last';
                }
                labels[index] = parseInt(item.label);
                values += '<div class="value ' + _class + '" style="width: ' + percentage + '%;">' + item.label + '</div>';
                images += '<div class="image image_' + index + '"><img src="images/' + src + '" /></div>';
            });
            $$('.widget-header .values').appendHTML(values);
            $$('.widget-content .images').appendHTML(images);
            var max = this.data.length - 1;
            var min = 0;
            $$('.widget-header').appendHTML('<div class="range_wrap"><input id="range" type="range" min="' + min + '" max="' + max + '" value="' + min + '"/></div>');
            this.timelineEvents();
        }
    },
    timelineEvents: function () {
        $('range').addEvent('input', function () {
            var index = this.get('value');
            $$('.widget-content .images .image').hide();
            $$('.widget-content .images .image_' + index).show();
        });
    }
});


