InteractiveGraph = new Class({
	Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
        data: {}
    },

    current_step: 3,
    graph_type: null,
    widget: null,

    initialize: function (options) {
        var MetrodigiWidget = $$('#MetrodigiWidget')[0];
    	if(MetrodigiWidget.get('data-xml-type')) {
            options.visuallyHideLongStatic = true;
    		this.graph_type = MetrodigiWidget.get('data-xml-type');

    		switch(this.graph_type) {
    			case "toggle-images":
    			case "timeline-images":
    			case "reveal-images":
    				this.widget = new InteractiveGraphImages(options);
    				break;
                
    			case "timeline-data":
    			case "reveal-data":
    				break;

    			case "line-data":
    			case "bar-data":
    			case "pie-data":
                case "line-data-toggle":
                case "bar-data-toggle":
                case "pie-data-toggle":
                    options.type = this.graph_type;

                    // enable medium editor on #introductory-line
                    this.initMediumEditor.call(this);

    				this.widget = new InteractiveGraphData(options);
    				break;
    		}
    	}

    	this.parent(options);
    },

    listenPostMessages: function() {
        return;
    },

    customPostMessages: function(message) {
        if(this.widget) {
            this.widget.customPostMessages(message);
        }
    },

    bindEditMode: function() {
    	if(! this.graph_type) {
    		this.showStep();
            this.header.hide();
        } else {
            this.sendPostMessages('initial-type', {type: this.graph_type});
        }
    },

    showStep: function() {
    	var _this = this;
    	var images_root = '../_framework/interactive-graph-v2/images/';

    	switch(this.current_step) {
    		case 1:
    			// Step 1 - Initial step
		    	var html = '<div id="step-1" class="md-edit-step">';
		    	html += '<p class="title">How do you want to create this interactive graph?</p>';
		    	html += '<div><button type="button" data-step="2"><i class="fa fa-file-image-o"></i> Create from images</button></div>';
		    	html += '<div><button type="button" data-step="3"><i class="fa fa-table"></i> Create from data</button>';
		    	html += '<p class="note">Bar, line or pie graph</p>';
		    	html += '</div>';
    			break;
    		case 2:
    			// Step 2 - Images menu
		    	var html = '<div id="step-2" class="md-edit-step">';
		    	html += '<div class="panel"><a class="navigation" data-step="1"><i class="fa fa-angle-left"></i> You are creating a graph from images</a></div>';
		    	html += '<div class="type-select"><p class="title">Toggle Graph</p><p class="subtitle">Switch between data sets</p><div class="interactive toggle-graph"></div><button data-type="toggle-images">Choose</button></div>';
		    	html += '<div class="type-select"><p class="title">Timeline Graph</p><p class="subtitle">Slide through history</p><div class="interactive timeline-graph"></div><button data-type="timeline-images">Choose</button></div>';
		    	html += '<div class="type-select"><p class="title">Reveal Graph</p><p class="subtitle">Reveal data gradually</p><div class="interactive reveal-graph"></div><button data-type="reveal-images">Choose</button></div>';
		    	html += '</div>';
    			break;
    		case 3:
    			// Step 3 - Data menu
		    	var html = '<div id="step-3" class="md-edit-step">';
		    	//html += '<div class="left-panel"><a class="navigation" data-step="1"><i class="fa fa-angle-left"></i> You are creating a graph from data</a></div>';
		    	html += '<div class="right-panel">'
		    	html += '<div class="type-select"><p class="title">Annotated Graph</p><p class="subtitle">Just the facts</p><div class="interactive annotated-graph"></div><button data-step="4">Choose</button></div>';
		    	html += '<div class="type-select"><p class="title">Toggle Graph</p><p class="subtitle">Switch between data sets</p><div class="interactive toggle-graph"></div><button data-step="5">Choose</button></div>';
		    	//html += '<div class="type-select"><p class="title">Timeline Graph</p><p class="subtitle">Slide through history</p><div class="interactive timeline-graph"></div><button data-type="timeline-data">Choose</button></div>';
		    	//html += '<div class="type-select"><p class="title">Reveal Graph</p><p class="subtitle">Reveal data gradually</p><div class="interactive reveal-graph"></div><button data-type="reveal-data">Choose</button></div>';

		    	html += '</div>';
		    	html += '</div>';
    			break;
    		case 4:
    			// Step 4 - Annotated menu
		    	var html = '<div id="step-4" class="md-edit-step">';
		    	html += '<div class="left-panel"><a class="navigation" data-step="3"><i class="fa fa-angle-left"></i> You are creating an annotated graph</a></div>';
		    	html += '<div class="right-panel">'
		    	html += '<div class="type-select"><p class="title">Line Graph</p><img src="'+images_root+'annotated-line.jpg" /><button data-type="line-data">Choose</button></div>';
		    	html += '<div class="type-select"><p class="title">Bar Graph</p><img src="'+images_root+'annotated-bar.jpg" /><button data-type="bar-data">Choose</button></div>';
		    	html += '<div class="type-select"><p class="title">Pie Graph</p><img src="'+images_root+'annotated-pie.jpg" /><button data-type="pie-data">Choose</button></div>';
		    	html += '</div>';
		    	html += '</div>';
    			break;
            case 5:
                // Step 4 - Annotated menu
                var html = '<div id="step-5" class="md-edit-step">';
                html += '<div class="left-panel"><a class="navigation" data-step="3"><i class="fa fa-angle-left"></i> You are creating a toggle graph</a></div>';
                html += '<div class="right-panel">'
                html += '<div class="type-select"><p class="title">Line Graph</p><img src="'+images_root+'annotated-line.jpg" /><button data-type="line-data-toggle">Choose</button></div>';
                html += '<div class="type-select"><p class="title">Bar Graph</p><img src="'+images_root+'annotated-bar.jpg" /><button data-type="bar-data-toggle">Choose</button></div>';
                html += '<div class="type-select"><p class="title">Pie Graph</p><img src="'+images_root+'annotated-pie.jpg" /><button data-type="pie-data-toggle">Choose</button></div>';
                html += '</div>';
                html += '</div>';
                break;
    	}
    	this.body.set('html', html);

        Array.prototype.slice.call(document.querySelectorAll('.type-select')).forEach(function(el) {
            switch(el.querySelector('p.title').textContent) {
                case 'Annotated Graph':
                    _this.init_annotated_graph(document.querySelector('.interactive.annotated-graph'), images_root, [{graph_value: 33, color: '#ADAFB3'}, {graph_value: 33, color: '#8F9297'}, {graph_value: 9, color: '#4D4F51'}, {graph_value: 9, color: '#C5C9D1'}, {graph_value: 9, color: '#3C3C3C'}, {graph_value: 7, color: '#6D6F72'}]);
                    break;
                case 'Toggle Graph':
                    _this.init_toggle_graph(document.querySelector('.interactive.toggle-graph'), images_root, ['Set 1', 'Set 2']);
                    break;
                case 'Timeline Graph':
                    _this.init_timeline_graph(document.querySelector('.interactive.timeline-graph'), images_root, [{year: 2000, graph_data: [80, 60, 70, 30, 80]}, {year: 2004, graph_data: [90, 70, 80, 40, 90]}, {year: 2008, graph_data: [100, 80, 90, 50, 100]}]);
                    break;
                case 'Reveal Graph':
                    _this.init_reveal_graph(document.querySelector('.interactive.reveal-graph'), images_root);
                    break;
            }
        });
    	
    	$$('.md-edit-step button, .md-edit-step a.navigation').addEvent('click', function() {
    		if(this.get('data-step')) {
    			_this.current_step = +this.get('data-step');
    			_this.showStep();
    		} else if(this.get('data-type')) {
    			_this.sendPostMessages('set-type', { type: this.get('data-type') });
    		}
    	});
    },

    init_create_element: function(node_name, class_name, append_area, attributes) {
        var new_element = document.createElement(node_name);

        // check if the class_name is an array or just a singular class
        if (Array.isArray(class_name)) {
            class_name.forEach(function(c_name) {
                new_element.classList.add(c_name);
            });
        } else if (class_name !== '') {
            new_element.classList.add(class_name);
        }

        append_area.appendChild(new_element);

        // set the attributes for each element
        if (Array.isArray(attributes)) {
            attributes.forEach(function(attrbute, i) {
                var key = Object.keys(attrbute);
                new_element.setAttribute(key, attrbute[key]);
            });
        }

        return new_element;
    },

    init_toggle_graph: function(wrapper, images_root, buttons) {
        _this = this;

        var buttons_wrapper = _this.init_create_element('div', 'button-wrapper', wrapper);
        var base_image_wrapper = _this.init_create_element('div', 'image-wrapper', wrapper, [{'style': 'background: url("' + images_root + 'toggle_base.png") top left no-repeat'}]);

        Array.prototype.slice.call(buttons).forEach(function(button, i) {
            var toggle_button = _this.init_create_element('button', '', buttons_wrapper, [{'data-id': i}]);
                toggle_button.textContent = button;

            var graph_image = _this.init_create_element('img', '', base_image_wrapper, [{'src': images_root + 'toggle_graph_' + i + '.png'}, {'data-id': i}]);

            // Add Event to the toggle buttons
            toggle_button.addEventListener('click', function(e) {
                if (!e.target.classList.contains('active')) {
                    Array.prototype.slice.call(wrapper.querySelectorAll('button')).forEach(function(button, i) {
                        if (button.classList.contains('active')) {
                            button.classList.remove('active');
                            wrapper.querySelector('img[data-id="' + button.getAttribute('data-id') + '"]').style.display = 'none';
                        }
                    });
                    e.target.classList.add('active');
                    wrapper.querySelector('img[data-id="' + i + '"]').style.display = 'block';
                }
            });

            // Add an active class to the first button and initiate the first image only
            i === 0 ? toggle_button.classList.add('active') : graph_image.style.display = 'none';

        });
    },
    init_timeline_graph: function(wrapper, images_root, buttons) {
        _this = this;

        // create the slider element
        var slider_wrapper = _this.init_create_element('div', 'slider_wrapper', wrapper),
            knob = _this.init_create_element('div', 'knob', slider_wrapper),
            slider_labels = _this.init_create_element('div', 'labels', wrapper),
            base_image_wrapper = _this.init_create_element('div', 'image-wrapper', wrapper, [{'style': 'background: url("' + images_root + 'toggle_base.png") top left no-repeat'}]),
            graph = _this.init_create_element('div', 'base_graph', base_image_wrapper);


        buttons.forEach(function(button, i) {
            var label = _this.init_create_element('div', 'label', slider_labels, [{'style': 'width: ' + slider_wrapper.getBoundingClientRect().width / buttons.length + 'px; display: inline-block'}]);
                label.textContent = button.year;

            // Initiate the interactivity
            if (i === 0) {
                button.graph_data.forEach(function(data) {
                    var graph_bar = _this.init_create_element('div', '', graph),
                        graph_bar_inner = _this.init_create_element('span', '', graph_bar, [{'style': 'width: ' + data + '%'}]);
                });
            }
        });

        // create the slider
        new Slider(slider_wrapper, knob, {
            snap: true,
            wheel: true,
            steps: buttons.length-1,
            onChange: function(pos){
                Array.prototype.slice.call(wrapper.querySelectorAll('.base_graph > div > span')).forEach(function(el, i) {
                    el.style.width = buttons[pos].graph_data[i] + '%';
                });
            }
        });
    },

    init_reveal_graph: function(wrapper, images_root) {

        // create the slider node
        var reveal_slider_wrapper = _this.init_create_element('div', 'slider_wrapper', wrapper),
            reveal_knob = _this.init_create_element('div', ['knob', 'line'], reveal_slider_wrapper),
            reveal_slider_label = _this.init_create_element('div', 'labels', wrapper),
            base_image_wrapper = _this.init_create_element('div', 'image-wrapper', wrapper);
            base_image_wrapper.setAttribute('style', 'background: url("' + images_root + 'toggle_base.png") top left no-repeat');

        var image_wrapper_coordinates = _this.container.getElement('.image-wrapper').getBoundingClientRect(),
            slider_slider_position = image_wrapper_coordinates.width / 3,
            comparative_map_image = _this.init_create_element('img', '', base_image_wrapper, [{'src': images_root + 'reveal_graph.png'}, {'style': 'clip: rect(0, ' + slider_slider_position + 'px, ' + image_wrapper_coordinates.height + 'px, 0)'}]);

        new Slider(reveal_slider_wrapper, reveal_knob, {
            wheel: true,
            steps: image_wrapper_coordinates.width,
            initialStep: slider_slider_position,
            onChange: function(pos){
                comparative_map_image.setStyle('clip', 'rect(0, ' + pos + 'px, ' + image_wrapper_coordinates.height + 'px, 0)')
            }
        });
    },

    init_annotated_graph: function(wrapper, images_root, graph_values) {
        var _this = this;
        var start_value = 0,
            new_value = 0,
            pie_main_wrapper = _this.init_create_element('div', 'pie-main-wrapper', wrapper);

        graph_values.forEach(function(data, i) {
            var end_value = +(parseFloat(((data.graph_value/100)*360)).toFixed(2));

            // Calculate the start value of the pie chart
            start_value = new_value;
            new_value =  start_value + end_value;
            new_value = +new_value.toFixed(2);

            // Create each of the pie chart
            var pie_section_wrapper = document.createElement('div');
                if (i !== 0) {
                    pie_section_wrapper.setAttribute('style', '-webkit-transform: rotate(' + start_value + 'deg); transform: rotate(' + start_value + 'deg);');
                }
                pie_section_wrapper.classList.add('pie-section-wrapper');
                pie_main_wrapper.appendChild(pie_section_wrapper);

                pie_main_wrapper.addEventListener('mouseover', function() {
                    pie_tooltip.style.display = 'block';
                });
                pie_main_wrapper.addEventListener('mouseout', function() {
                    pie_tooltip.style.display = 'none';
                });

            var pie_section_inner = _this.init_create_element('div', '', pie_section_wrapper, [{'style': '-webkit-transform: rotate(' + end_value + 'deg); transform: rotate(' + end_value + 'deg); background-color: ' + data.color + ';'}]);

            var pie_tooltip = _this.init_create_element('div', 'pie-tooltip', pie_main_wrapper);
                pie_tooltip.innerHTML = '<p>Only 18% of freshmen have chosen a career path.</p>';
                pie_tooltip.style.display = 'none';
        });
    }
});




