ClickToReveal = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
        elements: []
    },

    canvas : null,
    idCounter : 1,

    initialize: function(options) {
        this.setOptions(options);
        this.assets.push("../_framework/_base_external/fabric.min.js");
        this.parent(this.options);
    },

    bindEditMode: function() {
        var that = this;
        this.canvas = new fabric.Canvas('canvas', { width: 672, height: 511 });

        // events
        this.canvas.on('mouse:down', function(options) {
            if (options.target) {
                that.sendPostMessages('object-selected', {id: options.target.id, type: options.target.type});
            }else{
                that.sendPostMessages('unselected', {});
            }
        });
    },

    drawFigure: function(type){
        switch(type){
            case "text":
                // create a text object
                var text = new fabric.IText("Double click to change the text", {
                    left: 225,
                    top: 225,
                    fontSize: 14,
                    fontFamily: 'HelveticaNeueETW01-75Bd',
                    id: this.idCounter
                });

                // "add" text onto canvas
                this.canvas.add(text);
                this.idCounter++;
                break;
            case "rectangle":
                // create a rectangle object
                var rect = new fabric.Rect({
                    left: 275,
                    top: 225,
                    fill: 'brown',
                    width: 125,
                    height: 75,
                    stroke: "black",
                    id: this.idCounter
                });

                // "add" rectangle onto canvas
                this.canvas.add(rect);
                this.idCounter++;
                break;
            case "round-rect":
                // create a round rectangle object
                var rectRound = new fabric.Rect({
                    left: 275,
                    top: 225,
                    fill: 'brown',
                    width: 125,
                    height: 75,
                    ry: 10,
                    rx: 10,
                    stroke: "black",
                    id: this.idCounter
                });

                // "add" round rectangle onto canvas
                this.canvas.add(rectRound);
                this.idCounter++;
                break;
            case "ellipse":
                // create an ellipse object
                var ellipse = new fabric.Ellipse({
                    fill: "brown",
                    rx: 50,
                    ry:35,
                    left: 288,
                    top:228,
                    stroke: "black",
                    id: this.idCounter
                });

                // "add" ellipse onto canvas
                this.canvas.add(ellipse);
                this.idCounter++;
                break;
            case "triangle":
                // create a triangle object
                var triangle = new fabric.Triangle({
                    width: 100,
                    height: 73,
                    fill: 'brown',
                    left: 288,
                    top: 226,
                    stroke: "black",
                    id: this.idCounter
                });

                // "add" triangle onto canvas
                this.canvas.add(triangle);
                this.idCounter++;
                break;
            case "star":
                this.createStar();
                this.idCounter++;
                break;
            case "callout":
                this.createCallout();
                this.idCounter++;
                break;
            case "line":
                this.createLine();
                this.idCounter++;
                break;
            case "arrow":
                this.createArrow();
                this.idCounter++;
                break;
            case "image":

                break;
            default:
        }
    },

    createCallout: function(){
        // create an ellipse object
        var ellipse = new fabric.Ellipse({
            fill: "brown",
            rx: 50,
            ry:35,
            left: 300,
            top:225,
            stroke: "black"
        });

        // create a triangle object
        var triangle = new fabric.Triangle({
            width: 50,
            height: 90,
            fill: 'brown',
            left: 312,
            top: 322,
            angle: 233,
            stroke: "black"
        });

        // create a little triangle object to hide the ellipse stroke
        var littleTriangle = new fabric.Triangle({
            width: 28,
            height: 35,
            fill: 'brown',
            left: 314,
            top: 306,
            angle: 233
        });

        // create a group object
        var group = new fabric.Group([ triangle, ellipse, littleTriangle ], {
            left: 270,
            top: 228,
            id: this.idCounter
        });

        // "add" the group onto canvas
        this.canvas.add(group);
    },

    createStar: function(){
        // create the star coordinates
        var points = [
            {x: 75, y: 0},
            {x: 94, y: 52},
            {x: 150, y: 52},
            {x: 107, y: 84},
            {x: 126, y: 135},
            {x: 75, y: 102},
            {x: 24, y: 135},
            {x: 43, y: 84},
            {x: 0, y: 52},
            {x: 56, y: 52},
        ];

        // create a polygon object whit the coordinates
        var polygon = new fabric.Polygon(points, {
            left: 262,
            top: 190,
            fill: 'brown',
            stroke: "black",
            id: this.idCounter
        });

        // "add" star onto canvas
        this.canvas.add(polygon);
    },

    createLine: function(){
        var that = this;
        (function() {
            that.canvas.on('object:moving', function (e) {
                objectMoving(e);
            });

            addLine();

            function addLine() {
                var line = new fabric.Line([280, 296, 396, 254], {
                    stroke: 'black',
                    strokeWidth: 3,
                    lockScalingX: true,
                    lockScalingY: true,
                    lockRotation: true,
                    hasBorders: false,
                    hasControls: false,
                    perPixelTargetFind: true,
                    originX: 'center',
                    originY: 'center',
                    fill: 'black',
                    id: that.idCounter
                });
                line.lockScalingX = line.lockScalingY = true;

                var circle1 = new fabric.Circle({
                    left: line.x1,
                    top: line.y1,
                    lockScalingX: true,
                    lockScalingY: true,
                    lockRotation: true,
                    hasBorders: false,
                    hasControls: false,
                    radius: 3,
                    strokeWidth: 3,
                    originX: 'center',
                    originY: 'center',
                    stroke: 'black',
                    fill: 'black'
                });
                var circle2 = new fabric.Circle({
                    left: line.x2,
                    top: line.y2,
                    lockScalingX: true,
                    lockScalingY: true,
                    lockRotation: true,
                    hasBorders: false,
                    hasControls: false,
                    radius: 3,
                    strokeWidth: 3,
                    originX: 'center',
                    originY: 'center',
                    stroke: 'black',
                    fill: 'black'
                });
                circle1.line = circle2.line = line;
                line.circle1 = circle1;
                line.circle2 = circle2;

                that.canvas.add(line);
                that.canvas.add(circle1);
                that.canvas.add(circle2);

                circle1.bringToFront();
                circle2.bringToFront();
            }


            function objectMoving(e) {
                var p = e.target;

                // move line
                if (p.circle1) {
                    var oldCenterX = (p.x1 + p.x2) / 2;
                    var oldCenterY = (p.y1 + p.y2) / 2;

                    var deltaX = p.left - oldCenterX;
                    var deltaY = p.top - oldCenterY;

                    p.circle1.set({'left': p.x1 + deltaX, 'top': p.y1 + deltaY}).setCoords();
                    p.circle2.set({'left': p.x2 + deltaX, 'top': p.y2 + deltaY}).setCoords();

                    p.set({'x1': p.x1 + deltaX, 'y1': p.y1 + deltaY});
                    p.set({'x2': p.x2 + deltaX, 'y2': p.y2 + deltaY});
                }

                // move circle
                if (p.line) {
                    var cir1 = p.line.circle1;
                    var cir2 = p.line.circle2;

                    p.line.set({'x1': cir1.left, 'y1': cir1.top});
                    p.line.set({'x2': cir2.left, 'y2': cir2.top});
                    p.line.setCoords();
                }
            }
        })();
    },

    createArrow: function(){
        var that = this;
        (function() {
            that.canvas.on('object:moving', function (e) {
                objectMoving(e);
            });

            addArrow();

            function addArrow() {
                var aline = new fabric.Line([394, 254, 280, 296], {
                    stroke: 'black',
                    strokeWidth: 3,
                    lockScalingX: true,
                    lockScalingY: true,
                    lockRotation: true,
                    hasBorders: false,
                    hasControls: false,
                    perPixelTargetFind: true,
                    originX: 'center',
                    originY: 'center',
                    fill: 'black',
                    id: that.idCounter
                });
                var arrow = new fabric.Triangle({
                    left: aline.x1,
                    top: aline.y1,
                    width: 15,
                    height: 15,
                    lockScalingX: true,
                    lockScalingY: true,
                    lockRotation: true,
                    hasBorders: false,
                    hasControls: false,
                    centeredRotation: true,
                    originX: 'center',
                    originY: 'center',
                    fill: 'black'
                });
                var circle = new fabric.Circle({
                    left: aline.x2,
                    top: aline.y2,
                    lockScalingX: true,
                    lockScalingY: true,
                    lockRotation: true,
                    hasBorders: false,
                    hasControls: false,
                    radius: 3,
                    strokeWidth: 3,
                    originX: 'center',
                    originY: 'center',
                    stroke: 'black',
                    fill: 'black'
                });

                // Get angle
                dy = aline.y2 - aline.y1;
                dx = aline.x2 - aline.x1;
                theta = Math.atan2(dy, dx) * 180/Math.PI;

                arrow.set('angle', theta - 90);

                arrow.aline = circle.aline = aline;
                aline.arrow = arrow;
                aline.circle = circle;

                that.canvas.add(arrow);
                that.canvas.add(aline);
                that.canvas.add(circle);
            }


            function objectMoving(e) {
                var p = e.target;

                // move line
                if (p.arrow && p.circle) {
                    var oldCenterX = (p.x1 + p.x2) / 2;
                    var oldCenterY = (p.y1 + p.y2) / 2;

                    var deltaX = p.left - oldCenterX;
                    var deltaY = p.top - oldCenterY;

                    p.arrow && p.arrow.set({'left': p.x1 + deltaX, 'top': p.y1 + deltaY}).setCoords();
                    p.circle && p.circle.set({'left': p.x2 + deltaX, 'top': p.y2 + deltaY}).setCoords();

                    p.set({'x1': p.x1 + deltaX, 'y1': p.y1 + deltaY});
                    p.set({'x2': p.x2 + deltaX, 'y2': p.y2 + deltaY});
                }

                // move arrow and circle
                if (p.aline) {
                    var arrow = p.aline.arrow;
                    var cir = p.aline.circle;

                    p.aline.set({'x1': arrow.left, 'y1': arrow.top});
                    p.aline.set({'x2': cir.left, 'y2': cir.top});
                    p.aline.setCoords();

                    // Get angle
                    dy = p.aline.y2 - p.aline.y1;
                    dx = p.aline.x2 - p.aline.x1;
                    theta = Math.atan2(dy, dx) * 180/Math.PI;

                    arrow.set('angle', theta - 90);
                }
            }
        })();
    },

    customPostMessages: function(message) {
        var that = this;
        switch(message.data.method){
            case "addFigure":
                that.drawFigure(message.data.figure);
                break;
            default:
        }
    }
});