InteractiveMapComparative = new Class({
    Implements: [Options, Events],
    Extends: MapBase,
    slider_value: 0,
    initial_y: 0,
    initial_x: 650,
    zoom_drag: null,
    initialize: function (options) {
        document.widgetType = 'interactiveMapComparative'
        this.parent(options);
        this.options.container.addClass('ComparativeMap');
        this.render();
        this.notificationEl = new Element("div#notification", {
            'aria-live': 'polite',
            'style': 'position:absolute;left:-1000%;max-width:1px;'
        }).inject(this.options.container);

        $$('.pan-zoom-controls .zoom-reset').set('aria-label', 'Reset');
        $$('.pan-zoom-controls .zoom-out').set('aria-label', 'Zoom Out');
        $$('.pan-zoom-controls .zoom-in').set('aria-label', 'Zoom In');
    },
    buildLayers: function () {
        var that = this;
        this.options.data.each(function (layer) {
            if (typeof layer.image.path !== 'undefined') {
                var _class = 'layer';
                if (layer.id === '2') {
                    var html = '<div id="wrap"><div id="layer-' + layer.id + '" class="' + _class + ' layer-' + layer.id + '">\n\
                    <img src="' + layer.image.path + '" style="display: none" /></div></div>';
                } else {
                    var html = '<div id="layer-' + layer.id + '" class="' + _class + ' layer-' + layer.id + '">\n\
                    <img src="' + layer.image.path + '" /></div>';
                }
                $$('.widget-content .layers').appendHTML(html);
            }
        });
        $$('.widget-content .layers').appendHTML('<div id="draggable"></div>');
        this.zoom_drag = $('draggable');
    },
    render: function () {
        var _this = this;
        
        var _zoom = this.options.zoom;
        if (_zoom === 'true') {
            this.initializePanZoom();
        }
        var image = $$('.layers .layer img')[0];

        // hide zoom controls until image load event
        $$('.pan-zoom-controls').setStyle('opacity', 0);

        if (image) {
            image.addEvent('load', function () {
                var size = $(this).getSize();
                var images = $$('.layers .layer img');
                if (size.x > 650) {
                    images.setStyle('width', 650);
                } else {
                    _this.initial_x = size.x;
                }
                var size = images[0].getSize();
                _this.initial_y = size.y;
                $$('.pan-zoom').setStyle('height', size.y);
                $$('.pan-zoom').setStyle('width', size.x);

                _this.slider(images[0]);

                _this.fixZoomControlsPosition(25);
            });
        } else {
            _this.fixZoomControlsPosition(25);
        }
        setTimeout(function(){
          if ($$('.accessibility-intructions')[0]) {
            $$('.accessibility-intructions')[0].remove()
          }
        },0)
    },
    slider: function (image) {
        var _this = this;
        var slider = $('slider');

        // add a11y slider role attributes 
        slider.set('role', 'slider');
        slider.set('aria-label', 'reveal new information about the map');
        var slider_valuenow = slider.set('aria-valuenow', 0);
        slider.set('aria-valuemin', 0);
        slider.set('aria-valuemax', '100');

        // set slider size
        var size = image.getSize();
        slider.show();
        slider.setStyle('width', size.x + 9);
        var bottom = size.y + 17;
        $$('.slider .knob .bar').setStyle('height', bottom);
        $$('.slider .knob .bar').setStyle('bottom', -bottom);
        $$('.slider .line').setStyle('width', size.x + 20);
        $$('.slider').setStyle('height', 10);

        slider.getElement('.knob').addClass("hide-knob");

        // create slider input
        var slider_input = new Element("input#range.comparative", {
            min: 0,
            max: 100,
            value: 0,
            type: 'range'
        });
        slider_input.addEvent('mouseenter', function(e) {
            $$('.slider .line').setStyle('outline', 'auto 4px #579fff');
        });
        slider_input.addEvent('mouseout', function(e) {
            $$('.slider .line').setStyle('outline', 'none');
        });
        slider_input.addEvent('focus', function(e) {
            setTimeout(function () {
                if (slider_input.hasClass('non-keyboard-outline')) {
                    $$('#slider').addClass('non-keyboard-outline');
                    slider_input.removeClass('non-keyboard-outline');
                }
            }, 0);
        });
        slider_input.addEvent('focusout', function(e) {
            $$('#slider').removeClass('non-keyboard-outline');
        });
        slider_input.addEvent('blur', function(e) {
            $$('#slider').removeClass('non-keyboard-outline');
        });
        slider_input.inject(slider, 'after');
        var slider_input_width = Number($$('.pan-zoom')[0].getStyle('width').replace('px', '')) + 9;
        slider_input.setStyle('width', slider_input_width);

        // init mootools slider
        slider = new Slider(slider, slider.getElement('.knob'), {
            range: [0, 100],
            initialStep: 0,
            onChange: function(value) {
                _this.revealChart(value);
                _this.slider_value = value;
                slider_input.set("value", _this.slider_value);
                slider_valuenow.set('aria-valuenow', _this.slider_value);
            }
        });

        if (isFirefox) {
            // hide input, hide input border
            slider_input.setStyles({opacity: 0});
            // display slider knob
            slider.element.getElement('.knob').removeClass('hide-knob').setStyle('background-color', '#686d6c');
        }

        var activeSlider = slider_input;
        var passiveSlider = slider.element;

        activeSlider.set('tabindex', '0');
        passiveSlider.set('tabindex', '-1');
        passiveSlider.set('aria-hidden', 'true');

        activeSlider.addEventListener('keydown', function(e) {
            console.log('activeSlider keydown');
            //prevent firefox to navigate elements while screen reader is running
            e.stopPropagation();
            e.stopImmediatePropagation();

            var wasLeftPressed = e.code == 37 || e.which == 37 || e.keyCode == 37;
            var wasRightPressed = e.code == 39 || e.which == 39 || e.keyCode == 39;
            var wasUpPressed = e.code == 38 || e.which == 38 || e.keyCode == 38;
            var wasDownPressed = e.code == 40 || e.which == 40 || e.keyCode == 40;
            var wasTabPressed = e.code == 9 || e.which == 9 || e.keyCode == 9;
            var value = new Number(slider_input.get('value'));

            if (wasLeftPressed || wasDownPressed) {
                slider.set(value - 1);
                passiveSlider.set('value', value - 1);

                return setTimeout(function() {
                    activeSlider.focus();
                }, 0);
            } else if (wasRightPressed || wasUpPressed) {
                slider.set(value + 1);
                passiveSlider.set('value', value + 1);

                return setTimeout(function() {
                    activeSlider.focus();
                }, 0);
            } else if (!wasTabPressed) {
                e.preventDefault();
            }

            return false;
        });

        activeSlider.addEventListener('input', updateSliderValue);

        // HACK: voice over dispatch change event
        activeSlider.addEventListener('change', updateSliderValue);

        function updateSliderValue(event) {
            slider.set(new Number(event.target.get('value')));

            // prevent focus get lost on activeSlider
            activeSlider.focus();
        }
    },
    revealChart: function (value) {
        var zoom = $$('.map.map-main')[0].getProperty('data-zoom');
        if (zoom !== null) {
            zoom = zoom / 100;
            value *= zoom;
        }
        if (value == 0){
            $$('#layer-2 img').hide();
            $$('#layer-2 img').getSiblings('p')[0].addClass('hidden');
        } else if (value == 100){
            $$('#layer-1 img').hide();
            $$('#layer-1 img').getSiblings('p')[0].addClass('hidden');
        } else {
            $$('#layer-1 img').show();
            $$('#layer-2 img').show();
            $$('#layer-1 img').getSiblings('p')[0].removeClass('hidden');
            $$('#layer-2 img').getSiblings('p')[0].removeClass('hidden');
        }
        $('wrap').setStyle('width', value + '%');
    },
    // Overriding zooms
    drag: function () {
        return false;
    },
    panAccessible: function(direction){
        if (!this.width_limit) this.width_limit = 1;

        var img = $$('.layer img');
        var left = img.getStyle('left') !== 'auto' ? parseInt(img.getStyle('left')) : 0;
        var top = img.getStyle('top') !== 'auto' ? parseInt(img.getStyle('top')) : 0;
        
        var top_limit = img[0].getSize().y - this.initial_y;
        var left_limit = this.width_limit - this.initial_x;

        if (direction == "up" || direction == "down"){
            if (top == 0) {
                top += direction == "up" ? -10 : 0;
            } else if (top > -top_limit){
                top += direction == "up" ? -10 : 10;
            } else {
                top += direction == "up" ? 0 : 10;
            }
        } else {
            if (left == 0){
                left += direction == "left" ? -10 : 0;
            } else if (left <= -left_limit){
                left += direction == "left" ? 0 : 10;
            } else {
                left += direction == "left" ? -10 : 10;
            }
        }

        // avoid negative position
        left = left < 0 ? 0 : left;
        top = top < 0 ? 0 : top;

        img.setStyle('top', top);
        img.setStyle('left', left);
        $$('#draggable').setStyle('top', top);
        $$('#draggable').setStyle('left', left);

    },
    dragZoom: function (img, width) {
        var limit_x = width - this.initial_x;
        var size = img[0].getSize();
        var current = size.y;
        var limit_y = current - this.initial_y;
        // this.zoom_drag.set('tabindex', 0)
        this.zoom_drag.makeDraggable({
            limit: {
                x: [-limit_x, 0],
                y: [-limit_y, 0]
            },
            onDrag: function (e, item) {
                var left = item.target.getStyle('left');
                var top = item.target.getStyle('top');
                var id = item.target.id;

                if ( id === 'draggable') {
                    if (top !== 'auto' && left !== 'auto') {
                        $$('.layer img').setStyle('top', top);
                        $$('.layer img').setStyle('left', left);
                    } else {
                        this.stop();
                    }
                }
            }
        });

    },
    zoomIn: function () {
        if (this.zoom.current_value.zoom >= this.zoom.max_in) {
            return false;
        }
        var zoom = this.zoom.current_value.zoom + this.zoom.delta;
        this.zoom.current_value.zoom = zoom;
        this.notificationEl.set('html', "Image zoomed to " + zoom + "%");
        var width = this.initial_x * (zoom / 100);
        var img = $$('.layers .layer img');
        img.setStyle('width', width);
        var size = img[0].getSize();
        this.zoom_drag.setStyle('width', width);
        this.zoom_drag.setStyle('height', size.y);
        this.width_limit = width;
        this.dragZoom(img, width);
    },
    zoomOut: function () {
        if (this.zoom.current_value.zoom <= this.zoom.max_out) {
            return false;
        }
        var zoom = this.zoom.current_value.zoom - this.zoom.delta;
        this.zoom.current_value.zoom = zoom;
        this.notificationEl.set('html', "Image zoomed to " + zoom + "%");
        var width = this.initial_x * (zoom / 100);
        var img = $$('.layers .layer img');
        img.setStyle('width', width);
        img.setStyle('left', 0);
        img.setStyle('top', 0);
        var size = img[0].getSize();
        this.zoom_drag.setStyle('width', width);
        this.zoom_drag.setStyle('height', size.y);
        this.zoom_drag.setStyle('left', 0);
        this.zoom_drag.setStyle('top', 0);
        this.width_limit = width;
        this.dragZoom(img, width);
    },
    zoomReset: function () {
        this.zoom.current_value.zoom = 100;
        this.notificationEl.set('html', "Image zoomed to " + 100 + "%");
        var img = $$('.layers .layer img');
        var width = this.initial_x;
        img.setStyle('width', width);
        img.setStyle('top', '0');
        img.setStyle('left', '0');
        this.width_limit = width;
        this.dragZoom(img, width);
    }
});

var isChrome = navigator.userAgent.indexOf('Chrome') > -1;
var isFirefox = navigator.userAgent.indexOf('Firefox') > -1;
var isOpera = navigator.userAgent.toLowerCase().indexOf("op") > -1;
var isSafari = navigator.userAgent.indexOf("Safari") > -1;
if ((isChrome)&&(isSafari)) {isSafari=false;}
if ((isChrome)&&(isOpera)) {isChrome=false;}

console.log(isSafari)