InteractiveMapTimeline = new Class({
    Implements: [Options, Events],
    Extends: MapBase,
    options: {
        type: 'timeline'
    },
    startYear: 1900,
    endYear: 2000,
    width: null,
    vertical: 345,
    horizontal: 360,
    interval: 20,
    total: 0,
    proc_layers: [],
    initialize: function (options) {
        document.widgetType = 'interactiveMapTimeline'
        this.parent(options);
        var _startYear = parseFloat(this.options.timelineStartYear);
        if (_startYear !== '') {
            this.startYear = _startYear;
        }
        var _endYear = parseFloat(this.options.timelineEndYear);
        if (_endYear !== '') {
            this.endYear = _endYear;
        }
        var _width = this.options.timelineWidth;
        if (_width !== '') {
            this.width = _width;
        }
        var _vertical = parseInt(this.options.timelineVerticalPos);
        if (_vertical !== '') {
            this.vertical = _vertical;
        }
        var _horizontal = parseInt(this.options.timelineHorizontalPos);
        if (_horizontal !== '') {
            this.horizontal = _horizontal;
        }
        var _interval = parseInt(this.options.timelineInterval);
        if (_interval !== '') {
            this.interval = _interval;
        }

        this.calculateInitialValues();

        var _intervals = this.options.timelineIntervals;
        if (_intervals === 'true') {
            this.sliderIntervals();
            this.labelsIntervals();
        } else {
            this.slider();
            this.labels();
        }
        var _zoom = this.options.zoom;
        if (_zoom === 'true') {
            document.panZoomMap = 'interactive map timeline'
            this.initializePanZoom();
            this.drag();
        }
        
        if ($('intro-line')) {
            $('intro-line').set('html', '<p>'+$('intro-line').get('html')+'</p>');
            $$('.pan-zoom-controls').setStyle('top', 45);
        }

        $$('.pan-zoom pan-zoom-active').set('tabindex', 0)
        $$('.pan-zoom-controls .zoom-reset').set('aria-label', 'Reset');
        $$('.pan-zoom-controls .zoom-out').set('aria-label', 'Zoom Out');
        $$('.pan-zoom-controls .zoom-in').set('aria-label', 'Zoom In');

        this.notificationEl = new Element("div#notification", {
            'aria-live': 'polite',
            'style': 'position:absolute;left:-1000%;max-width:1px;'
        }).inject(this.options.container);

        if (typeof accessibility_data != 'undefined') {
            this.altTextImages  = accessibility_data.images.map(function(img){
                return img.alt;
            })    
        }
    },
    calculateInitialValues: function () {
        if (this.layers.length > 0) {
            // var last = this.layers.length - 1;
            // if (this.startYear === parseInt(this.layers[0].year)) {
            //     this.startYear -= 10;
            // }
            // if (this.endYear === parseInt(this.layers[last].year)) {
            //     this.endYear += 10;
            // }
            var layers = [];
            var final_layers = [];
            var i = 0;
            this.layers.each(function (item, index) {
                if (!layers.contains(item.year)) {
                    layers[i] = item.year;
                    final_layers[i] = {year: item.year, id: item.id};
                    i++;
                }
            });

            this.proc_layers = final_layers;
        }
    },
    // Generate the html for the slider
    slider: function () {
        // TODO: delete #slider element
        var slider = $('slider');
        slider.set('role', 'slider');
        slider.set('aria-label', 'Move the slider to activate the progression');
        slider.set('tabindex', -1);
        slider.set('aria-hidden', 'true');
        slider.addClass('visually-hidden')
        slider.show();
        
        var totalLayers = this.proc_layers.length;
        var min = -1;
        var html = '';
        if (this.startYear === parseInt(this.layers[0].year)) {
            min = 0;
        }
        slider.set('aria-valuenow', this.startYear);
        slider.set('aria-valuemin', this.startYear);
        slider.set('aria-valuemax', this.endYear);

        if (this.endYear === parseInt(this.layers[this.proc_layers.length-1].year)) {
            totalLayers--;
        }

        if (this.width !== null) {
            html = '<div class="range_wrap" style="width: ' + this.width + 'px;">';
        } else {
            html = '<div class="range_wrap" style="width: ' + (this.proc_layers.length + 1) * 75 + 'px;">';
        }

        if(this.layers[0].ariaText){
            if (!isChrome) {
                html += '<input id="range" type="range" min="' + min + '" aria-valuemin="' + this.startYear + '" max="' + totalLayers + '" aria-valuemax="' + this.endYear + '" aria-valuenow="' + this.startYear + '" aria-valuetext="' + this.layers[0].ariaText + '" value="' + this.startYear + '" step="1" aria-label="Move the slider to activate the progression"/></div>';
            } else {
                html += '<input id="range" type="range" min="' + min + '" max="' + totalLayers + '" aria-valuetext="' + this.layers[0].ariaText + '" value="' + min + '" step="1" aria-label="Move the slider to activate the progression"/></div>';
            }
        }else{
            if (!isChrome) {
                html += '<input id="range" type="range" min="' + min + '" aria-valuemin="' + this.startYear + '" max="' + totalLayers + '" aria-valuemax="' + this.endYear + '" aria-valuenow="' + this.startYear + '" aria-valuetext="' + this.startYear + '" value="' + min + '" step="1" aria-label="Move the slider to activate the progression"/></div>';
            } else {
                // HACK: range input doesn't work well with arrow keys
                // when voiceover is enable and the range input has certain a11y attributes
                html += '<input id="range" type="range" min="' + min + '" max="' + totalLayers + '" aria-valuetext="' + this.startYear + '" value="' + min + '" step="1" aria-label="Move the slider to activate the progression"/></div>';
            }
        }

        $$('.widget-header').appendHTML(html);

        var widgetHeader = $$('.widget-header')[0];
        widgetHeader.insertBefore(widgetHeader.childNodes[5], widgetHeader.childNodes[3]);

        $$('.range_wrap').setStyle('top', this.vertical);
        $$('.range_wrap').setStyle('left', this.horizontal);

        this.sliderEvents();
    },
    panAccessible: function(direction){
        this.layers.forEach(function(el){
            var img = "layer-"+el.id;
            var bg_img = "layer-SB";
            img = $(img);
            bg_img = $(bg_img);

            var left = img.getStyle('left') !== 'auto' ? parseInt(img.getStyle('left')) : 0;
            var top = img.getStyle('top') !== 'auto' ? parseInt(img.getStyle('top')) : 0;

            var bg_left = bg_img.getStyle('left') !== 'auto' ? parseInt(bg_img.getStyle('left')) : 0;
            var bg_top = bg_img.getStyle('top') !== 'auto' ? parseInt(bg_img.getStyle('top')) : 0;

            
            
            if (direction == "up" || direction == "down"){
                top += direction == "up" ? -10 : 10;
            } else {
                left += direction == "left" ? -10 : 10;
            }
            
            img.setStyle('top', top);
            img.setStyle('left', left);
            bg_img.setStyle('top', top);
            bg_img.setStyle('left', left);
        });

    },
    sliderEvents: function () {
        var _this = this;
        var $mootoolSlider = $('slider');
        var $sliderInput = $('range');

        $sliderInput.set('tabindex', '0');
        $sliderInput.addEvent('input', handleSliderInputChange);
        $sliderInput.addEvent('change', handleSliderInputChange);

        function handleSliderInputChange (e) {
            var index = $sliderInput.get('value');
            var year = null;
            var valueNow;

            if (index == -1) {
                valueNow = _this.startYear;
            } else {
                if (_this.layers[index]) {
                    valueNow = _this.layers[index].year;
                }
            }

            if (_this.layers[0].ariaText) {
                $mootoolSlider.set('aria-valuenow', valueNow);
                $mootoolSlider.set('aria-valuetext', _this.layers[index].ariaText);
                if (!isChrome) {
                    $sliderInput.set('aria-valuenow', valueNow);
                }
                $sliderInput.set('aria-valuetext', _this.layers[index].ariaText);
            } else {
                $mootoolSlider.set('aria-valuenow', valueNow);
                $mootoolSlider.set('aria-valuetext', valueNow);
                if (!isChrome) {
                    $sliderInput.set('aria-valuenow', valueNow);
                }
                $sliderInput.set('aria-valuetext', valueNow);
            }

            if (typeof _this.proc_layers[index] !== 'undefined') {
                var year = parseFloat(_this.proc_layers[index].year);
            }

            if (year !== null) {
                _this.layers.each(function(item, _index) {
                    if (parseFloat(item.year) == year) {
                        $('layer-' + item.id).show();

                        if (_this.altTextImages) {
                            var altText = _this.altTextImages[_index + 1] || ""
                            $mootoolSlider.set('aria-valuetext', item.year + ', ' + altText);
                            $sliderInput.set('aria-valuetext', item.year + ', ' + altText);
                        }
                    } else {
                        $('layer-' + item.id).hide();
                    }
                });
            }

            if (index == -1) {
                $$('.layers .layer').hide();
                var year = $$('.value.first').get('text');
                var altText = _this.altTextImages[0] || ""
                $mootoolSlider.set('aria-valuetext', year + ', ' + altText);
                $sliderInput.set('aria-valuetext', year + ', ' + altText);
            }
        }

        if (isSafari) {
            // HACK: allow key arrows works on slider in safari
            $sliderInput.addEventListener('click', function () {
                $sliderInput.focus();
                $sliderInput.removeClass('non-keyboard-outline');
            });
        }

        if (this.layers.length > 0) {
            if (this.startYear === parseInt(this.layers[0].year)) {
                $('layer-' + this.layers[0].id).show();
            }
        }

        setTimeout(function () {
            $$('div.value').set('aria-hidden', 'true');
        });
    },
    // Generate labels
    labels: function () {
        var _this = this;
        // var percentage = 0;
        // if (this.layers.length > 0) {
        //     percentage = 100 / (this.proc_layers.length + 1);
        //     var values = '<div class="value first" style="width: ' + percentage + '%;">' + this.if_negative(this.startYear) + '</div>';

        //     this.proc_layers.each(function (item) {
        //         if (item.year !== this.startYear && item.year !== this.endYear) {
        //             values += '<div class="value" style="width: ' + percentage + '%;">' + _this.if_negative(item.year) + '</div>';
        //         }
        //     });
        //     values += '<div class="value last" style="width: ' + percentage + '%;">' + this.if_negative(this.endYear) + '</div>';
        //     $$('.range_wrap').appendHTML(values);
        // }
        var percentage = 0;
        var values = '';
        var i = 0;
        var totalLayers = this.proc_layers.length;
        var class_value= "value" 
        if(this.options.numbers_only) {
            class_value= "value numbers-only"
        }

        if (this.layers.length > 0) {
            if ( (this.endYear !== parseInt(this.layers[this.proc_layers.length-1].year)) && (this.startYear !== parseInt(this.layers[0].year)) ) {
                //console.log('NINGUNO extremo igual');
                percentage = 100 / (this.proc_layers.length + 1);
            } else if ( (this.endYear === parseInt(this.layers[this.proc_layers.length-1].year)) && (this.startYear !== parseInt(this.layers[0].year)) ) {
                //console.log('FIN extremo igual');
                percentage = 100 / (this.proc_layers.length);
            } else if ( (this.endYear !== parseInt(this.layers[this.proc_layers.length-1].year)) && (this.startYear === parseInt(this.layers[0].year)) ) {
                //console.log('INICIO extremo igual');
                percentage = 100 / (this.proc_layers.length);
            } else {
                //console.log('DOS extremos iguales');
                percentage = 100 / (this.proc_layers.length -1);
            }

            if (this.endYear === parseInt(this.layers[totalLayers-1].year)) {
                totalLayers--;
            }

            if (this.startYear === parseInt(this.layers[0].year)) {
                i++;
            }
            values += '<div class="'+class_value+' first" style="width: ' + percentage + '%; ">' + this.if_negative(this.startYear) + '</div>';
            
            while (i < totalLayers){
                if(_this.if_negative(this.proc_layers[i].year) > 9) {
                    class_value = "value numbers-only-two"
                }
                values += '<div class="'+class_value+'" style="width: ' + percentage + '%;">' + _this.if_negative(this.proc_layers[i].year) + '</div>';
                i++;
            }
            if(this.if_negative(this.endYear) > 9) {
                class_value = "value numbers-only-two"
            }
            values += '<div class="'+class_value+' last" style="width: ' + percentage + '%;">' + this.if_negative(this.endYear) + '</div>';

            $$('.range_wrap').appendHTML(values);
        }

    },
    sliderIntervals: function () {
        var total_years = this.endYear - this.startYear;
        var intervals = total_years / this.interval;
        if (this.width !== null) {
            var html = '<div class="range_wrap" style="width: ' + this.width + 'px;">';
        } else {
            var html = '<div class="range_wrap" style="width: ' + (intervals) * 75 + 'px;">';
        }
        html += '<input aria-hidden="true" id="range" type="range" min="' + this.startYear + '" max="' + this.endYear + '" value="' + this.startYear + '"/></div>';
        $$('.widget-header').appendHTML(html);
        $$('.range_wrap').setStyle('top', this.vertical);
        $$('.range_wrap').setStyle('left', this.horizontal);
        this.sliderIntervalsEvents();
    },
     sliderIntervalsEvents: function () {
        var _this = this;

       $('range').addEvent('change', function(e){
         // $('slider').focus()
         // return _this.notificationEl.set('text', $('slider').get('aria-valuetext'))
       })
        $('range').addEvent('input', function () {
            var index = this.get('value');
            _this.layers.each(function (item) {
                if (parseFloat(item.year) <= index) {
                    $('layer-' + item.id).show();
                } else {
                    $('layer-' + item.id).hide();
                }
            });
        });
    },
    labelsIntervals: function () {
        var _this = this;
        var total_years = this.endYear - this.startYear;
        var intervals = total_years / this.interval;
        var percentage = 0;
        percentage = 100 / (intervals);
        var values = '';

        for (var i = this.startYear; i <= this.endYear; i += this.interval) {
            var _class = '';
            var next = i + this.interval;
            if (i === this.startYear) {
                _class = 'first';
            } else if (i === this.endYear || next > this.endYear) {
                _class = 'last';
            }
            values += '<div class="value ' + _class + '" style="width: ' + percentage + '%;">' + this.if_negative(i) + '</div>';
        }
        $$('.range_wrap').appendHTML(values);
    },
    if_negative: function(year){
        var _year = parseFloat(year);
        if (_year < 0) {
            return Math.abs(_year) + ' BCE';
        } else {
            return year;
        }
    },
    zoomIn: function () {
        if (this.zoom.current_value.zoom >= this.zoom.max_in) {
            return false;
        }
        this.zoomTo(this.zoom.current_value.zoom + this.zoom.delta, 0.1);
        this.notificationEl.set('html', "Image zoomed to "+this.zoom.current_value.zoom+"%");
    },
    zoomOut: function () {
        if (this.zoom.current_value.zoom <= this.zoom.max_out) {
            return false;
        }
        this.zoomTo(this.zoom.current_value.zoom - this.zoom.delta, -0.1);
        this.notificationEl.set('html', "Image zoomed to "+this.zoom.current_value.zoom+"%");
    },
    zoomReset: function () {
        this.zoomTo(100, 0);
        this.notificationEl.set('html', "Image zoomed to 100%");
    },
});

var isChrome = navigator.userAgent.indexOf('Chrome') > -1;
var isFirefox = navigator.userAgent.indexOf('Firefox') > -1;
var isOpera = navigator.userAgent.toLowerCase().indexOf("op") > -1;
var isSafari = navigator.userAgent.indexOf("Safari") > -1;
if ((isChrome)&&(isSafari)) {isSafari=false;}
if ((isChrome)&&(isOpera)) {isChrome=false;}