ToggleMap = new Class({
    Implements: [Options, Events],
    Extends: MapBase,
    options: {
        duration: 1800,
        type: 'toggle'
    },
    layers: [],
    checksWrapper: {},
    legendWidth: '',
    column_2: 'false',
    items_count: 0,
    initialize: function (options) {
        var _this = this;
        this.setOptions(options);

        this.notificationEl = new Element("div#notification", {
            'aria-live': 'polite',
            'style': 'position:absolute;left:-1000%;max-width:1px;'
        }).inject(this.options.container);

        this.checksWrapper = $$('.map-key')[0];
        this.options.container.addClass('ToggleMap');
        this.column_2 = $('MetrodigiWidget').get('data-column2');
        // add default layer text
        this.options.data.each(function (layer, i) {
            if (layer.image.path && !layer.layer && layer.image.path.indexOf('images/') !== -1) {
                var imagePath = layer.image.path;
                var lastSlashIndex = imagePath.lastIndexOf('/');
                var lastDotIndex = imagePath.lastIndexOf('.');
                var finalIndex = lastDotIndex === -1 ? imagePath.length : lastDotIndex;
                var fileName = imagePath.substring(lastSlashIndex + 1, finalIndex);
                layer.layer = layer.fileName || fileName;

                console.log('layer ' + i + ' path: ', imagePath);
            }
        });

        zoom = this.options.zoom;
        var legendWidth = this.options.toggleWidth;
        this.legendWidth = legendWidth;
        var legendHorizontalPos = this.options.toggleHorizontalPos;
        var legendVerticalPos = this.options.toggleVerticalPos;

        if (zoom == 'true') {
            this.initializePanZoom();
            this.drag();
        }

        this.options.container.getElement('.map-key').style.width = legendWidth + 'px';
        this.options.container.getElement('.map-key').style.left = legendHorizontalPos + 'px';
        this.options.container.getElement('.map-key').style.top = legendVerticalPos + 'px';

        this.parent(options);

        this.fixZoomControlsPosition(25);

        $$('.pan-zoom-controls .zoom-reset').set('aria-label', 'Reset');
        $$('.pan-zoom-controls .zoom-out').set('aria-label', 'Zoom Out');
        $$('.pan-zoom-controls .zoom-in').set('aria-label', 'Zoom In');

        this.addEvents();
    },
    buildItem: function (layer) {
        var that = this;
        var altElId = 'layerimagealtstatic-' + layer.id;
        this.items_count++;
        var listItem = new Element('li').inject(this.checksWrapper);

        if (this.column_2 === 'true') {
            listItem.setStyle('width', '50%');
            if (this.items_count % 2 === 0) {
                new Element('div.clear').inject(this.checksWrapper);
            }
        } else {
            new Element('div.clear').inject(this.checksWrapper);
        }

        var lastTimerId = null;
        var toggleInput = function (inputEl) {
            clearTimeout(lastTimerId);
            var currentInputEl = inputEl;

            // check current checkbox input
            currentInputEl.set('checked', !currentInputEl.get('checked'));
            $$('.map-key input:not(:checked)').set('aria-describedby', '');

            that.toggleLayer("#" + currentInputEl.get("data-layer"), !!currentInputEl.get("checked"));

            if (currentInputEl.get('checked')) {
                currentInputEl.getNext('p').set('text', '');
                currentInputEl.set('aria-describedby', currentInputEl.get('data-describedby'));
                currentInputEl.getNext('p').set('aria-hidden', 'false');
                currentInputEl.getNext('p').set('aria-relevant', 'additions text');

                lastTimerId = setTimeout(function () {
                    var p = currentInputEl.getNext('p');
                    // read image alt text
                    p.set('text', p.get('data-text'));
                }, 500);
            }
        };

        var inputtrigger = new Element('input.map-layer-trigger', {
            type: 'checkbox',
            'data-layer': 'layer-' + layer.id,
            id: 'checkbox-' + layer.id,
            'aria-describedby': '',
            'data-describedby': altElId
        });
        inputtrigger.addEvent("click", function (e) {
            e.preventDefault();
            setTimeout(function () {
                toggleInput(e.target);
            }, 0);
        });
        inputtrigger.addEvent("keyup", function (e) {
            e.preventDefault();
            if (e.code == 32) {
                setTimeout(function () {
                    toggleInput(e.target);
                }, 0);
            }
        });

        inputtrigger.inject(listItem);

        var label = new Element('label', {
            for : 'checkbox-' + layer.id
        }).inject(listItem);

        var label_width = this.legendWidth - 55;
        if (this.column_2 === 'true') {
            label_width /= 2;
            label_width -= 25;
        }
        $$(label).setStyle('width',  label_width + 'px');

        if (layer['image legend'].path !== '') {
            var span = new Element('span.color', {id: 'color'}).inject(listItem);
            $$(span).setStyle('background', 'url(' + layer['image legend'].path + ') center center no-repeat');
            $$(span).setStyle('background-size', 'cover');
            $$(span).setStyle('border', 'none');
        } else {
            var span = new Element('span.color', {id: 'color'}).inject(listItem);
            $$(span).setStyle('background', (layer.color.indexOf("#")<0?'#':"") + layer.color);
        }

        new Element('div.clear').inject(listItem);

        var legend = this.convertToHTML(layer.legend);

        new Element('span.label', {
            'tab-index': 0,
            html: legend
        }).inject(label);

        new Element('p', {
            id: altElId,
            html: layer.image.alt,
            'data-text': layer.image.alt,
            class: 'visually-hidden',
            'aria-live': 'polite',
            // prevent image alt text been read twice
            'aria-hidden': 'true',
            'aria-relevant': ''
        }).inject(listItem);
    },
    buildLayers: function () {
        var that = this;
        var mainAlts = {};
        this.options.data.each(function (layer) {
            if (typeof layer.image.path !== 'undefined') {
                var _class = 'layer';
                if (layer.id === 'SB') {
                    mainAlts.SB = layer.image.alt;
                    _class = 'base visible layer';
                } else if (layer.id === 'ST') {
                    mainAlts.ST = layer.image.alt;
                    _class = 'over visible layer';
                } else {
                    that.layers.push(layer);
                    that.buildItem(layer);
                }

                var el = new Element('div.map-layer', {
                    id: 'layer-' + layer.id,
                    'class': _class + ' layer-' + layer.id,
                }).inject($$('.widget-content .layers')[0]);

                if (layer.image.path) {
                    // setTimeout(function(){
                    //     var img = new Image();
                    //     img.src = layer.image.path;
                    //     //alert(img.width + "x" + img.height);
                    //     if(img.height > 0 ){
                    //         console.log($$(el));
                    //         $$(el).getParent('.pan-zoom').setStyle('height', img.height + 'px');
                    //     }
                    // }, 500);
                    var img = new Element('img', {
                        src: layer.image.path,
                        styles: {
                            display: 'none'
                        }
                    }).inject($$('.widget-content .layers')[0]);
                    $$(el).getParent('.pan-zoom').setStyle('height', '560px');
                    $$(el).setStyle('background-image', 'url("' + layer.image.path + '")');
                    $$(el).setStyle('background-size', 'contain');
                    $$(el).setStyle('background-position', '50% 0%');
                } else {
                    $$(el).setStyle('background-image', 'transparent');
                }
            }
        });

        var mainImageAltElId = "SBSTaltimg";
        $("layer-SB").set("tabindex", "2");
        $("layer-SB").set("role", "img");
        $("layer-SB").set("aria-describedby", mainImageAltElId);
        new Element('p', {
            id: mainImageAltElId,
            html: (mainAlts.SB || "") + ", " + (mainAlts.ST || ""),
            class: 'visually-hidden'
        }).inject($$('.widget-content .layers')[0]);
    },
    addEvents: function () {},
    zoomIn: function () {   
        if (this.zoom.current_value.zoom >= this.zoom.max_in) {
            return false;
        }
        var zoom = this.zoom.current_value.zoom + this.zoom.delta;
        this.notificationEl.set('html', "Image zoomed to " + zoom + "%");
        this.zoomTo(zoom, 0.1);
    },
    zoomOut: function () {
        if (this.zoom.current_value.zoom <= this.zoom.max_out) {
            this.resetPanAccessible();
            return false;
        }
        var zoom = this.zoom.current_value.zoom - this.zoom.delta;
        this.notificationEl.set('html', "Image zoomed to " + zoom + "%");
        this.zoomTo(zoom, -0.1);
    },
    zoomReset: function () {
        var zoom = 100;
        this.notificationEl.set('html', "Image zoomed to " + zoom + "%");
        this.zoomTo(zoom, 0);
    }
});
