// https://tc39.github.io/ecma262/#sec-array.prototype.find
if (!Array.prototype.find) {
  Object.defineProperty(Array.prototype,"find",{value:function(b){if(this==null){throw new TypeError('"this" is null or not defined')}var f=Object(this);var a=f.length>>>0;if(typeof b!=="function"){throw new TypeError("predicate must be a function")}var c=arguments[1];var d=0;while(d<a){var e=f[d];if(b.call(c,e,d,f)){return e}d++}return undefined},configurable:true,writable:true});
}

InteractiveMap = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
    },
    map_type: null,
    widget: null,
    initialize: function (options) {

        _this = this;

        options.extra = [
            'data-zoom',
            'data-toggle-width',
            'data-toggle-horizontal-pos',
            'data-toggle-vertical-pos',
            'data-width',
            'data-horizontal-pos',
            'data-vertical-pos',
            'data-timeline-start-year',
            'data-timeline-end-year',
            'data-timeline-intervals',
            'data-timeline-interval',
            'data-column2'
        ];
        this.parent(options);

        //common (toggle, timeline, comparative)
        zoom = $('MetrodigiWidget').get('data-zoom');
        this.options.zoom = zoom;

        //toggle
        toggleWidth = $('MetrodigiWidget').get('data-toggle-width');
        toggleHorizontalPos = $('MetrodigiWidget').get('data-toggle-horizontal-pos');
        toggleVerticalPos = $('MetrodigiWidget').get('data-toggle-vertical-pos');
        this.options.toggleWidth = toggleWidth;
        this.options.toggleHorizontalPos = toggleHorizontalPos;
        this.options.toggleVerticalPos = toggleVerticalPos;

        //timeline
        timelineStartYear = $('MetrodigiWidget').getProperty('data-timeline-start-year');
        timelineEndYear = $('MetrodigiWidget').getProperty('data-timeline-end-year');
        timelineWidth = $('MetrodigiWidget').getProperty('data-width');
        timelineVerticalPos = $('MetrodigiWidget').getProperty('data-vertical-pos');
        timelineHorizontalPos = $('MetrodigiWidget').getProperty('data-horizontal-pos');
        timelineInterval = $('MetrodigiWidget').getProperty('data-timeline-interval');
        timelineIntervals = $('MetrodigiWidget').getProperty('data-timeline-intervals');
        this.options.timelineStartYear = timelineStartYear;
        this.options.timelineEndYear = timelineEndYear;
        this.options.timelineWidth = timelineWidth;
        this.options.timelineVerticalPos = timelineVerticalPos;
        this.options.timelineHorizontalPos = timelineHorizontalPos;
        this.options.timelineInterval = timelineInterval;
        this.options.timelineIntervals = timelineIntervals;

        this.challengeAssessableText = "Navigate to the first concept";
        this.presentationAssessableText = "Study the table";

        this.renderWidget();
        this.createAssessableText();
        this.setAssessableText(this.challengeAssessableText);
    },
    addAltTextToData: function () {
        var accessibilityData = window.accessibility_data;
        if (!accessibilityData || !accessibilityData.images || accessibilityData.images.length === 0) {
            return;
        }

        this.options.data.each(function (layer, i) {
            var imagePath = layer.image.path;
            var n = imagePath.lastIndexOf('/');
            var imageFileName = imagePath.substring(n + 1);
            var accessibilityImage = accessibilityData.images.find(function (image) {
                return image.src === imageFileName;
            });
            if (!accessibilityImage) {
                return;
            }
            layer.image.alt = accessibilityImage.alt;
            layer.image.altLong = accessibilityImage.altLong;
        });
    },
    renderWidget: function () {
        //Create the inital selection step.
        edit_init_container = this.container.getElement('#md-edit-init-step');
        this.map_type = $('MetrodigiWidget').get('data-xml-type');
        this.data_zoom = $('MetrodigiWidget').get('data-zoom');

        this.addAltTextToData();

        if (this.map_type) {

            switch (this.map_type) {
                case "toggle":
                    this.widget = new ToggleMap(this.options);

                    if (this.data_zoom == false) {
                        this.container.getElement('.pan-zoom-controls').style.display = 'none';
                    }

                    break;
                case "timeline":
                    //toggle elements
                    this.container.getElement('.map-key').style.display = 'none';
                    this.container.getElement('.pan-zoom-controls').style.display = 'none';

                    this.widget = new InteractiveMapTimeline(this.options);
                    break;
                case "comparative":
                    //toggle elements
                    this.container.getElement('.map-key').style.display = 'none';
                    this.container.getElement('.pan-zoom-controls').style.display = 'none';

                    this.widget = new InteractiveMapComparative(this.options);
                    break;
            }
        } else {
            this.sendPostMessages('hide-data-panel');
            this.container.getElement('.widget-header').hide();
            this.container.getElement('.widget-content').hide();
            this.container.getElement('.widget-footer').hide();

            this.options.init_step.forEach(function (step, index) {

                title = '<div class="title">' + step.title + '</div>';
                subtitle = '<div class="subtitle">' + step.subtitle + '</div>';

                wrapper = new Element('div', {
                    'class': 'wrapper init_step_' + index,
                    html: title + subtitle
                }).inject(edit_init_container);

                var image_wrapper = new Element('div.image-wrapper')
                        .setStyles({
                            'background': 'url(../_framework/interactive-map-v2/init_step/images/' + step.image_src + ') top left no-repeat',
                            'background-size': '100% 100%'
                        })
                        .inject(wrapper);

                if (step.image_src_grid_line) {
                    new Element('div.image-wrapper-outer')
                            .setStyles({
                                'background': 'url(../_framework/interactive-map-v2/init_step/images/' + step.image_src_grid_line + ') top left no-repeat',
                                'background-size': '100% 100%'
                            })
                            .inject(image_wrapper);
                }

                init_interactivitiy_wrapper = new Element('div.init-interactivity').inject(wrapper);

                new Element('button', {
                    html: 'Choose',
                    id: 'init_step_' + index
                })
                        .set('type', 'button')
                        .inject(wrapper)
                        .addEvent('click', function (e) {
                            _this.container.getElement('#md-edit-init-step').hide();
                            _this.container.getElement('.widget-header').show();
                            _this.container.getElement('.widget-content').show();
                            _this.container.getElement('.widget-footer').show();

                            //determine which map widget will be visible
                            switch (e.target.getParent('.wrapper .title').innerHTML) {
                                case 'Toggle Map':
                                    _this.toggle_map();
                                    break;
                                case 'Timeline Map':
                                    _this.timeline_map();
                                    break;
                                case 'Comparative Map':
                                    _this.comparative_map();
                                    break;
                            }
                        });

                //Create the interactivity for each init_step item
                //toggle map
                if (step.toggle_map) {
                    step.toggle_map.forEach(function (el, i) {
                        layer_wrapper = new Element('div.layer_toggle').inject(init_interactivitiy_wrapper);

                        new Element('img', {
                            'data-id': i
                        })
                                .set('src', '../_framework/interactive-map-v2/init_step/images/' + el.image_src)
                                .set('alt', i)
                                .inject(_this.container.getElement('#md-edit-init-step .init_step_' + index + ' .image-wrapper', 'top'));

                        off_element = '<span class="checkbox"></span> Layer off';

                        new Element('div', {
                            html: '<span class="checkbox" style="background-color: ' + el.layer_color + '";></span><i class="fa fa-check"></i> Layer on',
                            'class': 'layer_button on'
                        }).inject(layer_wrapper)

                                //toggle on/off for each toggle map layer options
                                .addEvent('click', function (e) {
                                    e.target = e.target.hasClass('layer_button') ? e.target : e.target.getParent();
                                    _this.container.getElements('#md-edit-init-step .init_step_' + index + ' .image-wrapper img[data-id="' + i + '"]').toggle();
                                    if (e.target.hasClass('off')) {
                                        var on_element = '<span class="checkbox" style="background-color: ' + el.layer_color + '";></span><i class="fa fa-check"></i> Layer on';
                                        e.target.set('html', on_element).removeClass('off').addClass('on');
                                    } else if (e.target.hasClass('on')) {
                                        e.target.set('html', off_element).removeClass('on').addClass('off');
                                    }
                                });

                    });
                }
                ;

                //timeline map
                if (step.timeline_map) {
                    //create the slider
                    slider_wrapper = new Element('div.slider').inject(init_interactivitiy_wrapper);
                    knob = new Element('div.knob').inject(slider_wrapper);
                    slider_labels = new Element('div.labels').inject(init_interactivitiy_wrapper);

                    step.timeline_map.forEach(function (map, i) {
                        new Element('img', {
                            'data-id': i
                        })
                                .set('src', '../_framework/interactive-map-v2/init_step/images/' + map.image_src)
                                .set('alt', i)
                                .inject(_this.container.getElement('#md-edit-init-step .init_step_' + index + ' .image-wrapper'))
                    });

                    _this.container.getElements('#md-edit-init-step .init_step_' + index + ' .image-wrapper img:not(:first-of-type)').setStyles({
                        'visibility': 'hidden',
                        'opacity': 0
                    });

                    slider_width = _this.container.getElement('#md-edit-init-step .init_step_' + index + ' .slider').getCoordinates().width;

                    //create the labels
                    step.timeline_map.forEach(function (el, i) {
                        new Element('div.label', {
                            html: el.text
                        })
                                .inject(_this.container.getElement('#md-edit-init-step .init_step_' + index + ' .init-interactivity .labels'))
                                .setStyle('width', 'calc(' + slider_width + 'px / ' + step.timeline_map.length + ')');
                    });

                    new Slider(slider_wrapper, knob, {
                        snap: true,
                        wheel: true,
                        steps: step.timeline_map.length - 1,
                        onChange: function (pos) {

                            _this.container.getElements('#md-edit-init-step .init_step_' + index + ' .image-wrapper img').setStyles({
                                'visibility': 'hidden',
                                'opacity': 0
                            });

                            for (var i = 0; i <= pos; i++) {
                                _this.container.getElements('#md-edit-init-step .init_step_' + index + ' .image-wrapper img[data-id="' + i + '"]').fade('in');
                            }
                            ;

                        }

                    });
                }
                ;

                //comparative map
                if (step.comparative_map) {
                    slider_wrapper = new Element('div.slider').inject(init_interactivitiy_wrapper);
                    knob = new Element('div.knob').inject(slider_wrapper);
                    slider_labels = new Element('div.labels').inject(init_interactivitiy_wrapper);

                    image_wrapper_coordinates = _this.container.getElement('#md-edit-init-step .init_step_' + index + ' .image-wrapper').getCoordinates();


                    comparative_map_image = new Element('img')
                            .set('src', '../_framework/interactive-map-v2/init_step/images/' + step.comparative_map_image_src)
                            .set('alt', 'comparative')
                            .inject(_this.container.getElement('#md-edit-init-step .init_step_' + index + ' .image-wrapper'))
                            .setStyle('clip', 'rect(0, 0, ' + image_wrapper_coordinates.height + 'px, 0)');

                    new Slider(slider_wrapper, knob, {
                        wheel: true,
                        steps: image_wrapper_coordinates.width,
                        onChange: function (pos) {
                            comparative_map_image.setStyle('clip', 'rect(0, ' + pos + 'px, ' + image_wrapper_coordinates.height + 'px, 0)')
                        }
                    });

                }
            });
        }
    },
    toggle_map: function () {
        _this.sendPostMessages('set-type', {type: 'toggle'})
    },
    timeline_map: function () {
        _this.sendPostMessages('set-type', {type: 'timeline'});
    },
    comparative_map: function () {
        _this.sendPostMessages('set-type', {type: 'comparative'});
    },
    renderEdit: function () {
        var introLine = this.options.container.getElementById('intro-line');

        if (introLine != null) {
            introLine = '<div id="intro-line" contenteditable="true" data-md-editable="md-content-editable">' + introLine.get('html') + '</div>';
        } else {
            introLine = '';
        }

        widgetHeader = this.options.container.getElements('.widget-header')[0];
        widgetHeader.set('html', '');
        widgetHeader.appendHTML(introLine + '<div id="slider" class="slider"><div class="line"></div><div class="knob"><div class="bar"></div></div></div><div class="pan-zoom-controls"><button class="zoom-in">+</button><button class="zoom-out">-</button><button class="zoom-reset">Reset</button></div>');

        widgetContent = this.options.container.getElements('.widget-content')[0];
        widgetContent.set('html', '');
        widgetContent.appendHTML('<div class="pan-zoom pan-zoom-active"><div class="map map-main" data-map="main" data-zoom="100"><div class="maps layers"></div></div></div><ul class="map-key"></ul>');

        this.renderWidget();
        this.buildHotspots();
    },
    renderHotspotsEdit: function () {
        infoWrapper = this.options.container.getElementById('infoWrapper')
        if (infoWrapper != null) {
            infoWrapper.destroy();
        }

        this.buildHotspots();
    },


    buildHotspots: function () {
        if (this.options.hotspots && this.options.hotspots.length > 0) {
            var _this = this;

            this.infoWrapper = new Element('div#infoWrapper');

            if ($$('.map')[0]) {
                this.infoWrapper.inject($$('.map')[0]);
            }
            else {
                this.infoWrapper.inject($$(this.container)[0]);
            }

            this.options.hotspots.each(function (popup, i) {
                position = '';

                if (typeof popup.position != 'undefined') {
                    position = popup.position;
                }

                img = new Element('button', {
                    'type': 'image',
                    'src': '../_base_pearson/images/info.png',
                    'class': 'icon-info info-' + i,
                    'data-info': 'info-' + i,
                    'aria-label': "Map callout: " + popup.text
                }).inject(_this.infoWrapper);

                popup.x = popup.x * 1;
                popup.y = popup.y * 1;

                img.setStyle('top', popup.y);
                img.setStyle('left', popup.x);



                text = new Element('span', {
                    html: popup.text,
                    'tabindex': 0,
                    'class': 'popup txt hidden info-' + i,
                    'data-info': 'info-' + i,
                    'data-position': position,
                }).inject(_this.infoWrapper);

                if (popup.image) {
                    image = new Element('img', {
                        src: popup.image,
                        'tabindex': 0,
                        'class': 'popup image info-' + i,
                        'data-info': 'info-' + i,
                        'data-position': position,
                    }).inject(text);
                }
                if (popup.video) {
                    image = new Element('iframe', {
                        src: popup.video,
                        'tabindex': 0,
                        'class': 'embed popup video info-' + i,
                        'data-info': 'info-' + i,
                        'allowfullscreen': true,
                        'webkitallowfullscreen': true,
                        'mozallowfullscreen': true,
                        'data-position': position,
                    }).inject(text);
                }
                if (popup.audio) {
                    image = new Element('iframe', {
                        src: popup.audio,
                        'tabindex': 0,
                        'class': 'embed popup audio info-' + i,
                        'data-info': 'info-' + i,
                        'data-position': position,
                    }).inject(text);
                }

                if (position == 'left') {
                    text.setStyle('top', popup.y + -35);
                    text.setStyle('left', popup.x - 205);

                } else if (position == 'top') {
                    text.setStyle('top', popup.y - 140);
                    text.setStyle('left', popup.x - 78);

                }
                else {
                    text.setStyle('top', popup.y + 40);
                    text.setStyle('left', popup.x - 78);

                }

            });
            $(document.body).addEvent('click', function (e) {
                if (!$(e.target).hasClass("icon-info")) {
                    $$('body span.popup').addClass('hidden');
                }
            });

            $$('body .icon-info').addEvent('click', function (e, i) {

                if ($$('body span.' + this.getAttribute('data-info'))[0].hasClass("hidden")) {
                    $$('body span.popup').addClass('hidden');
                    $$('body span.' + this.getAttribute('data-info')).removeClass('hidden');
                    //$$('body span.' + this.getAttribute('data-info'))[0].focus();
                }
                else {

                    $$('body span.popup').addClass('hidden');
                }

            });
        }
    },


    // Receive messages from server and take actions
    customPostMessages: function (message) {
        var that = this;
        switch (message.data.method) {
            case "data-change":
                this.options.data = message.data.data;

                this.renderEdit();
                break;

            case "hotspots-change":                
                this.options.hotspots = message.data.hotspots;

                this.renderHotspotsEdit();
                break;

            case "setting-change":
                switch (message.data.setting.attribute) {
                    case "data-zoom":
                        that.options.zoom = message.data.setting.value;
                        break;
                    case "data-toggle-width":
                        that.options.toggleWidth = message.data.setting.value;
                        break;
                    case "data-toggle-horizontal-pos":
                        that.options.toggleHorizontalPos = message.data.setting.value;
                        break;
                    case "data-toggle-vertical-pos":
                        that.options.toggleVerticalPos = message.data.setting.value;
                        break;
                    case "data-timeline-start-year":
                        that.options.timelineStartYear = message.data.setting.value;
                        break;
                    case "data-timeline-end-year":
                        that.options.timelineEndYear = message.data.setting.value;
                        break;
                    case "data-width":
                        that.options.timelineWidth = message.data.setting.value;
                        break;
                    case "data-vertical-pos":
                        that.options.timelineVerticalPos = message.data.setting.value;
                        break;
                    case "data-horizontal-pos":
                        that.options.timelineHorizontalPos = message.data.setting.value;
                        break;
                    case "data-timeline-interval":
                        that.options.timelineInterval = message.data.setting.value;
                        break;
                    case "data-timeline-intervals":
                        that.options.timelineIntervals = message.data.setting.value;
                        break;
                }

                this.renderEdit();
                break;
        }
    },
    createAssessableText: function () {
        var widgetContent = $$(".MetrodigiWidget")[0];
        var hiddenLabel;
        if (this.map_type && this.map_type === "toggle") {
            hiddenLabel = new Element("div.accessibility-intructions.invisible[tabindex=1]");
        } else { 
            hiddenLabel = new Element("div.accessibility-intructions.invisible[tabindex=0]");
        }
        hiddenLabel.inject(widgetContent,'top');
    },
    setAssessableText: function (text) {
        if (!this.isEditMode) {
            var hiddenLabel = $$(".accessibility-intructions")[0];
            hiddenLabel.set('text', text);
        }
    },
});
