MapBase = new Class({
    Implements: [Options, Events],
    //Extends: MetrodigiWidget,
    options: {
        duration: 1800
    },
    mapType: 'main',
    layers: [],
    maps: {
        main: null,
        zoom: null
    },
    initialize: function (options) {
        this.setOptions(options);
        this.maps.main = this.options.container.getElement('.map.map-main');
        this.buildLayers();
    },
    buildLayers: function () {
        var that = this;
        this.options.data.each(function (layer) {
            if (typeof layer.image !== 'undefined') {
                var _class = 'layer';
                if (layer.id === 'ST') {
                    _class = 'over visible';
                } else if (layer.id === 'SB') {
                    _class = 'base visible';
                } else {
                    that.layers.push(layer);
                    that.buildItem(layer);
                }
                var html = '<img src="'+layer.image.path+'" style="display:none" />';
                html += '<div id="layer-' + layer.id + '" class="' + _class + ' layer-' + layer.id + '" style="background-image: url(' + layer.image.path + ');background-size:contain"></div>';
                $$('.widget-content .layers').appendHTML(html);
                $$('.widget-content .pan-zoom').setStyle('height', '560px');
            }
        });
    },
    buildItem: function () {
        /*
         * This is just a function specification,
         * each widget instance has to redefine this function.
         */
    },
    /*
     * Show / Hide map layers
     * @param {string} layerId
     * @param {boolean} showLayer, if true shows the layer
     */
    toggleLayer: function (layerId, showLayer) {
        var mapLayer = this.options.container.getElement(layerId);
        mapLayer.toggle(showLayer);
    },
    render: function () {
        this.options.container.set('data-map', this.mapType);
    },
    initializePanZoom: function () {
        that = this;
        this.pan_zoom = this.options.container.getElement('.pan-zoom');
        this.controls = {
            container: this.options.container.getElement('.pan-zoom-controls'),
            zoom_in: this.options.container.getElement('.pan-zoom-controls .zoom-in'),
            zoom_out: this.options.container.getElement('.pan-zoom-controls .zoom-out'),
            zoom_reset: this.options.container.getElement('.pan-zoom-controls .zoom-reset'),
        };
        this.controls.zoom_in.addEvent('click', function () {
            this.zoomIn();
        }.bind(this));
        this.controls.zoom_out.addEvent('click', function () {
            this.zoomOut();
        }.bind(this));
        this.controls.zoom_reset.addEvent('click', function () {
            this.zoomReset();
        }.bind(this));

        this.pan_zoom.setProperties({
            id: 'imagemap-wrapper-region'
        });

        if (document.widgetType !== 'interactiveMapTimeline') {
            window.addEvent('keydown', function(e){
                var wasLeftPressed = e.code == 37 || e.which == 37 || e.keyCode == 37;
                var wasRightPressed = e.code == 39 || e.which == 39 || e.keyCode == 39;
                var wasUpPressed = e.code == 38 || e.which == 38 || e.keyCode == 38;
                var wasDownPressed = e.code == 40 || e.which == 40 || e.keyCode == 40;

                if (wasLeftPressed) {
                    that.panAccessible('left');
                } else if (wasUpPressed) {
                    that.panAccessible('up');
                } else if (wasRightPressed) {
                    that.panAccessible('right');
                } else if (wasDownPressed) {
                    that.panAccessible('down');
                }
            });
        }

        this.zoom = {
            container_size: {
                x: that.pan_zoom.getDimensions().x,
                y: that.pan_zoom.getDimensions().y
            },
            current_value: {
                zoom: 100,
                scrollLeft: 0,
                scrollTop: 0
            },
            delta: 20,
            max_in: 300,
            max_out: 100
        };

        this.controls.container.show();
        this.pan_zoom.addClass('pan-zoom-active');

        this.reOrderPanButtons();
    },
    panAccessible: function(direction){
        if (!this.width_limit) this.width_limit = 1;
        var wrapper = $('imagemap-wrapper-region')
        var wrapperTop = wrapper.getBoundingClientRect().top;
        var wrapperBottom = wrapper.getBoundingClientRect().bottom;
        var wrapperLeft = wrapper.getBoundingClientRect().left;
        var wrapperRight = wrapper.getBoundingClientRect().right;

        var img = $$('.layers .layer');
        var imgTop = img[0].getBoundingClientRect().top;
        var imgBottom = img[0].getBoundingClientRect().bottom;
        var imgLeft = img[0].getBoundingClientRect().left;
        var imgRight = img[0].getBoundingClientRect().right;

        var left = img.getStyle('left') !== 'auto' ? parseInt(img.getStyle('left')) : 0;
        var top = img.getStyle('top') !== 'auto' ? parseInt(img.getStyle('top')) : 0;

        if (direction == 'down') {
            if (imgTop >= wrapperTop) top += 0
            else { top += 5 }

        }

        if (direction == 'up') {
            if (imgBottom <= wrapperBottom) top += 0
            else { top += -5 }
        }

        if (direction == 'right') {
            if (imgLeft >= wrapperLeft) left += 0
            else { left += 5 }
        }

        if (direction == 'left') {
            if (imgRight <= wrapperRight) left += 0
            else { left += -5 }

        }

        img.setStyle('top', top);
        img.setStyle('left', left);
        $$('.map.map-main').setStyle('top', top);
        $$('.map.map-main').setStyle('left', left);
    },
    resetPanAccessible: function () {
        var img = $$('.layers .layer');
        img.setStyle('top', null);
        img.setStyle('left', null);
        $$('.map.map-main').setStyle('top', null);
        $$('.map.map-main').setStyle('left', null);
    },
    drag: function () {
        new Drag.Scroll(this.pan_zoom, {
            axis: {x: true, y: true}
        });
    },
    zoomIn: function () {
        if (this.zoom.current_value.zoom >= this.zoom.max_in) {
            return false;
        }
        this.zoomTo(this.zoom.current_value.zoom + this.zoom.delta, 0.1);
    },
    zoomOut: function () {
        if (this.zoom.current_value.zoom <= this.zoom.max_out) {
            this.resetPanAccessible();
            return false;
        }
        this.zoomTo(this.zoom.current_value.zoom - this.zoom.delta, -0.1);
    },
    zoomReset: function () {
        this.zoomTo(100, 0);
    },
    zoomTo: function (value, factor) {
        this.maps.main.set('data-zoom', value);
        this.pan_zoom.scrollLeft = this.zoom.container_size.x * (this.pan_zoom.scrollLeft / this.zoom.container_size.x + factor);
        this.pan_zoom.scrollTop = this.zoom.container_size.y * (this.pan_zoom.scrollTop / this.zoom.container_size.y + factor);

        this.zoom.current_value.zoom = value;
        this.zoom.current_value.scrollLeft = this.pan_zoom.scrollLeft;
        this.zoom.current_value.scrollTop = this.pan_zoom.scrollTop;
    },
    showZoomMap: function () {
        if (this.zoom) {
            this.zoom.current_value.scrollLeft = this.pan_zoom.scrollLeft;
            this.zoom.current_value.scrollTop = this.pan_zoom.scrollTop;
            this.controls.container.hide();
        }

        this.mapType = 'zoom';
        this.maps.main.hide();
        this.maps.zoom.show();
    },
    convertToHTML: function (content) {
        var pattern, re;
        //replace html to safe text for input
        pattern = '&quot;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '"');

        pattern = '&amp;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '&');

        pattern = "&#039;";
        re = new RegExp(pattern, "g");
        content = content.replace(re, "'");

        pattern = '&lt;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '<');

        pattern = '&gt;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '>');

        return content;
    },
    fixZoomControlsPosition: function (offset) {
        var introLineEl = document.querySelector('#intro-line');
        var $zoomControls = $$('.pan-zoom-controls');

        $zoomControls.setStyle('opacity', 0);

        setTimeout(function () {
            var widgetHeaderHeight = document.querySelector('.widget-header').getBoundingClientRect().height;
            $zoomControls.setStyle('top', widgetHeaderHeight + offset);
            $zoomControls.fade('in');
        }, 0);
    },
    reOrderPanButtons: function () {
        var list = $$('.pan-zoom-controls')[0];

        var items = list.children;
        var itemsArr = [];
        for (var i in items) {
            if (items[i].nodeType == 1) { // get rid of the whitespace text nodes
                itemsArr.push(items[i]);
            }
        }

        if (!itemsArr[0].classList.contains('zoom-in')) {
            itemsArr.reverse();
        }

        for (i = 0; i < itemsArr.length; ++i) {
            list.appendChild(itemsArr[i]);
        }

        zoom = this.options.zoom;
        if (typeof this.options.zoom === 'string') {
            zoom = JSON.parse(this.options.zoom);
        }
        if (zoom !== false) {
            list.setStyle('display', '');
            list.addClass('is-visible');
        }
    }
});
