/**
 * Created by germanmontes on 30/09/14.
 */
var LineReader =  new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
        data: []
    },

    xmlType: '',
    assets:[
        '../_framework/_base_external/media-element/mediaelement.min.js',
        '../_framework/_base_external/media-element/mediaelementplayer.css',
        '../_framework/_base_metrodigi/pearson-player-wrapper.css',
        '../_framework/_base_metrodigi/pearson-player-wrapper.js'
    ],
    timeEntries:[],
    two_columns_mode: false,
    media:null,

    initialize: function(options) {
        /*
        this.xmlType = $(options.container).get('data-xml-type');

        this.zoom = $(options.container).get('data-zoom');
        this.checkbox_mode = $(options.container).get('data-checkbox') || false;
        this.scalemarker = $(options.container).get('data-scalemarker') || false;
        this.scalemarker_source = $(options.container).get('data-scalemarker-source') || false;
        this.reveal_direction = $(options.container).get('data-reveal-direction') || 'ltr';
        options.extra = ["data-checkbox","data-scalemarker","data-scalemarker-type","data-scalemarker-source","data-reveal-direction"];
         */

        this.parent(options);

        if(this.container.get("data-xml-type")!="default"){
            this.container.addClass("two-column-mode");
            this.two_columns_mode = true;
        }

        

        

        if(parent!=window){
            parent.postMessage({method:"widget-ready", edit_mode:this.isEditMode},"*");
        }
        
        if(!this.isEditMode){
            //(Elements.from("<div class=\"current-media-title\">Listen to the audio to see how best practices are incorporated.<br/><br/><\/div>")[0]).inject(this.container.getElement(".audio-wrapper"));
            if(this.options.options.audio_source!="external"){
                var nativePlayer = (Elements.from("<audio  src=\""+this.options.options.audio_path+"\">")[0]).inject(this.container.getElement(".audio-wrapper"));
                var controls = new Element('#controls').inject(this.container.getElement(".audio-wrapper"));
                initAudioPlayer(controls, nativePlayer)
            }


            else{
                if(this.options.options.audio_path.indexOf(".mp3")>0){
                    (Elements.from("<audio controls=\"control\" src=\""+this.options.options.audio_path+"\">")[0]).inject(this.container.getElement(".audio-wrapper"));   
                }
                else {
                    (Elements.from("<div class=\"pearson-audio-wrapper\" ></div>")[0]).inject(this.container.getElement(".audio-wrapper"));

                }
            }
            new Element('#highlitedLine.visually-hidden',{
                'aria-live': 'assertive'
            }).inject(this.container.getElement(".audio-wrapper"));

        }

        if(this.options.data!=null && this.options.data.length>0) {
            if(!this.isEditMode){
                
            }
            this.fetchWidgetText();
            this.fetchTimeEntries(this.options.data);
        }

        // enable medium editor on #introductory-line
        this.initMediumEditor.call(this);
    },

    fetchWidgetText:function(){
        var content_text = "";
        this.options.data.each(function(entry,i){
            content_text+="<span class='data-entry-"+i+"'>"+entry.Text + "</span> " ;
        });
        $$(".content-left").set("html",content_text);
        $$(".content-wrapper").show();
    },

    fetchTimeEntries:function(entries){
        var that = this;
        that.timeEntries = [];

        if(that.two_columns_mode && $$(".content-right ul").length==0){
            var ul_element = new Element("ul");
            ul_element.inject($$(".content-right")[0]);
        }
        else if($$(".content-right ul").length==1) {
            $$(".content-right ul li").dispose();
        }

        if(entries!=null && entries.length>0) {
            entries.each(function(entry,ind){
                var point_slipted = [];
                var time_init_array = entry.Start;
                var time_end_array = entry.Finish;
                time_init_array = time_init_array.split(":");
                point_slipted = time_init_array[1].split(".");
                time_init_array[1] = point_slipted[0];
                time_init_array[2] = point_slipted[1];
                time_end_array = time_end_array.split(":");
                point_slipted = time_end_array[1].split(".");
                time_end_array[1] = point_slipted[0];
                time_end_array[2] = point_slipted[1];

                var time_init_int =  0;
                if (time_init_array.length==4)
                    time_init_int = new Number(time_init_array[0])*60*60*1000 + new Number(time_init_array[1])*60*1000 + new Number(time_init_array[2])*1000  + new Number(time_init_array[3]);
                else if (time_init_array.length==3)
                    time_init_int = new Number(time_init_array[0])*60*1000 + new Number(time_init_array[1])*1000 + new Number(time_init_array[2]);
                else if(time_init_array.length==2)
                    time_init_int = new Number(time_init_array[0])*1000 + new Number(time_init_array[1]);
                
                var time_end_int =  0;
                if (time_end_array.length==4)
                    time_end_int = new Number(time_end_array[0])*60*60*1000 + new Number(time_end_array[1])*60*1000 + new Number(time_end_array[2])*1000  + new Number(time_end_array[3]);
                else if (time_end_array.length==3)
                    time_end_int = new Number(time_end_array[0])*60*1000 + new Number(time_end_array[1])*1000 + new Number(time_end_array[2]);
                else if(time_end_array.length==2)
                    time_end_int = new Number(time_end_array[0])*1000 + new Number(time_end_array[1]);


                if(that.timeEntries[time_init_int]==null){
                    that.timeEntries[time_init_int] = [];
                }
                
                that.timeEntries[time_init_int].push({
                    id:"entry-"+ind,
                    index: ind,
                    pattern:entry.Text,
                    init:time_init_int,
                    end:time_end_int,
                    init_point:true
                });

                if(that.timeEntries[time_end_int]==null){
                    that.timeEntries[time_end_int] = [];
                }
                
                that.timeEntries[time_end_int].push({
                    id:"entry-"+ind,
                    index: ind,
                    pattern:entry.Text,
                    init:time_init_int,
                    end:time_end_int,
                    init_point:false
                });

                if(that.two_columns_mode){
                    Elements.from("<li class='time-entry-relation time-entry-relation-id-"+"entry-"+ind+"'><div class='bullet-div'>&bull;</div><div class='time-entry-relation-text'>"+entry["Optional list text"]+"</div></li>")[0].inject($$(".content-right ul")[0]);
                }
            });
            // var is_iPad = navigator.userAgent.match(/iPad/i) != null;
            // var isSafari = navigator.userAgent.match(/Safari/i) != null;

            // if(is_iPad || isSafari){
            //
            //
            //     $$('.content-right ul .time-entry-relation-text').map(function(elem){
            //         elem.setStyle('width', 'auto')
            //     })
            // }
        }
    },

    bindEditMode:function() {

        var that = this;

        //add "add media" button
        //create elements for options
        if(this.options.options==null || this.options.options.audio_path==null) {
            (Elements.from("<div class=\"add-media-title\">Add Media<\/div>")[0]).inject(this.container.getElement(".audio-wrapper"));
            var add_media_button = (Elements.from("<div class=\"drag-indication-box drop-zone selected\"><!--Click this box or drag<br/> an image onto it to<br/>add content to this<br/>enhanced image <br/> widget.--><\/div>")[0]);
            add_media_button.inject(this.container.getElement(".audio-wrapper"));
        }
        else {

        }
        
        if($$('.drop-zone:not(.drageventbind)').length>0){

            $$('.drop-zone')[0].ondragover = function(e) {
                this.addClass('dragover');
                return false;
            };
            $$('.drop-zone')[0].ondragend = function(e) {
                $$('.drop-zone').removeClass('dragover');
                return false;
            };
            $$('.drop-zone')[0].ondragleave = function(e) {
                $$('.drop-zone').removeClass('dragover');
                return false;
            };
            $$('.drop-zone')[0].ondrop = function(e) {
                e.preventDefault();

                var extensions = ".mp3,.mp4";
                extensions = extensions.replace(/\./g, '');
                extensions = extensions.split(",");

                var flag_no_errors = false;

                Array.each(e.dataTransfer.files,function(value,key){
                    can_be_added = false
                    extensions.each(function(ext,ind){
                        if (value.name.indexOf("."+ext)>0 || value.type.indexOf("/"+ext)>0)
                            can_be_added=true
                    })

                    if (can_be_added){
                        flag_no_errors=true;
                    }

                });


                if (!flag_no_errors){
                    alert("This field doesn't accept this file type. The file types accepted are .mp3,.mp4");
                    return;
                }

                if(parent && parent!=window) {
                    parent.postMessage({method:'files-begin-upload'},"*");
                }


                var container = '[data-md-editable="md-portal-media-list"]';
                $$(container).removeClass('dragover');
                that.uploadFile(e.dataTransfer.files, container);
                return false;
            };

            $$('.drop-zone')[0].addClass("drageventbind");
        }

        //if the audio is set
        if(this.options.options!=null && this.options.options.audio_path!=null){
            //var audio_path_split = this.options.options.audio_path.split("/");
            //var audio_name = audio_path_split[audio_path_split.length-1];
            var audio_name = this.options.options.audio_name;

            if(this.options.options.audio_source!="external")
                (Elements.from("<div class='current-media-wrapper'><div class=\"current-media-title\">"+(audio_name)+":<br/><br/><\/div><audio controls=\"control\" src=\""+this.options.options.audio_path+"\"></div>")[0]).inject(this.container.getElement(".audio-wrapper"));
            else{
                if(this.options.options.audio_path.indexOf(".mp3")>0){
                    (Elements.from("<div class='current-media-wrapper'><div class=\"current-media-title\">"+(audio_name)+":<br/><br/><\/div><audio controls=\"control\" src=\""+this.options.options.audio_path+"\"></div>")[0]).inject(this.container.getElement(".audio-wrapper"));
                }
                else {
                    (Elements.from("<div class='current-media-wrapper'><div class=\"current-media-title\">"+(audio_name)+":<br/><br/><\/div><div class=\"pearson-audio-wrapper\"></div></div>")[0]).inject(this.container.getElement(".audio-wrapper"));
                    this.media = new PearsonPlayerWrapper({
                        url: this.options.options.audio_path,
                        container: $$(".pearson-audio-wrapper")[0]
                    });
                    // add event listener
                    this.media.addEvent('timeupdate', that.mediaTimeUpdate.bind(that));
                    // add event listener seeked
                    this.media.addEvent('seeked', that.mediaSeeked.bind(that));
                    this.media.addEvent("ready_to_play",function(){
                        //console.log("listo ready_to_play");
                    });
                    this.media.addEvent("metadata_readed",function(){
                        //console.log("listo metadata_readed");
                    });
                }
            }

            


            (Elements.from("<div class='current-media-replace'>replace audio</div>")[0]).inject(this.container.getElement(".audio-wrapper"));
        }

        $$('.drag-indication-box,.current-media-replace').addEvent('click', function() {
            if(parent && parent!=window) {
                parent.postMessage({method:'show-media-popup'},"*");
            }
            return false;
        });


        $$(".content-wrapper .content-left").set("placeholder","Enter text");
        $$(".content-wrapper .content-left").set("contenteditable","true");


        $$('.content-wrapper').each(function (el, i) {
          var intTimerID = null;
          el.getElement('*[contenteditable="true"]').addEvent("change", that.editorContentChange.bind(that));
          //el.getElement('*[contenteditable="true"]').addEvent("paste", that.editorContentChange.bind(that));
          el.getElement('*[contenteditable="true"]').addEvent("keyup", function (ev) {
            if (intTimerID != null) {
              clearTimeout(intTimerID);
            }
            intTimerID = setTimeout(function () {
              that.editorContentChange(ev);
            }, 500);
          });      
        });


        that.addPlayerSettings();
    },

    afterAssetsLoad:function(){
        this.addPlayerSettings();
        if($$(".pearson-audio-wrapper").length>0){
            this.media = new PearsonPlayerWrapper({
                url: this.options.options.audio_path,
                container: $$(".pearson-audio-wrapper")[0]
            });
            // add event listener
            this.media.addEvent('timeupdate', this.mediaTimeUpdate.bind(this));
            // add event listener seeked
            this.media.addEvent('seeked', this.mediaSeeked.bind(this));
            this.media.addEvent("ready_to_play",function(){
                //console.log("listo ready_to_play");
            });
            this.media.addEvent("metadata_readed",function(){
                //console.log("listo metadata_readed");
            });
        }
    },

    addPlayerSettings:function(){ 
        var that = this,
            debug = false;

        if ( $$("audio").length==0 ) return;
        
        new MediaElement($$("audio")[0], {
            // shows debug errors on screen
            //enablePluginDebug: false,
            // remove or reorder to change plugin priority
            //plugins: ['flash','silverlight'],
            // specify to force MediaElement to use a particular video or audio type
            type: '',
            // path to Flash and Silverlight plugins
            //pluginPath: '/myjsfiles/',
            // name of flash file
            //flashName: 'flashmediaelement.swf',
            // name of silverlight file
            //silverlightName: 'silverlightmediaelement.xap',
            // default if the <video width> is not specified
            //defaultVideoWidth: 480,
            // default if the <video height> is not specified     
            //defaultVideoHeight: 270,
            // overrides <video width>
            //pluginWidth: -1,
            // overrides <video height>       
            //pluginHeight: -1,
            // rate in milliseconds for Flash and Silverlight to fire the timeupdate event
            // larger number is less accurate, but less strain on plugin->JavaScript bridge
            //timerRate: 250,
            // method that fires when the Flash or Silverlight object is ready
            success: function (mediaElement, domObject) { 
                that.media = mediaElement;
                
                // add event listener
                mediaElement.addEventListener('timeupdate', that.mediaTimeUpdate.bind(that), false);
                // add event listener seeked
                mediaElement.addEventListener('seeked', that.mediaSeeked.bind(that), false);
                 
                // call the play method
                if (debug){
                    //console.log(that.timeEntries);
                    mediaElement.play();
                }
                 
            },
            // fires when a problem is detected
            error: function () { 
             
            }
        });
    },
    mediaTimeUpdate:function(e){
        var that = this,
            debug = false;
        //console.log(that.media.currentTime*1000);
        //var current_time = Math.floor(that.media.currentTime);
        var current_time = that.media.currentTime*1000;
                    
        that.checkHighLightEntries(current_time+(debug?5:0));
    },
    mediaSeeked:function(e){
        var that = this;

        if(this.timerID!=null){
            clearTimeout(this.timerID);
        }

        this.timerID = setTimeout(function(){
            that.resetEntriesState();
            that.fetchWidgetText();

        },500);
    },

    resetEntriesState:function(){
        var that = this;
        that.timeEntries.each(function(entries,ind){
            entries.each(function(entry_data,ind2){
                that.timeEntries[ind][ind2].attached = null;
            });
        });

    },

    highlight: function(search, insensitive, klass){ 
        pattern = '"'
        re = new RegExp(pattern, "g");
        //search = search.replace(re, '\\"');
        search='"';

        //console.log( '(<[^>]*>)|(\\b'+ search.escapeRegExp() +')' );

        var regex = new RegExp('(<[^>]*>)|(\\b'+ search.escapeRegExp() +')', insensitive ? 'ig' : 'g');
        return $$(".content-left")[0].set('html', $$(".content-left")[0].get('html').replace(regex, function(a, b, c){
            return (a.charAt(0) == '<') ? a : '<span class="'+ klass +'">' + c + '</span>';
        }));
    },

    checkHighLightEntries:function(time){
        var that = this;

        if(that.timeEntries != null && that.timeEntries.length>0){

            //verify if index exist
            if(that.timeEntries[time]==null){
                var time_to_use = time;
                that.timeEntries.each(function(entry,time_ind){
                    if(time>=time_ind){
                        time_to_use = time_ind;
                    }
                });
                time = time_to_use;
            }

            if(that.timeEntries[time]!=null){

                that.timeEntries[time].each(function(entry_data,ind){
                    
                    if ( entry_data.init_point ) {
                        
                        if ( that.timeEntries[time][ind].attached == null ) {
                            
                            //that.highlight(entry_data.pattern,true,"time-entry time-entry-id-"+entry_data.id);
                            that.container.getElement(".data-entry-"+that.timeEntries[time][ind].index).addClass("time-entry time-entry-id-"+entry_data.id);

                            that.timeEntries[time][ind].attached = true;

                            if(that.two_columns_mode){
                                var textContainer = $$(".time-entry-relation-id-"+entry_data.id);
                                textContainer.addClass("highlight");
                                var highlightedText = textContainer.getElement('.time-entry-relation-text')[0]
                                  .get('text')
                                $('highlitedLine').set('text', highlightedText)
                            }

                        }
                    }
                    else {
                        if ( that.timeEntries[time][ind].attached == null ) {
                            
                            $$(".time-entry-id-"+entry_data.id).addClass("time-entry-disabled");
                            that.timeEntries[time][ind].attached = true;  

                            if(that.two_columns_mode){
                                $$(".time-entry-relation-id-"+entry_data.id).removeClass("highlight");
                            }                          
                        }
                        
                    }


                });
                
            }
        }
    },

    editorContentChange: function (e) {
        //console.log(e.target.get("html"));
        
        var that = this;
        that.saveRequest({
            method:"mdHtml",
            options:{
                html:e.target.get("html"),
                selector:"."+e.target.get("class")
            }
        },function(){
            //document.location.reload();
        });
    },

    customPostMessages:function(message,path) {
        var _this = this;

        switch(message.data.method){
            case "retrieve-image-accessibility-list":
                break;
            case "data-change":
                _this.options.data = message.data.data;
                _this.fetchWidgetText();
                _this.fetchTimeEntries(_this.options.data);
                break;
            case "show-media-popup":

                var current_options = {};

                if( this.options.options!=null) {
                    current_options = this.options.options;
                }
                
                switch(message.data.data.source_type){
                    case "pearson":
                        current_options.audio_path = message.data.data.source_value;
                        current_options.audio_name = message.data.data.source_value.split("/")[message.data.data.source_value.split("/").length-1];
                        current_options.audio_source = "external";
                        break;
                    default:
                        current_options.audio_path = message.data.data.source_relative;
                        current_options.audio_name = message.data.data.source_original_name;
                        current_options.audio_source = "local";
                }

                this.saveRequest({
                    method:"mdDataByID",
                    selector:"#md-widget-data-options",
                    variable_name:"options",
                    options:{
                        json:current_options
                    }
                },function(){
                    document.location.reload();
                });
                break;
            case "view-mode-switch":
                    if(_this.media==null) return;

                    if( !message.data.edit && _this.isEditMode ){
                        _this.media.stop();
                    }

                    if( message.data.edit && !_this.isEditMode ){
                        _this.media.stop();
                    }

                break;

        }
    },


    uploadFile: function (files, containerSelector) {
        var that = this;
        var formData = new FormData();
        var multimediaType = "image";
        var multimediaTypeFormat = "";
        for (var i = 0; i < files.length; i++) {
            if (files[i].type.indexOf("video") != -1) {
                multimediaType = "video";
            }
            multimediaTypeFormat = files[i].type;
            formData.append('file', files[i]);
        }

        var pathUpload = location.href;
        if (pathUpload.indexOf("?") > 0) {
            pathUpload = pathUpload.split("?")[0];
        }

        formData.append('path', pathUpload);
        formData.append('directory', 'audio');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', this.root + 'api/index.php/upload/');
        xhr.onload = function () {

            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                var audio_path = response.relativePath;
                var audio_name = response.originalFilename;

                var current_options = {};

                if( that.options.options!=null) {
                    current_options = that.options.options;
                }

                current_options.audio_path = audio_path;
                current_options.audio_name = audio_name;

                that.saveRequest({
                    method:"mdDataByID",
                    selector:"#md-widget-data-options",
                    variable_name:"options",
                    options:{
                        json:current_options
                    }
                },function(){
                    document.location.reload();
                });
            } else {
                alert(xhr.status + ' Error uploading media. Please contact the system administrator.');
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },



    render: function() {
        var _this = this;

    }

});

//Accessible Audio player

var audio;
var player;
var playpause;
var seekBar;
var seekBack;
var seekForward;
var seekInterval = 15; //number of seconds to seek forward or back
var timer;
var currentTimeContainer;
var currentTime;
var duration;
var durationContainer;
var muteButton;
// var volumeControl; //not used
//while it's tempting to crank the volume by default,
//doing so can drown out screen readers, so it's better to keep it moderate
var volume=0.5; //0 to 1
var hasSlider;
/* //volumeControl is not currently used, so neither are these vars
 //var volumeIsVisible = false;
 //var volumeHasFocus = false;
 //var muteHasFocus = false;
 */
function initAudioPlayer(controls, nativePlayer) {
    //add controls to #controls div using Javascript
    //but only for browsers that support <audio>
    player = controls
    audio = nativePlayer
    if (audio.canPlayType) { //this browser suports HTML5 audio

        audio.setAttribute('ontimeupdate','updateSeekBar()');
        //audio.setAttribute('onvolumechange','updateVolumeControl()'); //not used

        playpause = document.createElement('input');
        playpause.setAttribute('class', 'audioInput')
        playpause.setAttribute('type','button');
        playpause.setAttribute('id','playpause');
        playpause.setAttribute('value','');
        playpause.setAttribute('title','Play');
        playpause.setAttribute('onclick','playAudio()');
        player.appendChild(playpause);

        seekBar = document.createElement('input');
        seekBar.setAttribute('class', 'audioInput')
        seekBar.setAttribute('type','range');
        seekBar.setAttribute('id','seekBar');
        seekBar.setAttribute('value','0'); //???
        seekBar.setAttribute('step','any');
        seekBar.setAttribute('ondurationchange','setupSeekBar()');
        seekBar.setAttribute('onchange','seekAudio(this)');
        player.appendChild(seekBar);

        if (seekBar.type !== 'text') {
            //if browser doesn't support type="range" (i.e., Firefox), it will render as type="text"
            hasSlider = true;
        }
        else {
            //input type="text" is ugly and not very usable on the controller bar. Remove it.
            player.removeChild(seekBar); //seekBar.style.display='none';
        }
        //Now add rewind and fast forward buttons
        //These will be hidden from users who have sliders, but visible to users who don't
        //We still want them, even if hidden, so users can benefit from their accesskeys
        seekBack = document.createElement('input');
        seekBack.setAttribute('class', 'audioInput')
        seekBack.setAttribute('type','button');
        seekBack.setAttribute('id','seekBack');
        seekBack.setAttribute('value','');
        seekBack.setAttribute('title','Rewind ' + seekInterval + ' seconds');
        seekBack.setAttribute('onclick','seekAudio(this)');
        player.appendChild(seekBack);
        seekForward = document.createElement('input');
        seekForward.setAttribute('class', 'audioInput')
        seekForward.setAttribute('type','button');
        seekForward.setAttribute('id','seekForward');
        seekForward.setAttribute('value','');
        seekForward.setAttribute('title','Forward ' + seekInterval + ' seconds');
        seekForward.setAttribute('onclick','seekAudio(this)');
        player.appendChild(seekForward);
        if (hasSlider == true) {
            //Note: all major browsers support accesskey on elements hidden with visibility:hidden
            seekBack.style.visibility='hidden';
            seekForward.style.visibility='hidden';
        }
        timer = document.createElement('span');
        timer.setAttribute('id','timer');
        currentTimeContainer = document.createElement('span');
        currentTimeContainer.setAttribute('id','currentTime');
        var startTime = document.createTextNode('0:00');
        currentTimeContainer.appendChild(startTime);

        durationContainer = document.createElement('span');
        durationContainer.setAttribute('id','duration');
        timer.appendChild(currentTimeContainer);
        timer.appendChild(durationContainer);
        player.appendChild(timer);

        muteButton = document.createElement('input');
        muteButton.setAttribute('class', 'audioInput')
        muteButton.setAttribute('type','button');
        muteButton.setAttribute('id','muteButton');
        muteButton.setAttribute('value','');
        muteButton.setAttribute('title','Mute');
        muteButton.setAttribute('onclick','toggleMute()');
        //muteButton.setAttribute('onmouseover','showVolume()'); //not used
        //muteButton.setAttribute('onfocus','showVolume()'); //not used
        //muteButton.setAttribute('onmouseout','hideVolume()'); //not used
        //muteButton.setAttribute('onblur','hideVolume()'); //not used
        player.appendChild(muteButton);

        /*
         //This is here for future reference.
         //Since vertical sliders are not well-rendered by browsers yet
         //we'll replace that for now with volume up and down buttons
         //all volumeControl code is preserved though for possible future use
         volumeControl = document.createElement('input');
         volumeControl.setAttribute('type','range');
         volumeControl.setAttribute('id','volumeControl');
         volumeControl.setAttribute('max','1');
         volumeControl.setAttribute('width','30');
         volumeControl.setAttribute('height','100');
         volumeControl.setAttribute('step','any');
         volumeControl.setAttribute('onchange','updateVolume()');
         volumeControl.setAttribute('onmouseover','setVolumeFocus()');
         volumeControl.setAttribute('onfocus','setVolumeFocus()');
         volumeControl.setAttribute('onmouseout','unsetVolumeFocus()');
         volumeControl.setAttribute('onblur','unsetVolumeFocus()');
         volumeControl.setAttribute('tabindex','0');
         volumeControl.setAttribute('aria-labelledby','volumeLabel');
         */

        volumeUp = document.createElement('input');
        volumeUp.setAttribute('class', 'audioInput')
        volumeUp.setAttribute('type','button');
        volumeUp.setAttribute('id','volumeUp');
        volumeUp.setAttribute('value','');
        volumeUp.setAttribute('title','Volume Up');
        volumeUp.setAttribute('onclick',"updateVolume('up')");
        player.appendChild(volumeUp);

        volumeDown = document.createElement('input');
        volumeDown.setAttribute('class', 'audioInput')
        volumeDown.setAttribute('type','button');
        volumeDown.setAttribute('id','volumeDown');
        volumeDown.setAttribute('value','');
        volumeDown.setAttribute('title','Volume Down');
        volumeDown.setAttribute('onclick',"updateVolume('down')");
        player.appendChild(volumeDown);

        //get and set default values
        audio.volume = volume;
        //updateVolumeControl(volume); //not used

        //audio.duration returns a very very precice decimal value
        //this is exposed by MSAA and read by NVDA, and impairs accessibility
        //Plus, it isn't necessary for our purposes
        duration = Math.floor(audio.duration);
        //Chrome and Safari return NaN for duration until audio.loadedmetadata is true.
        //Other browsers are able to get duration with 100% reliability in my tests,
        //AND (interestingly) only Chrome and Safari support audio.loadedmetadata
        //So, have to assign duration both inside and outside of the following event listener
        if (isNaN(duration)) {
            audio.addEventListener('loadedmetadata',function (e) {
                duration = audio.duration;
                showTime(duration,durationContainer,hasSlider);
                seekBar.setAttribute('min',0);
                seekBar.setAttribute('max',duration);
            },false);
        }
        else {
            showTime(duration,durationContainer,hasSlider);
            seekBar.setAttribute('min',0);
            seekBar.setAttribute('max',duration);
        }
    }
    else {
        player.style.display='none';
    }
}
function showTime(time,elem,hasSlider) {
    var minutes = Math.floor(time/60);
    var seconds = Math.floor(time % 60);
    if (seconds < 10) seconds = '0' + seconds;
    var output = minutes + ':' + seconds;
    if (elem == currentTimeContainer) elem.innerHTML = output;
    else elem.innerHTML = ' / ' + output;
}
function playAudio() {
    if (audio.paused || audio.ended) {
        audio.play();
        playpause.setAttribute('title','Pause');
        playpause.style.backgroundImage="url('images/audio_pause.gif')";
    }
    else {
        audio.pause();
        playpause.setAttribute('title','Play');
        playpause.style.backgroundImage="url('images/audio_play.gif')";
    }
}
function setupSeekBar() {
    seekBar.max = video.duration;
}
function seekAudio(element) {
    //element is either seekBar, seekForward, or seekBack
    if (element == seekBar) {
        var targetTime = element.value;
        if (targetTime < duration) audio.currentTime = targetTime;
    }
    else if (element == seekForward) {
        var targetTime = audio.currentTime + seekInterval;
        if (targetTime < duration) audio.currentTime = targetTime;
        else audio.currentTime = duration;
    }
    else if (element == seekBack) {
        var targetTime = audio.currentTime - seekInterval;
        if (targetTime > 0) audio.currentTime = targetTime;
        else audio.currentTime = 0;
    }
}
function updateSeekBar() {
    //if browser displays input[type=range] as a slider, increment it
    if (seekBar.type !== 'text') {
        seekBar.value = audio.currentTime;
    }
    //also increment counter
    showTime(audio.currentTime,currentTimeContainer,hasSlider);
}
function toggleMute() {
    if (audio.muted) {
        audio.muted = false; //unmute the volume
        muteButton.setAttribute('title','Mute');
        audio.volume = volume;
        //volumeControl.value = volume; //not used
        muteButton.style.backgroundImage="url('images/audio_volume.gif')";
    }
    else {
        audio.muted = true; //mute the volume
        muteButton.setAttribute('title','UnMute');
        //don't update var volume. Keep it at previous level
        //so we can return to it on unmute
        muteButton.style.backgroundImage="url('images/audio_mute.gif')";
    }
}
function showVolume() {
    //not used...
    //triggered when #muteButton or #volumeControl receives focus
    volumeControl.style.display="block";
    volumeIsVisible = true;
    muteHasFocus = true;
    //volume doesn't have focus yet, but we'll say it does
    //this will keep it visible so user can tab to it if needed
    //If it's hidden when mute button loses focus, there's nothing for user to tab to
    volumeHasFocus = true;
}
function hideVolume() {
    //not used...
    //triggered when #muteButton or #volumeControl loses focus
    muteHasFocus = false;
    if (volumeHasFocus == false && muteHasFocus == false) {
        volumeControl.style.display="none";
        volumeIsVisible = false;
    }
}
function setVolumeFocus() {
    //not used...
    //user has moused over or tabbed to volumeControl
    volumeHasFocus = true;
    if (!volumeIsVisible) {
        showVolume();
    }
}
function unsetVolumeFocus() {
    //not used...
    //user has moused or tabbed away from volumeControl
    volumeHasFocus = false;
    hideVolume();
}
function updateVolume(direction) {
    //volume is a range between 0 and 1
    if (direction == 'up') {
        if (volume < 0.9) volume = (volume + 0.1);
        else volume = 1;
    }
    else { //direction is down
        if (volume > 0.1) volume = (volume - 0.1);
        else volume = 0;
    }
    audio.volume = volume;
    /*
     //volumeControl not used
     audio.volume = volumeControl.value;
     volume = volumeControl.value;
     */
}
function updateVolumeControl() {
    //not used...
    volumeControl.value = audio.volume;
}
