/*

 IDPF ePub Widget Framework
 MIT License
 Demos: http://widgets.chaucercloud.com

 */
var edit_mode = false;
var viewport_width = 500;
function calculateHeightElement(el) {

    if (el && el.getElement("img") != null) {
        if (el.getElement(".caption-text") == null)
            return;
        var captionclone = el.getElement(".caption-text").clone(true, true);
        captionclone.addClass("content-measure")
        captionclone.setStyles({
            position: "absolute",
            width: viewport_width + "px"
        });

        captionclone.inject($$("body")[0]);

        var size = $$(".content-measure")[0].getSize();
        $$(".content-measure").dispose();

        var image_height = el.getSize().y - size.y - 10;

        var current_image_size = el.getElement("img").getSize();
        if (current_image_size.x == 0 && current_image_size.y == 0) {
            Asset.image(el.getElement("img").get("src"), {
                onLoad: function () {
                    current_image_size = this.getSize();
                    if (current_image_size.x < current_image_size.y) {
                        el.getElement("img").setStyle("height", image_height);
                    }
                }
            })
        }
        else {
            if (current_image_size.x < current_image_size.y) {
                el.getElement("img").setStyle("height", image_height);
            }
        }
    }
}

(function () {


    var Loop = new Class({
        loopCount: 0,
        isLooping: false,
        loopMethod: function () {
        },
        setLoop: function (fn, delay) {
            wasLooping = this.isLooping;
            if (wasLooping)
                this.stopLoop();
            this.loopMethod = fn;
            this.loopDelay = delay || 3000;
            if (wasLooping)
                this.startLoop();
            return this;
        },
        stopLoop: function () {
            this.isLooping = false;
            clearInterval(this.periodical);
            return this;
        },
        startLoop: function (delay, now) {
            if (!this.isLooping) {
                this.isLooping = true;
                if (now)
                    this.looper();
                this.periodical = this.looper.periodical(delay || this.loopDelay, this);
            }
            ;
            return this;
        },
        resetLoop: function () {
            this.loopCount = 0;
            return this;
        },
        looper: function () {
            this.loopCount++;
            this.loopMethod(this.loopCount);
            return this;
        }

    });

    var Gallery = this.Gallery = new Class({
        Implements: [Options, Events, Loop],
        options: {
            delay: 0,
            transition: 'crossFade',
            duration: 0,
            autoplay: false,
            dataAttribute: 'data-gallery',
            selector: '> *',
            initialSlideIndex: 0
        },
        transitioning: false,
        reversed: false,
        initialize: function (element, options, noSetup) {
            this.element = document.id(element);
            this.setOptions(options);
            if (!noSetup)
                this.setup();
        },
        overlapTopLayer: function( slide ){
            $$('.top-layer-iframe').hide();
            $$('.top-layer-iframe').removeClass('active');
            $('top-layer-'+slide.get('id') ).show();
            $('top-layer-'+slide.get('id') ).addClass('active');
            var iframeWrapper = slide.getElement('.iframe-wrapper'),
                position = iframeWrapper.getPosition(),
                width = iframeWrapper.getWidth(),
                height = iframeWrapper.getHeight()
            ;
            $('top-layer-'+slide.get('id') ).setStyles({
                top: position.y,
                left: position.x,
                width: width,
                height: height
            });
        },
        setupIframe: function(container){

            //container.empty();
            $$('.top-layer-iframe').forEach(function(c){
                c.getElement('.iframe-wrapper').empty();
            });
            if(container.get("data-src").indexOf('youtube.com') > 0){
                container.adopt(new Element("iframe.youtube", {
                    src: container.get("data-src")
                }));
            }else{
                container.adopt(new Element("iframe", {
                    src: container.get("data-src")
                }));
            }
        },
        setup: function (options) {
            if (options)
                this.setOptions(options);
            this.slides = this.element.getElements(this.options.selector);
            this.setupElement().setupSlides();
            this.current = this.current || this.slides[this.options.initialSlideIndex];
            if (this.current) {
                this.index = this.current.retrieve('gallery-index');
                calculateHeightElement(this.current);
                this.current.addClass("current");
                if (this.current.getElement(".iframe-wrapper:not(.iframe-wrapper-placeholder)") != null) {
                    this.setupIframe( this.current.getElement(".iframe-wrapper") );
                } else if (this.current.getElement(".iframe-wrapper.iframe-wrapper-placeholder") != null) {
                    this.setupIframe( $('top-layer-'+this.current.get('id')).getElement(".iframe-wrapper") );
                    this.overlapTopLayer( this.current );
                }
            }
            this.setLoop(this.show.pass(this.reversed ? 'previous' : 'next', this), this.options.delay);
            if (this.options.autoplay)
                this.play();
            return this;
        },
        show: function (slide, options) {
            if (slide === 'next' || slide === 'previous') {
                slide = this[slide + 'Slide']();
            }

            if (typeof slide === 'number') {
                slide = this.slides[slide];
            }

            if (slide == this.current || this.transitioning) {
                return this;
            }

            var _this = this;

            this.transitioning = true;
            this.current.store('gallery:oldStyles', this.current.get('style'));


            if (!(options && options.transition) && slide == null)
                return;

            var transition = (options && options.transition) ? options.transition : slide.retrieve('gallery-transition'),
                    duration = (options && options.duration) ? options.duration : slide.retrieve('gallery-duration'),
                    previous = this.current.setStyle('z-index', 1),
                    next = this.reset(slide).setStyle('z-index', 0),
                    nextIndex = this.index = next.retrieve('gallery-index')
            slideData = {
                previous: {element: previous, index: previous.retrieve('gallery-index')},
                next: {element: next, index: nextIndex}
            };

            previous.removeClass('current');

            this.fireEvent('show', slideData);

            Gallery.transitions[transition]({
                previous: previous,
                next: next,
                duration: duration,
                instance: this
            });

            if (previous.getElement(".iframe-wrapper") != null) {
                previous.getElement(".iframe-wrapper").empty();
            }

            if (next.getElement(".iframe-wrapper:not(.iframe-wrapper-placeholder)") != null) {
                this.setupIframe( next.getElement(".iframe-wrapper") );
            } else if (next.getElement(".iframe-wrapper.iframe-wrapper-placeholder") != null) {
                this.setupIframe( $('top-layer-'+next.get('id')).getElement(".iframe-wrapper") );
                this.overlapTopLayer( next );
            }

            (function () {
                this.fireEvent('showComplete', slideData);
                this.transitioning = false;
                previous.removeClass("current");
                calculateHeightElement(next);
                next.addClass("current");

                image = next.getElement('img');
                image.setAttribute('tabindex', 0)
                image.focus()

            }).bind(this).delay(duration);

            this.current = next;
            return this;
        },
        play: function () {
            this.startLoop();
            this.fireEvent('play');
            return this;
        },
        pause: function () {
            this.stopLoop();
            this.fireEvent('pause');
            return this;
        },
        reverse: function () {
            this.setLoop(this.show.pass(this.reversed ? 'next' : 'previous', this), this.options.delay);
            this.reversed = !this.reversed;
            this.fireEvent('reverse');
            return this;
        },
        setupElement: function () {
            this.storeData(this.element);
            this.options.duration = this.element.retrieve('gallery-duration');
            this.options.transition = this.element.retrieve('gallery-transition');
            this.options.delay = this.element.retrieve('gallery-delay');
            if (this.element.getStyle('position') == 'static')
                this.element.setStyle('position', 'relative');
            return this;
        },
        setupSlides: function () {
            this.slides.each(function (slide, index) {
                slide.store('gallery-index', index).store('gallery:oldStyles', slide.get('style'));
                this.storeData(slide);
            }, this);
            return this;
        },
        storeData: function (element) {
            var ops = this.options;
            // default options
            element.store('gallery-transition', ops.transition);
            element.store('gallery-duration', ops.duration);
            if (element == this.element)
                element.store('gallery-delay', ops.delay);
            // override from data attribute
            var data = element.get(this.options.dataAttribute);
            if (!data)
                return this;
            Slick.parse(data).expressions[0].each(function (option) {
                element.store('gallery-' + option.tag, option.pseudos[0].key);
            });
            return this;
        },
        reset: function (slide) {
            return slide.set('style', slide.retrieve('gallery:oldStyles'));
        },
        nextSlide: function () {
            return this.slides[this.index + 1] || this.slides[0];
        },
        previousSlide: function () {
            return this.slides[this.index - 1] || this.slides.getLast();
        },
        toElement: function () {
            return this.element;
        }

    });

    Gallery.transitions = {};

    Gallery.defineTransition = function (name, fn) {
        Gallery.transitions[name] = fn;
    };

    Gallery.defineTransitions = function (transitions) {
        Object.each(transitions, function (item, index) {
            Gallery.defineTransition(index, item);
        });
    };

})();

// element extensions
Element.Properties.gallery = {
    set: function (options) {
        this.get('gallery').setup(options);
        return this;
    },
    get: function () {
        var instance = this.retrieve('gallery');
        if (!instance) {
            instance = new Gallery(this, {}, true);
            this.store('gallery', instance);
        }
        return instance;
    }

};

Element.implement({
    playGallery: function (options) {
        this.get('gallery').setup(options).play();
        return this;
    },
    pauseGallery: function () {
        this.get('gallery').pause();
        return this;
    }

});

// 19 transitions :D
Gallery.defineTransitions({
    none: function (data) {
        data.previous.setStyle('display', 'none');
        return this;
    },
    fade: function (data) {
        data.previous.set('tween', {duration: data.duration}).fade('out');
        return this;
    },
    crossFade: function (data) {
        data.previous.set('tween', {duration: data.duration}).fade('out');
        data.next.set('tween', {duration: data.duration}).fade('in');
        return this;
    },
    fadeThroughBackground: function (data) {
        var half = data.duration / 2;
        data.next.set('tween', {duration: half}).fade('hide');
        data.previous.set('tween', {
            duration: half,
            onComplete: function () {
                data.next.fade('in');
            }
        }).fade('out');
        return this;
    }

});

(function () {

    function getStyles(direction) {
        return {
            property: (direction == 'left' || direction == 'right') ? 'left' : 'top',
            inverted: (direction == 'left' || direction == 'up') ? 1 : -1
        };
    }

    function go(type, styles, data) {
        var tweenOptions = {duration: data.duration, unit: '%'};
        if (type == 'blind') {
            data.next.setStyle('z-index', 2);
        }
        if (type != 'slide') {
            data.next
                    .set('tween', tweenOptions)
                    .setStyle(styles.property, 100 * styles.inverted + '%');
            data.next.tween(styles.property, 0);
        }
        if (type != 'blind') {
            data.previous
                    .set('tween', tweenOptions)
                    .tween(styles.property, -(100 * styles.inverted));
        }
    }

    ['left', 'right', 'up', 'down'].each(function (direction) {

        var capitalized = direction.capitalize(),
                blindName = 'blind' + capitalized,
                slideName = 'slide' + capitalized;

        [
            ['push' + capitalized, (function () {
                    var styles = getStyles(direction);
                    return function (data) {
                        go('push', styles, data);
                    }
                }())],
            [blindName, (function () {
                    var styles = getStyles(direction);
                    return function (data) {
                        go('blind', styles, data);
                    }
                }())],
            [slideName, (function () {
                    var styles = getStyles(direction);
                    return function (data) {
                        go('slide', styles, data);
                    }
                }())],
            [blindName + 'Fade', function (data) {
                    this.fade(data)[blindName](data);
                    return this;
                }]
        ].each(function (transition) {
            Gallery.defineTransition(transition[0], transition[1]);
        });
    });

})();

var epubWidget = epubWidget || {};
epubWidget.AbstractWidget = new Class({
    Implements: [Events, Options],
    initialize: function (widgetName, el, options) {
        this.name = widgetName;
        this.el = el;
        $(this).addClass('epubWidget-widget');
        $(this).addClass('epubWidget-' + widgetName);
        this.setOptions(options);
    },
    toElement: function () {
        return this.el;
    }
});

var epubWidget = epubWidget || {};
epubWidget.Gallery = new Class({
    Extends: epubWidget.AbstractWidget,

    //DEFAULT OPTIONS
    options: {
        images: null,
        thumbnails: false,
        size: null,
        clickToNext: false
    },
    initialize: function (el, slideShowInfo, sliderInfo, options) {
        var _this = this;
        this.parent("gallery", $(el), options);
        this.options.images = [];

        for (var i = 0; i < $$('[data-md-editable="md-portal-media-list-item"] img').length; i++) {
            var type = $$('[data-md-editable="md-portal-media-list-item"] img')[i].getAttribute('type') || "image";
            var caption = $$('[data-md-editable="md-portal-media-list-item"]')[i].getAttribute('data-md-caption') || "";
            var filepath = $$('[data-md-editable="md-portal-media-list-item"] img')[i].getAttribute('filepath') || $$('[data-md-editable="md-portal-media-list-item"] img')[i].get('src');
            var src = $$('[data-md-editable="md-portal-media-list-item"] img')[i].get('src');
            var id = $$('[data-md-editable="md-portal-media-list-item"]')[i].getAttribute('data-md-id');
            var text_view = $$('[data-md-editable="md-portal-media-list-item"]')[i].get('data-text-view');
            var format = $$('[data-md-editable="md-portal-media-list-item"]')[i].get('data-md-multimediatype-format');

            switch (type) {
                case "iframe":
                    src = filepath;
                    break;
            }
            this.options.images.push({
                src: src,
                type: type,
                caption: caption,
                id: id,
                text_view: text_view,
                format: format
            });
        }
        ;


        if (this.options.images) {

            $$('.MetrodigiWidget.container').appendHTML(
                    [
                        '<div class="fullscreen">',
                        '<div class="rt-wrapper">',
                        '</div>',
                        '<div class="pan-zoom">',
                        '<div class="map map-main" data-map="main" data-zoom="100"><div class="maps layers">',
                        '<div class="layer" style="background-image: url(http://localhost/Pearson/pearson-books/practice-books/526/OPS/components/metrodigi/ch01-interactive_map-02/images/1425670517404615958.jpeg);"></div></div>',
                        '</div>',
                        '</div>',
                        '<div class="nav">',
                        '<div class="pan-zoom-controls">',
                        '<button class="zoom-in" tabindex="0" aria-label="Zoom in">+</button>',
                        '<button class="zoom-out" tabindex="0" aria-label="Zoom out">-</button>',
                        '<button class="zoom-reset" tabindex="0" aria-label="Reset">Reset</button>',
                        '</div>',
                        '<button class="close" aria-label="Close the expanded image" tabindex="0">&times;</button>',
                        '</div>',
                        '</div>',
                    ].join(' '), 'top');

            var self = this;
            $$('.MetrodigiWidget.container .fullscreen .close')
                    .addEvent('click', function (e) {
                        e.preventDefault();

                        // Delete #expand iframe
                        $$('#expand').destroy();

                        $$('.fullscreen').hide();
                        self.zoomReset();

                        expandButton = $$('div.slide-wrapper.current').getElement('div.expand');
                        expandButton = expandButton[0];
                        expandButton.focus();

                        //enable thumbnails
                        $$('div.widget-content')[0].show();

                        $$('div.thumbnail.selected')[0].focus();
                        if($$('.top-layer-iframe.active').length > 0)
                            self.resetOverlapTopLayer($$('.top-layer-iframe.active')[0]);
                    });



            var mainImageOuter = new Element('div', {'class': 'main-image-outer'});
            slideShowInfo.el = new Element('div', {'class': 'main-image-inner'});

            mainImageOuter.adopt(slideShowInfo.el);

            this.el.empty();

            var panelCount = this.options.images.length;
            window.theta = 360 / panelCount;

            window.radius = 1;//Math.round( ( parseInt(500) / 2) / Math.tan( Math.PI / panelCount ) );
            var angle = 0;
            var caption = new Element('div.caption');

            this.options.images.each(function (img, i) {
                var wrapperEl = new Element('div', {'class': 'slide-wrapper wraptocenter'});
                wrapperEl.setAttribute('data-id', img.id);
                wrapperEl.setAttribute('id', img.id);

                // View Text
                new Element('div.text_view_content', {html: img.text_view}).inject(wrapperEl);

                var slideWrapperHeight = this.options.thumbnails ? this.options.size.height - 90 : this.options.size.height;
                if (this.options.size) {
                    wrapperEl.setStyles({
                        width: this.options.size.width - 100 + "px",
                        height: slideWrapperHeight + "px"
                    });
                }

                var mediatype = img.type;
                var format = img.format;
                var expandFunction = function (e) {
                    e.preventDefault();

                    $$('.MetrodigiWidget.container .fullscreen').set('class', 'fullscreen');
                    $$('.MetrodigiWidget.container .fullscreen').addClass("md-media-element-type-" + mediatype).show();
                    if (this.hasClass('text_active')) {
                        $$('.MetrodigiWidget.container .fullscreen .rt-wrapper').show();
                        $$('.MetrodigiWidget.container .fullscreen .pan-zoom.pan-zoom-active').hide();
                        $$('.MetrodigiWidget.container .pan-zoom-controls').hide();
                        $$('.MetrodigiWidget.container .fullscreen .rt-wrapper').set('html', img.text_view);
                    } else {
                        $$('.MetrodigiWidget.container .fullscreen .rt-wrapper').hide();
                        $$('.MetrodigiWidget.container .fullscreen .pan-zoom.pan-zoom-active').show();
                        $$('.MetrodigiWidget.container .pan-zoom-controls').show();
                        $$('.MetrodigiWidget.container .fullscreen .rt-wrapper').set('html', img.caption);
                    }

                    if (mediatype === 'document') {
                        $$('.MetrodigiWidget.container .fullscreen .rt-wrapper').show();
                        $$('.MetrodigiWidget.container .pan-zoom-controls').hide();
                        $$('.MetrodigiWidget.container .fullscreen .pan-zoom.pan-zoom-active').hide();
                    }

                    var iframe_container = new Element('div.iframe-container');
                    $$('.MetrodigiWidget.container .fullscreen').adopt(iframe_container);

                    if (mediatype === 'iframe') {
                        $$('.pan-zoom .map .layer').set('style', 'background-image: none');
                        //iframe_container.set('html', '<iframe src="' + img.src + '"></iframe>');
                        if($$('.top-layer-iframe.active').length > 0)
                            _this.expandOverlapTopLayer($$('.top-layer-iframe.active')[0]);
                    }
                    else {
                        $$('.pan-zoom .map .layer').set('style', 'background-image: url(' + img.src + '); background-position:50% 40%;');
                    }
                    // $$('.MetrodigiWidget.container .pan-zoom img').set('src',img.src);


                    //disable thumbnails
                    $$('div.widget-content')[0].hide();

                    //set focus to zoom in
                    zoomIn = $$('button.zoom-in')[0];

                    $(zoomIn).focus();
                };

                var wrapper_main_content = new Element('div.wrapper_main_content');
                var imgEl = null;
                switch (mediatype) {
                    case "image":
                    case "video":
                        imgEl = new Element('img', {src: img.src, exif: false});
                        wrapperEl.adopt(new Element('span'));
                        break;
                    case "iframe":
                        //imgEl = new Element('div.iframe-wrapper'+(format?'.'+format:''), {"data-src": img.src, exif: false});
                        imgEl = new Element('div.iframe-wrapper.iframe-wrapper-placeholder'+(format?'.'+format:''), {"data-src": img.src, exif: false});
                        if(!$('iframes-top-layer-container')){
                            new Element('div#iframes-top-layer-container').inject($$('.MetrodigiWidget')[0], "top");
                        }
                        $('iframes-top-layer-container').adopt(
                            (new Element('div.top-layer-iframe#top-layer-'+img.id)).adopt( new Element('div.iframe-wrapper'+(format?'.'+format:''), {"data-src": img.src, exif: false}) )
                        )
                        break;
                    case "document":
                        imgEl = new Element('div.rt-wrapper', {
                            html: img.caption,
                            contenteditable: 'true'
                        });
                        break;
                }
                if(imgEl){
                    imgEl.setAttribute('data-pos', i);
                    wrapper_main_content.adopt(imgEl);
                }

                wrapperEl.adopt(wrapper_main_content);
                slideShowInfo.el.adopt(wrapperEl);

                var expand = new Element('div.expand', {html: '<i class="fa fa-expand asd fa-2x"></i>'}).inject(wrapperEl);

                if (edit_mode) {
                    var textarea_wapper_1 = new Element("div.md-editable-box-wrapper.md-editable-box-wrapper-1.md-media-element-type-" + mediatype, {
                    });
                    var textarea_wapper_2 = new Element("div.md-editable-box-wrapper.md-editable-box-wrapper-2", {
                    });
                    var border = new Element("div.border", {
                    });
                    var caption_textarea = new Element("div.data-md-editable.image-content-text.md-track-changes.caption-editor.editable-element-panel", {
                        contenteditable: 'true',
                        'data-md-editable': "md-content-editable-element",
                        'data-md-field-type': 'media-gallery-caption'
                    });
                    var credit_textarea = new Element("div.data-md-editable.image-content-text.md-track-changes.credit-editor.editable-element-panel", {
                        contenteditable: 'true',
                        'data-md-editable': "md-content-editable-element",
                        'data-md-field-type': 'media-gallery-caption'
                    });

                    border.adopt(caption_textarea);
                    border.adopt(credit_textarea);
                    var that = this;

                    caption_textarea.addEvent("blur", function () {
                        $$(".thumbnail[data-md-id='"+this.getAttribute('data-md-field-id')+"']")[0].set("data-md-caption",this.get('html'))
                    });
                    credit_textarea.addEvent("blur", function () {
                        $$(".thumbnail[data-md-id='"+this.getAttribute('data-md-field-id')+"']")[0].set("data-md-credit",this.get('html'))
                    });

                    textarea_wapper_1.adopt(textarea_wapper_2);
                    textarea_wapper_2.adopt(border);
                    caption.adopt(textarea_wapper_1);

                    if (img.type !== 'document') {
                        var text_add = ' + Add <br />text view<br />(optional)';
                        if (img.text_view !== '' && img.text_view !== null) {
                            text_add = 'Edit <br />text view';
                        }
                        var text_view = new Element('div.text_view', {html: text_add}).inject(wrapperEl);
                        text_view.addEvent('click', function () {
                            var id = this.getParent().get('data-md-id') || this.getParent().get('data-id');
                            var text = "";
                            if(typeof $$("[data-md-id='"+id+"']")[0] != "undefined"){
                                text = $$("[data-md-id='"+id+"']")[0].get('data-text-view');
                            }
                            parent.postMessage({method: 'text-view', id: id, text: text}, "*");
                        });
                    }

                }
                else {
                    var wrapperTexts = new Element("div.texts.md-media-element-type-" + mediatype, {});
                    var textarea = new Element("p.caption-text", {});
                    var credit = new Element("p.credit", {});
                    wrapperTexts.adopt(textarea);
                    wrapperTexts.adopt(credit);
                    caption.adopt(wrapperTexts);
                    // Expanding function event
                    wrapperEl.getElement('.wrapper_main_content').addEvent('click', expandFunction);

                    expand.addEvent('click', expandFunction);

                    // View text buttons
                    if (img.type !== 'document' && img.text_view !== null && img.text_view !== '') {
                        var button_img = new Element('div', {html: '<i class="fa fa-file-image-o fa-2x"></i>', class: 'button_img active'}).inject(wrapperEl);
                        var button_text = new Element('div.button_text', {html: '<i class="fa fa-file-text-o fa-2x"></i>'}).inject(wrapperEl);

                        button_img.addEvent('click', function () {
                            this.getParent().removeClass('text');
                            button_text.removeClass('active');
                            this.addClass('active');
                            this.getParent().getElement('.expand').removeClass('text_active');
                        });

                        button_text.addEvent('click', function () {
                            this.getParent().addClass('text');
                            button_img.removeClass('active');
                            this.addClass('active');
                            this.getParent().getElement('.expand').addClass('text_active');
                        });
                    }
                }

            }.bind(this));
            this.el.grab(mainImageOuter, 'top');
            this.el.grab(caption, 'bottom');
            this.calculateAngles();

        }
        if (this.options.size) {
            this.el.setStyles({
                width: this.options.size.width + "px",
                height: this.options.size.height + "px"
            });
        }

        if (this.options.thumbnails) {
            this.appendThumbnails(slideShowInfo.el);
            //this.el.getElements('.main-image-outer').setStyle('height', this.el.getHeight() - 190);
        }

        this.gallery = new Gallery(slideShowInfo.el, slideShowInfo.options);

        var that = this;
        var Hammer = window.Hammer || undefined;
        if (!!Hammer && !$$('.md-edit-mode')[0]) {

            Hammer(
                    $$('.main-image-inner')[0]
                    ).on("swipe", function (e) {
                if ($$('.container').get('data-3d-mode')[0] === 'true' && $$('body.md-edit-mode').length === 0) {
                    that.selectChangeSlide();
                }

                e.preventDefault();
                e.stopPropagation();
            })
        }

        if (sliderInfo) {
            this.slider = new Slider(sliderInfo.el, sliderInfo.knob, sliderInfo.options);
            this.slider.addEvent('change', function (pos) {
                this.current = pos;
                if (this.gallery.slides.length <= pos) {
                    return;
                }

                this.gallery.show(pos);
            }.bind(this));
        }

        this.initializePanZoom();

        var initialElement = that.parseAndCheckUrl();
        if(initialElement != -1) {
            // load initialElement if exist
            if(initialElement < $$('[data-md-editable="md-portal-media-list-item"]').length) {
                that.selectInitialThumbnail(initialElement);
            }
        }

        this.bindAccessibility();

    },
    expandOverlapTopLayer: function( slide ){
        var iframeWrapper = $$('.fullscreen')[0].getElement('.iframe-container'),
            position = iframeWrapper.getPosition(),
            width = iframeWrapper.getWidth(),
            height = iframeWrapper.getHeight()
        ;
        slide.setStyles({
            top: position.y,
            left: position.x,
            width: width,
            height: height
        });
    },
    resetOverlapTopLayer: function( slide ){
        var iframeWrapper = $$('.slide-wrapper.current')[0].getElement('.iframe-wrapper.iframe-wrapper-placeholder');
        if(iframeWrapper){
            var position = iframeWrapper.getPosition(),
                width = iframeWrapper.getWidth(),
                height = iframeWrapper.getHeight()
            ;
            slide.setStyles({
                top: position.y,
                left: position.x,
                width: width,
                height: height
            });
        }
    },
    setTabIndexThumbnails: function() {
        $$('[data-md-editable="md-portal-media-list-item"]').each( function(media, index){
            $(media).setAttribute('tabindex', 0);
            $(media).addClass('thumbnail');

            //Set aria label
            imageCaption = $(media).getAttribute('data-md-caption');
            imageCaption = (imageCaption != null?imageCaption+' image':'Image') + ' thumbnail opens larger image.';
            $(media).setAttribute('aria-label', imageCaption);
            $(media).setAttribute('role', 'button');

            elementID = $(media).getAttribute('data-md-id');

            image = $$('div.slide-wrapper[data-id="' + elementID + '"]').getElement('img');
            if(image!=null && image[0]!=null){
                image = image[0];
                image.setAttribute('tabindex', 0);
                ariaLabel = 'aria-' + elementID
                image.setAttribute('aria-describedby', ariaLabel);
            }

            expand = $$('div.slide-wrapper[data-id="' + elementID + '"').getElement('div.expand');
            expand = expand[0]
            expand.setAttribute('tabindex', 0);
        });



        // tabIndex = 1
        // $$('[data-md-editable="md-portal-media-list-item"]').each( function(media, index){
        //     $(media).setAttribute('tabindex', tabIndex++);
        //     $(media).addClass('thumbnail');
        //     elementID = $(media).getAttribute('id');

        //     image = $$('div.slide-wrapper[data-id="' + elementID + '"]').getElement('img');
        //     image = image[0];
        //     image.setAttribute('tabindex', tabIndex++);
        //     ariaLabel = 'aria-' + elementID
        //     image.setAttribute('aria-describedby', ariaLabel);

        //     caption = $$('div.caption div.texts');
        //     $(caption[index]).setAttribute('id', ariaLabel);

        //     expand = $$('div.slide-wrapper[data-id="' + elementID + '"').getElement('div.expand');
        //     expand = expand[0]
        //     expand.setAttribute('tabindex', tabIndex++);
        // });
    },
    removeTabIndexThumbnails: function() {
        $$('[data-md-editable="md-portal-media-list-item"]').each( function(media, index){
            $(media).removeAttribute('tabindex');
            $(media).removeClass('thumbnail');
        });
    },
    setTabIndexExpand: function(){
        // console.warn('setTabIndexExpand');
        // //remove tabindex from thumbnails, images, expand buttons
        // tabIndex = 1
        // $$('[data-md-editable="md-portal-media-list-item"]').each(function(media, index){
        //     $(media).removeAttribute('tabindex');
        //     $(media).removeClass('thumbnail');
        //     elementID = $(media).getAttribute('id');

        //     image = $$('div.slide-wrapper[data-id="' + elementID + '"]').getElement('img');
        //     image = image[0];
        //     image.removeAttribute('tabindex');

        //     expand = $$('div.slide-wrapper[data-id="' + elementID + '"').getElement('div.expand');
        //     expand = expand[0]
        //     expand.removeAttribute('tabindex');
        // });

        // tabIndex = 1

        // closeButton = $$('button.close');
        // closeButton = closeButton[0];
        // closeButton.setAttribute('tabIndex', tabIndex++);
        // closeButton.focus();

        // $$('div.pan-zoom-controls button').each(function(element, index){
        //     $(element).setAttribute('tabindex', tabIndex++);
        // });
    },
    triggerActions: function(e) {
        element = document.activeElement;

        if (element.hasClass('thumbnail')) {
            element.fireEvent('click', e);
            //line 921
        }

        if (element.hasClass('expand')) {
            element.fireEvent('click', e);
        }
    },
    bindAccessibility: function() {
        that = this;

        this.setTabIndexThumbnails()

        //capture INTRO key
        document.onkeydown = function(e) {
            if (e.keyCode == 32 || e.keyCode == 13) {
                that.triggerActions(e);
            }
        };

        //set accessibility text to expand image
        $$('div.expand').each(function(element, index){
            $(element).setAttribute('aria-label', 'Tap to expand');
        });

    },
    decodeHtmlTags: function(text_to_save){
        if(text_to_save==null || text_to_save==undefined) return "";
        //replace html to safe text for input
        pattern = '&quote;'
        re = new RegExp(pattern, "g");
        text_to_save = text_to_save.replace(re, '"')

        pattern = '&amp;'
        re = new RegExp(pattern, "g");
        text_to_save = text_to_save.replace(re, '&')

        pattern = "&#039;"
        re = new RegExp(pattern, "g");
        text_to_save = text_to_save.replace(re, "'")

        pattern = '&lt;'
        re = new RegExp(pattern, "g");
        text_to_save = text_to_save.replace(re, '<')

        pattern = '&gt;'
        re = new RegExp(pattern, "g");
        text_to_save = text_to_save.replace(re, '>')

        return text_to_save
    },
    parseAndCheckUrl: function () {
        var urlArray = window.location.href.split('&');
        var value = -1;
        urlArray.each(function(elem) {
            var part = elem.split('=');
            if(part[0] == "init") {
                value = part[1];
            }
        });
        return value;
    },
    selectInitialThumbnail: function(initialElement) {
        var that = this;
        var init = $$('[data-md-editable="md-portal-media-list-item"]')[initialElement];
        var captions = $$('.caption .texts');

        if (captions.length > 0) {
            captions[0].addClass('selected');
        }
        else {
            captions = $$('.caption .md-editable-box-wrapper-1');
            if (captions.length > 0) {
                captions[0].addClass('selected');
            }
        }

        if ($$('.container').get('data-3d-mode')[0] === 'true' && $$('body.md-edit-mode').length) {
            that.gallery.show(parseInt(init.getElement("img").getAttribute('data-pos')));
        }
        else {
            if ($$('.container').get('data-3d-mode')[0] === 'true') {
                that.goTogallery(parseInt(init.getElement("img").getAttribute('data-pos')));
            }
            else {
                that.gallery.show(parseInt(init.getElement("img").getAttribute('data-pos')));
            }
        }
        captions.removeClass('selected');

        if (captions.length > 0) {
            captions[initialElement].addClass('selected');
        }

        $$('[data-md-editable="md-portal-media-list"]')[0].getChildren().removeClass('selected');
        init.addClass('selected');
    },
    appendThumbnails: function (el) {
        var thumbWrapOuter = new Element('div', {'class': 'thumb-wrapper-outer'});
        var thumbWrapInner = $$('[data-md-editable="md-portal-media-list"]')[0];
        var captions = $$('.caption .texts');
        var that = this;
        thumbWrapInner.addClass('thumb-wrapper-inner');

        thumbWrapOuter.adopt(thumbWrapInner);

        var images = thumbWrapInner.getElements('img');

        images.each(function (img, i) {
            img.set({
                'data-pos': i,
                'exif': 'false'
            });
        });

        if (captions.length > 0) {
            captions[0].addClass('selected');
        }
        else {
            captions = $$('.caption .md-editable-box-wrapper-1');
            if (captions.length > 0) {
                captions[0].addClass('selected');
            }
        }

        if (thumbWrapInner.getChildren().length > 0) {
            thumbWrapInner.getChildren().each(function(thumb){
                thumb.removeClass('selected');
            });
            thumbWrapInner.getChildren()[0].addClass('selected');
        }

        thumbWrapInner.getChildren().each(function (element, index) {
            element.addEvent('click', function (e) {
                e.preventDefault();

                target = e.event;
                if (typeof e.event == 'undefined') {
                    target = e.target
                } else {
                    target = e.event.currentTarget;
                }

                if (target.hasClass("drag-indication-box")) {
                    return;
                }

                if ($$('.container').get('data-3d-mode')[0] === 'true' && $$('body.md-edit-mode').length) {
                    that.gallery.show(parseInt(target.getElement("img").getAttribute('data-pos')));

                }
                else {
                    if ($$('.container').get('data-3d-mode')[0] === 'true') {
                        that.goTogallery(parseInt(target.getElement("img").getAttribute('data-pos')));

                    }
                    else {
                        that.gallery.show(parseInt(target.getElement("img").getAttribute('data-pos')));

                    }
                }

                captions.removeClass('selected');

                if (captions.length > 0) {
                    captions[index].addClass('selected');
                }

                thumbWrapInner.getChildren().removeClass('selected');
                target.addClass('selected');
            });

        });

        this.el.grab(thumbWrapOuter, 'bottom');
    },
    goTogallery: function (index) {
        var slides = $$('.slide-wrapper');
        var slide = slides[index];
        var prevElem = $$(".main-image-inner").getElement('.current');

        spinner = $$(".main-image-inner");
        angle = index * theta * -1;
        $$('.slide-wrapper').removeClass('current');
        slide.addClass('current');
        if (slide.getElement(".iframe-wrapper:not(.iframe-wrapper-placeholder)") != null) {
            this.setupIframe( slide.getElement(".iframe-wrapper") );
        } else if (slide.getElement(".iframe-wrapper.iframe-wrapper-placeholder") != null) {
            this.setupIframe( $('top-layer-'+slide.get('id')).getElement(".iframe-wrapper") );
            this.overlapTopLayer( slide );
        }
        this.changeRotation(prevElem, index);
    },
    changeRotation: function (prevElem, currentElem) {
        var that = this;
        console.log('prevElem', prevElem);
        var previousElement = $(prevElem.get('data-id')[0]).getElement('img').get('data-pos');
        console.log('previousElement', previousElement);
        var rotationDirection = 'left';
        var steps = currentElem - previousElement;

        if(previousElement > currentElem){
            rotationDirection = 'right';
            steps = previousElement - currentElem;
        } else if(previousElement == currentElem) {
            rotationDirection = 'none';
            steps = 0;
        }

        switch(rotationDirection) {
            case 'left':
                var limit = parseInt(steps) + parseInt(previousElement);
                for(var i = parseInt(previousElement); i < limit; i++) {
                    that.sendToLeft(i);
                    that.bringToFront(i+1, 'left');
                }
                break;
            case 'right':
                var limit = parseInt(previousElement) - parseInt(steps);
                for(var i = parseInt(previousElement); i > limit; i--) {
                    that.sendToRight(i);
                    that.bringToFront(i-1, 'right');
                }
                break;
            default :
                break;
        }
    },
    bringToFront: function (item, direction){
        var mediaList = $$('.main-image-inner').getElements('.slide-wrapper')[0];
        if(direction == 'left'){
            mediaList[item].removeClass('mode-3d-after-1');
            mediaList[item].removeClass('mode-3d-after-2');
        }else{
            mediaList[item].removeClass('mode-3d-before-1');
            mediaList[item].removeClass('mode-3d-before-2');
        }
    },
    sendToRight: function (item) {
        var mediaList = $$('.main-image-inner').getElements('.slide-wrapper')[0];
        for(var i = item+1; i < mediaList.length; i++){
            if(mediaList[i].hasClass('mode-3d-after-1')){
                mediaList[i].removeClass('mode-3d-after-1');
                mediaList[i].addClass('mode-3d-after-2');
            }
        }

        mediaList[item].addClass('mode-3d-after-1');

        for(var i = item-1; i >= 0; i--){
            if(mediaList[i].hasClass('mode-3d-before-2')){
                mediaList[i].removeClass('mode-3d-before-2');
                mediaList[i].addClass('mode-3d-before-1');
                break;
            }
        }
    },
    sendToLeft: function (item) {
        var mediaList = $$('.main-image-inner').getElements('.slide-wrapper')[0];
        for(var i = 0; i < item; i++){
            if(mediaList[i].hasClass('mode-3d-before-1')){
                mediaList[i].removeClass('mode-3d-before-1');
                mediaList[i].addClass('mode-3d-before-2');
            }
        }

        mediaList[item].addClass('mode-3d-before-1');

        for(var i = item+1; i < mediaList.length; i++){
            if(mediaList[i].hasClass('mode-3d-after-2')){
                mediaList[i].removeClass('mode-3d-after-2');
                mediaList[i].addClass('mode-3d-after-1');
                break;
            }
        }
    },
    calculateAngles: function () {
        $$('.slide-wrapper').each(function (img, i) {
            if ($$('.container').get('data-3d-mode')[0] === 'true' && !$$('.md-edit-mode')[0]) {
                if(i != 0){
                    switch (i) {
                        case 1:
                            img.addClass('mode-3d-after-1');
                            break;
                        default:
                            img.addClass('mode-3d-after-2');
                            break;
                    }
                }
                img.addClass('slide-3d');
            }
        });
    },
    selectChangeSlide: function () {
        var elements = $$('.thumb-wrapper-inner >');
        for (var i = 0; i < elements.length; i++) {
            var thumb = elements[i];

            if (thumb.get('class') === 'selected') {

                if (event.gesture.direction == 'left') {
                    if (i + 1 === elements.length) {
                        elements[0].click();
                        return;
                    }
                    elements[i + 1].click();
                    return;
                }
                if (event.gesture.direction == 'right') {
                    if (i === 0) {
                        elements[ elements.length - 1 ].click();
                        return;
                    }
                    elements[i - 1].click();
                    return;
                }
            }
        }
    },
    initializePanZoom: function () {

        that = this;
        var container = $$('.fullscreen')[0];
        this.pan_zoom = container.getElement('.pan-zoom');
        this.layer = container.getElement('.layer');
        this.controls = {
            container: container.getElement('.pan-zoom-controls'),
            zoom_in: container.getElement('.pan-zoom-controls .zoom-in'),
            zoom_out: container.getElement('.pan-zoom-controls .zoom-out'),
            zoom_reset: container.getElement('.pan-zoom-controls .zoom-reset'),
        };
        this.controls.zoom_in.addEvent('click', function () {
            this.zoomIn();
        }.bind(this));
        this.controls.zoom_out.addEvent('click', function () {
            this.zoomOut();
        }.bind(this));
        this.controls.zoom_reset.addEvent('click', function () {
            this.zoomReset();
        }.bind(this));

        this.zoom = {
            container_size: {
                x: that.pan_zoom.getDimensions().x,
                y: that.pan_zoom.getDimensions().y
            },
            current_value: {
                zoom: 100,
                scrollLeft: 0,
                scrollTop: 0
            },
            delta: 20,
            max_in: 300,
            max_out: 100
        };

        this.pan_zoom.addClass('pan-zoom-active');
        this.drag();
    },
    drag: function () {
        new Drag.Scroll(this.pan_zoom, {
            axis: {x: true, y: true}
        });
    },
    zoomIn: function () {
        if (this.zoom.current_value.zoom >= this.zoom.max_in) {
            return false;
        }
        this.zoomTo(this.zoom.current_value.zoom + this.zoom.delta, 0.1);
    },
    zoomOut: function () {
        if (this.zoom.current_value.zoom <= this.zoom.max_out) {
            return false;
        }
        this.zoomTo(this.zoom.current_value.zoom - this.zoom.delta, -0.1);
    },
    zoomReset: function () {
        this.zoomTo(100, 0);
    },
    zoomTo: function (value, factor) {
        $$('.map.map-main').set('data-zoom', value);
        this.pan_zoom.scrollLeft = this.zoom.container_size.x * (this.pan_zoom.scrollLeft / this.zoom.container_size.x + factor);
        this.pan_zoom.scrollTop = this.zoom.container_size.y * (this.pan_zoom.scrollTop / this.zoom.container_size.y + factor);

        this.zoom.current_value.zoom = value;
        this.zoom.current_value.scrollLeft = this.pan_zoom.scrollLeft;
        this.zoom.current_value.scrollTop = this.pan_zoom.scrollTop;

        this.drag();

        switch (value) {
            case 120:
                porcent = 0.09;
                break;

            case 140:
                porcent = 0.15;
                break;

            case 160:
                porcent = 0.19;
                break;

            case 180:
                porcent = 0.22;
                break;

            case 200:
                porcent = 0.25;
                break;

            case 220:
                porcent = 0.28;
                break;

            case 240:
                porcent = 0.30;
                break;

            case 260:
                porcent = 0.31;
                break;

            case 280:
                porcent = 0.32;
                break;

            case 300:
                porcent = 0.33;
                break;

            default:
                porcent = factor;
        }
        var scroll_width_map = document.querySelector('.map.map-main').clientWidth * porcent;
        this.pan_zoom.scrollLeft = scroll_width_map;

    },
});


MediaGallery = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
        images: []
    },
    editModeFlag: false,
    initialize: function (options) {

        this.parent({
            container: $("contents")
        });


        if (parent != window) {
            parent.postMessage({
                method: "widget-ready",
                edit_mode: this.isEditMode,
                mode3d: $$('.container').get('data-3d-mode')[0] === 'true',
                vertical_mode: ($$("[data-md-widget-mode-vertical]").length > 0 && $$("[data-md-widget-mode-vertical]").get("data-md-widget-mode-vertical") == 1 ? true : false)
            }, "*");
        }
    },
    bindEditMode: function () {
        this.editModeFlag = true;
        edit_mode = true;
        var that = this;
        $$("body").addClass("md-edit-mode");

        var lastitem = $$('[data-md-editable="md-portal-media-list"]')[0];
        new Element("div.drag-indication-box.drop-zone", {
            html: "&nbsp;"//"Click here or drag an<br/> image or video to add<br/> it to this gallery."
        }).inject(lastitem, "bottom");

        $$('[data-md-editable="md-portal-media-list-item"]:not(.processed)').each(function (e, i) {
            new Element('a.md-portal-media-list-item-button.md-edit-remove', {
                'href': '#',
                'html': '<i class="fa fa-times"></i>'
            }).inject(e);

            new Element('a.md-portal-media-list-item-button.md-edit-slide', {
                'href': '#',
                'html': "<i class='fa fa-pencil'></i>" //'<u>EDIT</u>'
            }).inject(e);

            e.addClass("processed");
        });

        if ($$('[data-md-editable="md-portal-media-list"] .drop-zone:not(.drageventbind)').length > 0) {

            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondragover = function (e) {
                this.addClass('dragover');
                return false;
            };
            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondragend = function (e) {
                $$('[data-md-editable="md-portal-media-list"] .drop-zone').removeClass('dragover');
                return false;
            };
            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondragleave = function (e) {
                $$('[data-md-editable="md-portal-media-list"] .drop-zone').removeClass('dragover');
                return false;
            };
            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondrop = function (e) {
                e.preventDefault();

                var extensions = ".jpg,.jpeg,.gif,.png";
                extensions = extensions.replace(/\./g, '');
                extensions = extensions.split(",");

                var flag_no_errors = false;

                Array.each(e.dataTransfer.files, function (value, key) {
                    can_be_added = false
                    extensions.each(function (ext, ind) {
                        if (value.name.indexOf("." + ext) > 0 || value.type.indexOf("/" + ext) > 0)
                            can_be_added = true
                    })

                    if (can_be_added) {
                        flag_no_errors = true;
                    }

                });


                if (!flag_no_errors) {
                    alert("This field doesn't accept this file type. The file types accepted are .jpg,.jpeg,.gif,.png.");
                    return;
                }

                if (parent && parent != window) {
                    parent.postMessage({method: 'files-begin-upload'}, "*");
                }

                var container = '[data-md-editable="md-portal-media-list"]',
                    time = 0,
                    refresh = false;
                $$(container).removeClass('dragover');
                for (var i = 0; i < e.dataTransfer.files.length; i++) {
                    var file = [e.dataTransfer.files[i]];
                    if (i === e.dataTransfer.files.length - 1) {
                        refresh = true;
                    }
                    setTimeout(function(){
                        that.uploadFile(file, container, refresh);
                    }, time);
                    time += 1000;
                }
                return false;
            };

            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].addClass("drageventbind");
        }

        $$('.md-edit-remove').addEvent('click', function () {
            if (confirm("Are you sure you want to delete this element from the gallery?")) {
                that.removeFile(this.getParent().getAttribute("data-md-id"), this.getSiblings('img')[0].getAttribute('src'), this.getParent());
            }
            that.notifyFocusCapture();
            return false;
        });
        $$('.md-edit-alt-text').addEvent('click', function () {
            if (parent && parent != window) {
                parent.postMessage({method: 'edit-alt-text', type: "textfield", id: this.getParent().getAttribute("data-md-id"), content: this.getParent().getElement('img').get('alt')}, "*");
                that.notifyFocusCapture();
            }
            return false;
        });
        $$('.md-edit-image-id').addEvent('click', function () {
            if (parent && parent != window) {
                parent.postMessage({method: 'edit-image-id', type: "textfield", promptText: "Enter the image ID", id: this.getParent().getAttribute("data-md-id"), content: this.getParent().getAttribute("data-md-image-id")}, "*");
                that.notifyFocusCapture();
            }
            return false;
        });

        $$('.md-edit-slide').addEvent('click', function () {
            if (parent && parent !== window) {
                var document_caption = this.getParent().getElement('.data-md-doc-title-thumbnail');
                var multimedia_type = this.getParent().attributes['data-md-multimediatype'].value;
                if (document_caption !== null && multimedia_type === 'document') {
                    var slides = $$('.slide-wrapper');
                    var image = this.getParent().getElement('img');
                    var data_pos = image.get('data-pos');
                    var text = slides[data_pos].getElement('.rt-wrapper') ? slides[data_pos].getElement('.rt-wrapper').get('html') : '';
                    parent.postMessage({method: 'show-media-popup-edit-document', id: this.getParent().getAttribute("data-md-id"), title: document_caption.get('html'), text: text, remove_souce_limit: 'true'}, "*");
                } else {
                    var message = {method: 'show-media-popup', id: this.getParent().getAttribute("data-md-id"), remove_souce_limit: 'true'};
                    if (multimedia_type === 'iframe') {
                        message.edit = 'true';
                        if(this.getParent().attributes['data-md-title']){
                            message.title = this.getParent().attributes['data-md-title'].value;
                            message.title = message.title.replace('<p>', '');
                            message.title = message.title.replace('</p>', '');
                        }else{
                            message.title = '';
                        }
                        message.url = this.getParent().getElement('img').attributes['filepath'].value;
                        message.multimediatype_format = this.getParent().attributes['data-md-multimediatype-format'].value;
                    } else if (multimedia_type === 'image' && this.getParent().getElement('span.data-md-doc-title-thumbnail')) {
                        message.placeholder_id = this.getParent().get('id');
                    }
                    parent.postMessage(message, "*");
                }
                that.notifyFocusCapture();
            }
            return false;
        });

        $$('.drag-indication-box').addEvent('click', function () {
            if (parent && parent != window) {
                parent.postMessage({method: 'show-media-popup', remove_souce_limit: 'true'}, "*");
            }
            return false;
        });

        setTimeout(function() {
            var timeoutHandler = null;
            var wrapper = $$('.rt-wrapper[contenteditable="true"]');
            wrapper.addEvent('keyup', function() {
                if(timeoutHandler){
                    clearTimeout(timeoutHandler);
                }
                timeoutHandler = setTimeout(function(){
                    that.saveRequest({
                        method: 'mdSetAttribute',
                        options: {
                            selector: '#'+wrapper.getParent().getParent().get('data-id'),
                            attribute: 'data-md-caption',
                            value: wrapper.get('html')[0]
                        }
                    });
                }, 1500);
            });
        }, 3000);
    },
    removeFile: function (file_id, file_src, element) {
        this.saveRequest({
            img_src: file_src,
            method: 'remove',
            element: file_id,
            no_delete_image: element.get("data-md-no-delete-image") != "" && element.get("data-md-no-delete-image") == "1" ? true : false
        }, function () {
            document.location.reload();
        });
    },
    altText: function (id) {
        alert(id);
    },
    uploadFile: function (files, containerSelector, refresh) {
        var that = this;
        var formData = new FormData();
        var multimediaType = "image";
        var multimediaTypeFormat = "";
        for (var i = 0; i < files.length; i++) {
            if (files[i].type.indexOf("video") != -1) {
                multimediaType = "video";
            }
            multimediaTypeFormat = files[i].type;
            formData.append('file', files[i]);
        }

        var pathUpload = location.href;
        if (pathUpload.indexOf("?") > 0) {
            pathUpload = pathUpload.split("?")[0];
        }

        formData.append('path', pathUpload);
        formData.append('directory', 'images');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', this.root + 'api/index.php/upload/');
        xhr.onload = function () {

            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                var img_path = response.path;

                var imagepath, filepath;
                imagepath = filepath = 'images/' + response.filename;
                if (multimediaType == "video") {
                    imagepath = "https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
                }

                if (parent && parent != window) {
                    parent.postMessage({method: 'files-end-upload'}, "*");
                }
                that.saveRequest({
                    method: 'appendMultimedia',
                    element: containerSelector,
                    type: 'md-portal-media-list-element',
                    content: imagepath,
                    filePath: filepath,
                    multimediaType: multimediaType,
                    multimediaTypeFormat: multimediaTypeFormat
                }, function () {
                    if (refresh) {
                        document.location.reload();
                    }
                });
            } else {
                alert(xhr.status + ' Error uploading image. Please contact the system administrator.');
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },
    customPostMessages: function (message, path) {
        this.parent(message, path);
        var that = this;

        switch (message.data.method) {
            case "image-accessibility-text":
                that.saveRequest({
                    method: "setAttributeById",
                    id: $$('[data-md-editable="md-portal-media-list-item"]')[message.data.ind].get("id"),
                    attribute: [
                        {
                            attribute: "data-accessibility-text",
                            value: message.data.text
                        }
                    ]
                });
                break;
            case "retrieve-image-accessibility-list":
                if (parent != window) {
                    var image_list = [];
                    $$('[data-md-editable="md-portal-media-list-item"]').each(function (e) {

                        image_list.push({
                            image: e.getElement("img").get("src"),
                            text: e.get("data-accessibility-text")
                        });


                    });

                    parent.postMessage({
                        method: "image-accessibility-list",
                        list: image_list
                    }, "*");
                }
                break;
            case 'edit-alt-text':
                that.saveRequest({
                    method: 'setAttribute',
                    attribute: 'alt',
                    content: message.data.data.content,
                    innerElement: 'img',
                    id: message.data.id,
                    path: path
                });
                break;
            case "toggle-attribute":
                that.saveRequest({
                    method: 'setAttributeById',
                    attribute: message.data.content,
                    value: message.data.value,
                    id: message.data.id,
                    path: path
                }, function () {
                    window.location.reload();
                });
                break;
            case "edit-image-id":
                that.saveRequest({
                    method: 'setAttribute',
                    attribute: 'data-md-image-id',
                    content: message.data.data.content,
                    id: message.data.id,
                    path: path
                });
                break;

            case "retrieve-change-history":
                if (!message.data.data)
                    return;
                if (message.data.data.length > 0) {
                    var container = $$("[data-md-field-id='" + message.data.id + "']").getParent();
                    this.addFieldChangeTrackingControl(container[0], message.data.data, message.data.id);
                }
                else {
                    $$("[data-md-field-id='" + message.data.id + "']")[0].getParent().getElements("a.md-track-changes-control").dispose();
                    $$("[data-md-field-id='" + message.data.id + "']")[0].getParent().getElements("div.md-track-changes-show").dispose();
                }
                break;
            case "track-tracking-change-status":
                if (message.data && message.data.status == 2) {
                    var text = $$(".slide-wrapper.current .md-track-changes-show")[0].get("text").trim();
                    var ind = $$(".slide-wrapper").indexOf($$(".slide-wrapper.current")[0]);
                    that.saveRequest({
                        method: "setAttribute",
                        id: $$('[data-md-editable="md-portal-media-list-item"]')[ind].get("data-md-id"),
                        attribute: "data-md-caption",
                        content: text
                    });

                }

                if (message.data.data.length > 0) {

                    var container = $$("[data-md-field-id='" + message.data.id + "']").getParent();
                    this.addFieldChangeTrackingControl(container[0], message.data.data, message.data.id);
                }
                else {
                    $$("[data-md-field-id='" + message.data.id + "']")[0].getParent().getElements("*:not([data-md-field-id])").dispose();
                    $$("[data-md-field-id='" + message.data.id + "']")[0].getParent().getElements("*[data-md-field-id]").show();
                }

                break;
            case 'widget-test-difference':
                $$(".md-track-changes-preview-" + message.data.id).set("html", message.data.diff);
                that.saveRequest($$(".md-track-changes-editor-" + message.data.id)[0], {
                    method: "setAttribute",
                    track_id: message.data.track_id,
                    content: message.data.change
                });
                break;

            case 'show-media-popup-edit-document':
                var imagepath, filepath, multimediaTypeFormat, multimediaType, caption = "", defaultImage = false, copyFile = false, attributes = {};
                filepath = 'images/' + message.data.data.source_value;
                imagepath = "https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
                multimediaType = multimediaTypeFormat = message.data.data.source_type;

                var title = '';

                if (multimediaType == "document") {
                    multimediaType = multimediaTypeFormat = "document";
                    caption = message.data.data.source_value;
                    title = message.data.data.source_title;
                    defaultImage = 'document';
                    imagepath = filepath = "";
                }


                var containerSelector = '[data-md-editable="md-portal-media-list"]';

                that.saveRequest({
                    path: path,
                    method: message.data.id ? 'updateMultimedia' : 'appendMultimedia',
                    element: containerSelector,
                    type: 'md-portal-media-list-element',
                    content: imagepath,
                    filePath: filepath,
                    multimediaType: multimediaType,
                    multimediaTypeFormat: multimediaTypeFormat,
                    mustCopyTheFile: copyFile,
                    title: title,
                    caption: caption,
                    defaultImage: defaultImage,
                    id: message.data.id ? message.data.id : null,
                    attributes: attributes
                }, function () {
                    window.location.reload();
                });

                break;

            case "show-media-popup":

                var imagepath, filepath, multimediaTypeFormat, multimediaType, title = "", caption = "", defaultImage = false, copyFile = false, attributes = {};
                filepath = 'images/' + message.data.data.source_value;
                imagepath = "https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
                multimediaType = multimediaTypeFormat = message.data.data.source_type;

                if (multimediaType == "pearson") {
                    multimediaType = "iframe";
                    filepath = message.data.data.source_value;
                    if (filepath.indexOf("audio") > 0 ) {
                        multimediaTypeFormat = "pearson-audio";
                    }else{
                        multimediaTypeFormat = "pearson-video";
                    }

                }

                if (multimediaType == "pearson-video") {
                    multimediaType = "iframe";
                    if (message.data.data.source_value.indexOf("youtube.com")>=0) {
                        var url = message.data.data.source_value;
                        filepath = 'https://www.youtube.com/embed/' + url.split('watch?v=')[1];
                    } else {
                        filepath = message.data.data.source_value;
                    }
                    title = message.data.data.thumbnail_text;
                }

                if (multimediaType == "pearson-audio") {
                    multimediaType = "iframe";
                    filepath = message.data.data.source_value;
                    title = message.data.data.thumbnail_text;
                }

                if (multimediaType == "internet") {
                    multimediaType = multimediaTypeFormat = "iframe";
                    filepath = message.data.data.source_value;
                    if (filepath.indexOf(".png") > 0 || filepath.indexOf(".jpg") > 0 || filepath.indexOf(".jpeg") > 0) {
                        imagepath = filepath;
                        multimediaType = multimediaTypeFormat = "image";
                    } else if (filepath.indexOf(".avi") > 0 || filepath.indexOf(".mp4") > 0 || filepath.indexOf(".mpg") > 0) {
                        multimediaType = "iframe";
                        multimediaTypeFormat = "pearson-video";
                        filepath = message.data.data.source_value;
                        title = message.data.data.thumbnail_text;
                    } else if (filepath.indexOf(".mp3") > 0 || filepath.indexOf(".wma") > 0 || filepath.indexOf(".wav") > 0) {
                        multimediaType = "iframe";
                        multimediaTypeFormat = "pearson-audio";
                        filepath = message.data.data.source_value;
                        title = message.data.data.thumbnail_text;
                    } else if (filepath.indexOf("youtube.com") > 0) {
                        multimediaTypeFormat = "pearson-video";
                        var url = message.data.data.source_value;
                        filepath = 'https://www.youtube.com/embed/'+url.split('watch?v=')[1];
                        title = message.data.data.thumbnail_text;
                    }
                }

                if (multimediaType == "text") {
                    multimediaType = multimediaTypeFormat = "text";
                    caption = message.data.data.source_value;
                    defaultImage = true;
                    imagepath = filepath = "";
                }

                if (multimediaType == "folder") {
                    multimediaType = "image";
                    multimediaTypeFormat = message.data.data.source_ext;
                    imagepath = filepath = message.data.data.source_value;
                    attributes["data-md-no-delete-image"] = true;
                }

                if (multimediaType == "computer") {

                    if (message.data.data.source_ext.indexOf("image/") != -1) {
                        multimediaType = "image";
                        multimediaTypeFormat = message.data.data.source_ext;
                        imagepath = filepath = message.data.data.source_value;
                    }
                    if (message.data.data.source_ext.indexOf("video/") != -1) {
                        multimediaType = "video";
                        multimediaTypeFormat = message.data.data.source_ext;
                        filepath = message.data.data.source_value;
                    }

                    copyFile = true;
                }

                if (multimediaType == "document") {
                    multimediaType = multimediaTypeFormat = "document";
                    caption = message.data.data.source_value;
                    title = message.data.data.source_title;
                    defaultImage = 'document';
                    imagepath = filepath = "";
                }
                that.saveRequest({
                    path: path,
                    method: message.data.id ? 'updateMultimedia' : 'appendMultimedia',
                    element: containerSelector,
                    type: 'md-portal-media-list-element',
                    content: imagepath,
                    filePath: filepath,
                    multimediaType: multimediaType,
                    multimediaTypeFormat: multimediaTypeFormat,
                    mustCopyTheFile: false,
                    title: title,
                    caption: caption,
                    defaultImage: defaultImage,
                    id: message.data.id ? message.data.id : null,
                    attributes: attributes
                }, function () {

                    var is_pearson_media = message.data.multimediatype_format == "pearson-video" || message.data.multimediatype_format == "pearson-video";

                    if(message.data.id && $(message.data.id).getElement('span.data-md-doc-title-thumbnail') && filepath != '' && !is_pearson_media) {
                        $(message.data.id).getElement('a.md-edit-remove').destroy();
                        $(message.data.id).getElement('a.md-edit-slide').destroy();
                        $(message.data.id).getElement('span.data-md-doc-title-thumbnail').destroy();
                        $(message.data.id).getElement('img').setStyle('opacity', 1);
                        var imgName = filepath.split('/');
                        $(message.data.id).getElement('img').set('src', 'images/'+imgName[imgName.length-1]);
                        $(message.data.id).getElement('img').set('filepath', 'images/'+imgName[imgName.length-1]);
                        $(message.data.id).innerHTML = $(message.data.id).innerHTML.replace('type="document"', 'type="image"');
                        that.saveRequest({
                            method: 'mdHtml',
                            options: {
                                selector: '#'+message.data.id,
                                html: $(message.data.id).innerHTML
                            }
                        }, function(){
                            window.location.reload();
                        });
                    } else if (message.data.id && !$(message.data.id).getElement('span.data-md-doc-title-thumbnail') && filepath == '' && !is_pearson_media) {
                        $(message.data.id).getElement('a.md-edit-remove').destroy();
                        $(message.data.id).getElement('a.md-edit-slide').destroy();
                        $(message.data.id).getElement('img').setStyle('opacity', 0);
                        $(message.data.id).innerHTML = $(message.data.id).innerHTML.replace('type="image"', 'type="document"');
                        $(message.data.id).grab(new Element('span.data-md-doc-title-thumbnail'), 'top');
                        that.saveRequest({
                            method: 'mdHtml',
                            options: {
                                selector: '#'+message.data.id,
                                html: $(message.data.id).innerHTML
                            }
                        }, function(){
                            window.location.reload();
                        });
                    } else {
                        window.location.href = window.location.href+'&init='+$$('[data-md-editable="md-portal-media-list-item"]').length;
                    }
                });
                break;

            // case "toggleHTML":
            //     console.log(message);
            //     that.saveRequest({
            //         method: "toggleHTML",
            //         selector: message.data.wrapper,
            //         elementID: message.data.elementID,
            //         toggle: "" + message.data.value
            //     }, function () {
            //         document.location.reload();
            //     });
            //     break;

            default:
                console.warn('media-gallery Unknown message', message);
        }
    },
    initializeWarterMark: function (element, watermark) {
        element.set("data-edited", false);

        element.addEvent("focus", function () {
            var edited = this.get("data-edited");

            if (this.get("html") == watermark) {
                this.set("data-edited", false);
                edited = this.get("data-edited");
            }

            if (edited == "false") {
                this.set("html", "");
                this.removeClass("watermark-on");
            }
        });

        element.addEvent("blur", function () {
            if (!this.get("html")) {
                this.set("data-edited", false);
                this.set("html", watermark);
                this.addClass("watermark-on");
            }
        })

        element.set("html", watermark);
        element.addClass("watermark-on");
    },
    assignDatatoEditor: function (editorDiv, element, index, mark, attribute) {
        var that = this;
        if (editorDiv.length > 0 && editorDiv[index] != null) {
            editorDiv[index]
                .set('data-md-field-id', element.get('data-md-id'));

            if (element.get(attribute) != null && element.get(attribute) != "" && element.get(attribute) != mark) {
                editorDiv[index].set("html", element.get(attribute));
            }
            else {
                editorDiv[index].set("html", mark);
            }

            var html = editorDiv[index].get('html');
            var originalHtmlValue = html;

            editorDiv[index].set("data-edited", true);

            if (originalHtmlValue != mark) {
                editorDiv[index].removeClass("watermark-on");
            }
            setTimeout(function () {
                html = editorDiv[index].get('html');

                if (html != originalHtmlValue) {
                    editorDiv[index].fireEvent('keyup');

                    originalHtmlValue = html;
                }
            }, 1000);

            editorDiv[index].addEvent("keyup", function (e) {
                var text = this.get('html');
                var max = 200;
                var id = this.getAttribute('data-md-field-id');
                if (attribute === 'data-md-credit') {
                    max = 100;
                }
                var string = this.get('text');
                var length = string.length;
                if(e){
                    if (length >= max && ([8, 46, 18, 37, 38, 39, 40].indexOf(e.code) == -1)) {
                        return false;
                    }
                }

                $$(".thumbnail[data-md-id='"+this.getAttribute('data-md-field-id')+"']")[0].set(attribute,text);

                this.set("data-edited", true);
                that.saveRequest({
                    method: "setAttribute",
                    id: id,
                    attribute: attribute,
                    content: text
                });
            });

            editorDiv[index].addEvent("keyup", function () {
                var text = this.get('html');
                var max = 200;
                var selector = '.counter_caption';
                if (attribute === 'data-md-credit') {
                    max = 100;
                    selector = '.counter_credit';
                }
                var string = this.get('text');
                var count = max - string.length;
                $$(selector)[index].set('html', count);
            });
        }
    },
    render: function () {
        new epubWidget.Gallery(this.container, {
            options: {"delay": 4000, "autoplay": false, "transition": "fade", "size": {"height": "500", "width": "670"}}
        }, undefined, {
            "size": {"height": "500", "width": "670"},
            "images": this.options.images,
            "thumbnails": true,
            "clickToNext": false
        });

        var that = this;

        if (this.editModeFlag) {
            var captionEditor = $$("div.data-md-editable.caption-editor");
            var captionAttribute = "data-md-caption";
            var creditEditor = $$("div.data-md-editable.credit-editor");
            var creditAttribute = "data-md-credit";

            var captionWaterMark = 'Enter caption (optional)';
            var creditWaterMark = 'Enter credit (optional)';

            this.initializeWarterMark($$("div.data-md-editable.caption-editor"), captionWaterMark);
            this.initializeWarterMark($$("div.data-md-editable.credit-editor"), creditWaterMark);

            $$('[data-md-editable="md-portal-media-list-item"]').each(function (element, index) {
                that.assignDatatoEditor(captionEditor, element, index, captionWaterMark, captionAttribute);
                that.assignDatatoEditor(creditEditor, element, index, creditWaterMark, creditAttribute);
                var span = element.getElements('.data-md-doc-title-thumbnail');
                var title = element.get('data-md-title');
                if (title !== '' && title !== null && span.length > 0) {
                    span.set('html', title);
                    if (title.length < 20) {
                        span[0].addClass('single-line');
                    }
                }
            });


            $$("div.data-md-editable.caption-editor").addEvent("click", function () {
                that.notifyFocusCapture();
            });

            setTimeout(function () {
                if ($$('[data-md-widget-mode-vertical="1"]').length > 0)
                    $$(".epubWidget-gallery .thumb-wrapper-outer")[0].scrollTo(0, 5000);
                else
                    $$(".epubWidget-gallery .thumb-wrapper-outer")[0].scrollTo(5000, 0);
            }, 250);

            new Sortables('[data-md-editable="md-portal-media-list"]', {
                onSort: function () {
                    var newlist = $$('[data-md-editable="md-portal-media-list"]')[0].clone();
                    newlist.getElement(".drop-zone").dispose();

                    newlist.getElements('[data-md-editable="md-portal-media-list-item"]').removeClass("processed");
                    newlist.getElements('[data-md-editable="md-portal-media-list-item"] > img').removeProperty("data-pos");
                    newlist.getElements('[data-md-editable="md-portal-media-list-item"] > img').removeProperty("exif");
                    newlist.getElements('[data-md-editable="md-portal-media-list-item"] > a').dispose();
                    newlist.getElements('div:not([data-md-editable])').dispose();

                    that.saveRequest({
                        selector: '[data-md-editable="md-portal-media-list"]',
                        html: newlist.get('html'),
                        method: "setHTML"
                    });
                }
            });

            if (captionEditor.length > 0 && creditEditor.length > 0) {
                for(var i = 0; i < captionEditor.length; i++){
                    var caption_chars = captionEditor[i].get('text').trim();
                    var credit_chars = creditEditor[i].get('text').trim();
                    if (caption_chars === 'Enter caption (optional)') {
                        caption_chars_count = 200
                    } else {
                        var caption_chars_count = 200 - caption_chars.length;
                    }
                    if (credit_chars === 'Enter credit (optional)') {
                        var credit_chars_count = 100;
                    } else {
                        var credit_chars_count = 100 - credit_chars.length;
                    }
                    captionEditor[i].getParent().appendHTML('<div class="counter_caption">' + caption_chars_count + '</div><div class="counter_credit">' + credit_chars_count + '</div>');
                }
            }

            setTimeout(function(){
                that.detectContentEditableEditorPanelElements();
            },750);
        }
        else {
            $$('[data-md-editable="md-portal-media-list-item"]').each(function (e, i) {
                if ($$(".caption .caption-text").length > 0) {
                    $$(".caption .caption-text")[i].set("html", e.get("data-md-caption"));
                }
                if ($$(".caption .credit").length > 0) {
                    $$(".caption .credit")[i].set("html", e.get("data-md-credit"));
                }
                var title = e.get("data-md-title");
                var span = e.getElements('.data-md-doc-title-thumbnail');
                if (title !== '' && title !== null && span.length > 0) {
                    span.set('html', title);
                    if (title.length < 20) {
                        span[0].addClass('single-line');
                    }
                }
            });
        }

        calculateHeightElement($$(".slide-wrapper.current")[0]);

    },
    onTrackChangeApproved: function () {
        return $$(".slide-wrapper.current .md-track-changes-show")[0].get("text").trim();
    }
});
