/**
 * Created by germanmontes on 25/08/14.
 */


/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
 */

'use strict';
/*global $: true, $$: true*/
/*
 var state = function (e, i) { $$('.container')[0].dataset.show = i.get('data-id') };

 window.onload = (function() {
 document.body.addEvent('click:relay(.tabButton)', state);
 });
 */

var MultiChoiceQuiz = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
        container: null,
    },

    initialize: function(options) {
        var that = this;
        this.parent({
            container: options.container,
            itemTemplate:options.itemTemplate
        });

        this.render();
    },
    bindEditMode:function(){;

        var that = this;


        that.addEvent("md-multiple-options-option-added",function(event){
            that.addCorrectIncorrectToggleCheckbox(event.el);
        });

        var correctMessage = this.container.get("data-correct-answer") || "";
        var incorrectMessage = this.container.get("data-incorrect-answer") || "";


        var globalOptionsWrapper = new Element("div.global-options",{
            html:"" +
                    "<div class='global-option' >" +
                        "<div class='global-option-label' >" +
                            "<div>Correct Answer</div>"+
                            "<div>Message</div>"+
                        "</div>" +
                        "<div class='global-option-textfield-wrapper'><div class='global-option-textfield correct-answer-label' data-md-editable='md-textfield'>"+correctMessage+"</div></div>" +
                    "</div>"+
                        "<div class='global-option' >" +
                            "<div class='global-option-label' >" +
                                "<div>Incorrect Answer</div>"+
                                "<div>Message</div>"+
                            "</div>" +
                        "<div class='global-option-textfield-wrapper'><div class='global-option-textfield incorrect-answer-label' data-md-editable='md-textfield'>"+incorrectMessage+"</div></div>" +
                    "</div>"+
                ""
        });


        globalOptionsWrapper.inject(this.container,"top");
        new Element("hr").inject(this.container);

        var saveButton = new Element("div.global-options",{
            html:"" +
                "<div>" +
                "<button>Save Widget</button>"+
                "</div>"+
                "<br/><hr/><br/>"
        });
        saveButton.inject(this.container,"top");
        saveButton.getElement("button").addEvent("click",this.saveWidgetProcedure.bind(this));




        var navButtonWrapper = new Element("div.navigation-add-entry-wrappwer");
        navButtonWrapper.inject(this.container);

        new Element("div.go-to-button.go-prev-item",{
            html:"&lArr; Back"
        })
        .addEvent("click",that.goPrevNextItem.bind(that))
        .inject(navButtonWrapper);

        new Element("div.go-to-button.go-next-item",{
            html:"Next &rArr;"
        })
        .addEvent("click",that.goPrevNextItem.bind(that))
        .inject(navButtonWrapper);


        var buttonWrapper = new Element("div.button-add-change-position-wrapper");
        buttonWrapper.inject(navButtonWrapper)


        new Element("button.add-another-entry",{
            html:"Add another entry"
        })
        .addEvent("click",that.addAnotherItemClickEventListener.bind(that))
        .inject(buttonWrapper);

        new Element("button.move-prev.move-entry",{
            html:"&lArr; Move to previous position"
        })
        .addEvent("click",that.editorMoveElementPreviousNextPosition.bind(that))
        .inject(buttonWrapper);

        new Element("button.delete-entry",{
            html:"Delete entry"
        })
        .addEvent("click",that.editorDeleteEntry.bind(that))
        .inject(buttonWrapper);

        new Element("button.copy-entry",{
            html:"Copy entry"
        })
        .addEvent("click",that.editorCopyEntry.bind(that))
        .inject(buttonWrapper);

        new Element("button.move-next.move-entry",{
            html:"Move to next position &rArr;"
        })
        .addEvent("click",that.editorMoveElementPreviousNextPosition.bind(that))
        .inject(buttonWrapper);



        var fieldset = new Element("fieldset.entrys-wrapper");
        fieldset.inject(this.container);

        new Element("legend.total-entrys",{
            html:"0 entrys"
        }).inject(fieldset);


        if(this.container.getElements(".entry").length>0){
            this.container.getElements(".entry").inject(fieldset);
            this.container.getElements(".entry")[0].addClass("active");
        }


    },
    bindEditModeAfterTagParse:function(){
        this.parseEntryOptions();
        this.setPagerEditor(1);
    },
    editorCopyEntry:function(e){
        var current = this.container.getElement(".entry.active");
        current.removeClass("active");

        var newentry = this.addAnotherItemProcedure(current);

        newentry.getElement('.md-data-set-item > [data-md-editable="md-textfield"] input').set("value", current.getElement('.md-data-set-item > [data-md-editable="md-textfield"] input').get("value"));
        current.getElements('.md-data-set-item .entry-options .option-entry').each(function(el){
            //<div class="option-entry"><div data-md-editable="md-textfield" class="data-md-editable option-text" data-correct="1" data-md-id="textfield-01409101559205" id="textfield-01409101559205">test 2 option</div></div>
            if(el.getElement(".option-text input").get("value")!=""){
                var optionEntry = new Element("div.option-entry",{
                    html:'<div data-md-editable="md-textfield" class="data-md-editable option-text" data-correct="'+el.getElement(".option-text").get("data-correct")+'">'+el.getElement(".option-text input").get("value")+'</div>'
                });

                optionEntry.inject(newentry.getElement('.md-data-set-item .entry-options .option-entry:last-child'),"before");
            }
        });

        newentry.getElement('.md-data-set-item .entry-options').removeClass("correct-incorrect-toggle");

        this.parseElements(newentry.getElement('.md-data-set-item .entry-options'));
        this.parseEntryOptions();

    },
    editorDeleteEntry:function(e){
        var current = this.container.getElement(".entry.active");
        var next = null;

        if(current.getNext()!=null){
            next = current.getNext();
        }

        if(next==null && current.getPrevious()!=null){
            next = current.getPrevious();
        }

        current.dispose();
        next.addClass("active");


        var newindex = this.container.getElements(".entry").indexOf(next) + 1;
        this.setPagerEditor(newindex);


    },
    editorMoveElementPreviousNextPosition:function(e){
        var current = this.container.getElement(".entry.active");
        var next = null;

        if(e.event.currentTarget.hasClass("move-prev")){
            next = current.getPrevious();
            current.inject(next,"before");
        }
        else{
            next = current.getNext();
            current.inject(next,"after");

        }


        var newindex = this.container.getElements(".entry").indexOf(current) + 1;

        this.setPagerEditor(newindex);




    },
    parseEntryOptions:function(){
        var that = this;
        this.container.getElements('.entry [data-md-editable="md-multiple-options"]:not(.correct-incorrect-toggle)').each(function(e){

            e.getElements(".option-entry:not(.correct-incorrect-toggle-added)").each(function(optione){
                that.addCorrectIncorrectToggleCheckbox(optione);
            });

            e.addClass("correct-incorrect-toggle");
        })
    },
    addCorrectIncorrectToggleCheckbox:function(optione){
        var correct = optione.getElement('[data-md-editable="md-textfield"]').get("data-correct");
        var idinput = new Date().getTime() + "check-"+optione.getElement('[data-md-editable="md-textfield"]').get("id");
        new Element("input.correct-incorrect-toggle",{
            "type":"checkbox",
            value:"1",
            checked:correct=="1"?"checked":"",
            id:idinput
        })
        .addEvent("click",function(ev){
            optione.getElement(".option-text").set("data-correct",this.get("checked")?"1":"0");
        })
        .inject(optione.getElement('[data-md-editable="md-textfield"]'));



        new Element("label.correct-incorrect-toggle",{
            "html":"Correct",
            value:"1",
            for:idinput
        }).inject(optione.getElement('[data-md-editable="md-textfield"]'));

        optione.addClass("correct-incorrect-toggle-added");
    },
    goPrevNextItem:function(e){

        if(this.options.container.getElement("fieldset.entrys-wrapper").getElements(".entry").length <= 0) return;

        var current = this.container.getElement(".entry.active");
        var next= null;

        if(e.event.currentTarget.hasClass("go-next-item")){
            next = current.getNext();
        }else{
            next = current.getPrevious();
        }

        if(next==null)return;
        if(next.nodeName.toLowerCase()=="legend")return;


        current.removeClass("active");
        next.addClass("active");

        var ind = this.container.getElements(".entry").indexOf(next) + 1;

        this.setPagerEditor(ind);


    },
    setPagerEditor:function(page){
        if(this.options.container.getElement("fieldset.entrys-wrapper").getElements(".entry").length > 0){
            var totalentrys = this.options.container.getElement("fieldset.entrys-wrapper").getElements(".entry").length;
            this.options.container.getElement("fieldset.entrys-wrapper").getElement("legend").set("html"," Current entry: "+page+ " of " + totalentrys +" entrys.")
            this.container.getElements(".move-entry").setStyle("visibility","visible");
            this.container.getElements(".delete-entry").setStyle("visibility","visible");
            this.container.getElements(".copy-entry").setStyle("visibility","visible");
            this.container.getElements(".go-to-button").setStyle("visibility","visible");
            if(page==1){
                this.container.getElements(".move-entry.move-prev").setStyle("visibility","hidden");
                this.container.getElements(".go-prev-item").setStyle("visibility","hidden");
            }
            if(page==totalentrys){
                this.container.getElements(".move-entry.move-next").setStyle("visibility","hidden");
                this.container.getElements(".go-next-item").setStyle("visibility","hidden");
            }
        }else{
            this.options.container.getElement("fieldset.entrys-wrapper").getElement("legend").set("html"," No entrys yet.")
            this.container.getElements(".move-entry").setStyle("visibility","hidden");
            this.container.getElements(".delete-entry").setStyle("visibility","hidden");
            this.container.getElements(".copy-entry").setStyle("visibility","hidden");
            this.container.getElements(".go-to-button").setStyle("visibility","hidden");
        }
    },
    saveWidgetProcedure:function(){
        var widgetbody = this.container.getParent(".widget-body").clone();
        var container = this.container.clone(true,true);

        widgetbody.empty();
        container.empty();
        widgetbody.adopt(container);

        var correct_answer_label = this.container.getElement(".correct-answer-label input").get("value");
        var incorrect_answer_label = this.container.getElement(".incorrect-answer-label input").get("value");

        container.set("data-correct-answer",correct_answer_label);
        container.set("data-incorrect-answer",incorrect_answer_label);




        this.container.getElements(".entry").each(function(entryO){
            var entry = entryO.clone(true,true);
            entry.removeClass("active");

            entry.getElement(".entry-title").set("html",entry.getElement(".entry-title input").get("value"));

            entry.getElements(".option-entry:not([data-md-multiple-options-sample])").each(function(option){



                if(option.getElement("input").get("value")!=""){
                    option.getElement(".option-text").set("html",option.getElement("input").get("value"));
                }
                else{
                    option.dispose();
                }

            });

            entry.getElements(".processed:not([data-md-multiple-options-sample])").removeClass("processed");
            entry.getElements(".correct-incorrect-toggle").removeClass("correct-incorrect-toggle");
            entry.getElements(".correct-incorrect-toggle-added").removeClass("correct-incorrect-toggle-added");

            entry.getElements("button").dispose();
            entry.getElements("label").dispose();
            entry.removeAttribute("data-new");

            container.adopt(entry);

        });



        var html = widgetbody.get("html");

        this.saveRequestProcedure(null, {
            method:"setHTML",
            selector:".widget-body",
            html:html
        });


    },
    addAnotherItemClickEventListener:function(ev){
        this.addAnotherItemProcedure();
    },
    addAnotherItemProcedure:function(at){
        //md-data-set-item

        $$(".entry").removeClass("active");

        var template = this.options.itemTemplate;
        var newItem = new Element("div.entry.active",{
            html:template,
            "data-new":1
        });



        if(at==null)
            newItem.inject(this.options.container.getElement("fieldset.entrys-wrapper"));
        else{
            newItem.inject(at,"after");
        }

        this.setPagerEditor(this.options.container.getElement("fieldset.entrys-wrapper").getElements(".entry").indexOf(newItem) + 1);

        this.editMode();

        this.bindEvents();

        this.parseEntryOptions();

        return newItem;
    },
    bindEvents:function(){

    },
    editorOnChangeEventListener:function(el,editorEvent){
        var accordionEntry = el.targetElm.getParents(".tab-accordion-entry");
        this.saveEntry(accordionEntry[0]);
    },
    render: function() {
    }
});