MultipleChoiceV2 = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    // Set initial options here
    options: {
        simple_result_screen: false
    },
    current_question: 0,
    mode: null,
    initialize: function (options) {
        _this = this;
        options.extra = [];
        options.extra.push('data-mode');
        this.parent(options);
        this.mode = $('MetrodigiWidget').get('data-mode');
        if (this.isEditMode) {
            $$('.preview').hide();
            $$('.edit').show();
            this.editMode(0);
            this.questions();
        } else {
            $$('.preview').show();
            $$('.edit').hide();
            this.previewMode();
        }
    },
    navigate: function () {
        $('navigate').empty();
        this.options.data.each(function (item, index) {
            if (item.question !== '' && item.options.length > 1 && item.correctAnswer !== '') {
                var _class = '';
                if (_this.current_question === index) {
                    _class = 'class="active"';
                }
                var html = '<span ' + _class + '></span>';
                $('navigate').appendHTML(html);
            }
        });
    },
    save: function (id) {
        var question = $$('.edit .question .question_area')[0].get('html');
        var feedback = $$('.edit .question .feedback_area')[0].get('html');
        var inputs = $$('.edit .question input');
        var data = this.options.data;
        if (typeof data[id] === 'undefined') {
            data[id] = {};
        }
        data[id].correctAnswer = '';
        data[id].question = question;
        data[id].feedback = feedback;
        inputs.each(function (item) {
            var index = item.getParent().get('data-index');
            if (index == null) {
                index = item.getParent().getParent().get('data-index');
            }
            // Answers
            if (item.hasClass('answer')) {
                var value = item.get('value');
                if (typeof data[id].options === 'undefined') {
                    data[id].options = [];
                }
                if (value !== '') {
                    data[id].options[index] = value;
                }
            }
            if (item.hasClass('radio')) {
                if (item.checked) {
                    data[id].correctAnswer = index;
                }
            }

        });
        this.saveRequest({method: 'mdData', options: {'json': data}});
        this.options.data = data;
        this.validate();
    },
    delay: function (id) {
        clearTimeout(this.timer);
        this.timer = setTimeout(function () {
            _this.save(id);
        }, 500);
    },
    validate: function () {
        var ok = true;
        var questions = this.options.data;
        questions.each(function (item) {
            var count = 0;
            var answers = item.options;
            answers.each(function (answer) {
                if (answer !== '') {
                    count++;
                }
            });
            if (count < 2) {
                ok = false;
            }
            if (item.correctAnswer === '') {
                ok = false;
            }
        });
        if (ok) {
            $('add_question').removeAttribute('disabled');
        } else {
            $('add_question').setAttribute('disabled', 'disabled');
        }
    },
    editEvents: function () {
        $$('.edit .question .question_area, .edit .question .feedback_area').removeEvents(['input']);
        $$('.edit .question .question_area, .edit .question .feedback_area').addEvent('input', function (e) {
            var id = parseInt(this.getParent().get('data-index'));
            _this.delay(id);
        });
        $$('.edit .question input[type="text"]').removeEvents(['keyup']);
        $$('.edit .question input[type="text"]').addEvent('keyup', function (e) {
            var id = parseInt(this.getParent().getParent().getParent().get('data-index'));
            this.getParent().getElement('input[type="radio"]').setStyle('visibility', 'visible');
            _this.delay(id);
        });
        $$('.edit .question input[type="radio"]').removeEvents(['change']);
        $$('.edit .question input[type="radio"]').addEvent('change', function (e) {
            var id = parseInt(this.getParent().getParent().getParent().get('data-index'));
            _this.delay(id);
            _this.validate();
        });

        // Add new row
        $$('.edit .question .new_answer').removeEvents(['click']);
        $$('.edit .question .new_answer').addEvent('click', function () {
            var answers = $$('.edit .question .answers');
            var clone = answers.getElement('li:last-child')[0].clone(true, true);
            var index = parseInt(clone.get('data-index')) + 1;
            clone.setAttribute('data-index', index);
            clone.getElement('input[type="text"]').setAttribute('name', 'answer_' + index);
            clone.setAttribute('value', '');
            var li = new Element('li').adopt(clone).get('html');
            $$('.edit .question .answers').appendHTML(li);
            _this.editEvents();
        });
        // Remove
        $$('.edit .question .remove').removeEvents(['click']);
        $$('.edit .question .remove').addEvent('click', function (e) {
            e.preventDefault();
            var empty = false;
            var li = this.getParent();
            var input = li.getElement('input[type="radio"]');
            if (input.checked === true) {
                empty = true;
            }
            var inputs = $$('.edit .answers input[type="text"]');
            var count = 0;
            inputs.each(function (input) {
                if (input.get('value') !== '') {
                    count++;
                }
            });
            if (count <= 2) {
                alert('You need minimum 2 answers for a question.');
                return false;
            }
            var ok = confirm('Are you sure you want to delete?');
            if (ok) {
                var index = parseInt(this.getParent().get('data-index'));
                var data = _this.options.data;
                data.each(function (item, main_index) {
                    if (_this.current_question === main_index) {
                        item.options.each(function (answer, _index) {
                            if (index === _index) {
                                data[main_index].options.splice(_index, 1);
                                if (empty) {
                                    data[main_index].correctAnswer = '';
                                }
                                _this.saveRequest({method: 'mdData', options: {'json': data}});
                                _this.options.data = data;
                                return false;
                            }
                        });
                        return false;
                    }
                });
                li.remove();
                var lis = $$('.edit ul.answers li');
                lis.each(function (li, index) {
                    li.setAttribute('data-index', index);
                });
                _this.validate();
            }
        });
        // Add new question
        $('add_question').removeEvents(['click']);
        $('add_question').addEvent('click', function (e) {
            e.preventDefault();
            _this.new_question();
            _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
            _this.editMode(_this.current_question + 1);
            _this.questions();
            _this.navigate();
        });

        // Remove Question
        $$('.edit .remove_question button').removeEvents(['click']);
        $$('.edit .remove_question button').addEvent('click', function () {
            var ok = confirm('Are you sure you want to delete the whole question?');
            if (ok) {
                _this.options.data.splice(_this.current_question, 1);
                var index = _this.current_question - 1;
                if (index < 0) {
                    index = 0;
                    _this.new_question();
                }
                _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
                _this.editMode(index);
                _this.questions();
                _this.navigate();
            }
        });

    },
    new_question: function () {
        var new_question = {};
        new_question.question = '';
        new_question.correctAnswer = '';
        new_question.options = [];
        new_question.type = 'multipleChoice';
        new_question.feedback = '';
        this.options.data.push(new_question);
    },
    questions: function () {
        var questions = $$('.edit .questions ul')[0];
        questions.empty();
        this.options.data.each(function (item, _index) {
            var li = new Element('li');
            var a = new Element('a', {html: _index + 1, href: '#'}).inject(li);
            a.setAttribute('data-index', _index);
            if (_this.current_question === _index) {
                a.setAttribute('class', 'active');
            }
            li.inject(questions);
        });

        $$('.edit .questions ul a').addEvent('click', function (e) {
            e.preventDefault();
            var index = parseInt(this.get('data-index'));
            $$('.edit .questions ul a').removeClass('active');
            this.addClass('active');
            _this.editMode(index);
        });

    },
    // Edit Mode Main View Render
    editMode: function (id) {
        this.current_question = id;
        if (this.options.data.length === 0) {
            this.new_question();
        }
        this.options.data.each(function (item, index) {
            if (id === index) {
                var question = new Element('div.question');
                question.setAttribute('data-index', index);
                var number = index + 1;
                new Element('div.remove_question', {html: '<button>Remove Question</button>'}).inject(question);
                new Element('div.top', {html: 'Question ' + number}).inject(question);
                var question_area = new Element('div.question_area', {html: item.question}).inject(question);
                question_area.setAttribute('contenteditable', 'true');
                new Element('div.feedback_header', {html: 'Optional Feedback'}).inject(question);
                var feedback_area = new Element('div.feedback_area', {html: item.feedback}).inject(question);
                feedback_area.setAttribute('contenteditable', 'true');
                var answers = new Element('ul.answers');
                var next = 0;
                item.options.each(function (answer, _index) {
                    var li = new Element('li');
                    li.setAttribute('data-index', _index);
                    new Element('span', {html: 'Possible Answer'}).inject(li);
                    var input = new Element('input.answer', {value: answer, name: 'answer_' + _index, type: 'text'}).inject(li);
                    input.setAttribute('value', answer);
                    input.setStyle('width', '388px');
                    var radio = new Element('input.radio', {name: index, type: 'radio'});
                    if (parseInt(item.correctAnswer) === _index) {
                        radio.setAttribute('checked', 'checked');
                    }
                    if (answer !== '') {
                        radio.setStyle('visibility', 'visible');
                    }
                    radio.inject(li);
                    var a = new Element('a.remove', {html: '<i class="fa fa-times"></i>', title: 'Remove'}).inject(li);
                    li.inject(answers);
                    next = _index + 1;
                });
                var li = new Element('li');
                li.setAttribute('data-index', next);
                new Element('span', {html: 'Possible Answer'}).inject(li);
                var input = new Element('input.answer', {name: 'answer_' + next, value: '', type: 'text'}).inject(li);
                input.setStyle('width', '388px');
                new Element('input.radio', {name: 0, type: 'radio'}).inject(li);
                new Element('a.remove', {html: '<i class="fa fa-times"></i>', title: 'Remove'}).inject(li);
                li.inject(answers);
                new Element('div.correct_answer', {html: 'Correct<br />Answer'}).inject(question);
                answers.inject(question);
                new Element('div.new_answer', {html: '+ Add Possible Answer'}).inject(question);
                var html = new Element('div').adopt(question).get('html');
                $('question_content').set('html', html);
                return false;
            }
        });
        this.editEvents();
        this.validate();
    },
    previewMode: function () {
        $$('.explanation').hide();
        $$('button.next')
                .set('disabled', 'disabled')
                .addEvent(this.clickEvent, function () {
                    _this.nextHandler();
                });
        $$('button.feedbackBtn')
                .hide()
                .addEvent(this.clickEvent, function () {
                    _this.prepResults();
                });
        $$('button.prev')
                .set('disabled', 'disabled')
                .addEvent(this.clickEvent, function () {
                    _this.prevHandler();
                });
        $$('button.reset')
                .hide()
                .addEvent(this.clickEvent, function () {
                    _this.resetHandler();
                });
    },
    createDOM: function () {
        this.data_questions = this.options.data.length;
        this.counter = 0;

    },
    nextHandler: function () {
        $$('.multiple-choice .widget-footer .options .result_message').hide();
        this.counter++;
        this.current_question = this.counter;

        $$('.feedback')[0]
                .empty()
                .appendHTML('Question ' + (this.counter + 1) + ' of ' + this.data_questions);

        $$('ol#questions .wrapper').each(function (el, i) {
            if (i !== _this.counter) {
                el
                        .hide()
                        .removeClass('active');

                el.getElements('input').each(function (el) {
                    el.removeClass('filled');
                })
            } else {
                el
                        .show()
                        .addClass('active');
            }
        });

        $$('button.next').set('disabled', true);

        //this.updateProgress(this.counter);
        this.optionsHandler();

    },
    prevHandler: function () {
        $$('.multiple-choice .widget-footer .options .result_message').hide();
        this.counter--;
        this.current_question = this.counter;
        $$('.feedback')[0]
                .empty()
                .appendHTML('Question ' + (this.counter + 1) + ' of ' + this.data_questions);

        $$('ol#questions .wrapper').each(function (el, i) {
            if (i !== _this.counter) {
                el
                        .hide()
                        .removeClass('active');
            } else {
                el
                        .show()
                        .addClass('active');
            }
        });

        $$('button.next')
                .set('disabled', 'disabled');


        //this.updateProgress(this.counter);
        this.optionsHandler();
    },
    feedbackDots: function (counterNum) {
        $$('.number-of-questions .n-wrapper').each(function (el, i) {
            if (i !== counterNum) {
                el.getElement('.fa').removeClass('active');
            } else {
                el.getElement('.fa').addClass('active');
            }
        });
    },
    prepResults: function () {
        $$('ol#questions').hide();
        $$('.explanation').show();
        $$('button.feedbackBtn').hide();
        $$('button.reset').show();
        $$('button.prev').set('disabled', true);
        $$('.feedback')[0]
                .empty()
                .appendHTML('Quiz Complete');

        $$('.number-of-questions').hide();


        $$('ol#questions .wrapper').each(function (el, i) {
            var wrapper = new Element('div.wrapper').inject($$('.explanation .result')[0]);

            // construct the question
            var question = el.getElement('.question p').innerHTML;

            if (el.hasClass('fitb')) {
                wrapper.addClass('fitb');
                var q = new Element('div.question').inject(wrapper);
                var input_arr = [];

                var sentence = Array.prototype.slice.call(el.querySelectorAll('.question p > *')).map(function (node) {
                    if (node.nodeName === 'input') {
                        var inputAnswer = '';
                        input_arr.push(node.value);
                        _this.options.data.each(function (data, i_i) {
                            if (i === i_i) {
                                userAnswer = input_arr[input_arr.length - 1];
                                var correctAnswer = data.answers[input_arr.length - 1];
                                if (correctAnswer.toLowerCase() === userAnswer.toLowerCase().replace(/^\s+|\s+$/g, "")) {
                                    inputAnswer = '<span class="answer"><span class="correct"><i class="fa fa-check"></i> ' + correctAnswer + '</span></span>';
                                } else {
                                    inputAnswer = '<span class="answer"><span class="incorrect"><i class="fa fa-times"></i> ' + node.value + '</span><span class="correct"><i class="fa fa-check"></i> ' + correctAnswer + '</span></span>';
                                }
                            }
                        });
                        return inputAnswer;
                    } else {
                        return node.outerHTML;
                    }
                }).join(' ');

                q.appendHTML('<p>' + sentence + '</p>');

            } else {
                new Element('div.question')
                        .appendHTML('<p>' + question + '</p>')
                        .inject(wrapper);

                // construct answer
                var answer = new Element('div.answer').inject(wrapper);
                var userAnswer = el.getElement('input[type="radio"]:checked').get('value');
                var userNum = parseInt(el.getElement('input[type="radio"]:checked').get('data-num'));
                var index = parseInt(el.get('data-id'));
                var correctAsnwer = parseInt(_this.options.data[index].correctAnswer);
                if (correctAsnwer === userNum) {
                    _this.resultCorrectAnswer(userAnswer, answer);
                } else {
                    _this.resultIncorrectAnswer(userAnswer, correctAsnwer, answer);
                }

                // textarea
                if (el.getElement('textarea')) {
                    answer.appendHTML(el.getElement('textarea').value);
                    answer.addClass('textarea-response');
                }

                if (_this.options.data[index].feedback !== '') {
                    var feedbackWrapper = new Element('div.feedbackText').inject(wrapper);
                    new Element('p')
                            .appendHTML('<span class="title">ANSWER:</span> ' + _this.convertBracketTags(_this.options.data[index].feedback))
                            .inject(feedbackWrapper);
                }

            }
        });


    },
    resultCorrectAnswer: function (userAnswer, answer) {
        answer
                .appendHTML('<div class="correct"><i class="fa fa-check"></i> ' + userAnswer + '</div>')
    },
    resultIncorrectAnswer: function (userAnswer, correctAnswer, answer) {
        answer.appendHTML('<div class="incorrect"><i class="fa fa-times"></i> ' + userAnswer + '</div>');
        //answer.appendHTML('<div class="correct"><i class="fa fa-check"></i> ' + correctAnswer + '</div>');
    },
    convertBracketTags: function (thisText) {
        thisText = thisText.replace(/(?:\r\n|\r|\n)/g, '<br />');
        thisText = thisText.replace(/\[(.*?)\]/g, "<$1>");
        thisText = thisText.replace("lbrack", "[");
        thisText = thisText.replace("rbrack", "]");

        return thisText;
    },
    immidiate: function (e) {
        var input = e.target.getParent().getParent().getElement('input');
        var index = parseInt(input.get('data-num'));
        var correct = parseInt(this.options.data[this.current_question].correctAnswer);
        var parent = input.getParent();
        var button = $$('.multiple-choice .widget-footer .options .result_message');
        var blocks = parent.getParent().getElements('.block');
        var wrapper = blocks.getParent();
        blocks.removeClass('correct');
        blocks.removeClass('incorrect');
        if (correct === index) {
            button.set('text', 'Nice Job!');
            parent.addClass('correct');
        } else {
            button.set('text', 'Try Again');
            parent.addClass('incorrect');
        }
        button.setStyle('display', 'inline-block');
        button.removeEvents(['click']);
        button.addEvent('click', function () {
            blocks.removeClass('correct');
            blocks.removeClass('incorrect');
            button.hide();
            if ($$('.feedback_immediate').length > 0) {
                $$('.feedback_immediate')[0].remove();
            }
            input.checked = false;
        });
        var feedback = this.options.data[this.current_question].feedback;
        if (feedback !== '') {
            if ($$('.feedback_immediate').length > 0) {
                $$('.feedback_immediate')[0].remove();
            }
            wrapper.appendHTML('<div class="feedback_immediate"><span>Feedback:</span> ' + feedback + '</div>');
        }
    },
    optionsHandler: function (e) {
        if (this.mode === 'immediate' && typeof e !== 'undefined') {
            this.immidiate(e);
        }
        var counter = 0;

        var total_questions = $$('ol#questions .wrapper').length;

        counter += $$('ol#questions .wrapper input[type="radio"]:checked').length;

        // check all textarea
        $$('ol#questions .wrapper textarea').each(function (el) {
            if (el.value !== '') {
                counter++;
            }
        });

        // check fill in the blank
        $$('ol#questions .wrapper.fitb').each(function (el) {
            var total_fitb = 0;
            var total_filled = 0;

            el.getElements('input').each(function (opt) {
                total_fitb++;
                if (opt.value !== '') {
                    total_filled++;
                }
            });
            if (total_fitb === total_filled) {
                counter++;
            }
        });

        if (counter === total_questions) {
            if (this.mode === 'delayed') {
                $$('button.feedbackBtn').show();
            }

            if (this.counter < total_questions - 1) {
                $$('button.next').set('disabled', false);
            } else {
                $$('button.next').set('disabled', true);
            }
        }

        // enabling next button
        $$('ol#questions .wrapper.active.fitb input').each(function (el) {
            if (el.value !== '') {
                el.addClass('filled');
            }
        });

        if ($$('ol#questions .wrapper.active input[type="radio"]:checked').length === 1) {
            if (counter != total_questions) {
                $$('button.next')
                        .set('disabled', '');
                this.updateProgress(this.counter);
            }
        }

        var fitb_active_length = $$('ol#questions .wrapper.active.fitb input').length;
        if (fitb_active_length > 0 && fitb_active_length === $$('ol#questions .wrapper.active.fitb input.filled').length) {
            $$('button.next').set('disabled', '');
            this.updateProgress(this.counter);
        }

        if ($$('ol#questions .wrapper.active textarea')[0] !== undefined && $$('ol#questions .wrapper.active textarea')[0].value !== '') {

            if (counter != total_questions) {
                $$('button.next')
                        .set('disabled', '');
                this.updateProgress(this.counter);
            }

            //$$('button.next').set('disabled', '');

        }

        // enabling back button
        if (this.counter > 0) {
            $$('button.prev').set('disabled', false);
        } else {
            $$('button.prev').set('disabled', true);
        }
        this.navigate();

    },
    resetHandler: function () {
        location.reload();
    },
    render: function () {
        if (!this.isEditMode) {
            this.options.data.each(function (el, i) {
                if (el.question !== '' && el.options.length > 1 && el.correctAnswer !== '') {
                    var wrapper = new Element('div.wrapper')
                            .set('data-id', i)
                            .hide()
                            .removeClass('active')
                            .inject($$('ol#questions')[0]);

                    new Element('div.n-wrapper')
                            .appendHTML('<i class="fa fa-circle"></i>')
                            .inject($$('.number-of-questions')[0]);

                    switch (el.type) {
                        case 'trueFalse':
                            _this.generateQuestion(el.question, i, wrapper, 'tf');
                            return _this.answerOptions(['true', 'false'], wrapper, i);
                            break;
                        case 'multipleChoice':
                            _this.generateQuestion(el.question, i, wrapper, 'mc');
                            return _this.answerOptions(el.options, wrapper, i);
                            break;
                        case 'shortAnswer':
                            _this.generateQuestion(el.question, i, wrapper);
                            new Element('div.block')
                                    .appendHTML('<textarea rows="4" cols="50"></textarea>')
                                    .addEvent('keyup', function () {
                                        _this.optionsHandler();
                                    })
                                    .inject(wrapper);
                            break;
                        case 'fillInTheBlank':
                            wrapper.addClass('fitb');
                            return _this.fillInTheBlank(el.question, wrapper, i);
                            break;
                    }
                }
            });

            this.feedbackDots(this.counter);
            //this.updateProgress(this.counter);

            $$('ol#questions div.wrapper[data-id="' + this.counter + '"]')
                    .addClass('active')
                    .show();

            $$('.feedback')[0]
                    .empty()
                    .appendHTML('Question ' + (this.counter + 1) + ' of ' + this.data_questions);
            this.navigate();
        }
    },
    updateProgress: function (counter) {

        /*step = counter + 1;
         
         percentage = step * 100 / this.options.data.length;
         
         $$('.progress-bar').setStyle('width', percentage + '%');*/

    },
    generateQuestion: function (question, i, wrapper, wrapperClass) {
        wrapper.addClass(wrapperClass);

        new Element('div.question')
                .appendHTML('<p><span class="num">' + (i + 1) + '. </span>' + question + '</p>')
                .inject(wrapper);
    },
    answerOptions: function (answerOptions, wrapper, i) {
        var options_wrapper = new Element('div.option').inject(wrapper);

        answerOptions.each(function (el, i_i) {
            var answerWrapper = new Element('div.block').inject(options_wrapper);

            var input = new Element('input')
                    .set('type', 'radio')
                    .set('id', 'q-' + i + '-' + i_i)
                    .set('name', 'q-' + i)
                    .set('value', el)
                    .set('data-num', i_i)
                    .inject(answerWrapper)
                    .addEvent(_this.clickEvent, function (e) {
                        e.preventDefault();
                        _this.optionsHandler();
                    });

            var label = new Element('label')
                    .set('for', 'q-' + i + '-' + i_i)
                    .inject(answerWrapper);

            new Element('span')
                    .set('tabindex', 0)
                    .addEvents({
                        'keyup': function (e) {
                            e.preventDefault();
                            if (e.key === 'space') {
                                input.checked = true;
                                _this.optionsHandler(e);
                            }
                        },
                        'click': function (e) {
                            e.preventDefault();
                            input.checked = true;
                            _this.optionsHandler(e);
                        }
                    }).inject(label);

            new Element('span')
                    .appendHTML(el)
                    .inject(label).addEvent('click', function (e) {
                input.checked = true;
                _this.optionsHandler(e);
            });
        });
    },
    fillInTheBlank: function (question, wrapper, i) {
        var q = new Element('div.question').inject(wrapper);
        var p = new Element('p').inject(q);

        new Element('span.num')
                .appendHTML((i + 1) + '. ')
                .inject(p);

        question.each(function (el, i_i) {
            if (el === 'fill') {
                new Element('input')
                        .set('type', 'text')
                        .set('data-num', i_i)
                        .inject(p)
                        .addEvent('keyup', function () {
                            _this.optionsHandler();
                        });

            } else {
                new Element('span')
                        .appendHTML(el)
                        .inject(p);
            }
        });
    }
});