MultipleChoice = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    // Set initial options here
    options: {

    },
		
		total_questions: 34,
		current_question: 0,
		score:0,
		scoring_base : 72,
		score_step1: [],
		score_step2: [],
		score_range_low: 'Low',
		score_range_mid: 'Moderate',
		score_range_high: 'High',

    initialize: function(options) {
			this.parent(options);
			
			
			this.title = this.container.getElement('.title');
			
			this.explanationContainer = this.container.getElement('.explanation');
			this.explanationContainer.hide();
			
			this.testContainer = this.container.getElement('.test');
			this.testContainer.show();
			
			this.resetEl = this.container.getElement('.reset');
			this.resetEl.addEvent(this.clickEvent, this.reset.bind(this));
			this.resetEl.hide();
			
			this.nextEl = this.container.getElement('.next');
			this.nextEl.addEvent(this.clickEvent, this.nextHandler.bind(this));
			
			this.prevEl = this.container.getElement('.prev');
			this.prevEl.addEvent(this.clickEvent, this.prevHandler.bind(this));
			this.prevEl.hide();
			
			
			this.questions = this.container.getElements('.question');
			this.questions.hide();
			
			this._options = this.container.getElements('input[type="radio"]');
			this._options.addEvent(this.clickEvent, this.optionsHandler.bind(this));
			
			
			this.feedbackEl = this.container.getElement('.feedback');
			
			this.nextEl.set('disabled', 'disabled');
			this.render();
    },
		
		createDOM : function(){
			this.testContainer = this.container.getElement('.test');

			_this = this;
			
			this.options.data.questions.each(function(item, i) {
					var text = item;
					var is_not_a_question = false;
					if(typeof item == "object"){
						text = item.text;
						is_not_a_question = item.notAQuestion || false;
					}
					else{
						text = (i+1) + '.  ' +text;
					}
					var question = new Element('li.question', {
					}).inject(_this.testContainer);
					
					var question = new Element('div.question-text', {
							html: text,
							tabindex : 0,
					}).inject(question);
					
					
					var answers = new Element('div.answers', {
					}).inject(question);
					
					if(!is_not_a_question){
						_this.options.data.answers.each(function(item, j) {
								var answer = new Element('div.option', {
								}).inject(answers);
								var answerButton = new Element('input[type="radio"]', {
									 html : item,
									 'data-qid' : i,
									 'data-value' : j+1,
									 'class' : 'q-'+i,
									 'name' : 'q-'+i+'-'+j,
									 'id' : 'q-'+i+'-'+j,
									 tabindex : 0,
								}).inject(answer);
								var label = new Element('label', {
									 html : item,
									 'for' : 'q-'+i+'-'+j,
								}).inject(answer);
						});
					}
					
			});
			this.parent();
		},
		
		nextHandler : function(){
			this.prevEl.show();
			this.nextEl.set('disabled', 'disabled');
			this.current_question++;
			
			// this.title.hide();
			this.render();
			
			
			
		},
		
		prevHandler : function(){
			this.nextEl.set('disabled', 'disabled');
			this.current_question--;
			this.render();
			question_text = this.questions[this.current_question].getChildren('.question-text');
			question_text[0].focus();
		},
		
		
		optionsHandler :function(e){

			
			option  = e.target;
			other_options = this.container.getElements('.'+option.get('class'));

			other_options.removeProperty('checked');
			option.set('checked', 'checked');
			
			
			value = option.get('data-value');
			
			if(this.options.data.scores.step1.indexOf(this.current_question + 1) != -1){
				this.score_step1[this.current_question] = value;
			}else{
				this.score_step2[this.current_question] = value;
			}
			
			
			this.nextEl.removeProperty('disabled');
			

		},
		prepResults : function(){
			
			score_step1 = this.score_step1.reduce(function(a, b) { return parseInt(a) + parseInt(b); }, 0);
			score_step2 = this.score_step2.reduce(function(a, b) { return parseInt(a) + parseInt(b); }, 0);
			
			this.score = 72 - score_step2 + score_step1;
			
			if(this.score < 98){
				score_range = this.score_range_low;
			}else if(this.score >= 98 && this.score <= 131 ){
				score_range = this.score_range_mid;
			}else{
				score_range = this.score_range_high;
			}
			
			this.container.getElement('.score-number').set('html', this.score);
			this.container.getElement('.score-range').set('html', score_range);
			
		},
		reset : function(){
			this.nextEl.show();
			this.nextEl.set('disabled', 'disabled');
			this.resetEl.hide();
			this.prevEl.hide();
			this.title.show();
			this.feedbackEl.show();
			this.testContainer.show();
			this.explanationContainer.hide();
			this.current_question = 0;
			this.score = 0;
			this.score_step1 = [];
			this.score_step2 = [];
			this.render();
			this._options.removeProperty('checked');
			this.title.focus();
		},
		
    render: function() {
			
			
    	this.parent();
			this.questions.hide();
			
			
			if(this.current_question == this.total_questions){
				this.nextEl.hide();
				this.prevEl.hide();
				this.feedbackEl.hide();
				this.testContainer.hide();
				this.prepResults();
				this.resetEl.show();
				this.explanationContainer.show();
				this.explanationContainer.focus();
			}else{
				this.questions[this.current_question].show();
				if(this.current_question > 0){
					question_text = this.questions[this.current_question].getChildren('.question-text');
					question_text[0].focus();
				}else{
					this.prevEl.hide();
					
				}
				this.feedbackEl.set('html', this.current_question + 1 + ' of ' + this.total_questions);
			}
			
    }
});