StandardImageMap = new Class({
    Implements: [Options, Events],
    objects: [],
    // Set initial options here
    options: {},
    images_loaded: false,

    // scale `image map wrapper` to available height 
    updateImageWrapperHeight: function () {
        var window_height = window.getHeight();
        
        if (window_height === 0) return;

        var widgetImageMapWrapperEl = $$('.widget-imagemap-wrapper')[0];
        var imageMapWrapperEl = $$('.imagemap-wrapper')[0];
        var headerEl = $$('.widget-header');
        var headerHeight = headerEl.length > 0 ? headerEl[0].getHeight() : 0;
        var paddingBottom = 13;

        if (widgetImageMapWrapperEl.hasClass('right')) {
            var imageMapHeight = window_height - (paddingBottom + headerHeight);
            imageMapWrapperEl.setStyle('height', imageMapHeight + 'px');
        }

        if (widgetImageMapWrapperEl.hasClass('bottom')) {
            var imageMapNavigatorEl = document.querySelector('.imagemap-navigator');
            var imageMapHeight = window_height - (paddingBottom + headerHeight + imageMapNavigatorEl.getHeight());
            imageMapWrapperEl.setStyle('height', imageMapHeight + 'px');
        }
    },

    // initialize - widget initialization
    initialize: function (elements, options) {
        var that = this;
        this.setOptions(options);
        this.elements = elements;
        elements.addClass("loading");


        if($$("img").length>0 && that.images_loaded==false){
            var imgs = [];
            $$("img").forEach(function(e){

                imgs.push($$(e).get("src"));
            })
            Asset.images(imgs,{
                onComplete:function(){

                    that.render();
                    that.images_loaded = true;
                }
            })
        } else {
            this.render();
        }
    },
    mobileConsole :function(message , message2){


        if(!$$('.container')[0].getElement('.mobile-console')){
            console_div = new Element('div.mobile-console').inject($$('.container')[0]);
            item = new Element('li.mobile-console-line',{
                html : 'MOBILE CONSOLE INIT'
            }).inject(console_div);
        }else{
            console_div = $$('.container')[0].getElement('.mobile-console');
        }
        item = new Element('li.mobile-console-line',{
            html : message + ' ' + message2
        }).inject(console_div, 'top');
    },
    isMobile : function(){
        var isMobile = false;
        if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(Browser.platform)){
            isMobile = true;
        }
        return isMobile;
    },
    enableBackContent:function(){
        $$('.map-controls-container').set('aria-hidden',"false");
        $$('.imagemap-navigator').set('aria-hidden',"false");
        $$('.image-area').set('aria-hidden',"false");
        $$('.widget-body').set('aria-hidden',"false");
        $$('.widget-imagemap-wrapper .overlays').set('aria-hidden',"false");
        $$('.widget-imagemap-wrapper img').set('aria-hidden',"false");

        $$('.map-controls-container')[0].set('tabindex',-1)
        $$('.imagemap-navigator')[0].set('tabindex',-1)
        $$('.image-area')[0].set('tabindex',-1)
        $$('.imagemap-wrapper img')[0].set('tabindex', -1)
        $$('.widget-body')[0].set('tabindex',-1)
        $$('.widget-imagemap-wrapper .overlays').set('tabindex', 0);
        $$('.widget-imagemap-wrapper img').set('tabindex', 0);

        $$('.widget-body').show();
        $$('.widget-footer').show();
    },
    disableBackContent: function(){
        $$('.map-controls-container').set('aria-hidden',"true");
        $$('.imagemap-navigator').set('aria-hidden',"true");
        $$('.image-area').set('aria-hidden',"true");
        $$('.widget-body').set('aria-hidden',"true");
        $$('.widget-imagemap-wrapper .overlays').set('aria-hidden',"true");
        $$('.widget-imagemap-wrapper img').set('aria-hidden',"true");

        $$('.map-controls-container').set('tabindex',-1);
        $$('.imagemap-navigator').set('tabindex',-1);
        $$('.image-area').set('tabindex',-1);
        $$('.widget-body').set('tabindex',-1);
        $$('.widget-imagemap-wrapper .overlays').set('tabindex',-1);
        $$('.widget-imagemap-wrapper img').set('tabindex',-1);

        $$('.widget-body').hide();
        $$('.widget-footer').hide();
    },
    render: function () {
        new_event = this.isMobile()?"touchstart":"click";

        var _this = this,
            close = function () {
                var popup_close = $$(".popup .close");
                if (popup_close.length > 0) {
                    popup_close.fireEvent("click");
                }
            },
            adjustOverlays = function () {
                var overlays = _this.elements[0].getElement('.overlays');
                if (!overlays) {
                    return false;
                }
                overlayDirection = $$('.image_container')[0].get('data-overlay-direction');
                var imagemap_wrapper = _this.elements[0].getElement('.imagemap-wrapper');
                var img = imagemap_wrapper.getElement('img');
                var img_size = img.getSize();
                overlays.setStyles({
                    width: img_size.x,
                    height: img_size.y,
                    'margin-left': img.offsetLeft
                });
                if (imagemap_wrapper.scrollLeft > 0) {
                    overlays.setStyles({'margin-left': imagemap_wrapper.scrollLeft});
                }
                var slider = _this.elements[0].getElement('.slider');
                var imgs = overlays.getElements('img');
                if (imgs) {
                    imgs.setStyles({
                        width: img_size.x,
                        height: img_size.y
                    });
                    imgs.setStyles({'margin-left': -imagemap_wrapper.scrollLeft});

                }

                if (slider) {
                    slider.style.setProperty('width', (+img_size.x + 24) + 'px', 'important');
                    slider.setStyles({
                        'margin-left': img.offsetLeft - 10
                    });
                }
                if (overlayDirection == 'RTL') {
                    $$('.overlays-inside').addClass('RTL')
                } else {
                    $$('.overlays-inside').addClass('LTR')
                }

            },
            adjustOverlayWidth = function () {
                overlayDirection = $$('.image_container')[0].get('data-overlay-direction');
                if (overlayDirection == 'RTL') {
                    _this.elements[0].getElement('.overlays-inside').setStyle(
                        'width', 100 - parseInt(_this.elements[0].getElement('input.slider').get('value')) + '%');
                    var img = _this.elements[0].getElement('.overlays');
                    var img_size = img.getSize();
                    sliderVal = parseInt(_this.elements[0].getElement('input.slider').get('value'));
                    newLeftMargin = img_size.x * sliderVal / 100
                    _this.elements[0].getElements('.overlays-inside img').setStyle(
                        'left', -newLeftMargin);

                } else {
                    _this.elements[0].getElement('.overlays-inside').setStyle(
                        'width', _this.elements[0].getElement('input.slider').get('value') + '%');

                }
            },

            events = [new_event];


        setInterval(adjustOverlays, 1000);

        this.elements.each(function (element, i) {
            var options = {},
                img = element.getElement("img"),
                imageMap;

            options.zoomStep = 100;
            options.mobileZoomStep = 20;
            options.showZoomControls = element.get('data-show-controls') === "false" ? null : true;
            options.imageUrl = img.get("src");
            options.extraLayer = element.get("data-overlay");
            options.initExtraLayers = element.get("data-visible-extra-layers") === "false" ? false : true;
            options.overlayDirection = element.get("data-overlay-direction") === "RTL" ? "RTL" : "LTR";
            options.overlayData = element.getElements('dl.overlays');
            options.text_left = element.get("data-text-left");
            options.text_right = element.get("data-text-right");
            options.manIcon = (element.get("data-scale-button") == 'false') ? false : element.get("data-scale-button");
            options.hideSlider = element.get("data-hide-slider") === "true";
            options.alt = img.get("alt");
            options.defaultZoom = element.get("data-default-zoom") ? +element.get("data-default-zoom") : element.getDimensions().x;
            options.minZoom = options.defaultZoom;
            options.popupZoom = parseInt(element.get('data-popup-zoom'));
            options.maxZoom = img.get("width");
            options.autoZoom = element.get('data-autozoom');
            options.showNavigator = element.get('data-show-navigator') === "true"; // default is false
            options.controlPosition = element.get('data-controls') ? element.get('data-controls') : "right"; //default is right
            options.i = i;
            options.adjustCallback = !element.get("data-overlay") ? null : function () {
                adjustOverlays();
            }


            if (options.extraLayer) {
                options.extraLayer = options.extraLayer.split(',');
            }

            imageMap = new ModifiedImageMap(element, options);
            imageMap.options.imageEl.options = options;
            imageMap._setZoom = imageMap.setZoom;

            imageMap.setZoom = function (zoomLevel) {
                this._setZoom(zoomLevel);

                if (+zoomLevel <= +this.options.defaultZoom) {
                    this.controlsWrapper.addClass("lock");
                    $$('.widget-imagemap-wrapper .map-controls-container .map-control:nth-child(2)')[0].setProperties({
                        'aria-disabled': 'true',
                        tabindex: -1
                    });
                    $$('.widget-imagemap-wrapper .map-controls-container .map-control:nth-child(3)')[0].setProperties({
                        'aria-disabled': 'true',
                        tabindex: -1
                    });
                }
                else {
                    this.controlsWrapper.removeClass("lock");
                    $$('.widget-imagemap-wrapper .map-controls-container .map-control:nth-child(2)')[0].setProperties({
                        'aria-disabled': 'false',
                        tabindex: 0
                    });
                    $$('.widget-imagemap-wrapper .map-controls-container .map-control:nth-child(3)')[0].setProperties({
                        'aria-disabled': 'false',
                        tabindex: 0
                    });
                }
                if (this.options.extraLayer) {
                    try {
                        var img = this.wrapper.getElement("img"),
                            img_dimensions = img.getComputedSize(),
                            img_position = img.getPosition(element);

                        this.wrapper.getElement(".extra") //on load this is not created
                            .setStyles({
                                left: (img_position.x >= 0) ? img_position.x : 0,
                                "background-image": "url('" + options.extraLayer + "')",
                                "background-size": img_dimensions.width + "px " + img_dimensions.height + "px",
                                "height": img_dimensions.height + "px"
                            });
                    } catch (e) {
                    }
                }
            };

            imageMap.setPan = function (x, y) {
                this.wrapper.scrollTo(x, y);
            };

            imageMap.options.imageEl.addEvent("load", function () {

                var options = this.options,
                    widget_imagemap_wrapper = element.getElement(".widget-imagemap-wrapper"),
                    control_container = widget_imagemap_wrapper.getElement(".map-controls-container"),
                    img_dimensions = this.getComputedSize(),
                    img_position = this.getPosition(element),
                    spacing = 20,
                    person = new Element("div.map-control.man-icon", {
                        html: "Man", "data-i": options.i,
                        tabindex: 0,
                        role: "button"
                    }).inject(control_container),
                    events = [new_event,'keypress'];

                if (imageMap.options.manIcon) {
                    events.each(function (event) {
                        person.addEvent(event, function (e) {
                            if(e.type == 'keypress'){
                                var wasSpacePressed = e.code == 32 || e.which == 32 || e.keyCode == 32;
                                if(!wasSpacePressed) return;
                            }
                            _this.disableBackContent();
                            if (options.manIcon === 'true') {
                                var popup = new Element("div.popup", {
                                    tabindex: 0,
                                    'role':"dialog" ,
                                    'aria-label':"Man" ,
                                    'aria-describedby':"img-desc",
                                    html: "<span aria-label='Close' tabindex='0' role='button' class='close'>×</span><img src='" + imageMap.options.imageUrl + "' id='img-desc' alt='Prevalence of Ritual: Tidings shows a winged figure and woman, with the color black prominent, in the foreground and lighter colored elements such as a train in the background compared next to a six foot man' style='width:" + imageMap.options.popupZoom + "px' />",
                                    styles: {
                                        "margin-left": -imageMap.options.popupZoom / 2 + "px",
                                        "margin-top": -imageMap.options.popupZoom / 2 * img_dimensions.height / img_dimensions.width + "px"
                                    }
                                }).inject(widget_imagemap_wrapper.addClass("popup_open"));
                                events.each(function (event) {
                                    popup.getElement(".close")
                                        .addEvent(event, function (ev) {
                                            if( typeof ev.code != 'undefined' && ['enter', 'space'].indexOf(ev.key) < 0 ){
                                                return;
                                            }
                                            $$(popup).destroy();													//	popup.hide();
                                            _this.enableBackContent();
                                            widget_imagemap_wrapper.removeClass("popup_open");
                                        });
                                });
                                $$('.popup"')[0].focus();
                            }
                            else {
                                var imageObj = new Image();
                                imageObj.src = options.manIcon;
                                imageObj.addEventListener('load', function () {
                                    var popup_max_area = imageMap.options.imageAreaDiv.getSize();
                                    var popup = new Element("div.popup", {
                                        tabindex: 0,
                                        'role':"dialog" ,
                                        'aria-label':"Man" ,
                                        'aria-describedby':"img-desc",
                                        html: "<span aria-label='Close' tabindex='0' role='button' class='close'>×</span><img id='img-desc' alt='Prevalence of Ritual: Tidings shows a winged figure and woman, with the color black prominent, in the foreground and lighter colored elements such as a train in the background compared next to a six foot man' src='" + imageObj.src + "' style='" +
                                        "max-width: " + (popup_max_area.x - 20) + "px; " +
                                        "max-height: " + (popup_max_area.y - 20) + "px;" + "' />",
                                        styles: {
                                            "opacity": 0
                                        }
                                    }).inject(widget_imagemap_wrapper.addClass("popup_open"));
                                    setTimeout(function () {
                                        var popup_size = {
                                            x: parseInt(popup.getStyle('width')),
                                            y: parseInt(popup.getStyle('height'))
                                        };
                                        $$('.popup')[0].setStyles({
                                            "margin-left": -popup_size.x / 2 + "px",
                                            "margin-top": -popup_size.y / 2 + "px",
                                            "opacity": 1
                                        });
                                    }, 100);
                                    events.each(function (event) {
                                        popup.getElement(".close")
                                            .addEvent(event, function (ev) {
                                                if( typeof ev.code != 'undefined' && ['enter', 'space'].indexOf(ev.key) < 0 ){
                                                    return;
                                                }
                                                $$(popup).destroy();
                                                widget_imagemap_wrapper.removeClass("popup_open");
                                                _this.enableBackContent();
                                            });
                                    });
                                    $$('.popup"')[0].focus();
                                }, false);
                            }

                            e.preventDefault();
                            e.stopPropagation();
                        });
                    });
                }
                else {
                    person.hide();
                }

                imageMap.options.defaultZoom = Math.max(imageMap.options.defaultZoom, img_dimensions.height);
                imageMap.options.minZoom = imageMap.options.defaultZoom / 2;
                imageMap.currentZoom = imageMap.options.defaultZoom;

                //var h = widget_imagemap_wrapper.getDimensions().y * img_dimensions.width / img_dimensions.height;
                var wrapper = widget_imagemap_wrapper.addClass(options.controlPosition).getElement(".imagemap-wrapper");
                var myFx = new Fx.Scroll(wrapper);
                var hammertime = new Hammer(wrapper);

                // Enable pinch
                hammertime.get('pinch').set({enable:true});
                hammertime.get('pan').set({ direction: Hammer.DIRECTION_ALL });
                hammertime.on("pinchout", function (e) {
                    imageMap.setZoom(imageMap.currentZoom + imageMap.options.mobileZoomStep);
                }).on("pinchin", function (e) {
                    imageMap.setZoom(imageMap.currentZoom - imageMap.options.mobileZoomStep);
                }).on("panleft panright panup pandown", function (e) {
                    var x = wrapper.getScroll().x - e.deltaX/10;
                    var y = wrapper.getScroll().y - e.deltaY/10;
                    myFx.set(x, y);
                });


                if (options.showNavigator) {
                    var navigator = widget_imagemap_wrapper.getElement(".imagemap-navigator");

                    //remove tabindex
                    navigator.getElement('img').setAttribute('tabindex', -1);

                    navigator
                        .setStyles({
                            height: navigator.getDimensions().x * img_dimensions.height / img_dimensions.width
                        })
                        .getElement(".navigator-view-area")
                        .setStyles({height: 0, top: -9999999999});
                }
                else {
                    var imagemap_wrapper = widget_imagemap_wrapper.getElement(".imagemap-wrapper");
                    widget_imagemap_wrapper.addClass("no-navigator");
                }
                if (options.controlPosition === "right") {
                    control_container
                        .setStyles({
                            top: navigator ? navigator.getElement("img").getDimensions().y : parseInt(this.getStyle("padding-top")) - 5
                        });
                }

                element
                    .removeClass("loading")
                    .getElements(">*")
                    .setStyles({opacity: 1});

                if (options.extraLayer) {
                    var imagemap_wrapper = widget_imagemap_wrapper.getElement(".imagemap-wrapper");
                    var overlays = new Element('div.overlays').inject(imagemap_wrapper);
                    var overlays_inside = new Element('div.overlays-inside').inject(overlays);
                    if (options.overlayData && this.options.extraLayer.length > 1) {
                        var toggle_inputs = new Element('table.toggle-layers').inject(element);
                    }
                    var tr;
                    if (options.initExtraLayers == false) {
                        initExtraLayersStyle = "display:none"
                    } else {
                        initExtraLayersStyle = ""
                    }
                    for (var i = 0; i < this.options.extraLayer.length; i++) {
                        var layer = this.options.extraLayer[i];
                        new Element('img', {
                            src: layer,
                            style: initExtraLayersStyle
                        }).inject(overlays_inside);
                        try {
                            if (options.overlayData && this.options.extraLayer.length > 1) {
                                tr = new Element('tr').grab(
                                    new Element('td.toggle-inputs').grab(
                                        new Element('label', {
                                            html: options.overlayData.getElements('dt')[0][i].get('html')
                                        }).grab(
                                            new Element('input', {
                                                type: 'checkbox',
                                                'data-overlay-id': i,
                                                checked: options.initExtraLayers,
                                                tabindex: 0,
                                                events: {
                                                    change: function () {
                                                        var index = this.get('data-overlay-id');
                                                        $$('.overlays-inside')[0].getElements('img')[index].toggle()
                                                    }
                                                }
                                            }), 'top'
                                        )
                                    )
                                ).grab(
                                    new Element('td.layer-descriptions', {
                                        html: options.overlayData.getElements('dd')[0][i].get('html')
                                    })
                                );
                                tr.inject(toggle_inputs);
                            }
                        }
                        catch (e) {
                            console.error('Invalid overlay data', i, e);
                        }
                    }
                    ;
                    element.addClass('overlay-enabled');
                    if (options.hideSlider) {
                        overlays_inside.addClass('fixed-width');
                    }
                    else {
                        sliderInitVal = 0;
                        if (options.overlayDirection == 'RTL')
                            sliderInitVal = 100;

                        var slider = new Element('input.slider', {
                            type: 'range',
                            min: 0,
                            max: 100,
                            tabindex: 0
                        }).set('value', sliderInitVal).inject(imagemap_wrapper.getParent());
                        slider.addEvents({
                            'input': function () {
                                adjustOverlayWidth(this.get('value'));
                            },
                            'change': function () {
                                adjustOverlayWidth(this.get('value'));
                            }
                        });
                        slider.style.setProperty('max-width', (parseInt($$('.imagemap-wrapper')[0].getSize().x) + 24) + 'px', 'important');
                    }
                }
                
                _this.updateImageWrapperHeight();

                // autozoom
                if (imageMap.options.autoZoom) {
                    // imageMap.options.imageEl.getParent().setStyle('height', null);
                    var container_size = imageMap.options.imageEl.getParent().getSize();

                    // var window_height = window.getHeight();
                    // if (container_size.y > window_height) {
                    //     imageMap.options.imageEl.getParent().setStyle('height', window_height);
                    //     container_size.y = window_height;
                    // }

                    var image_size = {
                        x: imageMap.options.imageEl.naturalWidth,
                        y: imageMap.options.imageEl.naturalHeight
                    };
                    var mod_container_size = {
                        x: container_size.y * (image_size.x / image_size.y),
                        y: container_size.x * (image_size.y / image_size.x)
                    };
                    if (mod_container_size.y > container_size.y) {
                        var x = mod_container_size.x;
                        imageMap.options.minZoom = x;
                        imageMap.options.defaultZoom = x;
                        imageMap.setZoom(x);
                    }
                    else {
                        imageMap.options.minZoom = container_size.x;
                        imageMap.options.defaultZoom = container_size.x;
                        imageMap.setZoom(container_size.x);
                    }
                }
                else if (imageMap.options.defaultZoom) {
                    imageMap.setZoom(imageMap.options.defaultZoom);
                }

            });
            _this.objects.push(imageMap);
        });


        // TODO: refactor this awful hack
        //setTimeout(function(){
        //
        //    new Element("style",{
        //        html:".imagemap-wrapper{height:"+window.getSize().y+"px;}.widget-imagemap-wrapper.bottom .imagemap-wrapper{max-height:"+(window.getSize().y - 100)+"px;}"
        //    }).inject($$("head")[0]);
        //
        //},1000);

        window.addEvent('keyup', function (e) {
            if (e.key === "esc") {
                close();
            }
        });
    }
});

ModifiedImageMap = new Class({
    Implements: [Events, Options],
    options: {
        defaultZoom: 100,
        defaultX: 0,
        defaultY: 0,
        zoomStep: 10,
        minZoom: 0,
        maxZoom: 250,
        left: 0,
        top: 0,
        wrapperEl: null,
        imageEl: null,
        controlsEl: null,
        imageUrl: null,
        showZoomControls: true,
        boundDragToContainer: false,
        showNavigator: false,
        updateNavigatorImmediately: true
    },
    currentZoom: null,
    wrapper: null,
    image: null,
    controlsWrapper: null,
    initialize: function (el, options) {
        // We check the container size and abort if the container element is not the crop size.
        // We try to intialize again on the next turn of the event loop if this is the case.
        // This prevents the Scrollable Image from initializing with a collapsed height and being unusable.
        // var containerSize = el.getSize();
        //       if (containerSize.x !== options.cropWidth || containerSize.y !== options.cropHeight) {
        //           setTimeout(function () { this.initialize.call(this, el, options); }.bind(this), 0);
        //           return;
        //       }

        this.el = el;
        this.setOptions(options);
        var needDomSetup = !options.wrapperEl;
        if (needDomSetup) {
            this.setupDom();
        }
        this.wrapper = this.options.wrapperEl;
        this.image = this.options.imageEl;
        if (this.options.showNavigator) {
            this.addNavigator();
        }
        this.controlsWrapper = this.options.controlsEl;
        this.addControls();

        if (!needDomSetup) {
            this.attachBehavior();
        }

        var ratio;
        if (this.options.defaultZoom == 'autofit') {
            this.options.imageEl.addEvent('load', function () {
                ratio = this.image.naturalHeight / this.image.naturalWidth;
                this.setZoom(this.el.getSize().x * ratio);
            }.bind(this));
        }
    },
    addNavigator: function () {
        this.navigator = this.options.navigatorEl;
        this.navigatorImage = this.image.clone();
        this.navigatorImage.setStyles({'width': '100%'});
        this.navigator.adopt(this.navigatorImage);
        this.navigatorArea = new Element('div', {'class': 'navigator-view-area'});
        this.navigator.adopt(this.navigatorArea);
        this.navigatorArea.makeDraggable({
            container: this.navigator,
            stopPropagation: true,
            preventDefault: true,
            onDrag: function () {
                if (this.options.updateNavigatorImmediately) {
                    this.positionImageArea();
                }
            }.bind(this),
            onComplete: function () {
                this.positionImageArea();
            }.bind(this)
        });
        this.navigatorArea.addEventListener('keydown', this.positionNavigatorAreaKeyboard.bind(this))
        this.navigatorArea.set('tabindex', 0)
    },

    getNavigationRatio: function () {
        return this.navigator ? this.image.width / this.navigator.getSize().x: 1;
    },

    positionNavigatorArea: function () {
        var wrapperSize = this.wrapper.getSize();
        var navigatorRatio = this.getNavigationRatio();

        var navHeightRatio = (wrapperSize.y / navigatorRatio);
        var navHeight = this.navigatorImage ? (this.navigatorImage.height > navHeightRatio ? this.navigatorImage.height : navHeightRatio) : 0;
        // this.navigator.setStyle('height', navHeight + "px");
        if( this.navigatorArea ){
            this.navigatorArea.setStyles({
                'top': (this.wrapper.scrollTop / navigatorRatio) + 'px',
                'left': (this.wrapper.scrollLeft / navigatorRatio) + 'px',
                width: (wrapperSize.x / navigatorRatio) + 'px',
                height: (wrapperSize.y / navigatorRatio) + 'px'
            });
        }
    },

    positionNavigatorAreaKeyboard: function (e) {
        var wasLeftPressed = e.code == 37 || e.which == 37 || e.keyCode == 37;
        var wasRightPressed = e.code == 39 || e.which == 39 || e.keyCode == 39;
        var wasUpPressed = e.code == 38 || e.which == 38 || e.keyCode == 38;
        var wasDownPressed = e.code == 40 || e.which == 40 || e.keyCode == 40;


        var leftDelta
        var topDelta
        if(wasLeftPressed){
            leftDelta = -1
        }
        if(wasRightPressed){
            leftDelta = 1
        }
        if(wasUpPressed) {
            topDelta = -1
        }
        if(wasDownPressed) {
            topDelta = 1
        }
        var wrapperSize = this.wrapper.getSize();
        var navigatorRatio = this.getNavigationRatio();
        //
        var parentHeight = this.navigatorArea.parentNode.offsetHeight
        var parentWidth = this.navigatorArea.parentNode.offsetWidth

        var areaHeight = this.navigatorArea.offsetHeight
        var areaWidth = this.navigatorArea.offsetWidth

        // var navHeight = this.navigatorImage ? (this.navigatorImage.height > navHeightRatio ? this.navigatorImage.height : navHeightRatio) : 0;
        // this.navigator.setStyle('height', navHeight + "px");

        if( this.navigatorArea ){

            var left = Number(this.navigatorArea.style.left.replace('px', '')) + leftDelta
            var top = Number(this.navigatorArea.style.top.replace('px', '')) + topDelta
            if(left < 0) left = 0;
            if(top < 0) top = 0;

            if(left + areaWidth > parentWidth){
                left =  left - Math.abs(left + areaWidth - parentWidth)
            }

            if(top + areaHeight > parentHeight){
                top =  top - Math.abs(top + areaHeight - parentHeight)
            }
            this.navigatorArea.setStyles({
                'top': top + 'px',
                'left': left + 'px',
            });
            if(this.wrapper.scrollTop < 0 ){

            }
            this.positionImageArea()
        }
    },

    positionImageArea: function () {
        var navigatorRatio = this.getNavigationRatio() * 1.1;
        var navPos = this.navigatorArea.getPosition(this.navigator);
        this.wrapper.scrollTo(navPos.x * navigatorRatio, navPos.y * navigatorRatio);
    },

    attachBehavior: function () {
        this.setZoom(this.options.defaultZoom);
        this._resetDrag();
        this.wrapper.scrollTo(this.options.left, this.options.top);
    },

    setUpAriaLive: function() {
        if( $$('.imagemap-wrapper').length > 0 &&  !$$('.imagemap-wrapper')[0].hasClass('aria-announced-binded') ){
            $$('.imagemap-wrapper').setProperties({
                //role: 'region',
                'aria-live': 'polite',
                //'aria-label': 'my label',
                id: 'imagemap-wrapper-region'
                //'aria-controls': 'control-zoom-in-image-text control-zoom-out-image-text'
            });

            $$('.imagemap-wrapper')[0].addClass('aria-announced-binded');

            var contentToBeAnnounced = new Element('div.content-anounced', {
                style: 'position: absolute; left: -1000%; left: -1000vw;'
            });

            contentToBeAnnounced.inject( $$('.imagemap-wrapper')[0] );
            //$$('.imagemap-wrapper')[0].inject(contentToBeAnnounced);
        }
    },

    setImageZoomPercent: function( percent ) {
        this.setUpAriaLive();
        if( $$('.imagemap-wrapper').length > 0 && $$('.imagemap-wrapper')[0].getElement('.content-anounced')){
            if(!isNaN(percent)){
                if(this.options.defaultZoom != this.currentZoom)
                    $$('.imagemap-wrapper')[0].getElement('.content-anounced').set('html', 'Image at '+ (percent <= 100 ? percent : 100) + '%');
            } else {
                $$('.imagemap-wrapper')[0].getElement('.content-anounced').set('html', percent);
            }
        }
    },

    setupDom: function () {
        _this = this;
        _this.setUpAriaLive();
        this.el.empty();
        this.options.wrapperEl = new Element('div', {'class': 'imagemap-wrapper'});
        this.options.imageAreaDiv = new Element('div.image-area');
        var size = this.el.getSize();
        this.options.wrapperEl.setStyles({
            'position': 'relative', 'overflow': 'hidden',
            'height': size.y + "px"
        });

        var body = document.body,
            scaleFactor = /scale\([0-9.]*\)/gi.test( body.get('style') )?
                '0.'+parseInt( /scale\([0-9.]*\)/gi.exec( body.get('style') )[0].replace(/\D/gi,"") )
            : 1
        ;

        if (!this.options.showNavigator) {
            this.options.wrapperEl.setStyles({'width': size.x/scaleFactor + "px"});
        } else {
            this.el.addClass('navigator-enabled');
        }
        this.options.imageEl = new Element('img', {
            src: this.options.imageUrl
        });

        this.options.imageEl.addEvent('load', function () {
            this.attachBehavior();
            // Reset minzoom if the image and container are both "portrait" orientation.
            // Prevents zoom out to blank areas.  See CHAUC-1060.
            if (this.image.naturalWidth < this.image.naturalHeight && this.el.getSize().x < this.el.getSize().y) {
                this.options.minZoom = (this.el.getSize().x / scaleFactor) / this.image.naturalWidth * this.image.naturalHeight;
            }

            if (this.options.showNavigator) {
                this.positionNavigatorArea();
            }
            if (this.options.adjustCallback) {
                this.options.adjustCallback();
            }

        }.bind(this));
        this.options.wrapperEl.adopt(this.options.imageEl);

        this.options.controlsEl = new Element('div');
        var widgetWrapperEl = new Element('div', {'class': 'widget-imagemap-wrapper'});
        widgetWrapperEl.adopt(this.options.imageAreaDiv.adopt(this.options.wrapperEl));

        if (this.options.showNavigator) {
            this.options.navigatorEl = new Element('div.imagemap-navigator').inject(widgetWrapperEl);
        }

        widgetWrapperEl.adopt(this.options.controlsEl);
        this.el.adopt(widgetWrapperEl);

        //accesibility
        var mainImage = widgetWrapperEl.getElement('.image-area img');
        mainImage.setAttribute('tabindex', 0);

        var mainImageFile = mainImage.getAttribute('src');
        if(typeof accessibility_data != 'undefined'){
            accessibility_data.images.each(function (image, index){
                altPath = 'images/' + image.src;

                if (altPath == mainImageFile) {
                    mainImage.setAttribute('alt', image.alt);
                }
            });
        }

        /*
        if (this.el.get('data-touchscreen') === 'true') {
            _this.attachTouchBehaviors();
            _this.preventContainerToucheEvents();
        }
        */

        //if (document.getElement('body').get('touch-device')) {
        //    _this.attachTouchBehaviors();
        //}

        _this.preventContainerToucheEvents();
    },
    addControls: function () {
        var createControl = function (text, isPlus, label, describedby) {
            var controlEl = new Element('div', {
                'class': 'map-control',
                'aria-label': label,
                //'aria-describedby': describedby,
                'aria-controls': 'imagemap-wrapper-region',
                role: 'button',
                'text': text,
                'tabindex': 0,
                id: 'control-'+describedby
            });
            controlEl.addEvent('click', function (e) {
                e.stop();
                var zoom = this.currentZoom;
                if (isPlus) {
                    zoom = zoom + this.options.zoomStep;
                } else {
                    zoom = zoom - this.options.zoomStep;
                }
                
                this.setZoom(zoom);
                //vickoman Fix
                this.positionNavigatorArea();
            }.bind(this));
            controlEl.addEvent('keydown', function (e) {
                var wasSpacePressed = e.code == 32 || e.which == 32 || e.keyCode == 32;
                var wasEnterPressed = e.code == 32 || e.which == 32 || e.keyCode == 32;
                if (wasSpacePressed || wasEnterPressed) {
                    this.fireEvent('click', e);
                }
            });
            return controlEl;
        }.bind(this);

        this.controlsWrapper.addClass('map-controls-container');
        this.controlsWrapper.adopt(createControl('+', true, 'Zoom in', 'zoom-in-image-text'));
        this.controlsWrapper.adopt(createControl('-', false, 'Zoom out', 'zoom-out-image-text'));
        this.controlsWrapper.adopt(new Element('div', {
            'class': 'map-control',
            html: '&#8635;',
            style: 'margin-top: 5px',
            'aria-label': 'Reset',
            //'aria-describedby': 'reset-image-text',
            role: 'button',
            tabindex: 0,
            events: {
                click: function (e) {
                    this.setZoom(this.options.defaultZoom);
                    this.setImageZoomPercent('Zoom reset.');
                    this.wrapper.scrollTop = 0;
                    this.wrapper.scrollLeft = 0;
                    if (this.options.showNavigator) {
                        this.positionNavigatorArea();
                    }
                    if (this.options.adjustCallback) {
                        this.options.adjustCallback();
                    }
                }.bind(this),
                keyup: function (e) {
                    var wasSpacePressed = e.code == 32 || e.which == 32 || e.keyCode == 32;
                    var wasEnterPressed = e.code == 13 || e.which == 13 || e.keyCode == 13;
                    if (wasSpacePressed || wasEnterPressed) {
                        this.fireEvent('click', e);
                    }
                }
            }
        }));

        this.controlsWrapper.adopt(new Element('div', {
            id: 'reset-image-text',
            tabindex: -1,
            role: 'region',
            'aria-expanded': 'true',
            html: 'Reset',
            styles: {
                display: 'none'
            }
        }));
        this.controlsWrapper.adopt(new Element('div', {
            id: 'zoom-in-image-text',
            tabindex: -1,
            role: 'region',
            'aria-expanded': 'true',
            html: 'Zoom In',
            styles: {
                display: 'none'
            }
        }));
        this.controlsWrapper.adopt(new Element('div', {
            id: 'zoom-out-image-text',
            tabindex: -1,
            role: 'region',
            'aria-expanded': 'true',
            html: 'Zoom Out',
            styles: {
                display: 'none'
            }
        }));

        if (!this.options.showZoomControls) {
            this.controlsWrapper.setStyle('display', 'none');
        }

        if (document.getElement('body').get('touch-device')) {
            this.controlsWrapper.getElements('div.map-control').each(function (el, i) {
                if (i <= 1) {
                    el.hide();
                }
            });
        }
    },
    _resetZoom: function () {
        _this = this;
        var body = document.body,
            scaleFactor = /scale\([0-9.]*\)/gi.test( body.get('style') )?
                '0.'+parseInt( /scale\([0-9.]*\)/gi.exec( body.get('style') )[0].replace(/\D/gi,"") )
            : 1
        ;
        var imageSize = this.image.getSize();
        var useWidth = false;
        var zoomWidth = this.currentZoom;
        var zoomHeight = this.currentZoom;
        if (useWidth) {
            zoomWidth = zoomHeight * this.image.naturalWidth / this.image.naturalHeight;
        } else {
            zoomHeight = zoomWidth * this.image.naturalHeight / this.image.naturalWidth;
        }

        var yDiff = Math.floor(zoomHeight - imageSize.y) / 2;
        var xDiff = Math.floor(zoomWidth - imageSize.x) / 2;
        var scrollTop = this.wrapper.scrollTop;
        var scrollLeft = this.wrapper.scrollLeft;

        this.image.setStyle('width', (zoomWidth/scaleFactor) + 'px');
        this.image.setStyle('height', (zoomHeight/scaleFactor) + 'px');


        if(typeof this.newX != 'undefined' && typeof this.newY != 'undefined'){
            this.image.setStyle('-webkit-transform', 'translate('+ $$('.imagemap-wrapper img')[0].getPosition().x +'px, '+ $$('.imagemap-wrapper img')[0].getPosition().y +'px)');
        }

        if(parseInt(this.image.getHeight()) == parseInt(this.options.wrapperEl.getHeight())){
            this.image.style.webkitTransform = '';
        }

    },
    setZoom: function (zoomLevel, zoomStep) {
        if (zoomLevel > this.options.maxZoom) {
            this.currentZoom = this.options.maxZoom;
        } else if (zoomLevel < this.options.minZoom) {
            this.currentZoom = this.options.minZoom;
        } else {
            this.currentZoom = zoomLevel;
        }

        if (/iPad/i.test(navigator.userAgent) || !/Mobile/i.test(navigator.userAgent)) {
            //this.newX = '';
            //this.newY = '';
            this._resetZoom();
        }
        if ($$('.imagemap-wrapper')) {
            if (this.options.showNavigator) {
                this.positionNavigatorArea();
            }
            this.setImageZoomPercent( (100*zoomLevel/this.options.maxZoom).toFixed(0)  );
        }
    },
    setPan: function (x, y) {
        this.wrapper.scrollTo(x, y);
    },
    _resetDrag: function () {
        if (this.drag) {
            this.drag.drag.detach();
        }
        this.drag = new DragScroll(this.wrapper, {
            axis: {x: true, y: true},
            friction: 100,
            boundDragToContainer: this.options.boundDragToContainer,
            stopPropagation: true,
            onDrag: function () {
                if ($$('.imagemap-wrapper')) {
                    this.positionNavigatorArea();
                }
                if (this.options.adjustCallback) {
                    this.options.adjustCallback();
                }
            }.bind(this),
            onComplete: function () {
                if (this.options.showNavigator) {
                    this.positionNavigatorArea();
                }
                if (this.options.adjustCallback) {
                    this.options.adjustCallback();
                }
            }.bind(this)
        });
    },

    prevent_left_scroll:false,
    prevent_right_scroll:false,
    prevent_top_scroll:false,
    prevent_bottom_scroll:false,

    preventContainerToucheEvents: function(){
        $$('.imagemap-wrapper')[0].addEvent('touchstart', function(e){
            e.preventDefault();
            e.stopPropagation();
            return false;
        });
        $$('.image-area')[0].addEvent('touchstart', function(e){
            e.preventDefault();
            e.stopPropagation();
            return false;
        });
        $$('.widget-imagemap-wrapper')[0].addEvent('touchstart', function(e){
            e.preventDefault();
            e.stopPropagation();
            return false;
        });
        $$('image').addEvent('touchstart', function(e){
            e.preventDefault();
            e.stopPropagation();
            return false;
        });
    },

    attachTouchBehaviors: function () {
        _this = this;
        $$('.imagemap-navigator').hide();

        var imageWrapper = $$('.imagemap-wrapper');
        var image = imageWrapper.getElement('img');
        var startX, startY, curX, curY;
        var orgImageWidth = image[0].getBoundingClientRect();

        image.addEvent('touchstart', touchStart, false);

        function touchStart(e) {
            e.preventDefault();
            if (typeof curX === 'undefined') {
                startX = e.targetTouches[0].pageX;
                startY = e.targetTouches[0].pageY;
            } else {
                startX = e.targetTouches[0].pageX - curX;
                startY = e.targetTouches[0].pageY - curY;
            }

            image.addEvent('touchmove', touchMove, false);
        }

        function touchMove(e) {
            if(_this.options.minZoom != _this.currentZoom){

                var imageWrapper_v = imageWrapper[0].getBoundingClientRect();
                var image_v = image[0].getBoundingClientRect();

                e.preventDefault();

                curX = e.targetTouches[0].pageX - startX;
                curY = e.targetTouches[0].pageY - startY;

                range = 300;

                if(parseInt(image[0].getBoundingClientRect().right) - range < parseInt(imageWrapper[0].getBoundingClientRect().left) && _this.prevent_left_scroll == false){
                    _this.prevent_left_scroll = true;
                    last_curX = curX;
                }

                if(parseInt(image[0].getBoundingClientRect().left) > parseInt(imageWrapper[0].getBoundingClientRect().right) - range && _this.prevent_right_scroll == false){
                    _this.prevent_right_scroll = true;
                    last_curX = curX;
                }

                if(parseInt(image[0].getBoundingClientRect().bottom) - range < parseInt(imageWrapper[0].getBoundingClientRect().top) && _this.prevent_top_scroll == false){
                    _this.prevent_top_scroll = true;
                    last_curY = curY;
                }

                if(parseInt(image[0].getBoundingClientRect().top) > parseInt(imageWrapper[0].getBoundingClientRect().bottom) - range && _this.prevent_bottom_scroll == false){
                    _this.prevent_bottom_scroll = true;
                    last_curY = curY;
                }

                newX = curX;
                newY = curY;

                if(_this.prevent_left_scroll){
                    newX = last_curX;
                    if(curX > last_curX){
                        newX = curX;
                        _this.prevent_left_scroll = false;
                    }
                }

                if(_this.prevent_right_scroll){
                    newX = last_curX;
                    if(curX < last_curX){
                        newX = curX;
                        _this.prevent_right_scroll = false;
                    }
                }

                if(_this.prevent_top_scroll){
                    newY = last_curY;
                    if(curY > last_curY){
                        newY = curY;
                        _this.prevent_top_scroll = false;
                    }
                }

                if(_this.prevent_bottom_scroll){
                    newY = last_curY;
                    if(curY < last_curY){
                        newY = curY;
                        _this.prevent_bottom_scroll = false;
                    }
                }

                _this.newX = newX;
                _this.newY = newY;

                e.targetTouches[0].target.setStyle('-webkit-transform', 'translate('+ newX +'px, '+newY +'px)');

            }
        }
    }
});

var sum = function (array) {
    var result = 0;
    for (var l = array.length; l--;) result += array[l];
    return result;
};

DragScroll = new Class({

    // We'd like to use the Options Class Mixin
    Implements: [Options, Events],

    // Default options
    options: {
        friction: 5,
        axis: {x: true, y: true},
        boundDragToContainer: false
    },

    initialize: function (element, options) {
        element = this.element = document.id(element);
        this.content = element.getFirst();
        this.setOptions(options);

        // Drag speed
        var prevTime, prevScroll, speed, scroll, timer;
        var timerFn = function () {
            var now = Date.now();
            scroll = [element.scrollLeft, element.scrollTop];
            if (prevTime) {
                var dt = now - prevTime + 1;
                speed = [
                    1000 * (scroll[0] - prevScroll[0]) / dt,
                    1000 * (scroll[1] - prevScroll[1]) / dt
                ];
            }
            prevScroll = scroll;
            prevTime = now;
        };

        // Use Fx.Scroll for scrolling to the right position after the dragging
        var fx = this.fx = new Fx.Scroll(element, {
            transition: Fx.Transitions.Expo.easeOut
        });

        // Set initial scroll
        fx.set.apply(fx, this.limit(element.scrollLeft, element.scrollTop));

        var self = this;
        friction = this.options.friction,
            axis = this.options.axis;

        // Make the element draggable
        var drag = this.drag = new Drag(element, {
            style: false,
            invert: true,
            modifiers: {x: axis.x && 'scrollLeft', y: axis.y && 'scrollTop'},
            stopPropagation: true,
            preventDefault: true,
            onStart: function () {
                // Start the speed measuring
                timerFn();
                timer = setInterval(timerFn, 1000 / 60);
                // cancel any fx if they are still running
                fx.cancel();
            },
            onDrag: function (el, e) {
                self.fireEvent('drag', el, e);
                if (!self.options.boundDragToContainer) {
                    return;
                }
                var elSize = el.getSize();
                var elPosition = el.getPosition();
                var cushion = -5;

                var x = this.mouse.now.x - elPosition.x;
                var y = this.mouse.now.y - elPosition.y;

                if (x <= cushion || x >= elSize.x - cushion || y <= cushion || y >= elSize.y - cushion) {
                    this.stop();
                }
            },
            onComplete: function () {
                // Stop the speed measuring
                prevTime = false;
                clearInterval(timer);
                // Scroll to the new location
                fx.start.apply(fx, self.limit(
                    scroll[0] + (speed[0] || 0) / friction,
                    scroll[1] + (speed[1] || 0) / friction
                ));
                self.fireEvent('complete');
            }
        });

    },

    // Calculate the limits
    getLimit: function () {
        var limit = [[0, 0], [0, 0]], element = this.element;
        var styles = Object.values(this.content.getStyles(
            'padding-left', 'border-left-width', 'margin-left',
            'padding-top', 'border-top-width', 'margin-top',
            'width', 'height'
        )).invoke('toInt');
        limit[0][0] = sum(styles.slice(0, 3));
        limit[0][1] = styles[6] + limit[0][0] - element.clientWidth;
        limit[1][0] = sum(styles.slice(3, 6));
        limit[1][1] = styles[7] + limit[1][0] - element.clientHeight;
        return limit;
    },

    // Apply the limits to the x and y values
    limit: function (x, y) {
        var limit = this.getLimit();
        return [
            x.limit(limit[0][0], limit[0][1]),
            y.limit(limit[1][0], limit[1][1])
        ];
    }

});
