StandardImageMap = new Class({
    Implements: [Options, Events],
    objects: [],
    // Set initial options here
    options: {},

    // initialize - widget initialization
    initialize: function (elements, options) {

        this.setOptions(options);
        this.elements = elements;
        elements.addClass("loading");
        this.render();
    },
    render: function () {
        var _this = this,
            close = function () {
                var popup_close = $$(".popup .close");
                if (popup_close.length > 0) {
                    popup_close.fireEvent("click");
                }
            },
            adjustOverlays = function () {

                if(typeof _this.elements[0] == 'undefined'){
                    return false;
                }

                var overlays = _this.elements[0].getElement('.overlays');
                if (!overlays) {
                    return false;
                }
                overlayDirection = $$('.image_container')[0].get('data-overlay-direction');
                var imagemap_wrapper = _this.elements[0].getElement('.imagemap-wrapper');
                var img = imagemap_wrapper.getElement('img');
                var img_size = img.getSize();
                overlays.setStyles({
                    width: img_size.x,
                    height: img_size.y,
                    'margin-left': img.offsetLeft
                });
                if (imagemap_wrapper.scrollLeft > 0) {
                    overlays.setStyles({'margin-left': imagemap_wrapper.scrollLeft});
                }
                var slider = _this.elements[0].getElement('.slider');
                var imgs = overlays.getElements('img');
                if (imgs) {
                    imgs.setStyles({
                        width: img_size.x,
                        height: img_size.y
                    });
                    imgs.setStyles({'margin-left': -imagemap_wrapper.scrollLeft});

                }

                if (slider) {
                    slider.style.setProperty('width', (+img_size.x + 24) + 'px', 'important');
                    slider.setStyles({
                        'margin-left': img.offsetLeft - 10
                    });
                }
                if (overlayDirection == 'RTL') {
                    $$('.overlays-inside').addClass('RTL')
                } else {
                    $$('.overlays-inside').addClass('LTR')
                }

            },
            adjustOverlayWidth = function () {
                overlayDirection = $$('.image_container')[0].get('data-overlay-direction');
                if (overlayDirection == 'RTL') {
                    _this.elements[0].getElement('.overlays-inside').setStyle(
                        'width', 100 - parseInt(_this.elements[0].getElement('input.slider').get('value')) + '%');
                    var img = _this.elements[0].getElement('.overlays');
                    var img_size = img.getSize();
                    sliderVal = parseInt(_this.elements[0].getElement('input.slider').get('value'));
                    newLeftMargin = img_size.x * sliderVal / 100
                    _this.elements[0].getElements('.overlays-inside img').setStyle(
                        'left', -newLeftMargin);

                } else {
                    _this.elements[0].getElement('.overlays-inside').setStyle(
                        'width', _this.elements[0].getElement('input.slider').get('value') + '%');

                }
            },
            events = ["click", "touchstart"];

        setInterval(adjustOverlays, 1000);

        this.elements.each(function (element, i) {
            var options = {},
                img = element.getElement("img"),
                imageMap;

            options.zoomStep = 100;
            options.showZoomControls = element.get('data-show-controls') === "false" ? null : true;
            options.imageUrl = img.get("src");
            options.extraLayer = element.get("data-overlay");
            options.initExtraLayers = element.get("data-visible-extra-layers") === "false" ? false : true;
            options.overlayDirection = element.get("data-overlay-direction") === "RTL" ? "RTL" : "LTR";
            options.overlayData = element.getElements('dl.overlays');
            options.text_left = element.get("data-text-left");
            options.text_right = element.get("data-text-right");
            options.manIcon = (element.get("data-scale-button") == 'false') ? false : element.get("data-scale-button");
            options.hideSlider = element.get("data-hide-slider") === "true";
            options.alt = img.get("alt");
            options.defaultZoom = element.get("data-default-zoom") ? +element.get("data-default-zoom") : element.getDimensions().x;
            options.minZoom = options.defaultZoom;
            options.popupZoom = parseInt(element.get('data-popup-zoom'));
            options.maxZoom = img.get("width");
            options.autoZoom = element.get('data-autozoom');
            options.showNavigator = element.get('data-show-navigator') === "true"; // default is false
            options.controlPosition = element.get('data-controls') ? element.get('data-controls') : "right"; //default is right
            options.i = i;
            options.adjustCallback = !element.get("data-overlay") ? null : function () {
                adjustOverlays();
            }


            if (options.extraLayer) {
                options.extraLayer = options.extraLayer.split(',');
            }

            imageMap = new ModifiedImageMap(element, options);
            imageMap.options.imageEl.options = options;
            imageMap._setZoom = imageMap.setZoom;

            imageMap.setZoom = function (zoomLevel) {
                this._setZoom(zoomLevel);

                if (+zoomLevel <= +this.options.defaultZoom) {
                    this.controlsWrapper.addClass("lock");
                }
                else {
                    this.controlsWrapper.removeClass("lock");
                }
                if (this.options.extraLayer) {
                    try {
                        var img = this.wrapper.getElement("img"),
                            img_dimensions = img.getComputedSize(),
                            img_position = img.getPosition(element);

                        this.wrapper.getElement(".extra") //on load this is not created
                            .setStyles({
                                left: (img_position.x >= 0) ? img_position.x : 0,
                                "background-image": "url('" + options.extraLayer + "')",
                                "background-size": img_dimensions.width + "px " + img_dimensions.height + "px",
                                "height": img_dimensions.height + "px"
                            });
                    } catch (e) {
                    }
                }
            };

            imageMap.setPan = function (x, y) {
                this.wrapper.scrollTo(x, y);
            };

            imageMap.options.imageEl.addEvent("load", function () {
                var options = this.options,
                    widget_imagemap_wrapper = element.getElement(".widget-imagemap-wrapper"),
                    control_container = widget_imagemap_wrapper.getElement(".map-controls-container"),
                    img_dimensions = this.getComputedSize(),
                    img_position = this.getPosition(element),
                    spacing = 20,
                    person = new Element("div.map-control.man-icon", {
                        html: "Man", "data-i": options.i,
                        tabindex: 0
                    }).inject(control_container),
                    events = ["click", "touchstart"];

                if (imageMap.options.manIcon) {
                    events.each(function (event) {
                        person.addEvent(event, function (e) {
                            if (options.manIcon === 'true') {
                                var popup = new Element("div.popup", {
                                    html: "<span class='close'>X</span><img src='" + imageMap.options.imageUrl + "' style='width:" + imageMap.options.popupZoom + "px' />",
                                    styles: {
                                        "margin-left": -imageMap.options.popupZoom / 2 + "px",
                                        "margin-top": -imageMap.options.popupZoom / 2 * img_dimensions.height / img_dimensions.width + "px"
                                    }
                                }).inject(widget_imagemap_wrapper.addClass("popup_open"));
                                events.each(function (event) {
                                    popup.getElement(".close")
                                        .addEvent(event, function () {
                                            $$(popup).destroy();													//	popup.hide();
                                            widget_imagemap_wrapper.removeClass("popup_open");
                                        });
                                });
                            }
                            else {
                                var imageObj = new Image();
                                imageObj.src = options.manIcon;
                                imageObj.addEventListener('load', function () {
                                    var popup_max_area = imageMap.options.imageAreaDiv.getSize();
                                    var popup = new Element("div.popup", {
                                        html: "<span class='close'>X</span><img src='" + imageObj.src + "' style='" +
                                            "max-width: " + (popup_max_area.x - 20) + "px; " +
                                            "max-height: " + (popup_max_area.y - 20) + "px;" + "' />",
                                        styles: {
                                            "opacity": 0
                                        }
                                    }).inject(widget_imagemap_wrapper.addClass("popup_open"));
                                    setTimeout(function () {
                                        var popup_size = {
                                            x: parseInt(popup.getStyle('width')),
                                            y: parseInt(popup.getStyle('height'))
                                        };
                                        $$('.popup')[0].setStyles({
                                            "margin-left": -popup_size.x / 2 + "px",
                                            "margin-top": -popup_size.y / 2 + "px",
                                            "opacity": 1
                                        });
                                    }, 100);
                                    events.each(function (event) {
                                        popup.getElement(".close")
                                            .addEvent(event, function () {
                                                $$(popup).destroy();
                                                widget_imagemap_wrapper.removeClass("popup_open");
                                            });
                                    });
                                }, false);
                            }

                            e.preventDefault();
                            e.stopPropagation();
                        });
                    });
                }
                else {
                    person.hide();
                }

                imageMap.options.defaultZoom = Math.max(imageMap.options.defaultZoom, img_dimensions.height);
                imageMap.options.minZoom = imageMap.options.defaultZoom / 2;
                imageMap.currentZoom = imageMap.options.defaultZoom;

                var h = widget_imagemap_wrapper.getDimensions().y * img_dimensions.width / img_dimensions.height;
                Hammer(
                    widget_imagemap_wrapper
                        .addClass(options.controlPosition)
                        .getElement(".imagemap-wrapper")
                        .setStyles({
                            "height": null
                        })
                ).on("pinchout", function (e) {
                        imageMap.setZoom(imageMap.currentZoom + imageMap.options.zoomStep);
                        e.preventDefault();
                        e.stopPropagation();
                        $$('body').set('data-nozoom', false);
                    }).on("pinchin", function (e) {
                        imageMap.setZoom(imageMap.currentZoom - imageMap.options.zoomStep);
                        e.preventDefault();
                        e.stopPropagation();
                        $$('body').set('data-nozoom', false);
                    });

                if (options.showNavigator) {
                    var navigator = widget_imagemap_wrapper.getElement(".imagemap-navigator");

                    navigator
                        .setStyles({
                            height: navigator.getDimensions().x * img_dimensions.height / img_dimensions.width
                        })
                        .getElement(".navigator-view-area")
                        .setStyles({height: 0, top: -9999999999});
                }
                else {
                    var imagemap_wrapper = widget_imagemap_wrapper.getElement(".imagemap-wrapper");
                    widget_imagemap_wrapper.addClass("no-navigator");
                }
                if (options.controlPosition === "right") {
                    control_container
                        .setStyles({
                            top: navigator ? navigator.getElement("img").getDimensions().y : parseInt(this.getStyle("padding-top")) - 5
                        });
                }

                element
                    .removeClass("loading")
                    .getElements(">*")
                    .setStyles({opacity: 1});

                if (options.extraLayer) {
                    var imagemap_wrapper = widget_imagemap_wrapper.getElement(".imagemap-wrapper");
                    var overlays = new Element('div.overlays').inject(imagemap_wrapper);
                    var overlays_inside = new Element('div.overlays-inside').inject(overlays);
                    if (options.overlayData && this.options.extraLayer.length > 1) {
                        var toggle_inputs = new Element('table.toggle-layers').inject(element);
                    }
                    var tr;
                    if (options.initExtraLayers == false) {
                        initExtraLayersStyle = "display:none"
                    } else {
                        initExtraLayersStyle = ""
                    }
                    for (var i = 0; i < this.options.extraLayer.length; i++) {
                        var layer = this.options.extraLayer[i];
                        new Element('img', {
                            src: layer,
                            style: initExtraLayersStyle
                        }).inject(overlays_inside);
                        try {
                            if (options.overlayData && this.options.extraLayer.length > 1) {
                                tr = new Element('tr').grab(
                                    new Element('td.toggle-inputs').grab(
                                        new Element('label', {
                                            html: options.overlayData.getElements('dt')[0][i].get('html')
                                        }).grab(
                                            new Element('input', {
                                                type: 'checkbox',
                                                'data-overlay-id': i,
                                                checked: options.initExtraLayers,
                                                tabindex: 0,
                                                events: {
                                                    change: function () {
                                                        var index = this.get('data-overlay-id');
                                                        $$('.overlays-inside')[0].getElements('img')[index].toggle()
                                                    }
                                                }
                                            }), 'top'
                                        )
                                    )
                                ).grab(
                                    new Element('td.layer-descriptions', {
                                        html: options.overlayData.getElements('dd')[0][i].get('html')
                                    })
                                );
                                tr.inject(toggle_inputs);
                            }
                        }
                        catch (e) {
                            console.error('Invalid overlay data', i, e);
                        }
                    }
                    ;
                    element.addClass('overlay-enabled');
                    if (options.hideSlider) {
                        overlays_inside.addClass('fixed-width');
                    }
                    else {
                        sliderInitVal = 0;
                        if (options.overlayDirection == 'RTL')
                            sliderInitVal = 100;

                        var slider = new Element('input.slider', {
                            type: 'range',
                            min: 0,
                            max: 100,
                            tabindex: 0
                        }).set('value', sliderInitVal).inject(imagemap_wrapper.getParent());
                        slider.addEvents({
                            'input': function () {
                                adjustOverlayWidth(this.get('value'));
                            },
                            'change': function () {
                                adjustOverlayWidth(this.get('value'));
                            }
                        });
                        slider.style.setProperty('max-width', (parseInt($$('.imagemap-wrapper')[0].getSize().x) + 24) + 'px', 'important');
                    }
                }

                // autozoom
                if (imageMap.options.autoZoom) {
                    imageMap.options.imageEl.getParent().setStyle('height', null);
                    var container_size = imageMap.options.imageEl.getParent().getSize();

                    var window_height = window.getHeight();
                    if (container_size.y > window_height) {
                        imageMap.options.imageEl.getParent().setStyle('height', window_height);
                        container_size.y = window_height;
                    }

                    var image_size = {
                        x: imageMap.options.imageEl.naturalWidth,
                        y: imageMap.options.imageEl.naturalHeight
                    };
                    var mod_container_size = {
                        x: container_size.y * (image_size.x / image_size.y),
                        y: container_size.x * (image_size.y / image_size.x)
                    };
                    if (mod_container_size.y > container_size.y) {
                        var x = mod_container_size.x;
                        imageMap.options.minZoom = x;
                        imageMap.options.defaultZoom = x;
                        imageMap.setZoom(x);
                    }
                    else {
                        imageMap.options.minZoom = container_size.x;
                        imageMap.options.defaultZoom = container_size.x;
                        imageMap.setZoom(container_size.x);
                    }
                }
                else if (imageMap.options.defaultZoom) {
                    imageMap.setZoom(imageMap.options.defaultZoom);
                }

            });
            _this.objects.push(imageMap);
        });


        // TODO: refactor this awful hack
        //setTimeout(function(){
        //
        //    new Element("style",{
        //        html:".imagemap-wrapper{height:"+window.getSize().y+"px;}.widget-imagemap-wrapper.bottom .imagemap-wrapper{max-height:"+(window.getSize().y - 100)+"px;}"
        //    }).inject($$("head")[0]);
        //
        //},1000);

        window.addEvent('keyup', function (e) {
            if (e.key === "esc") {
                close();
            }
        });
    }
});

ModifiedImageMap = new Class({
    Implements: [Events, Options],
    options: {
        defaultZoom: 100,
        defaultX: 0,
        defaultY: 0,
        zoomStep: 10,
        minZoom: 0,
        maxZoom: 250,
        left: 0,
        top: 0,
        wrapperEl: null,
        imageEl: null,
        controlsEl: null,
        imageUrl: null,
        showZoomControls: true,
        boundDragToContainer: false,
        showNavigator: false,
        updateNavigatorImmediately: true
    },
    currentZoom: null,
    wrapper: null,
    image: null,
    controlsWrapper: null,
    initialize: function (el, options) {
        // We check the container size and abort if the container element is not the crop size.
        // We try to intialize again on the next turn of the event loop if this is the case.
        // This prevents the Scrollable Image from initializing with a collapsed height and being unusable.
        // var containerSize = el.getSize();
        //       if (containerSize.x !== options.cropWidth || containerSize.y !== options.cropHeight) {
        //           setTimeout(function () { this.initialize.call(this, el, options); }.bind(this), 0);
        //           return;
        //       }

        this.el = el;
        this.setOptions(options);
        var needDomSetup = !options.wrapperEl;
        if (needDomSetup) {
            this.setupDom();
        }
        this.wrapper = this.options.wrapperEl;
        this.image = this.options.imageEl;
        if (this.options.showNavigator) {
            this.addNavigator();
        }
        this.controlsWrapper = this.options.controlsEl;
        this.addControls();

        if (!needDomSetup) {
            this.attachBehavior();
        }

        var ratio;
        if (this.options.defaultZoom == 'autofit') {
            this.options.imageEl.addEvent('load', function () {
                ratio = this.image.naturalHeight / this.image.naturalWidth;
                this.setZoom(this.el.getSize().x * ratio);
            }.bind(this));
        }

        /*console.log('Browser.name', Browser.name);
         console.log('Browser.platform', Browser.platform);
         console.log('Browser.Platform', Browser.Platform.android);*/

        if (Browser.Platform.ipod == true || Browser.Platform.android == true) {
            $$('body')[0].set('data-nozoom', true);
        }
    },
    addNavigator: function () {
        this.navigator = this.options.navigatorEl;
        this.navigatorImage = this.image.clone();
        this.navigatorImage.setStyles({'width': '100%'});
        this.navigator.adopt(this.navigatorImage);
        this.navigatorArea = new Element('div', {'class': 'navigator-view-area'});
        this.navigator.adopt(this.navigatorArea);
        this.navigatorArea.makeDraggable({
            container: this.navigator,
            stopPropagation: true,
            preventDefault: true,
            onDrag: function () {
                if (this.options.updateNavigatorImmediately) {
                    this.positionImageArea();
                }
            }.bind(this),
            onComplete: function () {
                this.positionImageArea();
            }.bind(this)
        });
    },
    getNavigationRatio: function () {
        return this.image.width / this.navigator.getSize().x;
    },
    positionNavigatorArea: function () {
        var navigatorRatio = this.getNavigationRatio();
        var wrapperSize = this.wrapper.getSize();

        var navHeightRatio = (wrapperSize.y / navigatorRatio);
        var navHeight = this.navigatorImage.height > navHeightRatio ? this.navigatorImage.height : navHeightRatio;
        // this.navigator.setStyle('height', navHeight + "px");

        this.navigatorArea.setStyles({
            'top': (this.wrapper.scrollTop / navigatorRatio) + 'px',
            'left': (this.wrapper.scrollLeft / navigatorRatio) + 'px',
            width: (wrapperSize.x / navigatorRatio) + 'px',
            height: (wrapperSize.y / navigatorRatio) + 'px'
        });
    },
    positionImageArea: function () {
        var navigatorRatio = this.getNavigationRatio() * 1.1;
        var navPos = this.navigatorArea.getPosition(this.navigator);
        this.wrapper.scrollTo(navPos.x * navigatorRatio, navPos.y * navigatorRatio);
    },
    attachBehavior: function () {
        this.setZoom(this.options.defaultZoom);
        this._resetDrag();
        this.wrapper.scrollTo(this.options.left, this.options.top);
    },
    setupDom: function () {
        _this = this;
        // <div id="map_wrapper">
        //  <img id="map_image" src="http://placehold.it/1350x1350" style=""></img>
        // </div>
        // <div id="controls-container">
        // </div>
        this.el.empty();
        this.options.wrapperEl = new Element('div', {'class': 'imagemap-wrapper'});
        this.options.imageAreaDiv = new Element('div.image-area');
        var size = this.el.getSize();
        this.options.wrapperEl.setStyles({
            'position': 'relative', 'overflow': 'hidden',
            'height': size.y + "px"
        });

        if (!this.options.showNavigator) {
            this.options.wrapperEl.setStyles({'width': size.x + "px"});
        } else {
            this.el.addClass('navigator-enabled');
        }
        this.options.imageEl = new Element('img', {
            src: this.options.imageUrl
        });

        this.options.imageEl.addEvent('load', function () {
            this.attachBehavior();
            // Reset minzoom if the image and container are both "portrait" orientation.
            // Prevents zoom out to blank areas.  See CHAUC-1060.
            if (this.image.naturalWidth < this.image.naturalHeight && this.el.getSize().x < this.el.getSize().y) {
                this.options.minZoom = this.el.getSize().x / this.image.naturalWidth * this.image.naturalHeight;
            }

            if (this.options.showNavigator) {
                this.positionNavigatorArea();
            }
            if (this.options.adjustCallback) {
                this.options.adjustCallback();
            }

        }.bind(this));
        this.options.wrapperEl.adopt(this.options.imageEl);

        this.options.controlsEl = new Element('div');
        var widgetWrapperEl = new Element('div', {'class': 'widget-imagemap-wrapper'});
        widgetWrapperEl.adopt(this.options.imageAreaDiv.adopt(this.options.wrapperEl));

        if (this.options.showNavigator) {
            this.options.navigatorEl = new Element('div.imagemap-navigator').inject(widgetWrapperEl);
        }

        widgetWrapperEl.adopt(this.options.controlsEl);
        this.el.adopt(widgetWrapperEl);

        if (this.el.get('data-touchscreen') === 'true') {
            _this.attachTouchBehaviors();
            _this.preventContainerToucheEvents();
        }
    },
    addControls: function () {
        var createControl = function (text, isPlus) {
            var controlEl = new Element('div', {
                'class': 'map-control',
                'text': text,
                'tabindex': 0
            });
            controlEl.addEvent('click', function (e) {
                e.stop();
                var zoom = this.currentZoom;
                if (isPlus) {
                    zoom = zoom + this.options.zoomStep;
                } else {
                    zoom = zoom - this.options.zoomStep;
                }
                this.setZoom(zoom);
            }.bind(this));
            controlEl.addEvent('keydown', function (e) {
                if (e.which == 13 || e.code == 13 || e.which == 32 || e.code == 32) {
                    this.fireEvent('click', e);
                }
            });
            return controlEl;
        }.bind(this);

        this.controlsWrapper.addClass('map-controls-container');
        this.controlsWrapper.adopt(createControl('+', true));
        this.controlsWrapper.adopt(createControl('-', false));
        this.controlsWrapper.adopt(new Element('div', {
            'class': 'map-control',
            html: '&#8635;',
            style: 'margin-top: 5px',
            tabindex: 0,
            events: {
                click: function (e) {
                    this.setZoom(this.options.defaultZoom);
                    this.wrapper.scrollTop = 0;
                    this.wrapper.scrollLeft = 0;
                    if (this.options.showNavigator) {
                        this.positionNavigatorArea();
                    }
                    if (this.options.adjustCallback) {
                        this.options.adjustCallback();
                    }
                }.bind(this),
                keyup: function (e) {
                    if (e.which == 13 || e.code == 13 || e.which == 32 || e.code == 32) {
                        this.fireEvent('click', e);
                    }
                }
            }
        }));
        if (!this.options.showZoomControls) {
            this.controlsWrapper.setStyle('display', 'none');
        }

        if (document.getElement('body').get('touch-device')) {
            this.controlsWrapper.getElements('div.map-control').each(function (el, i) {
                if (i <= 1) {
                    el.hide();
                }
            });
        }
    },
    _resetZoom: function () {
        _this = this;
        var imageSize = this.image.getSize();
        // var useWidth   = this.el.getSize().x < this.el.getSize().y;
        var useWidth = false;
        var zoomWidth = this.currentZoom;
        var zoomHeight = this.currentZoom;
        if (useWidth) {
            zoomWidth = zoomHeight * this.image.naturalWidth / this.image.naturalHeight;
        } else {
            zoomHeight = zoomWidth * this.image.naturalHeight / this.image.naturalWidth;
        }

        var yDiff = Math.floor(zoomHeight - imageSize.y) / 2;
        var xDiff = Math.floor(zoomWidth - imageSize.x) / 2;
        var scrollTop = this.wrapper.scrollTop;
        var scrollLeft = this.wrapper.scrollLeft;

        this.image.setStyle('width', zoomWidth + 'px');
        this.image.setStyle('height', zoomHeight + 'px');

        //console.log($$('.imagemap-wrapper img')[0].getPosition());

        //console.log(this.newX, this.newY)
        // console.log(typeof this.newX);


        if (typeof this.newX != 'undefined' && typeof this.newY != 'undefined') {

            //console.log(newX, newY);

            this.image.setStyle('-webkit-transform', 'translate(' + $$('.imagemap-wrapper img')[0].getPosition().x + 'px, ' + $$('.imagemap-wrapper img')[0].getPosition().y + 'px)');
        }

        if (parseInt(this.image.getHeight()) == parseInt(this.options.wrapperEl.getHeight())) {
            this.image.style.webkitTransform = '';
        }


        //this.wrapper.scrollTop = scrollTop + yDiff;
        //this.wrapper.scrollLeft = scrollLeft + xDiff;
        // this.wrapper.scrollTop  = 0;
        // this.wrapper.scrollLeft = 0;

    },
    setZoom: function (zoomLevel, zoomStep) {

        if (zoomLevel > this.options.maxZoom) {
            this.currentZoom = this.options.maxZoom;
        } else if (zoomLevel < this.options.minZoom) {
            this.currentZoom = this.options.minZoom;
        } else {
            this.currentZoom = zoomLevel;
        }

        if (/iPad/i.test(navigator.userAgent) || !/Mobile/i.test(navigator.userAgent)) {
            //this.newX = '';
            //this.newY = '';
            this._resetZoom();
        }
    },
    setPan: function (x, y) {
        this.wrapper.scrollTo(x, y);
    },
    _resetDrag: function () {
        if (this.drag) {
            this.drag.drag.detach();
        }
        this.drag = new DragScroll(this.wrapper, {
            axis: {x: true, y: true},
            friction: 100,
            boundDragToContainer: this.options.boundDragToContainer,
            stopPropagation: true,
            onDrag: function () {
                if ($$('.imagemap-wrapper')) {
                    this.positionNavigatorArea();
                }
                if (this.options.adjustCallback) {
                    this.options.adjustCallback();
                }
            }.bind(this),
            onComplete: function () {
                if (this.options.showNavigator) {
                    this.positionNavigatorArea();
                }
                if (this.options.adjustCallback) {
                    this.options.adjustCallback();
                }
            }.bind(this)
        });
    },

    prevent_left_scroll: false,
    prevent_right_scroll: false,
    prevent_top_scroll: false,
    prevent_bottom_scroll: false,

    preventContainerToucheEvents: function () {

        //console.log('AAAAACCCAAAA');

        /*$$('.imagemap-wrapper')[0].addEvent('pinchout', function(e){
         e.preventDefault();
         e.stopPropagation();
         return false;
         });*/


    },

    attachTouchBehaviors: function () {
        _this = this;
        $$('.imagemap-navigator').hide();

        var imageWrapper = $$('.imagemap-wrapper');
        var image = imageWrapper.getElement('img');
        var startX, startY, curX, curY;
        var orgImageWidth = image[0].getBoundingClientRect();


        image.addEvent('touchstart', touchStart, false);


        function touchStart(e) {
            e.preventDefault();
            if (typeof curX === 'undefined') {
                startX = e.targetTouches[0].pageX;
                startY = e.targetTouches[0].pageY;
            } else {
                startX = e.targetTouches[0].pageX - curX;
                startY = e.targetTouches[0].pageY - curY;
            }


            image.addEvent('touchmove', touchMove, false);


        }

        function touchMove(e) {

            if (_this.options.minZoom != _this.currentZoom) {


                var imageWrapper_v = imageWrapper[0].getBoundingClientRect();
                var image_v = image[0].getBoundingClientRect();

                e.preventDefault();


                curX = e.targetTouches[0].pageX - startX;
                curY = e.targetTouches[0].pageY - startY;

                range = 300;

                //console.log(parseInt(image[0].getBoundingClientRect().top) , parseInt(imageWrapper[0].getBoundingClientRect().bottom) - range)

                if (parseInt(image[0].getBoundingClientRect().right) - range < parseInt(imageWrapper[0].getBoundingClientRect().left) && _this.prevent_left_scroll == false) {
                    _this.prevent_left_scroll = true;
                    last_curX = curX;
                }

                if (parseInt(image[0].getBoundingClientRect().left) > parseInt(imageWrapper[0].getBoundingClientRect().right) - range && _this.prevent_right_scroll == false) {
                    _this.prevent_right_scroll = true;
                    last_curX = curX;
                }

                if (parseInt(image[0].getBoundingClientRect().bottom) - range < parseInt(imageWrapper[0].getBoundingClientRect().top) && _this.prevent_top_scroll == false) {
                    _this.prevent_top_scroll = true;
                    last_curY = curY;
                }

                if (parseInt(image[0].getBoundingClientRect().top) > parseInt(imageWrapper[0].getBoundingClientRect().bottom) - range && _this.prevent_bottom_scroll == false) {
                    _this.prevent_bottom_scroll = true;
                    last_curY = curY;
                }

                newX = curX;
                newY = curY;

                if (_this.prevent_left_scroll) {
                    newX = last_curX;
                    if (curX > last_curX) {
                        newX = curX;
                        _this.prevent_left_scroll = false;
                    }
                }

                if (_this.prevent_right_scroll) {
                    newX = last_curX;
                    if (curX < last_curX) {
                        newX = curX;
                        _this.prevent_right_scroll = false;
                    }
                }

                if (_this.prevent_top_scroll) {
                    newY = last_curY;
                    if (curY > last_curY) {
                        newY = curY;
                        _this.prevent_top_scroll = false;
                    }
                }

                if (_this.prevent_bottom_scroll) {
                    newY = last_curY;
                    if (curY < last_curY) {
                        newY = curY;
                        _this.prevent_bottom_scroll = false;
                    }
                }

                _this.newX = newX;
                _this.newY = newY;

                e.targetTouches[0].target.setStyle('-webkit-transform', 'translate(' + newX + 'px, ' + newY + 'px)');

            }
        }
    }
});

var sum = function (array) {
    var result = 0;
    for (var l = array.length; l--;) result += array[l];
    return result;
};

DragScroll = new Class({

    // We'd like to use the Options Class Mixin
    Implements: [Options, Events],

    // Default options
    options: {
        friction: 5,
        axis: {x: true, y: true},
        boundDragToContainer: false
    },

    initialize: function (element, options) {
        element = this.element = document.id(element);
        this.content = element.getFirst();
        this.setOptions(options);

        // Drag speed
        var prevTime, prevScroll, speed, scroll, timer;
        var timerFn = function () {
            var now = Date.now();
            scroll = [element.scrollLeft, element.scrollTop];
            if (prevTime) {
                var dt = now - prevTime + 1;
                speed = [
                        1000 * (scroll[0] - prevScroll[0]) / dt,
                        1000 * (scroll[1] - prevScroll[1]) / dt
                ];
            }
            prevScroll = scroll;
            prevTime = now;
        };

        // Use Fx.Scroll for scrolling to the right position after the dragging
        var fx = this.fx = new Fx.Scroll(element, {
            transition: Fx.Transitions.Expo.easeOut
        });

        // Set initial scroll
        fx.set.apply(fx, this.limit(element.scrollLeft, element.scrollTop));

        var self = this;
        friction = this.options.friction,
            axis = this.options.axis;

        // Make the element draggable
        var drag = this.drag = new Drag(element, {
            style: false,
            invert: true,
            modifiers: {x: axis.x && 'scrollLeft', y: axis.y && 'scrollTop'},
            stopPropagation: true,
            preventDefault: true,
            onStart: function () {
                // Start the speed measuring
                timerFn();
                timer = setInterval(timerFn, 1000 / 60);
                // cancel any fx if they are still running
                fx.cancel();
            },
            onDrag: function (el, e) {
                self.fireEvent('drag', el, e);
                if (!self.options.boundDragToContainer) {
                    return;
                }
                var elSize = el.getSize();
                var elPosition = el.getPosition();
                var cushion = -5;

                var x = this.mouse.now.x - elPosition.x;
                var y = this.mouse.now.y - elPosition.y;

                if (x <= cushion || x >= elSize.x - cushion || y <= cushion || y >= elSize.y - cushion) {
                    this.stop();
                }
            },
            onComplete: function () {
                // Stop the speed measuring
                prevTime = false;
                clearInterval(timer);
                // Scroll to the new location
                fx.start.apply(fx, self.limit(
                        scroll[0] + (speed[0] || 0) / friction,
                        scroll[1] + (speed[1] || 0) / friction
                ));
                self.fireEvent('complete');
            }
        });

    },

    // Calculate the limits
    getLimit: function () {
        var limit = [
            [0, 0],
            [0, 0]
        ], element = this.element;
        var styles = Object.values(this.content.getStyles(
            'padding-left', 'border-left-width', 'margin-left',
            'padding-top', 'border-top-width', 'margin-top',
            'width', 'height'
        )).invoke('toInt');
        limit[0][0] = sum(styles.slice(0, 3));
        limit[0][1] = styles[6] + limit[0][0] - element.clientWidth;
        limit[1][0] = sum(styles.slice(3, 6));
        limit[1][1] = styles[7] + limit[1][0] - element.clientHeight;
        return limit;
    },

    // Apply the limits to the x and y values
    limit: function (x, y) {
        var limit = this.getLimit();
        return [
            x.limit(limit[0][0], limit[0][1]),
            y.limit(limit[1][0], limit[1][1])
        ];
    }

});