/**
 * Created by germanmontes on 18/03/15.
 */

var PanZoom =  new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
    },
    images_loaded: false,


    initialize: function(options) {
        var that = this;
        //call parent before to go into the widget
        this.parent({
            container: options.container,
            itemTemplate: options.itemTemplate
        });

        if (!this.isEditMode){

            function initialize_procedure(){
                that.container.set("data-multiple",0);


                //retrieve labels before the widget is initializated
                var image_list = that.container.getElements("[data-md-editable]");

                //this.container.getElements(".option-entry").dispose();


                var WidgetPreview = new Element("div.widget-preview.pan-zoom");
                WidgetPreview.inject($$(".widget-body")[0],"before");

                that.addWidget(WidgetPreview);

                $$(".widget-body").removeClass("pan-zoom");

                //create elements for options
                var template="";
                template += "<div class=\"thumb-wrapper-outer\">";
                template += "  <div  class=\"thumb-wrapper-inner\">";
                //template += "    <div class=\"drag-indication-box drop-zone drageventbind selected\">Click here or drag an<br> image or video to add<br> it to this gallery.<\/div>";
                template += "  <\/div>";
                template += "<\/div>";

                var image_list_wrapper = new Element("div.image-list-wrapper", {
                    html: template

                });
                image_list_wrapper.getElement(".thumb-wrapper-inner").adopt(image_list);
                //inject options at the end of the container
                image_list_wrapper.inject(that.container);

                if($$('[data-md-editable="md-portal-media-list-item"]').length>0){
                    //console.log($$('[data-md-editable="md-portal-media-list-item"]')[0]);
                    setTimeout(function(){
                        $$('[data-md-editable="md-portal-media-list-item"]')[0].click();
                        if(parent && parent!=window) {
                            parent.postMessage({
                                method:'enhanced-image-have-entry',
                                editMode:false,
                                options:{
                                    align:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("data-align"),
                                    scaleMarkerType:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("data-scalemarker-type"),
                                    scaleMarkerValue:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("data-scalemarker-value"),
                                }
                            },"*");
                            that.notifyFocusCapture();
                        }
                    },500);
                }
            }

            if($$("img").length>0 && that.images_loaded==false){
                var imgs = [];
                $$("img").forEach(function(e){
                    imgs.push($$(e).get("src"));
                })
                Asset.images(imgs,{
                    onProgress(counter, index, source){
                    
                        if(source[index]!="" && source[index]!=null){
                            
                            $$("img[src='"+source[index]+"']")[0].set("width", this.width);
                            $$("img[src='"+source[index]+"']")[0].set("height", this.height);
                        }
                        //console.log(this, counter, index, source);
                        //console.log($$("img[src='']"))
                    },
                    onComplete:function(){
                        that.images_loaded=true;
                        initialize_procedure();
                    }
                })
            } else {
                initialize_procedure();
            }
        }

        this.render();

        if(parent!=window){
            parent.postMessage({
                method:"widget-ready",
                edit_mode:this.isEditMode
            },"*");
        }
    },
    //add the widget
    addWidget:function(container){
        //var standardImageMap = new StandardImageMap($$(".image_container"));
        var that = this;

        if($$('[data-md-editable="md-portal-media-list-item"]').length==0){
            return;
        }


        $$('[data-md-editable="md-portal-media-list-item"]').addEvent("click",function(e, i) {
            var img_clone = this.getElement("img").clone(true);

            img_clone.set("width",img_clone.width);
            img_clone.set("height",img_clone.height);
            container.empty();
            var options = {
                "data-autozoom":"true",
                "data-show-navigator":"true",
                "data-controls":this.get("data-align")!=null?this.get("data-align"):"right",
                //"data-scale-button":"images/AADGKBB0.jpg"
            };

            if(this.get("data-scalemarker-type")!="0"){
                options["data-scale-button"] = this.get("data-scalemarker-value");
            }

            var image_container = new Element("div.image_container",options);
            image_container.adopt(img_clone);
            container.adopt(image_container);

            var standardImageMap = new StandardImageMap($$(".image_container"));

            setTimeout(function(){
                /*
                 $$('.imagemap-wrapper')[0].addEvent("click",function(){

                 if(parent!=window){
                 parent.postMessage({method:'delete-image-request'},"*");
                 }
                 })
                 */

                if(that.isEditMode){

                    var actions_wrapper = new Element("div.actions-wrapper");

                    var delete_action = new Element('a', {
                        'href': '#',
                        'html': '<i class="fa fa-times"></i>'
                    });
                    delete_action.inject(actions_wrapper);

                    var edit_action = new Element('a', {
                        'href': '#',
                        'html': '<i class="fa fa-pencil"></i>'
                    });
                    edit_action.inject(actions_wrapper);

                    var alt_text_action = new Element('a', {
                        'href': '#',
                        'html': '<i class="fa fa-align-left"></i>'
                    });
                    alt_text_action.inject(actions_wrapper);

                    actions_wrapper.inject($$(".image_container .imagemap-wrapper")[0]);


                    delete_action.addEvent("click",function(e){
                        if(parent!=window){
                            parent.postMessage({
                                method:"delete-image-request",
                                edit_mode:this.isEditMode
                            },"*");
                        }
                        return false;
                    });

                    edit_action.addEvent("click",function(e){
                        if(parent && parent!=window) {
                            parent.postMessage({method:'show-media-popup',id:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("data-md-id")},"*");
                        }
                        return false;
                    });

                    alt_text_action.addEvent("click",function(e){
                        if(parent && parent!=window) {
                            parent.postMessage({method:'edit-accessibility-text-request'},"*");
                        }
                        return false;
                    });

                }

            },500);

            $$('[data-md-editable="md-portal-media-list-item"]').removeClass("selected");
            this.addClass("selected");
        });

    },
    //if edit mode is on add fileupload event and rotation select form
    bindEditMode: function () {

        var that = this;

        that.container.set("data-multiple",0);

        $$('[data-md-editable="md-portal-media-list-item"]:not(.processed)').each(function(e, i) {
            new Element('a.md-portal-media-list-item-button.md-edit-remove', {
                'href': '#',
                'html': '<i class="fa fa-times"></i>'
            }).inject(e);

            new Element('a.md-portal-media-list-item-button.md-edit-slide', {
                'href': '#',
                'html': '<u>EDIT</u>'
            }).inject(e);

            e.addClass("processed");
        });

        //retrieve labels before the widget is initializated
        var image_list = this.container.getElements("[data-md-editable]");
        that.container.addClass(image_list.length>0?"has-entrys":"");

        //this.container.getElements(".option-entry").dispose();


        var WidgetPreview = new Element("div.widget-preview.pan-zoom");
        WidgetPreview.inject($$(".widget-body")[0],"before");

        //var container_clone = this.container.clone(true);
        //container_clone.inject(WidgetPreview);

        this.addWidget(WidgetPreview);

        $$(".widget-body").removeClass("pan-zoom");

        //image was deleted
        this.addEvent("md-file-delete", function (data) {
            data.el.dispose();
            that.saveProcedure(that.onImageUpload);
        });

        //image was added or edited
        this.addEvent("md-file-added-edited", function (data) {

            var file = data.files[0];
            data.el.set("data-file-name", file.filename);
            data.el.set("data-file-path", file.path);
            data.el.set("data-file-path-relative", file.relativePath);
            that.saveProcedure(that.onImageUpload);
        });

        //upload complete listener
        this.addEvent("md-fileupload-multiple-complete", function (data) {

            if (data.files) {
                data.files.each(function (file) {
                    that.addImageEntry(file);
                });

                that.saveProcedure(that.onImageUpload);


                that.parseElements(that.container);
            }
        });

        //create elements for options
        var template="";
        template += "<div class=\"thumb-wrapper-outer\">";
        template += "  <div  class=\"thumb-wrapper-inner\">";
        //template += "    <div class=\"drag-indication-box drop-zone drageventbind selected\">Click here or drag an<br> image or video to add<br> it to this gallery.<\/div>";
        template += "  <\/div>";
        template += "<\/div>";

        var image_list_wrapper = new Element("div.image-list-wrapper", {
            html: template

        });
        image_list_wrapper.getElement(".thumb-wrapper-inner").adopt(image_list);
        //image_list_wrapper.getElement(".thumb-wrapper-inner").adopt(Elements.from("<div class=\"drag-indication-box drop-zone  selected\">Click this box or drag<br/> an image onto it to<br/>add content to this<br/>enhanced image <br/> widget.<\/div>")[0]);
        image_list_wrapper.getElement(".thumb-wrapper-inner").adopt(Elements.from("<div class=\"drag-indication-box drop-zone  selected\">&nbsp;<\/div>")[0]);
        //inject options at the end of the container
        image_list_wrapper.inject(this.container);

        if($$('[data-md-editable="md-portal-media-list-item"]').length>0){
            //console.log($$('[data-md-editable="md-portal-media-list-item"]')[0]);
            setTimeout(function(){
                $$('[data-md-editable="md-portal-media-list-item"]')[0].click();

                if(parent && parent!=window) {
                    parent.postMessage({
                        method:'enhanced-image-have-entry',
                        editMode:true,
                        options:{
                            align:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("data-align"),
                            scaleMarkerType:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("data-scalemarker-type"),
                            scaleMarkerValue:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("data-scalemarker-value"),
                        }
                    },"*");
                    that.notifyFocusCapture();
                }




            },500);
        }else{

            //$$(".widget-preview").set("html","<div class=\"drag-indication-box drop-zone  selected\">Click this box or drag<br/> an image onto it to<br/>add content to this<br/>enhanced image <br/> widget.<\/div>");

            if(parent && parent!=window) {
                parent.postMessage({method:'enhanced-image-no-entry'},"*");
                that.notifyFocusCapture();
            }
        }



        if($$('[data-md-editable="md-portal-media-list"] .drop-zone:not(.drageventbind)').length>0){

            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondragover = function(e) {
                this.addClass('dragover');
                return false;
            };
            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondragend = function(e) {
                $$('[data-md-editable="md-portal-media-list"] .drop-zone').removeClass('dragover');
                return false;
            };
            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondragleave = function(e) {
                $$('[data-md-editable="md-portal-media-list"] .drop-zone').removeClass('dragover');
                return false;
            };
            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondrop = function(e) {
                e.preventDefault();
                var container = '[data-md-editable="md-portal-media-list"]';
                $$(container).removeClass('dragover');
                that.uploadFile(e.dataTransfer.files, container);
                return false;
            };

            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].addClass("drageventbind");
        }

        $$('.md-edit-slide').addEvent('click', function() {
            if(parent && parent!=window) {
                parent.postMessage({method:'show-media-popup',id:this.getParent().getAttribute("data-md-id")},"*");
                that.notifyFocusCapture();
            }
            return false;
        });

        $$('.md-edit-remove').addEvent('click', function() {
            /*
             if(confirm("Are you sure you want to delete this element from the gallery?"))
             that.removeFile(this.getParent().getAttribute("data-md-id"), this.getSiblings('img')[0].getAttribute('src'));
             that.notifyFocusCapture();

             if(parent && parent!=window) {
             parent.postMessage({
             method:'enhanced-image-delete-image',
             id:this.getParent().getAttribute("data-md-id"),
             promptText:"Are you sure you want to remove this image from the widget?",
             type:"dialog"
             },"*");
             }*/
            that.saveRequest({
                //path: path,
                options:{
                    selector:'[data-md-id="'+this.getParent().get("data-md-id")+'"]'
                },
                method: 'mdRemove'
            },function(){
                window.location.reload();
            });
            return false;
        });


        $$('.drag-indication-box').addEvent('click', function() {
            if(parent && parent!=window) {
                parent.postMessage({method:'show-media-popup'},"*");
            }
            return false;
        });


    },
    uploadFile: function(files, containerSelector) {
        var that = this;
        var formData = new FormData();
        var multimediaType = "image";
        var multimediaTypeFormat = "";
        for (var i = 0; i < files.length; i++) {
            console.log(files[i]);
            if(files[i].type.indexOf("video")!=-1){
                multimediaType = "video";
            }
            multimediaTypeFormat = files[i].type;
            formData.append('file', files[i]);
        }

        var pathUpload = location.href;
        /*
         if(this.booksRoot==null){
         pathUpload = this.getBookPath('/pearson-books/');
         if(pathUpload==""){
         pathUpload = this.getBookPath('/pearson-books-dev/');
         }
         }
         else{
         pathUpload = this.getBookPath('/'+this.booksRoot+'/');
         }
         */
        pathUpload="";

        formData.append('path', pathUpload);
        formData.append("widget_id",this.widget_id);
        formData.append('directory', 'images');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', this.root + 'api/index.php/upload/');
        xhr.onload = function () {

            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                var img_path = response.path;
                /* var path = pathUpload.substr(pathUpload.indexOf('/pearson-books/')).split('/');
                 path = path.splice(1, path.length-2).join('/');*/


                var imagepath,filepath;
                imagepath = filepath = 'images/' + response.filename;
                if(multimediaType=="video"){
                    imagepath="https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
                }

                that.saveRequest({
                    //path: path,
                    method: 'appendMultimedia',
                    element: containerSelector,
                    type: 'md-portal-media-list-element',
                    content: imagepath,
                    filePath:filepath,
                    multimediaType:multimediaType,
                    multimediaTypeFormat:multimediaTypeFormat
                },function(){
                    window.location.reload();
                });
            } else {
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },
    removeFile: function(file_id, file_src) {
        /* var path = location.href.substr(location.href.indexOf('/pearson-books/')).split('/');
         path = path.splice(1, path.length-2).join('/'); */

        this.saveRequest({
            //path: path,
            img_src: file_src,
            method: 'remove',
            element: file_id
        });
    },
    //receive postmessage event
    customPostMessages:function(message,path) {


        this.parent(message, path);

        var that = this;


        switch(message.data.method){
            case "image-accessibility-text":
                //var image_item = $$('[data-md-editable="md-portal-media-list-item"]')[message.data.ind];
                that.saveRequest({
                    method:"setAttributeById",
                    id:$$('[data-md-editable="md-portal-media-list-item"]')[message.data.ind].get("id"),
                    attribute:[
                        {
                            attribute:"data-accessibility-text",
                            value:message.data.text
                        }
                    ]
                });
                break;
            case "retrieve-image-accessibility-list":
                if(parent!=window){
                    var image_list = [];
                    $$('[data-md-editable="md-portal-media-list-item"]').each(function(e) {

                        image_list.push({
                            image:e.getElement("img").get("src"),
                            text: e.get("data-accessibility-text")
                        });


                    });

                    parent.postMessage({
                        method:"image-accessibility-list",
                        list:image_list
                    },"*");
                }
                break;
            case "enhanced-image-delete-image":
                var element_to_delete = $$('.selected[data-md-editable="md-portal-media-list-item"]')[0];
                that.removeFile(element_to_delete.getAttribute("data-md-id"), element_to_delete.getElement('img').getAttribute('src'));
                break;
            case "scalemarker-change":
                $$('.selected[data-md-editable="md-portal-media-list-item"]').set("data-scalemarker-type",message.data.type);
                $$('.selected[data-md-editable="md-portal-media-list-item"]').set("data-scalemarker-value",message.data.value);
                $$('.selected[data-md-editable="md-portal-media-list-item"]')[0].click();
                that.saveRequest({
                    method:"setAttributeById",
                    id:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("id"),
                    attribute:[
                        {
                            attribute:"data-scalemarker-type",
                            value:message.data.type
                        },
                        {
                            attribute:"data-scalemarker-value",
                            value:message.data.value
                        }
                    ]
                });
                break;
            case "align-change":
                $$('.selected[data-md-editable="md-portal-media-list-item"]').set("data-align",message.data.align);
                $$('.selected[data-md-editable="md-portal-media-list-item"]')[0].click();
                that.saveRequest({
                    method:"setAttributeById",
                    id:$$('[data-md-editable="md-portal-media-list-item"]')[0].get("id"),
                    attribute:"data-align",
                    value:message.data.align
                });
                break;
            case "delete-image":
                that.container.getElement('.selected[data-md-editable] .md-edit-remove').click();
                /*
                 if(parent && parent!=window) {
                 parent.postMessage({method:'enhanced-image-no-entry',options:{}},"*");
                 that.notifyFocusCapture();
                 }
                 */
                break;
            case "show-media-popup":

                var imagepath,filepath,multimediaTypeFormat,multimediaType,caption="",defaultImage=false,copyFile=false;
                filepath = 'images/' + message.data.data.source_value;
                imagepath="https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
                multimediaType = multimediaTypeFormat =  message.data.data.source_type;

                if(multimediaType=="internet"){
                    multimediaType="iframe";
                    filepath = imagepath = message.data.data.source_value;
                }

                if(multimediaType=="computer"){

                    if(message.data.data.source_ext.indexOf("image/")!=-1){
                        multimediaType="image";
                        multimediaTypeFormat = message.data.data.source_ext;
                        imagepath = filepath = message.data.data.source_value;
                    }

                    copyFile=true;

                }

                if(multimediaType=="folder"){

                    multimediaType="image";
                    multimediaTypeFormat = message.data.data.source_ext;
                    imagepath = filepath = message.data.data.source_value;

                    copyFile=false;

                }



                var containerSelector = '[data-md-editable="md-portal-media-list"]';


                that.saveRequest({
                    path: path,
                    method: message.data.id?'updateMultimedia':'appendMultimedia',
                    element: containerSelector,
                    type: 'md-portal-media-list-element',
                    content: imagepath,
                    filePath:filepath,
                    multimediaType:multimediaType,
                    multimediaTypeFormat:multimediaTypeFormat,
                    mustCopyTheFile:copyFile,
                    caption:caption,
                    defaultImage:defaultImage,
                    id:message.data.id?message.data.id:null
                },function(){
                    window.location.reload();
                });

                break;
            default:
                console.warn('media-gallery Unknown message', message);
        }
    },
    //this method is executed after the tags are parsed
    bindEditModeAfterTagParse: function () {
        this.bindTargetButton();
    },
    bindTargetButton:function(){
        //code goes here
    },
    bindEvents: function () {

    },
    render: function () {

    }
});

