TermsAndDefinitions = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        delay: 2000,
        top_score: 7
    },
    terms: [],
    challenge_mode: false,
    current_pos: 0,
    current_opt: 0,
    initialize: function(options) {
        this.parent(options);
        var _this = this;
        this.setOptions(options);

        this.container = this.options.container;




        this.canvas = this.container.getElement('canvas');
        this.ctx = this.canvas.getContext('2d');

        this.container.getElement('.start').addEvent(this.clickEvent, function() {
            _this.startChallenge(true);
        }.bind(this));
        this.container.getElement('.exit').addEvent(this.clickEvent, function() {
            _this.exitChallenge();
        }.bind(this));
        this.container.getElement('.repeat').addEvent(this.clickEvent, function() {
            _this.repeatChallenge();
        }.bind(this));
        this.pos = null;

        this.arrayOrderOptions = [];
        this.options.data.each(function(e, i) {
            _this.arrayOrderOptions[i] = i;
        });


        this.makeElementDraggable();
        this.renderLine();
        this.container.getElement('.draggable').hide();
        this.container.getElement('.instruction strong').set('html', '<span class="responsive-call-to-action">Click or tap</span> each type of supporting material to learn more about it, then <span class="responsive-call-to-action">click or tap</span> “Check Your Understanding” to review.');

        this.insertActionText();

        //this.createDOM();
    },
    makeElementDraggable: function() {
        var _this = this;
        this.draggable = this.container.getElement('.draggable');
        this.draggable.setStyle('left', ($$('body')[0].getSize().x / 2) + 'px');
        this.draggable.setStyle('top', ($$('.widget-content')[0].getSize().y / 2) + 'px');


        this.draggable.makeDraggable({
            droppables: $$('.droppable'),
            onSnap: function(el) {
                if ($$('.droppable.selected')[0])
                    $$('.droppable.selected')[0].removeClass('selected');
                if ($$('.message.correct')[0])
                    $$('.message.correct')[0].removeClass('correct').setStyle('opacity', 0);
                if ($$('.message.incorrect')[0])
                    $$('.message.incorrect')[0].removeClass('incorrect').setStyle('opacity', 0);
            },
            onEnter: function(draggable, droppable) {
                droppable.addClass('selected');
                droppable.addClass('no-description');
            },
            onLeave: function(draggable, droppable) {
                droppable.removeClass('selected');
                droppable.removeClass('no-description');
            },
            onDrop: function(draggable, droppable) {
                var correct = false;

                if ($$('.droppable.selected')[0])
                    $$('.droppable.selected')[0].removeClass('selected');
                if (droppable) {
                    if (_this.checkAnswer(droppable.getAttribute('data-id'))) {
                        _this.container.getElement('.message').set('html', 'Correct!').addClass('correct').setStyle('opacity', 1);
                        draggable.morph({
                            left: $$('body')[0].getSize().x / 2 + 'px',
                            top: ($$('.widget-content')[0].getSize().y / 2) + 'px'
                        });
                        setTimeout(function() {

                            _this.container.getElement('.message').morph({'opacity': 0});
                            _this.nextOption();
                        }, 1800);
                        correct = true;
                    } else {
                        _this.container.getElement('.message').set('html', 'Incorrect. Try again.').addClass('incorrect').setStyle('opacity', 1);
                        //setTimeout(function() { _this.container.getElement('.message').morph({'opacity': 0})}, 2000);
                    }
                }
                if (!correct) {
                    draggable.morph({
                        left: $$('body')[0].getSize().x / 2 + 'px',
                        top: ($$('.widget-content')[0].getSize().y / 2) + 'px'
                    });
                }
            },
            onComplete: function(el) {
                $$('.column-left .item.no-description').removeClass('no-description');
            }
        });
    },
    createDOM: function() {


        this.parent();
        _this = this;
        var container_left = this.container.getElement('.column-left');
        var container_definition = this.container.getElement('.column-right .definition-wrapper');
        this.options.data.each(function(e, i) {
            new Element('div.item.droppable.clickable.item-' + i, {
                html: '<strong>' + e.title + '</strong>',
                'data-id': i,
                'aria-labelledby': 'opt-' + i,
                tabindex: 0,
                events: {
                    keyup: function(e) {
                        if(e.key == 'tab'){
                            if ($$('.message.correct')[0])
                                $$('.message.correct')[0].removeClass('correct').setStyle('opacity', 0);
                            if ($$('.message.incorrect')[0])
                                $$('.message.incorrect')[0].removeClass('incorrect').setStyle('opacity', 0);
                        }
                        if (e.key == 'tab' && !this.hasClass('on-quiz') && !this.hasClass('end-quiz')) {
                            this.fireEvent('click');
                        }
                    },
                    keypress: function(e) {
                        if ((e.key == 'enter' || e.key == 'space') && this.hasClass('on-quiz')) {
                            if (_this.checkAnswer(this.getAttribute('data-id'))) {
                                _this.container.getElement('.message').set('html', 'Correct!').addClass('correct').setStyle('opacity', 1);                                
                                _this.container.getElement('.message').set('aria-live', 'Correct!')
                                setTimeout(function() {
                                    _this.container.getElement('.message').morph({'opacity': 0});
                                    _this.nextOption();                                    
                                }, 1800);
                                
                            }else{
                                _this.container.getElement('.message').set('html', 'Incorrect. Try again.').addClass('incorrect').setStyle('opacity', 1);                                
                                _this.container.getElement('.message').set('aria-live', 'Incorrect. Try again.')
                            }
                        }
                    }
                }
            }).inject(container_left);

            definition = new Element('div.item.definition.hidden.item-' + i, {
                html: '<div class="opac">' + e.title + '.</div>' + e.definition + ' ' + e.other,
                'id': 'opt-' + i,
                'data-id': i
            }).inject(container_definition);


        });


        this.container.getElements('.clickable').addEvent('click', function() {


            elem = _this.container.getElement('.column-right .definition[data-id="' + this.getAttribute('data-id') + '"]');

            if (elem.hasClass('hidden')) {
                _this.container.getElements('.column-right .definition').addClass('hidden');
                _this.container.getElements('.column-left .selected').removeClass('selected');
                this.addClass('selected');
                elem.removeClass('hidden');
            } else {
                this.removeClass('selected');
                elem.addClass('hidden');
            }
        });

        this.canvas_width = 0;
        setInterval(function() {
            if ($$('body')[0].getSize().x !== this.canvas_width) {
                _this.canvas_width = $$('body')[0].getSize().x;
                $$('canvas').set('width', $$('body')[0].getSize().x);
            }
        }, 500);

    },
    startChallenge: function(shuffle) {
        this.container.getElement('.instruction strong').set('text', 'Drag the circle to connect the text below to the part of the outline that describes it.');
        this.container.getElement('.draggable').show();
        this.container.getElement('.challenge-wrapper').removeClass('hidden');
        this.container.getElement('.exit').removeClass('hidden');
        this.container.getElement('.start').addClass('hidden');
        this.container.getElement('.option-definition').show();
        this.container.getElement('.draggable').show();

        if (this.container.getElement('.selected'))
            this.container.getElement('.selected').fireEvent('click');

        this.options.data.each(function(e, i) {
            e.firsttry = '-';
        });

        if (shuffle) {
            this.arrayOrderOptions.shuffle();
        }
        this.current_pos = -1;
        this.nextOption();
        this.timer = setInterval(function() {
            _this.renderLine();
        }, 10);
        
        $$('div.item.droppable').each(function(e,i){            
            e.removeAttribute('aria-labelledby');
            e.addClass('on-quiz');
            e.removeClass('end-quiz');
        });
    },
    repeatChallenge: function() {
        this.container.getElement('.instruction strong').set('text', 'Drag the circle to connect the text below to the part of the outline that describes it.');
        this.startChallenge(false);
        this.container.getElement('.repeat').addClass('hidden');
        this.container.getElement('.draggable').show();
        $$('div.item.droppable').each(function(e,i){                       
            e.addClass('on-quiz');
            e.removeClass('end-quiz');
        });
    },
    endChallenge: function() {
        var _this = this;

        this.ctx.clearRect(0, 0, this.canvas_width, 400);
        clearInterval(this.timer);
        this.container.getElement('.option-definition').hide();
        this.container.getElement('.draggable').hide();
        this.container.getElement('.repeat').removeClass('hidden');
        this.container.getElement('.widget-footer .feedback').set('html', '');
        this.container.getElement('.draggable').hide();
        $$('div.item.droppable').each(function(e,i){                       
            e.removeClass('on-quiz');
            e.addClass('end-quiz');
        });
        
        setTimeout(function(){
            _this.showScore();
            $$('.note.instruction.score')[0].setAttribute('tabindex', 0);
            $$('.note.instruction.score')[0].focus();            
        }, 2000);        
    },
    exitChallenge: function() {
        this.container.getElement('.instruction strong').set('html', '<span class="responsive-call-to-action">Click or tap</span> each type of supporting material to learn more about it, then <span class="responsive-call-to-action">click or tap</span> “Check Your Understanding” to review.');
        this.ctx.clearRect(0, 0, this.canvas_width, 400);
        clearInterval(this.timer);
        this.container.getElement('.challenge-wrapper').addClass('hidden');
        this.container.getElement('.repeat').addClass('hidden');
        this.container.getElement('.exit').addClass('hidden');
        this.container.getElement('.start').removeClass('hidden');
        this.container.getElement('.widget-footer .feedback').set('html', '');
        this.container.getElement('.draggable').hide();
        this.insertActionText();
        $$('div.item.droppable').each(function(e,i){            
            e.setAttribute('aria-labelledby', 'opt-' + e.get('data-id'));
            e.removeClass('on-quiz');
            e.removeClass('end-quiz');
        });
    },
    checkAnswer: function(ans) {
        if (this.current_opt == ans) {
            return true;
        } else {
            this.options.data[this.current_opt].firsttry = '0';
            return false;
        }
    },
    nextOption: function() {
        this.current_pos = this.current_pos + 1;
        if (this.current_pos == this.arrayOrderOptions.length) {
            this.endChallenge();
        } else {
            this.container.getElement('.message').morph({'opacity': 0});
            this.current_opt = this.arrayOrderOptions[this.current_pos];
            this.container.getElement('.option-definition').set({'html': this.options.data[this.current_opt].definition, 'data-id': this.current_opt});
            this.container.getElement('.widget-footer .feedback').set('html', 'Question ' + (this.current_pos + 1) + ' of ' + this.arrayOrderOptions.length);
        }
    },
    showScore: function() {
        var success = 0;
        this.options.data.each(function(e, i) {
            if (e.firsttry == '-')
                success++;
        });

        var score = new Score(this.options.data.length, success);
        this.container.getElement('.instruction strong').set('text', score.getMessage());
        _this.container.getElement('.message').set('html', '');

    },
    renderLine: function() {
        this.ctx.clearRect(0, 0, this.canvas_width, 400);
        this.ctx.beginPath();
        this.ctx.setLineDash([2, 2]);
        this.ctx.moveTo(this.canvas_width / 2 - ((this.canvas_width - 700) / 2) + 48, 198);
        this.ctx.lineTo(this.draggable.getPosition().x - ((this.canvas_width - 700) / 2) + 25, this.draggable.getPosition().y - 85);
        this.ctx.strokeStyle = '#C3C3C3';
        this.ctx.lineWidth = 3;
        this.ctx.stroke();
    }
});