MultChoice = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    // Set initial options here
    options: {
    },
    currentQuestion: 0,
    answeredQuestions: 0,
    firstTry: true,
    firstTryCorrect: false,
    correctAnswered: 0,
    currentQuestionObject: null,
    canContinue: false,
    // initialize - widget initialization
    initialize: function(options) {
        this.parent(options);

        this.nextEl = this.container.getElement(".next");
        this.nextEl.addEvent(this.clickEvent, this.next.bind(this));
        this.nextEl.setProperty("disabled", "disabled");

        this.resetEl = this.container.getElement(".reset");
        this.resetEl.addEvent(this.clickEvent, this.reset.bind(this));
        this.resetEl.hide();

        this.render();
        // $$(".answers button")[0].focus();
    },
    // Add any helper methods here
    reset: function() {

        var _this = this;

        this.currentQuestion = 0;
        this.answeredQuestions = 0;
        this.firstTry = true;
        this.firstTryCorrect = false;
        this.correctAnswered = 0;
        this.currentQuestionObject = null;
        this.canContinue = false;

        this.nextEl.show();
        this.resetEl.hide();

        _this.container.getElement(".instruction").set("html", "Choose your answer");
        _this.container.getElement(".instruction").removeClass("allcorrect");

        this.render();
        $$('.note.question')[0].setAttribute('tabindex', '0');
        $$('.note.question')[0].focus();
    },
    next: function() {
        var _this = this;
        if (this.firstTryCorrect) {
            this.correctAnswered++;
        }

        this.nextEl.setProperty("disabled", "disabled");
        _this.container.getElement(".message").empty();
        _this.container.getElement(".message-text").empty();
        this.currentQuestion++;
        this.answeredQuestions++;
        this.firstTry = true;
        this.firstTryCorrect = false;
        this.canContinue = false;
        this.render();

        try {
            // $$(".answers button")[0].focus();
        } catch (ex) {
        }
        $$('.note.question')[0].setAttribute('tabindex', '0');
        $$('.note.question')[0].focus();
    },
    finishQuiz: function() {
        var _this = this;
        _this.container.getElement(".question").empty();
        _this.container.getElement(".answers").empty();
        _this.container.getElement(".message").empty();
        _this.container.getElement(".message-text").empty();

        var final_message = "";
        if (_this.container.getElement(".note.final-message") != null)
            final_message = _this.container.getElement(".note.final-message").get("html");

        var mss = new Score(_this.options.data.length, _this.correctAnswered).getMessage();
        _this.container.getElement(".instruction").set("html", mss + "<br/>" + final_message);

        if (_this.correctAnswered == _this.options.data.length) {
            _this.container.getElement(".instruction").addClass("allcorrect");
        }
        this.nextEl.hide();
        this.resetEl.show();
        // this.resetEl.focus();
    },
    createAnswerDOM: function(answer) {
        var _this = this;
        var answer_dom = new Element("li.answer");
        var answer_radio = new Element("input.answer-radio");
        answer_radio.set("value", answer.aid);
        answer_radio.set("type", "radio");
        answer_radio.set("id", "radio" + answer.aid);
        answer_radio.set("name", "answer");
        answer_radio.set("tabindex", "-1");
        answer_radio.inject(answer_dom);

        var answer_button = new Element("button");

        // if (answer.tabindex == null || answer.tabindex != false) {
        //     answer_button.set("tabindex", answer.tabindex != null ? answer.tabindex : 0);
        // }
        answer_button.set("html", answer.label);
        answer_button.set("data-rid", "radio" + answer.aid);
        answer_button.inject(answer_dom);


        answer_button.addEvent("click", function(e) {
            var rid = this.getProperty("data-rid");
            _this.container.getElement("li.answer input[type='radio']").removeProperty("checked");
            $(rid).setProperty("checked", "checked");
            _this.nextEl.removeProperty("disabled");

            _this.checkSelected($(rid));
        });

        answer_radio.addEvent("change", function() {
            _this.checkSelected(this);
        });

        return answer_dom;
    },
    checkSelected: function(el) {
        var _this = this;

        if (_this.currentQuestionObject.correct == el.getProperty("value")) {
            _this.canContinue = true;
            _this.nextEl.removeProperty("disabled");
      
            $$('.next')[0].focus();
        }
        else {
            _this.canContinue = false;
            this.nextEl.setProperty("disabled", "disabled");
        }

        if (_this.firstTry && _this.currentQuestionObject.correct == el.getProperty("value")) {
            _this.firstTryCorrect = true;
        }
        else {
            _this.firstTryCorrect = false;
        }
        _this.firstTry = false;

        var ind = 0;
        Array.each(_this.currentQuestionObject.answers, function(e, i) {
            if (e.aid == el.getProperty("value")) {
                ind = i;
            }
        });

        _this.noticeCorrectIncorrect(ind);
    },
    noticeCorrectIncorrect: function(answer_index) {


        var _this = this;



        _this.container.getElement(".note.message").removeClass("correct");
        _this.container.getElement(".note.message").removeClass("incorrect");

        if (_this.canContinue) {
            _this.container.getElement(".note.message").set("html", "Correct.");
            _this.container.getElement(".note.message").addClass("correct");

            _this.container.getElement(".note.message-text").set("html", _this.currentQuestionObject.answers[answer_index].fallbackResponse);
        }
        else {
            _this.container.getElement(".note.message").set("html", "Incorrect.");
            _this.container.getElement(".note.message").addClass("incorrect");

            _this.container.getElement(".note.message-text").set("html", _this.currentQuestionObject.answers[answer_index].fallbackResponse);
        }
    },
    // render - updates the widget display
    render: function() {
        this.parent();
        var _this = this;

        if (_this.options.data != null) {


            if (_this.answeredQuestions == _this.options.data.length) {
                _this.finishQuiz();
                return;
            }

            var question_o = _this.options.data[_this.currentQuestion];
            _this.renderQuestion(question_o);
        }
    },
    renderQuestion: function(question) {
        var _this = this;
        _this.currentQuestionObject = question;
        _this.container.getElement(".answers").empty();
        _this.container.getElement(".message").empty();
        _this.container.getElement(".instruction").removeClass("allcorrect");

        _this.container.getElement(".note.question").set("html", question.question);
        // if (question.tabindex == null || question.tabindex != false) {
        //     _this.container.getElement(".note.question").set("tabindex", question.tabindex != null ? question.tabindex : 0);
        // }

        if (question.answers != null) {
            var cont = 0;
            Array.each(question.answers, function(e, i) {
                if (e.aid == null) {
                    e.aid = cont;
                }
                var a = _this.createAnswerDOM(e);
                a.inject(_this.container.getElement(".answers"));
                cont++;
            });
        }
    }
});