/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
*/

function MyVirtualChildViewModel(virtualchild_data) {
    var self = this;

    this.virtualchild = virtualchild_data;

    this.status = 'status-initial';
    this.currentQuestionNumber = 1;
    this.totalQuestions = this.virtualchild.length;

    this.getQuestionNumber = function() {
        if (this.status == 'status-initial') {
            return self.currentQuestionNumber + ' of ' + self.totalQuestions;
        }
        return ' ';
    }

    this.currentQuestion = function() {
        return self.virtualchild[self.currentQuestionNumber - 1];
    }

    this.answerSelect = function(answerIndex) {
        if (self.status == 'status-initial') {
            self.virtualchild[self.currentQuestionNumber - 1].state = answerIndex + 1;
            $$('.MyVirtualChild .answers').addClass('answer-selected');
            $$('.MyVirtualChild .answer').removeClass('selected');
            $$('.MyVirtualChild .answer')[answerIndex].addClass('selected');
            $$('.MyVirtualChild .next-question').removeProperty('disabled');
        }
        return false;
    }

    this.getHeadText = function() {
        if (self.status == 'status-feedback') {
            return self.currentQuestion().head + ': Feedback';
        }
        else if (self.status == 'status-compare') {
            return self.currentQuestion().head + ": Your Peers’ Choices";
        }
        return self.currentQuestion().head;
    }

    this.getFeedback = function() {
        if (self.currentQuestion().state == 0) {
            return '';
        }
        return self.currentQuestion().feedbackArr[self.currentQuestion().state - 1].feedbackTxt;
    }

    this.activatePercentages = function() {
        $$('.MyVirtualChild').addClass('percentages-active');
        $$('.MyVirtualChild .activate-percentages').set('disabled', 'disabled');

        return false;
    }

    this.getContinueText = function() {
        if (self.status == 'status-initial' && self.currentQuestionNumber == self.totalQuestions) {
            $$('.MyVirtualChild .next-question').removeProperty('disabled');
            return 'View Feedback';
        }
        else if (self.status == 'status-feedback' || self.currentQuestionNumber < self.totalQuestions) {
            $$('.MyVirtualChild .next-question').removeProperty('disabled');
            return 'Next';
        }
        else {
            $$('.MyVirtualChild .next-question').set('disabled', 'disabled');
            return 'Next';
        }
    }

    this.previous = function() {
        if (self.currentQuestionNumber == 1) {
            self.currentQuestionNumber = self.totalQuestions;
            if (self.status == 'status-compare') {
                self.status = 'status-feedback';
            }
        }
        else {
            self.currentQuestionNumber--;
        }
        self.render();

        return false;
    }

    this.continue = function() {
        if (self.currentQuestionNumber + 1 <= self.totalQuestions) {
            self.currentQuestionNumber++;
        }
        else if (self.status == 'status-feedback' && self.currentQuestionNumber == self.totalQuestions) {
            self.status = 'status-compare';
            self.currentQuestionNumber = 1;
            $$('.MyVirtualChild .answer').removeProperty('tabindex');
        }
        else {
            self.status = 'status-feedback';
            self.currentQuestionNumber = 1;
            $$('.MyVirtualChild .answer').removeProperty('tabindex');
        }
        self.render();
        $$("*[tabindex]")[0].focus();

        return false;
    }

    this.reset = function() {
        self.virtualchild = virtualchild_data;

        self.status = 'status-initial';
        self.currentQuestionNumber = 1;
        self.totalQuestions = self.virtualchild.length;

        self.render();
        $$('.MyVirtualChild .reset').hide();

        return false;
    }

    $$('.MyVirtualChild .next-question').addEvent('click', self.continue);
    $$('.MyVirtualChild .previous-question').addEvent('click', self.previous);
    $$('.MyVirtualChild .reset').addEvent('click', self.reset);

    this.render = function() {
        $$('.MyVirtualChild').set('class', 'MyVirtualChild ' + self.status);
        $$('.MyVirtualChild .widget-header').set('class', 'widget-header question-' + self.currentQuestionNumber);
        $$('.MyVirtualChild .widget-header h3').set('html', self.getHeadText());
        $$('.MyVirtualChild .widget-header h3').set('tabindex', 0);
        $$('.MyVirtualChild .question').set('html', self.currentQuestion().question);
        $$('.MyVirtualChild .question').set('tabindex', 0);
        $$('.MyVirtualChild .instruction').set('tabindex', 0);
        var answer_row = $$('.MyVirtualChild .answer')[0].clone();
        $$('.MyVirtualChild .answers').set('html', '');
        for (var i = 0; i < self.currentQuestion().answersArr.length; i++) {
            answer_row.removeClass('selected');
            answer_row.getElement('.answer-text').set('html', self.currentQuestion().answersArr[i].answerTxt);
            answer_row.inject($$('.MyVirtualChild .answers')[0]);
            answer_row = answer_row.clone();
        };
        $$('.MyVirtualChild .answer').each(function(element, index) {
            element.addEvent('click', function(e) {
                self.answerSelect(index);
            });
            element.addEvent('keydown', function(e) {
                if (e.which == 13 || e.code == 13 || e.which == 32 || e.code == 32) {
                    this.fireEvent('click');
                    return false;
                }
            });
        });
        if (self.status == 'status-feedback') {
            $$('.MyVirtualChild .feedback-head').set('html', self.currentQuestion().feedback_head + ', you chose&hellip;');
            $$('.MyVirtualChild .feedback-head').set('tabindex', 0);
        }
        else {
            $$('.MyVirtualChild .feedback-head').set('html', self.currentQuestion().feedback_head + ', students chose&hellip;');
            $$('.MyVirtualChild .feedback-head').set('tabindex', 0);
        }
        $$('.MyVirtualChild .feedback').set('html', self.getFeedback());
        $$('.MyVirtualChild .feedback').set('tabindex', 0);
        $$('.MyVirtualChild .next-question').set('html', self.getContinueText());
        if (self.status == 'status-initial') {
            $$('.MyVirtualChild .answers').removeClass('answer-selected');
            $$('.MyVirtualChild .next-question').set('disabled', 'disabled');
        }
        if (self.status == 'status-feedback') {
            $$('.MyVirtualChild .answer')[self.currentQuestion().state - 1].addClass('selected');
            $$('.MyVirtualChild .answer.selected').set('tabindex', 0);
            if (self.currentQuestionNumber == 1) {
                $$('.MyVirtualChild .previous-question').set('disabled', 'disabled');
            }
            else {
                $$('.MyVirtualChild .previous-question').removeProperty('disabled');
            }
        }
        if (self.status == 'status-compare') {
            $$('.MyVirtualChild .previous-question').removeProperty('disabled');
            self.renderBarChartResult();
        }
        if (self.status == 'status-compare' && self.currentQuestionNumber == this.totalQuestions) {
            $$('.MyVirtualChild .next-question').hide();
            $$('.MyVirtualChild .reset').show();
        }
        else {
            $$('.MyVirtualChild .next-question').show();
            $$('.MyVirtualChild .reset').hide();
        }
    },

    this.renderBarChartResult = function() {
        var self = this;
        var data = [];
        var surveyans=this.survey_questions;
        var count = 0;
        var result_container = $$('.chart-area > div')[0];
        result_container.set('html','');
        var optionsTable =  new Element('table', {
                id: 'optionstable',
                class: 'results-table',
                border: 0,
                cellspacing: 0, 
                cellpadding: "3px",
                width: "100%"
            })
            .inject(result_container);
        var row =  new Element('tr')
            .inject(optionsTable);
        var column =  new Element('th',{'html':"<strong>Response</strong>", 'colspan':'2', 'class': 'first-column-header'})
            .inject(row);
        column =  new Element('th',{'html':""})
            .inject(row);
        column =  new Element('th',{'html':"<strong>Percentage</strong>", 'class': 'last-column-header'})
            .inject(row);
        for (var i = 0; i < this.currentQuestion().answersArr.length; i++) {
            var selected = false;
            if (self.currentQuestion().state - 1 == i) 
                selected = true;
            row =  new Element('tr', {tabIndex: '0', ariaLabel: 'original question'})
                .inject(optionsTable);
            column =  new Element('td',{'html':this.currentQuestion().answersArr[i].answerTxt,'colspan':'2', 'class': 'response ' + (selected ? "user-choice" : "other-choice")})
                .inject(row);
            column =  new Element('td')
                .setStyles({'width': '40%'})
                .inject(row);
            var dvper = new Element('div', {'html' : selected ? '<span class="offscreen">&nbsp;</span>': ''})
                .setStyles({'width':self.currentQuestion().percentagesArr[i].percentageTxt+'%'
                    ,'background-color': selected ? '#f54e5d' : '#feedec'
                    ,'height':'20px'})
                    .inject(column);
            column =  new Element('td',{'html':self.currentQuestion().percentagesArr[i].percentageTxt, 'class': 'response ' + (selected ? "user-choice" : "other-choice")})
                .inject(row);
        };    
        row =  new Element('tr')
            .inject(optionsTable);
        if ($$('#optionstable tr:first-child td')[0]) {
            $$('#optionstable tr:first-child td')[0].focus();
        }
    }
}
 