RouteMap = new Class({
    Implements: [Options, Events],

    options: {
        duration: 1800
    },

    paths: [],
    position_map: [],

    ready: false,
    map_type: 'main',

    maps: {
        main: null,
        zoom: null
    },

    initialize: function(options) {
        var _this = this;
        this.setOptions(options);
        this.container = this.options.container;

        this.maps.main = this.container.getElement('.map.map-main');
        // create slider knob actions
        $$('.slider .knob').addEvent('mousedown', function() {
            this.addClass('mousedown');
        });
        $$('body, .slider .knob').addEvent('mouseup', function() {
            $$('body, .slider .knob').removeClass('mousedown');
        });
        
        $$('.start-animation').addEvent('click', function(){
            _this.startAnimation(_this.slider);            
        });
        $$('.reset-animation').addEvent('click', function(){
            _this.resetAnimation(_this.slider);            
        });
        $$('.knob').addEvent('mousedown', function() {
            $$('.start-animation').removeClass('hidden');
            $$('.reset-animation').addClass('hidden');
            clearInterval(_this.animTime);
        });
        
        if(this.container.getElements(".map-key li label > div").length>0){
          this.container.getElements(".map-key li label > div")
          .addEvent("keypress", function(e,i){
              
              if(e.key=="enter" || e.key=="space"){
                  
                  var check = this.getParent("li").getElement("input");
                  var isc = check.get("checked");
                  if(check.get("checked")){
                    check.set("checked",false);
                  }
                  else{
                    check.set("checked",true);
                  }
                  var map_layer = _this.container.getElement("#_" + check.get("id"));
                  if(check.get("checked")){
                      map_layer.show();
                  }
                  else{
                      map_layer.hide();
                  }
              }
          });
        }
        /* // NEVER USE FOCUS WHEN INITIALIZING A WIDGET
        if($$("*[tabindex]").length>0){
          $$("*[tabindex]")[0].focus();
        }
        else if($$(".start-animation").length>0){
          $$(".start-animation")[0].focus();
        }*/
    },
    startAnimation: function(sld) {
        _this = this;
        var max = sld.max;
        var counter = (sld.step < sld.max) ? sld.step : this.options.data.initial;
        
        _this.slider.set(counter++);

        $$('.start-animation').addClass('hidden');
        $$('.reset-animation').removeClass('hidden');
        $$('.reset-animation')[0].focus();
        
        _this.animTime = setInterval(function() {
            _this.slider.set(counter++);
            if (counter === max + 1) {
                clearInterval(_this.animTime);
                $$('.start-animation').removeClass('hidden');
                $$('.reset-animation').addClass('hidden');
                sld.step = _this.options.data.initial;
            }
        }, 2000);
    },
    resetAnimation: function(sld) {
        //var counter = sld.step + 1;
        $$('.start-animation').removeClass('hidden');
        $$('.reset-animation').addClass('hidden');
        $$('.start-animation')[0].focus();
        clearInterval(_this.animTime);
        //_this.slider.set(counter);
    },
    initializePaths: function() {
        var paths;
        
        paths = this.container.getElements('.path-group');
        for (var i = 0; i < paths.length; i++) {
            this.paths.push({
                el_id: paths[i].get('id'),
                year: +paths[i].get('data-year'),
                path: paths[i].getElement('path'),
                polygon: paths[i].getElement('polygon'),
                text: paths[i].getElement('text'),
                line: paths[i].getElement('line'),
                map: paths[i].closest('.map').get('data-map')
            });
        };
        this.paths.sort(function(a, b) {
            return a.year - b.year;
        });
    },

    initializeSlider: function(snap) {
        var position,
            _this = this;

        this.path_positions = this.container.getElement('.path-positions');

        for (var i = 0; i <= this.options.data.slider_range; i++) {
            position = false;
            for (var j = 0; j < this.options.data.positions.length; j++) {
                if (this.options.data.positions[j].position == i) {
                    position = this.options.data.positions[j].year;
                    new Element('li', {
                        html: this.options.data.positions[j].year
                    }).inject(this.container.getElement('.year-labels'));
                }
            };
            this.position_map[i] = position ? position : this.position_map[0] + i;

            new Element('li', {
                'data-year': this.position_map[i],
                'data-sld-step': i
            }).inject(this.path_positions);
        };

        this.slider = new Slider( $$('.slider')[0], $$('.slider .knob')[0], {
            snap: (snap !== undefined ? snap : true),
            steps: this.options.data.slider_range,
            range: [0, this.options.data.slider_range],
            parent_element: _this,
            wheel: true,
            maxWidth: $$('.slider .line')[0].getDimensions().width,
            onChange: function(intStep) {
                _this.sliderChange(intStep);
            }
        });

        this.init_timer = setInterval(function() {
            if (this.position_map.length > 0) {
                clearTimeout(this.init_timer);
                this.fireEvent('ready');
            }
        }.bind(this), 10);
        this.addEvent('ready', this.onReady);
    },

    onReady: function() {
        var _this = this;
        var index, li;

        this.ready = true;

        this.slider.set(this.options.data.initial);
        
        for (var i = 0; i < this.paths.length; i++) {
            li = this.path_positions.getElement('li[data-year="' + this.paths[i].year + '"]');

            if (li) {
                li.addEvent('keyup', function(e) {
                    if (e.key == 'tab') {
                        _this.slider.set(+this.get('data-sld-step'));
                    }
                })
                .addEvent('click', function(e) {
                  _this.slider.set(this.get('data-sld-step'));
                });

                var color = this.getColor(this.paths[i]),
                    elements = li.getElements('span[data-color="' + color + '"]');            
                if( color != "none" ){
                    if(this.paths[i].text || (this.paths[i].text!=null && this.paths[i].text.getAttribute('data-alt-text'))){
                      new Element('span', {
                          'data-map': this.paths[i].map,
                          'data-color' : color,
                          'tabindex':0,
                          'role':"button",
                          'aria-label':  (this.paths[i].text) ? (this.paths[i].text.getAttribute('data-alt-text')) ? this.paths[i].text.getAttribute('data-alt-text') : this.paths[i].text.get('text').clean() : '',
                          //'aria-hidden': this.paths[i].text || (this.paths[i].text!=null && this.paths[i].text.getAttribute('data-alt-text'))?"false":"true"
                      })
                      .setStyle('background-color', this.getColor(this.paths[i]))
                      .inject(li);
                    }
                    else{
                      new Element('span', {
                        'data-map': this.paths[i].map,
                        'data-color' : color,
                        'tabindex':0,
                        'aria-hidden': "true"
                      })
                      .setStyle('background-color', this.getColor(this.paths[i]))
                      .inject(li);
                    }
                }
            }
        };
    },

    initializeHotSpot: function() {
        this.hotspot = this.container.getElement('.hotspot');
        this.hotspot.addEvent('click', function() {
            this.showZoomMap();
        }.bind(this));
        this.close_zoom = this.container.getElement('button.close');
        this.close_zoom.addEvent('click', function() {
            this.hideZoomMap();
        }.bind(this));
        this.maps.zoom = this.container.getElement('.map.map-zoom');
    },

    initializePanZoom: function() {
        this.pan_zoom = this.container.getElement('.pan-zoom');
        this.controls = {
            container: this.container.getElement('.pan-zoom-controls'),
            zoom_in: this.container.getElement('.pan-zoom-controls .zoom-in'),
            zoom_out: this.container.getElement('.pan-zoom-controls .zoom-out'),
            zoom_reset: this.container.getElement('.pan-zoom-controls .zoom-reset'),
        };
        this.controls.zoom_in.addEvent('click', function() {
            this.zoomIn();
        }.bind(this));
        this.controls.zoom_out.addEvent('click', function() {
            this.zoomOut();
        }.bind(this));
        this.controls.zoom_reset.addEvent('click', function() {
            this.zoomReset();
        }.bind(this));

        this.zoom = {
            container_size: {
                x: this.pan_zoom.getDimensions().x,
                y: this.pan_zoom.getDimensions().y
            },
            current_value: {
                zoom: 100,
                scrollLeft: 0,
                scrollTop: 0
            },
            delta: 20,
            max_in: 300,
            max_out: 100
        };

        this.controls.container.show();
        this.pan_zoom.addClass('pan-zoom-active');

        new Drag.Scroll(this.pan_zoom, {
            axis: {x: true, y: true}    
        });
    },

    zoomIn: function() {
        if (this.zoom.current_value.zoom >= this.zoom.max_in) {
            return false;
        }
        this.zoomTo(this.zoom.current_value.zoom + this.zoom.delta, 0.1);
    },

    zoomOut: function() {
        if (this.zoom.current_value.zoom <= this.zoom.max_out) {
            return false;
        }
        this.zoomTo(this.zoom.current_value.zoom - this.zoom.delta, -0.1);
    },

    zoomReset: function() {
        this.zoomTo(100, 0);
    },

    zoomTo: function(value, factor) {
        this.maps.main.set('data-zoom', value);
        this.pan_zoom.scrollLeft = this.zoom.container_size.x * (this.pan_zoom.scrollLeft / this.zoom.container_size.x + factor);
        this.pan_zoom.scrollTop = this.zoom.container_size.y * (this.pan_zoom.scrollTop / this.zoom.container_size.y + factor);

        this.zoom.current_value.zoom = value;
        this.zoom.current_value.scrollLeft = this.pan_zoom.scrollLeft;
        this.zoom.current_value.scrollTop = this.pan_zoom.scrollTop;
    },

    sliderChange: function(step) {
        if (window.widget_instance) {
//            console.log(step);
//            console.log(window.widget_instance.paths[step]);
//            console.log(window.widget_instance.position_map[step]);
            window.widget_instance.render(window.widget_instance.position_map[step]);
        }
    },

    getColor: function(path) {
        return path.path.getStyle('stroke');
    },

    showZoomMap: function() {
        if (this.zoom) {
            this.zoom.current_value.scrollLeft = this.pan_zoom.scrollLeft;
            this.zoom.current_value.scrollTop = this.pan_zoom.scrollTop;
            this.controls.container.hide();
        }

        this.map_type = 'zoom';
        this.maps.main.hide();
        this.maps.zoom.show();
    },

    hideZoomMap: function() {
        if (this.zoom) {
            this.controls.container.show();
        }

        this.map_type = 'main';
        this.maps.zoom.hide();
        this.maps.main.show();

        if (this.zoom) {
            this.pan_zoom.scrollLeft = this.zoom.current_value.scrollLeft;
            this.pan_zoom.scrollTop = this.zoom.current_value.scrollTop;
        }
    },

    render: function() {
        this.container.set('data-map', this.map_type);
    },

    getKeyByValue: function(object, value) {
        for(var prop in object) {
            if(object.hasOwnProperty(prop)) {
                if(object[prop] === value)
                    return prop;
            }
        }
    }
});

Element.implement({
   closest: function(selector) {
      var matches = $$(selector);
      var cur = this;
      while (cur && !matches.contains(cur)) {
         cur = cur.getParent();
      }
      return cur;
   }
});