/*

IDPF ePub Widget Framework
MIT License
Demos: http://widgets.chaucercloud.com

*/
var viewport_width = 500;

function calculateHeightElement(el) {
    if (el && el.getElement("img") != null) {
        if (el.getElement(".caption-text") == null) return;
        var captionclone = el.getElement(".caption-text").clone(true, true);
        captionclone.addClass("content-measure")
        captionclone.setStyles({
            position: "absolute",
            width: viewport_width + "px"
        });

        captionclone.inject($$("body")[0]);

        var size = $$(".content-measure")[0].getSize();
        $$(".content-measure").dispose();

        var image_height = el.getSize().y - size.y - 10;

        var current_image_size = el.getElement("img").getSize();
        if (current_image_size.x == 0 && current_image_size.y == 0) {
            Asset.image(el.getElement("img").get("src"), {
                onLoad: function () {
                    current_image_size = this.getSize();
                    if (current_image_size.x < current_image_size.y) {
                        el.getElement("img").setStyle("height", image_height);
                    }
                }
            })
        } else {
            if (current_image_size.x < current_image_size.y) {
                el.getElement("img").setStyle("height", image_height);
            }
        }
    }
}

(function () {


    var Loop = new Class({

        loopCount: 0,
        isLooping: false,
        loopMethod: function () {},

        setLoop: function (fn, delay) {
            wasLooping = this.isLooping;
            if (wasLooping) this.stopLoop();
            this.loopMethod = fn;
            this.loopDelay = delay || 3000;
            if (wasLooping) this.startLoop();
            return this;
        },

        stopLoop: function () {
            this.isLooping = false;
            clearInterval(this.periodical);
            return this;
        },

        startLoop: function (delay, now) {
            if (!this.isLooping) {
                this.isLooping = true;
                if (now) this.looper();
                this.periodical = this.looper.periodical(delay || this.loopDelay, this);
            };
            return this;
        },

        resetLoop: function () {
            this.loopCount = 0;
            return this;
        },

        looper: function () {
            this.loopCount++;
            this.loopMethod(this.loopCount);
            return this;
        }

    });

    var Gallery = this.Gallery = new Class({

        Implements: [Options, Events, Loop],

        options: {
            delay: 0,
            transition: 'crossFade',
            duration: 0,
            autoplay: false,
            dataAttribute: 'data-gallery',
            selector: '> *',
            initialSlideIndex: 0
        },

        transitioning: false,
        reversed: false,

        initialize: function (element, options, noSetup) {
            this.element = document.id(element);
            this.setOptions(options);
            if (!noSetup) this.setup();

        },

        setup: function (options) {
            if (options) this.setOptions(options);
            this.slides = this.element.getElements(this.options.selector);
            this.setupElement().setupSlides();
            this.current = this.current || this.slides[this.options.initialSlideIndex];
            if (this.current) {
                this.index = this.current.retrieve('gallery-index');
                calculateHeightElement(this.current);
                this.current.addClass("current");


                if (this.current.getElement(".iframe-wrapper") != null) {
                    this.current.getElement(".iframe-wrapper").adopt(new Element("iframe", {
                        src: this.current.getElement(".iframe-wrapper").get("data-src")
                    }));
                }
            }
            this.setLoop(this.show.pass(this.reversed ? 'previous' : 'next', this), this.options.delay);
            if (this.options.autoplay) this.play();
            return this;
        },



        show: function (slide, options) {
            if (slide == 'next' || slide == 'previous') slide = this[slide + 'Slide']();
            if (typeof slide == 'number') slide = this.slides[slide];
            if (slide == this.current || this.transitioning) return this;

            var _this = this;

            this.transitioning = true;
            this.current.store('gallery:oldStyles', this.current.get('style'));


            if (!(options && options.transition) && slide == null) return;

            var transition = (options && options.transition) ? options.transition : slide.retrieve('gallery-transition'),
                duration = (options && options.duration) ? options.duration : slide.retrieve('gallery-duration'),
                previous = this.current.setStyle('z-index', 1),
                next = this.reset(slide).setStyle('z-index', 0),
                nextIndex = this.index = next.retrieve('gallery-index')
            slideData = {
                previous: {
                    element: previous,
                    index: previous.retrieve('gallery-index')
                },
                next: {
                    element: next,
                    index: nextIndex
                }
            };


            previous.removeClass("current");

            this.fireEvent('show', slideData);

            Gallery.transitions[transition]({
                previous: previous,
                next: next,
                duration: duration,
                instance: this
            });

            if (previous.getElement(".iframe-wrapper") != null) {
                previous.getElement(".iframe-wrapper").empty();
            }

            if (next.getElement(".iframe-wrapper") != null) {
                next.getElement(".iframe-wrapper").adopt(new Element("iframe", {
                    src: next.getElement(".iframe-wrapper").get("data-src")
                }));
            }

            previous.setStyle('width', 0);
            (function () {
                previous.setStyle('visibility', 'hidden');
                this.fireEvent('showComplete', slideData);
                this.transitioning = false;
                previous.removeClass("current");
                calculateHeightElement(next);
                next.addClass("current");
            }).bind(this).delay(duration);

            this.current = next;
            return this;
        },

        play: function () {
            this.startLoop();
            this.fireEvent('play');
            return this;
        },

        pause: function () {
            this.stopLoop();
            this.fireEvent('pause');
            return this;
        },

        reverse: function () {
            this.setLoop(this.show.pass(this.reversed ? 'next' : 'previous', this), this.options.delay);
            this.reversed = !this.reversed;
            this.fireEvent('reverse');
            return this;
        },

        setupElement: function () {
            this.storeData(this.element);
            this.options.duration = this.element.retrieve('gallery-duration');
            this.options.transition = this.element.retrieve('gallery-transition');
            this.options.delay = this.element.retrieve('gallery-delay');
            if (this.element.getStyle('position') == 'static') this.element.setStyle('position', 'relative');
            return this;
        },

        setupSlides: function () {
            this.slides.each(function (slide, index) {
                slide.store('gallery-index', index).store('gallery:oldStyles', slide.get('style'));
                this.storeData(slide);
                slide.setStyle('visibility', (this.current || index == this.options.initialSlideIndex) ? '' : 'hidden');
                if (!this.current && index !== this.options.initialSlideIndex) {
                    slide.setStyle('width', 0);
                }
            }, this);
            return this;
        },

        storeData: function (element) {
            var ops = this.options;
            // default options
            element.store('gallery-transition', ops.transition);
            element.store('gallery-duration', ops.duration);
            if (element == this.element) element.store('gallery-delay', ops.delay);
            // override from data attribute
            var data = element.get(this.options.dataAttribute);
            if (!data) return this;
            Slick.parse(data).expressions[0].each(function (option) {
                element.store('gallery-' + option.tag, option.pseudos[0].key);
            });
            return this;
        },

        reset: function (slide) {
            return slide.set('style', slide.retrieve('gallery:oldStyles'));
        },

        nextSlide: function () {
            return this.slides[this.index + 1] || this.slides[0];
        },

        previousSlide: function () {
            return this.slides[this.index - 1] || this.slides.getLast();
        },

        toElement: function () {
            return this.element;
        }

    });

    Gallery.transitions = {};

    Gallery.defineTransition = function (name, fn) {
        Gallery.transitions[name] = fn;
    };

    Gallery.defineTransitions = function (transitions) {
        Object.each(transitions, function (item, index) {
            Gallery.defineTransition(index, item);
        });
    };

})();

// element extensions

Element.Properties.gallery = {

    set: function (options) {
        this.get('gallery').setup(options);
        return this;
    },

    get: function () {
        var instance = this.retrieve('gallery');
        if (!instance) {
            instance = new Gallery(this, {}, true);
            this.store('gallery', instance);
        }
        return instance;
    }

};

Element.implement({

    playGallery: function (options) {
        this.get('gallery').setup(options).play();
        return this;
    },

    pauseGallery: function () {
        this.get('gallery').pause();
        return this;
    }

});

// 19 transitions :D
Gallery.defineTransitions({

    none: function (data) {
        data.previous.setStyle('display', 'none');
        return this;
    },

    fade: function (data) {
        data.previous.set('tween', {
            duration: data.duration
        }).fade('out');
        return this;
    },

    crossFade: function (data) {
        data.previous.set('tween', {
            duration: data.duration
        }).fade('out');
        data.next.set('tween', {
            duration: data.duration
        }).fade('in');
        return this;
    },

    fadeThroughBackground: function (data) {
        var half = data.duration / 2;
        data.next.set('tween', {
            duration: half
        }).fade('hide');
        data.previous.set('tween', {
            duration: half,
            onComplete: function () {
                data.next.fade('in');
            }
        }).fade('out');
        return this;
    }

});

(function () {

    function getStyles(direction) {
        return {
            property: (direction == 'left' || direction == 'right') ? 'left' : 'top',
            inverted: (direction == 'left' || direction == 'up') ? 1 : -1
        };
    }

    function go(type, styles, data) {
        var tweenOptions = {
            duration: data.duration,
            unit: '%'
        };
        if (type == 'blind') {
            data.next.setStyle('z-index', 2);
        }
        if (type != 'slide') {
            data.next
                .set('tween', tweenOptions)
                .setStyle(styles.property, 100 * styles.inverted + '%');
            data.next.tween(styles.property, 0);
        }
        if (type != 'blind') {
            data.previous
                .set('tween', tweenOptions)
                .tween(styles.property, -(100 * styles.inverted));
        }
    }

    ['left', 'right', 'up', 'down'].each(function (direction) {

        var capitalized = direction.capitalize(),
            blindName = 'blind' + capitalized,
            slideName = 'slide' + capitalized;

        [
            ['push' + capitalized, (function () {
                var styles = getStyles(direction);
                return function (data) {
                    go('push', styles, data);
                }
            }())],

            [blindName, (function () {
                var styles = getStyles(direction);
                return function (data) {
                    go('blind', styles, data);
                }
            }())],

            [slideName, (function () {
                var styles = getStyles(direction);
                return function (data) {
                    go('slide', styles, data);
                }
            }())],

            [blindName + 'Fade', function (data) {
                this.fade(data)[blindName](data);
                return this;
            }]
        ].each(function (transition) {
            Gallery.defineTransition(transition[0], transition[1]);
        });
    });

})();


var epubWidget = epubWidget || {};
epubWidget.AbstractWidget = new Class({
    Implements: [Events, Options],
    initialize: function (widgetName, el, options) {
        this.name = widgetName;
        this.el = el;
        $(this).addClass('epubWidget-widget');
        $(this).addClass('epubWidget-' + widgetName);
        this.setOptions(options);
    },
    toElement: function () {
        return this.el;
    }
});


var epubWidget = epubWidget || {};
epubWidget.Gallery = new Class({
    Extends: epubWidget.AbstractWidget,
    //DEFAULT OPTIONS
    options: {
        images: null,
        thumbnails: false,
        size: null,
        clickToNext: false
    },
    initialize: function (el, slideShowInfo, sliderInfo, options) {
        this.parent("gallery", $(el), options);
        this.options.images = [];

        for (var i = 0; i < $$('[data-md-editable="md-portal-media-list-item"] img').length; i++) {
            var type = $$('[data-md-editable="md-portal-media-list-item"] img')[i].getAttribute('type') || "image";
            var filepath = $$('[data-md-editable="md-portal-media-list-item"] img')[i].getAttribute('filepath') || $$('[data-md-editable="md-portal-media-list-item"] img')[i].get('src');
            var src = $$('[data-md-editable="md-portal-media-list-item"] img')[i].get('src');

            switch (type) {
            case "iframe":
                src = filepath;
                break;
            }
            this.options.images.push({
                src: src,
                type: type
            });
        };

        if (this.options.images) {
            var mainImageOuter = new Element('div', {
                'class': 'main-image-outer'
            });
            //var mainImageInner = new Element('div', {'class': 'main-image-inner'});
            slideShowInfo.el = new Element('div', {
                'class': 'main-image-inner'
            });

            mainImageOuter.adopt(slideShowInfo.el);
            //mainImageInner.adopt(slideShowInfo.el);

            this.el.empty();
            this.options.images.each(function (img) {
                var wrapperEl = new Element('div', {
                    'class': 'slide-wrapper wraptocenter'
                });
                var slideWrapperHeight = this.options.thumbnails ? this.options.size.height - 90 : this.options.size.height;
                if (this.options.size) {
                    wrapperEl.setStyles({
                        width: this.options.size.width + "px",
                        height: slideWrapperHeight + "px"
                    })
                }

                var mediatype = img.type;


                switch (mediatype) {
                case "image":
                case "video":
                    var imgEl = new Element('img', {
                        src: img.src,
                        exif: false
                    });
                    wrapperEl.adopt(new Element('span'));
                    wrapperEl.adopt(imgEl);
                    slideShowInfo.el.adopt(wrapperEl);
                    break;
                case "iframe":
                    var imgEl = new Element('div.iframe-wrapper', {
                        "data-src": img.src,
                        exif: false
                    });
                    wrapperEl.adopt(imgEl);
                    slideShowInfo.el.adopt(wrapperEl);
                    break;
                }


                if ($$('body')[0].hasClass('md-edit-mode')) {
                    var textarea = new Element("div.data-md-editable.image-content-text.md-track-changes", {
                        contenteditable: 'true',
                        'data-md-editable': "md-content-editable-element",
                        'data-md-field-type': 'media-gallery-caption'
                    });
                    wrapperEl.adopt(textarea);
                } else {
                    var textarea = new Element("p.caption-text", {});
                    wrapperEl.adopt(textarea);
                }

            }.bind(this));
            this.el.adopt(mainImageOuter);
        }
        if (this.options.size) {
            this.el.setStyles({
                width: this.options.size.width + "px",
                height: this.options.size.height + "px"
            });
        }

        if (this.options.thumbnails) {
            this.appendThumbnails(slideShowInfo.el);
            this.el.getElements('.main-image-outer').setStyle('height', this.el.getHeight() - 90);
        }

        this.gallery = new Gallery(slideShowInfo.el, slideShowInfo.options);

        if (this.options.clickToNext) {
            this.el.addEvent('click', function (e) {
                e.preventDefault();
                this.gallery.show('next');
            }.bind(this))
        }
        $(this.gallery).addEvents({
            swipe: function (event) {
                gallery['show' + ((event.direction == 'left') ? 'Next' : 'Previous')]({
                    transition: 'blind' + event.direction.capitalize()
                });
            }.bind(this),
            mousedown: function (event) {
                //event.stop();
            }
        });

        if (sliderInfo) {
            this.slider = new Slider(sliderInfo.el, sliderInfo.knob, sliderInfo.options);
            this.slider.addEvent('change', function (pos) {
                this.current = pos;
                if (this.gallery.slides.length <= pos) {
                    return;
                }

                this.gallery.show(pos);
            }.bind(this));
        }
    },
    appendThumbnails: function (el) {
        var thumbWrapOuter = new Element('div', {
            'class': 'thumb-wrapper-outer'
        });
        var thumbWrapInner = $$('[data-md-editable="md-portal-media-list"]')[0];
        thumbWrapInner.addClass('thumb-wrapper-inner');

        thumbWrapOuter.adopt(thumbWrapInner);

        var images = thumbWrapInner.getElements('img');

        images.each(function (img, i) {
            img.set({
                'data-pos': i,
                'exif': 'false'
            });
        });

        if (thumbWrapInner.getChildren().length > 0)
            thumbWrapInner.getChildren()[0].addClass("selected");

        thumbWrapInner.getChildren().addEvent('click', function (e) {
            e.preventDefault();

            if (e.event.currentTarget.hasClass("drag-indication-box")) {
                return;
            }
            this.gallery.show(parseInt(e.event.currentTarget.getElement("img").getAttribute('data-pos')));


            thumbWrapInner.getChildren().removeClass("selected");
            e.event.currentTarget.addClass("selected");

        }.bind(this));

        this.el.adopt(thumbWrapOuter);
    }
});


MediaGallery = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
        container: null,
        images: []
    },
    editModeFlag: false,

    initialize: function (options) {
        this.parent({
            container: $("contents")
        });
        this.render();
    },

    bindEditMode: function () {
        this.editModeFlag = true;
        var that = this;

        var lastitem = $$('[data-md-editable="md-portal-media-list"]')[0];
        new Element("div.drag-indication-box.drop-zone", {
            html: "Click here or drag an<br/> image or video to add<br/> it to this gallery."
        }).inject(lastitem, "bottom");

        $$('[data-md-editable="md-portal-media-list-item"]:not(.processed)').each(function (e, i) {
            new Element('a.md-portal-media-list-item-button.md-edit-remove', {
                'href': '#',
                'html': '<i class="fa fa-times"></i>'
            }).inject(e);

            new Element('a.md-portal-media-list-item-button.md-edit-slide', {
                'href': '#',
                'html': '<u>EDIT</u>'
            }).inject(e);

            e.addClass("processed");
        });

        if ($$('[data-md-editable="md-portal-media-list"] .drop-zone:not(.drageventbind)').length > 0) {

            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondragover = function (e) {
                this.addClass('dragover');
                return false;
            };
            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondragend = function (e) {
                $$('[data-md-editable="md-portal-media-list"] .drop-zone').removeClass('dragover');
                return false;
            };
            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].ondrop = function (e) {
                e.preventDefault();

                var extensions = ".jpg,.jpeg,.gif,.png,.mp3,.mp4";
                extensions = extensions.replace(/\./g, '');
                extensions = extensions.split(",");

                var flag_no_errors = false;

                Array.each(e.dataTransfer.files, function (value, key) {
                    can_be_added = false
                    extensions.each(function (ext, ind) {
                        if (value.name.indexOf("." + ext) > 0 || value.type.indexOf("/" + ext) > 0)
                            can_be_added = true
                    })

                    if (can_be_added) {
                        flag_no_errors = true;
                    }

                });


                if (!flag_no_errors) {
                    alert("This field doesn't accept this file type. The file types accepted are .jpg,.jpeg,.gif,.png,.mp3,.mp4");
                    return;
                }

                if (parent && parent != window) {
                    parent.postMessage({
                        method: 'files-begin-upload'
                    }, "*");
                }


                var container = '[data-md-editable="md-portal-media-list"]';
                $$(container).removeClass('dragover');
                that.uploadFile(e.dataTransfer.files, container);
                return false;
            };

            $$('[data-md-editable="md-portal-media-list"] .drop-zone')[0].addClass("drageventbind");
        }

        $$('.md-edit-remove').addEvent('click', function () {
            if (confirm("Are you sure you want to delete this element from the gallery?"))
                that.removeFile(this.getParent().getAttribute("data-md-id"), this.getSiblings('img')[0].getAttribute('src'), this.getParent());
            that.notifyFocusCapture();
            return false;
        });
        $$('.md-edit-alt-text').addEvent('click', function () {
            if (parent && parent != window) {
                parent.postMessage({
                    method: 'edit-alt-text',
                    type: "textfield",
                    id: this.getParent().getAttribute("data-md-id"),
                    content: this.getParent().getElement('img').get('alt')
                }, "*");
                that.notifyFocusCapture();
            }
            return false;
        });
        $$('.md-edit-image-id').addEvent('click', function () {
            if (parent && parent != window) {
                parent.postMessage({
                    method: 'edit-image-id',
                    type: "textfield",
                    promptText: "Enter the image ID",
                    id: this.getParent().getAttribute("data-md-id"),
                    content: this.getParent().getAttribute("data-md-image-id")
                }, "*");
                that.notifyFocusCapture();
            }
            return false;
        });

        $$('.md-edit-slide').addEvent('click', function () {
            if (parent && parent != window) {
                parent.postMessage({
                    method: 'show-media-popup',
                    id: this.getParent().getAttribute("data-md-id")
                }, "*");
                that.notifyFocusCapture();
            }
            return false;
        });




        $$('.drag-indication-box').addEvent('click', function () {
            if (parent && parent != window) {
                parent.postMessage({
                    method: 'show-media-popup'
                }, "*");
            }
            return false;
        });

    },

    removeFile: function (file_id, file_src, element) {
        this.saveRequest({
            img_src: file_src,
            method: 'remove',
            element: file_id,
            no_delete_image: element.get("data-md-no-delete-image") != "" && element.get("data-md-no-delete-image") == "1" ? true : false
        });
    },

    altText: function (id) {
        alert(id);
    },

    uploadFile: function (files, containerSelector) {
        var that = this;
        var formData = new FormData();
        var multimediaType = "image";
        var multimediaTypeFormat = "";
        for (var i = 0; i < files.length; i++) {
            if (files[i].type.indexOf("video") != -1) {
                multimediaType = "video";
            }
            multimediaTypeFormat = files[i].type;
            formData.append('file', files[i]);
        }

        var pathUpload = location.href;
        if (pathUpload.indexOf("?") > 0) {
            pathUpload = pathUpload.split("?")[0];
        }

        formData.append('path', pathUpload);
        formData.append('directory', 'images');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', this.root + 'api/index.php/upload/');
        xhr.onload = function () {

            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                var img_path = response.path;

                var imagepath, filepath;
                imagepath = filepath = 'images/' + response.filename;
                if (multimediaType == "video") {
                    imagepath = "https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
                }

                if (parent && parent != window) {
                    parent.postMessage({
                        method: 'files-end-upload'
                    }, "*");
                }

                that.saveRequest({
                    //path: path,
                    method: 'appendMultimedia',
                    element: containerSelector,
                    type: 'md-portal-media-list-element',
                    content: imagepath,
                    filePath: filepath,
                    multimediaType: multimediaType,
                    multimediaTypeFormat: multimediaTypeFormat
                });
            } else {
                alert(xhr.status + ' Error uploading image. Please contact the system administrator.');
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },

    postMessageReceived: function (message, path) {
        this.parent(message, path);

        var that = this;
        switch (message.data.method) {
        case 'edit-alt-text':
            that.saveRequest({
                method: 'setAttribute',
                attribute: 'alt',
                content: message.data.data.content,
                innerElement: 'img',
                id: message.data.id,
                path: path
            });
            break;
        case "toggle-attribute":
            that.saveRequest({
                method: 'setAttributeById',
                attribute: message.data.content,
                value: message.data.value,
                id: message.data.id,
                path: path
            });
            break;
        case "edit-image-id":
            that.saveRequest({
                method: 'setAttribute',
                attribute: 'data-md-image-id',
                content: message.data.data.content,
                id: message.data.id,
                path: path
            });
            break;

        case "retrieve-change-history":
            if (message.data.data.length > 0) {
                var container = $$("[data-md-field-id='" + message.data.id + "']").getParent();
                this.addFieldChangeTrackingControl(container[0], message.data.data, message.data.id);
            } else {
                $$("[data-md-field-id='" + message.data.id + "']")[0].getParent().getElements("a.md-track-changes-control").dispose();
                $$("[data-md-field-id='" + message.data.id + "']")[0].getParent().getElements("div.md-track-changes-show").dispose();
            }
            break;
        case "track-tracking-change-status":

            if (message.data && message.data.status == 2) {
                var text = $$(".slide-wrapper.current .md-track-changes-show")[0].get("text").trim();
                var ind = $$(".slide-wrapper").indexOf($$(".slide-wrapper.current")[0]);
                that.saveRequestProcedure(null, {
                    method: "setAttribute",
                    id: $$('[data-md-editable="md-portal-media-list-item"]')[ind].get("data-md-id"),
                    attribute: "data-md-caption",
                    content: text
                });

            }

            if (message.data.data.length > 0) {

                var container = $$("[data-md-field-id='" + message.data.id + "']").getParent();
                this.addFieldChangeTrackingControl(container[0], message.data.data, message.data.id);
            } else {
                $$("[data-md-field-id='" + message.data.id + "']")[0].getParent().getElements("*:not([data-md-field-id])").dispose();
                $$("[data-md-field-id='" + message.data.id + "']")[0].getParent().getElements("*[data-md-field-id]").show();
            }

            break;
        case 'widget-test-difference':
            $$(".md-track-changes-preview-" + message.data.id).set("html", message.data.diff);
            that.saveRequestProcedure($$(".md-track-changes-editor-" + message.data.id)[0], {
                method: "setAttribute",
                track_id: message.data.track_id,
                content: message.data.change
            });
            break;
        case "show-media-popup":

            var imagepath, filepath, multimediaTypeFormat, multimediaType, caption = "",
                defaultImage = false,
                copyFile = false,
                attributes = {};
            filepath = 'images/' + message.data.data.source_value;
            imagepath = "https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
            multimediaType = multimediaTypeFormat = message.data.data.source_type;

            if (multimediaType == "pearson") {
                multimediaType = "iframe";
                filepath = message.data.data.source_value;
            }

            if (multimediaType == "internet") {
                multimediaType = "iframe";
                filepath = message.data.data.source_value;
                if (filepath.indexOf(".png") > 0 || filepath.indexOf(".jpg") > 0 || filepath.indexOf(".jpeg") > 0) {
                    multimediaType = "image";
                }
            }

            if (multimediaType == "text") {
                multimediaType = multimediaTypeFormat = "image";
                caption = message.data.data.source_value;
                defaultImage = true;
                imagepath = filepath = "";
            }

            if (multimediaType == "folder") {
                multimediaType = "image";
                multimediaTypeFormat = message.data.data.source_ext;
                imagepath = filepath = message.data.data.source_value;
                attributes["data-md-no-delete-image"] = true;
            }

            if (multimediaType == "computer") {

                if (message.data.data.source_ext.indexOf("image/") != -1) {
                    multimediaType = "image";
                    multimediaTypeFormat = message.data.data.source_ext;
                    imagepath = filepath = message.data.data.source_value;
                }
                if (message.data.data.source_ext.indexOf("video/") != -1) {
                    multimediaType = "video";
                    multimediaTypeFormat = message.data.data.source_ext;
                    filepath = message.data.data.source_value;
                }

                copyFile = true;

            }



            var containerSelector = '[data-md-editable="md-portal-media-list"]';

            that.saveRequest({
                path: path,
                method: message.data.id ? 'updateMultimedia' : 'appendMultimedia',
                element: containerSelector,
                type: 'md-portal-media-list-element',
                content: imagepath,
                filePath: filepath,
                multimediaType: multimediaType,
                multimediaTypeFormat: multimediaTypeFormat,
                mustCopyTheFile: copyFile,
                caption: caption,
                defaultImage: defaultImage,
                id: message.data.id ? message.data.id : null,
                attributes: attributes
            });

            break;

        case "toggleHTML":
            that.saveRequestProcedure(null, {
                method: "toggleHTML",
                selector: message.data.wrapper,
                elementID: message.data.elementID,
                toggle: "" + message.data.value
            }, null, function () {
                document.location.reload();
            });
            break;

        default:
            console.warn('media-gallery Unknown message', message);
        }
    },
    render: function () {
        new epubWidget.Gallery(this.container, {
            options: {
                "delay": 4000,
                "autoplay": false,
                "transition": "fade",
                "size": {
                    "height": "500",
                    "width": "600"
                }
            }
        }, undefined, {
            "size": {
                "height": "500",
                "width": "600"
            },
            "images": this.options.images,
            "thumbnails": true,
            "clickToNext": false
        });

        var that = this;

        if (this.editModeFlag) {

            $$('[data-md-editable="md-portal-media-list-item"]').each(function (e, i) {
                if ($$(".slide-wrapper").length > 0 && $$(".slide-wrapper")[i].getElement("div.data-md-editable") != null) {
                    $$(".slide-wrapper")[i].getElement("div.data-md-editable").set("html", e.get("data-md-caption"))
                        .set('data-md-field-id', e.get('data-md-id'));

                    var a = $$(".slide-wrapper")[i].getElement("div.data-md-editable").get('html');
                    var b = a;
                    setInterval(function () {
                        a = $$(".slide-wrapper")[i].getElement("div.data-md-editable").get('html');
                        if (a != b) {
                            $$(".slide-wrapper")[i].getElement("div.data-md-editable").fireEvent('keyup');
                            b = a;
                        }
                    }, 1000);
                }
            });

            $$("div.data-md-editable").addEvent("keyup", function (e) {
                var ind = $$(".slide-wrapper").indexOf(this.getParents(".slide-wrapper")[0]);
                that.saveRequestProcedure(this, {
                    method: "setAttribute",
                    id: $$('[data-md-editable="md-portal-media-list-item"]')[ind].get("data-md-id"),
                    attribute: "data-md-caption",
                    content: this.get("html")
                });
            });

            $$("div.data-md-editable").addEvent("click", function () {
                that.notifyFocusCapture();
            });

            setTimeout(function () {
                if ($$('[data-md-widget-mode-vertical="1"]').length > 0)
                    $$(".epubWidget-gallery .thumb-wrapper-outer")[0].scrollTo(0, 5000)
                else
                    $$(".epubWidget-gallery .thumb-wrapper-outer")[0].scrollTo(5000, 0)
            }, 250);

            new Sortables('[data-md-editable="md-portal-media-list"]', {
                onSort: function () {
                    var newlist = $$('[data-md-editable="md-portal-media-list"]')[0].clone();
                    newlist.getElement(".drop-zone").dispose();

                    newlist.getElements('[data-md-editable="md-portal-media-list-item"]').removeClass("processed");
                    newlist.getElements('[data-md-editable="md-portal-media-list-item"] > img').removeProperty("data-pos");
                    newlist.getElements('[data-md-editable="md-portal-media-list-item"] > img').removeProperty("exif");
                    newlist.getElements('[data-md-editable="md-portal-media-list-item"] > a').dispose();
                    newlist.getElements('div:not([data-md-editable])').dispose();

                    that.saveRequestProcedure(newlist, {
                        selector: '[data-md-editable="md-portal-media-list"]',
                        html: newlist.get('html'),
                        method: "setHTML"
                    });
                }
            });


        } else {
            $$('[data-md-editable="md-portal-media-list-item"]').each(function (e, i) {
                if ($$(".slide-wrapper").length > 0 && $$(".slide-wrapper")[i].getElement(".caption-text") != null)
                    $$(".slide-wrapper")[i].getElement(".caption-text").set("html", e.get("data-md-caption"));
            });
        }

        calculateHeightElement($$(".slide-wrapper.current")[0]);


        this.bindChangeTracking();
    },
    onTrackChangeApproved: function () {
        return $$(".slide-wrapper.current .md-track-changes-show")[0].get("text").trim();
    }

});