ScrollGallery = new Class({
    Implements: [Options, Events],

    // Set initial options here
    options: {

    },

    scrollAdjust: {
        top: 0,
        bottom: 0
    },

    chapters: [],
    imageMaps: [],
    currentChapter: 0,
    eventLock: false,
    preventLock: false,

    isTouchDevice: function () {
        return !!('ontouchstart' in window);
    },

    // initialize - widget initialization
    initialize: function (options) {
        var chapters,
            _this = this;

        this.setOptions(options);

        this.createDOM();

        this.body = this.options.container.getElement('section.body');
        this.left_nav = this.options.container.getElement('.chapters');

        this.height = this.body.getDimensions().height;

        chapters = this.body.children;
        for (var i = 0; i < chapters.length; i++) {
            this.chapters.push(new ScrollGallery_Chapter({
                el: chapters[i],
                id: i,
                element_class: 'chapter-' + (i + 1)
            }));
        };

        this.chapter_padding = parseInt(this.chapters[0].el.getStyle('padding-bottom'));

        this.clickEvent = this.isTouchDevice() ? 'touchstart' : 'click';

        // initial conditions
        this.body.addClass('locked');

        // // events
        this.left_nav.getElements('a').addEvent(this.clickEvent, function (e) {
            _this.chapterClick(this);
            return false;
        });
        // JPA: uncomment the following commented lines to enable chapter change by scroll
        // this.options.container.getElements('.column-2').addEvent('scroll', function(e) {
        //     _this.scrollEvent(this);
        // });
        this.options.container.getElements('.column-2').addEvent('mousewheel', function (e) {
            if (!/(MSIE 9|MSIE 10|rv:11.0)/i.test(navigator.userAgent)) {
                e.preventDefault();
                this.scrollTop += e.event.deltaY;
            }
        });
        this.addEvent('currentChapterChange', function () {
            _this.currentChapterChange();
        });
        this.options.container.getElement('.start').addEvent(this.clickEvent, function (e) {
            _this.start();
            return false;
        });
        this.options.container.getElements('.play-audio').addEvent(this.clickEvent, function (e) {
            _this.playAudio(this, this.getParent().getElement('audio'));
            return false;
        });

        this.initAccessibility();
    },

    createDOM: function () {
        var nav_a, title,
            _this = this,
            body = $('gallery'),
            container = $$('.widget-content')[0],
            aside = new Element('aside.chapters'),
            nav = new Element('nav').inject(aside),
            chapters = body.children;
        body.addClass('body').addClass('locked');
        container.adopt(aside);
        container.adopt(body);

        for (var i = 0; i < chapters.length; i++) {
            title = chapters[i].getElement('.title').get('html');
            nav_a = new Element('a.chapter-' + (i + 1), {
                href: '#',
                tabindex: 0
            }).inject(nav);
            chapters[i].getElement('.thumbnail')
                .set('alt', title)
                .inject(nav_a);
            chapters[i].getElement('.fig-number')
                .inject(nav_a);
            if (i == 0) {
                nav_a.addClass('active');
            }


            scalemarker = false
            if (chapters[i].getElement('.data-scale-button') != null) {
                scalemarker = chapters[i].getElement('.data-scale-button').get('data-scale-button');
            }


            video = false
            if (chapters[i].getElement('.video-url') != null) {
                video = chapters[i].getElement('.video-url').get('data-video-url');
            }



            chapters[i].set('data-chapter', i + 1);
            var column1 = new Element('div.chapter.chapter-' + (i + 1)).inject(
                new Element('div.column.column-1').inject(chapters[i])
            );
            var column2 = new Element('div.chapter.chapter-' + (i + 1)).inject(
                new Element('div.column.column-2').inject(chapters[i])
            );


            if (video == false) {

                var imagemap_el = new Element('div.smartwidget.smartwidget-placeholder.smartwidget-imagemap', {
                    'data-show-navigator': 'true',
                    'data-controls': chapters[i].hasClass('landscape') ? 'right' : 'bottom',
                    'data-scale-button': scalemarker,
                    'data-autozoom': 'true'
                }).inject(column1);
                imagemap_el.adopt(chapters[i].getElement('.main-image').set('alt', title));

            } else {
                /*var videoIframe = new Element('iframe.chapter-iframe',{
										'border' : '0',
										src : video,
										width :300,
										height: 550,											
								}).inject(column1);*/


                var myIFrame = new IFrame({
                    id: 'iframe_content',
                    src: video,
                    styles: {
                        width: 350,
                        height: 550,
                        overflow: 'hidden'
                    }
                }).inject(column1);


            }


            column2.adopt(chapters[i].getElement('.title'));
            column2.adopt(chapters[i].getElement('.sub-title'));
            column2.adopt(chapters[i].getElement('.content'));

            if (i + 1 == chapters.length) {
                new Element('button.next-chapter', {
                    html: 'Start Over',
                    'data-next-chapter': 0,
                    events: {
                        click: function (e) {
                            _this.currentChapter = +this.get('data-next-chapter');
                            _this.scrollToChapter(_this.currentChapter);
                            _this.fireEvent('currentChapterChange');
                            _this.options.container.getElements('.column-2').each(function (e, i) {
                                e.scrollTop = 0;
                            });
                        }
                    }
                }).inject(chapters[i].getElement('.content'));
            } else {
                new Element('button.next-chapter', {
                    html: 'Next',
                    'data-next-chapter': i + 1,
                    events: {
                        click: function (e) {
                            _this.currentChapter = +this.get('data-next-chapter');
                            _this.scrollToChapter(_this.currentChapter);
                            _this.fireEvent('currentChapterChange');
                        }
                    }
                }).inject(chapters[i].getElement('.content'));
            }
        };
    },

    start: function () {
        this.options.container.getElement('.splash-screen').destroy();
        this.render();
        this.fireEvent('currentChapterChange');
        $$('nav a').set('tabindex', 0);
    },

    scrollEvent: function (el) {
        if (el.scrollTop - this.scrollAdjust.top <= 0 && this.currentChapter > 0) {
            this.currentChapter--;
            this.scrollToChapter(this.currentChapter);
            this.fireEvent('currentChapterChange');
        }
        if (el.offsetHeight + el.scrollTop + this.scrollAdjust.bottom >= el.scrollHeight && (this.currentChapter + 1) < this.chapters.length) {
            this.currentChapter++;
            this.scrollToChapter(this.currentChapter);
            this.fireEvent('currentChapterChange');
        }
    },

    widgetScroll: function () {
        var previous_chapter = this.chapters[this.currentChapter - 1],
            next_chapter = this.chapters[this.currentChapter + 1];

        if (this.eventLock) {
            return false;
        }

        if (next_chapter) {

            if (this.height + this.left.scrollTop - next_chapter.el.offsetTop > this.height) {
                this.currentChapter++;
                this.fireEvent('currentChapterChange');
                this.right
                    .scrollTo(0, this.height * this.currentChapter);
            } else if (this.height + this.left.scrollTop - next_chapter.el.offsetTop > 0) {
                this.right
                    .scrollTo(0, this.height * (this.currentChapter + 1) + this.left.scrollTop - next_chapter.el.offsetTop);
            }

        }

        if (previous_chapter) {

            if (this.chapters[this.currentChapter].el.offsetTop - this.left.scrollTop > this.height) {
                this.currentChapter--;
                this.fireEvent('currentChapterChange');
                this.right
                    .scrollTo(0, this.height * this.currentChapter);
            } else if (this.chapters[this.currentChapter].el.offsetTop - this.left.scrollTop > 0) {
                this.right
                    .scrollTo(0, this.height * this.currentChapter + this.left.scrollTop - this.chapters[this.currentChapter].el.offsetTop);
            }

        }

    },

    chapterClick: function (element) {
        var _this = this,
            chapter_number = false;
        element.get('class').split(' ').each(function (e, i) {
            if (e.substr(0, 8) == 'chapter-') {
                chapter_number = e.substr(8, 1);
            }
        });
        if (chapter_number !== false) {
            this.currentChapter = chapter_number - 1;
            this.scrollToChapter(this.currentChapter);
            this.fireEvent('currentChapterChange');
        }
    },

    scrollToChapter: function (chapter) {
        if (this.chapters[chapter]) {
            scrollTo(widget_instance.body, this.chapters[chapter].el.offsetTop, null, 800)
        }
    },

    currentChapterChange: function () {
        var _this = this;
        this.left_nav.getElements('a').removeClass('active');
        this.left_nav.getElement('a.chapter-' + (this.currentChapter + 1)).addClass('active');

        $$('.column-2').removeProperty('tabindex');
        $$('.map-control').removeProperty('tabindex');
        $$('.column-2')[this.currentChapter].set('tabindex', 0);
        $$('article')[this.currentChapter].getElements('.map-control').set('tabindex', 0);

        var reset_prevent_scroll = setTimeout(function () {
            _this.preventLock = false;
        }, 850);


    },

    playAudio: function (button, audio) {
        if (!audio) {
            return false;
        }

        if (button.hasClass('active')) {
            this.stopAudio(audio);
            button.removeClass('active');
            button.getElement('i').removeClass('fa-volume-up').addClass('fa-volume-off');
        } else {
            audio.play();
            button.addClass('active');
            button.getElement('i').removeClass('fa-volume-off').addClass('fa-volume-up');
        }
    },

    stopAudio: function (audio) {
        audio.pause();
        try {
            audio.currentTime = 0;
        } catch (e) {
            // iOS bug
        }
    },

    initAccessibility: function () {
        $$('a.image-map').set('tabindex', -1);
        $$('nav a').set('tabindex', -1);
    },

    // render - updates the widget display
    render: function () {
        var defaultZoom,
            _this = this,
            elements = this.options.container.getElements('.smartwidget-imagemap');
        this.left_nav.setStyle('height', this.options.container.getDimensions().height);

        try {
            _this.imageMaps.push(new StandardImageMap(elements, {
                "showZoomControls": true
            }));
            $$('.map-control').addEvent('keydown', function (e) {
                if (e.which == 13 || e.code == 13 || e.which == 32 || e.code == 32) {
                    this.fireEvent('click', e);
                }
            });
        } catch (e) {
            console.log(e);
            console.log("Widget init error: cannot create ImageMap.");
        }
    }
});

ScrollGallery_Chapter = new Class({
    Implements: [Options, Events],

    options: {},

    isTouchDevice: function () {
        return !!('ontouchstart' in window);
    },

    initialize: function (options) {
        var _this = this;
        this.setOptions(options);

        this.el = this.options.el;

        this.clickEvent = this.isTouchDevice() ? 'touchstart' : 'click';

        this.el.getElements('p a.image-map').addEvent(this.clickEvent, function (e) {
            _this.zoomPan(this.get('data-zoom'), this.get('data-pan-x'), this.get('data-pan-y'));
            return false;
        });

        this.render();
    },

    zoomPan: function (zoom, pan_x, pan_y) {
        widget_instance.imageMaps[0].objects[widget_instance.currentChapter].setZoom(zoom);
        widget_instance.imageMaps[0].objects[widget_instance.currentChapter].setPan(pan_x, pan_y);
    },

    render: function () {}
});

// easing functions http://goo.gl/5HLl8
Math.easeInOutQuad = function (t, b, c, d) {
    t /= d / 2;
    if (t < 1) {
        return c / 2 * t * t + b
    }
    t--;
    return -c / 2 * (t * (t - 2) - 1) + b;
};

Math.easeInCubic = function (t, b, c, d) {
    var tc = (t /= d) * t * t;
    return b + c * (tc);
};

Math.inOutQuintic = function (t, b, c, d) {
    var ts = (t /= d) * t,
        tc = ts * t;
    return b + c * (6 * tc * ts + -15 * ts * ts + 10 * tc);
};

// requestAnimationFrame for Smart Animating http://goo.gl/sx5sts
var requestAnimFrame = (function () {
    return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || function (callback) {
        window.setTimeout(callback, 1000 / 60);
    };
})();

function scrollTo(doc, to, callback, duration) {
    // figure out if this is moz || IE because they use documentElement
    // var doc = (navigator.userAgent.indexOf('Firefox') != -1 || navigator.userAgent.indexOf('MSIE') != -1) ? document.documentElement : document.body,
    start = doc.scrollTop,
        change = to - start,
        currentTime = 0,
        increment = 20;
    duration = (typeof (duration) === 'undefined') ? 500 : duration;
    var animateScroll = function () {
        // increment the time
        currentTime += increment;
        // find the value with the quadratic in-out easing function
        var val = Math.easeInOutQuad(currentTime, start, change, duration);
        // move the document.body
        doc.scrollTop = val;
        // do the animation unless its over
        if (currentTime < duration) {
            requestAnimFrame(animateScroll);
        } else {
            if (callback && typeof (callback) === 'function') {
                // the animation is done so lets callback
                callback();
            }
        }
    };
    animateScroll();
}