SelectableTable = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
        container: null,
        mode: 'columns'     // rows | columns
    },

    selectedIndex: 0,
    viewAll: false,

    editModeFlag: false,

    initialize: function(options) {
        var that = this;
        this.parent(options);

        this.table = this.container.getElement('table.selectable-table');
        this.cells = this.table.getElements('td, th');
        this.cells.addEvent(this.clickEvent, function(e) {
            that.clickedCell(this);
        });
        this.view_all_btn = this.container.getElement('.view-all');
        this.view_all_btn.addEvent(this.clickEvent, function(e) {
            that.toggleViewAll();
        });

        this.render();
    },

    postMessageReceived: function(message,path) {
        this.parent(message, path);

        var that = this;
        switch (message.data.method) {
            default:
                console.warn('fill-in-the-blank Unknown message', message);
        }
    },

    clickedCell: function(cell) {
        var that = this;
        this.viewAll = false;
        if (this.options.mode == 'columns') {       // columns mode
            cell.getParent().getChildren().each(function(e,i) {
                if (e == cell) {
                    that.selectedIndex = i;
                }
            });
        }
        else {                                      // rows mode
            cell.getParent().getParent().getChildren().each(function(e,i) {
                if (e == cell.getParent()) {
                    that.selectedIndex = i;
                }
            });
        }
        this.view_all_btn.innerHTML = "View All";
        this.render();
    },

    toggleViewAll: function() {
        this.viewAll = !this.viewAll;
        if(!this.viewAll){
            this.view_all_btn.innerHTML = "View All";
        } else {
            this.view_all_btn.innerHTML = "View One at a Time";
        }
        this.render();
    },

    render: function() {
        var rows, row;
        this.container.getElements('.selected').removeClass('selected');

        if (this.viewAll) {
            this.table.addClass('view-all');
        }
        else {
            this.table.removeClass('view-all');
            if (this.options.mode == 'columns') {       // columns mode
                var rows = this.table.getElements('tr');
                for (var i = 0; i < rows.length; i++) {
                    rows[i].getChildren()[this.selectedIndex].addClass('selected');
                };
            }
            else {                                      // rows mode
                row = this.table.getElements('tbody tr')[this.selectedIndex];
                row.addClass('selected');
                row.getElements('td').addClass('selected');
            }
        }
        
        // this.bindChangeTracking();
    }

});