SelectedResponse = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    /**
     * Set initial options here, including:
     *   total_answers: (defaults to 0)
     *
     *   hideElemColumn: true or false (defaults to false)
     *   shuffleAnswerBox: true or false (defaults to false)
     *   shuffleQuizRows: true or false (defaults to true)
     **/
    options: {
        hideElemColumn: false,
        shuffleAnswerBox: true,
        shuffleQuizRows: false
    },
    total_answers: 0,
    answerArray: [],
    // initialize - widget initialization
    initialize: function (options) {
        this.widgetBody;
        this.tableContainer = new Element('table');
        this.answersContainer = new Element('div.answers');
        
        this.parent(options);
        
        this.resetEl = this.container.getElement(".reset");
        this.resetEl.addEvent(this.clickEvent, this.resetListener.bind(this));

        this.checkEl = this.container.getElement(".check");
        this.checkEl.addEvent(this.clickEvent, this.checkAnswers.bind(this));
        this.checkEl.set('disabled', 'disabled');        
        
        this.render();
    },
    createDOM: function () {
        var _this = this;

        _this.widgetBody = this.options.container.getElement('.widget-body');
        _this.tableContainer.inject(_this.widgetBody);
        _this.answersContainer.inject(_this.widgetBody);

        _this.options.data.questions.each(function (question, i) {
            answer = new Element('div.answer-container', {
                html: '<div class="draggable drag-option answer" data-answer="' + i + '"><i class="fa fa-bars"></i>' + question.answer + '</div>'
            });

            _this.answerArray.push(answer);

            TR = new Element('tr').inject(_this.tableContainer);
            TD = new Element('td', {
                html: (i + 1)
            }).inject(TR);
            
            TD = new Element('td', {
                html: question.elem,
                'data-elem': i,
                'class': 'elem-cell'
            });
            if (!!_this.options.hideElemColumn) {
                TD.addClass('hidden');
            }
            TD.inject(TR);

            TD = new Element('td', {
                html: '<div class="droppable answer-holder" data-answer="' + i + '"></div>'
            }).inject(TR);

            _this.total_answers = i + 1;
        });

        /**
         * Check the instance options for
         *   'shuffleAnswerBox === true'
         * and then shuffle the answer array, which will randomize
         * the elements in the answer box.
         **/
        if (!!_this.options.shuffleAnswerBox) {
            _this.answerArray = _this.shuffle(_this.answerArray);
        }
        _this.answerArray.each(function (answer, i) {
            answer.inject(_this.answersContainer);
        }); // end answerArray.each

    },
    shuffle: function (o) {
        for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
        return o;
    },
    reorderTable: function () {
        var _this = this;

        rows = _this.tableContainer.getElements('tr');
        rows.dispose();

        /**
         * Read flag to shuffle quiz rows or not
         **/
        if (!!_this.options.shuffleQuizRows) {
            rows = this.shuffle(rows);
        } else {
            for (var i = 0; i < rows.length; i++) {
                rows[i].children[1].dataset.elem = i;
                rows[i].children[2].children[0].dataset.answer = i;
            } // end for()
        } // end else

        rows.each(function (row, i) {
            TR = new Element('tr', {
                html: row.innerHTML
            }).inject(_this.tableContainer);
        });

        rows.each(function (row, i) {
            row.getElements('td')[0].set('html', i + 1);
        });

        this.container.getElements(".draggable").makeDraggable({
            droppables: ".droppable",
            onDrag: function (draggable) {
                draggable.addClass("dragging");
            },
            onDrop: function (draggable, droppable) {
                _this.checkDrop(draggable, droppable);
            }
        });

        /**
         * Check the instance options for
         *   'shuffleAnswerBox === true'
         * and then shuffle the answer array, which will randomize
         * the elements in the answer box.
         **/
        if (!!_this.options.shuffleAnswerBox) {
            var answerElements = _this.answersContainer.getElementsByClassName('answer-container');
            for (var i = 0; i < answerElements.length; i++) {
                answerElements[i].dispose();
            }
            _this.answerArray = _this.shuffle(_this.answerArray);
        }
        _this.answerArray.each(function (answer, i) {
            answer.inject(_this.answersContainer);
        }); // end answerArray.each
    },
    resetListener: function () {
        var _this = this;
        var answersnotcorrect = this.container.getElements(".answer-holder:not(.answered)");

        _this.checkEl.set('disabled', 'disabled');

        if (answersnotcorrect.length > 0) {
            Array.each(answersnotcorrect, function (answerWrapper, ind) {
                if (answerWrapper.getElement(".answer") != null) {
                    _this.container.getElements('.answers .answer').setStyle('display', 'block');
                    _this.container.getElements('.droppable.dropped .answer').dispose();
                    _this.container.getElements('.droppable.dropped').removeClass('dropped');
                }
            });
        }
        
        var noteEl = document.getElementsByClassName('note');
        noteEl[0].textContent = "";
        
        _this.reorderTable();
    },

    checkAnswers: function () {
        answers = this.container.getElements('.dropped .answer');
        this.checkEl.set('disabled', 'disabled');

        if (answers.length > 0) {
            answers.each(function (answer, i) {

                my_answer = answer.get('data-answer');
                right_answer = answer.getParent('.dropped').get('data-answer');

                if (my_answer == right_answer) {
                    answer.addClass('correct');
                    answer.addClass('fa-check');
                } else {
                    answer.addClass('incorrect');
                    answer.addClass('fa-times');
                }
            });

        }

        var scoreMessageFunction = function() {
            return "Good job! You completed the challenge. You got " + this.correct + " out of " + this.total + " correct.";
        };
        
        $$('.note')[0].textContent = new Score(this.options.data.questions.length, $$('.answer.correct').length, scoreMessageFunction).getMessage();
    },

    resetAnswer: function (answerEl, answer, resetStyles) {
        old_contender = this.container.getElements('.answers .answer[data-answer="' + answer + '"]');
        old_contender.removeClass("dropped").setStyle('display', 'block');
        if (resetStyles) {
            answerEl.getParent().removeClass('dropped');
        }

        answerEl.dispose();
    },
    checkDrop: function (draggable, droppable) {
        var _this = this;
        draggable.removeClass("dragging");
        if (droppable == null) {
            draggable.setStyles({
                left: "auto",
                top: "auto"
            });
            return;
        }
        if (droppable != null && droppable.hasClass("answer-holder") && !draggable.hasClass("nodragg")) {
            droppable.addEvent(_this.clickEvent, function (e) {
                e.preventDefault();
                if (droppable.getElement(".answer") != null) {
                    _this.resetAnswer(droppable.getElement(".answer"), droppable.getElement(".answer").get('data-answer'), true);
                }
            });
            if (droppable.getElement(".answer") != null) {
                _this.resetAnswer(droppable.getElement(".answer"), droppable.getElement(".answer").get('data-answer'), false);
            }
            if (droppable.getElement(".answer") == null) {
                var newDrag = draggable.clone();
                newDrag.setStyles({
                    left: "auto",
                    top: "auto",
                    position: "static"
                });
                newDrag.set("tabindex", "-1");

                newDrag.inject(droppable);
                draggable.setStyles({
                    left: "auto",
                    top: "auto",
                    display: "none"
                }).addClass("dropped");

                droppable.addClass("dropped");

                if (_this.container.getElements('.droppable.dropped').length == _this.total_answers) {
                    _this.checkEl.removeProperty('disabled');
                }

            } else {
                draggable.setStyles({
                    left: "auto",
                    top: "auto"
                });
            }
        } else {
            draggable.setStyles({
                left: "auto",
                top: "auto"
            });
        }

    },
    // render - updates the widget display
    render: function () {
        this.parent();
        this.reorderTable();
    }
});