SequencingAssessment = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        data: {}
    },
    dataType: null,
    dataMode: null,
    assets:[
        '../_framework/_base_external/media-element/mediaelement.min.js',
        '../_framework/_base_external/media-element/mediaelementplayer.css'
    ],
    dragList: [],

    initialize: function(options) {
        var that = this;

        options.extra = [
            'data-type',
            'data-mode'
        ];

        if ($('MetrodigiWidget').get('data-type')) {
            this.dataType = $('MetrodigiWidget').get('data-type');
        }

        if ($('MetrodigiWidget').get('data-mode')) {
            this.dataMode = $('MetrodigiWidget').get('data-mode');
        }

        this.parent(options);
        if(this.dataType=="image") {
            this.options.options.each(function(item){
                if(item.value) {
                    hidden_element = new Element('img', {src: item.value});
                    $$("#MetrodigiWidget").adopt(hidden_element);
                    hidden_element.hide();
                }
            })
        }
    },

    render: function() {

        if (this.isEditMode) {
            return;
        }

        $$('.view-mode').show()
        if (this.dataMode == 'presentation-challenge') {

            this.viewModePresentation();
        } else {

            this.viewModeChallenge();
        }
    },

    viewModePresentation: function() {
        that = this;

        $$('.view-mode .presentation').show();
        $$('.view-mode .challenge').hide();
        $$('.view-mode .actions .next-button').show();
        $$('.view-mode .actions .back-button').hide();
        $$('.view-mode .actions .cancel-button').hide();
        $$('.view-mode .actions .check-button').hide();
        $$('.view-mode .actions .try-again-button').hide();

        var sequences = this.options.options;

        var widgetContent = $$('.MetrodigiWidget.container')[0];
        var introLine = $('intro-line');
        var viewModePresentationContent = $$('.view-mode .presentation .content');
        var viewModeChallengeContent = $$('.view-mode .challenge .content');
        switch(this.dataType) {
            case 'text':
                viewModePresentationContent.setStyle('width', 575);
                viewModePresentationContent.setStyle('height', 300);
                viewModePresentationContent.setStyle('margin-left', 60);
                viewModePresentationContent.setStyle('margin-top', 60);

                viewModeChallengeContent.setStyle('width', 575);
                viewModeChallengeContent.setStyle('height', 280);
                viewModeChallengeContent.setStyle('margin-left', 60);
                viewModeChallengeContent.setStyle('margin-top', 60);
            break;
            case 'image':

            break;
            case 'audio':

            break;
            case 'video':
                widgetContent.addClass('bgGray');
                if(introLine)
                    introLine.addClass('intro-line-white');
            break;
        }

        //list items
        var presentationList = $$('.view-mode .presentation .list .presentation-list')[0];
        var presentationContent = $$('.view-mode .presentation .content')[0];
        presentationList.set('html', '');
        presentationContent.set('html', '');

        sequences.each(function(sequence, index){
            var label = sequence.label;
            if(sequence.sequence_order_index == -1){
                var order_index = index;
            }else{
                var order_index = sequence.sequence_order_index;
            }

            var sequenceLI = new Element('li.sequence-item', {
                id: order_index,
                text: label
            }).inject(presentationList);
        });



        sequences.each(function(sequence, index){
            if(sequence.sequence_order_index == -1){
                var order_index = index;
            }else{
                var order_index = sequence.sequence_order_index;
            }
            var value = sequence.value;
            var source_type = sequence.source_type;
            var data = sequence.data;

            var sequenceContent = null;

            switch(that.dataType) {
                case 'text':
                    sequenceContent = new Element('div.sequence-content', {
                        id: order_index,
                        html: value,
                        styles: {
                            display: 'none',
                            'text-align': 'left'
                        }
                    });
                    break;
                case 'image':
                    sequenceContent = new Element('div.sequence-content', {
                                id: order_index,
                                styles: {
                                    display: 'none'
                                }
                            });


                    caption = new Element('span.caption', {
                        text: data.caption
                    }).inject(sequenceContent);

                    image = new Element('img', {
                        'src': value,
                        'alt': data.alt
                    }).inject(sequenceContent);

                    break;
                case 'audio':
                    sequenceContent = new Element('div.sequence-content', {
                                id: order_index,
                                styles: {
                                    display: 'none'
                                }
                            });
                    switch(source_type) {
                        case 'iframe':
                            iframe = new Element('iframe', {
                                id: 'widet-edit-container',
                                src: value,
                                styles: {
                                    width: 640,
                                    height: 385,
                                }
                            }).inject(sequenceContent);
                            break;
                        case 'local':
                            caption = new Element('span.caption', {
                                text: data.caption
                            }).inject(sequenceContent);

                            videoContainer = new Element('div', {
                                styles: {
                                    'text-align': 'center',
                                    'width': '100%'
                                }
                            }).inject(sequenceContent);
                            audio = new Element('audio', {
                                'src': value,
                                'controls': 'controls',
                                styles: {
                                    'max-height': 330
                                }
                            }).inject(videoContainer);
                            break;
                    }
                    break;
                case 'video':
                    sequenceContent = new Element('div.sequence-content', {
                                id: order_index,
                                styles: {
                                    display: 'none'
                                }
                            });

                    switch(source_type) {
                        case 'iframe':
                            iframe = new Element('iframe', {
                                id: 'widet-edit-container',
                                src: value,
                                styles: {
                                    width: 640,
                                    height: 375,
                                }
                            }).inject(sequenceContent);
                            break;
                        case 'local':
                            caption = new Element('span.caption', {
                                text: data.caption
                            }).inject(sequenceContent);

                            videoContainer = new Element('div', {
                                styles: {
                                    'text-align': 'center',
                                    'width': '100%'
                                }
                            }).inject(sequenceContent);
                            video = new Element('video', {
                                'src': value,
                                'controls': 'controls',
                                styles: {
                                    'max-height': 375
                                }
                            }).inject(videoContainer);
                            break;
                    }
                    break;
            }

            sequenceContent.inject(presentationContent);
        });

        //show first sequence
        var presentationContentItems = $$('.view-mode .presentation .content .sequence-content');
        var presentationListItems = $$('.view-mode .presentation .list .presentation-list .sequence-item');


        if (presentationContentItems.length > 0) {
            presentationContentItems[0].show();
        }

        if (presentationListItems.length > 0) {
            presentationListItems[0].addClass('selected');
        }

        //bind click event list element
        presentationListItems.removeEvents('click');
        presentationListItems.addEvent('click', function(){
            presentationListItems.removeClass('selected');
            $$('audio').each(function(el){
                el.pause();
                el.currentTime = 0;
            });
             $$('video').each(function(el){
                el.pause();
                el.currentTime = 0;
            });
            presentationContentItems.hide();
            var currenID = this.get('id');
            this.addClass('selected');
            presentationContentItems.each(function(contentItem){
                var iframe = contentItem.getElements('iframe');
                if(iframe) iframe.set('src', iframe.get('src'));

                if (contentItem.get('id') == currenID) {
                    contentItem.show();
                }
            });
        });

        var nextButton = $$('.view-mode .actions .next-button');
        nextButton.removeEvents('click');
        nextButton.addEvent('click', function(){
            that.viewModeChallenge();
        });
        var margin_left_used = 0;
        switch(presentationListItems.length) {
            case 1:
                presentationListItems[0].setStyle('margin-left', 290);
                margin_left_used = 290;
                break;
            case 2:
                presentationListItems[0].setStyle('margin-left', 225);
                margin_left_used = 225;
                break;
            case 3:
                presentationListItems[0].setStyle('margin-left', 165);
                margin_left_used = 165;
                break;
            case 4:
                presentationListItems[0].setStyle('margin-left', 100);
                margin_left_used = 100;
                break;
            case 5:
                presentationListItems[0].setStyle('margin-left', 30);
                margin_left_used = 30;
                break;
            case 6:
                presentationListItems.setStyle('margin-left', 1);
                margin_left_used = 1;
                break;
        }


        var sequence_width = $$(".widget-content")[0].getWidth()/sequences.length - margin_left_used*(sequences.length);

        if(sequence_width > 115){
            if($$("li.sequence-item")[0].getWidth()>sequence_width){
                $$("li.sequence-item").setStyle("width",sequence_width);
            }
        }

    },

    viewModeChallenge: function() {
        var that = this;
        var sequences = this.options.options;

        $$('.view-mode .presentation').hide();
        $$('.view-mode .challenge').show();

        $$('.view-mode .actions .next-button').hide();
        $$('.view-mode .actions .cancel-button').show();
        $$('.view-mode .actions .check-button').show();
        $$('.view-mode .actions .try-again-button').hide();

        if (this.dataMode == 'presentation-challenge') {
            $$('.view-mode .actions .back-button').show();
            var backButton = $$('.view-mode .actions .back-button');
            backButton.removeEvents('click');
            backButton.addEvent('click', function(){
                that.viewModePresentation();
            });
        } else {
            $$('.view-mode .actions .back-button').hide();
        }

        //list items
        var presentationList = $$('.view-mode .challenge .list .challenge-list')[0];
        var assessmentList = $$('.view-mode .challenge .list .assessment-list')[0];
        var presentationContent = $$('.view-mode .challenge .content')[0];

        presentationList.set('html', '');
        presentationContent.set('html', '');
        assessmentList.set('html', '');

        var sortedSequence = [];
        var saverandy = []

        sequences.each(function(sequence, index){
            var label = sequence.label;
            if(sequence.sequence_order_index == -1){
                var order_index = index;
            }else{
                var order_index = sequence.sequence_order_index;
            }

            var assessmentLI = new Element('li.sequence-item-drop', {
                id: order_index,
                html: "<div class='draggable-element'>"+label+"</div>",
                'data-label': label
            }).inject(assessmentList);

            var randy = that.randNumberItem(sequences, saverandy);
            sortedSequence[randy] = sequence;
            saverandy.push(randy);
        });


        sortedSequence.each(function(sortedItem, index){
            var label = 'Sequence #' + (index+1);
            var originalLabel = sortedItem.label;
            if(sortedItem.sequence_order_index == -1){
                var order_index = index;
            }else{
                var order_index = sortedItem.sequence_order_index;
            }

            var sequenceLI = new Element('li.sequence-item', {
                id: order_index,
                html: "<div class='label-wrapper' data-label='" + originalLabel + "' id='" + order_index + "'>" + label + "</div>",
                'data-value': sortedItem.label
            }).inject(presentationList);
        });

        sequences.each(function(sequence, index){
            if(sequence.sequence_order_index == -1){
                var order_index = index;
            }else{
                var order_index = sequence.sequence_order_index;
            }
            var value = sequence.value;
            var source_type = sequence.source_type;
            var data = sequence.data;

            var sequenceContent = null;
            switch(that.dataType) {
                case 'text':
                    sequenceContent = new Element('div.sequence-content', {
                        id: order_index,
                        html: value,
                        styles: {
                            display: 'none',
                            'text-align': 'left'
                        }
                    });
                    break;
                case 'image':
                    sequenceContent = new Element('div.sequence-content', {
                                id: order_index,
                                styles: {
                                    display: 'none'
                                }
                            });


                    caption = new Element('span.caption', {
                        text: data.caption
                    }).inject(sequenceContent);

                    image = new Element('img', {
                        'src': value,
                        'alt': data.alt
                    }).inject(sequenceContent);

                    break;
                case 'audio':
                    sequenceContent = new Element('div.sequence-content', {
                                id: order_index,
                                styles: {
                                    display: 'none'
                                }
                            });
                    switch(source_type) {
                        case 'iframe':
                            iframe = new Element('iframe', {
                                id: 'widet-edit-container',
                                src: value,
                                styles: {
                                    width: 736,
                                    height: 580,
                                }
                            }).inject(sequenceContent);
                            break;
                        case 'local':
                            caption = new Element('span.caption', {
                                text: data.caption
                            }).inject(sequenceContent);

                            videoContainer = new Element('div', {
                                styles: {
                                    'text-align': 'center',
                                    'width': '100%'
                                }
                            }).inject(sequenceContent);
                            audio = new Element('audio', {
                                'src': value,
                                'controls': 'controls',
                                styles: {
                                    'max-height': 330
                                }
                            }).inject(videoContainer);
                            break;
                    }
                    break;
                case 'video':
                    sequenceContent = new Element('div.sequence-content', {
                                id: order_index,
                                styles: {
                                    display: 'none'
                                }
                            });

                    switch(source_type) {
                        case 'iframe':
                            iframe = new Element('iframe', {
                                id: 'widet-edit-container',
                                src: value,
                                styles: {
                                    width: 640,
                                    height: 325,
                                }
                            }).inject(sequenceContent);
                            break;
                        case 'local':
                            caption = new Element('span.caption', {
                                text: data.caption
                            }).inject(sequenceContent);

                            videoContainer = new Element('div', {
                                styles: {
                                    'text-align': 'center',
                                    'width': '100%'
                                }
                            }).inject(sequenceContent);
                            video = new Element('video', {
                                'src': value,
                                'controls': 'controls',
                                styles: {
                                    'max-height': 340
                                }
                            }).inject(videoContainer);
                            break;
                    }
                    break;
            }

            sequenceContent.inject(presentationContent);
        });

        //show first sequence
        var presentationContentItems = $$('.view-mode .challenge .content .sequence-content');
        var presentationListItems = $$('.view-mode .challenge .list .challenge-list .sequence-item');
        var assessmentListItems = $$('.view-mode .challenge .list .assessment-list .sequence-item-drop');


        presentationContentItems.each(function(contentItem){
                if (contentItem.get('id') == presentationListItems[0].get('id')) {
                    contentItem.show();
                }
            });

        if (presentationListItems.length > 0) {
            presentationListItems[0].addClass('selected');
        }

        var tryAgainButton = $$('.view-mode .actions .try-again-button')[0];
        tryAgainButton.removeEvents('click');
        tryAgainButton.addEvent('click', function(){
            that.viewModeChallenge();
        });

        var checkButton = $$('.view-mode .actions .check-button')[0];
        checkButton.removeEvents('click');
        checkButton.addEvent('click', function(){

            assessmentListItems.each(function(item){
                var currenID = item.get('id');
                var dataOption = item.getAttribute('data-option');
                var dataLabel = item.getAttribute('data-label');
                var currentLabel = item.get('html');

                if (currenID == dataOption) {
                    item.addClass('option-ok');
                } else {
                    item.addClass('option-fail');
                    new Element('div.red-icon').inject(item);
                }
            });

            presentationListItems.removeClass('selected');
            presentationListItems.setStyle('cursor', 'default');
            presentationListItems.each(function(items) {
                items.removeEvents('click');
            });

            that.dragList.each(function(dragItem) {
                dragItem.detach();
            });

            $$('.view-mode .actions .check-button').hide();
            $$('.view-mode .actions .try-again-button').show();


        });

        var cancelButton = $$('.view-mode .actions .cancel-button')[0];
        cancelButton.removeEvents('click');
        cancelButton.addEvent('click', function(){
            that.viewModeChallenge();
        });

        //bind click event list element
        var presentation_list_items_click = function(){
            if(this.hasClass("dragOver")) return;
            presentationListItems.removeClass('selected');

            // Audio
            $$('audio').each(function(el){
                    el.pause();
                    el.currentTime = 0;
                });
            //Video
             $$('video').each(function(el){
                el.pause();
                el.currentTime = 0;
            });
            presentationContentItems.hide();

            var currenID = this.get('id');
            this.addClass('selected');
            presentationContentItems.each(function(contentItem){
                var iframe = contentItem.getElements('iframe');
                if(iframe) iframe.set('src', iframe.get('src'));

                if (contentItem.get('id') == currenID) {
                    contentItem.show();
                }
            });
        };
        presentationListItems.removeEvents('click');
        presentationListItems.addEvent('click', presentation_list_items_click);

        var sequenceList = $$('.view-mode .challenge ul.challenge-list div, .view-mode .challenge ul.assessment-list div.draggable-element');

        sequenceList.each(function(item) {
            var dragItem = item.makeDraggable({
                droppables: ".sequence-item-drop",
                onDrag: function (draggable) {
                    draggable.addClass("dragging");
                },
                onDrop: function (draggable, droppable, event) {
                    if(droppable){

                        if(!draggable.hasClass("draggable-element")){

                            if(droppable.get("data-option")!="" && droppable.get("data-option")!=null){
                                //to data
                                var to_label = droppable.get("data-label");
                                var to_item_id = droppable.get("data-option");
                                var to_item_label = $$(".view-mode .challenge .list ul.challenge-list li").indexOf($$(".view-mode .challenge .list ul.challenge-list li[id='"+to_item_id+"']")[0]);
                                to_item_label = "Sequence #"+(to_item_label+1);

                                 //set to data
                                droppable.set("data-option", draggable.get('id'));
                                droppable.getElement(".draggable-element").set("html",to_label + "<br/>" + draggable.get("html"));

                                $$(".view-mode .challenge .list ul.challenge-list li[id='"+to_item_id+"'] div")[0].show();
                                $$(".view-mode .challenge .list ul.challenge-list li[id='"+to_item_id+"']")[0].removeClass("dragOver");

                                liContainer = draggable.getParent();
                                draggable.hide();
                                //liContainer.set('html', '');
                                liContainer.addClass('dragOver');
                            }
                            else {

                                droppable.setAttribute('data-option', draggable.get('id'));
                                currentLabel = droppable.getAttribute('data-label');
                                droppable.getElement(".draggable-element").set("html", currentLabel + '<br/>' + draggable.get("html"));
                                droppable.getElement(".draggable-element").setStyle('padding-top', 7);
                                droppable.getElement(".draggable-element").setStyle('line-height', 17);
                                droppable.getElement(".draggable-element").setStyle('height', 41);

                                liContainer = draggable.getParent();
                                draggable.hide();
                                //liContainer.set('html', '');
                                liContainer.addClass('dragOver');
                            }



                        }
                        else if(draggable.getParent().get("data-option")!="" && draggable.getParent().get("data-option")!=null){
                            if(droppable.get("data-option")!="" && droppable.get("data-option")!=null){
                                //from data
                                var from_label = draggable.getParent().get("data-label");
                                var from_item_id = draggable.getParent().get("data-option");
                                var from_item_label = $$(".view-mode .challenge .list ul.challenge-list li").indexOf($$(".view-mode .challenge .list ul.challenge-list li[id='"+from_item_id+"']")[0]);
                                from_item_label = "Sequence #"+(from_item_label+1);
                                //to data
                                var to_label = droppable.get("data-label");
                                var to_item_id = droppable.get("data-option");
                                var to_item_label = $$(".view-mode .challenge .list ul.challenge-list li").indexOf($$(".view-mode .challenge .list ul.challenge-list li[id='"+to_item_id+"']")[0]);
                                to_item_label = "Sequence #"+(to_item_label+1);

                                //set from data
                                draggable.getParent().set("data-option", to_item_id);
                                draggable.set("html",from_label + "<br/>" + to_item_label);
                                draggable.setStyles({
                                    top:0,
                                    left:0
                                })

                                //set to data
                                droppable.set("data-option", from_item_id);
                                droppable.getElement(".draggable-element").set("html",to_label + "<br/>" + from_item_label);

                            }
                            else{
                                //from data
                                var from_label = draggable.getParent().get("data-label");
                                var from_item_id = draggable.getParent().get("data-option");
                                var from_item_label = $$(".view-mode .challenge .list ul.challenge-list li").indexOf($$(".view-mode .challenge .list ul.challenge-list li[id='"+from_item_id+"']")[0]);
                                from_item_label = "Sequence #"+(from_item_label+1);
                                //to data
                                var to_label = droppable.get("data-label");

                                //set from data
                                draggable.getParent().set("data-option", null);
                                draggable.set("html",from_label);
                                draggable.setStyle('padding-top', 0);
                                draggable.setStyle('line-height', "48px");
                                draggable.setStyle('height', "100%");

                                //set to data
                                droppable.set("data-option", from_item_id);
                                droppable.getElement(".draggable-element").set("html",to_label + "<br/>" + from_item_label);
                                droppable.getElement(".draggable-element").setStyle('padding-top', 7);
                                droppable.getElement(".draggable-element").setStyle('line-height', 17);
                                droppable.getElement(".draggable-element").setStyle('height', 41);
                            }
                        }

                        if($$(".view-mode .challenge .list ul.challenge-list li:not(.dragOver)").length>0){
                            //presentation_list_items_click.call($$(".view-mode .challenge .list ul.challenge-list li:not(.dragOver)")[0]);
                            $$(".view-mode .challenge .list ul.challenge-list li:not(.dragOver)")[0].click();
                        }
                    }

                    draggable.removeClass("dragging");
                    draggable.morph({
                        top: 0,
                        left: 0
                    });
                }
            });

            that.dragList.push(dragItem);
        });

        // this.container.getElements(".sequence-item > div").makeDraggable({
        //     droppables: ".sequence-item-drop",
        //     onDrag: function (draggable) {
        //         draggable.addClass("dragging");
        //     },
        //     onDrop: function (draggable, droppable) {
        //         if(droppable){

        //             droppable.setAttribute('data-option', draggable.get('id'));
        //             currentLabel = droppable.getAttribute('data-label');
        //             droppable.set("html", currentLabel + '<br/>' + draggable.get("html"));
        //             droppable.setStyle('padding-top', 5);
        //             droppable.setStyle('line-height', 17);
        //             droppable.setStyle('height', 41);

        //             liContainer = draggable.getParent();
        //             liContainer.set('html', '');
        //             liContainer.addClass('dragOver');
        //         }
        //         else {

        //         }

        //         draggable.removeClass("dragging");
        //         draggable.morph({
        //             top: 0,
        //             left: 0
        //         });
        //     }
        // });
        var margin_left_used = 0;
        switch(presentationListItems.length) {
            case 1:
                presentationListItems[0].setStyle('margin-left', 290);
                assessmentListItems[0].setStyle('margin-left', 290);
                margin_left_used = 290;
                break;
            case 2:
                presentationListItems[0].setStyle('margin-left', 225);
                assessmentListItems[0].setStyle('margin-left', 225);
                margin_left_used = 225;
                break;
            case 3:
                presentationListItems[0].setStyle('margin-left', 165);
                assessmentListItems[0].setStyle('margin-left', 165);
                margin_left_used = 165;
                break;
            case 4:
                presentationListItems[0].setStyle('margin-left', 100);
                assessmentListItems[0].setStyle('margin-left', 100);
                margin_left_used = 100;
                break;
            case 5:
                presentationListItems[0].setStyle('margin-left', 30);
                assessmentListItems[0].setStyle('margin-left', 30);
                margin_left_used = 30;
                break;
            case 6:
                presentationListItems.setStyle('margin-left', 1);
                assessmentListItems.setStyle('margin-left', 1);
                margin_left_used = 1;
                break;
        }

        var sequence_width = $$(".widget-content")[0].getWidth()/sequences.length - margin_left_used*(sequences.length);
        if($$(".challenge-list li.sequence-item")[0].getWidth()>sequence_width){
            $$(".challenge-list li.sequence-item").setStyle("width",sequence_width);
            $$(".assessment-list .sequence-item-drop").setStyle("width",sequence_width-2);
        }
    },


    saveData: function(callback) {
        if(callback) {
            this.saveRequest({
                method: 'mdDataByID',
                selector:"#md-widget-data-options",
                variable_name:"options",
                options: {
                    'json': this.options.options
                }
            }, function(data){
                location.reload();
            }, true);
        } else {
            this.saveRequest({
                method: 'mdDataByID',
                selector:"#md-widget-data-options",
                variable_name:"options",
                options: {
                    'json': this.options.options
                }
            }, function(data){
            }, true);
        }
    },

    bindEditMode: function() {
        var that = this;

        //editor template non include on the index file
        var editor_template="";
        editor_template += "<div class=\"choose-media-type\">";
        editor_template += "    <div class=\"title\">";
        editor_template += "        Adaptative Sequencing";
        editor_template += "    <\/div>";
        editor_template += "    <div class=\"options\">";
        editor_template += "        <span>Choose Media Type<\/span>";
        editor_template += "        <ul>";
        editor_template += "            <li data-type-name=\"text\">Text<\/li>";
        editor_template += "            <li data-type-name=\"image\">Image<\/li>";
        editor_template += "            <li data-type-name=\"video\">Video<\/li>";
        editor_template += "            <li data-type-name=\"audio\">Audio<\/li>";
        editor_template += "        <\/ul>";
        editor_template += "    <\/div>";
        editor_template += "    <div class=\"actions\">";
        editor_template += "        <div class=\"button next-button\">NEXT<\/div>";
        editor_template += "    <\/div>";
        editor_template += "<\/div>";
        editor_template += "<div class=\"editor-options-wrapper\">";
        editor_template += "    <div class='sequence-type-content'><\/div>";
        editor_template += "    <!--";
        editor_template += "    <div class=\"text-area\">";
        editor_template += "        <span>Description text<\/span>";
        editor_template += "        <textarea class=\"textarea\" maxlength=\"130\"><\/textarea><span class=\"label-count\">0<\/span>";
        editor_template += "    <\/div>";
        editor_template += "    -->";
        editor_template += "    <div class=\"sequence\">";
        editor_template += "        <span>Build Sequences for a total allowable of 6<\/span>";
        editor_template += "        <div class=\"list\">";
        editor_template += "            <ul class=\"sequence-list\"><\/ul>";
        editor_template += "            <ul class=\"assessment-list\"><\/ul>";
        editor_template += "        <\/div>";
        editor_template += "    <\/div>";
        editor_template += "    <div class=\"actions\">";
        editor_template += "        <div class=\"button set-assessment-button\">SET ASSESSMENT<\/div>";
        editor_template += "        <div class=\"button done-button\">DONE<\/div>";
        editor_template += "        <div class=\"button gray reset-button\">RESET<\/div>";
        editor_template += "        <div class=\"button gray back-button\">BACK<\/div>";
        editor_template += "    <\/div>";
        editor_template += "<\/div>";

        this.container.getElement(".widget-content").set("html",editor_template);



        //Set initial step when dataType = null
        if (! this.dataType) {
            $$('.choose-media-type').show();
            $$('.choose-media-type .options ul li:first-child').addClass('black');

            //bind click to change selected option
            $$('.choose-media-type .options ul li').addEvent('click', function(){
                $$('.choose-media-type .options ul li').removeClass('black');
                $$(this).addClass('black');
            });

            //bind click to next button
            $$('.choose-media-type .next-button').addEvent('click', function(){
                this.dataType = $$('.choose-media-type .options ul li.black')[0].get('data-type-name');

                that.sendPostMessages('initial-type', {type: this.dataType});
            });
        } else {
            $$('.editor-options-wrapper').show();

            switch(this.dataType) {
                case 'text':
                    this.editModeText();
                    break;
                case 'image':
                    this.editModeImage();
                    break;
                case 'video':
                    this.editModeVideo();
                    break;
                case 'audio':
                    this.editModeAudio();
                    break;

            }
        }
    },

    bindDragZoneEvents:function(formats,hide_rules,folder){
        that = this;
        $$('.md-portal-media-list-item-button.md-edit-slide').addEvent('click', function(e){
            e.preventDefault();

            if (parent && parent!=window) {
                parent.postMessage({method:'show-media-popup',formats:formats,hide_rules:hide_rules,folder:folder},"*");
            }
            return false;
        });
         $$('.md-edit-remove').addEvent('click', function () {
            if (confirm("Are you sure you want to delete this element from the gallery?")) {
                if(this.getParent().getAttribute("data-type") == 'imagen'){
                    var type = "img";
                }else if(this.getParent().getAttribute("data-type") == 'video'){
                    var type = "video";
                }else if(this.getParent().getAttribute("data-type") == 'audio'){
                    var type = "audio";
                }else if(this.getParent().getAttribute("data-type") == 'iframe_video'){
                    that.setIframeAudioVide(this.getParent(), this.getParent().getAttribute("data-index"), 'video');
                    return false;
                }else if(this.getParent().getAttribute("data-type") == 'iframe_audio'){
                    that.setIframeAudioVide(this.getParent(), this.getParent().getAttribute("data-index"), 'audio');
                    return false;
                }
                that.removeFile(this.getParent().getAttribute("data-md-id"), this.getParent().getAttribute("data-index"), this.getSiblings(type)[0].getAttribute('src'), this.getParent(), type);
            }
            that.notifyFocusCapture();
            return false;
        });
        $$('.drag-indication-box,.replace-current-media').addEvent('click', function() {

            if(parent && parent!=window) {
                parent.postMessage({method:'show-media-popup',formats:formats,hide_rules:hide_rules,folder:folder},"*");
            }
            return false;
        });

        if($$('.drop-zone:not(.drageventbind)').length>0){

            $$('.drop-zone')[0].ondragover = function(e) {
                this.addClass('dragover');
                return false;
            };
            $$('.drop-zone')[0].ondragend = function(e) {
                $$('.drop-zone').removeClass('dragover');
                return false;
            };
            $$('.drop-zone')[0].ondragleave = function(e) {
                $$('.drop-zone').removeClass('dragover');
                return false;
            };
            $$('.drop-zone')[0].ondrop = function(e) {
                e.preventDefault();

                var extensions = formats.join();
                extensions = extensions.replace(/\./g, '');
                extensions = extensions.split(",");

                var flag_no_errors = false;

                Array.each(e.dataTransfer.files,function(value,key){
                    can_be_added = false
                    extensions.each(function(ext,ind){
                        if (value.name.indexOf("."+ext)>0 || value.type.indexOf("/"+ext)>0)
                            can_be_added=true
                    })

                    if (can_be_added){
                        flag_no_errors=true;
                    }

                });


                if (!flag_no_errors){
                    alert("This field doesn't accept this file type. The file types accepted are "+formats.join());
                    return;
                }

                if(parent && parent!=window) {
                    parent.postMessage({method:'files-begin-upload'},"*");
                }

                that.uploadFile(e.dataTransfer.files,folder);
                return false;
            };

            $$('.drop-zone')[0].addClass("drageventbind");
        }

        //end drag zone events
    },
    setIframeAudioVide: function (element, itemId, type){
        that = this;
        that.options.options[itemId].value = "";
        that.saveData();
        $$('.upload-wrapper').set('html', '<div class="drag-indication-box drop-zone selected"></div><br/><div class="current-media-entry"></div>');
        $$(".image-upload-wrapper > span").set("html","Add an " + type + " to this sequence:");
        if(type == 'video'){
            that.bindDragZoneEvents([".mp4"],[1,5],"video/");
        }else{
            that.bindDragZoneEvents([".mp3",".mp4"],[1,5],"audio/");
        }
    },
    removeFile: function (file_id, itemId,  file_src, element, type) {
        that = this;
        that.options.options[itemId].value = "";
        if(this.dataType == "image") {
           this.saveData(true);
        } else {
           this.saveData();
        }

        this.saveRequest({
            img_src: file_src,
            method: 'remove',
            element: file_id,
            no_delete_image: false //element.get("data-md-no-delete-image") != "" && element.get("data-md-no-delete-image") == "1" ? true : false
        }, function () {
            $$('.upload-wrapper').set('html', '<div class="drag-indication-box drop-zone selected"></div><br/><div class="current-media-entry"></div>');

            if(type == 'img'){
                $$(".image-upload-wrapper > span").set("html","Add an image to this sequence:");
                that.bindDragZoneEvents([".jpg", ".jpeg", ".png"], [1,2], "images/");
            }else if(type == 'video'){
                $$(".image-upload-wrapper > span").set("html","Add a video to this sequence:");
                that.bindDragZoneEvents([".mp4"],[1,3],"video/");
            }else if(type == 'audio'){
                $$(".image-upload-wrapper > span").set("html","Add an audio to this sequence:");
                that.bindDragZoneEvents([".mp3",".mp4"],[1,3],"audio/");
            }
            //document.location.reload();
        });
    },
    uploadFile: function (files, folder) {
        var that = this;
        var formData = new FormData();

        for (var i = 0; i < files.length; i++) {
            formData.append('file', files[i]);
        }

        var pathUpload = location.href;
        if (pathUpload.indexOf("?") > 0) {
            pathUpload = pathUpload.split("?")[0];
        }

        formData.append('path', pathUpload);
        formData.append('directory', folder);

        var xhr = new XMLHttpRequest();
        xhr.open('POST', this.root + 'api/index.php/upload/');
        xhr.onload = function () {

            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                var relative_path = response.relativePath;
                var currentItemIndex = $$('li.sequence-item').indexOf($$('li.sequence-item.current')[0]);
                that.setMediaContentByType(currentItemIndex,{
                    data:{
                        source_relative: relative_path,
                        source_type: "computer"
                    }
                });

                alert("Media successfully uploaded.");

            } else {
                alert(xhr.status + ' Error uploading media. Please contact the system administrator.');
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },

    editModeAudio:function() {
        that = this;

        var edit_mode_template = ''+
            '<div class="image-upload-wrapper">'+
                '<span>Add an audio to this sequence:</span><br/><br/>'+
                '<div class="upload-alt-text-wrapper">'+
                    '<div class="upload-wrapper"><div class="drag-indication-box drop-zone selected"></div><br/><div class="current-media-entry"></div></div>'+
                    //'<div class="image-alt-text-wrapper"><textarea placeholder="Alt Text (mandatory)"></textarea></div>'+
                '</div>'+
                //'<div class="editor-separation"></div>'+
                //'<div class="image-caption-text"><textarea placeholder="Enter caption (optional)"></textarea><span class="label-count">0</span></div>'+
            '</div>';

        $$('.sequence-type-content').set("html",edit_mode_template);

        this.bindDragZoneEvents([".mp3",".mp4"],[1,3],"audio/");


        this.bindSetSeequencingButtons();
    },

    editModeVideo:function() {
        that = this;

        //$$('.editor-options-wrapper').show();

        var edit_mode_template = ''+
            '<div class="image-upload-wrapper">'+
                '<span>Add an video to this sequence:</span><br/><br/>'+
                '<div class="upload-alt-text-wrapper">'+
                    '<div class="upload-wrapper"><div class="drag-indication-box drop-zone selected"></div><br/><div class="current-media-entry"></div></div>'+
                    //'<div class="image-alt-text-wrapper"><textarea placeholder="Alt Text (mandatory)"></textarea></div>'+
                '</div>'+
                //'<div class="editor-separation"></div>'+
                //'<div class="image-caption-text"><textarea placeholder="Enter caption (optional)"></textarea><span class="label-count">0</span></div>'+
            '</div>';

        $$('.sequence-type-content').set("html",edit_mode_template);

        this.bindDragZoneEvents([".mp4"],[1,3],"video/");

        this.bindSetSeequencingButtons();
    },

    editModeImage:function() {
        var that = this;

        var edit_mode_template = ''+
            '<div class="image-upload-wrapper">'+
                '<span>Add an image to this sequence:</span><br/><br/>'+
                '<div class="upload-alt-text-wrapper">'+
                    '<div class="upload-wrapper"><div class="drag-indication-box drop-zone selected"></div><br/><div class="current-media-entry"></div></div>'+
                    '<div class="image-alt-text-wrapper" style="display:none;"><textarea placeholder="Alt Text (mandatory)" maxlength="50"></textarea></div>'+
                '</div>'+
                '<div class="editor-separation"></div>'+
                '<div class="image-caption-text"><textarea data-max-input="50" placeholder="Enter caption (optional)" maxlength="50"></textarea><span class="label-count">0</span></div>'+
            '</div>';

        $$('.sequence-type-content').set("html",edit_mode_template);

        this.bindDragZoneEvents([".jpg",".jpeg",".png"],[1,2],"images/");
        $$('.image-alt-text-wrapper textarea').addEvent('paste', that.pastelistener.bind(that));
        $$('.image-alt-text-wrapper textarea').addEvent('keyup', function() {
            //$$('.label-count').set('html', $$(this)[0].get('value').length);

            if(that.options.options==null || that.options.options.length==0 ) return;

            //save data
            var currentItemInd = $$('.editor-options-wrapper .sequence ul li.sequence-item').indexOf($$('.editor-options-wrapper .sequence ul li.sequence-item.current')[0]);
            var value = $$(this)[0].get('value');
            if(that.options.options[currentItemInd].data==null) that.options.options[currentItemInd].data = {alt:"",caption:""};
            that.options.options[currentItemInd].data.alt = value;
            that.saveData();
        });

        $$('.image-caption-text textarea').addEvent('keyup', function() {
            var limit = 50;
            var current_lengt = $$(this)[0].get('value').length;
            if($$(this)[0].get('data-max-input')){
                limit = new Number($$(this)[0].get('data-max-input'));
            }
            if(limit-current_lengt<0){
                return false;
            }


            $$('.label-count').set('html', limit-current_lengt);

            if(that.options.options==null || that.options.options.length==0 ) return;

            //save data
            var currentItemInd = $$('.editor-options-wrapper .sequence ul li.sequence-item').indexOf($$('.editor-options-wrapper .sequence ul li.sequence-item.current')[0]);
            var value = $$(this)[0].get('value');
            if(that.options.options[currentItemInd].data==null) that.options.options[currentItemInd].data = {alt:"",caption:""};
            that.options.options[currentItemInd].data.caption = value;
            that.saveData();
        });

        this.bindSetSeequencingButtons();
    },

    editModeText: function() {
        var that = this;

        var edit_mode_template = ''+
            '<div class="text-area">'+
                //'<span>Description text</span>'+
                '<div class="textarea" contenteditable="true" data-max-input="130" data-placeholder="Type your text"></div><span class="label-count">0</span>'+
            '</div>';

        $$('.sequence-type-content').set("html",edit_mode_template);


        $$('.textarea').addEvent('paste', that.pastelistener.bind(that));
        $$('.textarea').addEvent('keypress', that.editModeTextKeyboardKeypressListener.bind(that));
        $$('.textarea').addEvent('keyup', that.editModeTextKeyboardListener.bind(that));
        $$('.textarea').addEvent('change', that.editModeTextKeyboardListener.bind(that));


        this.bindSetSeequencingButtons();
    },

    editModeTextKeyboardKeypressListener: function (e) {
        var that = this;
        var limit = 130;
        var current_lengt = $$(e.target)[0].get('text').length;
        if($$(e.target)[0].get('data-max-input')){
            limit = new Number($$(e.target)[0].get('data-max-input'));
        }

        if(limit-current_lengt -  1 <0){
            e.preventDefault();
        }


    },

    pastelistener: function(e) {
        var that = this;
        var limit = 130;
        var current_lengt = $$(e.target)[0].get('text').length;
        if($$(e.target)[0].get('data-max-input')){
            limit = new Number($$(e.target)[0].get('data-max-input'));
        }

        if(limit-current_lengt<0){
            $$('.label-count').set('html', limit);
            var value = $$(e.target)[0].get('text');
            var value = value.substr(0, limit);
        }else{
            $$('.label-count').set('html', limit - current_lengt);
            var value = $$(e.target)[0].get('text');
        }
        if(that.options.options==null || that.options.options.length==0 ) return;
        //save data
        var currenItemID = $$('.editor-options-wrapper .sequence ul li.sequence-item.current').get('id');
        var currentItemInd = $$('.editor-options-wrapper .sequence ul li.sequence-item').indexOf($$('.editor-options-wrapper .sequence ul li.sequence-item.current')[0]);
        that.options.options[currentItemInd].value = value;
        $$(e.target)[0].set('html', value);
        that.saveData();
    },

    editModeTextKeyboardListener: function (e) {
        var that = this;
        var limit = 130;
        var current_lengt = $$(e.target)[0].get('text').length;
        if($$(e.target)[0].get('data-max-input')){
            limit = new Number($$(e.target)[0].get('data-max-input'));
        }

        if(limit-current_lengt<0){
            e.preventDefault();
        }
        else{

            $$('.label-count').set('html', limit - current_lengt);

            if(that.options.options==null || that.options.options.length==0 ) return;

            //save data
            var currenItemID = $$('.editor-options-wrapper .sequence ul li.sequence-item.current').get('id');
            var currentItemInd = $$('.editor-options-wrapper .sequence ul li.sequence-item').indexOf($$('.editor-options-wrapper .sequence ul li.sequence-item.current')[0]);
            var value = $$(e.target)[0].get('html');


            that.options.options[currentItemInd].value = value;
            that.saveData();
        }

    },

    bindSetSeequencingButtons:function(){
        var that = this;

        $$('.sequence-plus').addEvent('click', function(){
            that.bindClickToAddItem(this);
        });

        var currentUL = $$('.sequence-list');

        this.options.options.each(function(option,index){
            var attr = option;

            var label = attr.label;
            var sequenceItem = new Element('li', {
                id: attr.index,
                html: "<button class='label-remove'><i class='fa fa-trash-o'></i></button><div class='label-wrapper' data-max-input='15' contenteditable='true'>" + label + "</div>",
                class: 'sequence-item'
            });

            var sequencePlus = new Element('li', {
                class: 'sequence-plus plus'
            });
            var sequenceIcon = new Element('i', {
                class: 'fa fa-plus'
            }).inject(sequencePlus);

            sequenceItem.inject(currentUL[0]);

            if (index < 5) {
                sequencePlus.inject(sequenceItem, 'after');
            }

            $$('.sequence-plus').removeEvents('click');

            sequencePlus.addEvent('click', function(){
                that.bindClickToAddItem(this);
            });




        });


        if( $$('.editor-options-wrapper .sequence ul li.sequence-item').length > 0 ){
            $$('.editor-options-wrapper .sequence ul li.sequence-item').addEvent('click', function(){
                that.bindClickChangeSelectedItem(this);
            });

            $$('.editor-options-wrapper .sequence ul li.sequence-item .label-remove').addEvent('click', function(e){
                that.removeItem(this);
                e.preventDefault();
                e.stopPropagation();
            });

            if ( $$('.editor-options-wrapper .sequence ul li.sequence-item') ) {
                $$('.editor-options-wrapper .sequence ul li.sequence-item')[0].addClass('current');
                $$('.editor-options-wrapper .sequence ul li.sequence-item')[0].fireEvent("click");
            }
        }
        else {

            var sequencePlus = new Element('li', {
                class: 'sequence-plus plus'
            });
            var sequenceIcon = new Element('i', {
                class: 'fa fa-plus'
            }).inject(sequencePlus);

            sequencePlus.inject(currentUL[0]);

            sequencePlus.addEvent('click', function(){
                that.bindClickToAddItem(this);
                this.dispose();
            });

            sequencePlus.fireEvent('click');
            if ( $$('.editor-options-wrapper .sequence ul li.sequence-item') ) {

                $$('.editor-options-wrapper .sequence ul li.sequence-item')[0].addClass('current');
                $$('.editor-options-wrapper .sequence ul li.sequence-item')[0].fireEvent("click");
            }
        }

        $$('.editor-options-wrapper .set-assessment-button').addEvent('click', function(){
            $$("body").addClass("set-assessment-mode");
            that.setAssessmentText();
        });

        $$('.editor-options-wrapper .reset-button').addEvent('click', function(){
            $$("body").removeClass("set-assessment-mode");

            $$('.editor-options-wrapper .sequence ul.sequence-list').setStyle('width', 1330);

            that.setAssessmentReset();
        });

        $$('.editor-options-wrapper .done-button').addEvent('click', function(el){
            if($$('.editor-options-wrapper .done-button').hasClass('enabled')){
                $$("body").removeClass("set-assessment-mode");

                $$('.editor-options-wrapper .sequence ul.sequence-list').setStyle('width', 1330);

                that.setAssessmentDone();
            }else{
                $$("body").removeClass("set-assessment-mode");
            }
        });

        $$('.editor-options-wrapper .back-button').addEvent('click', function(el){
            that.backEditmode();
        });


        this.bindTitleSequenceChangeEvent();

    },

    removeItem: function(item){
        var that = this;
        console.log( $$('.editor-options-wrapper .sequence ul li.sequence-item').indexOf(item.getParent()) );
        var index = $$('.editor-options-wrapper .sequence ul li.sequence-item').indexOf(item.getParent());


        if(item.getParent().getNext('.sequence-item')){
            that.bindClickChangeSelectedItem( item.getParent().getNext('.sequence-item') );
        } else {
            item.getParent().getPrevious().addEvent('click', function(){
                that.bindClickToAddItem(this);
            });
        }

        if(item.getParent().getNext())
            item.getParent().getNext().dispose();

        item.getParent().dispose();

        //that.options.options[currentItemIndex].label = e.target.get("text");
        that.options.options.splice(index, 1);
        that.saveData();


    },

    bindTitleSequenceChangeEvent:function(){
        var that = this;
        $$('.sequence-item *[contenteditable="true"]:not(.binded)').each(function(title_editable){

            var intTimerID = null;
            title_editable.addEvent("change", that.sequenceTitleChange.bind(that));
            title_editable.addEvent('keypress', that.editModeTextKeyboardKeypressListener.bind(that));
            title_editable.addEvent("keyup", function (ev) {
                that.editModeTextKeyboardListener.bind(ev);

                if (intTimerID != null) {
                    clearTimeout(intTimerID);
                }
                intTimerID = setTimeout(function () {
                    that.sequenceTitleChange(ev);
                }, 500);
            });
            title_editable.addClass("binded");
        });

    },

    sequenceTitleChange:function(e){
        var currentItemIndex = $$('li.sequence-item').indexOf(e.target.getParent());
        this.options.options[currentItemIndex].label = e.target.get("text");
        this.saveData();
    },

    bindClickToAddItem: function(currentPlus) {
        var that = this;
        var sequenceCount = $$('.sequence-item').length;
        var currentPosition = $$('.sequence-plus').indexOf(currentPlus);
        currentPosition = currentPosition + 2;

        $$('.editor-options-wrapper .sequence ul li.sequence-item').removeClass('current');


        if (sequenceCount < 6) {
            var label = 'Sequence #' + (this.options.options.length + 1);
            var sequenceItem = new Element('li', {
                id: Date.now(),
                html: "<button class='label-remove'><i class='fa fa-trash-o'></i></button><div class='label-wrapper' data-max-input='15' contenteditable='true'>" + label + "</div>",
                class: 'sequence-item current'
            });

            var sequencePlus = new Element('li', {
                class: 'sequence-plus plus'
            });
            var sequenceIcon = new Element('i', {
                class: 'fa fa-plus'
            }).inject(sequencePlus);

            sequenceItem.inject(currentPlus, 'after');

            if (sequenceCount < 5) {
                sequencePlus.inject(sequenceItem, 'after');
            }

            if(sequenceCount > 4){
                $$('.sequence-list').setStyle('width', 1330);
            }


            $$('.sequence-plus').removeEvents('click');

            that.bindClickChangeSelectedItem(sequenceItem);


            sequencePlus.addEvent('click', function(){
                that.bindClickToAddItem(this);
            });

            sequenceItem.addEvent('click', function(){
                that.bindClickChangeSelectedItem(this);
            });

            sequenceItem.getElement('.label-remove').addEvent('click', function(e){
                that.removeItem(this);
                e.preventDefault();
                e.stopPropagation();
            });



            //add element to data
            var newItemID = sequenceItem.get('id');
            var newItemLabel = sequenceItem.get('text');

            if(this.options.options==null ) this.options.options = [];

            this.options.options.push({
                id: newItemID,
                label: newItemLabel,
                sequence_order_index: this.options.options.length, //-1
                nelement: true,
                value: "", // path | text
                source_type: "",// iframe | local
                data: {
                    alt: "",
                    caption: ""
                }
            });

            this.saveData();

            this.bindTitleSequenceChangeEvent();

            var list = $$('.editor-options-wrapper .sequence .list')[0];
            var scroll = new Fx.Scroll(list, {
                wait: false,
                duration: 500,
                transition: Fx.Transitions.Quad.easeInOut
            });
            scroll.toElement(sequenceItem);

            sequenceItem.fireEvent("click");
            if($$(".textarea[contenteditable='true']").length>0){
                $$(".textarea[contenteditable='true']")[0].focus();
            }
        }
    },


    bindClickChangeSelectedItem: function(currentItem) {
        var currentID = $$(currentItem).get('id');
        var currentItemIndex = $$('li.sequence-item').indexOf(currentItem);
        $$('.editor-options-wrapper .sequence ul li.sequence-item').removeClass('current');

        // Add Halo only not dragged element
        if(!currentItem.hasClass('dragged')){
            $$(currentItem).addClass('current');
        }

        switch(this.dataType) {
            case 'text':
                this.changeSelectedItemText(currentItemIndex);
                break;
            case 'image':
                this.changeSelectedItemImage(currentItemIndex);
                break;
            case 'video':
                this.changeSelectedItemVideo(currentItemIndex);
                break;
            case 'audio':
                this.changeSelectedItemAudio(currentItemIndex);
                break;
        }
    },

    changeSelectedItemVideo: function(itemID) {
        var value = '';
            itemData = this.options.options[itemID];

        if ( this.options.options[itemID] ) {
            index = itemID;
            id = this.options.options[itemID].data!=null?this.options.options[itemID].id:"";
            value = this.options.options[itemID].data!=null?this.options.options[itemID].value:"";
        }

        $$('.upload-wrapper').set('html', '<div class="drag-indication-box drop-zone selected"></div><br/><div class="current-media-entry"></div>');

        if(value!=""){

            if(itemData.source_type!="iframe"){
                $$('.upload-wrapper').set("html","<div class='video_editable' data-type='video' data-md-id='"+id+"' data-index='"+index+"'><video width='300' height='230' controls src='"+value+"' /><div>");
            }
            else{
                $$('.upload-wrapper').set("html","<div class='video_editable' data-type='iframe_video' data-md-id='"+id+"' data-index='"+index+"'><iframe width='300' height='230' height src='"+value+"' ></iframe></div>");
            }

             $$('.video_editable').each(function (e, i) {
                new Element('a.md-portal-media-list-item-button.md-edit-remove', {
                    'href': '#',
                    'html': '<i class="fa fa-times"></i>'
                }).inject(e);

                new Element('a.md-portal-media-list-item-button.md-edit-slide', {
                    'href': '#',
                    'html': "<i class='fa fa-pencil'></i>", //'<u>EDIT</u>'
                }).inject(e);
            });


            $$(".image-upload-wrapper > span").set("html","Replace a video to this sequence:");
            $$(".header-upload-button-video").hide();
            $$(".replace-current-media").show();
        }
        else {
            $$(".image-upload-wrapper > span").set("html","Add a video to this sequence:");
            $$(".header-upload-button-video").show();
            $$(".replace-current-media").hide();
        }
        this.bindDragZoneEvents([".mp4"],[1,3],"video/");

    },

    changeSelectedItemAudio: function(itemID) {
        var value = '';
            itemData = this.options.options[itemID];

        if ( this.options.options[itemID] ) {
            index = itemID;
            id = this.options.options[itemID].data!=null?this.options.options[itemID].id:"";
            value = this.options.options[itemID].data!=null?this.options.options[itemID].value:"";
        }

        $$('.upload-wrapper').set('html', '<div class="drag-indication-box drop-zone selected"></div><br/><div class="current-media-entry"></div>');
        if(value!=""){
            //$$(".current-media-entry").set("html","Current media: <a href='"+value+"' target='_blank'>Click here to open in new window</a>");
            // $$(".current-media-entry").set("html","<audio controls='controls' src='"+value+"' />");
            // $$(".image-upload-wrapper > span").set("html","Replace an audio to this sequence:");
            // $$(".header-upload-button-audio").hide();
            // $$(".replace-current-media").show();
            if(itemData.source_type!="iframe"){
                $$(".image-upload-wrapper > span").set("html","Replace media current to this sequence:");
                $$(".current-media-entry").set("html","<audio controls='controls' src='"+value+"' />");
                $$('.upload-wrapper').set('html', '<div class="audio_editable" data-type="audio" data-md-id="'+id+'" data-index="'+index+'"><audio controls="controls" src="'+value+'" /></div>');
                $$('.audio_editable').each(function (e, i) {
                new Element('a.md-portal-media-list-item-button.md-edit-remove', {
                    'href': '#',
                    'html': '<i class="fa fa-times"></i>'
                }).inject(e);

                new Element('a.md-portal-media-list-item-button.md-edit-slide', {
                    'href': '#',
                    'html': "<i class='fa fa-pencil'></i>", //'<u>EDIT</u>'
                }).inject(e);
            });
            }
            else{
                $$('.upload-wrapper').set("html","<div class='audio_editable_frame' data-type='iframe_audio' data-md-id='"+id+"' data-index='"+index+"'><iframe width='400' height='200' height src='"+value+"' ></iframe></div>");
                $$('.audio_editable_frame').each(function (e, i) {
                new Element('a.md-portal-media-list-item-button.md-edit-remove', {
                    'href': '#',
                    'html': '<i class="fa fa-times"></i>'
                }).inject(e);

                new Element('a.md-portal-media-list-item-button.md-edit-slide', {
                    'href': '#',
                    'html': "<i class='fa fa-pencil'></i>", //'<u>EDIT</u>'
                }).inject(e);
            });
            }




            $$(".image-upload-wrapper > span").set("html","Replace an audio to this sequence:");
            $$(".header-upload-button-audio").hide();
            $$(".replace-current-media").show();
        }
        else {
            $$(".image-upload-wrapper > span").set("html","Add an audio to this sequence:");
            $$(".header-upload-button-audio").show();
            $$(".replace-current-media").hide();
        }
        that.bindDragZoneEvents([".mp3",".mp4"],[1,3],"audio/");

    },

    changeSelectedItemImage: function(itemID) {
        var value = '',
            caption = "",
            alt = "";

        if ( this.options.options[itemID] ) {
            index = itemID;
            id = this.options.options[itemID].data!=null?this.options.options[itemID].id:"";
            alt = this.options.options[itemID].data!=null?this.options.options[itemID].data.alt:"";
            caption = this.options.options[itemID].data!=null?this.options.options[itemID].data.caption:"";
            value = this.options.options[itemID].data!=null?this.options.options[itemID].value:"";
        }

        $$('.image-alt-text-wrapper textarea').set('value', alt);
        $$('.image-caption-text textarea').set('value', caption);


        $$('.upload-wrapper').set('html', '<div class="drag-indication-box drop-zone selected"></div><br/><div class="current-media-entry"></div>');
        if(value!=""){
            $$(".image-upload-wrapper > span").set("html","Replace an image to this sequence:");
            $$('.upload-wrapper').set('html', '<div class="thumbnail_editable" data-type="imagen" data-md-id="'+id+'" data-index="'+index+'"><img src="'+value+'" style="width:130px; height:130px;" /></div>');
        }else{
            $$(".image-upload-wrapper > span").set("html","Add an image to this sequence:");
        }

        $$('.thumbnail_editable').each(function (e, i) {
            new Element('a.md-portal-media-list-item-button.md-edit-remove', {
                'href': '#',
                'html': '<i class="fa fa-times"></i>'
            }).inject(e);

            new Element('a.md-portal-media-list-item-button.md-edit-slide', {
                'href': '#',
                'html': "<i class='fa fa-pencil'></i>", //'<u>EDIT</u>'
            }).inject(e);
        });

        this.bindDragZoneEvents([".jpg", ".jpeg", ".png"], [1,2], "images/");
        var limit = 50;
        var current_lengt = caption.length;

        if($$('.image-caption-text textarea').get("data-max-input")){
            limit = new Number($$('.image-caption-text textarea').get("data-max-input"));
        }

        $$('.label-count').set('html', limit - current_lengt);
    },

    changeSelectedItemText: function(itemID) {
        var value = '';

        if ( this.options.options[itemID] ) {
            value = this.options.options[itemID].value;
        }

        $$('.editor-options-wrapper .text-area .textarea').set('html', value);

        var limit = 130;
        var current_lengt = this.strippedHtmlString(value).length;

        if($$('.editor-options-wrapper .text-area .textarea').get("data-max-input")){
            limit = new Number($$('.editor-options-wrapper .text-area .textarea').get("data-max-input"));
        }

        $$('.label-count').set('html', limit - current_lengt);

    },

    strippedHtmlString: function(string){
        var StrippedString = string.replace(/(<([^>]+)>)/ig,"");
        return StrippedString;
    },

    setAssessmentText: function() {
        var that = this;
        $$('.editor-options-wrapper .set-assessment-button').hide();
        $$('.editor-options-wrapper .back-button').show();
        $$('.editor-options-wrapper .reset-button').show();
        $$('.editor-options-wrapper .done-button').show();
        $$('.editor-options-wrapper .sequence ul li.sequence-plus').hide();
        //$$('.editor-options-wrapper .sequence ul.sequence-list').setStyle('width', 730);
        var assessmentList = $$('.editor-options-wrapper .sequence ul.assessment-list');
        assessmentList.show();

        var items = $$('.editor-options-wrapper .sequence ul li.sequence-item');
        if(items.length < 4){
            $$('.editor-options-wrapper .sequence ul.sequence-list').setStyle('width', 730);
        }else{
            $$('.editor-options-wrapper .sequence ul.sequence-list').setStyle('width', 1330);
        }
        assessmentList.set('html', '');



        if(that.options.options[0].nelement == false){
            var sortedSequence = [];

            that.options.options.each(function(sequence, index){
                if(sequence.sequence_order_index > -1){
                    sortedSequence[sequence.sequence_order_index] = sequence;
                    $$('.editor-options-wrapper .sequence span').set('html', 'This order is saved. If you change the sequences order, click reset to set a new order.');

                }else if(sequence.sequence_order_index == -1){
                    sortedSequence[index] = sequence;
                    $$('.editor-options-wrapper .sequence span').set('html', 'Set the new order sequences and click done button to save.');
                }

            });
            sortedSequence.each(function(item, index) {
                assessmentPlace = new Element('li', {
                    id: index,
                    class: 'assessment-item',
                    "data-current-relation":item.sequence_order_index
                });

                assessmentPlace.inject(assessmentList[0]);
            });
            $$(".editor-options-wrapper .actions .button.done-button").hide();
        }else{
            var saverandy = [];
            items.each(function(item, index) {
                var randy = that.randNumberItem(items, saverandy);
                assessmentPlace = new Element('li', {
                    id: index,
                    class: 'assessment-item',
                    "data-current-relation":randy
                });
                saverandy.push(randy);

                assessmentPlace.inject(assessmentList[0]);
            });
            $$(".sequence-item").addClass("dragged");
            $$(".editor-options-wrapper .actions .button.done-button").addClass("enabled");
            $$(".editor-options-wrapper .actions .button.done-button").removeEvents("click");
            $$(".editor-options-wrapper .actions .button.done-button").addEvent("click", that.setAssessmentDone.bind(that));
            $$('.editor-options-wrapper .sequence span').set('html', 'This sequences order is random, click done to save this random order or click reset to set new order.');
        }

        var itemsAssessment = $$('.editor-options-wrapper .sequence ul.assessment-list li.assessment-item');


        this.options.options.each(function(option,index){
            if(option.sequence_order_index!=null && option.sequence_order_index > -1){
                $$(".sequence-item")[index].addClass("dragged");
                if(option.nelement == true){
                    $$(".assessment-item")[option.sequence_order_index].set("html", that.options.options[$$(".assessment-item")[option.sequence_order_index].get("data-current-relation")].label);
                }else{
                    $$(".assessment-item")[option.sequence_order_index].set("html", option.label);
                }
            }else{
                $$(".assessment-item")[index].set("html", that.options.options[$$(".assessment-item")[index].get("data-current-relation")].label);
            }
        });

        items.setStyle('margin-left', 5);
        itemsAssessment.setStyle('margin-left', 5);

        switch(items.length) {
            case 1:
                itemsAssessment[0].setStyle('margin-left', 290);
                items[0].setStyle('margin-left', 290);
                break;
            case 2:
                itemsAssessment[0].setStyle('margin-left', 225);
                items[0].setStyle('margin-left', 225);
                break;
            case 3:
                itemsAssessment[0].setStyle('margin-left', 165);
                items[0].setStyle('margin-left', 165);
                break;
            case 4:
                itemsAssessment[0].setStyle('margin-left', 100);
                items[0].setStyle('margin-left', 100);
                break;
            case 5:
                itemsAssessment[0].setStyle('margin-left', 30);
                items[0].setStyle('margin-left', 30);
                break;
            case 6:
                items.setStyle('margin-left', 1);
                itemsAssessment.setStyle('margin-left', 1);
                break;
        }

        this.dragList = [];

        var sequenceList = $$('.editor-options-wrapper .sequence ul.sequence-list div');

        sequenceList.each(function(sequence) {
            sequence.setStyle('cursor', 'pointer');

            var dragItem = sequence.makeDraggable({
                droppables: ".assessment-item",
                onDrag: function (draggable) {
                    draggable.addClass("dragging");
                },
                onDrop: function (draggable, droppable) {

                    if(droppable){
                        //$$(".editor-options-wrapper .actions .button.done-button").addClass("enabled");
                        var position_index = $$(".assessment-item").indexOf(droppable);
                        var dragged_item_index = $$(".sequence-item").indexOf(draggable.getParent());

                        var current_relation = new Number(droppable.get("data-current-relation"));

                        if(that.options.options[dragged_item_index].sequence_order_index!=null && that.options.options[dragged_item_index].sequence_order_index>-1){
                            $$(".sequence-item")[dragged_item_index].removeClass("dragged");
                            $$(".assessment-item")[that.options.options[dragged_item_index].sequence_order_index].set("html","");
                            $$(".assessment-item")[that.options.options[dragged_item_index].sequence_order_index].set("data-current-relation",-1);
                        }

                        if(current_relation && current_relation>-1){
                            $$(".sequence-item")[current_relation].removeClass("dragged");
                            that.options.options[current_relation].sequence_order_index = -1;
                        }

                        droppable.set("html",draggable.get("html"));
                        droppable.set("data-current-relation",dragged_item_index);
                        that.options.options[dragged_item_index].sequence_order_index = position_index;
                        draggable.getParent().addClass("dragged");
                        var indicator = 0;
                        $$(".sequence-item").each(function(el){
                            if(!el.hasClass('dragged')){
                                indicator++;
                            }
                        });
                        if(indicator==0){
                            $$(".editor-options-wrapper .actions .button.done-button").show();
                            $$(".editor-options-wrapper .actions .button.done-button").addClass("enabled");
                            $$(".editor-options-wrapper .actions .button.done-button").addEvent("click", that.setAssessmentDone.bind(that));

                        }else{
                            $$(".editor-options-wrapper .actions .button.back-button").hide();
                        }
                        that.saveData();

                    }

                    draggable.removeClass("dragging");
                    draggable.morph({
                        top: 0,
                        left: 0
                    });
                }
            });

            that.dragList.push(dragItem);

        });

        // this.container.getElements(".sequence-item > div").makeDraggable({
        //     droppables: ".assessment-item",
        //     onDrag: function (draggable) {
        //         draggable.addClass("dragging");
        //     },
        //     onDrop: function (draggable, droppable) {

        //         if(droppable){


        //             var position_index = $$(".assessment-item").indexOf(droppable);
        //             var dragged_item_index = $$(".sequence-item").indexOf(draggable.getParent());
        //             var current_relation = new Number(droppable.get("data-current-relation"));

        //             if(that.options.options[dragged_item_index].sequence_order_index!=null && that.options.options[dragged_item_index].sequence_order_index>-1){
        //                 $$(".assessment-item")[that.options.options[dragged_item_index].sequence_order_index].set("html","");
        //                 $$(".assessment-item")[that.options.options[dragged_item_index].sequence_order_index].set("data-current-relation",-1);
        //             }

        //             if(current_relation && current_relation>-1){
        //                 that.options.options[current_relation].sequence_order_index = -1;
        //             }

        //             droppable.set("html",draggable.get("html"));
        //             droppable.set("data-current-relation",dragged_item_index);
        //             that.options.options[dragged_item_index].sequence_order_index = position_index;

        //             that.saveData();
        //         }

        //         draggable.removeClass("dragging");
        //         draggable.morph({
        //             top: 0,
        //             left: 0
        //         });
        //     }
        // });

    },
    randNumberItem: function(items, saverandy) {
        var randy = Math.round((Math.random() * (items.length-1)));
        for (var i = 0; i<=saverandy.length-1; i++) {
            if(randy == saverandy[i]){
                return this.randNumberItem(items, saverandy);
            }
        };
        return randy;
    },

    backEditmode: function() {
        $$("body").removeClass("set-assessment-mode");
        $$(".editor-options-wrapper .actions .button.done-button").removeClass("enabled");
        $$('.editor-options-wrapper .set-assessment-button').show();
        $$('.editor-options-wrapper .back-button').hide();
        $$('.editor-options-wrapper .reset-button').hide();
        $$('.editor-options-wrapper .done-button').hide();
        $$('.editor-options-wrapper .sequence ul li.sequence-plus').show();
        $$(".sequence-item").removeClass("dragged");
        var assessmentList = $$('.editor-options-wrapper .sequence ul.assessment-list');
        assessmentList.hide();
        var sequenceList = $$('.editor-options-wrapper .sequence ul.sequence-list div');
        sequenceList.each(function(sequence) {
            sequence.setStyle('cursor', 'text');
        });
        var items = $$('.editor-options-wrapper .sequence ul li.sequence-item');
        items.setStyle('margin-left', 0);
        items[0].setStyle('margin-left', 20);

        $$('.editor-options-wrapper .sequence span').set('html', 'Build Sequences for a total allowable of 6');
    },

    setAssessmentReset: function() {
        var that = this;
        //$$(".editor-options-wrapper .actions .button.done-button").addClass("enabled");
        $$("body").addClass("set-assessment-mode");
        $$(".editor-options-wrapper .actions .button.back-button").show();
        $$(".editor-options-wrapper .actions .button.done-button").hide();
        $$(".editor-options-wrapper .actions .button.done-button").removeClass("enabled");
        $$(".editor-options-wrapper .actions .button.done-button").removeEvents('click');
        $$(".editor-options-wrapper .sequence ul.assessment-list li").set("data-current-relation",-1);
        $$(".editor-options-wrapper .sequence ul.assessment-list li").set("html","");
        $$(".sequence-item").removeClass("dragged");


        that.options.options.each(function(option,index){
            // if(option.nelement != true){
            //     that.options.options[index].sequence_order_index = -1;
            // }else{
            //     that.options.options[index].sequence_order_index = option.sequence_order_index;
            // }
            that.options.options[index].sequence_order_index = -1;
            that.options.options[index].nelement = true;
        });
        that.saveData();
        $$('.editor-options-wrapper .sequence span').set('html', 'Set a new order to sequences.');
    },

    setAssessmentDone: function() {
        var that = this;
        if(!$$(".editor-options-wrapper .actions .button.done-button")[0].hasClass("enabled")){

        }
        $$("body").removeClass("set-assessment-mode");
        $$(".editor-options-wrapper .actions .button.done-button").removeClass("enabled");
        $$('.editor-options-wrapper .set-assessment-button').show();
        $$('.editor-options-wrapper .back-button').hide();
        $$('.editor-options-wrapper .reset-button').hide();
        $$('.editor-options-wrapper .done-button').hide();
        $$('.editor-options-wrapper .sequence ul li.sequence-plus').show();
        $$(".sequence-item").removeClass("dragged");

        var assessmentItem = $$(".assessment-item");

        assessmentItem.each(function(it, index){
          that.options.options[it.get('data-current-relation')].sequence_order_index = it.get('id');
          that.options.options[it.get('data-current-relation')].nelement = false;
        });
        that.saveData();

        var assessmentList = $$('.editor-options-wrapper .sequence ul.assessment-list');
        assessmentList.hide();

        this.dragList.each(function(dragItem) {
            dragItem.detach();
        });

        var sequenceList = $$('.editor-options-wrapper .sequence ul.sequence-list div');
        sequenceList.each(function(sequence) {
            sequence.setStyle('cursor', 'text');
        });

        var items = $$('.editor-options-wrapper .sequence ul li.sequence-item');
        items.setStyle('margin-left', 0);
        items[0].setStyle('margin-left', 20);

        $$('.editor-options-wrapper .sequence span').set('html', 'Build Sequences for a total allowable of 6');
    },

    // Receive messages from server and take actions
    customPostMessages: function(message) {
        var that = this

        switch(message.data.method){
            case "setting-change":
                switch(message.data.setting.attribute) {
                    case "data-type":
                        that.options.options = [];
                        that.saveData();
                        location.reload();
                        break;
                    default:
                        location.reload();
                }

                break;
            case "show-media-popup":
                    var currentItemIndex = $$('li.sequence-item').indexOf($$('li.sequence-item.current')[0]);
                    that.setMediaContentByType(currentItemIndex,message.data);
                break;
            case "view-mode-switch":

                if($$("audio,video").length==0) return;
                var media = null;
                if($$("audio").length>0){
                    media = $$("audio")[0];
                }
                else{
                    media = $$("video")[0];
                }

                new MediaElement(media, {
                    success: function (mediaElement, domObject) {

                        if( !message.data.edit && that.isEditMode ){
                            mediaElement.stop();
                        }

                        if( message.data.edit && !that.isEditMode ){
                            mediaElement.stop();
                        }

                    },
                    // fires when a problem is detected
                    error: function () {

                    }
                });
                break;
        }
    },
    setMediaContentByType:function(ind,data){
        var _this = this;
        switch(this.dataType){
            case "image":
                this.options.options[ind].value = data.data.source_relative;
                break;
            case "video":
            case "audio":
                if(data.data.source_type=="pearson"){
                    this.options.options[ind].value = data.data.source_value;
                    this.options.options[ind].source_type = "iframe";
                }
                else{
                    this.options.options[ind].value = data.data.source_relative;
                    this.options.options[ind].source_type = "local";
                }
                break;

        }
        if(this.dataType == "image") {
           this.saveData(true);
        } else {
           this.saveData();
        }

        $$('li.sequence-item.current')[0].fireEvent("click");
    }
});
