DataImageSlider = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    // Set initial options here
    options: {
        snap: false,
        lastIsFake: false
    },

    step: 1,

    // initialize - widget initialization
    initialize: function(options) {
        var _this = this;

    	this.parent(options);

        var lab_container = $$('ul.labels')[0];
        var width = 100 / (this.options.data.labels.length);
        Array.each(this.options.data.labels, function(e, i){
            new Element('li',{
                'data-customstep': i+1,
                'tabindex': 0,
                'html': e,
                'style': 'width: ' + width +'%;'
            }).inject(lab_container);
        });

        $$('.slide').hide();

        this.slider = new Slider($$('.slider')[0], $$('.knob')[0], {
            snap: this.options.snap,
            steps: this.options.data.labels.length * 6,
            wheel: true,
            initialStep: 1,
            range: [1, this.options.data.length],
            onChange: function(intStep) {
                this.sliderChange(intStep);
            }.bind(this)
        });



        this.container.getElements('.labels li').addEvent(this.clickEvent, function(e, i) {
            _this.slider.set(($$(e.target)[0].get('data-customstep')-1)*6 + 3);
        });

        this.render();
        
        //$$('.labels li').each(function(e, i){
        //    e.addEvent('keyup', function(el){
        //        if(el.key === 'tab'){
        //            _this.slider.set(_this.sliderLabels.getChildren('li').indexOf(this) + 1);
        //        }
        //    });
        //});
    },

    sliderChange: function(intStep) {
        $$('.slide').hide();
        step = Math.floor(intStep / 6) + 1;
        $$('.slide.slide-' + step).show();
    }

});