DataImageSlider = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    // Set initial options here
    options: {
        snap: false,
        lastIsFake: false
    },

    step: 1,

    // initialize - widget initialization
    initialize: function(options) {
        var _this = this;

    	this.parent(options);

        this.slider = new Slider(this.sliderContainer, this.sliderKnob, {
            snap: this.options.snap,
            steps: this.options.data.length - 1,
            wheel: true,
            range: [1, this.options.data.length],
            // onComplete: function(intStep) {
            //     this.sliderComplete(intStep);
            // }.bind(this),
            onChange: function(intStep) {
                this.sliderChange(intStep);
            }.bind(this)
        });

        this.container.getElements('.labels li').addEvent(this.clickEvent, function(e, i) {
            _this.slider.set(_this.sliderLabels.getChildren('li').indexOf(this) + 1);
        });

        this.render();
        
        $$('.teratogen .labels li').each(function(e, i){
            e.addEvent('keyup', function(el){
                if(el.key === 'tab'){
                    _this.slider.set(_this.sliderLabels.getChildren('li').indexOf(this) + 1);
                }
            });
        });
    },

    sliderChange: function(intStep) {
        if (!this.slider) {
            return false;
        }
        if (this.options.lastIsFake && intStep > this.slider.steps) {
            this.slider.set(this.slider.steps);
        }
        this.step = this.slider.step;
        this.render();
    },

    createDOM: function() {        
        var step, imgPath;
        this.sliderContainer = new Element('div.slider').inject(this.body);
        new Element('div.line').inject(this.sliderContainer);
        this.sliderLabels = new Element('ul.labels').inject(this.body);
        this.sliderKnob = new Element('div.knob').inject(this.sliderContainer);

        var contentArea = new Element('div.content-area').inject(this.body);
        this.textContent = new Element('div.text-content').inject(contentArea);
        this.imageContent = new Element('div.image-content').inject(contentArea);

        for (var i = 0; i < this.options.data.length; i++) {
            step = this.options.data[i];
            for (var j = 0; j < step.text.length; j++) {
                new Element('h5', {
                    html: step.text[j].title,
                    'data-step': i + 1
                }).inject(this.textContent);
                new Element('p', {
                    html: step.text[j].content,
                    'data-step': i + 1
                }).inject(this.textContent);
            };

            imgPath = step.img ?
                'url(' + step.img + ')' :
                'url(images/slide' + (i + 1) + '.png)';
            new Element('div.step-img', {
                'data-step': i + 1
            }).setStyle(
                'background-image',
                imgPath
            ).inject(this.imageContent);

            if (step['img-title']) {
                new Element('h3.img-title', {
                    html: step['img-title'],
                    'data-step': i + 1
                }).inject(this.imageContent);
            }
            if (step['img-title']) {                
                new Element('h4.img-subtitle', {
                    html: step['img-subtitle'],
                    'data-step': i + 1
                }).inject(this.imageContent);
            }

            if (step['free-text']) {
                for (var j = 0; j < step['free-text'].length; j++) {
                    new Element('span.free-text', {
                        html: step['free-text'][j],
                        'data-step': i + 1,
                        'data-id': j
                    }).inject(this.imageContent);
                };
            }

            new Element('li', {
                'data-customstep': i+1,
                tabindex: 0,
                html: step.name,
               // 'aria-hidden': true
            }).inject(this.sliderLabels);
        };
    },

    // render - updates the widget display
    render: function() {
    	this.parent();

        this.container.getElements('[data-step]').hide();
        this.container.getElements('[data-step="' + this.step + '"]').show();
    }
});