MapWidget = new Class({
    Implements: [Options, Events],
    options: {
        delay: 3500,
        widgetContainer: "#widgetContainer",
        controlsContainer: "#controls",
    },
    // initialize - widget initialization
    initialize: function(options) {
        var _this = this;
        this.setOptions(options);
        this.currentStep = -1;

        // Build table with filters
        this.buildControls();
        this.buildFunctionality();
        this.buildPopups();

        // Create Loupe
        this.mooloupe = new md.widgets.MooLoupe(this.nationalMap, {
            width: 200,
            height: 200,
            magnification: 0.8,
            controls: false,
            hidden: true,
            circular: true,
            padding: 6,
            'main-image': $$('.map-overlay')[0]
        });
        this.addTabIndex();

        document.onkeydown = function(evt) {
            if (evt.keyCode == 32 || evt.keyCode == 13) {
                _this.triggerActions();
            }
        };

        new Element("div.offscreen.legendassertive",{
          "aria-live":"assertive"
        }).inject($$(this.options.widgetContainer)[0]);
    },
		triggerActions : function(){
			element = document.activeElement;
			
			if(typeof element.getChildren('td.checkBox')[0] !=  'undefined'){
					element.fireEvent("click");	
			}
			if(element.hasClass('popup')){
					$$('body span.popup').addClass('hidden');
					info_id = element.get('data-info');
					$$('button[data-info="'+info_id+'"]')[0].focus();
			}
		},
    buildSlider: function() {
        var _this = this;

        // Create the dom
        var sliderDom = new Element('div.slider');
        new Element('div.line').inject(sliderDom);
        new Element('div.knob').inject(sliderDom);
        sliderDom.inject($$(this.options.widgetContainer)[0]);

        // Create Slider
        this.slider = new SliderAccess($$('.slider')[0], $$('.slider .knob')[0], {
            snap: false,
            steps: 100,
            range: [0, 100],
            parent_element: _this,
            maxWidth: $$('.slider .line')[0].getDimensions().width,
            onChange: function(intStep) {
                _this.sliderChange(intStep);
            }
        });

        $$('.slider .knob').addEvent('mousedown', function() {
            $$('.container')[0].addClass('mousedown');
        });
        $$('body, .slider .knob').addEvent('mouseup', function() {
            $$('.container')[0].removeClass('mousedown');
        });
    },
    buildLegend: function() {
        if(this.options.data.comparative.legends) {
            // Create the dom
            var legendDom = new Element('aside.legend-wrapper');
            new Element('h2', {
                'html': this.options.data.comparative.title
            }).inject(legendDom);

            var table = new Element('table.data');

            // Fill legends table
            this.options.data.comparative.legends.each(function(el) {
                var tr = new Element('tr', {
                    'data-description': ''
                });
                new Element('td.color', {
                    styles: {
                        'background-color': el.color,
                    },
                }).inject(tr);
                new Element('td.txt', {
                    html: el.text
                }).inject(tr);
                tr.inject(table);
            });
            table.inject(legendDom);

            legendDom.inject($$(this.options.widgetContainer)[0]);
        }
    },
    buildControls: function() {
        var _this = this;

        // Create the dom
        new Element('div.disable-control').inject($$(this.options.controlsContainer)[0]);

        // Filters table
        var filtersDom = new Element('div.legend.separator');
        var filterTitle = new Element('div.title').inject(filtersDom);
        var filterDiv = new Element('div.table').inject(filtersDom);
        this.filterTable = new Element('table.checkBoxes');
        this.filterTable.inject(filterDiv);
        new Element('h3', {html: this.options.data.controls.title}).inject(filterTitle);
        new Element('h3.subtitle', {html: this.options.data.controls.subtitle}).inject(filterTitle);
        filtersDom.inject($$(this.options.controlsContainer)[0]);

        // Walkthrough
        var walkthroughDom = new Element('div.control-toggle.separator.walkthrough');
        new Element('h3.title.main', {html: this.options.data.controls.walkthrough}).inject(walkthroughDom);
        this.walkthrough = new Element('div').inject(walkthroughDom);


        this.walkButtonNext = new Element('button.walkButtonNext', {
            html: '<i class="fa fa-play"></i>'}
        ).addEvent('click', function(e, i) {
            _this.nextWalkthrough();
        }).inject(walkthroughDom);
        this.walkButtonClear= new Element('button.walkButtonClear.hidden', {
            html: '<i class="fa fa-refresh"></i>'
        }).addEvent('click', function(e, i) {
            _this.clearWalkthrough();
        }).inject(walkthroughDom);
        this.walkButtonPrev= new Element('button.walkButtonPrev.disabled', {
            html: '<i class="fa fa-play"></i>'
        }).addEvent('click', function(e, i) {
            _this.prevWalkthrough();
        }).inject(walkthroughDom);
        walkthroughDom.inject($$(this.options.controlsContainer)[0]);

        // Loupe
        var loupeDom = new Element('div.control-toggle.loupe');
        new Element('h3.title', {html: this.options.data.controls.loupe}).inject(loupeDom);
        new Element('button#showHideLoupe', {
            html: '<div class="loupe-toggle1"><i class="fa fa-plus"></i></div>'
        }).addEvent('click', function() {
            if ($$('.mooloupe').length > 0 && $$('.mooloupe')[0].hasClass('mooloupe-hidden')) {
                $$('.loupe-toggle1 .fa').removeClass('fa-plus').addClass('fa-minus');
                $$('.control-toggle.loupe .title').set('html', '<span class="responsive-call-to-action">Click or tap</span> to hide the magnifying loupe.');
            }
            else {
                $$('.loupe-toggle1 .fa').removeClass('fa-minus').addClass('fa-plus');
                $$('.control-toggle.loupe .title').set('html', '<span class="responsive-call-to-action">Click or tap</span> to show a magnifying loupe over the map.');
            }
            insert_call_to_action_text();
            _this.mooloupe.toggle();
            return false;
        }).inject(loupeDom);
        loupeDom.inject($$(this.options.controlsContainer)[0]);
        
    },
    buildFunctionality: function() {
        var _this = this;
        this.overlays = [];
        this.walkthroughTexts = [];
        this.filters = [];

        // Build Dom
        this.mapContainer = new Element('div#map-container.map-container');
        this.nationalMap = new Element('figure#map').inject(this.mapContainer);
        var mapOverlays = new Element('div#mapOverlays').inject(this.nationalMap);
        this.infoWrapper = new Element('div#infoWrapper').inject(this.mapContainer);

        // Build underlays
        if(this.options.data.underlays) {
            this.options.data.underlays.each(function(el) {
                new Element('img.map-overlay', {
                    "src": el
                }).inject(mapOverlays);
            });
        }

        // Compare if map has comparative data
        if(this.options.data.comparative) {
            // Add comparative map if exists
            this.mapComparatives = new Element('div#mapComparatives.mapComparatives').inject(this.nationalMap);

            // Ad Slider and Legend
            this.buildSlider();
            this.buildLegend();

            // Build comparative overlay
            new Element('img.map-overlay-comparative', {
                "src": this.options.data.comparative.image
            }).inject(this.mapComparatives);
        } else {
            this.mapContainer.addClass('no-slider');
        }
        

        // Apend widget to widget container
        this.mapContainer.inject($$(this.options.widgetContainer)[0]);

        // Itarate through each filter
        Object.each(this.options.data.filters, function(filter, i) {
            // Build filter overlays
            var overlay = new Element('img.map-overlay', {
                "src": filter.image,
                "data-id" : "layer-" + i
            })
            overlay.inject(mapOverlays);
            _this.overlays.push(overlay);

            // Build walkthrough
            var walkthroughText = new Element('h3', {
                "class": "title walkthrough-text hidden",
                html: filter.text
            })
            walkthroughText.inject(_this.walkthrough);
            _this.walkthroughTexts.push(walkthroughText);

            // Build filters
            var column = new Element('tr', {
                'data-description': '',
                'aria-label': filter.description ? filter.description : '',
                events: {
                    click: function(is_walktrough){
                        _this.overlays[i].toggle();
                        this.getElement('.checkBox span').toggle();
                        this.toggleClass('overlay-hidden');
                        $$(".mooloupe-loupe img[data-id='layer-" + i + "']").toggle();

                        // If user clicks a filter reset walktrough
                        if(is_walktrough !== true) {
                            _this.currentStep = -1;
                            $$('aside.controls h3.main').removeClass('hidden');
                            _this.walkButtonNext.removeClass('disabled');
                            _this.walkButtonPrev.addClass('disabled');
                            _this.walkButtonClear.addClass('hidden');
                            _this.walkthroughTexts.each(function(text) {
                                text.addClass('hidden');
                            });
                        }
                    },
                }
            });
            new Element('td.checkBox', {
                html: '<span><i class="fa fa-check"></i></span>',
                styles: { "background-color": filter.color }
            }).inject(column);

            new Element('td', { "class": "txt", html: filter.legend }).inject(column);

            column.inject(_this.filterTable);
            _this.filters.push(column);
        });

        // Build extra overlays
        if(this.options.data.overlays) {
            this.options.data.overlays.each(function(el) {
                new Element('img.map-overlay', {
                    "src": el,
                }).inject(mapOverlays);
            });
        }

        if(this.options.data.comparative) {
            $$('.map-overlay')[0].addEvent('load', function() {
                _this.mapComparatives.setStyle('height', $$('.map-overlay')[0].getSize().y)
                .setStyle('width', 0);
            });
        }
    },
    buildPopups: function(popups){
        var _this = this;
				

        if(this.options.data.popups) {
            this.options.data.popups.each(function(popup, i){
								position =  '';
								if(typeof popup.position != 'undefined'){
										position = popup.position;
								}
								 img = new Element('button', {
										'type' : 'image',

                    'src': '../../_framework/_base_pearson/images/info.png',
                    'class': 'icon-info info-' + i,
                    'data-info': 'info-' + i,
                    'aria-label':"Map callout: "+ popup.text
                 }).inject(_this.infoWrapper);
                 
                 img.setStyle('top', popup.y);
                 img.setStyle('left', popup.x);
                 
                 text = new Element('span', {
                    html: popup.text,
										'tabindex' : 0,
                    'class': 'popup txt hidden info-' + i,
                    'data-info': 'info-' + i,
										'data-position' : position,
                 }).inject(_this.infoWrapper);
                 
								 
									if(position == 'left'){
										text.setStyle('top', popup.y + -35);
                 		text.setStyle('left', popup.x - 205);
									
									}else if(position == 'top'){
										text.setStyle('top', popup.y -  140);
                 		text.setStyle('left', popup.x -78);
									
									}
									else{
										text.setStyle('top', popup.y + 40);
                 		text.setStyle('left', popup.x - 78);
										
									}
								 
                 
            });
            $(document.body).addEvent('click', function(e) {
                if (!$(e.target).hasClass("icon-info")) {
                    $$('body span.popup').addClass('hidden');
                }
            });
            $$('body .icon-info').addEvent('click', function(e, i) {

                if($$('body span.' + this.getAttribute('data-info'))[0].hasClass("hidden")){
                  $$('body span.popup').addClass('hidden');
                  $$('body span.' + this.getAttribute('data-info')).removeClass('hidden');
                  //$$('body span.' + this.getAttribute('data-info'))[0].focus();
                }
                else{

                  $$('body span.popup').addClass('hidden');
                }

            });
        }
    },
    nextWalkthrough: function() {
        if (this.currentStep < this.options.data.filters.length-1 && !this.walkButtonNext.hasClass("disabled")) {
            this.currentStep++;

            // Skip last filter if it's empty
            if(this.walkthroughTexts[this.currentStep+1] && this.walkthroughTexts[this.currentStep+1].get('html') == "") {
                this.walkButtonNext.addClass('disabled');
            }

            this.hideAllOverlays();
            this.filters[this.currentStep].fireEvent('click', true);
            this.walkthroughTexts[this.currentStep].removeClass('hidden');
            this.walkButtonPrev.removeClass('disabled');
            this.walkButtonClear.removeClass('hidden');
            if(this.currentStep == this.options.data.filters.length-1) {
                this.walkButtonNext.addClass('disabled');
            }
        }
    },
    prevWalkthrough: function() {
        if (this.currentStep > 0) {
            this.hideAllOverlays();
            this.filters[--this.currentStep].fireEvent('click', true);
            this.walkthroughTexts[this.currentStep].removeClass('hidden');
            this.walkButtonNext.removeClass('disabled');
            if (this.currentStep == 0) {
                this.walkButtonPrev.addClass('disabled');
            }
        }
    },
    clearWalkthrough: function() {
        this.currentStep = -1;
        this.hideAllOverlays();
        $$('aside.controls h3.main').removeClass('hidden');
        this.walkButtonNext.removeClass('disabled');
        this.walkButtonPrev.addClass('disabled');
        this.walkButtonClear.addClass('hidden');
        this.filterTable.getElements('tr').fireEvent('click', true);
    },
    sliderChange: function(step) {
        var width = (step < 30)?step-0:step-0.5;

        $$('.legend.separator, .walkthrough').setStyle('opacity', (step < 90) ? 1 : 0.5);
        $$('.disable-control').setStyle('width', (step < 90) ? '0' : '70%');

        this.mapComparatives.setStyle('width', width + '%');
        $$('.mooloupe-loupe-content-wrapper .mapComparatives').setStyle('width', width + '%');

        if(step == 0 || step == 100) {
            this.mapComparatives.setStyle('border-right', '0 none');
            $$('.mooloupe-loupe-content-wrapper .mapComparatives').setStyle('border-right', '0 none');
        } else {
            this.mapComparatives.setStyle('border-right', '1px solid #FF0000');
            $$('.mooloupe-loupe-content-wrapper .mapComparatives').setStyle('border-right', '2px solid #FF0000');
        }

        if (step > 35) {
            $$('.legend-wrapper').show();
            if($$('.legend-wrapper').length>0){
              if($$(".legendassertive").length>0 && !$$(".legendassertive")[0].hasClass("setted")){
                $$(".legendassertive")[0].addClass("setted");
                $$(".legendassertive")[0].empty();
                $$(".legendassertive")[0].set("html",$$('.legend-wrapper')[0].get("html"));
              }
            }

        } else {
            $$('.legend-wrapper').hide();
            if($$(".legendassertive").length>0 && $$(".legendassertive")[0].hasClass("setted")){
                $$(".legendassertive")[0].removeClass("setted");
                $$(".legendassertive")[0].empty();
            }
        }
    },
    hideAllOverlays: function()  {
        $$('aside.controls h3.main').addClass('hidden');
        this.filters.each(function(filter) {
            if (!filter.hasClass('overlay-hidden')) {
                filter.fireEvent('click', true);
            }
        });
        this.walkthroughTexts.each(function(text) {
            text.addClass('hidden');
        });
    },
		addTabIndex : function(){
            var _this = this;
			container = document.getElement('.MapWidget');
			container.getElement('.note').set('tabindex', 0).set('aria-hidden','true');
            if(container.getElement('.legend .title'))
			    container.getElement('.legend .title').set('tabindex', 0);
			container.getElements('.control-toggle .title').set('tabindex', 0).set('aria-hidden','true');
            if(container.getElement('.walkButtonNext'))
			    container.getElement('.walkButtonNext').set('tabindex', 0).set('aria-hidden','true');
			if(container.getElement('.walkButtonClear'))
                container.getElement('.walkButtonClear').set('tabindex', 0).set('aria-hidden','true');
			if(container.getElement('.walkButtonPrev'))
                container.getElement('.walkButtonPrev').set('tabindex', 0).set('aria-hidden','true');
            if(container.getElements(".button-wrapper .button"))
                container.getElements('.button-wrapper .button').set('tabindex', 0);
            if(container.getElements(".table .checkBoxes"))
                container.getElements('.table .checkBoxes tr').set('tabindex', 0);
            if(container.getElement('#showHideLoupe'))
                container.getElement('#showHideLoupe').set('tabindex', 0).set('aria-hidden','true');
            if(container.getElements('tr'))
			    container.getElements('tr').set('tabindex', 0);
            if(container.getElements(".controls h3"))
                container.getElements('.controls h3').set('tabindex', 0);
            
            if(this.slider){
                new Element("button.instruction", {'tabindex': 0, value: container.getElement('.note').get("text").replace("Drag the slider to the right to ", "Compare the map showing ")})
                    .addEvent('click', function(e){
                        _this.slider.set(99);
                        if(container.getElement("#mapComparatives")){
                            container.getElement("#mapComparatives").setStyles({
                                "border-right-width": "0px",
                                "border-right-style": "none"
                            });
                            container.getElement(".legend-wrapper table.data tr:first-child").focus();
                        }
                    })
                    .inject(container.getElement("footer"));
            }
		}
});