SurveyInventory = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    // Set initial options here
    options: {
    },
    assets:[
        '../_framework/_base_external/d3.v3.min.js'
    ],
    mode: null,
    scale: null,
    data_tf: null,
    scoring: null,
    intro: false,
    cases: [],
    // initialize - widget initialization
    initialize: function (options) {
        document.visitedWidgetPages = []
        var _this = this;
        var MetrodigiWidget = $('MetrodigiWidget');
        this.mode = MetrodigiWidget.getProperty('data-xml-type');
        this.scoring = Boolean(MetrodigiWidget.getProperty('data-scoring'));
        this.scale = MetrodigiWidget.getProperty('data-scale');
        this.data_tf = MetrodigiWidget.getProperty('data-tf');
        this.standard_deviation = MetrodigiWidget.getProperty('data-standard-deviation');
        this.standard_deviation_average_score = MetrodigiWidget.getProperty('data-standard-deviation-avarage-score');
        this.standard_deviation_norm_sd = MetrodigiWidget.getProperty('data-standard-deviation-norm-sd');
        this.standard_deviation_norm_mean = MetrodigiWidget.getProperty('data-standard-deviation-norm-mean');
        this.feedback_result = MetrodigiWidget.getProperty('data-answer-feedback');
        
        options.extra = [];
        options.extra.push('data-scoring');
        options.extra.push('data-tf');
        options.extra.push('data-scale');
        options.extra.push('data-answer-feedback');
        options.extra.push('data-standard-deviation');
        options.extra.push('data-standard-deviation-norm-mean');
        options.extra.push('data-standard-deviation-norm-sd');
        options.extra.push('data-standard-deviation-avarage-score');
        
        options.extra.push('data-categorized-responses');
        options.extra.push('data-customize-statement');
        options.extra.push('data-customize-score');
        options.extra.push('data-customize-scoring-breakdown');
        options.extra.push('data-customize-scoring-sumarry');
        options.extra.push('data-customize-scoring-sumarry-text');
        options.extra.push('data-customize-question-response');
        options.extra.push('data-single-text-response-text');

        this.addAccessibility();
        this.parent(options);
        this.options = options;
        this.setUPSettings(options);

        $$('.alert')[0].set('text', '');

        
        if (this.isEditMode) {
            $$('.widget-footer').hide();
            $$('.questions, .results').setStyle("overflow-y","auto");
            $$('.item').hide();
            if (this.intro) {
                //$$('.item').hide();
                //$$('.intro').show();
            }
        }

        if (!this.isEditMode) {
            setTimeout(function () {
                _this.initAccessibility();
            }, 500);
        }
        if ($$('.intro')[0]) {
            $$('.intro')[0].getChildren('p').map(function(item){
                if(item.get('text') === ""){
                    return item.remove();
                }
                return;
            })
        }
        setTimeout(function(){
            touchScroll(null, $$('.widget-content')[0]);
        },0)

    },
    setUPSettings:function(options){
        this.categorized_responses = options.data.categorized_fallback!=null?options.data.categorized_fallback:true ;
        
        if(this.standard_deviation == true || this.standard_deviation == 'true'){
            this.categorized_responses = false;
        }
        
        if(this.categorized_responses){
            this.standard_deviation = false;
        }

        this.customize_statement = options.data.customize_statement!=null?options.data.customize_statement:true ;
        this.customize_score = options.data.customize_score!=null?options.data.customize_score:true ;
        this.customize_scoring_breakdown = options.data.customize_scoring_breakdown!=null?options.data.customize_scoring_breakdown:true ;
        this.customize_scoring_sumarry = options.data.customize_scoring_sumarry!=null?options.data.customize_scoring_sumarry:true ;
        this.customize_scoring_sumarry_text = options.data.summary_screen_text!=null?options.data.summary_screen_text:'' ;
        this.customize_question_response = options.data.customize_question_response!=null?options.data.customize_question_response:true ;
        this.single_text_response = options.data.categorized_fallback_text!=null?options.data.categorized_fallback_text:'' ;
        this.summary_your_score_text = options.data.summary_your_score_text!=null?options.data.summary_your_score_text:'Your Score';
        this.category_feedback_message = options.data.category_feedback_message!=null?options.data.category_feedback_message:'Your Result:';
        this.intro_line_summary = options.data.intro_line_summary!=null?options.data.intro_line_summary:'';
        this.customize_standard_deviation_graph = options.data.customize_standard_deviation_graph!=null?options.data.customize_standard_deviation_graph:true;
        this.prefix_category_summary = options.data.prefix_category_summary!=null?options.data.prefix_category_summary:'Scores';
        this.show_summary_screen_intro = options.data.show_summary_screen_intro!=null?options.data.show_summary_screen_intro:true ;


        // We will send the cases to the checkresults method
        this.cases = this.preRender();
        // Set the pages for the paginator
        var pages = 4;
        switch (this.mode) {
            case 'Likert':
                if (this.scale > 4) {
                    pages = 2;
                }
                break;
            case 'Open':
                pages = 2;
                break;
        }

        if($('intro-line')==null || ($('intro-line')!=null && $('intro-line').get('text')=='')){
            $$('.widget-header').addClass('widget-header-no-text')
        }

        this.addEventsFooter(pages);
    },
    /* HELPERS */

    getLikertScaleCases:function(scale){
        var cases = [];
        switch (scale) {
            case '2':
                cases[2] = "Agree";
                cases[1] = "Disagree";
                break;
            case '3':
                cases[3] = "Agree";
                cases[2] = "Neither Agree nor Disagree";
                cases[1] = "Disagree";
                break;
            case '4':
                cases[4] = "Strongly Agree";
                cases[3] = "Agree";
                cases[2] = "Disagree";
                cases[1] = "Strongly Disagree";
                break;
            case '5':
                cases[5] = "Strongly Agree";
                cases[4] = "Moderately Agree";
                cases[3] = "Neither Agree nor Disagree";
                cases[2] = "Moderately Disagree";
                cases[1] = "Strongly Disagree";
                break;
            case '6':
                cases[6] = "Strongly Agree";
                cases[5] = "Moderately Agree";
                cases[4] = "Somewhat Agree";
                cases[3] = "Somewhat Disagree";
                cases[2] = "Moderately Disagree";
                cases[1] = "Strongly Disagree";
                break;
            case '7':
                cases[7] = "Strongly Agree";
                cases[6] = "Moderately Agree";
                cases[5] = "Somewhat Agree";
                cases[4] = "Neither Agree nor Disagree";
                cases[3] = "Somewhat Disagree";
                cases[2] = "Moderately Disagree";
                cases[1] = "Strongly Disagree";
                break;
            case '8':
                cases[8] = "Strongly Agree";
                cases[7] = "Agree";
                cases[6] = "Moderately Agree";
                cases[5] = "Mildly Agree";
                cases[4] = "Mildly Disagree";
                cases[3] = "Moderately Disagree";
                cases[2] = "Disagree";
                cases[1] = "Strongly Disagree";
                break;
            case '9':
                cases[9] = "Strongly Agree";
                cases[8] = "Agree";
                cases[7] = "Moderately Agree";
                cases[6] = "Mildly Agree";
                cases[5] = "Neither Agree nor Disagree";
                cases[4] = "Mildly Disagree";
                cases[3] = "Moderately Disagree";
                cases[2] = "Disagree";
                cases[1] = "Strongly Disagree";
                break;
        }

        return cases;
    },

    // PreviewMode
    preRender: function () {
        var _this = this;
        var cases = [];
        switch (this.mode) {
            case 'T / F':
                if (this.data_tf === "0 | 1") {
                    cases[1] = "True";
                    cases[0] = "False";
                } else {
                    cases[2] = "True";
                    cases[1] = "False";
                }
                break;
            case 'Likert':
                cases = this.getLikertScaleCases(this.scale);
                break;
            case 'Open':
                Array.each(this.options.data.questions, function (item, index) {
                    Array.each(item.answers, function (answer, _index) {
                        //html += '<div><label><input type="radio" name="' + index + '" value="' + answer.value + '"/>' + answer.answer + '</label></div>';
                        if(cases[index]==null){
                            cases[index] = [];
                        }
                        cases[index].push( answer );
                    });
                });
                
                break;
        }
        this.generateDOM(cases);
        this.addEvents();

        return cases;
    },
    // Generate the html for cases
    generateDOM: function (cases) {
        var _this = this;
        var questions = $$('.questions .list');
        $$('.questions .list')[0].empty();
        var number = 1;
        if ((typeof this.options.data.intro !== 'undefined' && this.options.data.intro !== '' && !_this.isEditMode) || _this.isEditMode) {
            questions.appendHTML('<li class="item intro">' + (this.options.data.intro?this.options.data.intro:'') + '</li>');
            this.intro = true;
        }
        Array.each(this.options.data.questions, function (item, index) {
            var question_title = _this.getQuestionTitle(item);
            var html = '<li class="item"><fieldset><legend class="question">' + number + '. ' + question_title + '<span style="position:absolute;left:-1000%;"> This field is required. </span></legend>';

            if(item==null) return;

            if (_this.mode === 'Open') {
                Array.each(item.answers, function (answer, _index) {
                    html += '<div><input type="radio" data-case-index="' + index + '" value="' + answer.value + '" name="question_'+ number  +'" id="question_'+ number + '_' + _index +'"/><label for="question_'+ number + '_' + _index +'">' + answer.answer + '</label></div>';
                });
            } else if( item!=null ) {
                if (item.reverse === 'true') {
                    //debugger;
                    var _cases = cases.slice(0).reverse();
                    //debugger;
                    Array.each(_cases, function (item, value) {
                        value = parseInt(value);
                        value++;
                        if (_this.mode === 'T / F' && _this.data_tf === '0 | 1') {
                            value--;
                        }
                        html += '<div><input type="radio" data-case-index="' + index + '" value="' + value + '" name="question_'+ number  +'" id="question_'+ number + '_' + value +'"/><label for="question_'+ number + '_' + value +'">' + item + '</label></div>';
                    });
                } else {
                    var aux = 1;
                    if (_this.mode === 'T / F' && _this.data_tf === '0 | 1') {
                        aux = 0;
                    }
                    for (var value = cases.length - 1; value >= aux; value--) {
                        html += '<div><input type="radio" data-case-index="' + index + '" value="' + value + '" name="question_'+ number  +'" id="question_'+ number + '_' + value +'"/><label for="question_'+ number + '_' + value +'">' + cases[value] + '</label></div>';
                    }
                }
            }
            html += '</fieldset></li>';
            questions.appendHTML(html);
            number++;
        });
    },
    // Add events for the inputs on change
    addEvents: function () {
        var _this = this;
        $$('.questions input').addEvent('change', function () {
            _this.options.data.questions[this.get('data-case-index')]['result'] = this.get('value');
        });
    },
    // Add events for the footer
    addEventsFooter: function (pages) {
        var _this = this;
        var page = 1;
        var extra = 1;
        $$('.questions .item').each(function (item, index) {
            item.addClass('page-' + page);
            item.setProperty('data-page', page);
            if (page === 1) {
                item.addClass('show');
            }
            if (item.hasClass('intro')) {
                extra = pages;
            }
            var count = index + extra;
            if (count % pages === 0) {
                page++;
            }
        });

        /* Pager */
        if (typeof this.options.data.questions !== 'undefined') {
            var total = this.options.data.questions.length;
            if (this.intro) {
                total += pages;
            }
            var max = total / pages;
            if (Math.floor(max) !== max) {
                max = parseInt(max);
                max++;
            }
            if (total <= pages) {
                $('next').hide();
                $('check').show();
            }

            if($$('.item.show')[0].hasClass('intro')){
                $('MetrodigiWidget').addClass('item-intro');
            }

            $('next').addEvent('click', function () {
                var MetrodigiWidget = $('MetrodigiWidget');
                MetrodigiWidget.removeClass('item-intro');
                MetrodigiWidget.removeClass('summary-active');
                var current = $$('.item.show').getProperty('data-page');
                $$('.item.show').getParent()[0].removeProperty('tabindex').set('tabindex',-1).focus();



                if (typeof current[0] !== 'undefined') {
                    var next = parseInt(current[0]) + 1;
                    $('previous').removeProperty('disabled');

                }
                if (next <= max) {
                    $$('.item.show').removeClass('show');
                    $$('.item.page-' + next).addClass('show');

                    if( $('intro-line') ){
                        setTimeout(function(){
                            $('intro-line').focus();
                        }, 500);

                    }else
                    {
                        $$('.show .question')[0].focus();
                    }
                }
                if (next === max) {
                    $('next').hide();
                    $('check').show();
                    // $('check').focus();
                }
              try{

                if (document.visitedWidgetPages.indexOf(next) == -1){

                    document.dispatchEvent(document.resizeQuestions)
                    document.visitedWidgetPages.push(next);
                    document.visitedWidgetPages.push(next - 1);
                } else {
                    
                    document.dispatchEvent(document.unResizeQuestions)
                }
              } catch(e){
                console.log('no iphone')
              }

                _this.updateContentHeight();
                _this.resetContentScrollPos();
            });
            $('previous').addEvent('click', function () {
                $('MetrodigiWidget').removeClass('summary-active');
                $('MetrodigiWidget').removeClass('item-intro');

                var current = $$('.item.show').getProperty('data-page');

                $$('.item.show').getParent()[0].removeProperty('tabindex').set('tabindex',-1).focus();

                $('next').show();
                $('check').hide();
                if (typeof current[0] !== 'undefined') {
                    var prev = parseInt(current[0]) - 1;
                    $('next').removeProperty('disabled');
                }
                if (prev > 0) {
                    $$('.item.show').removeClass('show');
                    $$('.item.page-' + prev).addClass('show');
                    if($$('.item.intro.page-' + prev).length>0){
                        $('MetrodigiWidget').addClass('item-intro');
                        setTimeout(function(){
                            // $$('.intro.item [tabindex]')[0].focus();
                        }, 500);
                    } else {
                        if( $('intro-line') ){
                            setTimeout(function(){
                                $('intro-line').focus();
                            }, 500);
                        }else
                        {
                            $$('.show .question')[0].focus();
                        }
                    }
                  if(prev > 1){
                    try{
                      $$('.alert')[0].setAttribute('tabindex', -1);
                      $$('.alert').setStyle('visibility', 'hidden');
                      $$('.alert').setStyle('display', 'none');
                      $$('.alert')[0].set('text', '');
                      // document.dispatchEvent(document.resizeQuestions)
                    } catch(e){
                      console.log('no iphone')
                    }
                  }

                }
                if (prev === 1) {
                  $$('.alert')[0].setAttribute('tabindex', -1);
                  $$('.alert').setStyle('visibility', 'hidden');
                  $$('.alert').setStyle('display', 'none');
                  $$('.alert')[0].set('text', '');
                    this.setProperty('disabled', 'disabled');
                }

                _this.updateContentHeight();
            });
        }


        $('restart').addEvent('click', function () {
            location.reload();
        });
        $('check').addEvent('click', function () {
            _this.checkResults();
        });
    },
    // Validate
    validate: function () {
        var ok = true;
        Array.each(this.options.data.questions, function (item) {
            if (item!=null && typeof item.result === 'undefined') {
                ok = false;
            }
        });
        if (ok) {
            $$('.alert').setStyle('visibility', 'hidden');
            $$('.alert')[0].setAttribute('tabindex', -1);
            return true;
        } else {
            $$('.alert')[0].set('text', 'Please answer all the questions.');
            $$('.alert')[0].setAttribute('tabindex', 0);
            $$('.alert').setStyle('visibility', 'visible');
            $$('.alert').setStyle('display', 'block');
            $$('.alert')[0].focus();
            try{
                document.dispatchEvent(document.resizeQuestionsOnAlert)
            } catch(e){
                console.log('no iphone')
            }
            setTimeout(function (){
                $$('.alert')[0].setAttribute('tabindex', -1);
                $$('.alert').setStyle('visibility', 'hidden');
                $$('.alert').setStyle('display', 'none');
                $$('.alert')[0].set('text', '');
                try{
                    document.dispatchEvent(document.resizeQuestionsOnAlertOff)
                } catch(e){

                }
            }, 2500)
            return false;
        }
    },
    // Check the results of the user
    checkResults: function () {
        $('MetrodigiWidget').removeClass('item-intro');
        
        
        // Validate
        if (!this.isEditMode && !this.validate()) {
            return true;
        }

        $('MetrodigiWidget').addClass('summary-active');


        if(!this.isEditMode)
          $$('.questions').destroy();
        else{
            $$(".questions").hide();
            $$('.results')[0].empty()
            var _this = this;
            Array.each(this.options.data.questions, function(e,i){
                if(_this.options.data.questions[i]!=null){
                    
                    if(_this.options.data.questions[i].answers!=null && _this.options.data.questions[i].answers.length>0)
                        _this.options.data.questions[i].result = _this.options.data.questions[i].answers[_this.options.data.questions[i].answers.length - 1].value;
                    else
                        _this.options.data.questions[i].result = 2;
                }
            });

        }
        $$('.results').show();

        this.SIWrapper = new Element('div.survey-inventory-result').inject(this.container.getElement('.results'));

        if (this.scoring) {
            this.scoring_inventory();
        } else {
            this.scoring_survey(this.cases);
        }

        this.updateContentHeight();
        this.resetContentScrollPos();

        try{
            document.dispatchEvent(document.resizeResults)
        } catch(e){
            console.log('no iphone')
        }

        $('previous').hide();
        $('next').hide();
        $('check').hide();

        $('restart').show();

      $$('.survey-inventory-result').set('tabindex',-1);
      $$('.survey-inventory-result')[0].focus();


      setTimeout(function(){
            if($$('.results [tabindex]').length > 0){
                // $$('.results [tabindex]')[0].focus();
            }
        }, 500);
    },

    updateContentHeight: function () {
        setTimeout(function () {
            window.fireEvent('resize');
        }, 0);
    },

    resetContentScrollPos: function () {
        setTimeout(function () {
            $$('.widget-content')[0].scrollTop = 0;
        }, 0);
    },

    scoring_survey: function (cases) {
        var _this = this;

        if(this.show_summary_screen_intro){

            if(this.isEditMode){

                new Element('div.summary-intro-line', {
                    html: this.intro_line_summary,
                    contenteditable: true
                }).inject($$(".widget-header")[0]);

                var timer_input_intro_line_summary = null;
                $$("div.summary-intro-line[contenteditable]").addEvent("input",function(e){
                    var _this_el = this;
                    if(timer_input_intro_line_summary!=null){
                        clearTimeout(timer_input_intro_line_summary);
                    }
                    timer_input_intro_line_summary = setTimeout(function(){
                        this;
                        this.sendPostMessages('async-widget-data-save',{
                            data_target: "intro_line_summary",
                            value_send: $(_this_el).get("text")
                        })
                    }.bind(_this),750)
                });

            } else {
                if(this.intro_line_summary.replace(/(<([^>]+)>)/ig,"").trim() !=""){
                    new Element('div.summary-intro-line', {
                        // tabindex: 0,
                        html: this.intro_line_summary //
                    }).inject($$(".widget-header")[0]); 
                }
            }
        }

        // show all questions and responses
        this.options.data.questions.forEach(function (el, question_num) {

            var elWrapper = new Element('div.wrapper').inject(_this.SIWrapper);

            // generate the questions
            new Element('div.question-wrapper', {
                html: '<span class="aria-offscreen">original queston.</span>' + '\n' + '<p><span class="num">' + (question_num + 1) + '.</span> ' + el.question + '</p>'
            }).inject(elWrapper);

            // generate the responses
            var responseWrapper = new Element('div.header',{
                // tabindex: 0
            }).inject(elWrapper);

            new Element('div.grid_8', {
                html: '<strong>Response</strong>'
            }).inject(responseWrapper);

            new Element('div.grid_2', {
                html: '<strong>Percentage</strong>'
            }).inject(responseWrapper);
            
            if(el.reverse === 'true') {
                for (var key in el) {
                    if (el.hasOwnProperty(key)) {
                        var element = el[key];
                        if (key != 'question' && key != 'result' && key != 'answers' && cases[key]!=null) {
                            var choice_class = 'other_choice';
                            var percentage_background_color = 'rgb(153, 153, 153)';
                            if (key === el.result) {
                                choice_class = 'user_choice';
                                percentage_background_color = 'rgb(0, 0, 0)';
                            }
                            var percentage_choice = parseInt(element);
                            var response = '<div class="grid_4 option">' + cases[key] + '</div>';
                            var percentage_chart = '<div class="grid_4 graph"><span style="width:' + percentage_choice + '%; background-color: ' + percentage_background_color + ';"></span></div>';
                            var percentage = '<div class="grid_2 percentage" >' + percentage_choice + '%</div>';

                            new Element('div', {
                                'class': choice_class,
                                html: response + '\n' + percentage_chart + '\n' + percentage
                            }).inject(elWrapper);
                        }
                    }
                }
            } else {
                var rows_content = [];
                for (var key in el) {
                    if (el.hasOwnProperty(key)) {
                        var element = el[key];
                        
                        if (key != 'question' && key != 'result' && key != 'answers' && cases[key]!=null) {
                            var choice_class = 'other_choice';
                            var percentage_background_color = 'rgb(153, 153, 153)';

                            if (key == el.result) {
                                choice_class = 'user_choice';
                                percentage_background_color = 'rgb(0, 0, 0)';
                            }
                            var percentage_choice = parseInt(element);
                            var response = '<div class="grid_4 option">' + cases[key] + '</div>';
                            var percentage_chart = '<div class="grid_4 graph"><span style="width:' + percentage_choice + '%; background-color: ' + percentage_background_color + ';"></span></div>';
                            var percentage = '<div class="grid_2 percentage" >' + percentage_choice + '%</div>';

                            rows_content.push({
                                text: response + '\n' + percentage_chart + '\n' + percentage,
                                class: choice_class
                            });
                            
                        }

                        
                    }
                }

                if(rows_content.length>0){
                    rows_content.reverse();
                    rows_content.forEach(function(r){
                        new Element('div', {
                            'class': r.class,
                            html: r.text
                        }).inject(elWrapper);
                    })
                }

                
            }   
            
            
                                
        });

        if(this.customize_scoring_sumarry){
            // new Element('br').inject(this.container.getElement('.results'));
            
            // new Element('p.sumarry-score-text.sumarry-score-text-survey', {
            //     html: this.customize_scoring_sumarry_text
            // }).inject(this.container.getElement('.results'));

            // new Element('br').inject(this.container.getElement('.results'));
        }
        
        var questions_resume = new Element('div.scam-questions-resume', {
            styles: {
                "margin-left": "20px" 
            }
        });                    
        questions_resume.inject($$('.survey-inventory-result')[0]);  
                  
        if(this.customize_question_response){
            Array.each(this.options.data.questions, function (item, ind) {
                // SCAM questions resume item   

                if (item==null) return;
                var answered = ''
                if(_this.mode !== 'Open'){
                    if(item.reverse == "true"){
                        answered = cases_revert[item.result];
                    }else{
                        answered = _this.cases[item.result];
                    }
                } else{
                    answered = _this.getOpenSelectedOption(item, ind);
                }

                if(answered==null){
                    answered = '';
                }
                                    
                if(item.feedback != undefined && item.feedback != null){
                    var feedback = item.feedback;
                }else{
                    var feedback = "";
                }

                var question_title = _this.getQuestionTitle(item);
                
                new Element('div.scam-questions-resume-item', {
                    html: '<p><strong>Question '+(ind+1)+':</strong> '+ question_title + '</p>' +
                            '<p><strong>You answered:</strong> '+ answered + '</p>' +
                            (_this.feedback_result=='true' && feedback.trim()!=''?'<p><strong>Feedback:</strong> '+ feedback +  '</p>':'')
                }).inject(questions_resume);
            });
            } 
        
    },
    draw_bell_curve:function($selector, $half){
        //setting up empty data array
        var data = [];

        getData(); // popuate data

        // line chart based on http://bl.ocks.org/mbostock/3883245
        var margin = {
                top: 5,
                right: 15,
                bottom: 20,
                left: 15
            },
            width = 400 - margin.left - margin.right,
            height = 155 - margin.top - margin.bottom;

        var x = d3.scale.linear()
            .range([0, width]);

        var y = d3.scale.linear()
            .range([height, 0]);


        if(!$half){
            var xAxis = d3.svg.axis()
            .scale(x)
            .orient("bottom");

            /*
            var yAxis = d3.svg.axis()
                .scale(y)
                .orient("left");

            */
        }
        var line = d3.svg.line()
            .x(function(d) {
                return x(d.q);
            })
            .y(function(d) {
                return y(d.p);
            });

        var svg = d3.select($selector).append("svg")
            .attr("width", width + margin.left + margin.right)
            .attr("height", height + margin.top + margin.bottom)
            .append("g")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

        x.domain(d3.extent(data, function(d) {
            return d.q;
        }));
        y.domain(d3.extent(data, function(d) {
            return d.p;
        }));

        if(!$half){
            svg.append("g")
                .attr("class", "x axis")
                .attr("transform", "translate(0," + height + ")")
                .call(xAxis)
                ;
            /*
            svg.append("g")
                .attr("class", "y axis")
                .call(yAxis);

            */
        }
        svg.append("path")
            .datum(data)
            .attr("class", "line")
            .attr("d", line);

        function getData() {

            // loop to populate data array with
            // probabily - quantile pairs
            for (var i = 0; i < 100000; i++) {
                q = normal() // calc random draw from normal dist
                if(Math.abs(q)>3){
                    if(q>0) q=3
                    else q=-3
                }
                p = gaussian(q) // calc prob of rand draw
                if($half && q>0){
                    //continue;
                }
                el = {
                    "q": q,
                    "p": p
                }
                data.push(el)
            };

            // need to sort for plotting
            //https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort
            data.sort(function(x, y) {
                return x.q - y.q;
            });


        }

        // from http://bl.ocks.org/mbostock/4349187
        // Sample from a normal distribution with mean 0, stddev 1.
        function normal() {
            var x = 0,
                y = 0,
                rds, c;
            do {
                x = Math.random() * 2 - 1;
                y = Math.random() * 2 - 1;
                rds = x * x + y * y;
            } while (rds == 0 || rds > 1);
            c = Math.sqrt(-2 * Math.log(rds) / rds); // Box-Muller transform
            return x * c; // throw away extra sample y * c
        }

        //taken from Jason Davies science library
        // https://github.com/jasondavies/science.js/
        function gaussian(x) {
            var gaussianConstant = 1 / Math.sqrt(2 * Math.PI),
                mean = 0,
                sigma = 1;

            x = (x - mean) / sigma;
            return gaussianConstant * Math.exp(-.5 * x * x) / sigma;
        };
    },
    scoring_inventory: function () {
        var _this = this;
        var total_score = 0;
        var category_feedback = [];
        var category_feedbacks_arr = [];
        var category_feedbacks = '';
        //var category_feedback_message = 'Based on your responses, ';
        var category_feedback_message = this.category_feedback_message;
        var response_score_sd = '';
        var cases_revert = [];
        

        if(this.mode === 'Likert' || this.mode === 'T / F'){
            if(this.mode === "T / F"){
                if(this.data_tf == "0 | 1"){                        
                    cases_revert[0] = "True";
                    cases_revert[1] = "False";    
                }else if(this.data_tf ==  "1 | 2"){
                    cases_revert[1] = "True";
                    cases_revert[2] = "False";
                }else{                        
                    cases_revert[2] = "True";
                    cases_revert[1] = "False";
                }
                
            }else{
                /*
                cases_revert[1] = "Strongly Agree";
                cases_revert[2] = "Moderately Agree";
                cases_revert[3] = "Neither Agree nor Disagree";
                cases_revert[4] = "Moderately Disagree";
                cases_revert[5] = "Strongly Disagree";
                */

                cases_revert = this.getLikertScaleCases(this.scale);
                cases_revert.reverse();
                cases_revert = [null].concat(cases_revert);
            }
        }

        elWrapper = new Element('div.wrapper').inject(_this.SIWrapper);              
        if(this.standard_deviation == true || this.standard_deviation == 'true'){
            if(this.mode === 'Likert' || this.mode === 'T / F'){
                var _tf_data = _this.data_tf.split("|");
                _tf_data[0] = _tf_data[0] ? _tf_data[0].trim() : null;
                _tf_data[1] = _tf_data[1] ? _tf_data[1].trim() : null;
                var total_valid = 0;
                Array.each(this.options.data.questions, function (item, ind) {                                    
                    if(item != null)
                        total_valid = total_valid + parseInt(item.result);
                });
                $$('.results').addClass('inventory');


                $$(".summary-intro-line").destroy();

                if(this.show_summary_screen_intro){

                    if(this.isEditMode){

                        new Element('div.summary-intro-line', {
                            html: this.intro_line_summary,
                            contenteditable: true
                        }).inject($$(".widget-header")[0]);

                        var timer_input_intro_line_summary = null;
                        $$("div.summary-intro-line[contenteditable]").addEvent("input",function(e){
                            var _this_el = this;
                            if(timer_input_intro_line_summary!=null){
                                clearTimeout(timer_input_intro_line_summary);
                            }
                            timer_input_intro_line_summary = setTimeout(function(){
                                this;
                                this.sendPostMessages('async-widget-data-save',{
                                    data_target: "intro_line_summary",
                                    value_send: $(_this_el).get("text")
                                })
                            }.bind(_this),750)
                        });

                    } else {
                        if( this.intro_line_summary.replace(/(<([^>]+)>)/ig,"").trim() !=""){
                            new Element('div.summary-intro-line', {
                                html: this.intro_line_summary //
                            }).inject($$(".widget-header")[0]); 
                        }
                    }
                }
                // SCAM summary title
                new Element('div.scam-result-graph-title', {
                    html: 'SUMMARY'
                }).inject(elWrapper);
                 // SCAM graph header

                // Get Percentle
                // Arrg Values of ranges in the graph
                var arrg_range = [ -3, -2.5, -2, -1.5, -1, -0.5, 0, 0.5, 1, 1.5, 2, 2.5, 3 ]
                var arrg_settings = [
                    obj1 = {
                        range: '-3 | -2',
                        dispersion: 1.5,
                        total: 96,
                        part: 15.2
                    },
                    obj2 = {
                        range: '-2 | -1',
                        dispersion: 1.56,
                        total: 80.8,
                        part: 15.6
                    },
                    obj3 = {
                        range: '-1 | 0',
                        dispersion: 1.56,
                        total: 65.2,
                        part: 15.6
                    },
                    obj4 = {
                        range: '0 | 1',
                        dispersion: 1.51,
                        total: 49.7,
                        part: 15.1  
                    },
                    obj5 = {
                        range: '1 | 2',
                        dispersion: 1.56,
                        total: 34.6,
                        part: 15.6 
                    },
                    obj5 = {
                        range: '2 | 3',
                        dispersion: 1.56,
                        total:19,
                        part: 15.6 
                    }          

                ];                
                
                var desviacion_standar = parseFloat(((total_valid - this.standard_deviation_norm_mean) / this.standard_deviation_norm_sd).toFixed(2));
                var range = '';                
                var position = null;
                var porcentaje = 0;

                for (var i = 0; i <= arrg_range.length; i++) {                    
                    if(i>0){
                        if(desviacion_standar <= -3){
                            range = '';
                        }else if(desviacion_standar >= arrg_range[i-1] && desviacion_standar <= arrg_range[i+1]){
                            var dec = String(arrg_range[i-1]);                
                            var dec = dec.substr(dec.indexOf('.') + 1);
                            var dec = dec.substr(0, 1);
                            if(dec == 5){
                                range = arrg_range[i-2] + ' | ' + arrg_range[i];                                
                            }else{
                                range = arrg_range[i-1] + ' | ' + arrg_range[i+1];                                
                            }
                            
                        }else if(desviacion_standar >= 3){
                            range = arrg_range[arrg_range.length-1] + ' | null';
                        }
                    }                    
                }                
                if(range != ''){
                    for(var j =0; j <= arrg_settings.length-1; j++){                                                
                        if(arrg_settings[j].range == range){
                            position = j;
                        }
                    }
                }else{
                    position = null;
                }
                
                var decimal = String(desviacion_standar);                
                var decimal = decimal.substr(decimal.indexOf('.') + 1);
                var first_decimal = decimal.substr(0, 1);
                var below_above = 'above';
                                
                if(position != null){  
                    
                    if(first_decimal == 0){
                        if(desviacion_standar < 0){ 
                            below_above = 'below';
                            porcentaje = arrg_settings[position].total - arrg_settings[position].part;
                        }else{
                            below_above = 'above';          
                            porcentaje = arrg_settings[position].total;
                        }
                    }else{
                        if(desviacion_standar < 0){                             
                            below_above = 'below';
                            porcentaje = arrg_settings[position].total - (arrg_settings[position].part - (first_decimal*arrg_settings[position].dispersion));                                     
                        }else{                  
                            below_above = 'above';          
                            porcentaje = (arrg_settings[position].total - arrg_settings[position].part) + (arrg_settings[position].part - (first_decimal*arrg_settings[position].dispersion));                                     
                        }

                    }
                    
                }else if(desviacion_standar <= -2.8){
                    below_above = 'below';
                    porcentaje = 100; 
                }else if(desviacion_standar >= 2.8){
                    below_above = 'ABOVE';
                    porcentaje = 0;
                }

                //Percentile Table
                var arrg_percentiles = {                    
                    '0': {"percentile": 1, "min": -1000, "max": -2.32},
                    '1': {"percentile": 2, "min": -2.31, "max": -2.05},
                    '2': {"percentile": 3, "min": -2.04, "max": -1.88},
                    '3': {"percentile": 4, "min": -1.87, "max": -1.75},
                    '4': {"percentile": 5, "min": -1.74, "max": -1.64},
                    '5': {"percentile": 6, "min": -1.63, "max": -1.55},
                    '6': {"percentile": 7, "min": -1.54, "max": -1.47},
                    '7': {"percentile": 8, "min": -1.46, "max": -1.40},
                    '8': {"percentile": 9, "min": -1.39, "max": -1.34},
                    '9': {"percentile": 10, "min": -1.33, "max": -1.28},
                    '10': {"percentile": 11, "min": -1.27, "max": -1.22},
                    '11': {"percentile": 12, "min": -1.21, "max": -1.17},
                    '12': {"percentile": 13, "min": -1.16, "max": -1.12},
                    '13': {"percentile": 14, "min": -1.11, "max": -1.08},
                    '14': {"percentile": 15, "min": -1.07, "max": -1.03},
                    '15': {"percentile": 16, "min": -1.02, "max": -0.99},
                    '16': {"percentile": 17, "min": -0.98, "max": -0.95},
                    '17': {"percentile": 18, "min": -0.94, "max": -0.91},
                    '18': {"percentile": 19, "min": -0.90, "max": -0.87},
                    '19': {"percentile": 20, "min": -0.86, "max": -0.84},                    
                    '20': {"percentile": 21, "min": -0.83, "max": -0.80},
                    '21': {"percentile": 22, "min": -0.79, "max": -0.77},
                    '22': {"percentile": 23, "min": -0.76, "max": -0.73},
                    '23': {"percentile": 24, "min": -0.72, "max": -0.70},
                    '24': {"percentile": 25, "min": -0.69, "max": -0.67},
                    '25': {"percentile": 26, "min": -0.66, "max": -0.64},
                    '26': {"percentile": 27, "min": -0.63, "max": -0.61},
                    '27': {"percentile": 28, "min": -0.60, "max": -0.58},
                    '28': {"percentile": 29, "min": -0.57, "max": -0.55},
                    '29': {"percentile": 30, "min": -0.54, "max": -0.52},
                    '30': {"percentile": 31, "min": -0.51, "max": -0.49},
                    '31': {"percentile": 32, "min": -0.48, "max": -0.46},
                    '32': {"percentile": 33, "min": -0.45, "max": -0.44},
                    '33': {"percentile": 34, "min": -0.43, "max": -0.41},
                    '34': {"percentile": 35, "min": -0.40, "max": -0.38},
                    '35': {"percentile": 36, "min": -0.37, "max": -0.35},
                    '36': {"percentile": 37, "min": -0.34, "max": -0.33},
                    '37': {"percentile": 38, "min": -0.32, "max": -0.30},
                    '38': {"percentile": 39, "min": -0.29, "max": -0.27},
                    '39': {"percentile": 40, "min": -0.26, "max": -0.25},
                    '40': {"percentile": 41, "min": -0.24, "max": -0.22},
                    '41': {"percentile": 42, "min": -0.21, "max": -0.20},
                    '42': {"percentile": 43, "min": -0.19, "max": -0.17},
                    '43': {"percentile": 44, "min": -0.16, "max": -0.15},
                    '44': {"percentile": 45, "min": -0.14, "max": -0.12},
                    '45': {"percentile": 46, "min": -0.11, "max": -0.1},
                    '46': {"percentile": 47, "min": -0.09, "max": -0.07},
                    '47': {"percentile": 48, "min": -0.06, "max": -0.05},
                    '48': {"percentile": 49, "min": -0.04, "max": -0.02},
                    '49': {"percentile": 50, "min": -0.01, "max": 0},
                    '50': {"percentile": 51, "min": 0.01, "max": 0.02},
                    '51': {"percentile": 52, "min": 0.03, "max": 0.05},
                    '52': {"percentile": 53, "min": 0.06, "max": 0.07},
                    '53': {"percentile": 54, "min": 0.08, "max": 0.10},
                    '54': {"percentile": 55, "min": 0.11, "max": 0.12},
                    '55': {"percentile": 56, "min": 0.13, "max": 0.15},
                    '56': {"percentile": 57, "min": 0.16, "max": 0.17},
                    '57': {"percentile": 58, "min": 0.18, "max": 0.20},
                    '58': {"percentile": 59, "min": 0.21, "max": 0.22},
                    '59': {"percentile": 60, "min": 0.23, "max": 0.25},
                    '60': {"percentile": 61, "min": 0.26, "max": 0.27},
                    '61': {"percentile": 62, "min": 0.28, "max": 0.30},
                    '62': {"percentile": 63, "min": 0.31, "max": 0.33},
                    '63': {"percentile": 64, "min": 0.34, "max": 0.35},
                    '64': {"percentile": 65, "min": 0.36, "max": 0.38},
                    '65': {"percentile": 66, "min": 0.39, "max": 0.41},
                    '66': {"percentile": 67, "min": 0.42, "max": 0.44},
                    '67': {"percentile": 68, "min": 0.45, "max": 0.46},
                    '68': {"percentile": 69, "min": 0.47, "max": 0.49},
                    '69': {"percentile": 70, "min": 0.49, "max": 0.52},
                    '70': {"percentile": 71, "min": 0.53, "max": 0.55},
                    '71': {"percentile": 72, "min": 0.56, "max": 0.58},
                    '72': {"percentile": 73, "min": 0.59, "max": 0.61},
                    '73': {"percentile": 74, "min": 0.62, "max": 0.64},
                    '74': {"percentile": 75, "min": 0.65, "max": 0.67},
                    '75': {"percentile": 76, "min": 0.68, "max": 0.70},
                    '76': {"percentile": 77, "min": 0.71, "max": 0.73},
                    '77': {"percentile": 78, "min": 0.74, "max": 0.77},
                    '78': {"percentile": 79, "min": 0.78, "max": 0.80},
                    '79': {"percentile": 80, "min": 0.81, "max": 0.84},
                    '80': {"percentile": 81, "min": 0.85, "max": 0.87},
                    '81': {"percentile": 82, "min": 0.88, "max": 0.91},
                    '82': {"percentile": 83, "min": 0.92, "max": 0.95},
                    '83': {"percentile": 84, "min": 0.96, "max": 0.99},
                    '84': {"percentile": 85, "min": 1.00, "max": 1.03},
                    '85': {"percentile": 86, "min": 1.04, "max": 1.08},
                    '86': {"percentile": 87, "min": 1.09, "max": 1.12},
                    '87': {"percentile": 88, "min": 1.13, "max": 1.17},
                    '88': {"percentile": 89, "min": 1.18, "max": 1.22},
                    '89': {"percentile": 90, "min": 1.23, "max": 1.28},
                    '90': {"percentile": 91, "min": 1.29, "max": 1.34},
                    '91': {"percentile": 92, "min": 1.35, "max": 1.40},
                    '92': {"percentile": 93, "min": 1.41, "max": 1.47},
                    '93': {"percentile": 94, "min": 1.48, "max": 1.55},
                    '94': {"percentile": 95, "min": 1.56, "max": 1.64},
                    '95': {"percentile": 96, "min": 1.65, "max": 1.75},
                    '96': {"percentile": 97, "min": 1.76, "max": 1.88},
                    '97': {"percentile": 98, "min": 1.89, "max": 2.05},
                    '98': {"percentile": 99, "min": 2.06, "max": 1000},                    
                };                                
                var percentile = "";
                for(var i in arrg_percentiles){                    
                    if(desviacion_standar >= arrg_percentiles[i].min && desviacion_standar <= arrg_percentiles[i].max){
                        percentile = arrg_percentiles[i].percentile;
                    }
                }
                var thstnd = '';            
                if(percentile.toString().length == 1){
                    // If have only digit
                    if(percentile == 1){
                        thstnd = "st";
                    }else if(percentile == 2){
                        thstnd = 'nd';
                    }else if(percentile == 3){
                        thstnd = 'rd';
                    }else{
                        thstnd = 'th';
                    }
                }else{
                    if(percentile == 11 || percentile == 12 || percentile == 13){
                        thstnd = 'th';
                    }else{                        
                        var lastDigit = parseInt( percentile.toString().substring(percentile.toString().length - 1, percentile.toString().length));
                        if(lastDigit == 1){
                            thstnd = 'st';
                        }else if( lastDigit == 2){
                            thstnd = 'nd';
                        }else if( lastDigit == 3){
                            thstnd = 'rd';
                        }else{
                            thstnd = 'th';
                        }
                    }
                }

                if(this.standard_deviation_average_score){
                    response_score_sd = 'Based on your responses, your score is <b> '+total_valid+'</b> compared to an average score of <b>'+this.standard_deviation_average_score+'. </b><br/> Your score is <b>'+desviacion_standar+'</b> standard deviations <b>'+ below_above +'</b> the mean, which is the <b>'+ percentile + thstnd +' </b> percentile.';
                }else{
                    response_score_sd = 'Based on your responses, your score is <b> '+total_valid+'</b>.<br/> Your score is  <b>'+desviacion_standar+'</b> standard deviations <b>'+ below_above +'</b> the mean, which is the <b>'+ percentile + thstnd + ' </b> percentile.';
                }


                new Element('div.scam-result-graph-header', {
                    html: response_score_sd
                }).inject(elWrapper);

                

                if(this.customize_standard_deviation_graph){
                    var _graph_wrapper = new Element('div.scam-result-graph-wrapper', {
                    });
                    _graph_wrapper.inject(elWrapper);
                    // SCAM graph
                    new Element('div.scam-result-graph', {
                        html: ''
                    }).inject(_graph_wrapper);

                    new Element('div.scam-result-graph-2', {
                        html: ''
                    }).inject(_graph_wrapper);
                                    
                    new Element('div.scam-result-graph-hide', {
                        style: 'width:calc('+porcentaje.toFixed(1)+'%)'
                    }).inject(_graph_wrapper);

                    this.draw_bell_curve(".scam-result-graph",false);
                    this.draw_bell_curve(".scam-result-graph-2",true);
                }

                if(this.customize_scoring_sumarry){
                    new Element('br').inject(elWrapper);
                    
                    new Element('p.sumarry-score-text', {
                        html: this.customize_scoring_sumarry_text
                    }).inject(elWrapper);

                    new Element('br').inject(elWrapper);
                }

                // SCAM questions resume
                var questions_resume = new Element('div.scam-questions-resume', {
                });
                questions_resume.inject(elWrapper);


                if(this.customize_question_response){
                    Array.each(this.options.data.questions, function (item, ind) {
                        // SCAM questions resume item   

                        if (item==null) return;
                        var answered = '';

                        if(_this.mode !== 'Open'){
                            if(item.reverse == "true"){
                                answered = cases_revert[item.result];
                            }else{
                                answered = _this.cases[item.result];
                            }

                        } else{
                            answered = _this.getOpenSelectedOption(item, ind);
                        }

                        if(answered==null){
                            answered = '';
                        }
                                            
                        if(item.feedback != undefined && item.feedback != null){
                            var feedback = item.feedback;
                        }else{
                            var feedback = "";
                        }

                        var question_title = _this.getQuestionTitle(item);
                        
                        new Element('div.scam-questions-resume-item', {
                            html: '<p><strong>Question '+(ind+1)+':</strong> '+ question_title + '</p>' +
                                  '<p><strong>You answered:</strong> '+ answered + '</p>' +
                                  (_this.feedback_result=='true' && feedback.trim()!='' ?'<p><strong>Feedback:</strong> '+ feedback +  '</p>':'')
                        }).inject(questions_resume);
                    });
                }


            }else{
                var _tf_data = _this.data_tf.split("|");
                
                _tf_data[0] = _tf_data[0] ? _tf_data[0].trim() : null;
                _tf_data[1] = _tf_data[1] ? _tf_data[1].trim() : null;

                var total_valid = 0;

                Array.each(this.options.data.questions, function (item, ind) {

                    if (item==null) return;

                    if(item.reverse=="true"){
                        if(item.result==_tf_data[1]){
                            total_valid++;
                        }
                    } else {
                        if(item.result==_tf_data[1]){
                            total_valid++;
                        }
                    }
                });            
                $$('.results').addClass('inventory');

                // SCAM summary title
                new Element('div.scam-result-graph-title', {
                    html: 'SUMMARY'
                }).inject(elWrapper);

                // SCAM graph header
                new Element('div.scam-result-graph-header', {
                    html: '<strong>Based on your responses, you got '+total_valid+' out of '+this.options.data.questions.length+'.<br/>You are in the '+Math.ceil(total_valid*100/this.options.data.questions.length)+'th percentile of all middle school students</strong>'
                }).inject(elWrapper);

                var _graph_wrapper = new Element('div.scam-result-graph-wrapper', {
                });
                _graph_wrapper.inject(elWrapper);

                // SCAM graph
                new Element('div.scam-result-graph', {
                    html: ''
                }).inject(_graph_wrapper);

                new Element('div.scam-result-graph-2', {
                    html: ''
                }).inject(_graph_wrapper);

                new Element('div.scam-result-graph-hide', {
                    style: 'width:calc(100% - '+(Math.ceil(total_valid*100/this.options.data.questions.length))+'%)'
                }).inject(_graph_wrapper);

                this.draw_bell_curve(".scam-result-graph",false);
                this.draw_bell_curve(".scam-result-graph-2",true);

                // SCAM questions resume
                var questions_resume = new Element('div.scam-questions-resume', {
                });
                questions_resume.inject(elWrapper);

                Array.each(this.options.data.questions, function (item, ind) {
                    // SCAM questions resume item
                    if (item==null) return;
                    var answered = "True";
                    if(_this.mode !== 'Open'){
                        if(item.reverse=="true"){
                            if(item.result==_tf_data[1]){
                                answered = "False";
                            } else {
                                answered = "True";
                            }
                        } else {
                            if(item.result==_tf_data[1]){
                                answered = "True";
                            } else {
                                answered = "False";
                            }
                        }
                    } else{
                        answered = _this.getOpenSelectedOption(item, ind);
                    }

                    var question_title = _this.getQuestionTitle(item);
                    
                    new Element('div.scam-questions-resume-item', {
                        html: '<p><strong>Question '+(ind+1)+':</strong> '+ question_title + '</p>' +
                              '<p><strong>You answered:</strong> '+ answered + '</p>' +
                              (_this.feedback_result=='true' && item.feedback.trim()!=''?'<p><strong>Feedback:</strong> '+ item.feedback +  '</p>':'')
                    }).inject(questions_resume);
                });
            }
            

        } else {
            Array.each(this.options.data.questions, function (item) {                
                if (item!=null) 
                    total_score += parseInt(item.result);
            });

            // feedback message
            var category_feedback_message_generated_text = "";
            var prefix_category_summary = _this.prefix_category_summary;
            this.options.data.categories.forEach(function (category, i) {
                var min = parseInt(category.min);
                var max = parseInt(category.max);

                var feedback_to_use = category.feedback;
                if(feedback_to_use==null || feedback_to_use==""){
                    feedback_to_use = '<i style="opacity:0.5;"><strong>[ Feedback for '+ min + ' - ' + max + ' is empty]</strong></i>';
                }
                //category_feedback_message_generated_text += feedback_to_use;
                var prefix_category_summary_wrapper = prefix_category_summary;
                if(_this.isEditMode){
                    prefix_category_summary_wrapper = '<span class="prefix_category_summary" contenteditable="true">'+prefix_category_summary+'</span>';
                }
                var category_feedbacks_generated = '<p><b>'+prefix_category_summary_wrapper+' '+ min + ' - ' + max + ':</b> ' + feedback_to_use+ '</p>' + '\n';

                category_feedbacks_arr.push(category_feedbacks_generated);
                
                console.table([{total_score:total_score, max:max, min:min}]);
                if (total_score <= max && total_score >= min) {
                    category_feedback_message_generated_text += feedback_to_use;
                    category_feedbacks = category_feedbacks_generated;
                }
                /*
                if (total_score <= max && total_score >= min) {
                    var feedback_to_use = category.feedback;
                    if(feedback_to_use==null || feedback_to_use==""){
                        feedback_to_use = '<i style="opacity:0.5;"><strong>[ Feedback for '+ min + ' - ' + max + ' is empty]</strong></i>';
                    }
                    category_feedback_message_generated_text += feedback_to_use;
                    var prefix_category_summary_wrapper = prefix_category_summary;
                    if(_this.isEditMode){
                        prefix_category_summary_wrapper = '<span class="prefix_category_summary" contenteditable="true">'+prefix_category_summary+'</span>';
                    }
                    category_feedbacks = '<p><b>'+prefix_category_summary_wrapper+' '+ min + ' - ' + max + ':</b> ' + feedback_to_use+ '</p>' + '\n';
                }
                */

            });

            
            
            $$('.results').addClass('inventory');

            $$(".summary-intro-line").destroy();

            if(this.show_summary_screen_intro){

                if(this.isEditMode){

                    new Element('div.summary-intro-line', {
                        html: this.intro_line_summary,
                        contenteditable: true
                    }).inject($$(".widget-header")[0]); 

                    var timer_input_intro_line_summary = null;
                    $$("div.summary-intro-line[contenteditable]").addEvent("input",function(e){
                        var _this_el = this;
                        if(timer_input_intro_line_summary!=null){
                            clearTimeout(timer_input_intro_line_summary);
                        }
                        timer_input_intro_line_summary = setTimeout(function(){
                            this;
                            this.sendPostMessages('async-widget-data-save',{
                                data_target: "intro_line_summary",
                                value_send: $(_this_el).get("text")
                            })
                        }.bind(_this),750)
                    });

                } else {
                    if( this.intro_line_summary.replace(/(<([^>]+)>)/ig,"").trim() !=""){
                        new Element('div.summary-intro-line', {
                            html: this.intro_line_summary//
                        }).inject($$(".widget-header")[0]); 
                    }
                }
            }
            
            if(this.customize_statement){

                if(this.isEditMode){
                    category_feedback_message = '<div contenteditable="true" style="display:inline;"><p>'+category_feedback_message+'</p></div> ';
                    if(this.categorized_responses)
                        category_feedback_message+= category_feedback_message_generated_text;
                    new Element('div.feedback-message', {
                        html: category_feedback_message//
                    }).inject(elWrapper); 

                    var timer_input_category_feedback_message = null;
                    $$("div.feedback-message *[contenteditable]").addEvent("input",function(e){
                        var _this_el = this;
                        if(timer_input_category_feedback_message!=null){
                            clearTimeout(timer_input_category_feedback_message);
                        }
                        timer_input_category_feedback_message = setTimeout(function(){
                            this;
                            this.sendPostMessages('async-widget-data-save',{
                                data_target: "category_feedback_message",
                                value_send: $(_this_el).get("text")
                            })
                        }.bind(_this),750)
                    });

                } else {


                    if(this.categorized_responses)
                        category_feedback_message+=' ' + category_feedback_message_generated_text;

                    if(category_feedback_message.trim()!="")
                        new Element('div.feedback-message', {
                            html: '<p>' + category_feedback_message + '</p>'//
                        }).inject(elWrapper);   
                }

                
            }
            
            
            if(this.customize_score){
                // SCAM score header
                if(this.isEditMode){
                    new Element('div.scam-header', {
                        html: this.summary_your_score_text,
                        contenteditable: true
                    }).inject(elWrapper);
                    var timer_input_your_score = null;
                    
                    $$("div.scam-header").addEvent("input",function(e){
                        var _this_el = this;
                        if(timer_input_your_score!=null){
                            clearTimeout(timer_input_your_score);
                        }
                        timer_input_your_score = setTimeout(function(){
                            this;
                            this.sendPostMessages('async-widget-data-save',{
                                data_target: "summary_your_score_text",
                                value_send: $(_this_el).get("text")
                            })
                        }.bind(_this),750)
                    })

                } else if( this.summary_your_score_text.replace(/(<([^>]+)>)/ig,"").trim() != ""){
                    new Element('div.scam-header', {
                        html: '<p><strong>' + this.summary_your_score_text + '</strong></p>'
                    }).inject(elWrapper);    
                }

                // SCAM score
                new Element('div.total-score', {
                    html: '<p><strong>' + total_score + '</strong></p>'
                }).inject(elWrapper);
            }

            

            if (_this.customize_scoring_breakdown){
                
                new Element('div.feedbacks', {
                    html: category_feedbacks_arr
                }).inject(elWrapper);

                if(_this.isEditMode){
                    var timer_input_prefix_category_summary = null;
                    $$(".prefix_category_summary[contenteditable]").addEvent("input",function(e){
                        var _this_el = this;
                        if(timer_input_prefix_category_summary!=null){
                            clearTimeout(timer_input_prefix_category_summary);
                        }
                        timer_input_prefix_category_summary = setTimeout(function(){
                            this;
                            this.sendPostMessages('async-widget-data-save',{
                                data_target: "prefix_category_summary",
                                value_send: $(_this_el).get("text")
                            })
                        }.bind(_this),750)
                    });
                }
            }
            
            if(this.customize_scoring_sumarry && this.customize_scoring_sumarry_text!=''){
                new Element('br').inject(elWrapper);
                new Element('br').inject(elWrapper);
                new Element('p.sumarry-score-text', {
                    html: this.customize_scoring_sumarry_text
                }).inject(elWrapper);
            }

            // SCAM questions resume
            var questions_resume = new Element('div.scam-questions-resume', {
            });
            questions_resume.inject(elWrapper);


            if(this.customize_question_response){
                Array.each(this.options.data.questions, function (item, ind) {
                    // SCAM questions resume item   
                    if (item==null) return;
                    var answered = ''
                    if(_this.mode !== 'Open'){
                        if(item.reverse == "true"){
                            var answered = cases_revert[item.result];
                        }else{
                            var answered = _this.cases[item.result];
                        }
                    } else{
                        answered = _this.getOpenSelectedOption(item, ind);
                    }

                    if(answered==null){
                        answered = '';
                    }
                    
                    if(item.feedback != undefined && item.feedback != null){
                        var feedback = item.feedback;
                    }else{
                        var feedback = "";
                    }

                    var question_title = _this.getQuestionTitle(item);
                    
                    new Element('div.scam-questions-resume-item.inventory-non-graph-mode', {
                        html: '<p><strong>Question '+(ind+1)+':</strong> '+ question_title + '</p>' +
                              '<p><strong>You answered:</strong> '+ answered + '</p>' +
                              (_this.feedback_result=='true' && feedback.trim()!=''?'<p><strong>Feedback:</strong> '+ feedback +  '</p>':'')
                    }).inject(questions_resume);
                });
            }


        }


    },

    getOpenSelectedOption: function(item, ind){
        
        var answer = '';
        if(item.answers!=null && item.answers.length>0){
            item.answers.forEach(function(answer_item){
                if(answer_item.value == item.result){
                    answer = answer_item.answer;
                    return false;
                }
            });
        }
        return answer;
    },
    getQuestionTitle: function(item){
        var _this = this;
        var question_title = item!=null?item.question:null;
        if(question_title=='' || question_title==undefined || question_title==null){
            question_title = '';
            if(_this.isEditMode || true){
                question_title = '<span class="question-is-empty"><i><strong>[ Question is empty ]</strong></i></span>';
            }
        }

        return question_title;
    },

    initAccessibility: function () {
        _this = this;

        $$('.questions .list')[0].set('role','presentation');
        $$('.alert').set('aria-live','assertive');

        if (document.querySelectorAll('ul.list > li').length !== 0) {
            if (document.querySelector('ul.list > li.show input') !== null) {
                //document.querySelector('ul.list > li.show input').focus();
            }
            Array.prototype.slice.call(document.querySelectorAll('ul.list > li')).forEach(function (li) {
                Array.prototype.slice.call(li.querySelectorAll('input:not([type="radio"])')).forEach(function (el) {
                    el.setAttribute('tabindex', 0);
                });
            });
            Array.prototype.slice.call(document.querySelectorAll('.widget-footer  button')).forEach(function (button) {
                button.setAttribute('tabindex', 0);
                button.addEventListener('click', function (e) {
                    e.target.blur();
                    if (document.querySelector('ul.list > li.show input') !== null) {
                        document.querySelector('ul.list > li.show input').focus();
                    } else {
                        Array.prototype.slice.call(document.querySelectorAll('button')).forEach(function (button) {
                            if (button.style.display === 'block') {
                                // button.focus();
                            }
                        });
                    }
                });
            });

            $$('.item label').addEvent('keyup', function(e){
                if(e.code == 32 || e.key == 'space' || e.code == 13 || e.key == 'enter'){
                    e.target.getPrevious().click();
                }
            });
        }

        
    },
    addAccessibility: function(){
        if( $$('.widget-header .alert').length > 0 ){
            $$('.widget-header .alert').set('role', 'alert');
        }

        if( $$('.widget-footer').length > 0 ){
            //new Element('div.buttons').wraps('.widget-footer > button');
            var _t = '<div class="buttons">'+
                    '<button id="restart">Repeat Survey</button>'+
                    '<button id="previous" disabled>Previous</button>'+
                    '<button id="next">Next</button>'+
                    '<button id="check">Next</button>'+
                '</div>';
            $$('.widget-footer').set('html', _t);
        }


    },
    // respond to received messages
    customPostMessages: function (message) {
        
        switch (message.data.method) {
            case "hide-intro-screen":
                $$('.item').show();
                $$('.intro').hide();
                break;
            case 'show-intro-screen':
                $$('.item').hide();
                $$('.intro').show();
                break;
            case 'refresh-intro-screen':
                this.refreshIntroScreen(message.data.html);
                break;
            case 'async-data-updated':
                this.options.data = message.data.data;
                this.setUPSettings(message.data);
                
                
            case 'steped-datapanel-change':
                $$(".summary-intro-line").destroy();
                switch(message.data.step){
                    case 0:
                        
                        $$(".questions").setProperty("style", "overflow-y: auto; display: block;");
                        $$(".results").setProperty("style", "overflow-y: auto; display: none !important");
                        $$(".item").hide();
                        $$(".item.intro").show();
                        if($('intro-line'))$('intro-line').hide();
                        $('MetrodigiWidget').removeClass('summary-active');
                        $('MetrodigiWidget').addClass('item-intro');
                        break;
                    case 1:
                        
                        $$(".questions").setProperty("style", "overflow-y: auto; display: block;");
                        $$(".results").setProperty("style", "overflow-y: auto; display: none !important");
                        $$(".item").show();
                        $$(".item.intro").hide();
                        if($('intro-line'))$('intro-line').show();
                        $('MetrodigiWidget').removeClass('summary-active');
                        $('MetrodigiWidget').removeClass('item-intro');
                        break;
                    case 2:
                        
                        $$(".questions").setProperty("style", "overflow-y: auto; display: none;");
                        if(this.scoring!="")
                            $$(".results").setProperty("style", "overflow-y: auto; display: table !important");
                        else
                            $$(".results").setProperty("style", "overflow-y: auto; display: block !important");
                        this.checkResults();
                        if($('intro-line'))$('intro-line').hide();
                        $('MetrodigiWidget').addClass('summary-active');
                        $('MetrodigiWidget').removeClass('item-intro');
                        break;
                }
                break;
        }


    },
    refreshIntroScreen: function (html) {
        if (typeof $$('.intro')[0] !== 'undefined') {
            $$('.intro').set('html', html);
        } else {
            var wrapper = $$('.questions .list')[0];
            new Element('<li>', {
                html: html,
                class: 'intro'
            }).inject(wrapper);
            $$('.item').hide();
            $$('.intro').show();
        }

    },
    // render - updates the widget display
    render: function () {
        this.parent();
    },
});

function isTouchDevice(){
    try{
        document.createEvent("TouchEvent");
        return true;
    }catch(e){
        return false;
    }
}
function allElementsFromPoint(x, y, cb) {
    var element, elements = [];
    var old_visibility = [];
    while (true) {
        element = document.elementFromPoint(x, y);
        if (!element || element === document.documentElement) {
            break;
        }
        elements.push(element);
        old_visibility.push(element.style.visibility);
        element.style.visibility = 'hidden'; // Temporarily hide the element (without changing the layout)
    }
    for (var k = 0; k < elements.length; k++) {
        elements[k].style.visibility = old_visibility[k];
    }
    elements.reverse();
    return cb(elements);
}

function touchScroll(id, element){
    if(isTouchDevice()){ //if touch events exist...
        var el;
        if(!id){
            el = element;
        } else {
            el=document.getElementById(id);
        }

        var scrollStartPos=0;
        var scale =  window._current_scale || 1
        document.addEventListener("touchstart", function(e) {
            // console.log(e.target.tagName )
            // if(e.target.tagName == 'HTML') e.preventDefault();
        },false);
        el.addEventListener("touchstart", function(event) {
            //
            // setTimeout(function(){this.scrollTop = 80;},0)
            // e.stopPropagation();
            // allElementsFromPoint(event.touches[0].pageX, event.touches[0].pageY, function(elems){
            //     var flag = false;
            //     elems.map(function(elem){
            //         var tag = elem.tagName;
            //         if(tag == 'FIELDSET' || tag == 'INPUT' || tag == 'LABEL' || tag =='INPUT'){
            //           flag = true;
            //         }
            //     })
            //     console.log('elems',elems)
            //     console.log('flag', flag)
            //     if(!flag) event.stopPropagation()
            // })
            // var that = this
            // setTimeout(function(){
            //     that.scrollTop = document.lastScrollTop;
            //
            //       console.log('start', that.scrollTop)
            var that = this;

            setTimeout(function(){
                that.scrollTop = document.lastScrollTop;
            }, 0)

        }, false);

        el.addEventListener("touchend", function(event) {
            var that = this
            event.stopImmediatePropagation()
            that.scrollTop = document.lastScrollTop;
        }, false);

        el.addEventListener("touchmove", function(event) {
            var that = this
            document.lastScrollTop = that.scrollTop;
        }, false);

        // el.addEventListener('touchmove',function(e){
        //     e.preventDefault();
        // });
        // el.addEventListener("touchmove", function(event) {
        //     document.prevScrollTop = this.scrollTop
        //     // this.scrollTop=scrollStartPos-event.touches[0].pageY*0.48;
        //     // event.preventDefault();
        // },false);
    }
}


