/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
*/

var QuizApp = new Class({
	initialize: function(el){
		this.el = $(el);
		
		/* get data from HTML */
		var statements = this.el.getElements('.cell.data');
		var myData = [];
		for(i=0; i< statements.length ;i++){
			myData.push({"answer":"q"+ i+1, "question":" "+ statements[i].innerHTML});
		}
		
		/* add data to DragDrop*/
		this.quiz = new md.dragdrop.StepByStepQuiz(el.getElement('#quizarea'), myData,
			{ score: true, shuffleQuestions: true}
		);
		

		var startQuizEl = this.el.getElements(".startquiz");
		var resetEl = this.el.getElements(".reset");
		var endEl = this.el.getElements(".endquiz");
		var closeEl = this.el.getElements(".close");
		var alertEl = this.el.getElements(".alert");

		endEl.hide();
		resetEl.hide();
		closeEl.hide();
		endEl.addEvent("click", function(e){
			this.reset(e, true);
		}.bind(this));
		startQuizEl.addEvent("click", function(e){
			e.target.hide();
			this.startQuiz();
		}.bind(this));
		resetEl.addEvent("click", function(e){
			this.reset(e, false);
		}.bind(this));
		closeEl.addEvent("click", function(e){
			this.reset(e, true);
		}.bind(this));

		this.firstTimeCorrectCount =  0;

		var incorrectFlag = false;
		this.quiz.addEvent("answerCorrect", function(data){
	        clearTimeout(self.feedbackTimer);
			data.droppable.setStyle('border-color','#ffffff');
			if(!incorrectFlag) {
				this.firstTimeCorrectCount++;
			}
			incorrectFlag = false;
			alertEl.setStyle("opacity", "1");
			alertEl.removeClass("correct");
			alertEl.removeClass("incorrect");
			alertEl.addClass("correct");
			alertEl.set('html', 'Correct!');
			if(data.correctAnswers == this.quiz.questions.length) {
				resetEl.show();
				closeEl.show();
				this.el.getElements(".title").set('text', 'Quiz complete! You got ' + this.firstTimeCorrectCount + ' of '
					+ this.quiz.questions.length + ' correct on the first try.');
			}
			self.feedbackTimer = setTimeout(function() {
	            alertEl.morph({opacity: 0}, 300);
	            alertEl.removeClass('correct').removeClass('incorrect');
	        }, 1200);
		}.bind(this));
		this.quiz.addEvent("answerIncorrect", function(){
	        clearTimeout(self.feedbackTimer);
			alertEl.setStyle("opacity", "1");
			alertEl.removeClass("correct");
			alertEl.removeClass("incorrect");
			alertEl.addClass("incorrect");
			alertEl.set('html', 'Incorrect. Try again!');
			incorrectFlag = true;
			self.feedbackTimer = setTimeout(function() {
	            alertEl.morph({opacity: 0}, 300);
	            alertEl.removeClass('correct').removeClass('incorrect');
	        }, 1200);
		});

		this.resetTitle();
	},
	startQuiz: function(){

		this.el.getElement("#quizinfo").hide();
		this.el.getElement("#quizarea").show();
		this.el.getElements(".startquiz").hide();
		this.el.getElements(".endquiz").show();
		this.actionTitle();
	},
	reset: function(e, toOriginal){
		this.firstTimeCorrectCount = 0;
		this.quiz.reset(e);
		this.el.getElements(".alert").set('text', "");
		this.el.getElements(".alert").morph({opacity: 0}, 0);
		this.actionTitle();
		if(toOriginal) {
			this.resetTitle();
			this.el.getElement("#quizinfo").show();
			this.el.getElement("#quizarea").hide();
			this.el.getElements(".reset").hide();
			this.el.getElements(".close").hide();
			this.el.getElements(".endquiz").hide();
			this.el.getElements(".startquiz").show();
		}
	},
	resetTitle: function(){
		this.el.getElements(".title").set('text','Study the table, then click Start Quiz when you’re ready.');
	},
	actionTitle: function(){
		this.el.getElements(".title").set('text','Drag the item below to the correct position in the table.');
	}
});