/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
 */
var md = md || {};
    md.dragdrop = md.dragdrop || {};

var QuizApp = new Class({
    Implements: [Options, Events],
    options: {
        action_text: 'Drag the item below to the correct position in the table.',
        reset_text:'Study the table. When you\'re ready, <span class="responsive-call-to-action">click</span> the "Check Your Understanding" button below.',
        next_widget:false,
        previus_widget:false,
        end_quiz_message:false
    },
    initialize: function(el, options) {
        
        this.setOptions(options);
        this.el = $(el);
        
        /***
         * Get data from HTML:
         * 1) Aggregate all elements with '.cell' class into this.statements object
         * 2) Iterate over this.statements object
         * 3) Push objects onto myData array objects are:
         *      { "answer": q1, "question": [[current innerHTML]]
         ***/
        this.statements = this.el.getElements('.cell'); // was previously "('.cell.data');"
        var myData = [];
        for (i = 0; i < this.statements.length; i++) {
            myData.push({"answer": "q" + i + 1, "question": " " + this.statements[i].innerHTML});
        }

        /* add data to DragDrop*/
        this.quiz = new md.dragdrop.StepByStepQuiz(el.getElement('#quizarea'), myData,
                {score: true, shuffleQuestions: true}
        );


        var startQuizEl = this.el.getElements(".check_your_understanding");
        var resetEl = this.el.getElements(".reset");
        var endEl = this.el.getElements(".start_over");
        var closeEl = this.el.getElements(".close");
        var alertEl = this.el.getElements(".alert");

        var nextEl = this.el.getElements(".next");
        var backEl = this.el.getElements(".back");

        endEl.hide();
        resetEl.hide();
        closeEl.hide();
        endEl.addEvent("click", function(e) {
            this.reset(e, true);
        }.bind(this));
        if(nextEl)
        {
            nextEl.hide();
            nextEl.addEvent("click", function(e) {
                this.reset(e, true);
                this.el.hide();
                if(this.options.next_widget)
                {
                    $(this.options.next_widget).show();
                }
            }.bind(this));  
        }
        if(backEl)
        {
            backEl.addEvent("click", function(e) {
                this.reset(e, true);
                this.el.hide();
                if(this.options.previus_widget)
                {
                   $(this.options.previus_widget).show(); 
                }
            }.bind(this));  
        }
        
        startQuizEl.addEvent("click", function(e) {
            console.log("clicked, in QuizApp.js ~~ L75");
            e.target.hide();
            this.startQuiz();
        }.bind(this));
        resetEl.addEvent("click", function(e) {
            this.reset(e, false);
            this.startQuiz();

        }.bind(this));
        closeEl.addEvent("click", function(e) {
            this.reset(e, true);
        }.bind(this));

        this.firstTimeCorrectCount = 0;

        var incorrectFlag = false;
        this.quiz.addEvent("answerCorrect", function(data) {
            clearTimeout(self.feedbackTimer);
            data.droppable.setStyle('border-color', '#ffffff');

            for (i = 0; i < this.statements.length; i++) {

                if (typeof (data.droppable.children[i]) != "undefined") {
                    data.droppable.innerHTML = data.droppable.children[i].innerHTML;
                }

            }


            if (!incorrectFlag) {
                this.firstTimeCorrectCount++;
            }
            incorrectFlag = false;
            alertEl.setStyle("opacity", "1");
            alertEl.removeClass("correct");
            alertEl.removeClass("incorrect");
            alertEl.addClass("correct");
            alertEl.set('html', 'Correct!');
            if (data.correctAnswers == this.quiz.questions.length) {
                //resetEl.show();
                closeEl.show();

                // Show score
                var score = new Score(this.quiz.questions.length, this.firstTimeCorrectCount);
                if(this.options.end_quiz_message){
                     this.el.getElements(".title").set('text', this.options.end_quiz_message).removeProperty("aria-label");
                }else{
                    this.el.getElements(".title").set('text', score.getMessage()).removeProperty("aria-label");
                }
                
                if((options==null || options.endChallengeFocusEl==null ) && this.el.getElement(".reset")!=null )
                   this.el.getElement(".reset").focus();
                if(options!=null && options.endChallengeFocusEl!=null){
                  options.endChallengeFocusEl.focus();
                }

                this.quiz.fireEvent("quizEnd");
                if(this.el.getElements(".next"))
                {
                    this.el.getElements(".next").show();  
                }

            }
            self.feedbackTimer = setTimeout(function() {
                alertEl.morph({opacity: 0}, 300);
                alertEl.removeClass('correct').removeClass('incorrect');
            }, 1200);
        }.bind(this));
        this.quiz.addEvent("answerIncorrect", function() {
            clearTimeout(self.feedbackTimer);
            alertEl.setStyle("opacity", "1");
            alertEl.removeClass("correct");
            alertEl.removeClass("incorrect");
            alertEl.addClass("incorrect");
            alertEl.set('html', 'Incorrect. Try again!');
            incorrectFlag = true;
            self.feedbackTimer = setTimeout(function() {
                alertEl.morph({opacity: 0}, 300);
                alertEl.removeClass('correct').removeClass('incorrect');
            }, 1200);
        });

        this.resetTitle();

        this.initAccessibility();
        this.el.getElement(".accessibility-icon").hide();
//        this.el.getElement('.notes .note').set("tabindex", "1");
        this.el.getElement('.notes').set("tabindex", "1");
        this.el.getElement('.alert').set("aria-live", "assertive");

        this.el.getElements(".left-content .title-row table tr td, .right-content .title-cell tr td")
            .each(function(el){
                el.set("scope", "col");
            });
        this.el.getElements(".left-content .data table tr td")
            .each(function(el){
                el.set("scope", "row");
            });
    },
    initAccessibility: function() {
        var _this = this;

        _this.accessibility_button = new Element('div.accessibility-icon.inactive', {
            'tabindex': '1',
            'aria-label': 'Select here to start accessible mode.'
        }).inject(_this.el.getElement('.notes'));
        
        this.accessibility_button.addEvents({
            'click': function() {

                if (_this.el.hasClass('accessibility-off')) {
                    _this.accessibility_button.set({
                        'tabindex': '1',
                        'aria-label': 'The accessible mode has started. Select again to stop accessible mode.'
                    });
                    _this.el.getElements(".title")[0].set({
                        'text': _this.el.getElements(".accessibility-caption")[0].get('text'),
                        'aria-label': _this.el.getElements(".accessibility-caption")[0].get('text') +
                        ' ' + _this.el.getElements(".accessibility-information")[0].get('text'),
                        'aria-live': 'assertive'
                    });

                    var acc_mes = new Element('div.accessibility-message').inject(_this.el.getElements('.alert')[0], 'after');

                    _this.el.removeClass('accessibility-off').addClass('accessibility-on');
                    _this.startAccessibilityMode();

                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
                    if (drag !== undefined) {
                        acc_mes.set('text', drag.getElements('td')[0].get('text'));
                    } else {
                        _this.removeAccessibilityActions();
                    }
                } else {
                    _this.accessibility_button.set({
                        'tabindex': '1',
                        'aria-label': 'The accessible mode has stoped. Select again to start accessible mode.'
                    });
                    _this.stoptAccessibilityMode();

                }

            },
            'keypress': function(e) {
                if (e.code === 13 || e.code === 32)
                    e.target.fireEvent("click");
            }
        });
        _this.el.getElements('.notes')[0].focus();
    },
    startAccessibilityMode: function() {
        var _this = this;

        var acc_mes = this.el.getElements(".accessibility-message")[0];
        var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
        acc_mes.set({
            'text': drag.getElements('td')[0].get('text'),
            'aria-label': 'Current option, ' + drag.getElements('td')[0].get('text'),
            'aria-live': 'assertive',
            'tabindex': 1
        });

        this.el.getElements('.clickable').each(function(obj, i) {
            obj.set({'role': 'button'});
            obj.addClass('on');

            obj.addEvents({
                'click': function(e) {
                    var qid = this.getAttribute('data-textid');
                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
                    var drop = _this.el.getElements('.droppable[data-textid="' + qid + '"]')[0];
                    if (qid === drag.getAttribute('data-textid')) {
                        drop
                            .addClass('dragHover correct')
                            .set('html', drag.get('html'));

                        drag.destroy();

                        _this.quiz.correctAnswers++;
                        var data = {draggable: drag, droppable: drop, correctAnswers: _this.quiz.correctAnswers};
                        _this.quiz.fireEvent("answerCorrect", data);
                        drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
                    } else {
                        drop.addClass('');
                        _this.quiz.fireEvent("answerIncorrect");
                    }
                    if (drag !== undefined) {
                        if (acc_mes.get('text') !== drag.getElements('td')[0].get('text')) {
                            acc_mes.set({
                                'text': drag.getElements('td')[0].get('text'),
                                'aria-label': 'new option, ' + drag.getElements('td')[0].get('text'),
                                'aria-live': 'assertive'
                            });
                        }

                    } else {
                        _this.removeAccessibilityActions();
                    }
                    setTimeout(function() {
                        drop
                            .removeProperty('aria-label')
                            .removeProperty('aria-live');
                    }, 2000);
                },
                'keypress': function(e) {
                    if (e.code === 13 || e.code === 32)
                        e.target.fireEvent("click");
                }
            });
        });
    },
    stoptAccessibilityMode: function() {
        var _this = this;
        this.el.removeClass('accessibility-on').addClass('accessibility-off');
        this.el.getElements(".title").set({
            'text': _this.options.action_text,
            'aria-label': _this.options.action_text,
            'aria-live': 'assertive'
        });
        this.removeAccessibilityActions();
    },
    removeAccessibilityActions: function() {
        var mes = this.el.getElement('div.accessibility-message');
        if (mes !== null) {
            mes.destroy();
        }
        this.el.getElements('.clickable').each(function(obj, i) {
            obj.removeClass('on');
            obj.removeEvents('keypress');
            obj.removeEvents('click');
        });

    },
    startQuiz: function() {
        
            console.log("clicked, in QuizApp.js ~~ L309");
        this.el.getElement(".accessibility-icon").show().focus();
        this.dragable_answers = this.el.getElements('.draggable');

        for (var i = 0; i < this.dragable_answers.length; i++) {
            this.dragable_answers[i].innerHTML = ' ' + (this.dragable_answers[i].innerText ? this.dragable_answers[i].innerText : this.dragable_answers[i].childNodes[0].data);
        }

        this.el.getElements(".cell-answer").hide();
        this.el.getElement("#quizarea").show();
        this.el.getElements(".check_your_understanding").hide();
        this.el.getElements(".start_over").show(); 
        if(this.el.getElements(".back"))
            {
                this.el.getElements(".back").show();  
            }
        this.actionTitle();
    },
    reset: function(e, toOriginal) {
        this.el.getElement(".accessibility-icon").hide();
        if (this.el.hasClass('accessibility-on')) {
            this.accessibility_button.fireEvent('click');
        }
        this.firstTimeCorrectCount = 0;
        this.quiz.reset(e);
        this.el.getElements(".alert").set('text', "");
        this.el.getElements(".alert").morph({opacity: 0}, 0);
        this.actionTitle();
        if (toOriginal) {
            this.resetTitle();
            this.el.getElement("#quizinfo").show();
            this.el.getElement("#quizarea").hide();
            this.el.getElements(".reset").hide();
            this.el.getElements(".close").hide();
            this.el.getElements(".start_over").hide();
            if(this.el.getElements(".next"))
            {
                this.el.getElements(".next").hide();  
            }
            if(this.el.getElements(".back"))
            {
                this.el.getElements(".back").show();  
            }
            this.el.getElements(".check_your_understanding").show();
        }
    },
    resetTitle: function() {
        var _this = this;
        this.el.getElements(".title").set({
            'html': _this.options.reset_text,
            'aria-label':  _this.options.reset_text
        });
    },
    actionTitle: function() {
        var _this = this;
        this.el.getElements(".title").set({
            'text':  _this.options.action_text,
            'aria-label':  _this.options.action_text
        });
    }
});











////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////==========   ciccarelli   ==============
////====================================================================
//
///*
// Poe eBook Framework
// Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
// */
//var md = md || {};
//    md.dragdrop = md.dragdrop || {};
//
//    
//
//var QuizApp = new Class({
//    Implements: [Options, Events],
//    options: {
//        action_text: 'Drag the item below to the correct position in the table.',
//        reset_text:'Study the table, then <span class="responsive-call-to-action">click</span> "Check Your Understanding" button when you’re ready.',
//        next_widget:false,
//        previus_widget:false,
//        end_quiz_message:false
//    },
//    initialize: function(el,options) {
//        this.setOptions(options);
//        this.el = $(el);
//        /* get data from HTML */
//        this.statements = this.el.getElements('.cell.data');
//        var myData = [];
//        for (i = 0; i < this.statements.length; i++) {
//            myData.push({"answer": "q" + i + 1, "question": " " + this.statements[i].innerHTML});
//        }
//
//        /* add data to DragDrop*/
//        this.quiz = new md.dragdrop.StepByStepQuiz(el.getElement('#quizarea'), myData,
//                {score: true, shuffleQuestions: true}
//        );
//
//
//        var startQuizEl = this.el.getElements(".check_your_understanding");
//        var resetEl = this.el.getElements(".reset");
//        var endEl = this.el.getElements(".start_over");
//        var closeEl = this.el.getElements(".close");
//        var alertEl = this.el.getElements(".alert");
//
//        var nextEl = this.el.getElements(".next");
//        var backEl = this.el.getElements(".back");
//
//        endEl.hide();
//        resetEl.hide();
//        closeEl.hide();
//        endEl.addEvent("click", function(e) {
//            this.reset(e, true);
//        }.bind(this));
//        if(nextEl)
//        {
//            nextEl.hide();
//            nextEl.addEvent("click", function(e) {
//                this.reset(e, true);
//                this.el.hide();
//                if(this.options.next_widget)
//                {
//                    $(this.options.next_widget).show();
//                }
//            }.bind(this));  
//        }
//        if(backEl)
//        {
//            backEl.addEvent("click", function(e) {
//                this.reset(e, true);
//                this.el.hide();
//                if(this.options.previus_widget)
//                {
//                   $(this.options.previus_widget).show(); 
//                }
//            }.bind(this));  
//        }
//        
//        startQuizEl.addEvent("click", function(e) {
//            e.target.hide();
//            this.startQuiz();
//        }.bind(this));
//        resetEl.addEvent("click", function(e) {
//            this.reset(e, false);
//            this.startQuiz();
//
//        }.bind(this));
//        closeEl.addEvent("click", function(e) {
//            this.reset(e, true);
//        }.bind(this));
//
//        this.firstTimeCorrectCount = 0;
//
//        var incorrectFlag = false;
//        this.quiz.addEvent("answerCorrect", function(data) {
//            clearTimeout(self.feedbackTimer);
//            data.droppable.setStyle('border-color', '#ffffff');
//
//            for (i = 0; i < this.statements.length; i++) {
//
//                if (typeof (data.droppable.children[i]) != "undefined") {
//                    data.droppable.innerHTML = data.droppable.children[i].innerHTML;
//                }
//
//            }
//
//
//            if (!incorrectFlag) {
//                this.firstTimeCorrectCount++;
//            }
//            incorrectFlag = false;
//            alertEl.setStyle("opacity", "1");
//            alertEl.removeClass("correct");
//            alertEl.removeClass("incorrect");
//            alertEl.addClass("correct");
//            alertEl.set('html', 'Correct!');
//            if (data.correctAnswers == this.quiz.questions.length) {
//                //resetEl.show();
//                closeEl.show();
//
//                // Show score
//                var score = new Score(this.quiz.questions.length, this.firstTimeCorrectCount);
//                if(this.options.end_quiz_message){
//                     this.el.getElements(".title").set('text', this.options.end_quiz_message).removeProperty("aria-label");
//                }else{
//                    this.el.getElements(".title").set('text', score.getMessage()).removeProperty("aria-label");
//                }
//                
//                if((options==null || options.endChallengeFocusEl==null ) && this.el.getElement(".reset")!=null )
//                   this.el.getElement(".reset").focus();
//                if(options!=null && options.endChallengeFocusEl!=null){
//                  options.endChallengeFocusEl.focus();
//                }
//
//                this.quiz.fireEvent("quizEnd");
//                if(this.el.getElements(".next"))
//                {
//                    this.el.getElements(".next").show();  
//                }
//
//            }
//            self.feedbackTimer = setTimeout(function() {
//                alertEl.morph({opacity: 0}, 300);
//                alertEl.removeClass('correct').removeClass('incorrect');
//            }, 1200);
//        }.bind(this));
//        this.quiz.addEvent("answerIncorrect", function() {
//            clearTimeout(self.feedbackTimer);
//            alertEl.setStyle("opacity", "1");
//            alertEl.removeClass("correct");
//            alertEl.removeClass("incorrect");
//            alertEl.addClass("incorrect");
//            alertEl.set('html', 'Incorrect. Try again!');
//            incorrectFlag = true;
//            self.feedbackTimer = setTimeout(function() {
//                alertEl.morph({opacity: 0}, 300);
//                alertEl.removeClass('correct').removeClass('incorrect');
//            }, 1200);
//        });
//
//        this.resetTitle();
//
//        this.initAccessibility();
//        this.el.getElement(".accessibility-icon").hide();
//        this.el.getElement('.notes .note').set("tabindex", "1");
//        this.el.getElement('.alert').set("aria-live", "assertive");
//
//        this.el.getElements(".left-content .title-row table tr td, .right-content .title-cell tr td")
//            .each(function(el){
//                el.set("scope", "col");
//            });
//        this.el.getElements(".left-content .data table tr td")
//            .each(function(el){
//                el.set("scope", "row");
//            });
//    },
//    initAccessibility: function() {
//        var _this = this;
//
//        _this.accessibility_button = new Element('div.accessibility-icon.inactive', {
//            'tabindex': '1',
//            'aria-label': 'Select here to start accessible mode.'
//        }).inject(_this.el.getElement('.notes'));
//        
//        this.accessibility_button.addEvents({
//            'click': function() {
//
//                if (_this.el.hasClass('accessibility-off')) {
//                    _this.accessibility_button.set({
//                        'tabindex': '1',
//                        'aria-label': 'The accessible mode has started. Select again to stop accessible mode.'
//                    });
//                    _this.el.getElements(".title")[0].set({
//                        'text': _this.el.getElements(".accessibility-caption")[0].get('text'),
//                        'aria-label': _this.el.getElements(".accessibility-caption")[0].get('text') +
//                        ' ' + _this.el.getElements(".accessibility-information")[0].get('text'),
//                        'aria-live': 'assertive'
//                    });
//
//                    var acc_mes = new Element('div.accessibility-message').inject(_this.el.getElements('.alert')[0], 'after');
//
//                    _this.el.removeClass('accessibility-off').addClass('accessibility-on');
//                    _this.startAccessibilityMode();
//
//                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
//                    if (drag !== undefined) {
//                        acc_mes.set('text', drag.getElements('td')[0].get('text'));
//                    } else {
//                        _this.removeAccessibilityActions();
//                    }
//                } else {
//                    _this.accessibility_button.set({
//                        'tabindex': '1',
//                        'aria-label': 'The accessible mode has stoped. Select again to start accessible mode.'
//                    });
//                    _this.stoptAccessibilityMode();
//
//                }
//
//            },
//            'keypress': function(e) {
//                if (e.code === 13 || e.code === 32)
//                    e.target.fireEvent("click");
//            }
//        });
//        _this.el.getElements('.notes')[0].focus();
//    },
//    startAccessibilityMode: function() {
//        var _this = this;
//
//        var acc_mes = this.el.getElements(".accessibility-message")[0];
//        var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
//        acc_mes.set({
//            'text': drag.getElements('td')[0].get('text'),
//            'aria-label': 'Current option, ' + drag.getElements('td')[0].get('text'),
//            'aria-live': 'assertive',
//            'tabindex': 1
//        });
//
//        this.el.getElements('.clickable').each(function(obj, i) {
//            obj.set({'role': 'button'});
//            obj.addClass('on');
//
//            obj.addEvents({
//                'click': function(e) {
//                    var qid = this.getAttribute('data-textid');
//                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
//                    var drop = _this.el.getElements('.droppable[data-textid="' + qid + '"]')[0];
//                    if (qid === drag.getAttribute('data-textid')) {
//                        drop
//                            .addClass('dragHover correct')
//                            .set('html', drag.get('html'));
//
//                        drag.destroy();
//
//                        _this.quiz.correctAnswers++;
//                        var data = {draggable: drag, droppable: drop, correctAnswers: _this.quiz.correctAnswers};
//                        _this.quiz.fireEvent("answerCorrect", data);
//                        drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
//                    } else {
//                        drop.addClass('');
//                        _this.quiz.fireEvent("answerIncorrect");
//                    }
//                    if (drag !== undefined) {
//                        if (acc_mes.get('text') !== drag.getElements('td')[0].get('text')) {
//                            acc_mes.set({
//                                'text': drag.getElements('td')[0].get('text'),
//                                'aria-label': 'new option, ' + drag.getElements('td')[0].get('text'),
//                                'aria-live': 'assertive'
//                            });
//                        }
//
//                    } else {
//                        _this.removeAccessibilityActions();
//                    }
//                    setTimeout(function() {
//                        drop
//                            .removeProperty('aria-label')
//                            .removeProperty('aria-live');
//                    }, 2000);
//                },
//                'keypress': function(e) {
//                    if (e.code === 13 || e.code === 32)
//                        e.target.fireEvent("click");
//                }
//            });
//        });
//    },
//    stoptAccessibilityMode: function() {
//        var _this = this;
//        this.el.removeClass('accessibility-on').addClass('accessibility-off');
//        this.el.getElements(".title").set({
//            'text': _this.options.action_text,
//            'aria-label': _this.options.action_text,
//            'aria-live': 'assertive'
//        });
//        this.removeAccessibilityActions();
//    },
//    removeAccessibilityActions: function() {
//        var mes = this.el.getElement('div.accessibility-message');
//        if (mes !== null) {
//            mes.destroy();
//        }
//        this.el.getElements('.clickable').each(function(obj, i) {
//            obj.removeClass('on');
//            obj.removeEvents('keypress');
//            obj.removeEvents('click');
//        });
//
//    },
//    startQuiz: function() {
//        this.el.getElement(".accessibility-icon").show().focus();
//        this.dragable_answers = this.el.getElements('.draggable');
//
//        for (var i = 0; i < this.dragable_answers.length; i++) {
//            this.dragable_answers[i].innerHTML = ' ' + (this.dragable_answers[i].innerText ? this.dragable_answers[i].innerText : this.dragable_answers[i].childNodes[0].data);
//        }
//
//        this.el.getElement("#quizinfo").hide();
//        this.el.getElement("#quizarea").show();
//        this.el.getElements(".check_your_understanding").hide();
//        this.el.getElements(".start_over").show(); 
//        if(this.el.getElements(".back"))
//            {
//                this.el.getElements(".back").show();  
//            }
//        this.actionTitle();
//    },
//    reset: function(e, toOriginal) {
//        this.el.getElement(".accessibility-icon").hide();
//        if (this.el.hasClass('accessibility-on')) {
//            this.accessibility_button.fireEvent('click');
//        }
//        this.firstTimeCorrectCount = 0;
//        this.quiz.reset(e);
//        this.el.getElements(".alert").set('text', "");
//        this.el.getElements(".alert").morph({opacity: 0}, 0);
//        this.actionTitle();
//        if (toOriginal) {
//            this.resetTitle();
//            this.el.getElement("#quizinfo").show();
//            this.el.getElement("#quizarea").hide();
//            this.el.getElements(".reset").hide();
//            this.el.getElements(".close").hide();
//            this.el.getElements(".start_over").hide();
//            if(this.el.getElements(".next"))
//            {
//                this.el.getElements(".next").hide();  
//            }
//            if(this.el.getElements(".back"))
//            {
//                this.el.getElements(".back").show();  
//            }
//            this.el.getElements(".check_your_understanding").show();
//        }
//    },
//    resetTitle: function() {
//        var _this = this;
//        this.el.getElements(".title").set({
//            'html': _this.options.reset_text,
//            'aria-label':  _this.options.reset_text
//        });
//    },
//    actionTitle: function() {
//        var _this = this;
//        this.el.getElements(".title").set({
//            'text':  _this.options.action_text,
//            'aria-label':  _this.options.action_text
//        });
//    }
//});
//
//
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////==========   maciones   ====================
////====================================================================
//
///*
// Poe eBook Framework
// Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
//*/
//
//var QuizApp = new Class({
//	initialize: function(el){
//		this.el = $(el);
//		
//		/* get data from HTML */
//		var statements = this.el.getElements('.cell.data');
//		var myData = [];
//		for(i=0; i< statements.length ;i++){
//			myData.push({"answer":"q"+ i+1, "question":" "+ statements[i].innerHTML});
//		}
//		
//		/* add data to DragDrop*/
//		this.quiz = new md.dragdrop.StepByStepQuiz(el.getElement('#quizarea'), myData,
//			{ score: true, shuffleQuestions: true}
//		);
//		
//
//		var startQuizEl = this.el.getElements(".startquiz");
//		var resetEl = this.el.getElements(".reset");
//		var endEl = this.el.getElements(".endquiz");
//		var closeEl = this.el.getElements(".close");
//		var alertEl = this.el.getElements(".alert");
//
//		endEl.hide();
//		resetEl.hide();
//		closeEl.hide();
//		endEl.addEvent("click", function(e){
//			this.reset(e, true);
//		}.bind(this));
//		startQuizEl.addEvent("click", function(e){
//			e.target.hide();
//			this.startQuiz();
//		}.bind(this));
//		resetEl.addEvent("click", function(e){
//			this.reset(e, false);
//		}.bind(this));
//		closeEl.addEvent("click", function(e){
//			this.reset(e, true);
//		}.bind(this));
//
//		this.firstTimeCorrectCount =  0;
//
//		var incorrectFlag = false;
//		this.quiz.addEvent("answerCorrect", function(data){
//	        clearTimeout(self.feedbackTimer);
//			data.droppable.setStyle('border-color','#ffffff');
//			if(!incorrectFlag) {
//				this.firstTimeCorrectCount++;
//			}
//			incorrectFlag = false;
//			alertEl.setStyle("opacity", "1");
//			alertEl.removeClass("correct");
//			alertEl.removeClass("incorrect");
//			alertEl.addClass("correct");
//			alertEl.set('html', 'Correct!');
//			if(data.correctAnswers == this.quiz.questions.length) {
//				resetEl.show();
//				closeEl.show();
//				this.el.getElements(".title").set('text', 'Quiz complete! You got ' + this.firstTimeCorrectCount + ' of '
//					+ this.quiz.questions.length + ' correct on the first try.');
//			}
//			self.feedbackTimer = setTimeout(function() {
//	            alertEl.morph({opacity: 0}, 300);
//	            alertEl.removeClass('correct').removeClass('incorrect');
//	        }, 1200);
//		}.bind(this));
//		this.quiz.addEvent("answerIncorrect", function(){
//	        clearTimeout(self.feedbackTimer);
//			alertEl.setStyle("opacity", "1");
//			alertEl.removeClass("correct");
//			alertEl.removeClass("incorrect");
//			alertEl.addClass("incorrect");
//			alertEl.set('html', 'Incorrect. Try again!');
//			incorrectFlag = true;
//			self.feedbackTimer = setTimeout(function() {
//	            alertEl.morph({opacity: 0}, 300);
//	            alertEl.removeClass('correct').removeClass('incorrect');
//	        }, 1200);
//		});
//
//		this.resetTitle();
//	},
//	startQuiz: function(){
//
//		this.el.getElement("#quizinfo").hide();
//		this.el.getElement("#quizarea").show();
//		this.el.getElements(".startquiz").hide();
//		this.el.getElements(".endquiz").show();
//		this.actionTitle();
//	},
//	reset: function(e, toOriginal){
//		this.firstTimeCorrectCount = 0;
//		this.quiz.reset(e);
//		this.el.getElements(".alert").set('text', "");
//		this.el.getElements(".alert").morph({opacity: 0}, 0);
//		this.actionTitle();
//		if(toOriginal) {
//			this.resetTitle();
//			this.el.getElement("#quizinfo").show();
//			this.el.getElement("#quizarea").hide();
//			this.el.getElements(".reset").hide();
//			this.el.getElements(".close").hide();
//			this.el.getElements(".endquiz").hide();
//			this.el.getElements(".startquiz").show();
//		}
//	},
//	resetTitle: function(){
//		this.el.getElements(".title").set('text','Study the table, then click Start Quiz when you’re ready.');
//	},
//	actionTitle: function(){
//		this.el.getElements(".title").set('text','Drag the item below to the correct position in the table.');
//	}
//});
//
//
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////==========   henslin   ===========================
////====================================================================
//
///*
// Poe eBook Framework
// Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
// */
//
//var QuizApp = new Class({
//    initialize: function(el) {
//
//        this.el = $(el);
//        /* get data from HTML */
//        this.statements = this.el.getElements('.cell.data');
//        var myData = [];
//        for (i = 0; i < this.statements.length; i++) {
//            myData.push({"answer": "q" + i + 1, "question": " " + this.statements[i].innerHTML});
//        }
//
//        /* add data to DragDrop*/
//        this.quiz = new md.dragdrop.StepByStepQuiz(el.getElement('#quizarea'), myData,
//                {score: true, shuffleQuestions: true}
//        );
//
//
//        var startQuizEl = this.el.getElements(".check_your_understanding");
//        var resetEl = this.el.getElements(".reset");
//        var endEl = this.el.getElements(".start_over");
//        var closeEl = this.el.getElements(".close");
//        var alertEl = this.el.getElements(".alert");
//
//        endEl.hide();
//        resetEl.hide();
//        closeEl.hide();
//        endEl.addEvent("click", function(e) {
//            this.reset(e, true);
//        }.bind(this));
//        startQuizEl.addEvent("click", function(e) {
//            e.target.hide();
//            this.startQuiz();
//        }.bind(this));
//        resetEl.addEvent("click", function(e) {
//            this.reset(e, false);
//            this.startQuiz();
//
//        }.bind(this));
//        closeEl.addEvent("click", function(e) {
//            this.reset(e, true);
//        }.bind(this));
//
//        this.firstTimeCorrectCount = 0;
//
//        var incorrectFlag = false;
//        this.quiz.addEvent("answerCorrect", function(data) {
//            clearTimeout(self.feedbackTimer);
//            data.droppable.setStyle('border-color', '#ffffff');
//
//            for (i = 0; i < this.statements.length; i++) {
//
//                if (typeof (data.droppable.children[i]) != "undefined") {
//                    data.droppable.innerHTML = data.droppable.children[i].innerHTML;
//                }
//
//            }
//
//
//            if (!incorrectFlag) {
//                this.firstTimeCorrectCount++;
//            }
//            incorrectFlag = false;
//            alertEl.setStyle("opacity", "1");
//            alertEl.removeClass("correct");
//            alertEl.removeClass("incorrect");
//            alertEl.addClass("correct");
//            alertEl.set('html', 'Correct!');
//            if (data.correctAnswers == this.quiz.questions.length) {
//                resetEl.show();
//                closeEl.show();
//
//                // Show score
//                var score = new Score(this.quiz.questions.length, this.firstTimeCorrectCount);
//                this.el.getElements(".title").set('text', score.getMessage());
//                this.quiz.fireEvent("quizEnd");
//            }
//            self.feedbackTimer = setTimeout(function() {
//                alertEl.morph({opacity: 0}, 300);
//                alertEl.removeClass('correct').removeClass('incorrect');
//            }, 1200);
//        }.bind(this));
//        this.quiz.addEvent("answerIncorrect", function() {
//            clearTimeout(self.feedbackTimer);
//            alertEl.setStyle("opacity", "1");
//            alertEl.removeClass("correct");
//            alertEl.removeClass("incorrect");
//            alertEl.addClass("incorrect");
//            alertEl.set('html', 'Incorrect. Try again!');
//            incorrectFlag = true;
//            self.feedbackTimer = setTimeout(function() {
//                alertEl.morph({opacity: 0}, 300);
//                alertEl.removeClass('correct').removeClass('incorrect');
//            }, 1200);
//        });
//
//        this.resetTitle();
//
//        this.initAccessibility();
//        this.el.getElement(".accessibility-icon").hide();
//        this.el.getElement('.notes').focus();
//    },
//    initAccessibility: function() {
//        var _this = this;
//
//        _this.accessibility_button = new Element('div.accessibility-icon.inactive', {
//            'tabindex': '1',
//            'aria-label': 'Select here to start accessible mode.'
//        }).inject(_this.el.getElement('.notes'));
//
//        this.accessibility_button.addEvents({
//            'click': function() {
//
//                if (_this.el.hasClass('accessibility-off')) {
//                    _this.accessibility_button.set({
//                        'tabindex': '1',
//                        'aria-label': 'The accessible mode has started. Select again to stop accessible mode.'
//                    });
//                    _this.el.getElements(".title")[0].set({
//                        'text': _this.el.getElements(".accessibility-caption")[0].get('text'),
//                        'aria-label': _this.el.getElements(".accessibility-caption")[0].get('text') +
//                                ' ' + _this.el.getElements(".accessibility-information")[0].get('text'),
//                        'aria-live': 'assertive'
//                    });
//
//                    var acc_mes = new Element('div.accessibility-message').inject(_this.el.getElements('.alert')[0], 'after');
//
//                    _this.el.removeClass('accessibility-off').addClass('accessibility-on');
//                    _this.startAccessibilityMode();
//
//                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
//                    if (drag !== undefined) {
//                        acc_mes.set('text', drag.getElements('td')[0].get('text'));
//                    } else {
//                        _this.removeAccessibilityActions();
//                    }
//                } else {
//                    _this.accessibility_button.set({
//                        'tabindex': '1',
//                        'aria-label': 'The accessible mode has stoped. Select again to start accessible mode.'
//                    });
//                    _this.stoptAccessibilityMode();
//
//                }
//
//            },
//            'keypress': function(e) {
//                if (e.code === 13 || e.code === 32)
//                    e.target.fireEvent("click");
//            }
//        });
//        _this.el.getElements('.notes')[0].focus();
//    },
//    startAccessibilityMode: function() {
//        var _this = this;
//
//        var acc_mes = this.el.getElements(".accessibility-message")[0];
//        var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
//        acc_mes.set({
//            'text': drag.getElements('td')[0].get('text'),
//            'aria-label': 'Current option, ' + drag.getElements('td')[0].get('text'),
//            'aria-live': 'assertive'
//        });
//
//        this.el.getElements('.clickable').each(function(obj, i) {
//            obj.set({'role': 'button'});
//            obj.addClass('on');
//
//            obj.addEvents({
//                'click': function(e) {
//                    var qid = this.getAttribute('data-textid');
//                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
//                    var drop = _this.el.getElements('.droppable[data-textid="' + qid + '"]')[0];
//
//                    if (qid === drag.getAttribute('data-textid')) {
//                        drop.addClass('dragHover correct').set({
//                            'aria-label': 'Correct answer!',
//                            'aria-live': 'assertive'
//                        });
//                        drop.set('html', drag.get('html'));
//
//                        drag.destroy();
//
//                        _this.quiz.correctAnswers++;
//                        var data = {draggable: drag, droppable: drop, correctAnswers: _this.quiz.correctAnswers};
//                        _this.quiz.fireEvent("answerCorrect", data);
//                        drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
//                    } else {
//                        drop.addClass('').set({
//                            'aria-label': 'Incorrect, try again.',
//                            'aria-live': 'assertive'
//                        });
//                        _this.quiz.fireEvent("answerIncorrect");
//                    }
//                    if (drag !== undefined) {
//                        if (acc_mes.get('text') !== drag.getElements('td')[0].get('text')) {
//                            acc_mes.set({
//                                'text': drag.getElements('td')[0].get('text'),
//                                'aria-label': 'new option, ' + drag.getElements('td')[0].get('text'),
//                                'aria-live': 'assertive'
//                            });
//                        }
//
//                    } else {
//                        _this.removeAccessibilityActions();
//                    }
//                    setTimeout(function() {
//                        drop.set({
//                            'aria-label': '',
//                            'aria-live': 'off'
//                        });
//                    }, 2000);
//                },
//                'keypress': function(e) {
//                    if (e.code === 13 || e.code === 32)
//                        e.target.fireEvent("click");
//                }
//            });
//        });
//    },
//    stoptAccessibilityMode: function() {
//        this.el.removeClass('accessibility-on').addClass('accessibility-off');
//        this.el.getElements(".title").set({
//            'text': 'Drag the item below to the correct position in the table.',
//            'aria-label': 'Drag the item below to the correct position in the table.',
//            'aria-live': 'assertive'
//        });
//        this.removeAccessibilityActions();
//    },
//    removeAccessibilityActions: function() {
//        var mes = this.el.getElement('div.accessibility-message');
//        if (mes !== null) {
//            mes.destroy();
//        }
//        this.el.getElements('.clickable').each(function(obj, i) {
//            obj.removeClass('on');
//            obj.removeEvents('keypress');
//            obj.removeEvents('click');
//        });
//
//    },
//    startQuiz: function() {
//        this.el.getElement(".accessibility-icon").show().focus();
//        this.dragable_answers = this.el.getElements('.draggable');
//
//        for (var i = 0; i < this.dragable_answers.length; i++) {
//            this.dragable_answers[i].innerHTML = ' ' + (this.dragable_answers[i].innerText ? this.dragable_answers[i].innerText : this.dragable_answers[i].childNodes[0].data);
//        }
//
//        this.el.getElement("#quizinfo").hide();
//        this.el.getElement("#quizarea").show();
//        this.el.getElements(".check_your_understanding").hide();
//        this.el.getElements(".start_over").show();
//        this.actionTitle();
//    },
//    reset: function(e, toOriginal) {
//        this.el.getElement(".accessibility-icon").hide();
//        if (this.el.hasClass('accessibility-on')) {
//            this.accessibility_button.fireEvent('click');
//        }
//        this.firstTimeCorrectCount = 0;
//        this.quiz.reset(e);
//        this.el.getElements(".alert").set('text', "");
//        this.el.getElements(".alert").morph({opacity: 0}, 0);
//        this.actionTitle();
//        if (toOriginal) {
//            this.resetTitle();
//            this.el.getElement("#quizinfo").show();
//            this.el.getElement("#quizarea").hide();
//            this.el.getElements(".reset").hide();
//            this.el.getElements(".close").hide();
//            this.el.getElements(".start_over").hide();
//            this.el.getElements(".check_your_understanding").show();
//        }
//    },
//    resetTitle: function() {
//        this.el.getElements(".title").set({
//            'html': 'Study the table, then <span class="responsive-call-to-action">tap</span> "Check Your Understanding" button when you’re ready.',
//            'aria-label': 'Study the table, then <span class="responsive-call-to-action">tap</span> "Check Your Understanding" button when you’re ready.'
//        });
//    },
//    actionTitle: function() {
//        this.el.getElements(".title").set({
//            'text': 'Drag the item below to the correct position in the table.',
//            'aria-label': 'Drag the item below to the correct position in the table.'
//        });
//    }
//});
//
//
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
////====================================================================
//
