/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
 */

var QuizApp = new Class({
    initialize: function(el,options) {

        this.el = $(el);
        this.el.ontouchmove = function() {event.preventDefault();}
        /* get data from HTML */
        this.statements = this.el.getElements('.cell.data');
        var myData = [];
        for (i = 0; i < this.statements.length; i++) {
            myData.push({"answer": "q" + i + 1, "question": " " + this.statements[i].innerHTML});
        }

        /* add data to DragDrop*/
        this.quiz = new md.dragdrop.StepByStepQuiz(el.getElement('#quizarea'), myData,
                {score: true, shuffleQuestions: true}
        );


        var startQuizEl = this.el.getElements(".check_your_understanding");
        var resetEl = this.el.getElements(".reset");
        var endEl = this.el.getElements(".start_over");
        var closeEl = this.el.getElements(".close");
        var alertEl = this.el.getElements(".alert");

        endEl.hide();
        resetEl.hide();
        closeEl.hide();
        endEl.addEvent("click", function(e) {
            this.reset(e, true);
        }.bind(this));
        startQuizEl.addEvent("click", function(e) {
            e.target.hide();
            this.startQuiz();
        }.bind(this));
        resetEl.addEvent("click", function(e) {
            this.reset(e, false);
            this.startQuiz();

        }.bind(this));
        closeEl.addEvent("click", function(e) {
            this.reset(e, true);
        }.bind(this));

        this.firstTimeCorrectCount = 0;

        var incorrectFlag = false;
        this.quiz.addEvent("answerCorrect", function(data) {
            clearTimeout(self.feedbackTimer);
            data.droppable.setStyle('border-color', '#ffffff');

            for (i = 0; i < this.statements.length; i++) {

                if (typeof (data.droppable.children[i]) != "undefined") {
                    data.droppable.innerHTML = data.droppable.children[i].innerHTML;
                }

            }


            if (!incorrectFlag) {
                this.firstTimeCorrectCount++;
            }
            incorrectFlag = false;
            alertEl.setStyle("opacity", "1");
            alertEl.removeClass("correct");
            alertEl.removeClass("incorrect");
            alertEl.addClass("correct");
            alertEl.set('html', 'Correct!');
            if (data.correctAnswers == this.quiz.questions.length) {
                //resetEl.show();
                closeEl.show();

                // Show score
                var score = new Score(this.quiz.questions.length, this.firstTimeCorrectCount);
                this.el.getElements(".title").set('text', score.getMessage()).removeProperty("aria-label");
                if((options==null || options.endChallengeFocusEl==null ) && this.el.getElement(".reset")!=null )
                   this.el.getElement(".reset").focus();
                if(options!=null && options.endChallengeFocusEl!=null){
                  options.endChallengeFocusEl.focus();
                }

                this.quiz.fireEvent("quizEnd");
            }
            self.feedbackTimer = setTimeout(function() {
                alertEl.morph({opacity: 0}, 300);
                alertEl.removeClass('correct').removeClass('incorrect');
            }, 1200);
        }.bind(this));
        this.quiz.addEvent("answerIncorrect", function() {
            clearTimeout(self.feedbackTimer);
            alertEl.setStyle("opacity", "1");
            alertEl.removeClass("correct");
            alertEl.removeClass("incorrect");
            alertEl.addClass("incorrect");
            alertEl.set('html', 'Incorrect. Try again!');
            incorrectFlag = true;
            self.feedbackTimer = setTimeout(function() {
                alertEl.morph({opacity: 0}, 300);
                alertEl.removeClass('correct').removeClass('incorrect');
            }, 1200);
        });

        this.resetTitle();

        this.initAccessibility();
        if(this.el.getElement(".accessibility-icon"))
            this.el.getElement(".accessibility-icon").hide();
        this.el.getElement('.notes .note').set("tabindex", "1");
        this.el.getElement('.alert').set("aria-live", "assertive");

        this.el.getElements(".left-content .title-row table tr td, .right-content .title-cell tr td")
            .each(function(el){
                el.set("scope", "col");
            });
        this.el.getElements(".left-content .data table tr td")
            .each(function(el){
                el.set("scope", "row");
            });
        
        if(this.isTouchDevice()){           
            setInterval(function(){
                if($$('div.accessibility-icon')[0])
                    $$('div.accessibility-icon')[0].remove();
            }, 1000);            
        }
    },
    initAccessibility: function() {
        var _this = this;

        _this.accessibility_button = new Element('div.accessibility-icon.inactive', {
            'tabindex': '1',
            'aria-label': 'Select here to start accesible mode.'
        }).inject(_this.el.getElement('.notes'));

        this.accessibility_button.addEvents({
            'click': function() {

                if (_this.el.hasClass('accessibility-off')) {
                    _this.accessibility_button.set({
                        'tabindex': '1',
                        'aria-label': 'The accessible mode has started. Select again to stop accessible mode.'
                    });
                    _this.el.getElements(".title")[0].set({
                        'text': _this.el.getElements(".accessibility-caption")[0].get('text'),
                        'aria-label': _this.el.getElements(".accessibility-caption")[0].get('text') +
                        ' ' + _this.el.getElements(".accessibility-information")[0].get('text'),
                        'aria-live': 'assertive'
                    });

                    var acc_mes = new Element('div.accessibility-message').inject(_this.el.getElements('.alert')[0], 'after');

                    _this.el.removeClass('accessibility-off').addClass('accessibility-on');
                    _this.startAccessibilityMode();

                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
                    if (drag !== undefined) {
                        acc_mes.set('text', drag.getElements('td')[0].get('text'));
                    } else {
                        _this.removeAccessibilityActions();
                    }
                } else {
                    _this.accessibility_button.set({
                        'tabindex': '1',
                        'aria-label': 'The accessible mode has stoped. Select again to start accessible mode.'
                    });
                    _this.stoptAccessibilityMode();

                }

            },
            'keypress': function(e) {
                if (e.code === 13 || e.code === 32)
                    e.target.fireEvent("click");
            }
        });
        _this.el.getElements('.notes')[0].focus();
    },
    startAccessibilityMode: function() {
        var _this = this;

        var acc_mes = this.el.getElements(".accessibility-message")[0];
        var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
        acc_mes.set({
            'text': drag.getElements('td')[0].get('text'),
            'aria-label': 'Current option, ' + drag.getElements('td')[0].get('text'),
            'aria-live': 'assertive',
            'tabindex': 1
        });

        this.el.getElements('.clickable').each(function(obj, i) {
            obj.set({'role': 'button'});
            obj.addClass('on');

            obj.addEvents({
                'click': function(e) {
                    var qid = this.getAttribute('data-textid');
                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
                    var drop = _this.el.getElements('.droppable[data-textid="' + qid + '"]')[0];

                    if (qid === drag.getAttribute('data-textid')) {
                        drop
                            .addClass('dragHover correct')
                            .set('html', drag.get('html'));

                        drag.destroy();

                        _this.quiz.correctAnswers++;
                        var data = {draggable: drag, droppable: drop, correctAnswers: _this.quiz.correctAnswers};
                        _this.quiz.fireEvent("answerCorrect", data);
                        drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
                    } else {
                        drop.addClass('');
                        _this.quiz.fireEvent("answerIncorrect");
                    }
                    if (drag !== undefined) {
                        if (acc_mes.get('text') !== drag.getElements('td')[0].get('text')) {
                            acc_mes.set({
                                'text': drag.getElements('td')[0].get('text'),
                                'aria-label': 'new option, ' + drag.getElements('td')[0].get('text'),
                                'aria-live': 'assertive'
                            });
                        }

                    } else {
                        _this.removeAccessibilityActions();
                    }
                    setTimeout(function() {
                        drop
                            .removeProperty('aria-label')
                            .removeProperty('aria-live');
                    }, 2000);
                },
                'keypress': function(e) {
                    if (e.code === 13 || e.code === 32)
                        e.target.fireEvent("click");
                }
            });
        });
    },
    stoptAccessibilityMode: function() {
        this.el.removeClass('accessibility-on').addClass('accessibility-off');
        if(this.isTouchDevice()){
            this.el.getElements(".title").set({
                'text': 'Drag the item below to the correct position, or just tap the correct cell in the table.',
                'aria-label': 'Select the correct cell in the table.'
            });
        }else{
            this.el.getElements(".title").set({
                'html': 'Drag the item below to the correct position in the table.',
                'aria-label': 'Drag the item below to the correct position in the table.',
                'aria-live': 'assertive'
            });
        }
        this.removeAccessibilityActions();
    },
    removeAccessibilityActions: function() {
        var mes = this.el.getElement('div.accessibility-message');
        if (mes !== null) {
            mes.destroy();
        }
        this.el.getElements('.clickable').each(function(obj, i) {
            obj.removeClass('on');
            obj.removeEvents('keypress');
            obj.removeEvents('click');
        });

    },
    startQuiz: function() {
        if(this.el.getElement(".accessibility-icon"))
            this.el.getElement(".accessibility-icon").show().focus();
        this.dragable_answers = this.el.getElements('.draggable');

        for (var i = 0; i < this.dragable_answers.length; i++) {
            this.dragable_answers[i].innerHTML = ' ' + (this.dragable_answers[i].innerText ? this.dragable_answers[i].innerText : this.dragable_answers[i].childNodes[0].data);
        }

        this.el.getElement("#quizinfo").hide();
        this.el.getElement("#quizarea").show();
        this.el.getElements(".check_your_understanding").hide();
        this.el.getElements(".start_over").show();
        this.actionTitle();
        
        var _this = this;
        
        this.el.getElements('.answer .droppable').each(function(obj, i) {
            $$('#quizarea')[0].setStyles({width: '10px', height: '10px'});
            obj.addEvents({
                'touchend': function(e) {
                    if($$('#dragdropquiz')[0].hasClass('accessibility-on'))
                        return;
                    
                    
                    var qid = this.getAttribute('data-textid');
                    var drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
                    var drop = _this.el.getElements('.droppable[data-textid="' + qid + '"]')[0];

                    if (qid === drag.getAttribute('data-textid')) {
                        drop.addClass('dragHover correct')
                            .set('html', drag.get('html'));
                        drop.setStyle('padding', '3px 8px');
                        drop.setStyle('font-size', '12px');

                        drag.destroy();

                        _this.quiz.correctAnswers++;
                        var data = {draggable: drag, droppable: drop, correctAnswers: _this.quiz.correctAnswers};
                        _this.quiz.fireEvent("answerCorrect", data);
                        drag = _this.el.getElements('.draggable[style="display: block;"]')[0];
                    } else {
                        drop.addClass('');
                        _this.quiz.fireEvent("answerIncorrect");
                    }
                    
                    setTimeout(function() {
                        drop
                            .removeProperty('aria-label')
                            .removeProperty('aria-live');
                    }, 2000);
                }
            });
        });
        
    },
    reset: function(e, toOriginal) {
        if(this.el.getElement(".accessibility-icon"))
            this.el.getElement(".accessibility-icon").hide();
        
        if (this.el.hasClass('accessibility-on')) {
            this.accessibility_button.fireEvent('click');
        }
        this.firstTimeCorrectCount = 0;
        this.quiz.reset(e);
        this.el.getElements(".alert").set('text', "");
        this.el.getElements(".alert").morph({opacity: 0}, 0);
        this.actionTitle();
        if (toOriginal) {
            this.resetTitle();
            this.el.getElement("#quizinfo").show();
            this.el.getElement("#quizarea").hide();
            this.el.getElements(".reset").hide();
            this.el.getElements(".close").hide();
            this.el.getElements(".start_over").hide();
            this.el.getElements(".check_your_understanding").show();
        }
    },
    resetTitle: function() {
        this.el.getElements(".title").set({
            'html': 'Study the table, then <span class="responsive-call-to-action">click</span> "Check Your Understanding" button when you’re ready.',
            'aria-label': 'Study the table, then <span class="responsive-call-to-action">click</span> "Check Your Understanding" button when you’re ready.'
        });
    },
    actionTitle: function() {
        if(this.isTouchDevice()){
            this.el.getElements(".title").set({
                'text': 'Drag the item below to the correct position or Tap the correct cell in the table.',
                'aria-label': 'Drag the item below to the correct position in the table.'
            });
        }else{
            this.el.getElements(".title").set({
                'text': 'Drag the item below to the correct position in the table.',
                'aria-label': 'Drag the item below to the correct position in the table.'
            });
        }
    },
    isTouchDevice: function(){
        return typeof window.ontouchstart !== 'undefined';		
    }    
});