/*
Poe eBook Framework
Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
*/

'use strict';

var tableDragGUI = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null
    },
    isEditMode: null,
    initialize: function (container) {
        //parse url params
        this.setOptions({container:container});
        this.paramsParse();
        // PROPERTIES
        var _this = this;
        this.documentPath = this.getDocumentPath();
        this.options.container = container;

        // parent.top gives access to the parent of the <iframe>
        this.parentFrame = parent.top;
        this.window = window;
        this.document = document;

        // inspect the URL of the <iframe> for the "mdedit" tag ("1" if true)
        if (this.getURLParameter('mdedit')) {
            this.isEditMode = true;
        } else {
            this.isEditMode = false;
        }
        var that = this;

        window.addEventListener("message", function(message) {

            var path = "";
            if(that.booksRoot==null){
                path = that.getBookPath('/pearson-books/');
                if(path==""){
                    path = that.getBookPath('/pearson-books-dev/');
                }
            }
            else{
                path = that.getBookPath('/'+that.booksRoot+'/');
            }


            that.postMessageReceived(message, path);

        });

        // NOTE: Can also access with "this.table = $$('#tabledrag');"
        this.table = document.getElementById('tabledrag');
        this.tableBody = document.getElementById('tablebody');
        this.tableDragSection = document.getElementById('tabledrag-wrapper');
        this.header = document.getElementById('widget-header');
//        this.tableDragSection = document.getElementById('tabledrag-wrapper');
        this.addColumnButton = null;
        this.addRowButton = null;

        // NOTE: maxColumns and maxRows were defined somewhat arbitrarily by Aaron in development. Feel free to change it.
        this.maxColumns = 4;
        this.maxRows = 10;

        // METHODS
        this.getNumOfRows = function () {
            return (_this.table.dataset.numberOfRows).toInt();
        }; // end getNumOfRows()
        this.getNumOfColumns = function () {
            return (_this.table.dataset.numberOfColumns).toInt();
        }; // end getNumOfColumns()

        if (this.isEditMode) {
            _this.bindEditMode();
            _this.bindEvents();
            _this.registerWidgetOnParentFrame();
        }
        else{
            this.receivePreviewMessages();
            this.afterInitialize();
        }
        if(this.isEditMode)
            this.updateEditMode();


        
        

        
    }, // end initialize(container)
    afterInitialize:function(){
        /****************
         * Function called once and is not a edit mode
         ***************/
        var _this = this;
        var quizColumn = $("tabledrag-wrapper").get("md-quiz-column")!=null?$("tabledrag-wrapper").get("md-quiz-column"):1;
        var headers = [];
        var columns = [];

        $("tabledrag-wrapper").getElements(".rowheader td span").each(function(e,i){
            headers.push(e.get("text"));
        });

        $("tabledrag-wrapper").getElements("tr:not(.rowheader)").each(function(e,i){
            
            e.getElements("td span").each(function(col,cindex){
                var column = [];
                if(columns[cindex]!=null){
                    column = columns[cindex];
                }
                else{
                    columns[cindex] = column;
                }
                column.push(col.get("text"));
            });
            
        });

        $("tabledrag-wrapper").empty();
        $("tabledrag-wrapper").addClass("bind-quiz");


        var widths = _this.tableDragSection.get("md-quiz-columns-widths");
        if(widths==null)
            widths=[]
        else
            widths = widths.split(";");


        /**************
         * Build Quiz Dom
         *************/
        headers.each(function(header,i){
            var column = _this.buildQuizColumn(header,columns[i],i,i+1==quizColumn);
            
            if(i==0){
                column.addClass("left-content");
            }
            else if(i+1==headers.length){
                column.addClass("right-content");
            }
            else{
                column.addClass("middle-content");
            }
            if(widths[i]!=null){
                column.setStyle("width",widths[i]);
            }
            $("tabledrag-wrapper").adopt(column);
        });


        var height = _this.tableDragSection.get("md-quiz-columns-height");
        if(height!="" && height!=null){
            height = height.replace("px","");
            $("tabledrag-wrapper").getElements(".cell:not(.title-cell)").setStyle("height",height+"px");
            setTimeout(function(){
                $("tabledrag-wrapper").getElements(".quiz-column-content .droppable").setStyle("height",(new Number(height)-0)+"px");
            },750);

            var style = '#tabledrag-wrapper .cell:not(.title-cell),#tabledrag-wrapper .quiz-column-content .droppable{height:'+height+'px;}';
            new Element("style",{html:style}).inject($$("head")[0]);
        }

        var height_title = _this.tableDragSection.get("md-quiz-columns-title-height");
        if(height_title!="" && height_title!=null){
            height_title = height.replace("px","");
            $$(".title-cell.cell").setStyle("height",height_title+"px");
            
        }
        



        window.widget = new QuizApp($("dragdropquiz"));

    }, // end afterInitialize
    buildQuizColumn:function(header,column,index,quizColumn){
        var _this = this;
        var column_wrapper = new Element("div.column");

        if(quizColumn){
            column_wrapper.addClass("quiz-column-content");
        }
        

        column_wrapper.adopt(this.buildQuizRowHeader(header, index, quizColumn));

        var data_wrapper = column_wrapper;

        if(quizColumn){
            var quizinfo = new Element("div#quizinfo");
            column_wrapper.adopt(quizinfo);

            var quizarea = new Element("div#quizarea");
            column_wrapper.adopt(quizarea);

            data_wrapper = new Element("div.droparea");
            quizinfo.adopt(data_wrapper);
        }

        Array.each(column,function(column_data){
            data_wrapper.adopt(_this.buildQuizRow(column_data, index, quizColumn));
        });


        return column_wrapper;

    }, // end buildQuizColumn
    buildQuizRowHeader:function(content,index,quizColumn){
        var wrapper = new Element("div");
        if(quizColumn){
            wrapper.addClass("title-row");
            wrapper.adopt(new Element("div.title-cell.cell",{html:content}));
        }
        else{
            wrapper = new Element("div.title-cell.cell",{html:content});
        }

        return wrapper;
    }, // end buildQuizRowHeader
    buildQuizRow:function(content,index,quizColumn){
        var wrapper = new Element("div");
        if(quizColumn){
            wrapper.addClass("cell data");
            wrapper.set("html","<table><tr><td>"+content+"</td></tr></table>");
        }
        else{
            wrapper = new Element("div.cell.celltype.clickable",{html:'<table><tr><td>'+content+"</td></tr></table>"});
        }

        return wrapper;
    }, // end buildQuizRow
    bindEditMode: function () {
        /****************
         * Add rows and cells to rows or columns.
         *     'rowPosition' = the row index of the new cell, counting from '0'
         *     'columnPosition' = the column index of the new cell, counting from '0'
         * The Header and Label rows are '0' rows.
         ***************/
        var _this = this;
        $$('body')[0].addClass('md-edit-mode');
        var quizColumn = $("tabledrag-wrapper").get("md-quiz-column")!=null?$("tabledrag-wrapper").get("md-quiz-column"):1;

        if(parent && parent.window != window){
            parent.window.postMessage({
                method:"set-quiz-column",
                column:quizColumn
            },"*");
        }
        
        /**************
         * Remove quiz header and footer from edit page
         *************/
        
        
        /**************
         * Add GUI buttons to DOM
         *************/
        this.addRowButton = new Element('div');
        this.addRowButton.set('class', 'addbutton clickable')
            .set('id', 'rowadd');
        this.addRowButton.innerHTML = '+';
        
        this.addColumnButton = new Element('div');
        this.addColumnButton.set('class', 'addbutton clickable')
            .set('id', 'coladd');
        this.addColumnButton.innerHTML = '+';
        
//        this.tableDragSection.appendChild(newAddColumnButton);
//        this.tableDragSection.appendChild(newAddRowButton);
//        setTimeout(function() {
//            this.addColumnButton = document.getElementById('coladd');
//            this.addRowButton = document.getElementById('rowadd');
//        }, 500).bind(this); // give the DOM time to update
//        debugger;
        this.tableDragSection.appendChild(this.addColumnButton);
        this.tableDragSection.appendChild(this.addRowButton);
        this.header.hide();
        
        
         /**************
         * Functions for GUI buttons
         *************/
        this.addRow = function (rowPosition) {
            _this.table.dataset.numberOfRows++;

            var newLastRow = new Element('tr');
            var classString = 'tabledrag-row-' + (rowPosition);
            newLastRow.set('class', classString);

            // append a <td> child to this last row for each column
            for (var i = 0; i < _this.getNumOfColumns(); i++) {
                newLastRow.appendChild(_this.addCell(rowPosition, i));
            } // end for (append <td> elements)

            _this.tableBody.appendChild(newLastRow);
        }; // end addRow()
        this.addColumn = function (columnPosition) {
            _this.table.dataset.numberOfColumns++;

            // get an array of all the <tr> elements
            var rowChildren = _this.tableBody.getChildren();

            // append a <td> child to each row
            for (var i = 0; i < _this.getNumOfRows(); i++) {
                rowChildren[i].appendChild(_this.addCell(i, columnPosition));
            } // end for (append <td> elements)
        }; // end addColumn()
        this.addCell = function (rowPosition, columnPosition) {
            var newCell = new Element('td');
            var newSpan = new Element('span');

            var classString = 'cell celltype clickable tabledrag-column tabledrag-column-' + columnPosition;
            var dataString = 'cell' + rowPosition + columnPosition;
            var tabIndexString = '1' + rowPosition + columnPosition;
            var textString = '';

            // change <td> class and text attrs depending on row and column
            if (columnPosition === 0) { // if this is a label cell on a new row:
                classString += ' cell-left cell-question';
                textString += 'Question ' + rowPosition;
            } else if (rowPosition === 0) { // if this is a header cell on a new column:
                classString = 'title-cell tabledrag-column tabledrag-column-' + columnPosition;
                textString += 'Column ' + columnPosition + ' Header';

                //e.adopt(new Element("div.deletecolumn",{html:"Delete Column"}));
            } else {
                classString += ' cell-right cell-answer';
                textString += 'Answer ' + rowPosition + '.' + columnPosition;
            }

            // Set calculated properties on new <span> element
            newSpan.set('contenteditable', 'true')
                .set('data-md-editable', 'cell')
                .set('tabindex', tabIndexString);
            newSpan.innerHTML = textString;

            // Set calculated properties on new <td> element
            newCell.set('class', classString)
                .set('data-textid', dataString);
            newCell.appendChild(newSpan);

            if (rowPosition === 0)
                new Element("div.deletecolumn",{html:"Delete Column"}).inject(newCell);

            this.watchForChanges(newSpan); // register event listeners for saving on new cells
            
            return newCell;
        }; // end addCell()

        /**
         * Add delete button
         */
        $$(".rowheader .tabledrag-column").each(function(e){
            e.adopt(new Element("div.deletecolumn",{html:"Delete Column"}));
        });


        this.watchForChanges();

        if(parent && parent!=window){
            
            var widths = _this.tableDragSection.get("md-quiz-columns-widths");
            if(widths==null)
                widths=[]
            else
                widths = widths.split(";");

            parent.postMessage({
                method:"columns-width",
                columns:_this.table.dataset.numberOfColumns,
                widths:widths
            },"*")

            var height = _this.tableDragSection.get("md-quiz-columns-height");
            parent.postMessage({
                method:"columns-height",
                height:height
            },"*")
        }
    },
    bindEvents: function () {
        var _this = this;

        if (!this.isEditMode) {
            return;
        }
        
        // Maximum number of rows = 10
        this.addRowButton.addEvent("click", function (e) {
            var numOfRows = _this.getNumOfRows();

            if (numOfRows < _this.maxRows) {
                _this.addRow(numOfRows);
            } else {
                console.log('Max ' + _this.maxRows + ' rows reached. Refactor to throw alert.');
            }
        }.bind(this));

        // Maximum number of columns = 4
        this.addColumnButton.addEvent("click", function (e) {
            var NumOfColumns = _this.getNumOfColumns();

            if (NumOfColumns < _this.maxColumns) {
                _this.addColumn(NumOfColumns);
            } else {
                console.log('Max ' + _this.maxColumns + ' columns reached. Refactor to throw alert.');
            }
        }.bind(this));
    },
    editorContentChange: function (e) {
        this.saveEntry($$(".MetrodigiWidget")[0]); // NOTE: During the save procedure, this is the second-to-outer-most scope.
    },
    watchForChanges: function (elToBind) {
        var _this = this;

        // Consider refactoring so this code is DRY.
        if (elToBind) {
            var el = elToBind;
            var intTimerID = null;
            el.setAttribute('contenteditable', true);
            el.addEvent("change", _this.editorContentChange.bind(_this));
            el.addEvent("paste", _this.editorContentChange.bind(_this));
            el.addEvent("keyup", function (ev) {
                if (intTimerID != null) {
                    clearTimeout(intTimerID);
                }
                intTimerID = setTimeout(function () {
                    _this.editorContentChange(ev); // NOTE: During the save procedure, this is the outer-most scope.
                }, 500);
            });
        } else { // initial binding
            $$('[data-md-editable]').each(function (el) {
                var intTimerID = null;
                el.setAttribute('contenteditable', true);
                el.addEvent("change", _this.editorContentChange.bind(_this));
                el.addEvent("paste", _this.editorContentChange.bind(_this));
                el.addEvent("keyup", function (ev) {
                    if (intTimerID != null) {
                        clearTimeout(intTimerID);
                    }
                    intTimerID = setTimeout(function () {
                        _this.editorContentChange(ev); // NOTE: During the save procedure, this is the outer-most scope.
                    }, 500);
                });
            });
        }

        $$("div.deletecolumn:not(.binded)").each(function(e){
            e.addEvent("click",function(ev){
                //get column index
                var index = $("tablebody").getElements("tr.rowheader td").indexOf(e.getParent());
                //$("tablebody").getElements("tr td:nth-child("+index+")").disponse();
                $("tablebody").getElements("tr td:nth-child("+(index+1)+")").each(function(column){
                   column.dispose();
                });
                //this.table
                _this.table.dataset.numberOfColumns--;
                _this.saveEntry(null);

            });
            e.addClass("binded");
        });

    }, // end watchForChanges
    registerWidgetOnParentFrame: function () {
        var _this = this;
        this.parentWindow = this.parentFrame.window;

        this.parentWindow.widgetInstance = {
            document: document,
            instance: _this
        };
    },
    render: function () {

    }, // end render()
    saveEntry: function (entry) {
        /************
         * Save the DOM elements
         * Save routes: metrodigi-widget.js has "saveRequestProcedure" notes.
         * this.options.container = #entries
         ***********/
//        var entriesDiv = this.options.container;
        var entriesDiv = this.tableDragSection.clone(true,true);
        entriesDiv.getElements(".addbutton").dispose();
        entriesDiv.getElements(".deletecolumn").dispose();
        entriesDiv.getElements('[contenteditable="true"]').set("contenteditable",null);
        var widgetContent = entriesDiv.get("html");
        var requestContentObject = {
//            selector: "#entries",
            selector: "#tabledrag-wrapper",
            html: widgetContent
        };

        var thisSaveRequest = {
            method: "setHTML",
            content_set: [requestContentObject]
        };

        this.saveRequestProcedure(entriesDiv, thisSaveRequest);
    }, // end saveEntry(entry)
    updateEditMode: function () {
        var _this = this;
        _this.editModeDiv = this.parentFrame.$('.edit-widget'); // the "edit mode" div OUTSIDE the <iframe>
        
        if (!this.isEditMode) {
            _this.options.container.getElements("[contenteditable]").removeProperty("contenteditable");
        }
    },
    postMessageReceived: function(message, path) {
        var that = this;

        switch(message.data.method){
            case "add-row":
            var numOfRows = that.getNumOfRows();
            that.addRow(numOfRows);
            break;
            case "add-column":
            var NumOfColumns = that.getNumOfColumns();
            that.addColumn(NumOfColumns);
            break;
            case "columns-height":
                var height = message.data.height;                
                
                this.saveRequestProcedure(null, {
                    method:"attr",
                    selector:"#tabledrag-wrapper",
                    attributes:{
                        'md-quiz-columns-height':height
                    }
                    
                });
                break;
            case "columns-width":
                var widths = "";
                Array.each(message.data.columns,function(w){
                    widths += w + ";" ;
                });
                
                this.saveRequestProcedure(null, {
                    method:"attr",
                    selector:"#tabledrag-wrapper",
                    attributes:{
                        'md-quiz-columns-widths':widths
                    }
                    
                });
                break;
            case "quiz-colmun-change":
                this.saveRequestProcedure(null, {
                    method:"attr",
                    selector:"#tabledrag-wrapper",
                    attributes:{
                        'md-quiz-column':message.data.column
                    }
                    
                });
                $("tabledrag-wrapper").set("md-quiz-column",message.data.column);
                break;
            default:
                // console.warn('md-widget Unknown message', message);
        }
    },
}); // end TableDragGUI() Class



var QuizAppWithVoiceAsyncAccessibilityEvent = new Class({
    Extends: QuizApp,
    initialize: function (container) {
        var asyncVoiceEl = new Element('div');
        asyncVoiceEl.set("id", "asyncVoiceEl").set("role", "alert").set("aria-live", "polite").setStyles({
            "clip": "rect(0px,0px,0px,0px)",
            "position": "absolute",
            "top": "-1000%",
            "left": "-1000%"
        });
        new Element('span').set("id", "asyncVoiceEl-add").inject(asyncVoiceEl);
        asyncVoiceEl.inject(container, 'after');

        var p = this.parent(container);
        var _this = this;
        this.quiz.addEvent("answerCorrect", function (e, i) {
            container.fireEvent("answerChange");
            setTimeout(function () {
                if (container.getElement(".accessibility-message") != null)
                    _this.asyncVoice("New Term: " + container.getElement(".accessibility-message").get("text"));
            }, 725);
        });

        this.quiz.addEvent("quizEnd", function (e, i) {
            setTimeout(function () {
                _this.asyncVoice(container.getElement(".note.title").get("text"));
            }, 725);
        });
    },
    initAccessibility: function () {
        this.parent();
        var _this = this;

        this.accessibility_button.addEvents({
            'click': function () {
                if (!_this.el.hasClass('accessibility-off')) {
                    _this.accessibility_button.fireEvent('AccessibilityStateChange', {
                        state: true
                    });
                    _this.asyncVoice("New Term: " + _this.el.getElement(".accessibility-message").get("text"));
                } else {
                    _this.accessibility_button.fireEvent('AccessibilityStateChange', {
                        state: false
                    });
                }

            }
        });
    },
    asyncVoice: function (txt) {
        elem1 = document.getElementById("asyncVoiceEl-add");
        //set role attribute on inner element
        elem1.setAttribute("role", "alert");
        elem1.setAttribute("aria-live", "polite");
        //change initial clip property to auto
        document.getElementById('asyncVoiceEl').style.clip = 'auto';
        // create and append the text node
        alertText = document.createTextNode(txt);
        elem1.appendChild(alertText);
        //toggle visibility from visible to hidden and back again
        elem1.style.visibility = 'hidden';
        elem1.style.visibility = 'visible';
    }
});