'use strict';

var TableDragAndDrop = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
        elements: []
    },

    initialize: function(options) {
        var that = this;

        this.parent({
            container: options.container
        });
        this.render();

        that.container.getElements('[contenteditable=true]').set('contenteditable', false);
    },

    render: function(){
        var that = this,
            key_column = +that.container.getElement("#content").get("data-key-column");

        that.container.getElements("thead th:nth-child(" + (key_column+1) + ")").addClass("key");
        that.container.getElements("tbody td:nth-child(" + (key_column+1) + ")").addClass("key");

        that.container.getElement(".check-understanding").addEvent("click", that.initActivity.bind(that));
        that.container.getElement(".reset").addEvent("click", that.resetActivity.bind(that));

        that.calculateHeight();

        if(that.isEditMode){
            window.onload = (function() {
                parent.postMessage({
                    state: 'update-complete'
                }, "*");
            });
        }
    },

    initActivity: function(event){
        var that = this;
        that.container.set("data-stage", "activity");

        that.calculateHeight();

        if(!that.isEditMode){
            var $content = that.container.getElement(".widget-content"),
                width = 0,
                restore = function(element){
                    element.morph({top: 0, left: 0}, 500);
                },
                show_alert = function(status){
                    var $alert = that.container.getElement(".alert"), text;

                    if(status === "incorrect"){
                        text = "Incorrect. Try again!";
                    }
                    else{
                        text = "Correct!";
                    }

                    $alert.set("html", text).addClass(status).setStyles({opacity: 1});

                    that.timer = setTimeout(function(){
                        var t = 300;
                        $alert.morph({opacity: 0}, t);
                        setTimeout(function(){
                            $alert.removeClass("correct").removeClass("incorrect").set("html", "&nbsp;");
                        }, t);
                    }, 1000);
                };
            that.answers = [];
            that.total_answers = 0;

            that.container.getElements("tbody td.key").each(function(obj, i){
                that.answers.push({
                    i: i,
                    text: obj.get("html"),
                    first_try: true
                });
                obj.set("data-answer", i).set("html", "").addClass("droppable");
                width = obj.getSize().x;
            });
            that.answers = that.shuffle(that.answers);
            that.total_answers = that.answers.length;
            that.correct_answers = 0;

            if(that.container.getElement("#answers-container"))
                that.container.getElement("#answers-container").dispose();

            new Element("div", {
                    id: "answers-container"
                })
                .inject($content)
                .setStyle("width", width);

            for(var i = 0; i < that.total_answers; i++){
                var element = new Element("div", {
                        "data-answer": that.answers[i].i,
                        "class": "answer draggable",
                        "html": that.answers[i].text
                    })
                    .setStyle("display", i?"none":"block")
                    .setStyle("width", width - 20 /* this is because of the padding */);
                element.inject($content.getElement("#answers-container"));
            }

            that.container.getElements('.answer.draggable').makeDraggable({
                droppables: 'td.key.droppable',
                onDrop: function(element, droppable, event){
                    if (!droppable) restore(element);
                    else{
                        if (element.get("data-answer") === droppable.get("data-answer")){
                            droppable.removeClass("droppable").set("data-answer", null).set("html", element.get("html"));
                            element.removeClass("grabbing").dispose();
                            for(var i = 0; i < that.answers.length; i++){
                                if (+that.answers[i].i === +element.get("data-answer")){
                                    if(that.answers[i].first_try){
                                        that.correct_answers++;
                                    }
                                    that.answers.splice(i,1);
                                }
                            }
                            if(that.answers.length){
                                show_alert("correct");
                                that.container.getElement("#answers-container .answer:nth-child(1)").setStyle("display", "block");
                            }
                            else{
                                that.container.set("data-stage", "results");
                                that.container.getElement('.results-header').set('html', new Score(that.total_answers, that.correct_answers).getMessage());
                            }
                        }
                        else{
                            for(var i = 0; i < that.answers.length; i++){
                                if (+that.answers[i].i === +element.get("data-answer")){
                                    that.answers[i].first_try = false;
                                }
                            }
                            show_alert("incorrect");
                            restore(element);
                        }
                    }
                    element.removeClass("grabbing");
                },
                onStart: function(element){
                    element.addClass("grabbing");
                },
                onCancel: function(element){
                    element.removeClass("grabbing");
                }
            });
        }
    },

    //https://stackoverflow.com/questions/2450954/how-to-randomize-shuffle-a-javascript-array
    shuffle: function (array) {
        var currentIndex = array.length, temporaryValue, randomIndex;

        // While there remain elements to shuffle...
        while (0 !== currentIndex) {

            // Pick a remaining element...
            randomIndex = Math.floor(Math.random() * currentIndex);
            currentIndex -= 1;

            // And swap it with the current element.
            temporaryValue = array[currentIndex];
            array[currentIndex] = array[randomIndex];
            array[randomIndex] = temporaryValue;
        }

        return array;
    },

    resetActivity: function(event){
        var that = this;
        that.container.set("data-stage", "main");

        that.calculateHeight();

        if(!that.isEditMode){
            for(var i = 0; i < that.answers.length; i++){
                that.container.getElement("td[data-answer='" + that.answers[i].i + "']")
                    .set("html", that.answers[i].text)
                    .removeClass("droppable")
                    .removeAttribute("data-answer");
            }
            that.answers = [];
            that.total_answers = 0;
            that.correct_answers = 0;

            that.container.getElement("#answers-container").dispose();
        }
    },

    bindEditMode: function() {
        var that = this;

        if(parent && parent!=window) {
            var titles = [];

            $$("body").addClass("editmode");

            that.container.getElements('[contenteditable]').set('contenteditable', "").each(function(obj){
                obj.set("old-value", obj.get("html"));
            });

            that.container.getElements('thead tr').each(function(obj, i){
                obj.getElements("th").each(function(obj, j){
                    var width = obj.get("width") || "";

                    titles[j] = obj
                        .addEvent("blur", that.editorTextChange.bind(that))
                        .set("selector", "thead tr:nth-child(" + (i+1) + ") th:nth-child(" + (j+1) + ")")
                        .set("index", j+1)
                        .removeProperty("width")
                        .setStyle("width", width)
                        .get("text");
                })
            });
            that.container.getElements('tbody tr').each(function(obj, i){
                obj.getElements("td").each(function(obj, j){
                    obj
                        .addEvent("blur", that.editorTextChange.bind(that))
                        .set("selector", "tbody tr:nth-child(" + (i+1) + ") td:nth-child(" + (j+1) + ")");
                })
            });

            that.container.getElements('[contenteditable]').each(function(obj, i){
                if(obj.get("data-md-editable"))
                    obj.addEvent("blur", that.editorTextChange.bind(that)).set("selector", obj.get("data-md-editable"));
            });

            // jquery library and resizableColumns plugin added for table columns functionality
            Asset.javascript('../_framework/tabledrag-v3/jquery.min.js', {
                id: 'jquery',
                onLoad: function(){
                    Asset.css('../_framework/tabledrag-v3/jquery.resizableColumns.css', {
                        id: 'resize_css',
                        onLoad: function(){
                            Asset.javascript('../_framework/tabledrag-v3/jquery.resizableColumns.min.js', {
                                id: 'resize_js',
                                onLoad: function(){
                                    jQuery("#content").resizableColumns({
                                        store:null,
                                        stop: function(event,opt,left,right,left_width,right_width){
                                            that.saveRequestProcedure(null, {
                                                method: 'attr',
                                                selector: left[0].get("selector"),
                                                attributes: {
                                                    width: left_width + "%"
                                                }
                                            }, null, function(data) {
                                                that.saveRequestProcedure(null, {
                                                    method: 'attr',
                                                    selector: right[0].get("selector"),
                                                    attributes: {
                                                        width: right_width + "%"
                                                    }
                                                }, null, function(data) { });
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });

            parent.postMessage({
                method:'initial-load',
                caption: that.container.getElement("caption").get("html"),
                rows: +that.container.getElement("#content").get("data-rows"),
                columns: +that.container.getElement("#content").get("data-columns"),
                titles: titles,
                key_column: +that.container.getElement("#content").get("data-key-column")
            }, "*");
        }
    },

    customPostMessages: function() {

    },

    editorTextChange: function(event){
        var that = this,
            value = event.target.get("html");

        if(value !== event.target.get("old-value")){
            that.saveRequestProcedure(null, {
                method: 'setHTML',
                content_set:[{
                    selector: event.target.get("selector"),
                    html: value
                }]
            }, null, function(data) {
                event.target.set("old-value", value);
                if ( event.target.get("selector") === "caption" ){
                    parent.postMessage({
                        method:'update-caption',
                        state: 'update-complete',
                        caption:  value
                    }, "*");
                }
                else if ( event.target.get("selector").indexOf("th") >= 0 ){
                    parent.postMessage({
                        method:'update-column-title',
                        state: 'update-complete',
                        index: event.target.get("index"),
                        title:  value
                    }, "*");
                }
            });
        }
    },
    calculateHeight: function(){
        var that = this,
            widget_content_height = this.container.parentElement.parentElement.getSize().y - this.container.getElement(".widget-header").getSize().y - this.container.getElement(".widget-footer").getSize().y;
        that.container.getElement(".widget-content").setStyles({height: widget_content_height});
    },
    postMessageReceived: function(message) {
        var that = this,
            _td = '<td contenteditable="true" tabindex="1"></td>',
            rows = +that.container.getElement("#content").get("data-rows"),
            columns = +that.container.getElement("#content").get("data-columns"),
            update_current_dom = function(data){
                if(that.container.getElement(data.selector))
                    that.container.getElement(data.selector).set(data.data, data.value);
            },
            change_data = function(data, value, fn){
                var attributes = {}, selector = "#content";
                attributes[data] = value;

                update_current_dom({selector: selector, data: data, value: value});
                that.saveRequestProcedure(null, {
                    method: 'attr',
                    selector: selector,
                    attributes: attributes
                }, null, function() {
                    if(fn) fn();
                    else document.location.reload();
                });
            };

        switch (message.data.method) {
            case "change-rows":
                var rows_sent = +message.data.rows_count;

                if(rows_sent > rows){
                    var td = "", w = 100 / (columns?columns:1);
                    for (var i = 0; i < columns; i++){
                        if (!rows && columns > 0){
                            td += '<th contenteditable="true" width="' + w + '%" tabindex="1">Column ' + (i+1) + '</th>';
                        }
                        else{
                            td += _td;
                        }
                    }
                    that.saveRequestProcedure(null, {
                        method: 'appendHtml',
                        content_set:[{
                            target: rows === 0 ? "thead" : "tbody",
                            html: '<tr>' + td + '</tr>'
                        }]
                    }, null, function() {
                        change_data("data-rows", rows+1, rows_sent > rows+1 ? function(){
                            that.postMessageReceived(message);
                        } : null);
                    });
                }
                else{
                    that.saveRequestProcedure(null, {
                        method: 'rm',
                        target: rows === 1 ? "thead tr" : "tbody tr:last"
                    }, null, function() {
                        change_data("data-rows", rows-1, rows_sent < rows-1 ? function(){
                            that.postMessageReceived(message);
                        } : null);
                    });
                }
                break;

            case "add-column":
                var selector = "thead tr th:nth-child(" + (columns) + ")",
                    width = (Math.round(parseFloat(that.container.getElement(selector).getStyle("width")) * 50) / 100) + "%";

                that.saveRequestProcedure(null, {
                    method: 'attr',
                    selector: selector,
                    attributes: {
                        "width" : width
                    }
                }, null, function(data) {
                    that.saveRequestProcedure(null, {
                        method: 'appendHtml',
                        content_set:[{
                            target: 'thead tr',
                            html: '<th contenteditable="true" width="' + width + '">Column ' + (columns + 1) + '</th>'
                        }]
                    }, null, function(data) {
                        var check_rows = function (rows, columns){
                            if(rows > 1){
                                var append = function(i){
                                        that.saveRequestProcedure(null, {
                                            method: 'appendHtml',
                                            content_set:[{
                                                target: 'tbody tr:nth-child(' + (i+1) + ')',
                                                html: _td
                                            }]
                                        }, null, function(data) {
                                            if(i < rows){
                                                append(i+1);
                                            }
                                            else{
                                                change_data("data-columns", columns+1);
                                            }
                                        });
                                    };
                                append(0);
                            }
                            else{
                                change_data("data-columns", columns+1);
                            }
                        };
                        if(!columns){
                            change_data("data-key-column", columns, function(){
                                check_rows(rows, columns);
                            });
                        }
                        else{
                            check_rows(rows, columns);
                        }
                    });
                });
                break;

            case "change-key-column":
                change_data("data-key-column", message.data.column);
                break;

            case "remove-column":
                var selector = function(index, td){
                        return (td?"tbody":"thead") + " tr " + (td?"td":"th") + ":nth-child(" + (+index+1) + ")";
                    },
                    rm = function(index){
                        that.saveRequestProcedure(null, {
                            method: 'rm',
                            target: selector(index)
                        }, null, function() {
                            that.saveRequestProcedure(null, {
                                method: 'rm',
                                target: selector(index, true)
                            }, null, function() {
                                var key = +that.container.getElement("#content").get("data-key-column");
                                if ( columns-1 === key){
                                    change_data("data-key-column", columns-2, function(){
                                        change_data("data-columns", columns-1);
                                    });
                                }
                                else if ( key > 0  && key - 1 === index){
                                    change_data("data-key-column", key - 1, function(){
                                        change_data("data-columns", columns-1);
                                    });
                                }
                                else{
                                    change_data("data-columns", columns-1);
                                }
                            });
                        });
                    },
                    new_width = function(index, width){
                        return width + Math.round(parseFloat(that.container.getElement(selector(index)).getStyle("width")) * 100) / 100
                    },
                    width = Math.round(parseFloat(that.container.getElement(selector(message.data.index)).getStyle("width")) * 50) / 100;

                if ( +message.data.index === 0 || +message.data.index+1 === columns){
                    that.saveRequestProcedure(null, {
                        method: 'attr',
                        selector: +message.data.index === 0 ? selector(1) : selector(+message.data.index-1),
                        attributes: {
                            width: new_width(+message.data.index === 0 ? 1 : +message.data.index-1, width*2) + "%"
                        }
                    }, null, function(data) {
                        rm(message.data.index);
                    });
                }
                else {
                    that.saveRequestProcedure(null, {
                        method: 'attr',
                        selector: selector(+message.data.index-1),
                        attributes: {
                            width: new_width(+message.data.index-1, width) + "%"
                        }
                    }, null, function(data) {
                        that.saveRequestProcedure(null, {
                            method: 'attr',
                            selector: selector(+message.data.index+1),
                            attributes: {
                                width: new_width(+message.data.index+1, width) + "%"
                            }
                        }, null, function(data) {
                            rm(message.data.index);
                        });
                    });
                }

                break;
            case "change-caption":
                that.saveRequestProcedure(null, {
                    method: 'setHTML',
                    content_set:[{
                        selector: "caption",
                        html: message.data.caption
                    }]
                }, null, function(data) {
                    document.location.reload();
               });
        }
    }
});