/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
 */
'use strict';
/*global $: true, $$: true*/
/*
var state = function (e, i) { $$('.container')[0].dataset.show = i.get('data-id') };

window.onload = (function() {
    document.body.addEvent('click:relay(.tabButton)', state);
});
*/
//fa fa-pencil
//fa fa-times
//fa fa-plus
//fa fa-save
//fa fa-check

var TabGallery = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
    },
    widgetMode: "0",

    initialize: function(options) {
        var that = this;
        document.widgetType = 'tabsAccordion';
        //map audio and videos
        if($$('[data-md-editable="md-placeholder-audio"]').length > 0 ){
            $$('[data-md-editable="md-placeholder-audio"]').forEach(function(audioEditable){
                if( audioEditable.getElement('iframe') && /(\.mp3|\.mp4)$/g.test(audioEditable.getElement('iframe').get('src')) ){
                    //audioEditable.getElement('iframe').set('data-src', audioEditable.getElement('iframe').get('src'))
                    var source = audioEditable.getElement('iframe').get('src');
                    var format = /(\.mp3|\.mp4)$/g.exec(source)[0];
                    audioEditable.getElement('iframe').set('src', '');
                    audioEditable.getElement('iframe').hide();

                    //new Element('div.iframe-media-lazy-load[tabindex="0"]',{html:'<span>Click to load the media.</span>', 'aria-label': 'Press enter to enable the media.'}).inject( audioEditable.getElement('iframe') ,"after");
                    new Element('audio[controls].audio-element', {html: '<source src="'+source+'">'}).inject(audioEditable.getElement('iframe'),'after');
                    audioEditable.addClass('md-placehorder-audio-element');
                }
            });
        }

        if($$('[data-md-editable="md-placeholder-video"]').length > 0 ){
            $$('[data-md-editable="md-placeholder-video"]').forEach(function(videoEditable){
                if( videoEditable.getElement('iframe') && /(\.avi|\.mpeg|\.mpg|\.mp3|\.mp4)$/g.test(videoEditable.getElement('iframe').get('src')) ){
                    //audioEditable.getElement('iframe').set('data-src', audioEditable.getElement('iframe').get('src'))
                    var source = videoEditable.getElement('iframe').get('src');
                    var format = /(\.mp3|\.mp4)$/g.exec(source)[0];
                    videoEditable.getElement('iframe').set('src', '');
                    videoEditable.getElement('iframe').hide();

                    //new Element('div.iframe-media-lazy-load[tabindex="0"]',{html:'<span>Click to load the media.</span>', 'aria-label': 'Press enter to enable the media.'}).inject( audioEditable.getElement('iframe') ,"after");
                    new Element('video[controls].video-element', {html: '<source src="'+source+'">'}).inject(videoEditable.getElement('iframe'),'after');
                    videoEditable.addClass('md-placehorder-video-element');
                }
            });
        }
        

        // Disable contenteditables
        $$('[contenteditable=true]').set('contenteditable', false);

        this.parent({
            container: options.container,
            itemTemplate: options.itemTemplate
        });
        var state = function(e, i) {
            $$('.container')[0].dataset.show = i.get('data-id');
        };
        document.body.addEvent('click:relay(.tabButton)', state);
        this.render();
        this.customResize();
        this.checkMedia();
        this.bindLazyLoadPlaceholder();

        if(/iPhone/.test(navigator.userAgent)) {
            $$('.MetrodigiWidget').addClass('iPhone6')
        }
        this.stopAudios();

        $$('.tab-accordion-entry iframe').set('tabindex', '0');
        $$('.tab-title').each(function (el) {
            el.set('aria-label', el.textContent)
        });
    },
    checkMedia: function(){
        var that = this;
        //Check if the place-holder-'type' exist
        //If not, create them dynamically but not safe
        if(!this.isEditMode)
            return;
        var length = $$('.data-md-editable.md-data-set-item').length-1;
        $$('.data-md-editable.md-data-set-item').each(function(e, i){
            if(i != length){
                if(!e.getElement('*[data-md-editable="md-placeholder-video"]')){
                    e.appendHTML('<div class="md-placeholder" data-md-editable="md-placeholder-video"><span class="md-placeholder-caption">Click to place an embedded video</span></div>', 'top');
                }else{
                    if(e.getElement('*[data-md-editable="md-placeholder-video"]').getElement('iframe') == null){
                        that.saveRequestProcedure(null, {
                            method: 'rm',
                            target: '.tab-content:nth-child(' + (i + 1) + ') [data-md-editable="md-placeholder-video"]'
                        }, null, function(data){
                            window.location.reload();
                        });
                    }
                }
                if(!e.getElement('*[data-md-editable="md-placeholder-audio"]')){
                    e.appendHTML('<div class="md-placeholder" data-md-editable="md-placeholder-audio"><span class="md-placeholder-caption">Click to place an embedded audio</span></div>', 'top');
                }else{
                    if(e.getElement('*[data-md-editable="md-placeholder-audio"]').getElement('iframe') == null){
                        that.saveRequestProcedure(null, {
                            method: 'rm',
                            target: '.tab-content:nth-child(' + (i + 1) + ') [data-md-editable="md-placeholder-audio"]'
                        }, null, function(data){
                            window.location.reload();
                        });
                    }
                }
                if(!e.getElement('*[data-md-editable="md-placeholder-image"]')){
                    e.appendHTML('<div class="md-placeholder" data-md-editable="md-placeholder-image"><span class="md-placeholder-caption">Click to place an image</span></div>', 'top');
                }else{
                    if(e.getElement('*[data-md-editable="md-placeholder-image"]').getElement('img') == null){
                        that.saveRequestProcedure(null, {
                            method: 'rm',
                            target: '.tab-content:nth-child(' + (i + 1) + ') [data-md-editable="md-placeholder-image"]'
                        }, null, function(data){
                            window.location.reload();
                        });
                    }
                }
                if(e.getElement('*[data-md-editable="md-content-editable-element"]').get('html') == ''){
                    e.getElement('*[data-md-editable="md-content-editable-element"]').set('html','Enter content (optional)');
                }else if(e.getElement('*[data-md-editable="md-content-editable-element"]').get('html') == 'The Content'){
                    that.saveRequestProcedure(null, {
                        method: 'mdSetAttribute',
                        selector: '.tab-content:nth-child(' + (i + 1) + ') [data-md-editable="md-content-editable-element]',
                        attribute: 'html',
                        value: ''
                    }, null, function(data){
                        window.location.reload();
                    });
                }
            }
        });

    },
    bindLazyLoadPlaceholder: function(){
        if($$('.iframe-media-lazy-load').length > 0){
            $$('.iframe-media-lazy-load').forEach(function(lazyLoadEl) {
                lazyLoadEl.addEvent('click', function(e){
                    var entry = e.target.getParents('.tab-accordion-entry')[0];
                    if( entry.getElement('iframe') ){
                        entry.getElement('iframe').set('src', entry.getElement('iframe').get('data-src'));
                        entry.getElement('.iframe-media-lazy-load').dispose();
                    }
                });

                lazyLoadEl.addEvent('keypress', function(e){
                    if(e.key != 'enter' && e.key != 'space') return;
                    var entry = e.target.getParents('.tab-accordion-entry')[0];
                    if( entry.getElement('iframe') ){
                        entry.getElement('iframe').set('src', entry.getElement('iframe').get('data-src'));
                        entry.getElement('.iframe-media-lazy-load').dispose();
                    }
                });
            });
        }
    },
    afterInitialize: function() {
        var that = this;

        if (this.container.get("data-mode") != null && this.container.get("data-mode") != "") {
            this.widgetMode = this.container.get("data-mode");
        }

        $$("body").addClass("widget-mode-" + this.widgetMode);

        if(that.widgetMode==1) {
            this.bindAccordionMode();
        } else {
            this.bindTabMode();
        }

        if($('tabs-nav').getElements('> div').length > 0){
            $('tabs-nav').getElements('> div').forEach(function(item){
                item.set('role', 'button');
            });
        }

        if ($$(".tab-accordion-entry").length > 0) {
            setTimeout(function() {
                that.bindEvents();
                if (that.widgetMode == 0)
                    if ($$(".header .tab-title").length > 0)
                        $$(".header .tab-title")[0].click();
            }, 0);
        }

        $$('.tab-accordion-entry').each(function(el, index){

                if(el.getElement('*[contenteditable="false"]').get('html') == 'Enter content (optional)'){
                    el.getElement('*[contenteditable="false"]').set('html', '');
                }

        });
        if (!this.isEditMode) {
            var tabsArray=[];
            //Accessibility
            var titleSelector = '.tab-title';
            if (this.widgetMode == 1) { //accordion
                titleSelector = '.tab-entry-title';
            }
            console.log(titleSelector, this.container.getElements(titleSelector))
            this.container.getElements(titleSelector).each(function (entry, index){
                //entry.setAttribute('tabindex', 0);
                entry.addEvent('keydown', function (e){
                    var key= e.key || e.which;
                    if (key == 'enter' || key == 'space') {
                        e.target.click();
                        that.accessibilityTab(e);
                    }

                })
            })
            document.addEvent('keyup', function (e){
                var keyCode = e.key || e.which;
                if (keyCode == "tab") {
                    if( $$("*:focus")[0].tagName == "BUTTON"){
                        that.container.getElements(titleSelector).each(function (entry, index){
                            if( entry.hasClass("active") ){
                                if(typeof $$(titleSelector)[index + 1] != "undefined"){
                                   $$(titleSelector)[index + 1].focus();
                                }
                            }
                            $$(".non-keyboard-outline").each(function (item){
                                if(item != document.activeElement){
                                    item.removeClass("non-keyboard-outline");
                                }
                            });
                        })
                    }
                }
            });
            document.addEvent('click', function (e){
                $$(".non-keyboard-outline").removeClass("non-keyboard-outline");
            });
            this.container.getElements('.tab-accordion-entry').each(function (entry, index){
                //entry.setAttribute('tabindex', '0');
            });
            this.container.getElements('.tab-content img').each(function (img, index){
                //img.setAttribute('tabindex', 0);
            });
            this.container.getElements('.tab-content .data-md-editable[data-md-editable="md-content-editable-element"]').each(function (text, index){
                //text.setAttribute('tabindex', 0);
            });
            this.container.getElements('.tab-content .md-placeholder[data-md-editable="md-placeholder-video"] iframe').each(function (text, index){
                //text.setAttribute('tabindex', 0);
            });
            this.container.getElements('.tab-content .md-placeholder[data-md-editable="md-placeholder-audio"] iframe').each(function (text, index){
                //text.setAttribute('tabindex', 0);
            });

            this.container.getElements('div.data-md-editable').each(function(e, i){
                if (e.hasAttribute('contenteditable')){
                    e.set('html', '<p>'+e.get('html')+'</p>');
                    e.getElements('div').each(function(el, i) {
                        if (el.get('text').length <= 0 || (el.get('html').trim() == '<br>' || el.get('html').trim() == '<br/>')) {
                            el.remove();
                        } else {
                            new Element('p', {html: el.get('html')}).replaces(el);
                        }
                    });
                    if (e.getElement('p:last-child').get('text').length <= 0){
                        e.getElement('p:last-child').remove();
                    }
                }
            });

            this.container.getElements('.tab-entry-title').each(function(e, i){
                e.set({
                    role: 'link',
                    tabindex: 0
                })
            });
        }
    },
    accessibilityTab: function(e) {
        e.preventDefault();
        e.stopPropagation();

        if(typeof $$(".tab-accordion-entry.active img")[0] != "undefined")
        {
            $$(".tab-accordion-entry.active img")[0].focus();
            $$(".tab-accordion-entry.active img")[0].addClass("non-keyboard-outline");
        }else{
            if(typeof $$(".tab-accordion-entry.active .md-placeholder[data-md-editable='md-placeholder-video'] iframe")[0] != "undefined")
            {
                $$(".tab-accordion-entry.active .md-placeholder[data-md-editable='md-placeholder-video'] iframe")[0].focus();
                $$(".tab-accordion-entry.active .md-placeholder[data-md-editable='md-placeholder-video'] iframe")[0].addClass("non-keyboard-outline");
            }else{
                if(typeof $$(".tab-accordion-entry.active .md-placeholder[data-md-editable='md-placeholder-audio'] iframe")[0] != "undefined")
                {
                    $$(".tab-accordion-entry.active .md-placeholder[data-md-editable='md-placeholder-audio'] iframe")[0].focus();
                    $$(".tab-accordion-entry.active .md-placeholder[data-md-editable='md-placeholder-audio'] iframe")[0].addClass("non-keyboard-outline");
                }else{
                    if(typeof $$(".tab-accordion-entry.active .data-md-editable[data-md-editable='md-content-editable-element']")[0] != "undefined")
                    {
                        $$(".tab-accordion-entry.active .data-md-editable[data-md-editable='md-content-editable-element']")[0].focus();
                        $$(".tab-accordion-entry.active .data-md-editable[data-md-editable='md-content-editable-element']")[0].addClass("non-keyboard-outline");
                    }
                }
            }

        }

    },
    bindEditMode: function() {
        if (this.container.get("data-mode") != null && this.container.get("data-mode") != "") {
            this.widgetMode = this.container.get("data-mode");
        }

        $$("body").addClass("widget-mode-" + this.widgetMode);
        if (parent && parent != window) {
            parent.postMessage({
                method: "settings-widget-mode",
                widget_mode: this.widgetMode
            }, "*");
        }

        var that = this;

        $$("body").addClass("editmode");

        // Enable contenteditables
        $$('[contenteditable]').set('contenteditable', true);

        var addAnotherButton = new Element("button.add-another-entry-button", {
            html: "<span class='fa fa-plus'></span>&#160;" + (this.widgetMode == 0 ? "NEW TAB" : "NEW ACCORDION PANEL")
        });
        addAnotherButton.addEvent("click", this.addAnotherItemClickEventListener.bind(this));

        if (this.widgetMode == 0) {
            addAnotherButton.inject($$(".widget-body .header")[0]);
            this.prePopulateTabs();
            $$(".tab-accordion-entry .tab-entry-title").dispose();

            if ($$(".tab-accordion-entry").length > 0) {
                setTimeout(function() {
                    that.bindEvents();
                    $$(".header .tab-title")[0].click();
                }, 0);
            }
        } else {
            addAnotherButton.inject(this.container, "after");
            this.prePopulateTabs();
            if ($$(".tab-accordion-entry").length > 0) {
                setTimeout(function() {
                    that.bindEvents();
                    $$(".tab-accordion-entry")[0].addClass("active");
                }, 0);
            }
        }
    },
    bindAccordionMode:function(){
        var that = this;

        $$(".tab-accordion-entry").each(function(el, index){
            var tab_entry_title = new Element("div.tab-entry-title",{
                html:"<span>"+$$("#tabs-nav .tab-title")[index].getElement("span").get("html")+"</span>"
            });

            tab_entry_title.inject(el,"top");

            if (index === 0) {
                el.addClass("active");

                if (!that.isEditMode) {
                    that.clearTimersOnUserInteraction(function (timers) {
                        timers.push(setTimeout(function () {
                            el.getElement('.data-md-editable.md-data-set-item').set('tabindex', -1).focus();
                        }, 100));
                    });
                }
            }

            el.getElement(".tab-entry-title").addEvent("click",function(){
                var self = this;
                if(this.getParent(".tab-accordion-entry").hasClass("active")){

                }
                else {
                    $$(".tab-accordion-entry").removeClass("active");
                    this.getParent(".tab-accordion-entry").addClass("active");
                    setTimeout(function(){
                        $(self).getSiblings('div')[0].set('tabindex', -1).focus();
                    }, 100);
                }
            });
        });
    },
    bindTabMode: function() {
        var that = this;
        $$(".header .tab-title").each(function(e, i) {
            if(i == 0){
                e.addClass("active");
                // TODO: focus first panel
            }
            e.addEvent("click", that.changeTabClickEventListener.bind(that));
        });
    },
    prePopulateTabs: function() {
        var that = this;

        if(that.widgetMode==1){
            this.bindAccordionMode();
        }

        $$('#tabs-nav > div,.tab-accordion-entry .tab-entry-title').each(function(el, i) {
            new Element('div.fa.fa-times.delete', {
                title: 'Delete Entry'
            }).inject(el);
            el.set('data-index', i);
        });

        $$('#tabs-content > div').each(function(el, i) {
            var intTimerID = null;
            el.getElement('*[contenteditable="true"]').addEvent("change", that.editorTabTitleChange.bind(that));
            // el.getElement('*[contenteditable="true"]').addEvent("paste", that.editorTabTitleChange.bind(that));
            // el.getElement('*[contenteditable="true"]').addEvent("keyup", function(ev) {
            //     //if ctrl + c or ctrl + v copy/paste
            //     if(typeof(ev) == 'undefined')
            //         return;
            //
            //     if(ev.code == 91)
            //         return;
            //
            //     if (intTimerID != null) {
            //         clearTimeout(intTimerID);
            //     }
            //     intTimerID = setTimeout(function() {
            //         that.editorTabTitleChange(ev);
            //     }, 500);
            // });
            if(el.getElement('*[contenteditable="true"]')){
                var a = $$(el)[0].get('html');
                var b = a;
                setInterval(function(){
                    a = $$(el)[0].get('html');
                    if(a != b){
                        if($$(".tab-accordion-entry.active")[0].getElement('*[data-md-editable="md-content-editable-element"]').get('html') == 'Enter content (optional)'){
                            //$$(".tab-accordion-entry.active")[0].getElement('*[data-md-editable="md-content-editable-element"]').set('html', '');
                            $$(".tab-accordion-entry.active")[0].getElement('*[data-md-editable="md-content-editable-element"]').setStyle('color', '#969A97');
                            that.saveEntry($$(".tab-accordion-entry.active")[0]);
                            b = a;
                            //$$(".tab-accordion-entry.active")[0].getElement('*[data-md-editable="md-content-editable-element"]').set('html', 'Enter content (optional)');
                        }else{
                            $$(".tab-accordion-entry.active")[0].getElement('*[data-md-editable="md-content-editable-element"]').setStyle('color', '#000');
                            that.saveEntry($$(".tab-accordion-entry.active")[0]);
                            b = a;
                        }
                    }
                },500);
            }
        });

        $$('.tab-accordion-entry').each(function(el, index){
            if(el.getElement('*[data-md-editable="md-content-editable-element"]').get('html') == 'Enter content (optional)' || el.getElement('*[data-md-editable="md-content-editable-element"]').get('html') == ''){
                el.getElement('*[data-md-editable="md-content-editable-element"]').setStyle('color', '#969A97');
            }else{
                el.getElement('*[data-md-editable="md-content-editable-element"]').setStyle('color', '#000');
            }
        });

        this.bindHeadTabEvents();
    },
    addAnotherItemClickEventListener: function() {
        //md-data-set-item
        var that = this;
        var elements_created = 0;
        var total_elements = 2;

        // navigation tab and content
        that.saveRequestProcedure(null, {
            method: 'appendHtml',
            content_set:[
                {
                    target: '#tabs-content',
                    html: '<div class="tab-accordion-entry tab-content tab-ready" ><div class="data-md-editable md-data-set-item"><div contenteditable="true" data-md-editable="md-content-editable-element" class="data-md-editable"></div></div></div>'
                },
                {
                    target: '#tabs-nav',
                    html: '<div class="tab-title non-keyboard-outline" ><span>The Title</span></div>'
                }
            ]
        }, null, function(data) {
            window.location.reload();
        });
    },
    bindHeadTabEvents: function() {
        var that = this;

        $$('#tabs-nav > div,.tab-accordion-entry > .tab-entry-title').each(function(tab) {
            tab.getElement("span").set("contenteditable", "true");

            var intTimerID = null
            tab.getElement("span").addEvent("change", that.editorTabTitleChange.bind(that));
            // tab.getElement("span").addEvent("paste", that.editorTabTitleChange.bind(that));
            // tab.getElement("span").addEvent("keyup", function(e) {
            //     if (intTimerID != null) {
            //         clearTimeout(intTimerID);
            //     }
            //     intTimerID = setTimeout(function() {
            //         that.editorTabTitleChange(e);
            //     }, 500);
            // });

            if(tab.getElement('*[contenteditable="true"]')){
                var a = $$(tab)[0].get('html');
                var b = a;

                setInterval(function(){
                    a = $$(tab)[0].get('html');
                    if(a != b){
                        if($$('.tab-accordion-entry.active')[0].getElement('span').get('html') != 'The Title'){
                            that.saveEntry($$(".tab-accordion-entry.active")[0]);
                            b = a;
                        }
                    }
                },500);
            }

            tab.getElement(".delete").addEvent("click", function(e) {

                if(confirm("Do you want to delete this entry?")){
                    var ind_to_delete = $$('#tabs-nav > div').indexOf(tab);
                    if(that.widgetMode==1){
                        ind_to_delete = $$('.tab-accordion-entry').indexOf(tab.getParent());
                    }
                    that.saveRequestProcedure(null, {
                        method: 'removeBySelector',
                        content_set:[
                            "#tabs-nav .tab-title:eq("+ind_to_delete+")",
                            "#tabs-content .tab-content:eq("+ind_to_delete+")"
                        ]
                    }, null, function(data) {
                        window.location.reload();
                    });
                }


            });

            tab.addClass("tab-title-operations-bind");
        });
    },
    editorTabTitleChange: function(e) {

        //title or body change
        if (this.widgetMode == 0) {
            this.saveEntry($$(".tab-accordion-entry.active")[0]);
        } else {
            this.saveEntry(e.target.getParent(".tab-accordion-entry"));
        }
    },
    bindEvents: function() {
        if(!this.isEditMode)
            return;
        var that = this;
        $$(".header .tab-title:not(.processed)").each(function(e) {
            e.addEvent("click", that.changeTabClickEventListener.bind(that));
            e.addClass("processed");
        });

        $$("[data-md-editable='md-textfield']:not(.event-processed) input").each(function(e) {
            e.addEvent("change", that.changeTitleEventListener.bind(that));
            e.getParent().addClass("event-processed");
        });

        $$('[data-md-editable="md-placeholder-image"]').addEvent('click', function(e) {
            this.attachImage(e);
        }.bind(this));
        $$('[data-md-editable="md-placeholder-audio"]').addEvent('click', function(e) {
            this.attachAudio(e);
        }.bind(this));
        $$('[data-md-editable="md-placeholder-video"]').addEvent('click', function(e) {
            this.attachVideo(e);
        }.bind(this));

        // Create droppzones
        $$('[data-md-editable="md-placeholder-image"]').each(function(item, index) {
            item.ondragover = function(e) {
                item.addClass('dragover');
                return false;
            };
            item.ondragend = function(e) {
                item.removeClass('dragover');
                return false;
            };
            item.ondrop = function(e) {
                e.preventDefault();


                var extensions = ".jpg,.jpeg,.gif,.png";
                extensions = extensions.replace(/\./g, '');
                extensions = extensions.split(",");

                var flag_no_errors = false;

                Array.each(e.dataTransfer.files,function(value,key){
                    var can_be_added = false
                    extensions.each(function(ext,ind){
                        if (value.name.indexOf("."+ext)>0 || value.type.indexOf("/"+ext)>0)
                            can_be_added=true
                    })

                    if (can_be_added){
                        flag_no_errors=true;
                    }

                });

                if (!flag_no_errors){
                    alert("This field doesn't accept this file type. The file types accepted are .jpg,.jpeg,.gif,.png,.mp3,.mp4");
                    return;
                }

                if(parent && parent!=window) {
                    parent.postMessage({method:'files-begin-upload'},"*");
                }

                item.removeClass('dragover');
                that.uploadFile(e.dataTransfer.files, index);

                return false;
            };

        });

    },

    uploadFile: function(files, index) {
        var that = this;
        var formData = new FormData();
        var multimediaType = "image";
        var multimediaTypeFormat = "";
        for (var i = 0; i < files.length; i++) {
            if(files[i].type.indexOf("video")!=-1){
                multimediaType = "video";
            }
            multimediaTypeFormat = files[i].type;
            formData.append('file', files[i]);
        }

        var pathUpload = location.href;
        if(pathUpload.indexOf("?")>0){
            pathUpload = pathUpload.split("?")[0];
        }

        formData.append('path', pathUpload);
        formData.append('directory', 'images');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', this.root + 'api/index.php/upload/');
        xhr.onload = function () {

            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                var img_path = response.path;

                var imagepath,filepath;
                imagepath = filepath = 'images/' + response.filename;
                if(multimediaType=="video"){
                    imagepath="https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
                }

                if(parent && parent!=window) {
                    parent.postMessage({method:'files-end-upload'},"*");
                }

                that.saveImageFile(imagepath,index);
            } else {
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },


    attachImage: function(e) {
        var iframe_parent = window.parent;
        var that = this,
            el = e.target,
            parent = el.getParent('.tab-content'),
            index = parent.getParent().getChildren('.tab-content').indexOf(parent),
            have_content = el.getParent().get('data-md-placeholder-has-content');



        if(iframe_parent && iframe_parent!=window){
            iframe_parent.postMessage({
                method:"show-media-popup",
                media_type:"image",
                parent_index:index,
                have_content:have_content && have_content=="true"?true:false
            },"*");
        }
        else{
            var src = prompt('Please enter the image URL');
            if (!src || src.trim() == '') {
                return;
            }
            that.saveImageFile(src,index);
        }
    },
    attachAudio: function(e) {
        var iframe_parent = window.parent;
        var that = this,
            el = e.target,
            parent = el.getParent('.tab-content'),
            index = parent.getParent().getChildren('.tab-content').indexOf(parent),
            have_content = el.get('data-md-placeholder-has-content');



        if(iframe_parent && iframe_parent!=window){
            iframe_parent.postMessage({
                method:"show-media-popup",
                media_type:"audio",
                parent_index:index,
                have_content:have_content && have_content=="true"?true:false
            },"*");
        }
        else{
            var src = prompt('Please enter the audio URL');
            if (!src || src.trim() == '') {
                return;
            }
            that.saveAudioFile(src,index);
        }
    },
    attachVideo: function(e) {
        var iframe_parent = window.parent;
        var that = this,
            el = e.target,
            parent = el.getParent('.tab-content'),
            index = parent.getParent().getChildren('.tab-content').indexOf(parent),
            have_content = el.get('data-md-placeholder-has-content');


        if(iframe_parent && iframe_parent!=window){
            iframe_parent.postMessage({
                method:"show-media-popup",
                media_type:"video",
                parent_index:index,
                have_content:have_content && have_content=="true"?true:false
            },"*");
        }
        else{
            var src = prompt('Please enter the video URL');
            if (!src || src.trim() == '') {
                return;
            }
            that.saveVideoFile(src,index);
        }
    },
    changeTitleEventListener: function(e) {
        var ind = $$(".tab-accordion-entry").indexOf(e.event.currentTarget.getParents(".tab-accordion-entry")[0]);
        $$(".tab-title")[ind].getElement("span").set("html", e.event.currentTarget.get("value"));

        var accordionEntry = e.event.currentTarget.getParents(".tab-accordion-entry");
        this.saveEntry(accordionEntry[0]);
    },
    changeTabClickEventListener: function(e) {
        $$(".tab-accordion-entry").hide();
        this.container.getElements('.tab-accordion-entry').each(function (entry, index){
            entry.setAttribute('aria-hidden','true');
        });
        $$(".tab-title").removeClass("active");

        e.event.currentTarget.addClass("active");
        var contentIndex = $$(".tab-title").indexOf(e.event.currentTarget);
        var scrollX = window.scrollX;
        var scrollY = window.scrollY;

        $$(".tab-accordion-entry").removeClass("active");
        $$(".tab-accordion-entry")[contentIndex].addClass("active");
        $$(".tab-accordion-entry")[contentIndex].setAttribute('aria-hidden','false');
        $$(".tab-accordion-entry")[contentIndex].show();

        this.clearTimersOnUserInteraction(function (timers) {
            timers.push(setTimeout(function () {
                $$(".tab-accordion-entry")[contentIndex].set('tabindex', '-1').focus();
                window.scrollTo(scrollX, scrollY);
            }, 100));
        });

        this.stopAudios();

    },
    editorOnChangeEventListener: function(el, editorEvent) {
        var accordionEntry = el.targetElm.getParents(".tab-accordion-entry");
        this.saveEntry(accordionEntry[0]);
    },
    postMessageReceived: function(message) {
        var that = this;
        switch (message.data.method) {
            case "change-widget-mode":
                that.saveRequestProcedure(null, {
                    method: "attr",
                    selector: "#tabs",
                    attributes: {
                        "data-mode": message.data.widget_mode
                    }
                }, null, function() {
                    document.location.reload();
                });
                break;

            case "show-media-popup":

                switch(message.data.media_type){
                    case "image":
                    if(message.data.data.source_type!="computer")
                        that.saveImageFile(message.data.data.source_value,message.data.parent_index,message.data.data.source_type)
                    else
                        that.saveImageFile(message.data.data.source_relative,message.data.parent_index,message.data.data.source_type)
                    break;
                    case "audio":
                    if(message.data.data.source_type!="computer")
                        that.saveAudioFile(message.data.data.source_value,message.data.parent_index,message.data.data.source_type)
                    else
                        that.saveAudioFile(message.data.data.source_relative,message.data.parent_index,message.data.data.source_type)
                    break;
                    case "video":

                        if(message.data.data.source_type!="computer")
                            that.saveVideoFile(message.data.data.source_value,message.data.parent_index,message.data.data.source_type)
                        else
                            that.saveVideoFile(message.data.data.source_relative,message.data.parent_index,message.data.data.source_type)
                    break;
                }
                break;

            case "toggleHTML":
                that.saveRequestProcedure(null, {
                    method: "toggleHTML",
                    selector: message.data.wrapper,
                    elementID: message.data.elementID,
                    toggle: "" + message.data.value
                }, null, function() {
                    document.location.reload();
                });
                break;
        }
    },
    saveImageFile:function(src,index,action){
        var that = this;
        var iframe = '<img src="'+src+'"/>';
        var content = '.tab-accordion-entry.tab-content.tab-ready:nth-child(' + (index + 1) + ') div.data-md-editable.md-data-set-item';
        var have_content = $$('.tab-accordion-entry.tab-content.tab-ready')[index].getElement('.data-md-editable.md-data-set-item').getElement('[data-md-editable="md-placeholder-image"]').get('data-md-placeholder-has-content');
        if(action=="delete"){
            that.saveRequestProcedure(null, {
                method: 'rm',
                target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]'
            }, null, function(data) {
                that.saveRequestProcedure(null, {
                    method: 'attr',
                    selector: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]',
                    attributes:{
                        'data-md-placeholder-has-content':'false'
                    }
                }, null, function(data) {
                    window.location.reload();
                });
            });
            return;
        }

        var textContent = $$(content).getElement('[data-md-editable="md-content-editable-element"]').get('html');
        if(have_content && have_content=="true"){
            that.saveRequestProcedure(null, {
                method: 'rm',
                target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]'
            }, null, function(){
                that.saveRequestProcedure(null, {
                    method: 'appendHtml',
                    content_set:[
                        {
                            target: content,
                            html: '<div class="md-placeholder" data-md-placeholder-has-content="true" data-md-editable="md-placeholder-image"><span class="md-placeholder-caption"></span>' + iframe + '</div>'
                        }
                    ]
                }, null, function() {
                    that.saveRequestProcedure(null, {
                        method: 'rm',
                        target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-content-editable-element"]'
                    }, null, function(){
                        that.saveRequestProcedure(null, {
                            method: 'appendHtml',
                            content_set:[
                                {
                                    target: content,
                                    html: '<div contenteditable="true" data-md-editable="md-content-editable-element" class="data-md-editable">'+textContent+'</div>'
                                }
                            ]
                        }, null, function(data) {
                            window.location.reload();
                        });
                    });
                });
            });
        }else{
            that.saveRequestProcedure(null, {
                method: 'appendHtml',
                content_set:[
                    {
                        target: content,
                        html: '<div class="md-placeholder" data-md-placeholder-has-content="true" data-md-editable="md-placeholder-image"><span class="md-placeholder-caption"></span>' + iframe + '</div>'
                    }
                ]
            }, null, function() {
                that.saveRequestProcedure(null, {
                    method: 'rm',
                    target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-content-editable-element"]'
                }, null, function(){
                    that.saveRequestProcedure(null, {
                        method: 'appendHtml',
                        content_set:[
                            {
                                target: content,
                                html: '<div contenteditable="true" data-md-editable="md-content-editable-element" class="data-md-editable">'+textContent+'</div>'
                            }
                        ]
                    }, null, function(data) {
                        window.location.reload();
                    });
                });
            });
        }
    },
    saveAudioFile:function(src,index,action){
        var that = this;
        var iframe = '<iframe xmlns="http://www.w3.org/1999/xhtml" id="widget-edit-container-preview" name="vplayer1" class="__embedpearsonvideoplayer__" tabindex="-1" aria-hidden="true" src="' + src + '" allowfullscreen="yes" width="402" height="65" seamless="seamless" style="width: 402px; height: 65;">Loading&amp;hellip;</iframe>';
        var content = '.tab-accordion-entry.tab-content.tab-ready:nth-child(' + (index + 1) + ') div.data-md-editable.md-data-set-item';
        var have_content = $$('.tab-accordion-entry.tab-content.tab-ready')[index].getElement('.data-md-editable.md-data-set-item').getElement('[data-md-editable="md-placeholder-audio"]').get('data-md-placeholder-has-content');
        if(action=="delete"){
            that.saveRequestProcedure(null, {
                method: 'rm',
                target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-audio"]'
            }, null, function(data) {
                that.saveRequestProcedure(null, {
                    method: 'attr',
                    selector: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-audio"]',
                    attributes:{
                        'data-md-placeholder-has-content':'false'
                    }
                }, null, function(data) {
                    window.location.reload();
                });
            });
            return;
        }

        var textContent = $$(content).getElement('[data-md-editable="md-content-editable-element"]').get('html');
        if(have_content && have_content=="true"){
            that.saveRequestProcedure(null, {
                method: 'rm',
                target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-audio"]'
            }, null, function(){
                that.saveRequestProcedure(null, {
                    method: 'appendHtml',
                    content_set:[
                        {
                            target: content,
                            html: '<div class="md-placeholder" data-md-placeholder-has-content="true" data-md-editable="md-placeholder-audio"><span class="md-placeholder-caption">Click to place an audio</span>' + iframe + '</div>'
                        }
                    ]
                }, null, function() {
                    that.saveRequestProcedure(null, {
                        method: 'rm',
                        target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-content-editable-element"]'
                    }, null, function(){
                        that.saveRequestProcedure(null, {
                            method: 'appendHtml',
                            content_set:[
                                {
                                    target: content,
                                    html: '<div contenteditable="true" data-md-editable="md-content-editable-element" class="data-md-editable">'+textContent+'</div>'
                                }
                            ]
                        }, null, function(data) {
                            window.location.reload();
                        });
                    });
                });
            });
        }else{
            that.saveRequestProcedure(null, {
                method: 'appendHtml',
                content_set:[
                    {
                        target: content,
                        html: '<div class="md-placeholder" data-md-placeholder-has-content="true" data-md-editable="md-placeholder-audio"><span class="md-placeholder-caption">Click to place an audio</span>' + iframe + '</div>'
                    }
                ]
            }, null, function() {
                that.saveRequestProcedure(null, {
                    method: 'rm',
                    target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-content-editable-element"]'
                }, null, function(){
                    that.saveRequestProcedure(null, {
                        method: 'appendHtml',
                        content_set:[
                            {
                                target: content,
                                html: '<div contenteditable="true" data-md-editable="md-content-editable-element" class="data-md-editable">'+textContent+'</div>'
                            }
                        ]
                    }, null, function(data) {
                        window.location.reload();
                    });
                });
            });
        }
    },
    saveVideoFile:function(src,index,action){
        var that = this;
        var iframe = '<iframe xmlns="http://www.w3.org/1999/xhtml" id="widget-edit-container-preview" name="vplayer1" class="__embedpearsonvideoplayer__" tabindex="-1" aria-hidden="true" src="' + src + '" allowfullscreen="yes" width="400" height="280" seamless="seamless" style="width: 400px; height:280px;">Loading&amp;hellip;</iframe>';
        var content = '.tab-accordion-entry.tab-content.tab-ready:nth-child(' + (index + 1) + ') div.data-md-editable.md-data-set-item';
        var have_content = $$('.tab-accordion-entry.tab-content.tab-ready')[index].getElement('.data-md-editable.md-data-set-item').getElement('[data-md-editable="md-placeholder-video"]').get('data-md-placeholder-has-content');
        if(action=="delete"){
            that.saveRequestProcedure(null, {
                method: 'rm',
                target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-video"]'
            }, null, function(data) {
                that.saveRequestProcedure(null, {
                    method: 'attr',
                    selector: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-video"]',
                    attributes:{
                        'data-md-placeholder-has-content':'false'
                    }
                }, null, function(data) {
                    window.location.reload();
                });
            });
            return;
        }

        var textContent = $$(content).getElement('[data-md-editable="md-content-editable-element"]').get('html');
        if(have_content && have_content=="true"){
            that.saveRequestProcedure(null, {
                method: 'rm',
                target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-video"]'
            }, null, function(){
                that.saveRequestProcedure(null, {
                    method: 'appendHtml',
                    content_set:[
                        {
                            target: content,
                            html: '<div class="md-placeholder" data-md-placeholder-has-content="true" data-md-editable="md-placeholder-video"><span class="md-placeholder-caption">Click to place a video</span>' + iframe + '</div>'
                        }
                    ]
                }, null, function(data) {
                    that.saveRequestProcedure(null, {
                        method: 'rm',
                        target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-content-editable-element"]'
                    }, null, function(){
                        that.saveRequestProcedure(null, {
                            method: 'appendHtml',
                            content_set:[
                                {
                                    target: content,
                                    html: '<div contenteditable="true" data-md-editable="md-content-editable-element" class="data-md-editable">'+textContent+'</div>'
                                }
                            ]
                        }, null, function(data) {
                            window.location.reload();
                        });
                    });
                });
            });
        }else{
            that.saveRequestProcedure(null, {
                method: 'appendHtml',
                content_set:[
                    {
                        target: content,
                        html: '<div class="md-placeholder" data-md-placeholder-has-content="true" data-md-editable="md-placeholder-video"><span class="md-placeholder-caption">Click to place a video</span>' + iframe + '</div>'
                    }
                ]
            }, null, function(data) {
                that.saveRequestProcedure(null, {
                    method: 'rm',
                    target: '.tab-content:nth-child(' + (index + 1) + ') [data-md-editable="md-content-editable-element"]'
                }, null, function(){
                    that.saveRequestProcedure(null, {
                        method: 'appendHtml',
                        content_set:[
                            {
                                target: content,
                                html: '<div contenteditable="true" data-md-editable="md-content-editable-element" class="data-md-editable">'+textContent+'</div>'
                            }
                        ]
                    }, null, function(data) {
                        window.location.reload();
                    });
                });
            });
        }
    },
    saveEntry: function(entry) {
        var ind = $$(".tab-accordion-entry").indexOf(entry);
        var title = "";
        if (this.widgetMode == 0) {
            title = $$(".tab-title.active span")[0].get("html");
        }else{
            title = entry.getElement(".tab-entry-title span").get("html");
        }

        var body = entry.getElement('.data-md-editable [data-md-editable="md-content-editable-element"]').get("html");
        this.saveRequestProcedure(this.options.container, {
            method: "setHTML",
            content_set:[
                {
                    selector:"#tabs-nav .tab-title:eq("+ind+") span",
                    html:title.trim()
                },
                {
                    selector:"#tabs-content .tab-content:eq("+ind+") .data-md-editable [data-md-editable='md-content-editable-element']",
                    html:body.trim()
                }
            ]
        });
    },
    render: function() {

    },
    customResize: function() {
        var _this = this;
        var w_size = $$('.widget-content.smartwidget-tabs')[0].getSize();
        var height = 0;

        if($$('.MetrodigiWidget.container .widget-footer')[0]){
            $$('.MetrodigiWidget.container .widget-footer')[0].hide();
        }

        setInterval(function(){ // NOTE from Aaron: This method was causing the accordian in Kenrick Ch12_sec_13.xhtml to jump like crazy.
            w_size = $$('.widget-content.smartwidget-tabs')[0].getSize();
            if(height != w_size.y){
                height = w_size.y;
                $$('.MetrodigiWidget.container').setStyle('height', height + 'px');
                var w_name = location.toString().split("/")[location.toString().split("/").length-2]

                /***************
                 * This code is officially quarantined!
                 *   This code appears to be collecting an array of iframes from the parent document,
                 *   then parsing the 'src' for each iframe,
                 *   and, if the src contains "w_name", expanding the height by +20px
                 *   and setting the bottom margin to 1em.
                 *
                 * I'm replacing that with a call to "this.frameElement" to get the target <iframe>
                 * and change the height that way.

                var elems = window.parent.document.getElementsByTagName('iframe');
                $$(elems).each(function(e){
                    try{
                        var src = e.get('src');
                        if(src.contains(w_name)){
                            e.set('height', height + 20);
                            e.setStyle('margin-bottom', '1em')
                        }
                    }catch(er){}
                });

                 **************/
                var elems = this.frameElement;
                (function(elems){
                    try{
                        var src = elems.get('src');
                        if(src.contains(w_name)){
                            elems.set('height', height + 30);
                            elems.setStyle('margin-bottom', '1em')
                        }
                    }
                    catch(er){}
                })(); // immediately invoke anonymous function
            }
        }, 100);
    },
    stopAudios: function(){
      if( $$('audio').length > 0 ){
        $$('audio').forEach(function(audio){
          audio.pause();
        });
      }

      if( $$('video').length > 0 ){
        $$('video').forEach(function(audio){
          audio.pause();
        });
      }
    }
});
